# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetVendorResult',
    'AwaitableGetVendorResult',
    'get_vendor',
    'get_vendor_output',
]

@pulumi.output_type
class GetVendorResult:
    """
    A collection of values returned by getVendor.
    """
    def __init__(__self__, id=None, name=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the found vendor.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The short name of the found vendor.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The generic service type for this vendor.
        """
        return pulumi.get(self, "type")


class AwaitableGetVendorResult(GetVendorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVendorResult(
            id=self.id,
            name=self.name,
            type=self.type)


def get_vendor(name: Optional[builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVendorResult:
    """
    Use this data source to get information about a specific [vendor](https://developer.pagerduty.com/api-reference/b3A6Mjc0ODI1OQ-list-vendors) that you can use for a service integration (e.g. Amazon Cloudwatch, Splunk, Datadog).

    > For the case of vendors that rely on [Change Events](https://support.pagerduty.com/docs/change-events) (e.g. Jekings CI, Github, Gitlab, ...) is important to know that those vendors are only available with [PagerDuty AIOps](https://support.pagerduty.com/docs/aiops) add-on. Therefore, they won't be accessible as result of `get_vendor` data source without the proper entitlements.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_pagerduty as pagerduty

    datadog = pagerduty.get_vendor(name="Datadog")
    example = pagerduty.User("example",
        name="Earline Greenholt",
        email="125.greenholt.earline@graham.name",
        teams=[example_pagerduty_team["id"]])
    foo = pagerduty.EscalationPolicy("foo",
        name="Engineering Escalation Policy",
        num_loops=2,
        rules=[{
            "escalation_delay_in_minutes": 10,
            "targets": [{
                "type": "user",
                "id": example.id,
            }],
        }])
    example_service = pagerduty.Service("example",
        name="My Web App",
        auto_resolve_timeout="14400",
        acknowledgement_timeout="600",
        escalation_policy=example_pagerduty_escalation_policy["id"])
    example_service_integration = pagerduty.ServiceIntegration("example",
        name="Datadog Integration",
        vendor=datadog.id,
        service=example_service.id)
    ```


    :param builtins.str name: The vendor name to use to find a vendor in the PagerDuty API.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('pagerduty:index/getVendor:getVendor', __args__, opts=opts, typ=GetVendorResult).value

    return AwaitableGetVendorResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        type=pulumi.get(__ret__, 'type'))
def get_vendor_output(name: Optional[pulumi.Input[builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVendorResult]:
    """
    Use this data source to get information about a specific [vendor](https://developer.pagerduty.com/api-reference/b3A6Mjc0ODI1OQ-list-vendors) that you can use for a service integration (e.g. Amazon Cloudwatch, Splunk, Datadog).

    > For the case of vendors that rely on [Change Events](https://support.pagerduty.com/docs/change-events) (e.g. Jekings CI, Github, Gitlab, ...) is important to know that those vendors are only available with [PagerDuty AIOps](https://support.pagerduty.com/docs/aiops) add-on. Therefore, they won't be accessible as result of `get_vendor` data source without the proper entitlements.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_pagerduty as pagerduty

    datadog = pagerduty.get_vendor(name="Datadog")
    example = pagerduty.User("example",
        name="Earline Greenholt",
        email="125.greenholt.earline@graham.name",
        teams=[example_pagerduty_team["id"]])
    foo = pagerduty.EscalationPolicy("foo",
        name="Engineering Escalation Policy",
        num_loops=2,
        rules=[{
            "escalation_delay_in_minutes": 10,
            "targets": [{
                "type": "user",
                "id": example.id,
            }],
        }])
    example_service = pagerduty.Service("example",
        name="My Web App",
        auto_resolve_timeout="14400",
        acknowledgement_timeout="600",
        escalation_policy=example_pagerduty_escalation_policy["id"])
    example_service_integration = pagerduty.ServiceIntegration("example",
        name="Datadog Integration",
        vendor=datadog.id,
        service=example_service.id)
    ```


    :param builtins.str name: The vendor name to use to find a vendor in the PagerDuty API.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('pagerduty:index/getVendor:getVendor', __args__, opts=opts, typ=GetVendorResult)
    return __ret__.apply(lambda __response__: GetVendorResult(
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        type=pulumi.get(__response__, 'type')))
