# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[builtins.str],
                 color: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 job_title: Optional[pulumi.Input[builtins.str]] = None,
                 license: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[builtins.str] email: The user's email address.
        :param pulumi.Input[builtins.str] color: The schedule color for the user. Valid options are purple, red, green, blue, teal, orange, brown, turquoise, dark-slate-blue, cayenne, orange-red, dark-orchid, dark-slate-grey, lime, dark-magenta, lime-green, midnight-blue, deep-pink, dark-green, dark-orange, dark-cyan, darkolive-green, dark-slate-gray, grey20, firebrick, maroon, crimson, dark-red, dark-goldenrod, chocolate, medium-violet-red, sea-green, olivedrab, forest-green, dark-olive-green, blue-violet, royal-blue, indigo, slate-blue, saddle-brown, or steel-blue.
        :param pulumi.Input[builtins.str] description: A human-friendly description of the user.
               If not set, a placeholder of "Managed by Pulumi" will be set.
        :param pulumi.Input[builtins.str] job_title: The user's title.
        :param pulumi.Input[builtins.str] license: The license id assigned to the user. If provided the user's role must exist in the assigned license's `valid_roles` list. To reference purchased licenses' ids see data source `get_licenses` [data source](https://developer.pagerduty.com/api-reference/b3A6Mjc0ODIzNA-create-a-user).
        :param pulumi.Input[builtins.str] name: The name of the user.
        :param pulumi.Input[builtins.str] role: The user role. Can be `admin`, `limited_user`, `observer`, `owner`, `read_only_user`, `read_only_limited_user`, `restricted_access`, or `user`.
               Notes:
               * Account must have the `read_only_users` ability to set a user as a `read_only_user` or a `read_only_limited_user`, and must have advanced permissions abilities to set a user as `observer` or `restricted_access`.
               * With advanced permissions, users can have both a user role (base role) and a team role. The team role can be configured in the `TeamMembership` resource.
               * Mapping of `role` values to Web UI user role names available in the [user roles support page](https://support.pagerduty.com/docs/advanced-permissions#roles-in-the-rest-api-and-saml).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] teams: A list of teams the user should belong to. Please use `TeamMembership` instead.
        :param pulumi.Input[builtins.str] time_zone: The time zone of the user. Default is account default timezone.
        """
        pulumi.set(__self__, "email", email)
        if color is not None:
            pulumi.set(__self__, "color", color)
        if description is None:
            description = 'Managed by Pulumi'
        if description is not None:
            pulumi.set(__self__, "description", description)
        if job_title is not None:
            pulumi.set(__self__, "job_title", job_title)
        if license is not None:
            pulumi.set(__self__, "license", license)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if teams is not None:
            warnings.warn("""Use the 'pagerduty_team_membership' resource instead.""", DeprecationWarning)
            pulumi.log.warn("""teams is deprecated: Use the 'pagerduty_team_membership' resource instead.""")
        if teams is not None:
            pulumi.set(__self__, "teams", teams)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[builtins.str]:
        """
        The user's email address.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def color(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The schedule color for the user. Valid options are purple, red, green, blue, teal, orange, brown, turquoise, dark-slate-blue, cayenne, orange-red, dark-orchid, dark-slate-grey, lime, dark-magenta, lime-green, midnight-blue, deep-pink, dark-green, dark-orange, dark-cyan, darkolive-green, dark-slate-gray, grey20, firebrick, maroon, crimson, dark-red, dark-goldenrod, chocolate, medium-violet-red, sea-green, olivedrab, forest-green, dark-olive-green, blue-violet, royal-blue, indigo, slate-blue, saddle-brown, or steel-blue.
        """
        return pulumi.get(self, "color")

    @color.setter
    def color(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "color", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-friendly description of the user.
        If not set, a placeholder of "Managed by Pulumi" will be set.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="jobTitle")
    def job_title(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user's title.
        """
        return pulumi.get(self, "job_title")

    @job_title.setter
    def job_title(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "job_title", value)

    @property
    @pulumi.getter
    def license(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The license id assigned to the user. If provided the user's role must exist in the assigned license's `valid_roles` list. To reference purchased licenses' ids see data source `get_licenses` [data source](https://developer.pagerduty.com/api-reference/b3A6Mjc0ODIzNA-create-a-user).
        """
        return pulumi.get(self, "license")

    @license.setter
    def license(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "license", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user role. Can be `admin`, `limited_user`, `observer`, `owner`, `read_only_user`, `read_only_limited_user`, `restricted_access`, or `user`.
        Notes:
        * Account must have the `read_only_users` ability to set a user as a `read_only_user` or a `read_only_limited_user`, and must have advanced permissions abilities to set a user as `observer` or `restricted_access`.
        * With advanced permissions, users can have both a user role (base role) and a team role. The team role can be configured in the `TeamMembership` resource.
        * Mapping of `role` values to Web UI user role names available in the [user roles support page](https://support.pagerduty.com/docs/advanced-permissions#roles-in-the-rest-api-and-saml).
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""Use the 'pagerduty_team_membership' resource instead.""")
    def teams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of teams the user should belong to. Please use `TeamMembership` instead.
        """
        return pulumi.get(self, "teams")

    @teams.setter
    def teams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "teams", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time zone of the user. Default is account default timezone.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 avatar_url: Optional[pulumi.Input[builtins.str]] = None,
                 color: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 html_url: Optional[pulumi.Input[builtins.str]] = None,
                 invitation_sent: Optional[pulumi.Input[builtins.bool]] = None,
                 job_title: Optional[pulumi.Input[builtins.str]] = None,
                 license: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[builtins.str] avatar_url: The URL of the user's avatar.
        :param pulumi.Input[builtins.str] color: The schedule color for the user. Valid options are purple, red, green, blue, teal, orange, brown, turquoise, dark-slate-blue, cayenne, orange-red, dark-orchid, dark-slate-grey, lime, dark-magenta, lime-green, midnight-blue, deep-pink, dark-green, dark-orange, dark-cyan, darkolive-green, dark-slate-gray, grey20, firebrick, maroon, crimson, dark-red, dark-goldenrod, chocolate, medium-violet-red, sea-green, olivedrab, forest-green, dark-olive-green, blue-violet, royal-blue, indigo, slate-blue, saddle-brown, or steel-blue.
        :param pulumi.Input[builtins.str] description: A human-friendly description of the user.
               If not set, a placeholder of "Managed by Pulumi" will be set.
        :param pulumi.Input[builtins.str] email: The user's email address.
        :param pulumi.Input[builtins.str] html_url: URL at which the entity is uniquely displayed in the Web app
        :param pulumi.Input[builtins.bool] invitation_sent: If true, the user has an outstanding invitation.
        :param pulumi.Input[builtins.str] job_title: The user's title.
        :param pulumi.Input[builtins.str] license: The license id assigned to the user. If provided the user's role must exist in the assigned license's `valid_roles` list. To reference purchased licenses' ids see data source `get_licenses` [data source](https://developer.pagerduty.com/api-reference/b3A6Mjc0ODIzNA-create-a-user).
        :param pulumi.Input[builtins.str] name: The name of the user.
        :param pulumi.Input[builtins.str] role: The user role. Can be `admin`, `limited_user`, `observer`, `owner`, `read_only_user`, `read_only_limited_user`, `restricted_access`, or `user`.
               Notes:
               * Account must have the `read_only_users` ability to set a user as a `read_only_user` or a `read_only_limited_user`, and must have advanced permissions abilities to set a user as `observer` or `restricted_access`.
               * With advanced permissions, users can have both a user role (base role) and a team role. The team role can be configured in the `TeamMembership` resource.
               * Mapping of `role` values to Web UI user role names available in the [user roles support page](https://support.pagerduty.com/docs/advanced-permissions#roles-in-the-rest-api-and-saml).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] teams: A list of teams the user should belong to. Please use `TeamMembership` instead.
        :param pulumi.Input[builtins.str] time_zone: The time zone of the user. Default is account default timezone.
        """
        if avatar_url is not None:
            pulumi.set(__self__, "avatar_url", avatar_url)
        if color is not None:
            pulumi.set(__self__, "color", color)
        if description is None:
            description = 'Managed by Pulumi'
        if description is not None:
            pulumi.set(__self__, "description", description)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if html_url is not None:
            pulumi.set(__self__, "html_url", html_url)
        if invitation_sent is not None:
            pulumi.set(__self__, "invitation_sent", invitation_sent)
        if job_title is not None:
            pulumi.set(__self__, "job_title", job_title)
        if license is not None:
            pulumi.set(__self__, "license", license)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if teams is not None:
            warnings.warn("""Use the 'pagerduty_team_membership' resource instead.""", DeprecationWarning)
            pulumi.log.warn("""teams is deprecated: Use the 'pagerduty_team_membership' resource instead.""")
        if teams is not None:
            pulumi.set(__self__, "teams", teams)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="avatarUrl")
    def avatar_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of the user's avatar.
        """
        return pulumi.get(self, "avatar_url")

    @avatar_url.setter
    def avatar_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "avatar_url", value)

    @property
    @pulumi.getter
    def color(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The schedule color for the user. Valid options are purple, red, green, blue, teal, orange, brown, turquoise, dark-slate-blue, cayenne, orange-red, dark-orchid, dark-slate-grey, lime, dark-magenta, lime-green, midnight-blue, deep-pink, dark-green, dark-orange, dark-cyan, darkolive-green, dark-slate-gray, grey20, firebrick, maroon, crimson, dark-red, dark-goldenrod, chocolate, medium-violet-red, sea-green, olivedrab, forest-green, dark-olive-green, blue-violet, royal-blue, indigo, slate-blue, saddle-brown, or steel-blue.
        """
        return pulumi.get(self, "color")

    @color.setter
    def color(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "color", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-friendly description of the user.
        If not set, a placeholder of "Managed by Pulumi" will be set.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user's email address.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="htmlUrl")
    def html_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL at which the entity is uniquely displayed in the Web app
        """
        return pulumi.get(self, "html_url")

    @html_url.setter
    def html_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "html_url", value)

    @property
    @pulumi.getter(name="invitationSent")
    def invitation_sent(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the user has an outstanding invitation.
        """
        return pulumi.get(self, "invitation_sent")

    @invitation_sent.setter
    def invitation_sent(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "invitation_sent", value)

    @property
    @pulumi.getter(name="jobTitle")
    def job_title(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user's title.
        """
        return pulumi.get(self, "job_title")

    @job_title.setter
    def job_title(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "job_title", value)

    @property
    @pulumi.getter
    def license(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The license id assigned to the user. If provided the user's role must exist in the assigned license's `valid_roles` list. To reference purchased licenses' ids see data source `get_licenses` [data source](https://developer.pagerduty.com/api-reference/b3A6Mjc0ODIzNA-create-a-user).
        """
        return pulumi.get(self, "license")

    @license.setter
    def license(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "license", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user role. Can be `admin`, `limited_user`, `observer`, `owner`, `read_only_user`, `read_only_limited_user`, `restricted_access`, or `user`.
        Notes:
        * Account must have the `read_only_users` ability to set a user as a `read_only_user` or a `read_only_limited_user`, and must have advanced permissions abilities to set a user as `observer` or `restricted_access`.
        * With advanced permissions, users can have both a user role (base role) and a team role. The team role can be configured in the `TeamMembership` resource.
        * Mapping of `role` values to Web UI user role names available in the [user roles support page](https://support.pagerduty.com/docs/advanced-permissions#roles-in-the-rest-api-and-saml).
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""Use the 'pagerduty_team_membership' resource instead.""")
    def teams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of teams the user should belong to. Please use `TeamMembership` instead.
        """
        return pulumi.get(self, "teams")

    @teams.setter
    def teams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "teams", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time zone of the user. Default is account default timezone.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.type_token("pagerduty:index/user:User")
class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 color: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 job_title: Optional[pulumi.Input[builtins.str]] = None,
                 license: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A [user](https://developer.pagerduty.com/api-reference/b3A6Mjc0ODIzNA-create-a-user) is a member of a PagerDuty account that have the ability to interact with incidents and other data on the account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_pagerduty as pagerduty

        example = pagerduty.User("example",
            name="Earline Greenholt",
            email="125.greenholt.earline@graham.name")
        ```

        ## Import

        Users can be imported using the `id`, e.g.

        ```sh
        $ pulumi import pagerduty:index/user:User main PLBP09X
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] color: The schedule color for the user. Valid options are purple, red, green, blue, teal, orange, brown, turquoise, dark-slate-blue, cayenne, orange-red, dark-orchid, dark-slate-grey, lime, dark-magenta, lime-green, midnight-blue, deep-pink, dark-green, dark-orange, dark-cyan, darkolive-green, dark-slate-gray, grey20, firebrick, maroon, crimson, dark-red, dark-goldenrod, chocolate, medium-violet-red, sea-green, olivedrab, forest-green, dark-olive-green, blue-violet, royal-blue, indigo, slate-blue, saddle-brown, or steel-blue.
        :param pulumi.Input[builtins.str] description: A human-friendly description of the user.
               If not set, a placeholder of "Managed by Pulumi" will be set.
        :param pulumi.Input[builtins.str] email: The user's email address.
        :param pulumi.Input[builtins.str] job_title: The user's title.
        :param pulumi.Input[builtins.str] license: The license id assigned to the user. If provided the user's role must exist in the assigned license's `valid_roles` list. To reference purchased licenses' ids see data source `get_licenses` [data source](https://developer.pagerduty.com/api-reference/b3A6Mjc0ODIzNA-create-a-user).
        :param pulumi.Input[builtins.str] name: The name of the user.
        :param pulumi.Input[builtins.str] role: The user role. Can be `admin`, `limited_user`, `observer`, `owner`, `read_only_user`, `read_only_limited_user`, `restricted_access`, or `user`.
               Notes:
               * Account must have the `read_only_users` ability to set a user as a `read_only_user` or a `read_only_limited_user`, and must have advanced permissions abilities to set a user as `observer` or `restricted_access`.
               * With advanced permissions, users can have both a user role (base role) and a team role. The team role can be configured in the `TeamMembership` resource.
               * Mapping of `role` values to Web UI user role names available in the [user roles support page](https://support.pagerduty.com/docs/advanced-permissions#roles-in-the-rest-api-and-saml).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] teams: A list of teams the user should belong to. Please use `TeamMembership` instead.
        :param pulumi.Input[builtins.str] time_zone: The time zone of the user. Default is account default timezone.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A [user](https://developer.pagerduty.com/api-reference/b3A6Mjc0ODIzNA-create-a-user) is a member of a PagerDuty account that have the ability to interact with incidents and other data on the account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_pagerduty as pagerduty

        example = pagerduty.User("example",
            name="Earline Greenholt",
            email="125.greenholt.earline@graham.name")
        ```

        ## Import

        Users can be imported using the `id`, e.g.

        ```sh
        $ pulumi import pagerduty:index/user:User main PLBP09X
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 color: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 job_title: Optional[pulumi.Input[builtins.str]] = None,
                 license: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["color"] = color
            if description is None:
                description = 'Managed by Pulumi'
            __props__.__dict__["description"] = description
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            __props__.__dict__["job_title"] = job_title
            __props__.__dict__["license"] = license
            __props__.__dict__["name"] = name
            __props__.__dict__["role"] = role
            __props__.__dict__["teams"] = teams
            __props__.__dict__["time_zone"] = time_zone
            __props__.__dict__["avatar_url"] = None
            __props__.__dict__["html_url"] = None
            __props__.__dict__["invitation_sent"] = None
        super(User, __self__).__init__(
            'pagerduty:index/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            avatar_url: Optional[pulumi.Input[builtins.str]] = None,
            color: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            email: Optional[pulumi.Input[builtins.str]] = None,
            html_url: Optional[pulumi.Input[builtins.str]] = None,
            invitation_sent: Optional[pulumi.Input[builtins.bool]] = None,
            job_title: Optional[pulumi.Input[builtins.str]] = None,
            license: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            role: Optional[pulumi.Input[builtins.str]] = None,
            teams: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            time_zone: Optional[pulumi.Input[builtins.str]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] avatar_url: The URL of the user's avatar.
        :param pulumi.Input[builtins.str] color: The schedule color for the user. Valid options are purple, red, green, blue, teal, orange, brown, turquoise, dark-slate-blue, cayenne, orange-red, dark-orchid, dark-slate-grey, lime, dark-magenta, lime-green, midnight-blue, deep-pink, dark-green, dark-orange, dark-cyan, darkolive-green, dark-slate-gray, grey20, firebrick, maroon, crimson, dark-red, dark-goldenrod, chocolate, medium-violet-red, sea-green, olivedrab, forest-green, dark-olive-green, blue-violet, royal-blue, indigo, slate-blue, saddle-brown, or steel-blue.
        :param pulumi.Input[builtins.str] description: A human-friendly description of the user.
               If not set, a placeholder of "Managed by Pulumi" will be set.
        :param pulumi.Input[builtins.str] email: The user's email address.
        :param pulumi.Input[builtins.str] html_url: URL at which the entity is uniquely displayed in the Web app
        :param pulumi.Input[builtins.bool] invitation_sent: If true, the user has an outstanding invitation.
        :param pulumi.Input[builtins.str] job_title: The user's title.
        :param pulumi.Input[builtins.str] license: The license id assigned to the user. If provided the user's role must exist in the assigned license's `valid_roles` list. To reference purchased licenses' ids see data source `get_licenses` [data source](https://developer.pagerduty.com/api-reference/b3A6Mjc0ODIzNA-create-a-user).
        :param pulumi.Input[builtins.str] name: The name of the user.
        :param pulumi.Input[builtins.str] role: The user role. Can be `admin`, `limited_user`, `observer`, `owner`, `read_only_user`, `read_only_limited_user`, `restricted_access`, or `user`.
               Notes:
               * Account must have the `read_only_users` ability to set a user as a `read_only_user` or a `read_only_limited_user`, and must have advanced permissions abilities to set a user as `observer` or `restricted_access`.
               * With advanced permissions, users can have both a user role (base role) and a team role. The team role can be configured in the `TeamMembership` resource.
               * Mapping of `role` values to Web UI user role names available in the [user roles support page](https://support.pagerduty.com/docs/advanced-permissions#roles-in-the-rest-api-and-saml).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] teams: A list of teams the user should belong to. Please use `TeamMembership` instead.
        :param pulumi.Input[builtins.str] time_zone: The time zone of the user. Default is account default timezone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["avatar_url"] = avatar_url
        __props__.__dict__["color"] = color
        __props__.__dict__["description"] = description
        __props__.__dict__["email"] = email
        __props__.__dict__["html_url"] = html_url
        __props__.__dict__["invitation_sent"] = invitation_sent
        __props__.__dict__["job_title"] = job_title
        __props__.__dict__["license"] = license
        __props__.__dict__["name"] = name
        __props__.__dict__["role"] = role
        __props__.__dict__["teams"] = teams
        __props__.__dict__["time_zone"] = time_zone
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="avatarUrl")
    def avatar_url(self) -> pulumi.Output[builtins.str]:
        """
        The URL of the user's avatar.
        """
        return pulumi.get(self, "avatar_url")

    @property
    @pulumi.getter
    def color(self) -> pulumi.Output[builtins.str]:
        """
        The schedule color for the user. Valid options are purple, red, green, blue, teal, orange, brown, turquoise, dark-slate-blue, cayenne, orange-red, dark-orchid, dark-slate-grey, lime, dark-magenta, lime-green, midnight-blue, deep-pink, dark-green, dark-orange, dark-cyan, darkolive-green, dark-slate-gray, grey20, firebrick, maroon, crimson, dark-red, dark-goldenrod, chocolate, medium-violet-red, sea-green, olivedrab, forest-green, dark-olive-green, blue-violet, royal-blue, indigo, slate-blue, saddle-brown, or steel-blue.
        """
        return pulumi.get(self, "color")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        A human-friendly description of the user.
        If not set, a placeholder of "Managed by Pulumi" will be set.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[builtins.str]:
        """
        The user's email address.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="htmlUrl")
    def html_url(self) -> pulumi.Output[builtins.str]:
        """
        URL at which the entity is uniquely displayed in the Web app
        """
        return pulumi.get(self, "html_url")

    @property
    @pulumi.getter(name="invitationSent")
    def invitation_sent(self) -> pulumi.Output[builtins.bool]:
        """
        If true, the user has an outstanding invitation.
        """
        return pulumi.get(self, "invitation_sent")

    @property
    @pulumi.getter(name="jobTitle")
    def job_title(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The user's title.
        """
        return pulumi.get(self, "job_title")

    @property
    @pulumi.getter
    def license(self) -> pulumi.Output[builtins.str]:
        """
        The license id assigned to the user. If provided the user's role must exist in the assigned license's `valid_roles` list. To reference purchased licenses' ids see data source `get_licenses` [data source](https://developer.pagerduty.com/api-reference/b3A6Mjc0ODIzNA-create-a-user).
        """
        return pulumi.get(self, "license")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The user role. Can be `admin`, `limited_user`, `observer`, `owner`, `read_only_user`, `read_only_limited_user`, `restricted_access`, or `user`.
        Notes:
        * Account must have the `read_only_users` ability to set a user as a `read_only_user` or a `read_only_limited_user`, and must have advanced permissions abilities to set a user as `observer` or `restricted_access`.
        * With advanced permissions, users can have both a user role (base role) and a team role. The team role can be configured in the `TeamMembership` resource.
        * Mapping of `role` values to Web UI user role names available in the [user roles support page](https://support.pagerduty.com/docs/advanced-permissions#roles-in-the-rest-api-and-saml).
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Use the 'pagerduty_team_membership' resource instead.""")
    def teams(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of teams the user should belong to. Please use `TeamMembership` instead.
        """
        return pulumi.get(self, "teams")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[builtins.str]:
        """
        The time zone of the user. Default is account default timezone.
        """
        return pulumi.get(self, "time_zone")

