# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CheckBusinessHoursArgs', 'CheckBusinessHours']

@pulumi.input_type
class CheckBusinessHoursArgs:
    def __init__(__self__, *,
                 end_time: pulumi.Input[builtins.str],
                 project_id: pulumi.Input[builtins.str],
                 start_time: pulumi.Input[builtins.str],
                 target_resource_id: pulumi.Input[builtins.str],
                 target_resource_type: pulumi.Input[builtins.str],
                 time_zone: pulumi.Input[builtins.str],
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 friday: Optional[pulumi.Input[builtins.bool]] = None,
                 monday: Optional[pulumi.Input[builtins.bool]] = None,
                 saturday: Optional[pulumi.Input[builtins.bool]] = None,
                 sunday: Optional[pulumi.Input[builtins.bool]] = None,
                 thursday: Optional[pulumi.Input[builtins.bool]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 tuesday: Optional[pulumi.Input[builtins.bool]] = None,
                 wednesday: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a CheckBusinessHours resource.
        :param pulumi.Input[builtins.str] end_time: The end of the time period that this check will be allowed to pass, specified as 24-hour time with leading zeros.
        :param pulumi.Input[builtins.str] project_id: The project ID.
        :param pulumi.Input[builtins.str] start_time: The beginning of the time period that this check will be allowed to pass, specified as 24-hour time with leading zeros.
        :param pulumi.Input[builtins.str] target_resource_id: The ID of the resource being protected by the check.
        :param pulumi.Input[builtins.str] target_resource_type: The type of resource being protected by the check. Possible values are: `endpoint`, `environment`, `queue`, `repository`, `securefile`, `variablegroup`.
        :param pulumi.Input[builtins.str] time_zone: The time zone this check will be evaluated in. See below for supported values.
        :param pulumi.Input[builtins.str] display_name: The name of the business hours check displayed in the web UI.
        :param pulumi.Input[builtins.bool] friday: This check will pass on Fridays. Defaults to `false`.
        :param pulumi.Input[builtins.bool] monday: This check will pass on Mondays. Defaults to `false`.
        :param pulumi.Input[builtins.bool] saturday: This check will pass on Saturdays. Defaults to `false`.
        :param pulumi.Input[builtins.bool] sunday: This check will pass on Sundays. Defaults to `false`.
        :param pulumi.Input[builtins.bool] thursday: This check will pass on Thursdays. Defaults to `false`.
        :param pulumi.Input[builtins.int] timeout: The timeout in minutes for the business hours check. Defaults to `1440`.
        :param pulumi.Input[builtins.bool] tuesday: This check will pass on Tuesday. Defaults to `false`.
        :param pulumi.Input[builtins.bool] wednesday: This check will pass on Wednesdays. Defaults to `false`.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "target_resource_id", target_resource_id)
        pulumi.set(__self__, "target_resource_type", target_resource_type)
        pulumi.set(__self__, "time_zone", time_zone)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if friday is not None:
            pulumi.set(__self__, "friday", friday)
        if monday is not None:
            pulumi.set(__self__, "monday", monday)
        if saturday is not None:
            pulumi.set(__self__, "saturday", saturday)
        if sunday is not None:
            pulumi.set(__self__, "sunday", sunday)
        if thursday is not None:
            pulumi.set(__self__, "thursday", thursday)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if tuesday is not None:
            pulumi.set(__self__, "tuesday", tuesday)
        if wednesday is not None:
            pulumi.set(__self__, "wednesday", wednesday)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Input[builtins.str]:
        """
        The end of the time period that this check will be allowed to pass, specified as 24-hour time with leading zeros.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.str]:
        """
        The project ID.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input[builtins.str]:
        """
        The beginning of the time period that this check will be allowed to pass, specified as 24-hour time with leading zeros.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the resource being protected by the check.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_resource_id", value)

    @property
    @pulumi.getter(name="targetResourceType")
    def target_resource_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of resource being protected by the check. Possible values are: `endpoint`, `environment`, `queue`, `repository`, `securefile`, `variablegroup`.
        """
        return pulumi.get(self, "target_resource_type")

    @target_resource_type.setter
    def target_resource_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_resource_type", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Input[builtins.str]:
        """
        The time zone this check will be evaluated in. See below for supported values.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the business hours check displayed in the web UI.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def friday(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This check will pass on Fridays. Defaults to `false`.
        """
        return pulumi.get(self, "friday")

    @friday.setter
    def friday(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "friday", value)

    @property
    @pulumi.getter
    def monday(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This check will pass on Mondays. Defaults to `false`.
        """
        return pulumi.get(self, "monday")

    @monday.setter
    def monday(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "monday", value)

    @property
    @pulumi.getter
    def saturday(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This check will pass on Saturdays. Defaults to `false`.
        """
        return pulumi.get(self, "saturday")

    @saturday.setter
    def saturday(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "saturday", value)

    @property
    @pulumi.getter
    def sunday(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This check will pass on Sundays. Defaults to `false`.
        """
        return pulumi.get(self, "sunday")

    @sunday.setter
    def sunday(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sunday", value)

    @property
    @pulumi.getter
    def thursday(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This check will pass on Thursdays. Defaults to `false`.
        """
        return pulumi.get(self, "thursday")

    @thursday.setter
    def thursday(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "thursday", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The timeout in minutes for the business hours check. Defaults to `1440`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def tuesday(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This check will pass on Tuesday. Defaults to `false`.
        """
        return pulumi.get(self, "tuesday")

    @tuesday.setter
    def tuesday(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tuesday", value)

    @property
    @pulumi.getter
    def wednesday(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This check will pass on Wednesdays. Defaults to `false`.
        """
        return pulumi.get(self, "wednesday")

    @wednesday.setter
    def wednesday(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "wednesday", value)


@pulumi.input_type
class _CheckBusinessHoursState:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 end_time: Optional[pulumi.Input[builtins.str]] = None,
                 friday: Optional[pulumi.Input[builtins.bool]] = None,
                 monday: Optional[pulumi.Input[builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 saturday: Optional[pulumi.Input[builtins.bool]] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None,
                 sunday: Optional[pulumi.Input[builtins.bool]] = None,
                 target_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 thursday: Optional[pulumi.Input[builtins.bool]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 tuesday: Optional[pulumi.Input[builtins.bool]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None,
                 wednesday: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering CheckBusinessHours resources.
        :param pulumi.Input[builtins.str] display_name: The name of the business hours check displayed in the web UI.
        :param pulumi.Input[builtins.str] end_time: The end of the time period that this check will be allowed to pass, specified as 24-hour time with leading zeros.
        :param pulumi.Input[builtins.bool] friday: This check will pass on Fridays. Defaults to `false`.
        :param pulumi.Input[builtins.bool] monday: This check will pass on Mondays. Defaults to `false`.
        :param pulumi.Input[builtins.str] project_id: The project ID.
        :param pulumi.Input[builtins.bool] saturday: This check will pass on Saturdays. Defaults to `false`.
        :param pulumi.Input[builtins.str] start_time: The beginning of the time period that this check will be allowed to pass, specified as 24-hour time with leading zeros.
        :param pulumi.Input[builtins.bool] sunday: This check will pass on Sundays. Defaults to `false`.
        :param pulumi.Input[builtins.str] target_resource_id: The ID of the resource being protected by the check.
        :param pulumi.Input[builtins.str] target_resource_type: The type of resource being protected by the check. Possible values are: `endpoint`, `environment`, `queue`, `repository`, `securefile`, `variablegroup`.
        :param pulumi.Input[builtins.bool] thursday: This check will pass on Thursdays. Defaults to `false`.
        :param pulumi.Input[builtins.str] time_zone: The time zone this check will be evaluated in. See below for supported values.
        :param pulumi.Input[builtins.int] timeout: The timeout in minutes for the business hours check. Defaults to `1440`.
        :param pulumi.Input[builtins.bool] tuesday: This check will pass on Tuesday. Defaults to `false`.
        :param pulumi.Input[builtins.int] version: The version of the check.
        :param pulumi.Input[builtins.bool] wednesday: This check will pass on Wednesdays. Defaults to `false`.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if friday is not None:
            pulumi.set(__self__, "friday", friday)
        if monday is not None:
            pulumi.set(__self__, "monday", monday)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if saturday is not None:
            pulumi.set(__self__, "saturday", saturday)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if sunday is not None:
            pulumi.set(__self__, "sunday", sunday)
        if target_resource_id is not None:
            pulumi.set(__self__, "target_resource_id", target_resource_id)
        if target_resource_type is not None:
            pulumi.set(__self__, "target_resource_type", target_resource_type)
        if thursday is not None:
            pulumi.set(__self__, "thursday", thursday)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if tuesday is not None:
            pulumi.set(__self__, "tuesday", tuesday)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if wednesday is not None:
            pulumi.set(__self__, "wednesday", wednesday)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the business hours check displayed in the web UI.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The end of the time period that this check will be allowed to pass, specified as 24-hour time with leading zeros.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter
    def friday(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This check will pass on Fridays. Defaults to `false`.
        """
        return pulumi.get(self, "friday")

    @friday.setter
    def friday(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "friday", value)

    @property
    @pulumi.getter
    def monday(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This check will pass on Mondays. Defaults to `false`.
        """
        return pulumi.get(self, "monday")

    @monday.setter
    def monday(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "monday", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The project ID.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def saturday(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This check will pass on Saturdays. Defaults to `false`.
        """
        return pulumi.get(self, "saturday")

    @saturday.setter
    def saturday(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "saturday", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The beginning of the time period that this check will be allowed to pass, specified as 24-hour time with leading zeros.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def sunday(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This check will pass on Sundays. Defaults to `false`.
        """
        return pulumi.get(self, "sunday")

    @sunday.setter
    def sunday(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sunday", value)

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the resource being protected by the check.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_resource_id", value)

    @property
    @pulumi.getter(name="targetResourceType")
    def target_resource_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of resource being protected by the check. Possible values are: `endpoint`, `environment`, `queue`, `repository`, `securefile`, `variablegroup`.
        """
        return pulumi.get(self, "target_resource_type")

    @target_resource_type.setter
    def target_resource_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_resource_type", value)

    @property
    @pulumi.getter
    def thursday(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This check will pass on Thursdays. Defaults to `false`.
        """
        return pulumi.get(self, "thursday")

    @thursday.setter
    def thursday(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "thursday", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time zone this check will be evaluated in. See below for supported values.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The timeout in minutes for the business hours check. Defaults to `1440`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def tuesday(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This check will pass on Tuesday. Defaults to `false`.
        """
        return pulumi.get(self, "tuesday")

    @tuesday.setter
    def tuesday(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tuesday", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the check.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def wednesday(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This check will pass on Wednesdays. Defaults to `false`.
        """
        return pulumi.get(self, "wednesday")

    @wednesday.setter
    def wednesday(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "wednesday", value)


@pulumi.type_token("azuredevops:index/checkBusinessHours:CheckBusinessHours")
class CheckBusinessHours(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 end_time: Optional[pulumi.Input[builtins.str]] = None,
                 friday: Optional[pulumi.Input[builtins.bool]] = None,
                 monday: Optional[pulumi.Input[builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 saturday: Optional[pulumi.Input[builtins.bool]] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None,
                 sunday: Optional[pulumi.Input[builtins.bool]] = None,
                 target_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 thursday: Optional[pulumi.Input[builtins.bool]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 tuesday: Optional[pulumi.Input[builtins.bool]] = None,
                 wednesday: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Manages a business hours check on a resource within Azure DevOps.

        ## Example Usage

        ### Protect a service connection

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example", name="Example Project")
        example_service_endpoint_generic = azuredevops.ServiceEndpointGeneric("example",
            project_id=example.id,
            server_url="https://some-server.example.com",
            username="username",
            password="password",
            service_endpoint_name="Example Generic",
            description="Managed by Pulumi")
        example_check_business_hours = azuredevops.CheckBusinessHours("example",
            project_id=example.id,
            display_name="Managed by Pulumi",
            target_resource_id=example_service_endpoint_generic.id,
            target_resource_type="endpoint",
            start_time="07:00",
            end_time="15:30",
            time_zone="UTC",
            monday=True,
            tuesday=True,
            timeout=1440)
        ```

        ### Protect an environment

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example", name="Example Project")
        example_environment = azuredevops.Environment("example",
            project_id=example.id,
            name="Example Environment")
        example_check_business_hours = azuredevops.CheckBusinessHours("example",
            project_id=example.id,
            display_name="Managed by Pulumi",
            target_resource_id=example_environment.id,
            target_resource_type="environment",
            start_time="07:00",
            end_time="15:30",
            time_zone="UTC",
            monday=True,
            tuesday=True)
        ```

        ### Protect an agent queue

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example", name="Example Project")
        example_pool = azuredevops.Pool("example", name="example-pool")
        example_queue = azuredevops.Queue("example",
            project_id=example.id,
            agent_pool_id=example_pool.id)
        example_check_business_hours = azuredevops.CheckBusinessHours("example",
            project_id=example.id,
            display_name="Managed by Pulumi",
            target_resource_id=example_queue.id,
            target_resource_type="queue",
            start_time="07:00",
            end_time="15:30",
            time_zone="UTC",
            monday=True,
            tuesday=True)
        ```

        ### Protect a repository

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example", name="Example Project")
        example_git = azuredevops.Git("example",
            project_id=example.id,
            name="Example Empty Git Repository",
            initialization={
                "init_type": "Clean",
            })
        example_check_business_hours = azuredevops.CheckBusinessHours("example",
            project_id=example.id,
            display_name="Managed by Pulumi",
            target_resource_id=pulumi.Output.all(
                exampleId=example.id,
                exampleGitId=example_git.id
        ).apply(lambda resolved_outputs: f"{resolved_outputs['exampleId']}.{resolved_outputs['exampleGitId']}")
        ,
            target_resource_type="repository",
            start_time="07:00",
            end_time="15:30",
            time_zone="UTC",
            monday=True,
            tuesday=True)
        ```

        ### Protect a variable group

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example", name="Example Project")
        example_variable_group = azuredevops.VariableGroup("example",
            project_id=example.id,
            name="Example Variable Group",
            description="Example Variable Group Description",
            allow_access=True,
            variables=[
                {
                    "name": "key1",
                    "value": "val1",
                },
                {
                    "name": "key2",
                    "secret_value": "val2",
                    "is_secret": True,
                },
            ])
        example_check_business_hours = azuredevops.CheckBusinessHours("example",
            project_id=example.id,
            display_name="Managed by Pulumi",
            target_resource_id=example_variable_group.id,
            target_resource_type="variablegroup",
            start_time="07:00",
            end_time="15:30",
            time_zone="UTC",
            monday=True,
            tuesday=True)
        ```

        ## Relevant Links

        - [Define approvals and checks](https://learn.microsoft.com/en-us/azure/devops/pipelines/process/approvals?view=azure-devops&tabs=check-pass)

        ## Supported Time Zones

        - AUS Central Standard Time
        - AUS Eastern Standard Time
        - Afghanistan Standard Time
        - Alaskan Standard Time
        - Aleutian Standard Time
        - Altai Standard Time
        - Arab Standard Time
        - Arabian Standard Time
        - Arabic Standard Time
        - Argentina Standard Time
        - Astrakhan Standard Time
        - Atlantic Standard Time
        - Aus Central W. Standard Time
        - Azerbaijan Standard Time
        - Azores Standard Time
        - Bahia Standard Time
        - Bangladesh Standard Time
        - Belarus Standard Time
        - Bougainville Standard Time
        - Canada Central Standard Time
        - Cape Verde Standard Time
        - Caucasus Standard Time
        - Cen. Australia Standard Time
        - Central America Standard Time
        - Central Asia Standard Time
        - Central Brazilian Standard Time
        - Central Europe Standard Time
        - Central European Standard Time
        - Central Pacific Standard Time
        - Central Standard Time (Mexico)
        - Central Standard Time
        - Chatham Islands Standard Time
        - China Standard Time
        - Cuba Standard Time
        - Dateline Standard Time
        - E. Africa Standard Time
        - E. Australia Standard Time
        - E. Europe Standard Time
        - E. South America Standard Time
        - Easter Island Standard Time
        - Eastern Standard Time (Mexico)
        - Eastern Standard Time
        - Egypt Standard Time
        - Ekaterinburg Standard Time
        - FLE Standard Time
        - Fiji Standard Time
        - GMT Standard Time
        - GTB Standard Time
        - Georgian Standard Time
        - Greenland Standard Time
        - Greenwich Standard Time
        - Haiti Standard Time
        - Hawaiian Standard Time
        - India Standard Time
        - Iran Standard Time
        - Israel Standard Time
        - Jordan Standard Time
        - Kaliningrad Standard Time
        - Kamchatka Standard Time
        - Korea Standard Time
        - Libya Standard Time
        - Line Islands Standard Time
        - Lord Howe Standard Time
        - Magadan Standard Time
        - Magallanes Standard Time
        - Marquesas Standard Time
        - Mauritius Standard Time
        - Mid-Atlantic Standard Time
        - Middle East Standard Time
        - Montevideo Standard Time
        - Morocco Standard Time
        - Mountain Standard Time (Mexico)
        - Mountain Standard Time
        - Myanmar Standard Time
        - N. Central Asia Standard Time
        - Namibia Standard Time
        - Nepal Standard Time
        - New Zealand Standard Time
        - Newfoundland Standard Time
        - Norfolk Standard Time
        - North Asia East Standard Time
        - North Asia Standard Time
        - North Korea Standard Time
        - Omsk Standard Time
        - Pacific SA Standard Time
        - Pacific Standard Time (Mexico)
        - Pacific Standard Time
        - Pakistan Standard Time
        - Paraguay Standard Time
        - Qyzylorda Standard Time
        - Romance Standard Time
        - Russia Time Zone 10
        - Russia Time Zone 11
        - Russia Time Zone 3
        - Russian Standard Time
        - SA Eastern Standard Time
        - SA Pacific Standard Time
        - SA Western Standard Time
        - SE Asia Standard Time
        - Saint Pierre Standard Time
        - Sakhalin Standard Time
        - Samoa Standard Time
        - Sao Tome Standard Time
        - Saratov Standard Time
        - Singapore Standard Time
        - South Africa Standard Time
        - South Sudan Standard Time
        - Sri Lanka Standard Time
        - Sudan Standard Time
        - Syria Standard Time
        - Taipei Standard Time
        - Tasmania Standard Time
        - Tocantins Standard Time
        - Tokyo Standard Time
        - Tomsk Standard Time
        - Tonga Standard Time
        - Transbaikal Standard Time
        - Turkey Standard Time
        - Turks And Caicos Standard Time
        - US Eastern Standard Time
        - US Mountain Standard Time
        - UTC
        - UTC+12
        - UTC+13
        - UTC-02
        - UTC-08
        - UTC-09
        - UTC-11
        - Ulaanbaatar Standard Time
        - Venezuela Standard Time
        - Vladivostok Standard Time
        - Volgograd Standard Time
        - W. Australia Standard Time
        - W. Central Africa Standard Time
        - W. Europe Standard Time
        - W. Mongolia Standard Time
        - West Asia Standard Time
        - West Bank Standard Time
        - West Pacific Standard Time
        - Yakutsk Standard Time
        - Yukon Standard Time

        ## Import

        Importing this resource is not supported.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] display_name: The name of the business hours check displayed in the web UI.
        :param pulumi.Input[builtins.str] end_time: The end of the time period that this check will be allowed to pass, specified as 24-hour time with leading zeros.
        :param pulumi.Input[builtins.bool] friday: This check will pass on Fridays. Defaults to `false`.
        :param pulumi.Input[builtins.bool] monday: This check will pass on Mondays. Defaults to `false`.
        :param pulumi.Input[builtins.str] project_id: The project ID.
        :param pulumi.Input[builtins.bool] saturday: This check will pass on Saturdays. Defaults to `false`.
        :param pulumi.Input[builtins.str] start_time: The beginning of the time period that this check will be allowed to pass, specified as 24-hour time with leading zeros.
        :param pulumi.Input[builtins.bool] sunday: This check will pass on Sundays. Defaults to `false`.
        :param pulumi.Input[builtins.str] target_resource_id: The ID of the resource being protected by the check.
        :param pulumi.Input[builtins.str] target_resource_type: The type of resource being protected by the check. Possible values are: `endpoint`, `environment`, `queue`, `repository`, `securefile`, `variablegroup`.
        :param pulumi.Input[builtins.bool] thursday: This check will pass on Thursdays. Defaults to `false`.
        :param pulumi.Input[builtins.str] time_zone: The time zone this check will be evaluated in. See below for supported values.
        :param pulumi.Input[builtins.int] timeout: The timeout in minutes for the business hours check. Defaults to `1440`.
        :param pulumi.Input[builtins.bool] tuesday: This check will pass on Tuesday. Defaults to `false`.
        :param pulumi.Input[builtins.bool] wednesday: This check will pass on Wednesdays. Defaults to `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CheckBusinessHoursArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a business hours check on a resource within Azure DevOps.

        ## Example Usage

        ### Protect a service connection

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example", name="Example Project")
        example_service_endpoint_generic = azuredevops.ServiceEndpointGeneric("example",
            project_id=example.id,
            server_url="https://some-server.example.com",
            username="username",
            password="password",
            service_endpoint_name="Example Generic",
            description="Managed by Pulumi")
        example_check_business_hours = azuredevops.CheckBusinessHours("example",
            project_id=example.id,
            display_name="Managed by Pulumi",
            target_resource_id=example_service_endpoint_generic.id,
            target_resource_type="endpoint",
            start_time="07:00",
            end_time="15:30",
            time_zone="UTC",
            monday=True,
            tuesday=True,
            timeout=1440)
        ```

        ### Protect an environment

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example", name="Example Project")
        example_environment = azuredevops.Environment("example",
            project_id=example.id,
            name="Example Environment")
        example_check_business_hours = azuredevops.CheckBusinessHours("example",
            project_id=example.id,
            display_name="Managed by Pulumi",
            target_resource_id=example_environment.id,
            target_resource_type="environment",
            start_time="07:00",
            end_time="15:30",
            time_zone="UTC",
            monday=True,
            tuesday=True)
        ```

        ### Protect an agent queue

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example", name="Example Project")
        example_pool = azuredevops.Pool("example", name="example-pool")
        example_queue = azuredevops.Queue("example",
            project_id=example.id,
            agent_pool_id=example_pool.id)
        example_check_business_hours = azuredevops.CheckBusinessHours("example",
            project_id=example.id,
            display_name="Managed by Pulumi",
            target_resource_id=example_queue.id,
            target_resource_type="queue",
            start_time="07:00",
            end_time="15:30",
            time_zone="UTC",
            monday=True,
            tuesday=True)
        ```

        ### Protect a repository

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example", name="Example Project")
        example_git = azuredevops.Git("example",
            project_id=example.id,
            name="Example Empty Git Repository",
            initialization={
                "init_type": "Clean",
            })
        example_check_business_hours = azuredevops.CheckBusinessHours("example",
            project_id=example.id,
            display_name="Managed by Pulumi",
            target_resource_id=pulumi.Output.all(
                exampleId=example.id,
                exampleGitId=example_git.id
        ).apply(lambda resolved_outputs: f"{resolved_outputs['exampleId']}.{resolved_outputs['exampleGitId']}")
        ,
            target_resource_type="repository",
            start_time="07:00",
            end_time="15:30",
            time_zone="UTC",
            monday=True,
            tuesday=True)
        ```

        ### Protect a variable group

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example", name="Example Project")
        example_variable_group = azuredevops.VariableGroup("example",
            project_id=example.id,
            name="Example Variable Group",
            description="Example Variable Group Description",
            allow_access=True,
            variables=[
                {
                    "name": "key1",
                    "value": "val1",
                },
                {
                    "name": "key2",
                    "secret_value": "val2",
                    "is_secret": True,
                },
            ])
        example_check_business_hours = azuredevops.CheckBusinessHours("example",
            project_id=example.id,
            display_name="Managed by Pulumi",
            target_resource_id=example_variable_group.id,
            target_resource_type="variablegroup",
            start_time="07:00",
            end_time="15:30",
            time_zone="UTC",
            monday=True,
            tuesday=True)
        ```

        ## Relevant Links

        - [Define approvals and checks](https://learn.microsoft.com/en-us/azure/devops/pipelines/process/approvals?view=azure-devops&tabs=check-pass)

        ## Supported Time Zones

        - AUS Central Standard Time
        - AUS Eastern Standard Time
        - Afghanistan Standard Time
        - Alaskan Standard Time
        - Aleutian Standard Time
        - Altai Standard Time
        - Arab Standard Time
        - Arabian Standard Time
        - Arabic Standard Time
        - Argentina Standard Time
        - Astrakhan Standard Time
        - Atlantic Standard Time
        - Aus Central W. Standard Time
        - Azerbaijan Standard Time
        - Azores Standard Time
        - Bahia Standard Time
        - Bangladesh Standard Time
        - Belarus Standard Time
        - Bougainville Standard Time
        - Canada Central Standard Time
        - Cape Verde Standard Time
        - Caucasus Standard Time
        - Cen. Australia Standard Time
        - Central America Standard Time
        - Central Asia Standard Time
        - Central Brazilian Standard Time
        - Central Europe Standard Time
        - Central European Standard Time
        - Central Pacific Standard Time
        - Central Standard Time (Mexico)
        - Central Standard Time
        - Chatham Islands Standard Time
        - China Standard Time
        - Cuba Standard Time
        - Dateline Standard Time
        - E. Africa Standard Time
        - E. Australia Standard Time
        - E. Europe Standard Time
        - E. South America Standard Time
        - Easter Island Standard Time
        - Eastern Standard Time (Mexico)
        - Eastern Standard Time
        - Egypt Standard Time
        - Ekaterinburg Standard Time
        - FLE Standard Time
        - Fiji Standard Time
        - GMT Standard Time
        - GTB Standard Time
        - Georgian Standard Time
        - Greenland Standard Time
        - Greenwich Standard Time
        - Haiti Standard Time
        - Hawaiian Standard Time
        - India Standard Time
        - Iran Standard Time
        - Israel Standard Time
        - Jordan Standard Time
        - Kaliningrad Standard Time
        - Kamchatka Standard Time
        - Korea Standard Time
        - Libya Standard Time
        - Line Islands Standard Time
        - Lord Howe Standard Time
        - Magadan Standard Time
        - Magallanes Standard Time
        - Marquesas Standard Time
        - Mauritius Standard Time
        - Mid-Atlantic Standard Time
        - Middle East Standard Time
        - Montevideo Standard Time
        - Morocco Standard Time
        - Mountain Standard Time (Mexico)
        - Mountain Standard Time
        - Myanmar Standard Time
        - N. Central Asia Standard Time
        - Namibia Standard Time
        - Nepal Standard Time
        - New Zealand Standard Time
        - Newfoundland Standard Time
        - Norfolk Standard Time
        - North Asia East Standard Time
        - North Asia Standard Time
        - North Korea Standard Time
        - Omsk Standard Time
        - Pacific SA Standard Time
        - Pacific Standard Time (Mexico)
        - Pacific Standard Time
        - Pakistan Standard Time
        - Paraguay Standard Time
        - Qyzylorda Standard Time
        - Romance Standard Time
        - Russia Time Zone 10
        - Russia Time Zone 11
        - Russia Time Zone 3
        - Russian Standard Time
        - SA Eastern Standard Time
        - SA Pacific Standard Time
        - SA Western Standard Time
        - SE Asia Standard Time
        - Saint Pierre Standard Time
        - Sakhalin Standard Time
        - Samoa Standard Time
        - Sao Tome Standard Time
        - Saratov Standard Time
        - Singapore Standard Time
        - South Africa Standard Time
        - South Sudan Standard Time
        - Sri Lanka Standard Time
        - Sudan Standard Time
        - Syria Standard Time
        - Taipei Standard Time
        - Tasmania Standard Time
        - Tocantins Standard Time
        - Tokyo Standard Time
        - Tomsk Standard Time
        - Tonga Standard Time
        - Transbaikal Standard Time
        - Turkey Standard Time
        - Turks And Caicos Standard Time
        - US Eastern Standard Time
        - US Mountain Standard Time
        - UTC
        - UTC+12
        - UTC+13
        - UTC-02
        - UTC-08
        - UTC-09
        - UTC-11
        - Ulaanbaatar Standard Time
        - Venezuela Standard Time
        - Vladivostok Standard Time
        - Volgograd Standard Time
        - W. Australia Standard Time
        - W. Central Africa Standard Time
        - W. Europe Standard Time
        - W. Mongolia Standard Time
        - West Asia Standard Time
        - West Bank Standard Time
        - West Pacific Standard Time
        - Yakutsk Standard Time
        - Yukon Standard Time

        ## Import

        Importing this resource is not supported.

        :param str resource_name: The name of the resource.
        :param CheckBusinessHoursArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CheckBusinessHoursArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 end_time: Optional[pulumi.Input[builtins.str]] = None,
                 friday: Optional[pulumi.Input[builtins.bool]] = None,
                 monday: Optional[pulumi.Input[builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 saturday: Optional[pulumi.Input[builtins.bool]] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None,
                 sunday: Optional[pulumi.Input[builtins.bool]] = None,
                 target_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 thursday: Optional[pulumi.Input[builtins.bool]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 tuesday: Optional[pulumi.Input[builtins.bool]] = None,
                 wednesday: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CheckBusinessHoursArgs.__new__(CheckBusinessHoursArgs)

            __props__.__dict__["display_name"] = display_name
            if end_time is None and not opts.urn:
                raise TypeError("Missing required property 'end_time'")
            __props__.__dict__["end_time"] = end_time
            __props__.__dict__["friday"] = friday
            __props__.__dict__["monday"] = monday
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["saturday"] = saturday
            if start_time is None and not opts.urn:
                raise TypeError("Missing required property 'start_time'")
            __props__.__dict__["start_time"] = start_time
            __props__.__dict__["sunday"] = sunday
            if target_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_resource_id'")
            __props__.__dict__["target_resource_id"] = target_resource_id
            if target_resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'target_resource_type'")
            __props__.__dict__["target_resource_type"] = target_resource_type
            __props__.__dict__["thursday"] = thursday
            if time_zone is None and not opts.urn:
                raise TypeError("Missing required property 'time_zone'")
            __props__.__dict__["time_zone"] = time_zone
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["tuesday"] = tuesday
            __props__.__dict__["wednesday"] = wednesday
            __props__.__dict__["version"] = None
        super(CheckBusinessHours, __self__).__init__(
            'azuredevops:index/checkBusinessHours:CheckBusinessHours',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            end_time: Optional[pulumi.Input[builtins.str]] = None,
            friday: Optional[pulumi.Input[builtins.bool]] = None,
            monday: Optional[pulumi.Input[builtins.bool]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            saturday: Optional[pulumi.Input[builtins.bool]] = None,
            start_time: Optional[pulumi.Input[builtins.str]] = None,
            sunday: Optional[pulumi.Input[builtins.bool]] = None,
            target_resource_id: Optional[pulumi.Input[builtins.str]] = None,
            target_resource_type: Optional[pulumi.Input[builtins.str]] = None,
            thursday: Optional[pulumi.Input[builtins.bool]] = None,
            time_zone: Optional[pulumi.Input[builtins.str]] = None,
            timeout: Optional[pulumi.Input[builtins.int]] = None,
            tuesday: Optional[pulumi.Input[builtins.bool]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None,
            wednesday: Optional[pulumi.Input[builtins.bool]] = None) -> 'CheckBusinessHours':
        """
        Get an existing CheckBusinessHours resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] display_name: The name of the business hours check displayed in the web UI.
        :param pulumi.Input[builtins.str] end_time: The end of the time period that this check will be allowed to pass, specified as 24-hour time with leading zeros.
        :param pulumi.Input[builtins.bool] friday: This check will pass on Fridays. Defaults to `false`.
        :param pulumi.Input[builtins.bool] monday: This check will pass on Mondays. Defaults to `false`.
        :param pulumi.Input[builtins.str] project_id: The project ID.
        :param pulumi.Input[builtins.bool] saturday: This check will pass on Saturdays. Defaults to `false`.
        :param pulumi.Input[builtins.str] start_time: The beginning of the time period that this check will be allowed to pass, specified as 24-hour time with leading zeros.
        :param pulumi.Input[builtins.bool] sunday: This check will pass on Sundays. Defaults to `false`.
        :param pulumi.Input[builtins.str] target_resource_id: The ID of the resource being protected by the check.
        :param pulumi.Input[builtins.str] target_resource_type: The type of resource being protected by the check. Possible values are: `endpoint`, `environment`, `queue`, `repository`, `securefile`, `variablegroup`.
        :param pulumi.Input[builtins.bool] thursday: This check will pass on Thursdays. Defaults to `false`.
        :param pulumi.Input[builtins.str] time_zone: The time zone this check will be evaluated in. See below for supported values.
        :param pulumi.Input[builtins.int] timeout: The timeout in minutes for the business hours check. Defaults to `1440`.
        :param pulumi.Input[builtins.bool] tuesday: This check will pass on Tuesday. Defaults to `false`.
        :param pulumi.Input[builtins.int] version: The version of the check.
        :param pulumi.Input[builtins.bool] wednesday: This check will pass on Wednesdays. Defaults to `false`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CheckBusinessHoursState.__new__(_CheckBusinessHoursState)

        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["friday"] = friday
        __props__.__dict__["monday"] = monday
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["saturday"] = saturday
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["sunday"] = sunday
        __props__.__dict__["target_resource_id"] = target_resource_id
        __props__.__dict__["target_resource_type"] = target_resource_type
        __props__.__dict__["thursday"] = thursday
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["tuesday"] = tuesday
        __props__.__dict__["version"] = version
        __props__.__dict__["wednesday"] = wednesday
        return CheckBusinessHours(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the business hours check displayed in the web UI.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[builtins.str]:
        """
        The end of the time period that this check will be allowed to pass, specified as 24-hour time with leading zeros.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def friday(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        This check will pass on Fridays. Defaults to `false`.
        """
        return pulumi.get(self, "friday")

    @property
    @pulumi.getter
    def monday(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        This check will pass on Mondays. Defaults to `false`.
        """
        return pulumi.get(self, "monday")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        The project ID.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def saturday(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        This check will pass on Saturdays. Defaults to `false`.
        """
        return pulumi.get(self, "saturday")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[builtins.str]:
        """
        The beginning of the time period that this check will be allowed to pass, specified as 24-hour time with leading zeros.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def sunday(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        This check will pass on Sundays. Defaults to `false`.
        """
        return pulumi.get(self, "sunday")

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the resource being protected by the check.
        """
        return pulumi.get(self, "target_resource_id")

    @property
    @pulumi.getter(name="targetResourceType")
    def target_resource_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of resource being protected by the check. Possible values are: `endpoint`, `environment`, `queue`, `repository`, `securefile`, `variablegroup`.
        """
        return pulumi.get(self, "target_resource_type")

    @property
    @pulumi.getter
    def thursday(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        This check will pass on Thursdays. Defaults to `false`.
        """
        return pulumi.get(self, "thursday")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[builtins.str]:
        """
        The time zone this check will be evaluated in. See below for supported values.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The timeout in minutes for the business hours check. Defaults to `1440`.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def tuesday(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        This check will pass on Tuesday. Defaults to `false`.
        """
        return pulumi.get(self, "tuesday")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the check.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def wednesday(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        This check will pass on Wednesdays. Defaults to `false`.
        """
        return pulumi.get(self, "wednesday")

