# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DashboardArgs', 'Dashboard']

@pulumi.input_type
class DashboardArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_interval: Optional[pulumi.Input[builtins.int]] = None,
                 team_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Dashboard resource.
        :param pulumi.Input[builtins.str] project_id: The ID of the Project. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] description: The description of the dashboard.
        :param pulumi.Input[builtins.str] name: The name of the Dashboard.
        :param pulumi.Input[builtins.int] refresh_interval: The interval for client to automatically refresh the dashboard. Expressed in minutes. Possible values are: `0`, `5`.Defaults to `0`.
        :param pulumi.Input[builtins.str] team_id: The ID of the Team.
        """
        pulumi.set(__self__, "project_id", project_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if refresh_interval is not None:
            pulumi.set(__self__, "refresh_interval", refresh_interval)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Project. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the dashboard.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Dashboard.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The interval for client to automatically refresh the dashboard. Expressed in minutes. Possible values are: `0`, `5`.Defaults to `0`.
        """
        return pulumi.get(self, "refresh_interval")

    @refresh_interval.setter
    def refresh_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "refresh_interval", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Team.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "team_id", value)


@pulumi.input_type
class _DashboardState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owner_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_interval: Optional[pulumi.Input[builtins.int]] = None,
                 team_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Dashboard resources.
        :param pulumi.Input[builtins.str] description: The description of the dashboard.
        :param pulumi.Input[builtins.str] name: The name of the Dashboard.
        :param pulumi.Input[builtins.str] owner_id: The owner of the Dashboard, could be the project or a team.
        :param pulumi.Input[builtins.str] project_id: The ID of the Project. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] refresh_interval: The interval for client to automatically refresh the dashboard. Expressed in minutes. Possible values are: `0`, `5`.Defaults to `0`.
        :param pulumi.Input[builtins.str] team_id: The ID of the Team.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if refresh_interval is not None:
            pulumi.set(__self__, "refresh_interval", refresh_interval)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the dashboard.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Dashboard.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The owner of the Dashboard, could be the project or a team.
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Project. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The interval for client to automatically refresh the dashboard. Expressed in minutes. Possible values are: `0`, `5`.Defaults to `0`.
        """
        return pulumi.get(self, "refresh_interval")

    @refresh_interval.setter
    def refresh_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "refresh_interval", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Team.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "team_id", value)


@pulumi.type_token("azuredevops:index/dashboard:Dashboard")
class Dashboard(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_interval: Optional[pulumi.Input[builtins.int]] = None,
                 team_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages Dashboard within Azure DevOps project.

        > **NOTE:** Project level Dashboard allows to be created with the same name. Dashboard held by a team must have a different name.

        ## Example Usage

        ### Manage Project dashboard

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            description="Managed by Pulumi")
        example_dashboard = azuredevops.Dashboard("example",
            project_id=example.id,
            name="Example dashboard")
        ```

        ### Manage Team dashboard

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            description="Managed by Pulumi")
        example_team = azuredevops.Team("example",
            project_id=example.id,
            name="Example team")
        example_dashboard = azuredevops.Dashboard("example",
            project_id=example.id,
            name="Example dashboard",
            team_id=example_team.id)
        ```

        ## Relevant Links

        - [Azure DevOps dashboards REST API 7.1 - Dashboard ](https://learn.microsoft.com/en-us/rest/api/azure/devops/dashboard/dashboards?view=azure-devops-rest-7.1)

        ## Import

        Azure DevOps Dashboard can be imported using the `projectId/dasboardId` or `projectId/teamId/dasboardId`

        ```sh
        $ pulumi import azuredevops:index/dashboard:Dashboard dashboard 00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000
        ```

        or

        ```sh
        $ pulumi import azuredevops:index/dashboard:Dashboard dashboard 00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the dashboard.
        :param pulumi.Input[builtins.str] name: The name of the Dashboard.
        :param pulumi.Input[builtins.str] project_id: The ID of the Project. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] refresh_interval: The interval for client to automatically refresh the dashboard. Expressed in minutes. Possible values are: `0`, `5`.Defaults to `0`.
        :param pulumi.Input[builtins.str] team_id: The ID of the Team.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DashboardArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Dashboard within Azure DevOps project.

        > **NOTE:** Project level Dashboard allows to be created with the same name. Dashboard held by a team must have a different name.

        ## Example Usage

        ### Manage Project dashboard

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            description="Managed by Pulumi")
        example_dashboard = azuredevops.Dashboard("example",
            project_id=example.id,
            name="Example dashboard")
        ```

        ### Manage Team dashboard

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            description="Managed by Pulumi")
        example_team = azuredevops.Team("example",
            project_id=example.id,
            name="Example team")
        example_dashboard = azuredevops.Dashboard("example",
            project_id=example.id,
            name="Example dashboard",
            team_id=example_team.id)
        ```

        ## Relevant Links

        - [Azure DevOps dashboards REST API 7.1 - Dashboard ](https://learn.microsoft.com/en-us/rest/api/azure/devops/dashboard/dashboards?view=azure-devops-rest-7.1)

        ## Import

        Azure DevOps Dashboard can be imported using the `projectId/dasboardId` or `projectId/teamId/dasboardId`

        ```sh
        $ pulumi import azuredevops:index/dashboard:Dashboard dashboard 00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000
        ```

        or

        ```sh
        $ pulumi import azuredevops:index/dashboard:Dashboard dashboard 00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param DashboardArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DashboardArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_interval: Optional[pulumi.Input[builtins.int]] = None,
                 team_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DashboardArgs.__new__(DashboardArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["refresh_interval"] = refresh_interval
            __props__.__dict__["team_id"] = team_id
            __props__.__dict__["owner_id"] = None
        super(Dashboard, __self__).__init__(
            'azuredevops:index/dashboard:Dashboard',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            owner_id: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            refresh_interval: Optional[pulumi.Input[builtins.int]] = None,
            team_id: Optional[pulumi.Input[builtins.str]] = None) -> 'Dashboard':
        """
        Get an existing Dashboard resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the dashboard.
        :param pulumi.Input[builtins.str] name: The name of the Dashboard.
        :param pulumi.Input[builtins.str] owner_id: The owner of the Dashboard, could be the project or a team.
        :param pulumi.Input[builtins.str] project_id: The ID of the Project. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] refresh_interval: The interval for client to automatically refresh the dashboard. Expressed in minutes. Possible values are: `0`, `5`.Defaults to `0`.
        :param pulumi.Input[builtins.str] team_id: The ID of the Team.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DashboardState.__new__(_DashboardState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["refresh_interval"] = refresh_interval
        __props__.__dict__["team_id"] = team_id
        return Dashboard(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the dashboard.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Dashboard.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[builtins.str]:
        """
        The owner of the Dashboard, could be the project or a team.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Project. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The interval for client to automatically refresh the dashboard. Expressed in minutes. Possible values are: `0`, `5`.Defaults to `0`.
        """
        return pulumi.get(self, "refresh_interval")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the Team.
        """
        return pulumi.get(self, "team_id")

