# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ElasticPoolArgs', 'ElasticPool']

@pulumi.input_type
class ElasticPoolArgs:
    def __init__(__self__, *,
                 azure_resource_id: pulumi.Input[builtins.str],
                 desired_idle: pulumi.Input[builtins.int],
                 max_capacity: pulumi.Input[builtins.int],
                 service_endpoint_id: pulumi.Input[builtins.str],
                 service_endpoint_scope: pulumi.Input[builtins.str],
                 agent_interactive_ui: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_provision: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_update: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 recycle_after_each_use: Optional[pulumi.Input[builtins.bool]] = None,
                 time_to_live_minutes: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a ElasticPool resource.
        :param pulumi.Input[builtins.str] azure_resource_id: The ID of the Azure resource.
        :param pulumi.Input[builtins.int] desired_idle: Number of agents to keep on standby.
        :param pulumi.Input[builtins.int] max_capacity: Maximum number of virtual machines in the scale set.
        :param pulumi.Input[builtins.str] service_endpoint_id: The ID of Service Endpoint used to connect to Azure.
        :param pulumi.Input[builtins.str] service_endpoint_scope: The Project ID of Service Endpoint belongs to.
        :param pulumi.Input[builtins.bool] agent_interactive_ui: Set whether agents should be configured to run with interactive UI. Defaults to `false`.
        :param pulumi.Input[builtins.bool] auto_provision: Specifies whether a queue should be automatically provisioned for each project collection. Defaults to `false`.
        :param pulumi.Input[builtins.bool] auto_update: Specifies whether or not agents within the pool should be automatically updated. Defaults to `true`.
        :param pulumi.Input[builtins.str] name: The name of the Elastic pool.
        :param pulumi.Input[builtins.str] project_id: The ID of the project where a new Elastic Pool will be created.
        :param pulumi.Input[builtins.bool] recycle_after_each_use: Tear down virtual machines after every use. Defaults to `false`.
        :param pulumi.Input[builtins.int] time_to_live_minutes: Delay in minutes before deleting excess idle agents. Defaults to `30`.
        """
        pulumi.set(__self__, "azure_resource_id", azure_resource_id)
        pulumi.set(__self__, "desired_idle", desired_idle)
        pulumi.set(__self__, "max_capacity", max_capacity)
        pulumi.set(__self__, "service_endpoint_id", service_endpoint_id)
        pulumi.set(__self__, "service_endpoint_scope", service_endpoint_scope)
        if agent_interactive_ui is not None:
            pulumi.set(__self__, "agent_interactive_ui", agent_interactive_ui)
        if auto_provision is not None:
            pulumi.set(__self__, "auto_provision", auto_provision)
        if auto_update is not None:
            pulumi.set(__self__, "auto_update", auto_update)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if recycle_after_each_use is not None:
            pulumi.set(__self__, "recycle_after_each_use", recycle_after_each_use)
        if time_to_live_minutes is not None:
            pulumi.set(__self__, "time_to_live_minutes", time_to_live_minutes)

    @property
    @pulumi.getter(name="azureResourceId")
    def azure_resource_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Azure resource.
        """
        return pulumi.get(self, "azure_resource_id")

    @azure_resource_id.setter
    def azure_resource_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "azure_resource_id", value)

    @property
    @pulumi.getter(name="desiredIdle")
    def desired_idle(self) -> pulumi.Input[builtins.int]:
        """
        Number of agents to keep on standby.
        """
        return pulumi.get(self, "desired_idle")

    @desired_idle.setter
    def desired_idle(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "desired_idle", value)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> pulumi.Input[builtins.int]:
        """
        Maximum number of virtual machines in the scale set.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter(name="serviceEndpointId")
    def service_endpoint_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of Service Endpoint used to connect to Azure.
        """
        return pulumi.get(self, "service_endpoint_id")

    @service_endpoint_id.setter
    def service_endpoint_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_endpoint_id", value)

    @property
    @pulumi.getter(name="serviceEndpointScope")
    def service_endpoint_scope(self) -> pulumi.Input[builtins.str]:
        """
        The Project ID of Service Endpoint belongs to.
        """
        return pulumi.get(self, "service_endpoint_scope")

    @service_endpoint_scope.setter
    def service_endpoint_scope(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_endpoint_scope", value)

    @property
    @pulumi.getter(name="agentInteractiveUi")
    def agent_interactive_ui(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set whether agents should be configured to run with interactive UI. Defaults to `false`.
        """
        return pulumi.get(self, "agent_interactive_ui")

    @agent_interactive_ui.setter
    def agent_interactive_ui(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "agent_interactive_ui", value)

    @property
    @pulumi.getter(name="autoProvision")
    def auto_provision(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether a queue should be automatically provisioned for each project collection. Defaults to `false`.
        """
        return pulumi.get(self, "auto_provision")

    @auto_provision.setter
    def auto_provision(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_provision", value)

    @property
    @pulumi.getter(name="autoUpdate")
    def auto_update(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether or not agents within the pool should be automatically updated. Defaults to `true`.
        """
        return pulumi.get(self, "auto_update")

    @auto_update.setter
    def auto_update(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_update", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Elastic pool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project where a new Elastic Pool will be created.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="recycleAfterEachUse")
    def recycle_after_each_use(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Tear down virtual machines after every use. Defaults to `false`.
        """
        return pulumi.get(self, "recycle_after_each_use")

    @recycle_after_each_use.setter
    def recycle_after_each_use(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "recycle_after_each_use", value)

    @property
    @pulumi.getter(name="timeToLiveMinutes")
    def time_to_live_minutes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Delay in minutes before deleting excess idle agents. Defaults to `30`.
        """
        return pulumi.get(self, "time_to_live_minutes")

    @time_to_live_minutes.setter
    def time_to_live_minutes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "time_to_live_minutes", value)


@pulumi.input_type
class _ElasticPoolState:
    def __init__(__self__, *,
                 agent_interactive_ui: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_provision: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_update: Optional[pulumi.Input[builtins.bool]] = None,
                 azure_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 desired_idle: Optional[pulumi.Input[builtins.int]] = None,
                 max_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 recycle_after_each_use: Optional[pulumi.Input[builtins.bool]] = None,
                 service_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_endpoint_scope: Optional[pulumi.Input[builtins.str]] = None,
                 time_to_live_minutes: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering ElasticPool resources.
        :param pulumi.Input[builtins.bool] agent_interactive_ui: Set whether agents should be configured to run with interactive UI. Defaults to `false`.
        :param pulumi.Input[builtins.bool] auto_provision: Specifies whether a queue should be automatically provisioned for each project collection. Defaults to `false`.
        :param pulumi.Input[builtins.bool] auto_update: Specifies whether or not agents within the pool should be automatically updated. Defaults to `true`.
        :param pulumi.Input[builtins.str] azure_resource_id: The ID of the Azure resource.
        :param pulumi.Input[builtins.int] desired_idle: Number of agents to keep on standby.
        :param pulumi.Input[builtins.int] max_capacity: Maximum number of virtual machines in the scale set.
        :param pulumi.Input[builtins.str] name: The name of the Elastic pool.
        :param pulumi.Input[builtins.str] project_id: The ID of the project where a new Elastic Pool will be created.
        :param pulumi.Input[builtins.bool] recycle_after_each_use: Tear down virtual machines after every use. Defaults to `false`.
        :param pulumi.Input[builtins.str] service_endpoint_id: The ID of Service Endpoint used to connect to Azure.
        :param pulumi.Input[builtins.str] service_endpoint_scope: The Project ID of Service Endpoint belongs to.
        :param pulumi.Input[builtins.int] time_to_live_minutes: Delay in minutes before deleting excess idle agents. Defaults to `30`.
        """
        if agent_interactive_ui is not None:
            pulumi.set(__self__, "agent_interactive_ui", agent_interactive_ui)
        if auto_provision is not None:
            pulumi.set(__self__, "auto_provision", auto_provision)
        if auto_update is not None:
            pulumi.set(__self__, "auto_update", auto_update)
        if azure_resource_id is not None:
            pulumi.set(__self__, "azure_resource_id", azure_resource_id)
        if desired_idle is not None:
            pulumi.set(__self__, "desired_idle", desired_idle)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if recycle_after_each_use is not None:
            pulumi.set(__self__, "recycle_after_each_use", recycle_after_each_use)
        if service_endpoint_id is not None:
            pulumi.set(__self__, "service_endpoint_id", service_endpoint_id)
        if service_endpoint_scope is not None:
            pulumi.set(__self__, "service_endpoint_scope", service_endpoint_scope)
        if time_to_live_minutes is not None:
            pulumi.set(__self__, "time_to_live_minutes", time_to_live_minutes)

    @property
    @pulumi.getter(name="agentInteractiveUi")
    def agent_interactive_ui(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set whether agents should be configured to run with interactive UI. Defaults to `false`.
        """
        return pulumi.get(self, "agent_interactive_ui")

    @agent_interactive_ui.setter
    def agent_interactive_ui(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "agent_interactive_ui", value)

    @property
    @pulumi.getter(name="autoProvision")
    def auto_provision(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether a queue should be automatically provisioned for each project collection. Defaults to `false`.
        """
        return pulumi.get(self, "auto_provision")

    @auto_provision.setter
    def auto_provision(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_provision", value)

    @property
    @pulumi.getter(name="autoUpdate")
    def auto_update(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether or not agents within the pool should be automatically updated. Defaults to `true`.
        """
        return pulumi.get(self, "auto_update")

    @auto_update.setter
    def auto_update(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_update", value)

    @property
    @pulumi.getter(name="azureResourceId")
    def azure_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Azure resource.
        """
        return pulumi.get(self, "azure_resource_id")

    @azure_resource_id.setter
    def azure_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "azure_resource_id", value)

    @property
    @pulumi.getter(name="desiredIdle")
    def desired_idle(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of agents to keep on standby.
        """
        return pulumi.get(self, "desired_idle")

    @desired_idle.setter
    def desired_idle(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "desired_idle", value)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum number of virtual machines in the scale set.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Elastic pool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project where a new Elastic Pool will be created.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="recycleAfterEachUse")
    def recycle_after_each_use(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Tear down virtual machines after every use. Defaults to `false`.
        """
        return pulumi.get(self, "recycle_after_each_use")

    @recycle_after_each_use.setter
    def recycle_after_each_use(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "recycle_after_each_use", value)

    @property
    @pulumi.getter(name="serviceEndpointId")
    def service_endpoint_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of Service Endpoint used to connect to Azure.
        """
        return pulumi.get(self, "service_endpoint_id")

    @service_endpoint_id.setter
    def service_endpoint_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_endpoint_id", value)

    @property
    @pulumi.getter(name="serviceEndpointScope")
    def service_endpoint_scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Project ID of Service Endpoint belongs to.
        """
        return pulumi.get(self, "service_endpoint_scope")

    @service_endpoint_scope.setter
    def service_endpoint_scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_endpoint_scope", value)

    @property
    @pulumi.getter(name="timeToLiveMinutes")
    def time_to_live_minutes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Delay in minutes before deleting excess idle agents. Defaults to `30`.
        """
        return pulumi.get(self, "time_to_live_minutes")

    @time_to_live_minutes.setter
    def time_to_live_minutes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "time_to_live_minutes", value)


@pulumi.type_token("azuredevops:index/elasticPool:ElasticPool")
class ElasticPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_interactive_ui: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_provision: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_update: Optional[pulumi.Input[builtins.bool]] = None,
                 azure_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 desired_idle: Optional[pulumi.Input[builtins.int]] = None,
                 max_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 recycle_after_each_use: Optional[pulumi.Input[builtins.bool]] = None,
                 service_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_endpoint_scope: Optional[pulumi.Input[builtins.str]] = None,
                 time_to_live_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        Manages Elastic pool within Azure DevOps.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_service_endpoint_azure_rm = azuredevops.ServiceEndpointAzureRM("example",
            project_id=example.id,
            service_endpoint_name="Example Azure Connection",
            description="Managed by Pulumi",
            service_endpoint_authentication_scheme="ServicePrincipal",
            credentials={
                "serviceprincipalid": "00000000-0000-0000-0000-000000000000",
                "serviceprincipalkey": "00000000-0000-0000-0000-000000000000",
            },
            azurerm_spn_tenantid="00000000-0000-0000-0000-000000000000",
            azurerm_subscription_id="00000000-0000-0000-0000-000000000000",
            azurerm_subscription_name="Subscription Name")
        example_elastic_pool = azuredevops.ElasticPool("example",
            name="Example Elastic Pool",
            service_endpoint_id=example_service_endpoint_azure_rm.id,
            service_endpoint_scope=example.id,
            desired_idle=2,
            max_capacity=3,
            azure_resource_id="/subscriptions/<Subscription Id>/resourceGroups/<Resource Name>/providers/Microsoft.Compute/virtualMachineScaleSets/<VMSS Name>")
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.0 - Elastic Pools](https://learn.microsoft.com/en-us/rest/api/azure/devops/distributedtask/elasticpools/create?view=azure-devops-rest-7.0)

        ## Import

        Azure DevOps Agent Pools can be imported using the Elastic pool ID, e.g.

        ```sh
        $ pulumi import azuredevops:index/elasticPool:ElasticPool example 0
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] agent_interactive_ui: Set whether agents should be configured to run with interactive UI. Defaults to `false`.
        :param pulumi.Input[builtins.bool] auto_provision: Specifies whether a queue should be automatically provisioned for each project collection. Defaults to `false`.
        :param pulumi.Input[builtins.bool] auto_update: Specifies whether or not agents within the pool should be automatically updated. Defaults to `true`.
        :param pulumi.Input[builtins.str] azure_resource_id: The ID of the Azure resource.
        :param pulumi.Input[builtins.int] desired_idle: Number of agents to keep on standby.
        :param pulumi.Input[builtins.int] max_capacity: Maximum number of virtual machines in the scale set.
        :param pulumi.Input[builtins.str] name: The name of the Elastic pool.
        :param pulumi.Input[builtins.str] project_id: The ID of the project where a new Elastic Pool will be created.
        :param pulumi.Input[builtins.bool] recycle_after_each_use: Tear down virtual machines after every use. Defaults to `false`.
        :param pulumi.Input[builtins.str] service_endpoint_id: The ID of Service Endpoint used to connect to Azure.
        :param pulumi.Input[builtins.str] service_endpoint_scope: The Project ID of Service Endpoint belongs to.
        :param pulumi.Input[builtins.int] time_to_live_minutes: Delay in minutes before deleting excess idle agents. Defaults to `30`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ElasticPoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Elastic pool within Azure DevOps.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_service_endpoint_azure_rm = azuredevops.ServiceEndpointAzureRM("example",
            project_id=example.id,
            service_endpoint_name="Example Azure Connection",
            description="Managed by Pulumi",
            service_endpoint_authentication_scheme="ServicePrincipal",
            credentials={
                "serviceprincipalid": "00000000-0000-0000-0000-000000000000",
                "serviceprincipalkey": "00000000-0000-0000-0000-000000000000",
            },
            azurerm_spn_tenantid="00000000-0000-0000-0000-000000000000",
            azurerm_subscription_id="00000000-0000-0000-0000-000000000000",
            azurerm_subscription_name="Subscription Name")
        example_elastic_pool = azuredevops.ElasticPool("example",
            name="Example Elastic Pool",
            service_endpoint_id=example_service_endpoint_azure_rm.id,
            service_endpoint_scope=example.id,
            desired_idle=2,
            max_capacity=3,
            azure_resource_id="/subscriptions/<Subscription Id>/resourceGroups/<Resource Name>/providers/Microsoft.Compute/virtualMachineScaleSets/<VMSS Name>")
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.0 - Elastic Pools](https://learn.microsoft.com/en-us/rest/api/azure/devops/distributedtask/elasticpools/create?view=azure-devops-rest-7.0)

        ## Import

        Azure DevOps Agent Pools can be imported using the Elastic pool ID, e.g.

        ```sh
        $ pulumi import azuredevops:index/elasticPool:ElasticPool example 0
        ```

        :param str resource_name: The name of the resource.
        :param ElasticPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ElasticPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_interactive_ui: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_provision: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_update: Optional[pulumi.Input[builtins.bool]] = None,
                 azure_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 desired_idle: Optional[pulumi.Input[builtins.int]] = None,
                 max_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 recycle_after_each_use: Optional[pulumi.Input[builtins.bool]] = None,
                 service_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_endpoint_scope: Optional[pulumi.Input[builtins.str]] = None,
                 time_to_live_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ElasticPoolArgs.__new__(ElasticPoolArgs)

            __props__.__dict__["agent_interactive_ui"] = agent_interactive_ui
            __props__.__dict__["auto_provision"] = auto_provision
            __props__.__dict__["auto_update"] = auto_update
            if azure_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'azure_resource_id'")
            __props__.__dict__["azure_resource_id"] = azure_resource_id
            if desired_idle is None and not opts.urn:
                raise TypeError("Missing required property 'desired_idle'")
            __props__.__dict__["desired_idle"] = desired_idle
            if max_capacity is None and not opts.urn:
                raise TypeError("Missing required property 'max_capacity'")
            __props__.__dict__["max_capacity"] = max_capacity
            __props__.__dict__["name"] = name
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["recycle_after_each_use"] = recycle_after_each_use
            if service_endpoint_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_endpoint_id'")
            __props__.__dict__["service_endpoint_id"] = service_endpoint_id
            if service_endpoint_scope is None and not opts.urn:
                raise TypeError("Missing required property 'service_endpoint_scope'")
            __props__.__dict__["service_endpoint_scope"] = service_endpoint_scope
            __props__.__dict__["time_to_live_minutes"] = time_to_live_minutes
        super(ElasticPool, __self__).__init__(
            'azuredevops:index/elasticPool:ElasticPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_interactive_ui: Optional[pulumi.Input[builtins.bool]] = None,
            auto_provision: Optional[pulumi.Input[builtins.bool]] = None,
            auto_update: Optional[pulumi.Input[builtins.bool]] = None,
            azure_resource_id: Optional[pulumi.Input[builtins.str]] = None,
            desired_idle: Optional[pulumi.Input[builtins.int]] = None,
            max_capacity: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            recycle_after_each_use: Optional[pulumi.Input[builtins.bool]] = None,
            service_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
            service_endpoint_scope: Optional[pulumi.Input[builtins.str]] = None,
            time_to_live_minutes: Optional[pulumi.Input[builtins.int]] = None) -> 'ElasticPool':
        """
        Get an existing ElasticPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] agent_interactive_ui: Set whether agents should be configured to run with interactive UI. Defaults to `false`.
        :param pulumi.Input[builtins.bool] auto_provision: Specifies whether a queue should be automatically provisioned for each project collection. Defaults to `false`.
        :param pulumi.Input[builtins.bool] auto_update: Specifies whether or not agents within the pool should be automatically updated. Defaults to `true`.
        :param pulumi.Input[builtins.str] azure_resource_id: The ID of the Azure resource.
        :param pulumi.Input[builtins.int] desired_idle: Number of agents to keep on standby.
        :param pulumi.Input[builtins.int] max_capacity: Maximum number of virtual machines in the scale set.
        :param pulumi.Input[builtins.str] name: The name of the Elastic pool.
        :param pulumi.Input[builtins.str] project_id: The ID of the project where a new Elastic Pool will be created.
        :param pulumi.Input[builtins.bool] recycle_after_each_use: Tear down virtual machines after every use. Defaults to `false`.
        :param pulumi.Input[builtins.str] service_endpoint_id: The ID of Service Endpoint used to connect to Azure.
        :param pulumi.Input[builtins.str] service_endpoint_scope: The Project ID of Service Endpoint belongs to.
        :param pulumi.Input[builtins.int] time_to_live_minutes: Delay in minutes before deleting excess idle agents. Defaults to `30`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ElasticPoolState.__new__(_ElasticPoolState)

        __props__.__dict__["agent_interactive_ui"] = agent_interactive_ui
        __props__.__dict__["auto_provision"] = auto_provision
        __props__.__dict__["auto_update"] = auto_update
        __props__.__dict__["azure_resource_id"] = azure_resource_id
        __props__.__dict__["desired_idle"] = desired_idle
        __props__.__dict__["max_capacity"] = max_capacity
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["recycle_after_each_use"] = recycle_after_each_use
        __props__.__dict__["service_endpoint_id"] = service_endpoint_id
        __props__.__dict__["service_endpoint_scope"] = service_endpoint_scope
        __props__.__dict__["time_to_live_minutes"] = time_to_live_minutes
        return ElasticPool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentInteractiveUi")
    def agent_interactive_ui(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Set whether agents should be configured to run with interactive UI. Defaults to `false`.
        """
        return pulumi.get(self, "agent_interactive_ui")

    @property
    @pulumi.getter(name="autoProvision")
    def auto_provision(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether a queue should be automatically provisioned for each project collection. Defaults to `false`.
        """
        return pulumi.get(self, "auto_provision")

    @property
    @pulumi.getter(name="autoUpdate")
    def auto_update(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether or not agents within the pool should be automatically updated. Defaults to `true`.
        """
        return pulumi.get(self, "auto_update")

    @property
    @pulumi.getter(name="azureResourceId")
    def azure_resource_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Azure resource.
        """
        return pulumi.get(self, "azure_resource_id")

    @property
    @pulumi.getter(name="desiredIdle")
    def desired_idle(self) -> pulumi.Output[builtins.int]:
        """
        Number of agents to keep on standby.
        """
        return pulumi.get(self, "desired_idle")

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> pulumi.Output[builtins.int]:
        """
        Maximum number of virtual machines in the scale set.
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Elastic pool.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the project where a new Elastic Pool will be created.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="recycleAfterEachUse")
    def recycle_after_each_use(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Tear down virtual machines after every use. Defaults to `false`.
        """
        return pulumi.get(self, "recycle_after_each_use")

    @property
    @pulumi.getter(name="serviceEndpointId")
    def service_endpoint_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of Service Endpoint used to connect to Azure.
        """
        return pulumi.get(self, "service_endpoint_id")

    @property
    @pulumi.getter(name="serviceEndpointScope")
    def service_endpoint_scope(self) -> pulumi.Output[builtins.str]:
        """
        The Project ID of Service Endpoint belongs to.
        """
        return pulumi.get(self, "service_endpoint_scope")

    @property
    @pulumi.getter(name="timeToLiveMinutes")
    def time_to_live_minutes(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Delay in minutes before deleting excess idle agents. Defaults to `30`.
        """
        return pulumi.get(self, "time_to_live_minutes")

