# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ExtensionArgs', 'Extension']

@pulumi.input_type
class ExtensionArgs:
    def __init__(__self__, *,
                 extension_id: pulumi.Input[builtins.str],
                 publisher_id: pulumi.Input[builtins.str],
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Extension resource.
        :param pulumi.Input[builtins.str] extension_id: The publisher ID of the extension.
        :param pulumi.Input[builtins.str] publisher_id: The extension ID of the extension.
        :param pulumi.Input[builtins.bool] disabled: Whether to disable the extension.
        :param pulumi.Input[builtins.str] version: The version of the extension.
        """
        pulumi.set(__self__, "extension_id", extension_id)
        pulumi.set(__self__, "publisher_id", publisher_id)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="extensionId")
    def extension_id(self) -> pulumi.Input[builtins.str]:
        """
        The publisher ID of the extension.
        """
        return pulumi.get(self, "extension_id")

    @extension_id.setter
    def extension_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "extension_id", value)

    @property
    @pulumi.getter(name="publisherId")
    def publisher_id(self) -> pulumi.Input[builtins.str]:
        """
        The extension ID of the extension.
        """
        return pulumi.get(self, "publisher_id")

    @publisher_id.setter
    def publisher_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "publisher_id", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to disable the extension.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the extension.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _ExtensionState:
    def __init__(__self__, *,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 extension_id: Optional[pulumi.Input[builtins.str]] = None,
                 extension_name: Optional[pulumi.Input[builtins.str]] = None,
                 publisher_id: Optional[pulumi.Input[builtins.str]] = None,
                 publisher_name: Optional[pulumi.Input[builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Extension resources.
        :param pulumi.Input[builtins.bool] disabled: Whether to disable the extension.
        :param pulumi.Input[builtins.str] extension_id: The publisher ID of the extension.
        :param pulumi.Input[builtins.str] extension_name: The name of the extension.
        :param pulumi.Input[builtins.str] publisher_id: The extension ID of the extension.
        :param pulumi.Input[builtins.str] publisher_name: The name of the publisher.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scopes: List of all oauth scopes required by this extension.
        :param pulumi.Input[builtins.str] version: The version of the extension.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if extension_id is not None:
            pulumi.set(__self__, "extension_id", extension_id)
        if extension_name is not None:
            pulumi.set(__self__, "extension_name", extension_name)
        if publisher_id is not None:
            pulumi.set(__self__, "publisher_id", publisher_id)
        if publisher_name is not None:
            pulumi.set(__self__, "publisher_name", publisher_name)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to disable the extension.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="extensionId")
    def extension_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The publisher ID of the extension.
        """
        return pulumi.get(self, "extension_id")

    @extension_id.setter
    def extension_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "extension_id", value)

    @property
    @pulumi.getter(name="extensionName")
    def extension_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the extension.
        """
        return pulumi.get(self, "extension_name")

    @extension_name.setter
    def extension_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "extension_name", value)

    @property
    @pulumi.getter(name="publisherId")
    def publisher_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The extension ID of the extension.
        """
        return pulumi.get(self, "publisher_id")

    @publisher_id.setter
    def publisher_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "publisher_id", value)

    @property
    @pulumi.getter(name="publisherName")
    def publisher_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the publisher.
        """
        return pulumi.get(self, "publisher_name")

    @publisher_name.setter
    def publisher_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "publisher_name", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of all oauth scopes required by this extension.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the extension.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("azuredevops:index/extension:Extension")
class Extension(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 extension_id: Optional[pulumi.Input[builtins.str]] = None,
                 publisher_id: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages extension within Azure DevOps organization.

        ## Example Usage

        ### Install Extension
        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Extension("example",
            extension_id="extension ID",
            publisher_id="publisher ID")
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.1 - Extension Management](https://learn.microsoft.com/en-us/rest/api/azure/devops/extensionmanagement/installed-extensions?view=azure-devops-rest-7.1)

        ## Import

        Azure DevOps Extension can be imported using the publisher ID and extension ID:

        ```sh
        $ pulumi import azuredevops:index/extension:Extension example publisherId/extensionId
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] disabled: Whether to disable the extension.
        :param pulumi.Input[builtins.str] extension_id: The publisher ID of the extension.
        :param pulumi.Input[builtins.str] publisher_id: The extension ID of the extension.
        :param pulumi.Input[builtins.str] version: The version of the extension.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExtensionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages extension within Azure DevOps organization.

        ## Example Usage

        ### Install Extension
        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Extension("example",
            extension_id="extension ID",
            publisher_id="publisher ID")
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.1 - Extension Management](https://learn.microsoft.com/en-us/rest/api/azure/devops/extensionmanagement/installed-extensions?view=azure-devops-rest-7.1)

        ## Import

        Azure DevOps Extension can be imported using the publisher ID and extension ID:

        ```sh
        $ pulumi import azuredevops:index/extension:Extension example publisherId/extensionId
        ```

        :param str resource_name: The name of the resource.
        :param ExtensionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExtensionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 extension_id: Optional[pulumi.Input[builtins.str]] = None,
                 publisher_id: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExtensionArgs.__new__(ExtensionArgs)

            __props__.__dict__["disabled"] = disabled
            if extension_id is None and not opts.urn:
                raise TypeError("Missing required property 'extension_id'")
            __props__.__dict__["extension_id"] = extension_id
            if publisher_id is None and not opts.urn:
                raise TypeError("Missing required property 'publisher_id'")
            __props__.__dict__["publisher_id"] = publisher_id
            __props__.__dict__["version"] = version
            __props__.__dict__["extension_name"] = None
            __props__.__dict__["publisher_name"] = None
            __props__.__dict__["scopes"] = None
        super(Extension, __self__).__init__(
            'azuredevops:index/extension:Extension',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            disabled: Optional[pulumi.Input[builtins.bool]] = None,
            extension_id: Optional[pulumi.Input[builtins.str]] = None,
            extension_name: Optional[pulumi.Input[builtins.str]] = None,
            publisher_id: Optional[pulumi.Input[builtins.str]] = None,
            publisher_name: Optional[pulumi.Input[builtins.str]] = None,
            scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None) -> 'Extension':
        """
        Get an existing Extension resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] disabled: Whether to disable the extension.
        :param pulumi.Input[builtins.str] extension_id: The publisher ID of the extension.
        :param pulumi.Input[builtins.str] extension_name: The name of the extension.
        :param pulumi.Input[builtins.str] publisher_id: The extension ID of the extension.
        :param pulumi.Input[builtins.str] publisher_name: The name of the publisher.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scopes: List of all oauth scopes required by this extension.
        :param pulumi.Input[builtins.str] version: The version of the extension.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExtensionState.__new__(_ExtensionState)

        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["extension_id"] = extension_id
        __props__.__dict__["extension_name"] = extension_name
        __props__.__dict__["publisher_id"] = publisher_id
        __props__.__dict__["publisher_name"] = publisher_name
        __props__.__dict__["scopes"] = scopes
        __props__.__dict__["version"] = version
        return Extension(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[builtins.bool]:
        """
        Whether to disable the extension.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="extensionId")
    def extension_id(self) -> pulumi.Output[builtins.str]:
        """
        The publisher ID of the extension.
        """
        return pulumi.get(self, "extension_id")

    @property
    @pulumi.getter(name="extensionName")
    def extension_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the extension.
        """
        return pulumi.get(self, "extension_name")

    @property
    @pulumi.getter(name="publisherId")
    def publisher_id(self) -> pulumi.Output[builtins.str]:
        """
        The extension ID of the extension.
        """
        return pulumi.get(self, "publisher_id")

    @property
    @pulumi.getter(name="publisherName")
    def publisher_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the publisher.
        """
        return pulumi.get(self, "publisher_name")

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of all oauth scopes required by this extension.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        The version of the extension.
        """
        return pulumi.get(self, "version")

