# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetGroupMembershipResult',
    'AwaitableGetGroupMembershipResult',
    'get_group_membership',
    'get_group_membership_output',
]

@pulumi.output_type
class GetGroupMembershipResult:
    """
    A collection of values returned by getGroupMembership.
    """
    def __init__(__self__, group_descriptor=None, id=None, members=None):
        if group_descriptor and not isinstance(group_descriptor, str):
            raise TypeError("Expected argument 'group_descriptor' to be a str")
        pulumi.set(__self__, "group_descriptor", group_descriptor)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if members and not isinstance(members, list):
            raise TypeError("Expected argument 'members' to be a list")
        pulumi.set(__self__, "members", members)

    @property
    @pulumi.getter(name="groupDescriptor")
    def group_descriptor(self) -> builtins.str:
        return pulumi.get(self, "group_descriptor")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def members(self) -> Sequence[builtins.str]:
        """
        A list of user or group descriptors.
        """
        return pulumi.get(self, "members")


class AwaitableGetGroupMembershipResult(GetGroupMembershipResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGroupMembershipResult(
            group_descriptor=self.group_descriptor,
            id=self.id,
            members=self.members)


def get_group_membership(group_descriptor: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGroupMembershipResult:
    """
    Use this data source to access information about an existing Group Memberships within Azure DevOps

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azuredevops as azuredevops

    example = azuredevops.get_group_membership(group_descriptor="groupdescroptpr")
    ```

    ## Relevant Links

    - [Azure DevOps Service REST API 7.1 - Memberships](https://docs.microsoft.com/en-us/rest/api/azure/devops/graph/memberships?view=azure-devops-rest-7.1)


    :param builtins.str group_descriptor: The descriptor of the group.
    """
    __args__ = dict()
    __args__['groupDescriptor'] = group_descriptor
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azuredevops:index/getGroupMembership:getGroupMembership', __args__, opts=opts, typ=GetGroupMembershipResult).value

    return AwaitableGetGroupMembershipResult(
        group_descriptor=pulumi.get(__ret__, 'group_descriptor'),
        id=pulumi.get(__ret__, 'id'),
        members=pulumi.get(__ret__, 'members'))
def get_group_membership_output(group_descriptor: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGroupMembershipResult]:
    """
    Use this data source to access information about an existing Group Memberships within Azure DevOps

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azuredevops as azuredevops

    example = azuredevops.get_group_membership(group_descriptor="groupdescroptpr")
    ```

    ## Relevant Links

    - [Azure DevOps Service REST API 7.1 - Memberships](https://docs.microsoft.com/en-us/rest/api/azure/devops/graph/memberships?view=azure-devops-rest-7.1)


    :param builtins.str group_descriptor: The descriptor of the group.
    """
    __args__ = dict()
    __args__['groupDescriptor'] = group_descriptor
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azuredevops:index/getGroupMembership:getGroupMembership', __args__, opts=opts, typ=GetGroupMembershipResult)
    return __ret__.apply(lambda __response__: GetGroupMembershipResult(
        group_descriptor=pulumi.get(__response__, 'group_descriptor'),
        id=pulumi.get(__response__, 'id'),
        members=pulumi.get(__response__, 'members')))
