# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetIdentityGroupResult',
    'AwaitableGetIdentityGroupResult',
    'get_identity_group',
    'get_identity_group_output',
]

@pulumi.output_type
class GetIdentityGroupResult:
    """
    A collection of values returned by getIdentityGroup.
    """
    def __init__(__self__, descriptor=None, id=None, name=None, project_id=None, subject_descriptor=None):
        if descriptor and not isinstance(descriptor, str):
            raise TypeError("Expected argument 'descriptor' to be a str")
        pulumi.set(__self__, "descriptor", descriptor)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if subject_descriptor and not isinstance(subject_descriptor, str):
            raise TypeError("Expected argument 'subject_descriptor' to be a str")
        pulumi.set(__self__, "subject_descriptor", subject_descriptor)

    @property
    @pulumi.getter
    def descriptor(self) -> builtins.str:
        """
        The descriptor of the identity group.
        """
        return pulumi.get(self, "descriptor")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        This is the non-unique display name of the identity subject. To change this field, you must alter its value in the source provider.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="subjectDescriptor")
    def subject_descriptor(self) -> builtins.str:
        """
        The subject descriptor of the identity group.
        """
        return pulumi.get(self, "subject_descriptor")


class AwaitableGetIdentityGroupResult(GetIdentityGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIdentityGroupResult(
            descriptor=self.descriptor,
            id=self.id,
            name=self.name,
            project_id=self.project_id,
            subject_descriptor=self.subject_descriptor)


def get_identity_group(name: Optional[builtins.str] = None,
                       project_id: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIdentityGroupResult:
    """
    Use this data source to access information about an existing Group within Azure DevOps On-Premise(Azure DevOps Server).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azuredevops as azuredevops

    # load existing group with specific name
    example_project_group = azuredevops.get_identity_group(project_id=example["id"],
        name="[Project-Name]\\\\Group-Name")
    ```

    ## Relevant Links

    - [Azure DevOps Service REST API 7.1 - Identities](https://docs.microsoft.com/en-us/rest/api/azure/devops/ims/?view=azure-devops-rest-7.2)


    :param builtins.str name: The name of the group.
    :param builtins.str project_id: The Project ID.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azuredevops:index/getIdentityGroup:getIdentityGroup', __args__, opts=opts, typ=GetIdentityGroupResult).value

    return AwaitableGetIdentityGroupResult(
        descriptor=pulumi.get(__ret__, 'descriptor'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        subject_descriptor=pulumi.get(__ret__, 'subject_descriptor'))
def get_identity_group_output(name: Optional[pulumi.Input[builtins.str]] = None,
                              project_id: Optional[pulumi.Input[builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIdentityGroupResult]:
    """
    Use this data source to access information about an existing Group within Azure DevOps On-Premise(Azure DevOps Server).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azuredevops as azuredevops

    # load existing group with specific name
    example_project_group = azuredevops.get_identity_group(project_id=example["id"],
        name="[Project-Name]\\\\Group-Name")
    ```

    ## Relevant Links

    - [Azure DevOps Service REST API 7.1 - Identities](https://docs.microsoft.com/en-us/rest/api/azure/devops/ims/?view=azure-devops-rest-7.2)


    :param builtins.str name: The name of the group.
    :param builtins.str project_id: The Project ID.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azuredevops:index/getIdentityGroup:getIdentityGroup', __args__, opts=opts, typ=GetIdentityGroupResult)
    return __ret__.apply(lambda __response__: GetIdentityGroupResult(
        descriptor=pulumi.get(__response__, 'descriptor'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id'),
        subject_descriptor=pulumi.get(__response__, 'subject_descriptor')))
