# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetTeamResult',
    'AwaitableGetTeamResult',
    'get_team',
    'get_team_output',
]

@pulumi.output_type
class GetTeamResult:
    """
    A collection of values returned by getTeam.
    """
    def __init__(__self__, administrators=None, description=None, descriptor=None, id=None, members=None, name=None, project_id=None, top=None):
        if administrators and not isinstance(administrators, list):
            raise TypeError("Expected argument 'administrators' to be a list")
        pulumi.set(__self__, "administrators", administrators)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if descriptor and not isinstance(descriptor, str):
            raise TypeError("Expected argument 'descriptor' to be a str")
        pulumi.set(__self__, "descriptor", descriptor)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if members and not isinstance(members, list):
            raise TypeError("Expected argument 'members' to be a list")
        pulumi.set(__self__, "members", members)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if top and not isinstance(top, int):
            raise TypeError("Expected argument 'top' to be a int")
        pulumi.set(__self__, "top", top)

    @property
    @pulumi.getter
    def administrators(self) -> Sequence[builtins.str]:
        """
        List of subject descriptors for `administrators` of the team.
        """
        return pulumi.get(self, "administrators")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the team.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def descriptor(self) -> builtins.str:
        """
        The descriptor of the Team.
        """
        return pulumi.get(self, "descriptor")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def members(self) -> Sequence[builtins.str]:
        """
        List of subject descriptors for `members` of the team.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    @_utilities.deprecated("""This property is deprecated and will be removed in the feature""")
    def top(self) -> Optional[builtins.int]:
        return pulumi.get(self, "top")


class AwaitableGetTeamResult(GetTeamResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTeamResult(
            administrators=self.administrators,
            description=self.description,
            descriptor=self.descriptor,
            id=self.id,
            members=self.members,
            name=self.name,
            project_id=self.project_id,
            top=self.top)


def get_team(name: Optional[builtins.str] = None,
             project_id: Optional[builtins.str] = None,
             top: Optional[builtins.int] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTeamResult:
    """
    Use this data source to access information about an existing Team in a Project within Azure DevOps.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azuredevops as azuredevops

    example_project = azuredevops.Project("example",
        name="Example Project",
        work_item_template="Agile",
        version_control="Git",
        visibility="private",
        description="Managed by Pulumi")
    example = azuredevops.get_team_output(project_id=example_project.id,
        name="Example Project Team")
    ```

    ## Relevant Links

    - [Azure DevOps Service REST API 7.0 - Teams - Get](https://docs.microsoft.com/en-us/rest/api/azure/devops/core/teams/get?view=azure-devops-rest-7.0)

    ## PAT Permissions Required

    - **vso.project**:	Grants the ability to read projects and teams.


    :param builtins.str name: The name of the Team.
    :param builtins.str project_id: The Project ID.
    :param builtins.int top: The maximum number of teams to return. Defaults to `100`. This property is deprecated and will be removed in the feature
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['top'] = top
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azuredevops:index/getTeam:getTeam', __args__, opts=opts, typ=GetTeamResult).value

    return AwaitableGetTeamResult(
        administrators=pulumi.get(__ret__, 'administrators'),
        description=pulumi.get(__ret__, 'description'),
        descriptor=pulumi.get(__ret__, 'descriptor'),
        id=pulumi.get(__ret__, 'id'),
        members=pulumi.get(__ret__, 'members'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        top=pulumi.get(__ret__, 'top'))
def get_team_output(name: Optional[pulumi.Input[builtins.str]] = None,
                    project_id: Optional[pulumi.Input[builtins.str]] = None,
                    top: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTeamResult]:
    """
    Use this data source to access information about an existing Team in a Project within Azure DevOps.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azuredevops as azuredevops

    example_project = azuredevops.Project("example",
        name="Example Project",
        work_item_template="Agile",
        version_control="Git",
        visibility="private",
        description="Managed by Pulumi")
    example = azuredevops.get_team_output(project_id=example_project.id,
        name="Example Project Team")
    ```

    ## Relevant Links

    - [Azure DevOps Service REST API 7.0 - Teams - Get](https://docs.microsoft.com/en-us/rest/api/azure/devops/core/teams/get?view=azure-devops-rest-7.0)

    ## PAT Permissions Required

    - **vso.project**:	Grants the ability to read projects and teams.


    :param builtins.str name: The name of the Team.
    :param builtins.str project_id: The Project ID.
    :param builtins.int top: The maximum number of teams to return. Defaults to `100`. This property is deprecated and will be removed in the feature
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['top'] = top
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azuredevops:index/getTeam:getTeam', __args__, opts=opts, typ=GetTeamResult)
    return __ret__.apply(lambda __response__: GetTeamResult(
        administrators=pulumi.get(__response__, 'administrators'),
        description=pulumi.get(__response__, 'description'),
        descriptor=pulumi.get(__response__, 'descriptor'),
        id=pulumi.get(__response__, 'id'),
        members=pulumi.get(__response__, 'members'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id'),
        top=pulumi.get(__response__, 'top')))
