# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ServiceEndpointAwsArgs', 'ServiceEndpointAws']

@pulumi.input_type
class ServiceEndpointAwsArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[builtins.str],
                 service_endpoint_name: pulumi.Input[builtins.str],
                 access_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_session_name: Optional[pulumi.Input[builtins.str]] = None,
                 role_to_assume: Optional[pulumi.Input[builtins.str]] = None,
                 secret_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 session_token: Optional[pulumi.Input[builtins.str]] = None,
                 use_oidc: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a ServiceEndpointAws resource.
        :param pulumi.Input[builtins.str] project_id: The ID of the project.
        :param pulumi.Input[builtins.str] service_endpoint_name: The Service Endpoint name.
        :param pulumi.Input[builtins.str] access_key_id: The AWS access key ID for signing programmatic requests.
        :param pulumi.Input[builtins.str] external_id: A unique identifier that is used by third parties when assuming roles in their customers' accounts, aka cross-account role access.
        :param pulumi.Input[builtins.str] role_session_name: Optional identifier for the assumed role session.
        :param pulumi.Input[builtins.str] role_to_assume: The Amazon Resource Name (ARN) of the role to assume.
        :param pulumi.Input[builtins.str] secret_access_key: The AWS secret access key for signing programmatic requests.
        :param pulumi.Input[builtins.str] session_token: The AWS session token for signing programmatic requests.
        :param pulumi.Input[builtins.bool] use_oidc: Enable this to attempt getting credentials with OIDC token from Azure Devops.
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "service_endpoint_name", service_endpoint_name)
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if role_session_name is not None:
            pulumi.set(__self__, "role_session_name", role_session_name)
        if role_to_assume is not None:
            pulumi.set(__self__, "role_to_assume", role_to_assume)
        if secret_access_key is not None:
            pulumi.set(__self__, "secret_access_key", secret_access_key)
        if session_token is not None:
            pulumi.set(__self__, "session_token", session_token)
        if use_oidc is not None:
            pulumi.set(__self__, "use_oidc", use_oidc)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="serviceEndpointName")
    def service_endpoint_name(self) -> pulumi.Input[builtins.str]:
        """
        The Service Endpoint name.
        """
        return pulumi.get(self, "service_endpoint_name")

    @service_endpoint_name.setter
    def service_endpoint_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_endpoint_name", value)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS access key ID for signing programmatic requests.
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_key_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique identifier that is used by third parties when assuming roles in their customers' accounts, aka cross-account role access.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="roleSessionName")
    def role_session_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional identifier for the assumed role session.
        """
        return pulumi.get(self, "role_session_name")

    @role_session_name.setter
    def role_session_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_session_name", value)

    @property
    @pulumi.getter(name="roleToAssume")
    def role_to_assume(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the role to assume.
        """
        return pulumi.get(self, "role_to_assume")

    @role_to_assume.setter
    def role_to_assume(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_to_assume", value)

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS secret access key for signing programmatic requests.
        """
        return pulumi.get(self, "secret_access_key")

    @secret_access_key.setter
    def secret_access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_access_key", value)

    @property
    @pulumi.getter(name="sessionToken")
    def session_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS session token for signing programmatic requests.
        """
        return pulumi.get(self, "session_token")

    @session_token.setter
    def session_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "session_token", value)

    @property
    @pulumi.getter(name="useOidc")
    def use_oidc(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable this to attempt getting credentials with OIDC token from Azure Devops.
        """
        return pulumi.get(self, "use_oidc")

    @use_oidc.setter
    def use_oidc(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_oidc", value)


@pulumi.input_type
class _ServiceEndpointAwsState:
    def __init__(__self__, *,
                 access_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 authorization: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_session_name: Optional[pulumi.Input[builtins.str]] = None,
                 role_to_assume: Optional[pulumi.Input[builtins.str]] = None,
                 secret_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 service_endpoint_name: Optional[pulumi.Input[builtins.str]] = None,
                 session_token: Optional[pulumi.Input[builtins.str]] = None,
                 use_oidc: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ServiceEndpointAws resources.
        :param pulumi.Input[builtins.str] access_key_id: The AWS access key ID for signing programmatic requests.
        :param pulumi.Input[builtins.str] external_id: A unique identifier that is used by third parties when assuming roles in their customers' accounts, aka cross-account role access.
        :param pulumi.Input[builtins.str] project_id: The ID of the project.
        :param pulumi.Input[builtins.str] role_session_name: Optional identifier for the assumed role session.
        :param pulumi.Input[builtins.str] role_to_assume: The Amazon Resource Name (ARN) of the role to assume.
        :param pulumi.Input[builtins.str] secret_access_key: The AWS secret access key for signing programmatic requests.
        :param pulumi.Input[builtins.str] service_endpoint_name: The Service Endpoint name.
        :param pulumi.Input[builtins.str] session_token: The AWS session token for signing programmatic requests.
        :param pulumi.Input[builtins.bool] use_oidc: Enable this to attempt getting credentials with OIDC token from Azure Devops.
        """
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if role_session_name is not None:
            pulumi.set(__self__, "role_session_name", role_session_name)
        if role_to_assume is not None:
            pulumi.set(__self__, "role_to_assume", role_to_assume)
        if secret_access_key is not None:
            pulumi.set(__self__, "secret_access_key", secret_access_key)
        if service_endpoint_name is not None:
            pulumi.set(__self__, "service_endpoint_name", service_endpoint_name)
        if session_token is not None:
            pulumi.set(__self__, "session_token", session_token)
        if use_oidc is not None:
            pulumi.set(__self__, "use_oidc", use_oidc)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS access key ID for signing programmatic requests.
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_key_id", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique identifier that is used by third parties when assuming roles in their customers' accounts, aka cross-account role access.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="roleSessionName")
    def role_session_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional identifier for the assumed role session.
        """
        return pulumi.get(self, "role_session_name")

    @role_session_name.setter
    def role_session_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_session_name", value)

    @property
    @pulumi.getter(name="roleToAssume")
    def role_to_assume(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the role to assume.
        """
        return pulumi.get(self, "role_to_assume")

    @role_to_assume.setter
    def role_to_assume(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_to_assume", value)

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS secret access key for signing programmatic requests.
        """
        return pulumi.get(self, "secret_access_key")

    @secret_access_key.setter
    def secret_access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_access_key", value)

    @property
    @pulumi.getter(name="serviceEndpointName")
    def service_endpoint_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Service Endpoint name.
        """
        return pulumi.get(self, "service_endpoint_name")

    @service_endpoint_name.setter
    def service_endpoint_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_endpoint_name", value)

    @property
    @pulumi.getter(name="sessionToken")
    def session_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS session token for signing programmatic requests.
        """
        return pulumi.get(self, "session_token")

    @session_token.setter
    def session_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "session_token", value)

    @property
    @pulumi.getter(name="useOidc")
    def use_oidc(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable this to attempt getting credentials with OIDC token from Azure Devops.
        """
        return pulumi.get(self, "use_oidc")

    @use_oidc.setter
    def use_oidc(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_oidc", value)


@pulumi.type_token("azuredevops:index/serviceEndpointAws:ServiceEndpointAws")
class ServiceEndpointAws(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_session_name: Optional[pulumi.Input[builtins.str]] = None,
                 role_to_assume: Optional[pulumi.Input[builtins.str]] = None,
                 secret_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 service_endpoint_name: Optional[pulumi.Input[builtins.str]] = None,
                 session_token: Optional[pulumi.Input[builtins.str]] = None,
                 use_oidc: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Manages a AWS service endpoint within Azure DevOps. Using this service endpoint requires you to first install [AWS Toolkit for Azure DevOps](https://marketplace.visualstudio.com/items?itemName=AmazonWebServices.aws-vsts-tools).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_service_endpoint_aws = azuredevops.ServiceEndpointAws("example",
            project_id=example.id,
            service_endpoint_name="Example AWS",
            access_key_id="00000000-0000-0000-0000-000000000000",
            secret_access_key="accesskey",
            description="Managed by AzureDevOps")
        ```

        ## Relevant Links

        * [aws-toolkit-azure-devops](https://github.com/aws/aws-toolkit-azure-devops)
        * [Azure DevOps Service REST API 7.0 - Agent Pools](https://docs.microsoft.com/en-us/rest/api/azure/devops/serviceendpoint/endpoints?view=azure-devops-rest-7.0)

        ## Import

        Azure DevOps AWS Service Endpoint can be imported using **projectID/serviceEndpointID** or **projectName/serviceEndpointID**

        ```sh
        $ pulumi import azuredevops:index/serviceEndpointAws:ServiceEndpointAws  azuredevops_serviceendpoint_aws.example 00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_key_id: The AWS access key ID for signing programmatic requests.
        :param pulumi.Input[builtins.str] external_id: A unique identifier that is used by third parties when assuming roles in their customers' accounts, aka cross-account role access.
        :param pulumi.Input[builtins.str] project_id: The ID of the project.
        :param pulumi.Input[builtins.str] role_session_name: Optional identifier for the assumed role session.
        :param pulumi.Input[builtins.str] role_to_assume: The Amazon Resource Name (ARN) of the role to assume.
        :param pulumi.Input[builtins.str] secret_access_key: The AWS secret access key for signing programmatic requests.
        :param pulumi.Input[builtins.str] service_endpoint_name: The Service Endpoint name.
        :param pulumi.Input[builtins.str] session_token: The AWS session token for signing programmatic requests.
        :param pulumi.Input[builtins.bool] use_oidc: Enable this to attempt getting credentials with OIDC token from Azure Devops.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceEndpointAwsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a AWS service endpoint within Azure DevOps. Using this service endpoint requires you to first install [AWS Toolkit for Azure DevOps](https://marketplace.visualstudio.com/items?itemName=AmazonWebServices.aws-vsts-tools).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_service_endpoint_aws = azuredevops.ServiceEndpointAws("example",
            project_id=example.id,
            service_endpoint_name="Example AWS",
            access_key_id="00000000-0000-0000-0000-000000000000",
            secret_access_key="accesskey",
            description="Managed by AzureDevOps")
        ```

        ## Relevant Links

        * [aws-toolkit-azure-devops](https://github.com/aws/aws-toolkit-azure-devops)
        * [Azure DevOps Service REST API 7.0 - Agent Pools](https://docs.microsoft.com/en-us/rest/api/azure/devops/serviceendpoint/endpoints?view=azure-devops-rest-7.0)

        ## Import

        Azure DevOps AWS Service Endpoint can be imported using **projectID/serviceEndpointID** or **projectName/serviceEndpointID**

        ```sh
        $ pulumi import azuredevops:index/serviceEndpointAws:ServiceEndpointAws  azuredevops_serviceendpoint_aws.example 00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param ServiceEndpointAwsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceEndpointAwsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_session_name: Optional[pulumi.Input[builtins.str]] = None,
                 role_to_assume: Optional[pulumi.Input[builtins.str]] = None,
                 secret_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 service_endpoint_name: Optional[pulumi.Input[builtins.str]] = None,
                 session_token: Optional[pulumi.Input[builtins.str]] = None,
                 use_oidc: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceEndpointAwsArgs.__new__(ServiceEndpointAwsArgs)

            __props__.__dict__["access_key_id"] = access_key_id
            __props__.__dict__["description"] = description
            __props__.__dict__["external_id"] = external_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["role_session_name"] = role_session_name
            __props__.__dict__["role_to_assume"] = role_to_assume
            __props__.__dict__["secret_access_key"] = None if secret_access_key is None else pulumi.Output.secret(secret_access_key)
            if service_endpoint_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_endpoint_name'")
            __props__.__dict__["service_endpoint_name"] = service_endpoint_name
            __props__.__dict__["session_token"] = None if session_token is None else pulumi.Output.secret(session_token)
            __props__.__dict__["use_oidc"] = use_oidc
            __props__.__dict__["authorization"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secretAccessKey", "sessionToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ServiceEndpointAws, __self__).__init__(
            'azuredevops:index/serviceEndpointAws:ServiceEndpointAws',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key_id: Optional[pulumi.Input[builtins.str]] = None,
            authorization: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            external_id: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            role_session_name: Optional[pulumi.Input[builtins.str]] = None,
            role_to_assume: Optional[pulumi.Input[builtins.str]] = None,
            secret_access_key: Optional[pulumi.Input[builtins.str]] = None,
            service_endpoint_name: Optional[pulumi.Input[builtins.str]] = None,
            session_token: Optional[pulumi.Input[builtins.str]] = None,
            use_oidc: Optional[pulumi.Input[builtins.bool]] = None) -> 'ServiceEndpointAws':
        """
        Get an existing ServiceEndpointAws resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_key_id: The AWS access key ID for signing programmatic requests.
        :param pulumi.Input[builtins.str] external_id: A unique identifier that is used by third parties when assuming roles in their customers' accounts, aka cross-account role access.
        :param pulumi.Input[builtins.str] project_id: The ID of the project.
        :param pulumi.Input[builtins.str] role_session_name: Optional identifier for the assumed role session.
        :param pulumi.Input[builtins.str] role_to_assume: The Amazon Resource Name (ARN) of the role to assume.
        :param pulumi.Input[builtins.str] secret_access_key: The AWS secret access key for signing programmatic requests.
        :param pulumi.Input[builtins.str] service_endpoint_name: The Service Endpoint name.
        :param pulumi.Input[builtins.str] session_token: The AWS session token for signing programmatic requests.
        :param pulumi.Input[builtins.bool] use_oidc: Enable this to attempt getting credentials with OIDC token from Azure Devops.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceEndpointAwsState.__new__(_ServiceEndpointAwsState)

        __props__.__dict__["access_key_id"] = access_key_id
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["description"] = description
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["role_session_name"] = role_session_name
        __props__.__dict__["role_to_assume"] = role_to_assume
        __props__.__dict__["secret_access_key"] = secret_access_key
        __props__.__dict__["service_endpoint_name"] = service_endpoint_name
        __props__.__dict__["session_token"] = session_token
        __props__.__dict__["use_oidc"] = use_oidc
        return ServiceEndpointAws(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The AWS access key ID for signing programmatic requests.
        """
        return pulumi.get(self, "access_key_id")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A unique identifier that is used by third parties when assuming roles in their customers' accounts, aka cross-account role access.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="roleSessionName")
    def role_session_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional identifier for the assumed role session.
        """
        return pulumi.get(self, "role_session_name")

    @property
    @pulumi.getter(name="roleToAssume")
    def role_to_assume(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the role to assume.
        """
        return pulumi.get(self, "role_to_assume")

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The AWS secret access key for signing programmatic requests.
        """
        return pulumi.get(self, "secret_access_key")

    @property
    @pulumi.getter(name="serviceEndpointName")
    def service_endpoint_name(self) -> pulumi.Output[builtins.str]:
        """
        The Service Endpoint name.
        """
        return pulumi.get(self, "service_endpoint_name")

    @property
    @pulumi.getter(name="sessionToken")
    def session_token(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The AWS session token for signing programmatic requests.
        """
        return pulumi.get(self, "session_token")

    @property
    @pulumi.getter(name="useOidc")
    def use_oidc(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable this to attempt getting credentials with OIDC token from Azure Devops.
        """
        return pulumi.get(self, "use_oidc")

