# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ServicePrincipalEntitlementArgs', 'ServicePrincipalEntitlement']

@pulumi.input_type
class ServicePrincipalEntitlementArgs:
    def __init__(__self__, *,
                 origin_id: pulumi.Input[builtins.str],
                 account_license_type: Optional[pulumi.Input[builtins.str]] = None,
                 licensing_source: Optional[pulumi.Input[builtins.str]] = None,
                 origin: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ServicePrincipalEntitlement resource.
        :param pulumi.Input[builtins.str] origin_id: The Object ID of the service principal in Entra ID. Changing this forces a new Service Principal Entitlement to be created.
        :param pulumi.Input[builtins.str] account_license_type: Type of Account License. Possible values are: `advanced`, `earlyAdopter`, `express`, `none`, `professional`, or `stakeholder`. Defaults to `express`. In addition the value `basic` is allowed which is an alias for `express` and reflects the name of the `express` license used in the Azure DevOps web interface.
        :param pulumi.Input[builtins.str] licensing_source: The source of the licensing (e.g. Account. MSDN etc.) Possible values are: `account` (Default), `auto`, `msdn`, `none`, `profile`, `trial`
        :param pulumi.Input[builtins.str] origin: The type of source provider for the origin identifier.
        """
        pulumi.set(__self__, "origin_id", origin_id)
        if account_license_type is not None:
            pulumi.set(__self__, "account_license_type", account_license_type)
        if licensing_source is not None:
            pulumi.set(__self__, "licensing_source", licensing_source)
        if origin is not None:
            pulumi.set(__self__, "origin", origin)

    @property
    @pulumi.getter(name="originId")
    def origin_id(self) -> pulumi.Input[builtins.str]:
        """
        The Object ID of the service principal in Entra ID. Changing this forces a new Service Principal Entitlement to be created.
        """
        return pulumi.get(self, "origin_id")

    @origin_id.setter
    def origin_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "origin_id", value)

    @property
    @pulumi.getter(name="accountLicenseType")
    def account_license_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of Account License. Possible values are: `advanced`, `earlyAdopter`, `express`, `none`, `professional`, or `stakeholder`. Defaults to `express`. In addition the value `basic` is allowed which is an alias for `express` and reflects the name of the `express` license used in the Azure DevOps web interface.
        """
        return pulumi.get(self, "account_license_type")

    @account_license_type.setter
    def account_license_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_license_type", value)

    @property
    @pulumi.getter(name="licensingSource")
    def licensing_source(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The source of the licensing (e.g. Account. MSDN etc.) Possible values are: `account` (Default), `auto`, `msdn`, `none`, `profile`, `trial`
        """
        return pulumi.get(self, "licensing_source")

    @licensing_source.setter
    def licensing_source(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "licensing_source", value)

    @property
    @pulumi.getter
    def origin(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of source provider for the origin identifier.
        """
        return pulumi.get(self, "origin")

    @origin.setter
    def origin(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "origin", value)


@pulumi.input_type
class _ServicePrincipalEntitlementState:
    def __init__(__self__, *,
                 account_license_type: Optional[pulumi.Input[builtins.str]] = None,
                 descriptor: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 licensing_source: Optional[pulumi.Input[builtins.str]] = None,
                 origin: Optional[pulumi.Input[builtins.str]] = None,
                 origin_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServicePrincipalEntitlement resources.
        :param pulumi.Input[builtins.str] account_license_type: Type of Account License. Possible values are: `advanced`, `earlyAdopter`, `express`, `none`, `professional`, or `stakeholder`. Defaults to `express`. In addition the value `basic` is allowed which is an alias for `express` and reflects the name of the `express` license used in the Azure DevOps web interface.
        :param pulumi.Input[builtins.str] descriptor: The descriptor is the primary way to reference the graph subject while the system is running. This field will uniquely identify the user graph subject.
        :param pulumi.Input[builtins.str] display_name: The display name of service principal.
        :param pulumi.Input[builtins.str] licensing_source: The source of the licensing (e.g. Account. MSDN etc.) Possible values are: `account` (Default), `auto`, `msdn`, `none`, `profile`, `trial`
        :param pulumi.Input[builtins.str] origin: The type of source provider for the origin identifier.
        :param pulumi.Input[builtins.str] origin_id: The Object ID of the service principal in Entra ID. Changing this forces a new Service Principal Entitlement to be created.
        """
        if account_license_type is not None:
            pulumi.set(__self__, "account_license_type", account_license_type)
        if descriptor is not None:
            pulumi.set(__self__, "descriptor", descriptor)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if licensing_source is not None:
            pulumi.set(__self__, "licensing_source", licensing_source)
        if origin is not None:
            pulumi.set(__self__, "origin", origin)
        if origin_id is not None:
            pulumi.set(__self__, "origin_id", origin_id)

    @property
    @pulumi.getter(name="accountLicenseType")
    def account_license_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of Account License. Possible values are: `advanced`, `earlyAdopter`, `express`, `none`, `professional`, or `stakeholder`. Defaults to `express`. In addition the value `basic` is allowed which is an alias for `express` and reflects the name of the `express` license used in the Azure DevOps web interface.
        """
        return pulumi.get(self, "account_license_type")

    @account_license_type.setter
    def account_license_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_license_type", value)

    @property
    @pulumi.getter
    def descriptor(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The descriptor is the primary way to reference the graph subject while the system is running. This field will uniquely identify the user graph subject.
        """
        return pulumi.get(self, "descriptor")

    @descriptor.setter
    def descriptor(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "descriptor", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name of service principal.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="licensingSource")
    def licensing_source(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The source of the licensing (e.g. Account. MSDN etc.) Possible values are: `account` (Default), `auto`, `msdn`, `none`, `profile`, `trial`
        """
        return pulumi.get(self, "licensing_source")

    @licensing_source.setter
    def licensing_source(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "licensing_source", value)

    @property
    @pulumi.getter
    def origin(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of source provider for the origin identifier.
        """
        return pulumi.get(self, "origin")

    @origin.setter
    def origin(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "origin", value)

    @property
    @pulumi.getter(name="originId")
    def origin_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Object ID of the service principal in Entra ID. Changing this forces a new Service Principal Entitlement to be created.
        """
        return pulumi.get(self, "origin_id")

    @origin_id.setter
    def origin_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "origin_id", value)


@pulumi.type_token("azuredevops:index/servicePrincipalEntitlement:ServicePrincipalEntitlement")
class ServicePrincipalEntitlement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_license_type: Optional[pulumi.Input[builtins.str]] = None,
                 licensing_source: Optional[pulumi.Input[builtins.str]] = None,
                 origin: Optional[pulumi.Input[builtins.str]] = None,
                 origin_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Service Principal Entitlement.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.ServicePrincipalEntitlement("example", origin_id="00000000-0000-0000-0000-000000000000")
        ```

        ## Import

        Service Principal Entitlements can be imported using the `resource id`.

        The `resource id` can be found using DEV Tools in the `Users` section of the ADO organization.

        ```sh
        $ pulumi import azuredevops:index/servicePrincipalEntitlement:ServicePrincipalEntitlement example 8480c6eb-ce60-47e9-88df-eca3c801638b
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_license_type: Type of Account License. Possible values are: `advanced`, `earlyAdopter`, `express`, `none`, `professional`, or `stakeholder`. Defaults to `express`. In addition the value `basic` is allowed which is an alias for `express` and reflects the name of the `express` license used in the Azure DevOps web interface.
        :param pulumi.Input[builtins.str] licensing_source: The source of the licensing (e.g. Account. MSDN etc.) Possible values are: `account` (Default), `auto`, `msdn`, `none`, `profile`, `trial`
        :param pulumi.Input[builtins.str] origin: The type of source provider for the origin identifier.
        :param pulumi.Input[builtins.str] origin_id: The Object ID of the service principal in Entra ID. Changing this forces a new Service Principal Entitlement to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServicePrincipalEntitlementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Service Principal Entitlement.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.ServicePrincipalEntitlement("example", origin_id="00000000-0000-0000-0000-000000000000")
        ```

        ## Import

        Service Principal Entitlements can be imported using the `resource id`.

        The `resource id` can be found using DEV Tools in the `Users` section of the ADO organization.

        ```sh
        $ pulumi import azuredevops:index/servicePrincipalEntitlement:ServicePrincipalEntitlement example 8480c6eb-ce60-47e9-88df-eca3c801638b
        ```

        :param str resource_name: The name of the resource.
        :param ServicePrincipalEntitlementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServicePrincipalEntitlementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_license_type: Optional[pulumi.Input[builtins.str]] = None,
                 licensing_source: Optional[pulumi.Input[builtins.str]] = None,
                 origin: Optional[pulumi.Input[builtins.str]] = None,
                 origin_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServicePrincipalEntitlementArgs.__new__(ServicePrincipalEntitlementArgs)

            __props__.__dict__["account_license_type"] = account_license_type
            __props__.__dict__["licensing_source"] = licensing_source
            __props__.__dict__["origin"] = origin
            if origin_id is None and not opts.urn:
                raise TypeError("Missing required property 'origin_id'")
            __props__.__dict__["origin_id"] = origin_id
            __props__.__dict__["descriptor"] = None
            __props__.__dict__["display_name"] = None
        super(ServicePrincipalEntitlement, __self__).__init__(
            'azuredevops:index/servicePrincipalEntitlement:ServicePrincipalEntitlement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_license_type: Optional[pulumi.Input[builtins.str]] = None,
            descriptor: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            licensing_source: Optional[pulumi.Input[builtins.str]] = None,
            origin: Optional[pulumi.Input[builtins.str]] = None,
            origin_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ServicePrincipalEntitlement':
        """
        Get an existing ServicePrincipalEntitlement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_license_type: Type of Account License. Possible values are: `advanced`, `earlyAdopter`, `express`, `none`, `professional`, or `stakeholder`. Defaults to `express`. In addition the value `basic` is allowed which is an alias for `express` and reflects the name of the `express` license used in the Azure DevOps web interface.
        :param pulumi.Input[builtins.str] descriptor: The descriptor is the primary way to reference the graph subject while the system is running. This field will uniquely identify the user graph subject.
        :param pulumi.Input[builtins.str] display_name: The display name of service principal.
        :param pulumi.Input[builtins.str] licensing_source: The source of the licensing (e.g. Account. MSDN etc.) Possible values are: `account` (Default), `auto`, `msdn`, `none`, `profile`, `trial`
        :param pulumi.Input[builtins.str] origin: The type of source provider for the origin identifier.
        :param pulumi.Input[builtins.str] origin_id: The Object ID of the service principal in Entra ID. Changing this forces a new Service Principal Entitlement to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServicePrincipalEntitlementState.__new__(_ServicePrincipalEntitlementState)

        __props__.__dict__["account_license_type"] = account_license_type
        __props__.__dict__["descriptor"] = descriptor
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["licensing_source"] = licensing_source
        __props__.__dict__["origin"] = origin
        __props__.__dict__["origin_id"] = origin_id
        return ServicePrincipalEntitlement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountLicenseType")
    def account_license_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Type of Account License. Possible values are: `advanced`, `earlyAdopter`, `express`, `none`, `professional`, or `stakeholder`. Defaults to `express`. In addition the value `basic` is allowed which is an alias for `express` and reflects the name of the `express` license used in the Azure DevOps web interface.
        """
        return pulumi.get(self, "account_license_type")

    @property
    @pulumi.getter
    def descriptor(self) -> pulumi.Output[builtins.str]:
        """
        The descriptor is the primary way to reference the graph subject while the system is running. This field will uniquely identify the user graph subject.
        """
        return pulumi.get(self, "descriptor")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The display name of service principal.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="licensingSource")
    def licensing_source(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The source of the licensing (e.g. Account. MSDN etc.) Possible values are: `account` (Default), `auto`, `msdn`, `none`, `profile`, `trial`
        """
        return pulumi.get(self, "licensing_source")

    @property
    @pulumi.getter
    def origin(self) -> pulumi.Output[builtins.str]:
        """
        The type of source provider for the origin identifier.
        """
        return pulumi.get(self, "origin")

    @property
    @pulumi.getter(name="originId")
    def origin_id(self) -> pulumi.Output[builtins.str]:
        """
        The Object ID of the service principal in Entra ID. Changing this forces a new Service Principal Entitlement to be created.
        """
        return pulumi.get(self, "origin_id")

