# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ServiceendpointCheckmarxOneArgs', 'ServiceendpointCheckmarxOne']

@pulumi.input_type
class ServiceendpointCheckmarxOneArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[builtins.str],
                 server_url: pulumi.Input[builtins.str],
                 service_endpoint_name: pulumi.Input[builtins.str],
                 api_key: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_url: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ServiceendpointCheckmarxOne resource.
        :param pulumi.Input[builtins.str] project_id: The ID of the project.
        :param pulumi.Input[builtins.str] server_url: The Server URL of the Checkmarx One Service.
        :param pulumi.Input[builtins.str] service_endpoint_name: The Service Endpoint name.
        :param pulumi.Input[builtins.str] api_key: The account of the Checkmarx One. Conflict with `client_id` and `client_secret`.
        :param pulumi.Input[builtins.str] authorization_url: The URL of Checkmarx Authorization. Used when using `client_id` and `client_secret` authorization.
        :param pulumi.Input[builtins.str] client_id: The Client ID of the Checkmarx One. Conflict with `api_key`
        :param pulumi.Input[builtins.str] client_secret: The Client Secret of the Checkmarx One. Conflict with `api_key`
               
               > **Note** At least one of `api_key` and `client_id`, `client_secret` must be set
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "server_url", server_url)
        pulumi.set(__self__, "service_endpoint_name", service_endpoint_name)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if authorization_url is not None:
            pulumi.set(__self__, "authorization_url", authorization_url)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> pulumi.Input[builtins.str]:
        """
        The Server URL of the Checkmarx One Service.
        """
        return pulumi.get(self, "server_url")

    @server_url.setter
    def server_url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "server_url", value)

    @property
    @pulumi.getter(name="serviceEndpointName")
    def service_endpoint_name(self) -> pulumi.Input[builtins.str]:
        """
        The Service Endpoint name.
        """
        return pulumi.get(self, "service_endpoint_name")

    @service_endpoint_name.setter
    def service_endpoint_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_endpoint_name", value)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The account of the Checkmarx One. Conflict with `client_id` and `client_secret`.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="authorizationUrl")
    def authorization_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of Checkmarx Authorization. Used when using `client_id` and `client_secret` authorization.
        """
        return pulumi.get(self, "authorization_url")

    @authorization_url.setter
    def authorization_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization_url", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Client ID of the Checkmarx One. Conflict with `api_key`
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Client Secret of the Checkmarx One. Conflict with `api_key`

        > **Note** At least one of `api_key` and `client_id`, `client_secret` must be set
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _ServiceendpointCheckmarxOneState:
    def __init__(__self__, *,
                 api_key: Optional[pulumi.Input[builtins.str]] = None,
                 authorization: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 authorization_url: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 server_url: Optional[pulumi.Input[builtins.str]] = None,
                 service_endpoint_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceendpointCheckmarxOne resources.
        :param pulumi.Input[builtins.str] api_key: The account of the Checkmarx One. Conflict with `client_id` and `client_secret`.
        :param pulumi.Input[builtins.str] authorization_url: The URL of Checkmarx Authorization. Used when using `client_id` and `client_secret` authorization.
        :param pulumi.Input[builtins.str] client_id: The Client ID of the Checkmarx One. Conflict with `api_key`
        :param pulumi.Input[builtins.str] client_secret: The Client Secret of the Checkmarx One. Conflict with `api_key`
               
               > **Note** At least one of `api_key` and `client_id`, `client_secret` must be set
        :param pulumi.Input[builtins.str] project_id: The ID of the project.
        :param pulumi.Input[builtins.str] server_url: The Server URL of the Checkmarx One Service.
        :param pulumi.Input[builtins.str] service_endpoint_name: The Service Endpoint name.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if authorization_url is not None:
            pulumi.set(__self__, "authorization_url", authorization_url)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if server_url is not None:
            pulumi.set(__self__, "server_url", server_url)
        if service_endpoint_name is not None:
            pulumi.set(__self__, "service_endpoint_name", service_endpoint_name)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The account of the Checkmarx One. Conflict with `client_id` and `client_secret`.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="authorizationUrl")
    def authorization_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of Checkmarx Authorization. Used when using `client_id` and `client_secret` authorization.
        """
        return pulumi.get(self, "authorization_url")

    @authorization_url.setter
    def authorization_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization_url", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Client ID of the Checkmarx One. Conflict with `api_key`
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Client Secret of the Checkmarx One. Conflict with `api_key`

        > **Note** At least one of `api_key` and `client_id`, `client_secret` must be set
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Server URL of the Checkmarx One Service.
        """
        return pulumi.get(self, "server_url")

    @server_url.setter
    def server_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_url", value)

    @property
    @pulumi.getter(name="serviceEndpointName")
    def service_endpoint_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Service Endpoint name.
        """
        return pulumi.get(self, "service_endpoint_name")

    @service_endpoint_name.setter
    def service_endpoint_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_endpoint_name", value)


@pulumi.type_token("azuredevops:index/serviceendpointCheckmarxOne:ServiceendpointCheckmarxOne")
class ServiceendpointCheckmarxOne(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_url: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 server_url: Optional[pulumi.Input[builtins.str]] = None,
                 service_endpoint_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Checkmarx One service endpoint within Azure DevOps. Using this service endpoint requires you to install: [Checkmarx AST](https://marketplace.visualstudio.com/items?itemName=checkmarx.checkmarx-ast-azure-plugin)

        ## Example Usage

        ### Authorize with API Key

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_serviceendpoint_checkmarx_one = azuredevops.ServiceendpointCheckmarxOne("example",
            project_id=example.id,
            service_endpoint_name="Example Checkmarx One",
            server_url="https://server.com",
            api_key="apikey")
        ```

        ### Authorize with Client ID and Secret

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_serviceendpoint_checkmarx_one = azuredevops.ServiceendpointCheckmarxOne("example",
            project_id=example.id,
            service_endpoint_name="Example Checkmarx One",
            server_url="https://server.com",
            client_id="clientid",
            client_secret="secret",
            authorization_url="https://authurl.com")
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.0 - Service Endpoints](https://docs.microsoft.com/en-us/rest/api/azure/devops/serviceendpoint/endpoints?view=azure-devops-rest-7.0)

        ## Import

        Azure DevOps Service Endpoint Check Marx One can be imported using **projectID/serviceEndpointID** or **projectName/serviceEndpointID**

        ```sh
        $ pulumi import azuredevops:index/serviceendpointCheckmarxOne:ServiceendpointCheckmarxOne example 00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_key: The account of the Checkmarx One. Conflict with `client_id` and `client_secret`.
        :param pulumi.Input[builtins.str] authorization_url: The URL of Checkmarx Authorization. Used when using `client_id` and `client_secret` authorization.
        :param pulumi.Input[builtins.str] client_id: The Client ID of the Checkmarx One. Conflict with `api_key`
        :param pulumi.Input[builtins.str] client_secret: The Client Secret of the Checkmarx One. Conflict with `api_key`
               
               > **Note** At least one of `api_key` and `client_id`, `client_secret` must be set
        :param pulumi.Input[builtins.str] project_id: The ID of the project.
        :param pulumi.Input[builtins.str] server_url: The Server URL of the Checkmarx One Service.
        :param pulumi.Input[builtins.str] service_endpoint_name: The Service Endpoint name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceendpointCheckmarxOneArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Checkmarx One service endpoint within Azure DevOps. Using this service endpoint requires you to install: [Checkmarx AST](https://marketplace.visualstudio.com/items?itemName=checkmarx.checkmarx-ast-azure-plugin)

        ## Example Usage

        ### Authorize with API Key

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_serviceendpoint_checkmarx_one = azuredevops.ServiceendpointCheckmarxOne("example",
            project_id=example.id,
            service_endpoint_name="Example Checkmarx One",
            server_url="https://server.com",
            api_key="apikey")
        ```

        ### Authorize with Client ID and Secret

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_serviceendpoint_checkmarx_one = azuredevops.ServiceendpointCheckmarxOne("example",
            project_id=example.id,
            service_endpoint_name="Example Checkmarx One",
            server_url="https://server.com",
            client_id="clientid",
            client_secret="secret",
            authorization_url="https://authurl.com")
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.0 - Service Endpoints](https://docs.microsoft.com/en-us/rest/api/azure/devops/serviceendpoint/endpoints?view=azure-devops-rest-7.0)

        ## Import

        Azure DevOps Service Endpoint Check Marx One can be imported using **projectID/serviceEndpointID** or **projectName/serviceEndpointID**

        ```sh
        $ pulumi import azuredevops:index/serviceendpointCheckmarxOne:ServiceendpointCheckmarxOne example 00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param ServiceendpointCheckmarxOneArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceendpointCheckmarxOneArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_url: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 server_url: Optional[pulumi.Input[builtins.str]] = None,
                 service_endpoint_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceendpointCheckmarxOneArgs.__new__(ServiceendpointCheckmarxOneArgs)

            __props__.__dict__["api_key"] = None if api_key is None else pulumi.Output.secret(api_key)
            __props__.__dict__["authorization_url"] = authorization_url
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["client_secret"] = None if client_secret is None else pulumi.Output.secret(client_secret)
            __props__.__dict__["description"] = description
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if server_url is None and not opts.urn:
                raise TypeError("Missing required property 'server_url'")
            __props__.__dict__["server_url"] = server_url
            if service_endpoint_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_endpoint_name'")
            __props__.__dict__["service_endpoint_name"] = service_endpoint_name
            __props__.__dict__["authorization"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apiKey", "clientSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ServiceendpointCheckmarxOne, __self__).__init__(
            'azuredevops:index/serviceendpointCheckmarxOne:ServiceendpointCheckmarxOne',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_key: Optional[pulumi.Input[builtins.str]] = None,
            authorization: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            authorization_url: Optional[pulumi.Input[builtins.str]] = None,
            client_id: Optional[pulumi.Input[builtins.str]] = None,
            client_secret: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            server_url: Optional[pulumi.Input[builtins.str]] = None,
            service_endpoint_name: Optional[pulumi.Input[builtins.str]] = None) -> 'ServiceendpointCheckmarxOne':
        """
        Get an existing ServiceendpointCheckmarxOne resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_key: The account of the Checkmarx One. Conflict with `client_id` and `client_secret`.
        :param pulumi.Input[builtins.str] authorization_url: The URL of Checkmarx Authorization. Used when using `client_id` and `client_secret` authorization.
        :param pulumi.Input[builtins.str] client_id: The Client ID of the Checkmarx One. Conflict with `api_key`
        :param pulumi.Input[builtins.str] client_secret: The Client Secret of the Checkmarx One. Conflict with `api_key`
               
               > **Note** At least one of `api_key` and `client_id`, `client_secret` must be set
        :param pulumi.Input[builtins.str] project_id: The ID of the project.
        :param pulumi.Input[builtins.str] server_url: The Server URL of the Checkmarx One Service.
        :param pulumi.Input[builtins.str] service_endpoint_name: The Service Endpoint name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceendpointCheckmarxOneState.__new__(_ServiceendpointCheckmarxOneState)

        __props__.__dict__["api_key"] = api_key
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["authorization_url"] = authorization_url
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["description"] = description
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["server_url"] = server_url
        __props__.__dict__["service_endpoint_name"] = service_endpoint_name
        return ServiceendpointCheckmarxOne(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The account of the Checkmarx One. Conflict with `client_id` and `client_secret`.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="authorizationUrl")
    def authorization_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The URL of Checkmarx Authorization. Used when using `client_id` and `client_secret` authorization.
        """
        return pulumi.get(self, "authorization_url")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Client ID of the Checkmarx One. Conflict with `api_key`
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Client Secret of the Checkmarx One. Conflict with `api_key`

        > **Note** At least one of `api_key` and `client_id`, `client_secret` must be set
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> pulumi.Output[builtins.str]:
        """
        The Server URL of the Checkmarx One Service.
        """
        return pulumi.get(self, "server_url")

    @property
    @pulumi.getter(name="serviceEndpointName")
    def service_endpoint_name(self) -> pulumi.Output[builtins.str]:
        """
        The Service Endpoint name.
        """
        return pulumi.get(self, "service_endpoint_name")

