# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceendpointExternaltfsArgs', 'ServiceendpointExternaltfs']

@pulumi.input_type
class ServiceendpointExternaltfsArgs:
    def __init__(__self__, *,
                 auth_personal: pulumi.Input['ServiceendpointExternaltfsAuthPersonalArgs'],
                 connection_url: pulumi.Input[builtins.str],
                 project_id: pulumi.Input[builtins.str],
                 service_endpoint_name: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ServiceendpointExternaltfs resource.
        :param pulumi.Input['ServiceendpointExternaltfsAuthPersonalArgs'] auth_personal: An `auth_personal` block as documented below. Allows connecting using a personal access token.
        :param pulumi.Input[builtins.str] connection_url: Azure DevOps Organization or TFS Project Collection Url.
        :param pulumi.Input[builtins.str] project_id: The ID of the project.
        :param pulumi.Input[builtins.str] service_endpoint_name: The Service Endpoint name.
        """
        pulumi.set(__self__, "auth_personal", auth_personal)
        pulumi.set(__self__, "connection_url", connection_url)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "service_endpoint_name", service_endpoint_name)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="authPersonal")
    def auth_personal(self) -> pulumi.Input['ServiceendpointExternaltfsAuthPersonalArgs']:
        """
        An `auth_personal` block as documented below. Allows connecting using a personal access token.
        """
        return pulumi.get(self, "auth_personal")

    @auth_personal.setter
    def auth_personal(self, value: pulumi.Input['ServiceendpointExternaltfsAuthPersonalArgs']):
        pulumi.set(self, "auth_personal", value)

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> pulumi.Input[builtins.str]:
        """
        Azure DevOps Organization or TFS Project Collection Url.
        """
        return pulumi.get(self, "connection_url")

    @connection_url.setter
    def connection_url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "connection_url", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="serviceEndpointName")
    def service_endpoint_name(self) -> pulumi.Input[builtins.str]:
        """
        The Service Endpoint name.
        """
        return pulumi.get(self, "service_endpoint_name")

    @service_endpoint_name.setter
    def service_endpoint_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_endpoint_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _ServiceendpointExternaltfsState:
    def __init__(__self__, *,
                 auth_personal: Optional[pulumi.Input['ServiceendpointExternaltfsAuthPersonalArgs']] = None,
                 authorization: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 connection_url: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_endpoint_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceendpointExternaltfs resources.
        :param pulumi.Input['ServiceendpointExternaltfsAuthPersonalArgs'] auth_personal: An `auth_personal` block as documented below. Allows connecting using a personal access token.
        :param pulumi.Input[builtins.str] connection_url: Azure DevOps Organization or TFS Project Collection Url.
        :param pulumi.Input[builtins.str] project_id: The ID of the project.
        :param pulumi.Input[builtins.str] service_endpoint_name: The Service Endpoint name.
        """
        if auth_personal is not None:
            pulumi.set(__self__, "auth_personal", auth_personal)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if service_endpoint_name is not None:
            pulumi.set(__self__, "service_endpoint_name", service_endpoint_name)

    @property
    @pulumi.getter(name="authPersonal")
    def auth_personal(self) -> Optional[pulumi.Input['ServiceendpointExternaltfsAuthPersonalArgs']]:
        """
        An `auth_personal` block as documented below. Allows connecting using a personal access token.
        """
        return pulumi.get(self, "auth_personal")

    @auth_personal.setter
    def auth_personal(self, value: Optional[pulumi.Input['ServiceendpointExternaltfsAuthPersonalArgs']]):
        pulumi.set(self, "auth_personal", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Azure DevOps Organization or TFS Project Collection Url.
        """
        return pulumi.get(self, "connection_url")

    @connection_url.setter
    def connection_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_url", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="serviceEndpointName")
    def service_endpoint_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Service Endpoint name.
        """
        return pulumi.get(self, "service_endpoint_name")

    @service_endpoint_name.setter
    def service_endpoint_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_endpoint_name", value)


@pulumi.type_token("azuredevops:index/serviceendpointExternaltfs:ServiceendpointExternaltfs")
class ServiceendpointExternaltfs(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_personal: Optional[pulumi.Input[Union['ServiceendpointExternaltfsAuthPersonalArgs', 'ServiceendpointExternaltfsAuthPersonalArgsDict']]] = None,
                 connection_url: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_endpoint_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure Repository/Team Foundation Server service endpoint within Azure DevOps.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_serviceendpoint_externaltfs = azuredevops.ServiceendpointExternaltfs("example",
            project_id=example.id,
            service_endpoint_name="Example External TFS Name",
            connection_url="https://dev.azure.com/myorganization",
            description="Managed by Pulumi",
            auth_personal={
                "personal_access_token": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            })
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.0 - Service Endpoints](https://docs.microsoft.com/en-us/rest/api/azure/devops/serviceendpoint/endpoints?view=azure-devops-rest-7.0)

        ## Import

        Azure DevOps Azure Repository/Team Foundation Server Service Endpoint can be imported using **projectID/serviceEndpointID** or **projectName/serviceEndpointID**

        ```sh
        $ pulumi import azuredevops:index/serviceendpointExternaltfs:ServiceendpointExternaltfs example 00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServiceendpointExternaltfsAuthPersonalArgs', 'ServiceendpointExternaltfsAuthPersonalArgsDict']] auth_personal: An `auth_personal` block as documented below. Allows connecting using a personal access token.
        :param pulumi.Input[builtins.str] connection_url: Azure DevOps Organization or TFS Project Collection Url.
        :param pulumi.Input[builtins.str] project_id: The ID of the project.
        :param pulumi.Input[builtins.str] service_endpoint_name: The Service Endpoint name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceendpointExternaltfsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Repository/Team Foundation Server service endpoint within Azure DevOps.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_serviceendpoint_externaltfs = azuredevops.ServiceendpointExternaltfs("example",
            project_id=example.id,
            service_endpoint_name="Example External TFS Name",
            connection_url="https://dev.azure.com/myorganization",
            description="Managed by Pulumi",
            auth_personal={
                "personal_access_token": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            })
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.0 - Service Endpoints](https://docs.microsoft.com/en-us/rest/api/azure/devops/serviceendpoint/endpoints?view=azure-devops-rest-7.0)

        ## Import

        Azure DevOps Azure Repository/Team Foundation Server Service Endpoint can be imported using **projectID/serviceEndpointID** or **projectName/serviceEndpointID**

        ```sh
        $ pulumi import azuredevops:index/serviceendpointExternaltfs:ServiceendpointExternaltfs example 00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param ServiceendpointExternaltfsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceendpointExternaltfsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_personal: Optional[pulumi.Input[Union['ServiceendpointExternaltfsAuthPersonalArgs', 'ServiceendpointExternaltfsAuthPersonalArgsDict']]] = None,
                 connection_url: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_endpoint_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceendpointExternaltfsArgs.__new__(ServiceendpointExternaltfsArgs)

            if auth_personal is None and not opts.urn:
                raise TypeError("Missing required property 'auth_personal'")
            __props__.__dict__["auth_personal"] = auth_personal
            if connection_url is None and not opts.urn:
                raise TypeError("Missing required property 'connection_url'")
            __props__.__dict__["connection_url"] = connection_url
            __props__.__dict__["description"] = description
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if service_endpoint_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_endpoint_name'")
            __props__.__dict__["service_endpoint_name"] = service_endpoint_name
            __props__.__dict__["authorization"] = None
        super(ServiceendpointExternaltfs, __self__).__init__(
            'azuredevops:index/serviceendpointExternaltfs:ServiceendpointExternaltfs',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth_personal: Optional[pulumi.Input[Union['ServiceendpointExternaltfsAuthPersonalArgs', 'ServiceendpointExternaltfsAuthPersonalArgsDict']]] = None,
            authorization: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            connection_url: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            service_endpoint_name: Optional[pulumi.Input[builtins.str]] = None) -> 'ServiceendpointExternaltfs':
        """
        Get an existing ServiceendpointExternaltfs resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServiceendpointExternaltfsAuthPersonalArgs', 'ServiceendpointExternaltfsAuthPersonalArgsDict']] auth_personal: An `auth_personal` block as documented below. Allows connecting using a personal access token.
        :param pulumi.Input[builtins.str] connection_url: Azure DevOps Organization or TFS Project Collection Url.
        :param pulumi.Input[builtins.str] project_id: The ID of the project.
        :param pulumi.Input[builtins.str] service_endpoint_name: The Service Endpoint name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceendpointExternaltfsState.__new__(_ServiceendpointExternaltfsState)

        __props__.__dict__["auth_personal"] = auth_personal
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["connection_url"] = connection_url
        __props__.__dict__["description"] = description
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["service_endpoint_name"] = service_endpoint_name
        return ServiceendpointExternaltfs(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authPersonal")
    def auth_personal(self) -> pulumi.Output['outputs.ServiceendpointExternaltfsAuthPersonal']:
        """
        An `auth_personal` block as documented below. Allows connecting using a personal access token.
        """
        return pulumi.get(self, "auth_personal")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> pulumi.Output[builtins.str]:
        """
        Azure DevOps Organization or TFS Project Collection Url.
        """
        return pulumi.get(self, "connection_url")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="serviceEndpointName")
    def service_endpoint_name(self) -> pulumi.Output[builtins.str]:
        """
        The Service Endpoint name.
        """
        return pulumi.get(self, "service_endpoint_name")

