# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceendpointOpenshiftArgs', 'ServiceendpointOpenshift']

@pulumi.input_type
class ServiceendpointOpenshiftArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[builtins.str],
                 service_endpoint_name: pulumi.Input[builtins.str],
                 accept_untrusted_certs: Optional[pulumi.Input[builtins.bool]] = None,
                 auth_basic: Optional[pulumi.Input['ServiceendpointOpenshiftAuthBasicArgs']] = None,
                 auth_none: Optional[pulumi.Input['ServiceendpointOpenshiftAuthNoneArgs']] = None,
                 auth_token: Optional[pulumi.Input['ServiceendpointOpenshiftAuthTokenArgs']] = None,
                 certificate_authority_file: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 server_url: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ServiceendpointOpenshift resource.
        :param pulumi.Input[builtins.str] project_id: The ID of the project.
        :param pulumi.Input[builtins.str] service_endpoint_name: The Service Endpoint name.
        :param pulumi.Input[builtins.bool] accept_untrusted_certs: Set this option to allow clients to accept a self-signed certificate. Available when using `auth_basic` or `auth_token` authorization.
        :param pulumi.Input['ServiceendpointOpenshiftAuthBasicArgs'] auth_basic: An `auth_basic` block as documented below.
        :param pulumi.Input['ServiceendpointOpenshiftAuthNoneArgs'] auth_none: An `auth_none` block as documented below.
        :param pulumi.Input['ServiceendpointOpenshiftAuthTokenArgs'] auth_token: An `auth_token` block as documented below.
        :param pulumi.Input[builtins.str] certificate_authority_file: The path to a certificate authority file to correctly and securely authenticates with an OpenShift server that uses HTTPS. Available when using `auth_basic` or `auth_token` authorization.
        :param pulumi.Input[builtins.str] server_url: The URL for the OpenShift cluster to connect to.
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "service_endpoint_name", service_endpoint_name)
        if accept_untrusted_certs is not None:
            pulumi.set(__self__, "accept_untrusted_certs", accept_untrusted_certs)
        if auth_basic is not None:
            pulumi.set(__self__, "auth_basic", auth_basic)
        if auth_none is not None:
            pulumi.set(__self__, "auth_none", auth_none)
        if auth_token is not None:
            pulumi.set(__self__, "auth_token", auth_token)
        if certificate_authority_file is not None:
            pulumi.set(__self__, "certificate_authority_file", certificate_authority_file)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if server_url is not None:
            pulumi.set(__self__, "server_url", server_url)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="serviceEndpointName")
    def service_endpoint_name(self) -> pulumi.Input[builtins.str]:
        """
        The Service Endpoint name.
        """
        return pulumi.get(self, "service_endpoint_name")

    @service_endpoint_name.setter
    def service_endpoint_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_endpoint_name", value)

    @property
    @pulumi.getter(name="acceptUntrustedCerts")
    def accept_untrusted_certs(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set this option to allow clients to accept a self-signed certificate. Available when using `auth_basic` or `auth_token` authorization.
        """
        return pulumi.get(self, "accept_untrusted_certs")

    @accept_untrusted_certs.setter
    def accept_untrusted_certs(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "accept_untrusted_certs", value)

    @property
    @pulumi.getter(name="authBasic")
    def auth_basic(self) -> Optional[pulumi.Input['ServiceendpointOpenshiftAuthBasicArgs']]:
        """
        An `auth_basic` block as documented below.
        """
        return pulumi.get(self, "auth_basic")

    @auth_basic.setter
    def auth_basic(self, value: Optional[pulumi.Input['ServiceendpointOpenshiftAuthBasicArgs']]):
        pulumi.set(self, "auth_basic", value)

    @property
    @pulumi.getter(name="authNone")
    def auth_none(self) -> Optional[pulumi.Input['ServiceendpointOpenshiftAuthNoneArgs']]:
        """
        An `auth_none` block as documented below.
        """
        return pulumi.get(self, "auth_none")

    @auth_none.setter
    def auth_none(self, value: Optional[pulumi.Input['ServiceendpointOpenshiftAuthNoneArgs']]):
        pulumi.set(self, "auth_none", value)

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional[pulumi.Input['ServiceendpointOpenshiftAuthTokenArgs']]:
        """
        An `auth_token` block as documented below.
        """
        return pulumi.get(self, "auth_token")

    @auth_token.setter
    def auth_token(self, value: Optional[pulumi.Input['ServiceendpointOpenshiftAuthTokenArgs']]):
        pulumi.set(self, "auth_token", value)

    @property
    @pulumi.getter(name="certificateAuthorityFile")
    def certificate_authority_file(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path to a certificate authority file to correctly and securely authenticates with an OpenShift server that uses HTTPS. Available when using `auth_basic` or `auth_token` authorization.
        """
        return pulumi.get(self, "certificate_authority_file")

    @certificate_authority_file.setter
    def certificate_authority_file(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_authority_file", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL for the OpenShift cluster to connect to.
        """
        return pulumi.get(self, "server_url")

    @server_url.setter
    def server_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_url", value)


@pulumi.input_type
class _ServiceendpointOpenshiftState:
    def __init__(__self__, *,
                 accept_untrusted_certs: Optional[pulumi.Input[builtins.bool]] = None,
                 auth_basic: Optional[pulumi.Input['ServiceendpointOpenshiftAuthBasicArgs']] = None,
                 auth_none: Optional[pulumi.Input['ServiceendpointOpenshiftAuthNoneArgs']] = None,
                 auth_token: Optional[pulumi.Input['ServiceendpointOpenshiftAuthTokenArgs']] = None,
                 authorization: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 certificate_authority_file: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 server_url: Optional[pulumi.Input[builtins.str]] = None,
                 service_endpoint_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceendpointOpenshift resources.
        :param pulumi.Input[builtins.bool] accept_untrusted_certs: Set this option to allow clients to accept a self-signed certificate. Available when using `auth_basic` or `auth_token` authorization.
        :param pulumi.Input['ServiceendpointOpenshiftAuthBasicArgs'] auth_basic: An `auth_basic` block as documented below.
        :param pulumi.Input['ServiceendpointOpenshiftAuthNoneArgs'] auth_none: An `auth_none` block as documented below.
        :param pulumi.Input['ServiceendpointOpenshiftAuthTokenArgs'] auth_token: An `auth_token` block as documented below.
        :param pulumi.Input[builtins.str] certificate_authority_file: The path to a certificate authority file to correctly and securely authenticates with an OpenShift server that uses HTTPS. Available when using `auth_basic` or `auth_token` authorization.
        :param pulumi.Input[builtins.str] project_id: The ID of the project.
        :param pulumi.Input[builtins.str] server_url: The URL for the OpenShift cluster to connect to.
        :param pulumi.Input[builtins.str] service_endpoint_name: The Service Endpoint name.
        """
        if accept_untrusted_certs is not None:
            pulumi.set(__self__, "accept_untrusted_certs", accept_untrusted_certs)
        if auth_basic is not None:
            pulumi.set(__self__, "auth_basic", auth_basic)
        if auth_none is not None:
            pulumi.set(__self__, "auth_none", auth_none)
        if auth_token is not None:
            pulumi.set(__self__, "auth_token", auth_token)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if certificate_authority_file is not None:
            pulumi.set(__self__, "certificate_authority_file", certificate_authority_file)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if server_url is not None:
            pulumi.set(__self__, "server_url", server_url)
        if service_endpoint_name is not None:
            pulumi.set(__self__, "service_endpoint_name", service_endpoint_name)

    @property
    @pulumi.getter(name="acceptUntrustedCerts")
    def accept_untrusted_certs(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set this option to allow clients to accept a self-signed certificate. Available when using `auth_basic` or `auth_token` authorization.
        """
        return pulumi.get(self, "accept_untrusted_certs")

    @accept_untrusted_certs.setter
    def accept_untrusted_certs(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "accept_untrusted_certs", value)

    @property
    @pulumi.getter(name="authBasic")
    def auth_basic(self) -> Optional[pulumi.Input['ServiceendpointOpenshiftAuthBasicArgs']]:
        """
        An `auth_basic` block as documented below.
        """
        return pulumi.get(self, "auth_basic")

    @auth_basic.setter
    def auth_basic(self, value: Optional[pulumi.Input['ServiceendpointOpenshiftAuthBasicArgs']]):
        pulumi.set(self, "auth_basic", value)

    @property
    @pulumi.getter(name="authNone")
    def auth_none(self) -> Optional[pulumi.Input['ServiceendpointOpenshiftAuthNoneArgs']]:
        """
        An `auth_none` block as documented below.
        """
        return pulumi.get(self, "auth_none")

    @auth_none.setter
    def auth_none(self, value: Optional[pulumi.Input['ServiceendpointOpenshiftAuthNoneArgs']]):
        pulumi.set(self, "auth_none", value)

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional[pulumi.Input['ServiceendpointOpenshiftAuthTokenArgs']]:
        """
        An `auth_token` block as documented below.
        """
        return pulumi.get(self, "auth_token")

    @auth_token.setter
    def auth_token(self, value: Optional[pulumi.Input['ServiceendpointOpenshiftAuthTokenArgs']]):
        pulumi.set(self, "auth_token", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="certificateAuthorityFile")
    def certificate_authority_file(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path to a certificate authority file to correctly and securely authenticates with an OpenShift server that uses HTTPS. Available when using `auth_basic` or `auth_token` authorization.
        """
        return pulumi.get(self, "certificate_authority_file")

    @certificate_authority_file.setter
    def certificate_authority_file(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_authority_file", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL for the OpenShift cluster to connect to.
        """
        return pulumi.get(self, "server_url")

    @server_url.setter
    def server_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_url", value)

    @property
    @pulumi.getter(name="serviceEndpointName")
    def service_endpoint_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Service Endpoint name.
        """
        return pulumi.get(self, "service_endpoint_name")

    @service_endpoint_name.setter
    def service_endpoint_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_endpoint_name", value)


@pulumi.type_token("azuredevops:index/serviceendpointOpenshift:ServiceendpointOpenshift")
class ServiceendpointOpenshift(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accept_untrusted_certs: Optional[pulumi.Input[builtins.bool]] = None,
                 auth_basic: Optional[pulumi.Input[Union['ServiceendpointOpenshiftAuthBasicArgs', 'ServiceendpointOpenshiftAuthBasicArgsDict']]] = None,
                 auth_none: Optional[pulumi.Input[Union['ServiceendpointOpenshiftAuthNoneArgs', 'ServiceendpointOpenshiftAuthNoneArgsDict']]] = None,
                 auth_token: Optional[pulumi.Input[Union['ServiceendpointOpenshiftAuthTokenArgs', 'ServiceendpointOpenshiftAuthTokenArgsDict']]] = None,
                 certificate_authority_file: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 server_url: Optional[pulumi.Input[builtins.str]] = None,
                 service_endpoint_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an Openshift service endpoint within Azure DevOps organization. Using this service endpoint requires you to first install the [OpenShift Extension](https://marketplace.visualstudio.com/items?itemName=redhat.openshift-vsts).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_serviceendpoint_openshift = azuredevops.ServiceendpointOpenshift("example",
            project_id=example.id,
            service_endpoint_name="Example Openshift",
            server_url="https://example.server",
            certificate_authority_file="/opt/file",
            accept_untrusted_certs=True,
            auth_basic={
                "username": "username",
                "password": "password",
            })
        ```

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_serviceendpoint_openshift = azuredevops.ServiceendpointOpenshift("example",
            project_id=example.id,
            service_endpoint_name="Example Openshift",
            server_url="https://example.server",
            certificate_authority_file="/opt/file",
            accept_untrusted_certs=True,
            auth_token={
                "token": "username",
            })
        ```
        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_serviceendpoint_openshift = azuredevops.ServiceendpointOpenshift("example",
            project_id=example.id,
            service_endpoint_name="Example Openshift",
            server_url="https://example.server",
            auth_none={
                "kube_config": "config",
            })
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.1 - Service Endpoints](https://docs.microsoft.com/en-us/rest/api/azure/devops/serviceendpoint/endpoints?view=azure-devops-rest-7.1)

        ## Import

        Azure DevOps Openshift Service Endpoint can be imported using **projectID/serviceEndpointID** or **projectName/serviceEndpointID**

        ```sh
        $ pulumi import azuredevops:index/serviceendpointOpenshift:ServiceendpointOpenshift example 00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] accept_untrusted_certs: Set this option to allow clients to accept a self-signed certificate. Available when using `auth_basic` or `auth_token` authorization.
        :param pulumi.Input[Union['ServiceendpointOpenshiftAuthBasicArgs', 'ServiceendpointOpenshiftAuthBasicArgsDict']] auth_basic: An `auth_basic` block as documented below.
        :param pulumi.Input[Union['ServiceendpointOpenshiftAuthNoneArgs', 'ServiceendpointOpenshiftAuthNoneArgsDict']] auth_none: An `auth_none` block as documented below.
        :param pulumi.Input[Union['ServiceendpointOpenshiftAuthTokenArgs', 'ServiceendpointOpenshiftAuthTokenArgsDict']] auth_token: An `auth_token` block as documented below.
        :param pulumi.Input[builtins.str] certificate_authority_file: The path to a certificate authority file to correctly and securely authenticates with an OpenShift server that uses HTTPS. Available when using `auth_basic` or `auth_token` authorization.
        :param pulumi.Input[builtins.str] project_id: The ID of the project.
        :param pulumi.Input[builtins.str] server_url: The URL for the OpenShift cluster to connect to.
        :param pulumi.Input[builtins.str] service_endpoint_name: The Service Endpoint name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceendpointOpenshiftArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Openshift service endpoint within Azure DevOps organization. Using this service endpoint requires you to first install the [OpenShift Extension](https://marketplace.visualstudio.com/items?itemName=redhat.openshift-vsts).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_serviceendpoint_openshift = azuredevops.ServiceendpointOpenshift("example",
            project_id=example.id,
            service_endpoint_name="Example Openshift",
            server_url="https://example.server",
            certificate_authority_file="/opt/file",
            accept_untrusted_certs=True,
            auth_basic={
                "username": "username",
                "password": "password",
            })
        ```

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_serviceendpoint_openshift = azuredevops.ServiceendpointOpenshift("example",
            project_id=example.id,
            service_endpoint_name="Example Openshift",
            server_url="https://example.server",
            certificate_authority_file="/opt/file",
            accept_untrusted_certs=True,
            auth_token={
                "token": "username",
            })
        ```
        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_serviceendpoint_openshift = azuredevops.ServiceendpointOpenshift("example",
            project_id=example.id,
            service_endpoint_name="Example Openshift",
            server_url="https://example.server",
            auth_none={
                "kube_config": "config",
            })
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.1 - Service Endpoints](https://docs.microsoft.com/en-us/rest/api/azure/devops/serviceendpoint/endpoints?view=azure-devops-rest-7.1)

        ## Import

        Azure DevOps Openshift Service Endpoint can be imported using **projectID/serviceEndpointID** or **projectName/serviceEndpointID**

        ```sh
        $ pulumi import azuredevops:index/serviceendpointOpenshift:ServiceendpointOpenshift example 00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param ServiceendpointOpenshiftArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceendpointOpenshiftArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accept_untrusted_certs: Optional[pulumi.Input[builtins.bool]] = None,
                 auth_basic: Optional[pulumi.Input[Union['ServiceendpointOpenshiftAuthBasicArgs', 'ServiceendpointOpenshiftAuthBasicArgsDict']]] = None,
                 auth_none: Optional[pulumi.Input[Union['ServiceendpointOpenshiftAuthNoneArgs', 'ServiceendpointOpenshiftAuthNoneArgsDict']]] = None,
                 auth_token: Optional[pulumi.Input[Union['ServiceendpointOpenshiftAuthTokenArgs', 'ServiceendpointOpenshiftAuthTokenArgsDict']]] = None,
                 certificate_authority_file: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 server_url: Optional[pulumi.Input[builtins.str]] = None,
                 service_endpoint_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceendpointOpenshiftArgs.__new__(ServiceendpointOpenshiftArgs)

            __props__.__dict__["accept_untrusted_certs"] = accept_untrusted_certs
            __props__.__dict__["auth_basic"] = auth_basic
            __props__.__dict__["auth_none"] = auth_none
            __props__.__dict__["auth_token"] = auth_token
            __props__.__dict__["certificate_authority_file"] = certificate_authority_file
            __props__.__dict__["description"] = description
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["server_url"] = server_url
            if service_endpoint_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_endpoint_name'")
            __props__.__dict__["service_endpoint_name"] = service_endpoint_name
            __props__.__dict__["authorization"] = None
        super(ServiceendpointOpenshift, __self__).__init__(
            'azuredevops:index/serviceendpointOpenshift:ServiceendpointOpenshift',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accept_untrusted_certs: Optional[pulumi.Input[builtins.bool]] = None,
            auth_basic: Optional[pulumi.Input[Union['ServiceendpointOpenshiftAuthBasicArgs', 'ServiceendpointOpenshiftAuthBasicArgsDict']]] = None,
            auth_none: Optional[pulumi.Input[Union['ServiceendpointOpenshiftAuthNoneArgs', 'ServiceendpointOpenshiftAuthNoneArgsDict']]] = None,
            auth_token: Optional[pulumi.Input[Union['ServiceendpointOpenshiftAuthTokenArgs', 'ServiceendpointOpenshiftAuthTokenArgsDict']]] = None,
            authorization: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            certificate_authority_file: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            server_url: Optional[pulumi.Input[builtins.str]] = None,
            service_endpoint_name: Optional[pulumi.Input[builtins.str]] = None) -> 'ServiceendpointOpenshift':
        """
        Get an existing ServiceendpointOpenshift resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] accept_untrusted_certs: Set this option to allow clients to accept a self-signed certificate. Available when using `auth_basic` or `auth_token` authorization.
        :param pulumi.Input[Union['ServiceendpointOpenshiftAuthBasicArgs', 'ServiceendpointOpenshiftAuthBasicArgsDict']] auth_basic: An `auth_basic` block as documented below.
        :param pulumi.Input[Union['ServiceendpointOpenshiftAuthNoneArgs', 'ServiceendpointOpenshiftAuthNoneArgsDict']] auth_none: An `auth_none` block as documented below.
        :param pulumi.Input[Union['ServiceendpointOpenshiftAuthTokenArgs', 'ServiceendpointOpenshiftAuthTokenArgsDict']] auth_token: An `auth_token` block as documented below.
        :param pulumi.Input[builtins.str] certificate_authority_file: The path to a certificate authority file to correctly and securely authenticates with an OpenShift server that uses HTTPS. Available when using `auth_basic` or `auth_token` authorization.
        :param pulumi.Input[builtins.str] project_id: The ID of the project.
        :param pulumi.Input[builtins.str] server_url: The URL for the OpenShift cluster to connect to.
        :param pulumi.Input[builtins.str] service_endpoint_name: The Service Endpoint name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceendpointOpenshiftState.__new__(_ServiceendpointOpenshiftState)

        __props__.__dict__["accept_untrusted_certs"] = accept_untrusted_certs
        __props__.__dict__["auth_basic"] = auth_basic
        __props__.__dict__["auth_none"] = auth_none
        __props__.__dict__["auth_token"] = auth_token
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["certificate_authority_file"] = certificate_authority_file
        __props__.__dict__["description"] = description
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["server_url"] = server_url
        __props__.__dict__["service_endpoint_name"] = service_endpoint_name
        return ServiceendpointOpenshift(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="acceptUntrustedCerts")
    def accept_untrusted_certs(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Set this option to allow clients to accept a self-signed certificate. Available when using `auth_basic` or `auth_token` authorization.
        """
        return pulumi.get(self, "accept_untrusted_certs")

    @property
    @pulumi.getter(name="authBasic")
    def auth_basic(self) -> pulumi.Output[Optional['outputs.ServiceendpointOpenshiftAuthBasic']]:
        """
        An `auth_basic` block as documented below.
        """
        return pulumi.get(self, "auth_basic")

    @property
    @pulumi.getter(name="authNone")
    def auth_none(self) -> pulumi.Output[Optional['outputs.ServiceendpointOpenshiftAuthNone']]:
        """
        An `auth_none` block as documented below.
        """
        return pulumi.get(self, "auth_none")

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> pulumi.Output[Optional['outputs.ServiceendpointOpenshiftAuthToken']]:
        """
        An `auth_token` block as documented below.
        """
        return pulumi.get(self, "auth_token")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="certificateAuthorityFile")
    def certificate_authority_file(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The path to a certificate authority file to correctly and securely authenticates with an OpenShift server that uses HTTPS. Available when using `auth_basic` or `auth_token` authorization.
        """
        return pulumi.get(self, "certificate_authority_file")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The URL for the OpenShift cluster to connect to.
        """
        return pulumi.get(self, "server_url")

    @property
    @pulumi.getter(name="serviceEndpointName")
    def service_endpoint_name(self) -> pulumi.Output[builtins.str]:
        """
        The Service Endpoint name.
        """
        return pulumi.get(self, "service_endpoint_name")

