# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ... import core as _core
from ... import meta as _meta

__all__ = [
    'ControllerRevision',
    'DaemonSet',
    'DaemonSetCondition',
    'DaemonSetSpec',
    'DaemonSetStatus',
    'DaemonSetUpdateStrategy',
    'Deployment',
    'DeploymentCondition',
    'DeploymentSpec',
    'DeploymentStatus',
    'DeploymentStrategy',
    'ReplicaSet',
    'ReplicaSetCondition',
    'ReplicaSetSpec',
    'ReplicaSetStatus',
    'RollingUpdateDaemonSet',
    'RollingUpdateDeployment',
    'RollingUpdateStatefulSetStrategy',
    'StatefulSet',
    'StatefulSetCondition',
    'StatefulSetSpec',
    'StatefulSetStatus',
    'StatefulSetUpdateStrategy',
]

@pulumi.output_type
class ControllerRevision(dict):
    """
    ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.
    """
    def __init__(__self__, *,
                 revision: int,
                 api_version: Optional[str] = None,
                 data: Optional[Any] = None,
                 kind: Optional[str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None):
        """
        ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.
        :param int revision: Revision indicates the revision of the state represented by Data.
        :param str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param Any data: Data is the serialized representation of the state.
        :param str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        pulumi.set(__self__, "revision", revision)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'apps/v1')
        if data is not None:
            pulumi.set(__self__, "data", data)
        if kind is not None:
            pulumi.set(__self__, "kind", 'ControllerRevision')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def revision(self) -> int:
        """
        Revision indicates the revision of the state represented by Data.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def data(self) -> Optional[Any]:
        """
        Data is the serialized representation of the state.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DaemonSet(dict):
    """
    DaemonSet represents the configuration of a daemon set.
    """
    def __init__(__self__, *,
                 api_version: Optional[str] = None,
                 kind: Optional[str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.DaemonSetSpec'] = None,
                 status: Optional['outputs.DaemonSetStatus'] = None):
        """
        DaemonSet represents the configuration of a daemon set.
        :param str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'DaemonSetSpecArgs' spec: The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param 'DaemonSetStatusArgs' status: The current status of this daemon set. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'apps/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'DaemonSet')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.DaemonSetSpec']:
        """
        The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.DaemonSetStatus']:
        """
        The current status of this daemon set. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DaemonSetCondition(dict):
    """
    DaemonSetCondition describes the state of a DaemonSet at a certain point.
    """
    def __init__(__self__, *,
                 status: str,
                 type: str,
                 last_transition_time: Optional[str] = None,
                 message: Optional[str] = None,
                 reason: Optional[str] = None):
        """
        DaemonSetCondition describes the state of a DaemonSet at a certain point.
        :param str status: Status of the condition, one of True, False, Unknown.
        :param str type: Type of DaemonSet condition.
        :param str last_transition_time: Last time the condition transitioned from one status to another.
        :param str message: A human readable message indicating details about the transition.
        :param str reason: The reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of DaemonSet condition.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[str]:
        """
        Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        A human readable message indicating details about the transition.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        The reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DaemonSetSpec(dict):
    """
    DaemonSetSpec is the specification of a daemon set.
    """
    def __init__(__self__, *,
                 selector: '_meta.v1.outputs.LabelSelector',
                 template: '_core.v1.outputs.PodTemplateSpec',
                 min_ready_seconds: Optional[int] = None,
                 revision_history_limit: Optional[int] = None,
                 update_strategy: Optional['outputs.DaemonSetUpdateStrategy'] = None):
        """
        DaemonSetSpec is the specification of a daemon set.
        :param '_meta.v1.LabelSelectorArgs' selector: A label query over pods that are managed by the daemon set. Must match in order to be controlled. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param '_core.v1.PodTemplateSpecArgs' template: An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        :param int min_ready_seconds: The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).
        :param int revision_history_limit: The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        :param 'DaemonSetUpdateStrategyArgs' update_strategy: An update strategy to replace existing DaemonSet pods with new pods.
        """
        pulumi.set(__self__, "selector", selector)
        pulumi.set(__self__, "template", template)
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if revision_history_limit is not None:
            pulumi.set(__self__, "revision_history_limit", revision_history_limit)
        if update_strategy is not None:
            pulumi.set(__self__, "update_strategy", update_strategy)

    @property
    @pulumi.getter
    def selector(self) -> '_meta.v1.outputs.LabelSelector':
        """
        A label query over pods that are managed by the daemon set. Must match in order to be controlled. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter
    def template(self) -> '_core.v1.outputs.PodTemplateSpec':
        """
        An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[int]:
        """
        The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).
        """
        return pulumi.get(self, "min_ready_seconds")

    @property
    @pulumi.getter(name="revisionHistoryLimit")
    def revision_history_limit(self) -> Optional[int]:
        """
        The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        """
        return pulumi.get(self, "revision_history_limit")

    @property
    @pulumi.getter(name="updateStrategy")
    def update_strategy(self) -> Optional['outputs.DaemonSetUpdateStrategy']:
        """
        An update strategy to replace existing DaemonSet pods with new pods.
        """
        return pulumi.get(self, "update_strategy")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DaemonSetStatus(dict):
    """
    DaemonSetStatus represents the current status of a daemon set.
    """
    def __init__(__self__, *,
                 current_number_scheduled: int,
                 desired_number_scheduled: int,
                 number_misscheduled: int,
                 number_ready: int,
                 collision_count: Optional[int] = None,
                 conditions: Optional[Sequence['outputs.DaemonSetCondition']] = None,
                 number_available: Optional[int] = None,
                 number_unavailable: Optional[int] = None,
                 observed_generation: Optional[int] = None,
                 updated_number_scheduled: Optional[int] = None):
        """
        DaemonSetStatus represents the current status of a daemon set.
        :param int current_number_scheduled: The number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        :param int desired_number_scheduled: The total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod). More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        :param int number_misscheduled: The number of nodes that are running the daemon pod, but are not supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        :param int number_ready: The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and ready.
        :param int collision_count: Count of hash collisions for the DaemonSet. The DaemonSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
        :param Sequence['DaemonSetConditionArgs'] conditions: Represents the latest available observations of a DaemonSet's current state.
        :param int number_available: The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and available (ready for at least spec.minReadySeconds)
        :param int number_unavailable: The number of nodes that should be running the daemon pod and have none of the daemon pod running and available (ready for at least spec.minReadySeconds)
        :param int observed_generation: The most recent generation observed by the daemon set controller.
        :param int updated_number_scheduled: The total number of nodes that are running updated daemon pod
        """
        pulumi.set(__self__, "current_number_scheduled", current_number_scheduled)
        pulumi.set(__self__, "desired_number_scheduled", desired_number_scheduled)
        pulumi.set(__self__, "number_misscheduled", number_misscheduled)
        pulumi.set(__self__, "number_ready", number_ready)
        if collision_count is not None:
            pulumi.set(__self__, "collision_count", collision_count)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if number_available is not None:
            pulumi.set(__self__, "number_available", number_available)
        if number_unavailable is not None:
            pulumi.set(__self__, "number_unavailable", number_unavailable)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if updated_number_scheduled is not None:
            pulumi.set(__self__, "updated_number_scheduled", updated_number_scheduled)

    @property
    @pulumi.getter(name="currentNumberScheduled")
    def current_number_scheduled(self) -> int:
        """
        The number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        """
        return pulumi.get(self, "current_number_scheduled")

    @property
    @pulumi.getter(name="desiredNumberScheduled")
    def desired_number_scheduled(self) -> int:
        """
        The total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod). More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        """
        return pulumi.get(self, "desired_number_scheduled")

    @property
    @pulumi.getter(name="numberMisscheduled")
    def number_misscheduled(self) -> int:
        """
        The number of nodes that are running the daemon pod, but are not supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        """
        return pulumi.get(self, "number_misscheduled")

    @property
    @pulumi.getter(name="numberReady")
    def number_ready(self) -> int:
        """
        The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and ready.
        """
        return pulumi.get(self, "number_ready")

    @property
    @pulumi.getter(name="collisionCount")
    def collision_count(self) -> Optional[int]:
        """
        Count of hash collisions for the DaemonSet. The DaemonSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
        """
        return pulumi.get(self, "collision_count")

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.DaemonSetCondition']]:
        """
        Represents the latest available observations of a DaemonSet's current state.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="numberAvailable")
    def number_available(self) -> Optional[int]:
        """
        The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and available (ready for at least spec.minReadySeconds)
        """
        return pulumi.get(self, "number_available")

    @property
    @pulumi.getter(name="numberUnavailable")
    def number_unavailable(self) -> Optional[int]:
        """
        The number of nodes that should be running the daemon pod and have none of the daemon pod running and available (ready for at least spec.minReadySeconds)
        """
        return pulumi.get(self, "number_unavailable")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[int]:
        """
        The most recent generation observed by the daemon set controller.
        """
        return pulumi.get(self, "observed_generation")

    @property
    @pulumi.getter(name="updatedNumberScheduled")
    def updated_number_scheduled(self) -> Optional[int]:
        """
        The total number of nodes that are running updated daemon pod
        """
        return pulumi.get(self, "updated_number_scheduled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DaemonSetUpdateStrategy(dict):
    """
    DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet.
    """
    def __init__(__self__, *,
                 rolling_update: Optional['outputs.RollingUpdateDaemonSet'] = None,
                 type: Optional[str] = None):
        """
        DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet.
        :param 'RollingUpdateDaemonSetArgs' rolling_update: Rolling update config params. Present only if type = "RollingUpdate".
        :param str type: Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
        """
        if rolling_update is not None:
            pulumi.set(__self__, "rolling_update", rolling_update)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="rollingUpdate")
    def rolling_update(self) -> Optional['outputs.RollingUpdateDaemonSet']:
        """
        Rolling update config params. Present only if type = "RollingUpdate".
        """
        return pulumi.get(self, "rolling_update")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
        """
        return pulumi.get(self, "type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Deployment(dict):
    """
    Deployment enables declarative updates for Pods and ReplicaSets.

    This resource waits until its status is ready before registering success
    for create/update, and populating output properties from the current state of the resource.
    The following conditions are used to determine whether the resource creation has
    succeeded or failed:

    1. The Deployment has begun to be updated by the Deployment controller. If the current
       generation of the Deployment is > 1, then this means that the current generation must
       be different from the generation reported by the last outputs.
    2. There exists a ReplicaSet whose revision is equal to the current revision of the
       Deployment.
    3. The Deployment's '.status.conditions' has a status of type 'Available' whose 'status'
       member is set to 'True'.
    4. If the Deployment has generation > 1, then '.status.conditions' has a status of type
       'Progressing', whose 'status' member is set to 'True', and whose 'reason' is
       'NewReplicaSetAvailable'. For generation <= 1, this status field does not exist,
       because it doesn't do a rollout (i.e., it simply creates the Deployment and
       corresponding ReplicaSet), and therefore there is no rollout to mark as 'Progressing'.

    If the Deployment has not reached a Ready state after 10 minutes, it will
    time out and mark the resource update as Failed. You can override the default timeout value
    by setting the 'customTimeouts' option on the resource.
    """
    def __init__(__self__, *,
                 api_version: Optional[str] = None,
                 kind: Optional[str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.DeploymentSpec'] = None,
                 status: Optional['outputs.DeploymentStatus'] = None):
        """
        Deployment enables declarative updates for Pods and ReplicaSets.

        This resource waits until its status is ready before registering success
        for create/update, and populating output properties from the current state of the resource.
        The following conditions are used to determine whether the resource creation has
        succeeded or failed:

        1. The Deployment has begun to be updated by the Deployment controller. If the current
           generation of the Deployment is > 1, then this means that the current generation must
           be different from the generation reported by the last outputs.
        2. There exists a ReplicaSet whose revision is equal to the current revision of the
           Deployment.
        3. The Deployment's '.status.conditions' has a status of type 'Available' whose 'status'
           member is set to 'True'.
        4. If the Deployment has generation > 1, then '.status.conditions' has a status of type
           'Progressing', whose 'status' member is set to 'True', and whose 'reason' is
           'NewReplicaSetAvailable'. For generation <= 1, this status field does not exist,
           because it doesn't do a rollout (i.e., it simply creates the Deployment and
           corresponding ReplicaSet), and therefore there is no rollout to mark as 'Progressing'.

        If the Deployment has not reached a Ready state after 10 minutes, it will
        time out and mark the resource update as Failed. You can override the default timeout value
        by setting the 'customTimeouts' option on the resource.
        :param str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata.
        :param 'DeploymentSpecArgs' spec: Specification of the desired behavior of the Deployment.
        :param 'DeploymentStatusArgs' status: Most recently observed status of the Deployment.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'apps/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'Deployment')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.DeploymentSpec']:
        """
        Specification of the desired behavior of the Deployment.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.DeploymentStatus']:
        """
        Most recently observed status of the Deployment.
        """
        return pulumi.get(self, "status")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DeploymentCondition(dict):
    """
    DeploymentCondition describes the state of a deployment at a certain point.
    """
    def __init__(__self__, *,
                 status: str,
                 type: str,
                 last_transition_time: Optional[str] = None,
                 last_update_time: Optional[str] = None,
                 message: Optional[str] = None,
                 reason: Optional[str] = None):
        """
        DeploymentCondition describes the state of a deployment at a certain point.
        :param str status: Status of the condition, one of True, False, Unknown.
        :param str type: Type of deployment condition.
        :param str last_transition_time: Last time the condition transitioned from one status to another.
        :param str last_update_time: The last time this condition was updated.
        :param str message: A human readable message indicating details about the transition.
        :param str reason: The reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if last_update_time is not None:
            pulumi.set(__self__, "last_update_time", last_update_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of deployment condition.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[str]:
        """
        Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> Optional[str]:
        """
        The last time this condition was updated.
        """
        return pulumi.get(self, "last_update_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        A human readable message indicating details about the transition.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        The reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DeploymentSpec(dict):
    """
    DeploymentSpec is the specification of the desired behavior of the Deployment.
    """
    def __init__(__self__, *,
                 selector: '_meta.v1.outputs.LabelSelector',
                 template: '_core.v1.outputs.PodTemplateSpec',
                 min_ready_seconds: Optional[int] = None,
                 paused: Optional[bool] = None,
                 progress_deadline_seconds: Optional[int] = None,
                 replicas: Optional[int] = None,
                 revision_history_limit: Optional[int] = None,
                 strategy: Optional['outputs.DeploymentStrategy'] = None):
        """
        DeploymentSpec is the specification of the desired behavior of the Deployment.
        :param '_meta.v1.LabelSelectorArgs' selector: Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment. It must match the pod template's labels.
        :param '_core.v1.PodTemplateSpecArgs' template: Template describes the pods that will be created.
        :param int min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        :param bool paused: Indicates that the deployment is paused.
        :param int progress_deadline_seconds: The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.
        :param int replicas: Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.
        :param int revision_history_limit: The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        :param 'DeploymentStrategyArgs' strategy: The deployment strategy to use to replace existing pods with new ones.
        """
        pulumi.set(__self__, "selector", selector)
        pulumi.set(__self__, "template", template)
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if progress_deadline_seconds is not None:
            pulumi.set(__self__, "progress_deadline_seconds", progress_deadline_seconds)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if revision_history_limit is not None:
            pulumi.set(__self__, "revision_history_limit", revision_history_limit)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)

    @property
    @pulumi.getter
    def selector(self) -> '_meta.v1.outputs.LabelSelector':
        """
        Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment. It must match the pod template's labels.
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter
    def template(self) -> '_core.v1.outputs.PodTemplateSpec':
        """
        Template describes the pods that will be created.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[int]:
        """
        Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        """
        return pulumi.get(self, "min_ready_seconds")

    @property
    @pulumi.getter
    def paused(self) -> Optional[bool]:
        """
        Indicates that the deployment is paused.
        """
        return pulumi.get(self, "paused")

    @property
    @pulumi.getter(name="progressDeadlineSeconds")
    def progress_deadline_seconds(self) -> Optional[int]:
        """
        The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.
        """
        return pulumi.get(self, "progress_deadline_seconds")

    @property
    @pulumi.getter
    def replicas(self) -> Optional[int]:
        """
        Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.
        """
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter(name="revisionHistoryLimit")
    def revision_history_limit(self) -> Optional[int]:
        """
        The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        """
        return pulumi.get(self, "revision_history_limit")

    @property
    @pulumi.getter
    def strategy(self) -> Optional['outputs.DeploymentStrategy']:
        """
        The deployment strategy to use to replace existing pods with new ones.
        """
        return pulumi.get(self, "strategy")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DeploymentStatus(dict):
    """
    DeploymentStatus is the most recently observed status of the Deployment.
    """
    def __init__(__self__, *,
                 available_replicas: Optional[int] = None,
                 collision_count: Optional[int] = None,
                 conditions: Optional[Sequence['outputs.DeploymentCondition']] = None,
                 observed_generation: Optional[int] = None,
                 ready_replicas: Optional[int] = None,
                 replicas: Optional[int] = None,
                 unavailable_replicas: Optional[int] = None,
                 updated_replicas: Optional[int] = None):
        """
        DeploymentStatus is the most recently observed status of the Deployment.
        :param int available_replicas: Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.
        :param int collision_count: Count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.
        :param Sequence['DeploymentConditionArgs'] conditions: Represents the latest available observations of a deployment's current state.
        :param int observed_generation: The generation observed by the deployment controller.
        :param int ready_replicas: Total number of ready pods targeted by this deployment.
        :param int replicas: Total number of non-terminated pods targeted by this deployment (their labels match the selector).
        :param int unavailable_replicas: Total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created.
        :param int updated_replicas: Total number of non-terminated pods targeted by this deployment that have the desired template spec.
        """
        if available_replicas is not None:
            pulumi.set(__self__, "available_replicas", available_replicas)
        if collision_count is not None:
            pulumi.set(__self__, "collision_count", collision_count)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if ready_replicas is not None:
            pulumi.set(__self__, "ready_replicas", ready_replicas)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if unavailable_replicas is not None:
            pulumi.set(__self__, "unavailable_replicas", unavailable_replicas)
        if updated_replicas is not None:
            pulumi.set(__self__, "updated_replicas", updated_replicas)

    @property
    @pulumi.getter(name="availableReplicas")
    def available_replicas(self) -> Optional[int]:
        """
        Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.
        """
        return pulumi.get(self, "available_replicas")

    @property
    @pulumi.getter(name="collisionCount")
    def collision_count(self) -> Optional[int]:
        """
        Count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.
        """
        return pulumi.get(self, "collision_count")

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.DeploymentCondition']]:
        """
        Represents the latest available observations of a deployment's current state.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[int]:
        """
        The generation observed by the deployment controller.
        """
        return pulumi.get(self, "observed_generation")

    @property
    @pulumi.getter(name="readyReplicas")
    def ready_replicas(self) -> Optional[int]:
        """
        Total number of ready pods targeted by this deployment.
        """
        return pulumi.get(self, "ready_replicas")

    @property
    @pulumi.getter
    def replicas(self) -> Optional[int]:
        """
        Total number of non-terminated pods targeted by this deployment (their labels match the selector).
        """
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter(name="unavailableReplicas")
    def unavailable_replicas(self) -> Optional[int]:
        """
        Total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created.
        """
        return pulumi.get(self, "unavailable_replicas")

    @property
    @pulumi.getter(name="updatedReplicas")
    def updated_replicas(self) -> Optional[int]:
        """
        Total number of non-terminated pods targeted by this deployment that have the desired template spec.
        """
        return pulumi.get(self, "updated_replicas")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DeploymentStrategy(dict):
    """
    DeploymentStrategy describes how to replace existing pods with new ones.
    """
    def __init__(__self__, *,
                 rolling_update: Optional['outputs.RollingUpdateDeployment'] = None,
                 type: Optional[str] = None):
        """
        DeploymentStrategy describes how to replace existing pods with new ones.
        :param 'RollingUpdateDeploymentArgs' rolling_update: Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.
        :param str type: Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
        """
        if rolling_update is not None:
            pulumi.set(__self__, "rolling_update", rolling_update)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="rollingUpdate")
    def rolling_update(self) -> Optional['outputs.RollingUpdateDeployment']:
        """
        Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.
        """
        return pulumi.get(self, "rolling_update")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
        """
        return pulumi.get(self, "type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ReplicaSet(dict):
    """
    ReplicaSet ensures that a specified number of pod replicas are running at any given time.
    """
    def __init__(__self__, *,
                 api_version: Optional[str] = None,
                 kind: Optional[str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.ReplicaSetSpec'] = None,
                 status: Optional['outputs.ReplicaSetStatus'] = None):
        """
        ReplicaSet ensures that a specified number of pod replicas are running at any given time.
        :param str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages. Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'ReplicaSetSpecArgs' spec: Spec defines the specification of the desired behavior of the ReplicaSet. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param 'ReplicaSetStatusArgs' status: Status is the most recently observed status of the ReplicaSet. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'apps/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ReplicaSet')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages. Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.ReplicaSetSpec']:
        """
        Spec defines the specification of the desired behavior of the ReplicaSet. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.ReplicaSetStatus']:
        """
        Status is the most recently observed status of the ReplicaSet. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ReplicaSetCondition(dict):
    """
    ReplicaSetCondition describes the state of a replica set at a certain point.
    """
    def __init__(__self__, *,
                 status: str,
                 type: str,
                 last_transition_time: Optional[str] = None,
                 message: Optional[str] = None,
                 reason: Optional[str] = None):
        """
        ReplicaSetCondition describes the state of a replica set at a certain point.
        :param str status: Status of the condition, one of True, False, Unknown.
        :param str type: Type of replica set condition.
        :param str last_transition_time: The last time the condition transitioned from one status to another.
        :param str message: A human readable message indicating details about the transition.
        :param str reason: The reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of replica set condition.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[str]:
        """
        The last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        A human readable message indicating details about the transition.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        The reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ReplicaSetSpec(dict):
    """
    ReplicaSetSpec is the specification of a ReplicaSet.
    """
    def __init__(__self__, *,
                 selector: '_meta.v1.outputs.LabelSelector',
                 min_ready_seconds: Optional[int] = None,
                 replicas: Optional[int] = None,
                 template: Optional['_core.v1.outputs.PodTemplateSpec'] = None):
        """
        ReplicaSetSpec is the specification of a ReplicaSet.
        :param '_meta.v1.LabelSelectorArgs' selector: Selector is a label query over pods that should match the replica count. Label keys and values that must match in order to be controlled by this replica set. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param int min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        :param int replicas: Replicas is the number of desired replicas. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
        :param '_core.v1.PodTemplateSpecArgs' template: Template is the object that describes the pod that will be created if insufficient replicas are detected. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        """
        pulumi.set(__self__, "selector", selector)
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter
    def selector(self) -> '_meta.v1.outputs.LabelSelector':
        """
        Selector is a label query over pods that should match the replica count. Label keys and values that must match in order to be controlled by this replica set. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[int]:
        """
        Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        """
        return pulumi.get(self, "min_ready_seconds")

    @property
    @pulumi.getter
    def replicas(self) -> Optional[int]:
        """
        Replicas is the number of desired replicas. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
        """
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter
    def template(self) -> Optional['_core.v1.outputs.PodTemplateSpec']:
        """
        Template is the object that describes the pod that will be created if insufficient replicas are detected. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        """
        return pulumi.get(self, "template")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ReplicaSetStatus(dict):
    """
    ReplicaSetStatus represents the current status of a ReplicaSet.
    """
    def __init__(__self__, *,
                 replicas: int,
                 available_replicas: Optional[int] = None,
                 conditions: Optional[Sequence['outputs.ReplicaSetCondition']] = None,
                 fully_labeled_replicas: Optional[int] = None,
                 observed_generation: Optional[int] = None,
                 ready_replicas: Optional[int] = None):
        """
        ReplicaSetStatus represents the current status of a ReplicaSet.
        :param int replicas: Replicas is the most recently oberved number of replicas. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
        :param int available_replicas: The number of available replicas (ready for at least minReadySeconds) for this replica set.
        :param Sequence['ReplicaSetConditionArgs'] conditions: Represents the latest available observations of a replica set's current state.
        :param int fully_labeled_replicas: The number of pods that have labels matching the labels of the pod template of the replicaset.
        :param int observed_generation: ObservedGeneration reflects the generation of the most recently observed ReplicaSet.
        :param int ready_replicas: The number of ready replicas for this replica set.
        """
        pulumi.set(__self__, "replicas", replicas)
        if available_replicas is not None:
            pulumi.set(__self__, "available_replicas", available_replicas)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if fully_labeled_replicas is not None:
            pulumi.set(__self__, "fully_labeled_replicas", fully_labeled_replicas)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if ready_replicas is not None:
            pulumi.set(__self__, "ready_replicas", ready_replicas)

    @property
    @pulumi.getter
    def replicas(self) -> int:
        """
        Replicas is the most recently oberved number of replicas. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
        """
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter(name="availableReplicas")
    def available_replicas(self) -> Optional[int]:
        """
        The number of available replicas (ready for at least minReadySeconds) for this replica set.
        """
        return pulumi.get(self, "available_replicas")

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.ReplicaSetCondition']]:
        """
        Represents the latest available observations of a replica set's current state.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="fullyLabeledReplicas")
    def fully_labeled_replicas(self) -> Optional[int]:
        """
        The number of pods that have labels matching the labels of the pod template of the replicaset.
        """
        return pulumi.get(self, "fully_labeled_replicas")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[int]:
        """
        ObservedGeneration reflects the generation of the most recently observed ReplicaSet.
        """
        return pulumi.get(self, "observed_generation")

    @property
    @pulumi.getter(name="readyReplicas")
    def ready_replicas(self) -> Optional[int]:
        """
        The number of ready replicas for this replica set.
        """
        return pulumi.get(self, "ready_replicas")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class RollingUpdateDaemonSet(dict):
    """
    Spec to control the desired behavior of daemon set rolling update.
    """
    def __init__(__self__, *,
                 max_unavailable: Optional[Any] = None):
        """
        Spec to control the desired behavior of daemon set rolling update.
        :param Union[int, str] max_unavailable: The maximum number of DaemonSet pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of total number of DaemonSet pods at the start of the update (ex: 10%). Absolute number is calculated from percentage by rounding up. This cannot be 0. Default value is 1. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their pods stopped for an update at any given time. The update starts by stopping at most 30% of those DaemonSet pods and then brings up new DaemonSet pods in their place. Once the new pods are available, it then proceeds onto other DaemonSet pods, thus ensuring that at least 70% of original number of DaemonSet pods are available at all times during the update.
        """
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[Any]:
        """
        The maximum number of DaemonSet pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of total number of DaemonSet pods at the start of the update (ex: 10%). Absolute number is calculated from percentage by rounding up. This cannot be 0. Default value is 1. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their pods stopped for an update at any given time. The update starts by stopping at most 30% of those DaemonSet pods and then brings up new DaemonSet pods in their place. Once the new pods are available, it then proceeds onto other DaemonSet pods, thus ensuring that at least 70% of original number of DaemonSet pods are available at all times during the update.
        """
        return pulumi.get(self, "max_unavailable")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class RollingUpdateDeployment(dict):
    """
    Spec to control the desired behavior of rolling update.
    """
    def __init__(__self__, *,
                 max_surge: Optional[Any] = None,
                 max_unavailable: Optional[Any] = None):
        """
        Spec to control the desired behavior of rolling update.
        :param Union[int, str] max_surge: The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. Defaults to 25%. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods.
        :param Union[int, str] max_unavailable: The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. Defaults to 25%. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.
        """
        if max_surge is not None:
            pulumi.set(__self__, "max_surge", max_surge)
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)

    @property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> Optional[Any]:
        """
        The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. Defaults to 25%. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods.
        """
        return pulumi.get(self, "max_surge")

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[Any]:
        """
        The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. Defaults to 25%. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.
        """
        return pulumi.get(self, "max_unavailable")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class RollingUpdateStatefulSetStrategy(dict):
    """
    RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType.
    """
    def __init__(__self__, *,
                 partition: Optional[int] = None):
        """
        RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType.
        :param int partition: Partition indicates the ordinal at which the StatefulSet should be partitioned. Default value is 0.
        """
        if partition is not None:
            pulumi.set(__self__, "partition", partition)

    @property
    @pulumi.getter
    def partition(self) -> Optional[int]:
        """
        Partition indicates the ordinal at which the StatefulSet should be partitioned. Default value is 0.
        """
        return pulumi.get(self, "partition")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class StatefulSet(dict):
    """
    StatefulSet represents a set of pods with consistent identities. Identities are defined as:
     - Network: A single stable DNS and hostname.
     - Storage: As many VolumeClaims as requested.
    The StatefulSet guarantees that a given network identity will always map to the same storage identity.

    This resource waits until its status is ready before registering success
    for create/update, and populating output properties from the current state of the resource.
    The following conditions are used to determine whether the resource creation has
    succeeded or failed:

    1. The value of 'spec.replicas' matches '.status.replicas', '.status.currentReplicas',
       and '.status.readyReplicas'.
    2. The value of '.status.updateRevision' matches '.status.currentRevision'.

    If the StatefulSet has not reached a Ready state after 10 minutes, it will
    time out and mark the resource update as Failed. You can override the default timeout value
    by setting the 'customTimeouts' option on the resource.
    """
    def __init__(__self__, *,
                 api_version: Optional[str] = None,
                 kind: Optional[str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.StatefulSetSpec'] = None,
                 status: Optional['outputs.StatefulSetStatus'] = None):
        """
        StatefulSet represents a set of pods with consistent identities. Identities are defined as:
         - Network: A single stable DNS and hostname.
         - Storage: As many VolumeClaims as requested.
        The StatefulSet guarantees that a given network identity will always map to the same storage identity.

        This resource waits until its status is ready before registering success
        for create/update, and populating output properties from the current state of the resource.
        The following conditions are used to determine whether the resource creation has
        succeeded or failed:

        1. The value of 'spec.replicas' matches '.status.replicas', '.status.currentReplicas',
           and '.status.readyReplicas'.
        2. The value of '.status.updateRevision' matches '.status.currentRevision'.

        If the StatefulSet has not reached a Ready state after 10 minutes, it will
        time out and mark the resource update as Failed. You can override the default timeout value
        by setting the 'customTimeouts' option on the resource.
        :param str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param 'StatefulSetSpecArgs' spec: Spec defines the desired identities of pods in this set.
        :param 'StatefulSetStatusArgs' status: Status is the current status of Pods in this StatefulSet. This data may be out of date by some window of time.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'apps/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'StatefulSet')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.StatefulSetSpec']:
        """
        Spec defines the desired identities of pods in this set.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.StatefulSetStatus']:
        """
        Status is the current status of Pods in this StatefulSet. This data may be out of date by some window of time.
        """
        return pulumi.get(self, "status")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class StatefulSetCondition(dict):
    """
    StatefulSetCondition describes the state of a statefulset at a certain point.
    """
    def __init__(__self__, *,
                 status: str,
                 type: str,
                 last_transition_time: Optional[str] = None,
                 message: Optional[str] = None,
                 reason: Optional[str] = None):
        """
        StatefulSetCondition describes the state of a statefulset at a certain point.
        :param str status: Status of the condition, one of True, False, Unknown.
        :param str type: Type of statefulset condition.
        :param str last_transition_time: Last time the condition transitioned from one status to another.
        :param str message: A human readable message indicating details about the transition.
        :param str reason: The reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of statefulset condition.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[str]:
        """
        Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        A human readable message indicating details about the transition.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        The reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class StatefulSetSpec(dict):
    """
    A StatefulSetSpec is the specification of a StatefulSet.
    """
    def __init__(__self__, *,
                 selector: '_meta.v1.outputs.LabelSelector',
                 service_name: str,
                 template: '_core.v1.outputs.PodTemplateSpec',
                 pod_management_policy: Optional[str] = None,
                 replicas: Optional[int] = None,
                 revision_history_limit: Optional[int] = None,
                 update_strategy: Optional['outputs.StatefulSetUpdateStrategy'] = None,
                 volume_claim_templates: Optional[Sequence['_core.v1.outputs.PersistentVolumeClaim']] = None):
        """
        A StatefulSetSpec is the specification of a StatefulSet.
        :param '_meta.v1.LabelSelectorArgs' selector: selector is a label query over pods that should match the replica count. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param str service_name: serviceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where "pod-specific-string" is managed by the StatefulSet controller.
        :param '_core.v1.PodTemplateSpecArgs' template: template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet.
        :param str pod_management_policy: podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down. The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.
        :param int replicas: replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.
        :param int revision_history_limit: revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet's revision history. The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.
        :param 'StatefulSetUpdateStrategyArgs' update_strategy: updateStrategy indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.
        :param Sequence['_core.v1.PersistentVolumeClaimArgs'] volume_claim_templates: volumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.
        """
        pulumi.set(__self__, "selector", selector)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "template", template)
        if pod_management_policy is not None:
            pulumi.set(__self__, "pod_management_policy", pod_management_policy)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if revision_history_limit is not None:
            pulumi.set(__self__, "revision_history_limit", revision_history_limit)
        if update_strategy is not None:
            pulumi.set(__self__, "update_strategy", update_strategy)
        if volume_claim_templates is not None:
            pulumi.set(__self__, "volume_claim_templates", volume_claim_templates)

    @property
    @pulumi.getter
    def selector(self) -> '_meta.v1.outputs.LabelSelector':
        """
        selector is a label query over pods that should match the replica count. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        serviceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where "pod-specific-string" is managed by the StatefulSet controller.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def template(self) -> '_core.v1.outputs.PodTemplateSpec':
        """
        template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="podManagementPolicy")
    def pod_management_policy(self) -> Optional[str]:
        """
        podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down. The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.
        """
        return pulumi.get(self, "pod_management_policy")

    @property
    @pulumi.getter
    def replicas(self) -> Optional[int]:
        """
        replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.
        """
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter(name="revisionHistoryLimit")
    def revision_history_limit(self) -> Optional[int]:
        """
        revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet's revision history. The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.
        """
        return pulumi.get(self, "revision_history_limit")

    @property
    @pulumi.getter(name="updateStrategy")
    def update_strategy(self) -> Optional['outputs.StatefulSetUpdateStrategy']:
        """
        updateStrategy indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.
        """
        return pulumi.get(self, "update_strategy")

    @property
    @pulumi.getter(name="volumeClaimTemplates")
    def volume_claim_templates(self) -> Optional[Sequence['_core.v1.outputs.PersistentVolumeClaim']]:
        """
        volumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.
        """
        return pulumi.get(self, "volume_claim_templates")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class StatefulSetStatus(dict):
    """
    StatefulSetStatus represents the current state of a StatefulSet.
    """
    def __init__(__self__, *,
                 replicas: int,
                 collision_count: Optional[int] = None,
                 conditions: Optional[Sequence['outputs.StatefulSetCondition']] = None,
                 current_replicas: Optional[int] = None,
                 current_revision: Optional[str] = None,
                 observed_generation: Optional[int] = None,
                 ready_replicas: Optional[int] = None,
                 update_revision: Optional[str] = None,
                 updated_replicas: Optional[int] = None):
        """
        StatefulSetStatus represents the current state of a StatefulSet.
        :param int replicas: replicas is the number of Pods created by the StatefulSet controller.
        :param int collision_count: collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
        :param Sequence['StatefulSetConditionArgs'] conditions: Represents the latest available observations of a statefulset's current state.
        :param int current_replicas: currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by currentRevision.
        :param str current_revision: currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [0,currentReplicas).
        :param int observed_generation: observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the StatefulSet's generation, which is updated on mutation by the API Server.
        :param int ready_replicas: readyReplicas is the number of Pods created by the StatefulSet controller that have a Ready Condition.
        :param str update_revision: updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [replicas-updatedReplicas,replicas)
        :param int updated_replicas: updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by updateRevision.
        """
        pulumi.set(__self__, "replicas", replicas)
        if collision_count is not None:
            pulumi.set(__self__, "collision_count", collision_count)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if current_replicas is not None:
            pulumi.set(__self__, "current_replicas", current_replicas)
        if current_revision is not None:
            pulumi.set(__self__, "current_revision", current_revision)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if ready_replicas is not None:
            pulumi.set(__self__, "ready_replicas", ready_replicas)
        if update_revision is not None:
            pulumi.set(__self__, "update_revision", update_revision)
        if updated_replicas is not None:
            pulumi.set(__self__, "updated_replicas", updated_replicas)

    @property
    @pulumi.getter
    def replicas(self) -> int:
        """
        replicas is the number of Pods created by the StatefulSet controller.
        """
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter(name="collisionCount")
    def collision_count(self) -> Optional[int]:
        """
        collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
        """
        return pulumi.get(self, "collision_count")

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.StatefulSetCondition']]:
        """
        Represents the latest available observations of a statefulset's current state.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="currentReplicas")
    def current_replicas(self) -> Optional[int]:
        """
        currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by currentRevision.
        """
        return pulumi.get(self, "current_replicas")

    @property
    @pulumi.getter(name="currentRevision")
    def current_revision(self) -> Optional[str]:
        """
        currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [0,currentReplicas).
        """
        return pulumi.get(self, "current_revision")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[int]:
        """
        observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the StatefulSet's generation, which is updated on mutation by the API Server.
        """
        return pulumi.get(self, "observed_generation")

    @property
    @pulumi.getter(name="readyReplicas")
    def ready_replicas(self) -> Optional[int]:
        """
        readyReplicas is the number of Pods created by the StatefulSet controller that have a Ready Condition.
        """
        return pulumi.get(self, "ready_replicas")

    @property
    @pulumi.getter(name="updateRevision")
    def update_revision(self) -> Optional[str]:
        """
        updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [replicas-updatedReplicas,replicas)
        """
        return pulumi.get(self, "update_revision")

    @property
    @pulumi.getter(name="updatedReplicas")
    def updated_replicas(self) -> Optional[int]:
        """
        updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by updateRevision.
        """
        return pulumi.get(self, "updated_replicas")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class StatefulSetUpdateStrategy(dict):
    """
    StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy.
    """
    def __init__(__self__, *,
                 rolling_update: Optional['outputs.RollingUpdateStatefulSetStrategy'] = None,
                 type: Optional[str] = None):
        """
        StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy.
        :param 'RollingUpdateStatefulSetStrategyArgs' rolling_update: RollingUpdate is used to communicate parameters when Type is RollingUpdateStatefulSetStrategyType.
        :param str type: Type indicates the type of the StatefulSetUpdateStrategy. Default is RollingUpdate.
        """
        if rolling_update is not None:
            pulumi.set(__self__, "rolling_update", rolling_update)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="rollingUpdate")
    def rolling_update(self) -> Optional['outputs.RollingUpdateStatefulSetStrategy']:
        """
        RollingUpdate is used to communicate parameters when Type is RollingUpdateStatefulSetStrategyType.
        """
        return pulumi.get(self, "rolling_update")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type indicates the type of the StatefulSetUpdateStrategy. Default is RollingUpdate.
        """
        return pulumi.get(self, "type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


