# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseMysqlV2Args', 'DatabaseMysqlV2']

@pulumi.input_type
class DatabaseMysqlV2Args:
    def __init__(__self__, *,
                 engine_id: pulumi.Input[_builtins.str],
                 label: pulumi.Input[_builtins.str],
                 region: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cluster_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_binlog_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_connect_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_default_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_mysql_group_concat_max_len: Optional[pulumi.Input[_builtins.float]] = None,
                 engine_config_mysql_information_schema_stats_expiry: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_change_buffer_max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_flush_neighbors: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_ft_min_token_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_ft_server_stopword_table: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_mysql_innodb_lock_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_log_buffer_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_online_alter_log_max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_read_io_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_rollback_on_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_config_mysql_innodb_thread_concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_write_io_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_interactive_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_internal_tmp_mem_storage_engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_mysql_max_allowed_packet: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_max_heap_table_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_net_buffer_length: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_net_read_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_net_write_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_sort_buffer_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_sql_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_mysql_sql_require_primary_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_config_mysql_tmp_table_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 fork_restore_time: Optional[pulumi.Input[_builtins.str]] = None,
                 fork_source: Optional[pulumi.Input[_builtins.int]] = None,
                 suspended: Optional[pulumi.Input[_builtins.bool]] = None,
                 timeouts: Optional[pulumi.Input['DatabaseMysqlV2TimeoutsArgs']] = None,
                 updates: Optional[pulumi.Input['DatabaseMysqlV2UpdatesArgs']] = None):
        """
        The set of arguments for constructing a DatabaseMysqlV2 resource.
        :param pulumi.Input[_builtins.str] engine_id: The Managed Database engine in engine/version format. (e.g. `mysql`)
        :param pulumi.Input[_builtins.str] label: A unique, user-defined string referring to the Managed Database.
        :param pulumi.Input[_builtins.str] region: The region to use for the Managed Database.
        :param pulumi.Input[_builtins.str] type: The Linode Instance type used for the nodes of the Managed Database.
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allow_lists: A list of IP addresses that can access the Managed Database. Each item can be a single IP address or a range in CIDR format. Use `DatabaseAccessControls` to manage your allow list separately.
        :param pulumi.Input[_builtins.int] cluster_size: The number of Linode Instance nodes deployed to the Managed Database. (default `1`)
        :param pulumi.Input[_builtins.int] engine_config_binlog_retention_period: The minimum amount of time in seconds to keep binlog entries before deletion. This may be extended for services that require binlog entries for longer than the default, for example if using the MySQL Debezium Kafka connector.
        :param pulumi.Input[_builtins.int] engine_config_mysql_connect_timeout: The number of seconds that the mysqld server waits for a connect packet before responding with "Bad handshake".
        :param pulumi.Input[_builtins.str] engine_config_mysql_default_time_zone: Default server time zone as an offset from UTC (from -12:00 to +12:00), a time zone name, or `SYSTEM` to use the MySQL server default.
        :param pulumi.Input[_builtins.float] engine_config_mysql_group_concat_max_len: The maximum permitted result length in bytes for the `GROUP_CONCAT()` function.
        :param pulumi.Input[_builtins.int] engine_config_mysql_information_schema_stats_expiry: The time, in seconds, before cached statistics expire.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_change_buffer_max_size: Maximum size for the InnoDB change buffer, as a percentage of the total size of the buffer pool. Default is 25.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_flush_neighbors: Specifies whether flushing a page from the InnoDB buffer pool also flushes other dirty pages in the same extent (default is 1): 0 - dirty pages in the same extent are not flushed, 1 - flush contiguous dirty pages in the same extent, 2 - flush dirty pages in the same extent.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_ft_min_token_size: Minimum length of words that are stored in an InnoDB FULLTEXT index. Changing this parameter will lead to a restart of the MySQL service.
        :param pulumi.Input[_builtins.str] engine_config_mysql_innodb_ft_server_stopword_table: This option is used to specify your own InnoDB FULLTEXT index stopword list for all InnoDB tables. This field is nullable.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_lock_wait_timeout: The length of time in seconds an InnoDB transaction waits for a row lock before giving up. Default is 120.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_log_buffer_size: The size in bytes of the buffer that InnoDB uses to write to the log files on disk.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_online_alter_log_max_size: The upper limit in bytes on the size of the temporary log files used during online DDL operations for InnoDB tables.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_read_io_threads: The number of I/O threads for read operations in InnoDB. Default is 4. Changing this parameter will lead to a restart of the MySQL service.
        :param pulumi.Input[_builtins.bool] engine_config_mysql_innodb_rollback_on_timeout: When enabled, a transaction timeout causes InnoDB to abort and roll back the entire transaction. Changing this parameter will lead to a restart of the MySQL service.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_thread_concurrency: Defines the maximum number of threads permitted inside of InnoDB. Default is 0 (infinite concurrency - no limit).
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_write_io_threads: The number of I/O threads for write operations in InnoDB. Default is 4. Changing this parameter will lead to a restart of the MySQL service.
        :param pulumi.Input[_builtins.int] engine_config_mysql_interactive_timeout: The number of seconds the server waits for activity on an interactive connection before closing it.
        :param pulumi.Input[_builtins.str] engine_config_mysql_internal_tmp_mem_storage_engine: The storage engine for in-memory internal temporary tables.
        :param pulumi.Input[_builtins.int] engine_config_mysql_max_allowed_packet: Size of the largest message in bytes that can be received by the server. Default is 67108864 (64M).
        :param pulumi.Input[_builtins.int] engine_config_mysql_max_heap_table_size: Limits the size of internal in-memory tables. Also set tmp_table_size. Default is 16777216 (16M).
        :param pulumi.Input[_builtins.int] engine_config_mysql_net_buffer_length: Start sizes of connection buffer and result buffer. Default is 16384 (16K). Changing this parameter will lead to a restart of the MySQL service.
        :param pulumi.Input[_builtins.int] engine_config_mysql_net_read_timeout: The number of seconds to wait for more data from a connection before aborting the read.
        :param pulumi.Input[_builtins.int] engine_config_mysql_net_write_timeout: The number of seconds to wait for a block to be written to a connection before aborting the write.
        :param pulumi.Input[_builtins.int] engine_config_mysql_sort_buffer_size: Sort buffer size in bytes for ORDER BY optimization. Default is 262144 (256K).
        :param pulumi.Input[_builtins.str] engine_config_mysql_sql_mode: Global SQL mode. Set to empty to use MySQL server defaults. When creating a new service and not setting this field Aiven default SQL mode (strict, SQL standard compliant) will be assigned. (default `ANSI,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION,NO_ZERO_DATE,NO_ZERO_IN_DATE,STRICT_ALL_TABLES`)
        :param pulumi.Input[_builtins.bool] engine_config_mysql_sql_require_primary_key: Require primary key to be defined for new tables or old tables modified with ALTER TABLE and fail if missing. It is recommended to always have primary keys because various functionality may break if any large table is missing them. (default `true`)
        :param pulumi.Input[_builtins.int] engine_config_mysql_tmp_table_size: Limits the size of internal in-memory tables. Also set max_heap_table_size. Default is 16777216 (16M).
        :param pulumi.Input[_builtins.int] engine_config_mysql_wait_timeout: The number of seconds the server waits for activity on a noninteractive connection before closing it.
        :param pulumi.Input[_builtins.str] fork_restore_time: The database timestamp from which it was restored.
        :param pulumi.Input[_builtins.int] fork_source: The ID of the database that was forked from.
               
               * `updates` - (Optional) Configuration settings for automated patch update maintenance for the Managed Database.
        :param pulumi.Input[_builtins.bool] suspended: Whether this Managed Database should be suspended.
        :param pulumi.Input['DatabaseMysqlV2UpdatesArgs'] updates: Configuration settings for automated patch update maintenance for the Managed Database.
        """
        pulumi.set(__self__, "engine_id", engine_id)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "type", type)
        if allow_lists is not None:
            pulumi.set(__self__, "allow_lists", allow_lists)
        if cluster_size is not None:
            pulumi.set(__self__, "cluster_size", cluster_size)
        if engine_config_binlog_retention_period is not None:
            pulumi.set(__self__, "engine_config_binlog_retention_period", engine_config_binlog_retention_period)
        if engine_config_mysql_connect_timeout is not None:
            pulumi.set(__self__, "engine_config_mysql_connect_timeout", engine_config_mysql_connect_timeout)
        if engine_config_mysql_default_time_zone is not None:
            pulumi.set(__self__, "engine_config_mysql_default_time_zone", engine_config_mysql_default_time_zone)
        if engine_config_mysql_group_concat_max_len is not None:
            pulumi.set(__self__, "engine_config_mysql_group_concat_max_len", engine_config_mysql_group_concat_max_len)
        if engine_config_mysql_information_schema_stats_expiry is not None:
            pulumi.set(__self__, "engine_config_mysql_information_schema_stats_expiry", engine_config_mysql_information_schema_stats_expiry)
        if engine_config_mysql_innodb_change_buffer_max_size is not None:
            pulumi.set(__self__, "engine_config_mysql_innodb_change_buffer_max_size", engine_config_mysql_innodb_change_buffer_max_size)
        if engine_config_mysql_innodb_flush_neighbors is not None:
            pulumi.set(__self__, "engine_config_mysql_innodb_flush_neighbors", engine_config_mysql_innodb_flush_neighbors)
        if engine_config_mysql_innodb_ft_min_token_size is not None:
            pulumi.set(__self__, "engine_config_mysql_innodb_ft_min_token_size", engine_config_mysql_innodb_ft_min_token_size)
        if engine_config_mysql_innodb_ft_server_stopword_table is not None:
            pulumi.set(__self__, "engine_config_mysql_innodb_ft_server_stopword_table", engine_config_mysql_innodb_ft_server_stopword_table)
        if engine_config_mysql_innodb_lock_wait_timeout is not None:
            pulumi.set(__self__, "engine_config_mysql_innodb_lock_wait_timeout", engine_config_mysql_innodb_lock_wait_timeout)
        if engine_config_mysql_innodb_log_buffer_size is not None:
            pulumi.set(__self__, "engine_config_mysql_innodb_log_buffer_size", engine_config_mysql_innodb_log_buffer_size)
        if engine_config_mysql_innodb_online_alter_log_max_size is not None:
            pulumi.set(__self__, "engine_config_mysql_innodb_online_alter_log_max_size", engine_config_mysql_innodb_online_alter_log_max_size)
        if engine_config_mysql_innodb_read_io_threads is not None:
            pulumi.set(__self__, "engine_config_mysql_innodb_read_io_threads", engine_config_mysql_innodb_read_io_threads)
        if engine_config_mysql_innodb_rollback_on_timeout is not None:
            pulumi.set(__self__, "engine_config_mysql_innodb_rollback_on_timeout", engine_config_mysql_innodb_rollback_on_timeout)
        if engine_config_mysql_innodb_thread_concurrency is not None:
            pulumi.set(__self__, "engine_config_mysql_innodb_thread_concurrency", engine_config_mysql_innodb_thread_concurrency)
        if engine_config_mysql_innodb_write_io_threads is not None:
            pulumi.set(__self__, "engine_config_mysql_innodb_write_io_threads", engine_config_mysql_innodb_write_io_threads)
        if engine_config_mysql_interactive_timeout is not None:
            pulumi.set(__self__, "engine_config_mysql_interactive_timeout", engine_config_mysql_interactive_timeout)
        if engine_config_mysql_internal_tmp_mem_storage_engine is not None:
            pulumi.set(__self__, "engine_config_mysql_internal_tmp_mem_storage_engine", engine_config_mysql_internal_tmp_mem_storage_engine)
        if engine_config_mysql_max_allowed_packet is not None:
            pulumi.set(__self__, "engine_config_mysql_max_allowed_packet", engine_config_mysql_max_allowed_packet)
        if engine_config_mysql_max_heap_table_size is not None:
            pulumi.set(__self__, "engine_config_mysql_max_heap_table_size", engine_config_mysql_max_heap_table_size)
        if engine_config_mysql_net_buffer_length is not None:
            pulumi.set(__self__, "engine_config_mysql_net_buffer_length", engine_config_mysql_net_buffer_length)
        if engine_config_mysql_net_read_timeout is not None:
            pulumi.set(__self__, "engine_config_mysql_net_read_timeout", engine_config_mysql_net_read_timeout)
        if engine_config_mysql_net_write_timeout is not None:
            pulumi.set(__self__, "engine_config_mysql_net_write_timeout", engine_config_mysql_net_write_timeout)
        if engine_config_mysql_sort_buffer_size is not None:
            pulumi.set(__self__, "engine_config_mysql_sort_buffer_size", engine_config_mysql_sort_buffer_size)
        if engine_config_mysql_sql_mode is not None:
            pulumi.set(__self__, "engine_config_mysql_sql_mode", engine_config_mysql_sql_mode)
        if engine_config_mysql_sql_require_primary_key is not None:
            pulumi.set(__self__, "engine_config_mysql_sql_require_primary_key", engine_config_mysql_sql_require_primary_key)
        if engine_config_mysql_tmp_table_size is not None:
            pulumi.set(__self__, "engine_config_mysql_tmp_table_size", engine_config_mysql_tmp_table_size)
        if engine_config_mysql_wait_timeout is not None:
            pulumi.set(__self__, "engine_config_mysql_wait_timeout", engine_config_mysql_wait_timeout)
        if fork_restore_time is not None:
            pulumi.set(__self__, "fork_restore_time", fork_restore_time)
        if fork_source is not None:
            pulumi.set(__self__, "fork_source", fork_source)
        if suspended is not None:
            pulumi.set(__self__, "suspended", suspended)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if updates is not None:
            pulumi.set(__self__, "updates", updates)

    @_builtins.property
    @pulumi.getter(name="engineId")
    def engine_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Managed Database engine in engine/version format. (e.g. `mysql`)
        """
        return pulumi.get(self, "engine_id")

    @engine_id.setter
    def engine_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "engine_id", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Input[_builtins.str]:
        """
        A unique, user-defined string referring to the Managed Database.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The region to use for the Managed Database.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The Linode Instance type used for the nodes of the Managed Database.

        - - -
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="allowLists")
    def allow_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IP addresses that can access the Managed Database. Each item can be a single IP address or a range in CIDR format. Use `DatabaseAccessControls` to manage your allow list separately.
        """
        return pulumi.get(self, "allow_lists")

    @allow_lists.setter
    def allow_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allow_lists", value)

    @_builtins.property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of Linode Instance nodes deployed to the Managed Database. (default `1`)
        """
        return pulumi.get(self, "cluster_size")

    @cluster_size.setter
    def cluster_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cluster_size", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigBinlogRetentionPeriod")
    def engine_config_binlog_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum amount of time in seconds to keep binlog entries before deletion. This may be extended for services that require binlog entries for longer than the default, for example if using the MySQL Debezium Kafka connector.
        """
        return pulumi.get(self, "engine_config_binlog_retention_period")

    @engine_config_binlog_retention_period.setter
    def engine_config_binlog_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_binlog_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlConnectTimeout")
    def engine_config_mysql_connect_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds that the mysqld server waits for a connect packet before responding with "Bad handshake".
        """
        return pulumi.get(self, "engine_config_mysql_connect_timeout")

    @engine_config_mysql_connect_timeout.setter
    def engine_config_mysql_connect_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_connect_timeout", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlDefaultTimeZone")
    def engine_config_mysql_default_time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default server time zone as an offset from UTC (from -12:00 to +12:00), a time zone name, or `SYSTEM` to use the MySQL server default.
        """
        return pulumi.get(self, "engine_config_mysql_default_time_zone")

    @engine_config_mysql_default_time_zone.setter
    def engine_config_mysql_default_time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_config_mysql_default_time_zone", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlGroupConcatMaxLen")
    def engine_config_mysql_group_concat_max_len(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The maximum permitted result length in bytes for the `GROUP_CONCAT()` function.
        """
        return pulumi.get(self, "engine_config_mysql_group_concat_max_len")

    @engine_config_mysql_group_concat_max_len.setter
    def engine_config_mysql_group_concat_max_len(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "engine_config_mysql_group_concat_max_len", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInformationSchemaStatsExpiry")
    def engine_config_mysql_information_schema_stats_expiry(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time, in seconds, before cached statistics expire.
        """
        return pulumi.get(self, "engine_config_mysql_information_schema_stats_expiry")

    @engine_config_mysql_information_schema_stats_expiry.setter
    def engine_config_mysql_information_schema_stats_expiry(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_information_schema_stats_expiry", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbChangeBufferMaxSize")
    def engine_config_mysql_innodb_change_buffer_max_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum size for the InnoDB change buffer, as a percentage of the total size of the buffer pool. Default is 25.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_change_buffer_max_size")

    @engine_config_mysql_innodb_change_buffer_max_size.setter
    def engine_config_mysql_innodb_change_buffer_max_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_innodb_change_buffer_max_size", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbFlushNeighbors")
    def engine_config_mysql_innodb_flush_neighbors(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies whether flushing a page from the InnoDB buffer pool also flushes other dirty pages in the same extent (default is 1): 0 - dirty pages in the same extent are not flushed, 1 - flush contiguous dirty pages in the same extent, 2 - flush dirty pages in the same extent.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_flush_neighbors")

    @engine_config_mysql_innodb_flush_neighbors.setter
    def engine_config_mysql_innodb_flush_neighbors(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_innodb_flush_neighbors", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbFtMinTokenSize")
    def engine_config_mysql_innodb_ft_min_token_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum length of words that are stored in an InnoDB FULLTEXT index. Changing this parameter will lead to a restart of the MySQL service.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_ft_min_token_size")

    @engine_config_mysql_innodb_ft_min_token_size.setter
    def engine_config_mysql_innodb_ft_min_token_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_innodb_ft_min_token_size", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbFtServerStopwordTable")
    def engine_config_mysql_innodb_ft_server_stopword_table(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This option is used to specify your own InnoDB FULLTEXT index stopword list for all InnoDB tables. This field is nullable.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_ft_server_stopword_table")

    @engine_config_mysql_innodb_ft_server_stopword_table.setter
    def engine_config_mysql_innodb_ft_server_stopword_table(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_config_mysql_innodb_ft_server_stopword_table", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbLockWaitTimeout")
    def engine_config_mysql_innodb_lock_wait_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The length of time in seconds an InnoDB transaction waits for a row lock before giving up. Default is 120.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_lock_wait_timeout")

    @engine_config_mysql_innodb_lock_wait_timeout.setter
    def engine_config_mysql_innodb_lock_wait_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_innodb_lock_wait_timeout", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbLogBufferSize")
    def engine_config_mysql_innodb_log_buffer_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size in bytes of the buffer that InnoDB uses to write to the log files on disk.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_log_buffer_size")

    @engine_config_mysql_innodb_log_buffer_size.setter
    def engine_config_mysql_innodb_log_buffer_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_innodb_log_buffer_size", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbOnlineAlterLogMaxSize")
    def engine_config_mysql_innodb_online_alter_log_max_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The upper limit in bytes on the size of the temporary log files used during online DDL operations for InnoDB tables.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_online_alter_log_max_size")

    @engine_config_mysql_innodb_online_alter_log_max_size.setter
    def engine_config_mysql_innodb_online_alter_log_max_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_innodb_online_alter_log_max_size", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbReadIoThreads")
    def engine_config_mysql_innodb_read_io_threads(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of I/O threads for read operations in InnoDB. Default is 4. Changing this parameter will lead to a restart of the MySQL service.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_read_io_threads")

    @engine_config_mysql_innodb_read_io_threads.setter
    def engine_config_mysql_innodb_read_io_threads(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_innodb_read_io_threads", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbRollbackOnTimeout")
    def engine_config_mysql_innodb_rollback_on_timeout(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, a transaction timeout causes InnoDB to abort and roll back the entire transaction. Changing this parameter will lead to a restart of the MySQL service.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_rollback_on_timeout")

    @engine_config_mysql_innodb_rollback_on_timeout.setter
    def engine_config_mysql_innodb_rollback_on_timeout(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "engine_config_mysql_innodb_rollback_on_timeout", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbThreadConcurrency")
    def engine_config_mysql_innodb_thread_concurrency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Defines the maximum number of threads permitted inside of InnoDB. Default is 0 (infinite concurrency - no limit).
        """
        return pulumi.get(self, "engine_config_mysql_innodb_thread_concurrency")

    @engine_config_mysql_innodb_thread_concurrency.setter
    def engine_config_mysql_innodb_thread_concurrency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_innodb_thread_concurrency", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbWriteIoThreads")
    def engine_config_mysql_innodb_write_io_threads(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of I/O threads for write operations in InnoDB. Default is 4. Changing this parameter will lead to a restart of the MySQL service.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_write_io_threads")

    @engine_config_mysql_innodb_write_io_threads.setter
    def engine_config_mysql_innodb_write_io_threads(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_innodb_write_io_threads", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInteractiveTimeout")
    def engine_config_mysql_interactive_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds the server waits for activity on an interactive connection before closing it.
        """
        return pulumi.get(self, "engine_config_mysql_interactive_timeout")

    @engine_config_mysql_interactive_timeout.setter
    def engine_config_mysql_interactive_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_interactive_timeout", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInternalTmpMemStorageEngine")
    def engine_config_mysql_internal_tmp_mem_storage_engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage engine for in-memory internal temporary tables.
        """
        return pulumi.get(self, "engine_config_mysql_internal_tmp_mem_storage_engine")

    @engine_config_mysql_internal_tmp_mem_storage_engine.setter
    def engine_config_mysql_internal_tmp_mem_storage_engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_config_mysql_internal_tmp_mem_storage_engine", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlMaxAllowedPacket")
    def engine_config_mysql_max_allowed_packet(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Size of the largest message in bytes that can be received by the server. Default is 67108864 (64M).
        """
        return pulumi.get(self, "engine_config_mysql_max_allowed_packet")

    @engine_config_mysql_max_allowed_packet.setter
    def engine_config_mysql_max_allowed_packet(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_max_allowed_packet", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlMaxHeapTableSize")
    def engine_config_mysql_max_heap_table_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Limits the size of internal in-memory tables. Also set tmp_table_size. Default is 16777216 (16M).
        """
        return pulumi.get(self, "engine_config_mysql_max_heap_table_size")

    @engine_config_mysql_max_heap_table_size.setter
    def engine_config_mysql_max_heap_table_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_max_heap_table_size", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlNetBufferLength")
    def engine_config_mysql_net_buffer_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Start sizes of connection buffer and result buffer. Default is 16384 (16K). Changing this parameter will lead to a restart of the MySQL service.
        """
        return pulumi.get(self, "engine_config_mysql_net_buffer_length")

    @engine_config_mysql_net_buffer_length.setter
    def engine_config_mysql_net_buffer_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_net_buffer_length", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlNetReadTimeout")
    def engine_config_mysql_net_read_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds to wait for more data from a connection before aborting the read.
        """
        return pulumi.get(self, "engine_config_mysql_net_read_timeout")

    @engine_config_mysql_net_read_timeout.setter
    def engine_config_mysql_net_read_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_net_read_timeout", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlNetWriteTimeout")
    def engine_config_mysql_net_write_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds to wait for a block to be written to a connection before aborting the write.
        """
        return pulumi.get(self, "engine_config_mysql_net_write_timeout")

    @engine_config_mysql_net_write_timeout.setter
    def engine_config_mysql_net_write_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_net_write_timeout", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlSortBufferSize")
    def engine_config_mysql_sort_buffer_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sort buffer size in bytes for ORDER BY optimization. Default is 262144 (256K).
        """
        return pulumi.get(self, "engine_config_mysql_sort_buffer_size")

    @engine_config_mysql_sort_buffer_size.setter
    def engine_config_mysql_sort_buffer_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_sort_buffer_size", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlSqlMode")
    def engine_config_mysql_sql_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Global SQL mode. Set to empty to use MySQL server defaults. When creating a new service and not setting this field Aiven default SQL mode (strict, SQL standard compliant) will be assigned. (default `ANSI,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION,NO_ZERO_DATE,NO_ZERO_IN_DATE,STRICT_ALL_TABLES`)
        """
        return pulumi.get(self, "engine_config_mysql_sql_mode")

    @engine_config_mysql_sql_mode.setter
    def engine_config_mysql_sql_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_config_mysql_sql_mode", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlSqlRequirePrimaryKey")
    def engine_config_mysql_sql_require_primary_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Require primary key to be defined for new tables or old tables modified with ALTER TABLE and fail if missing. It is recommended to always have primary keys because various functionality may break if any large table is missing them. (default `true`)
        """
        return pulumi.get(self, "engine_config_mysql_sql_require_primary_key")

    @engine_config_mysql_sql_require_primary_key.setter
    def engine_config_mysql_sql_require_primary_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "engine_config_mysql_sql_require_primary_key", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlTmpTableSize")
    def engine_config_mysql_tmp_table_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Limits the size of internal in-memory tables. Also set max_heap_table_size. Default is 16777216 (16M).
        """
        return pulumi.get(self, "engine_config_mysql_tmp_table_size")

    @engine_config_mysql_tmp_table_size.setter
    def engine_config_mysql_tmp_table_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_tmp_table_size", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlWaitTimeout")
    def engine_config_mysql_wait_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds the server waits for activity on a noninteractive connection before closing it.
        """
        return pulumi.get(self, "engine_config_mysql_wait_timeout")

    @engine_config_mysql_wait_timeout.setter
    def engine_config_mysql_wait_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_wait_timeout", value)

    @_builtins.property
    @pulumi.getter(name="forkRestoreTime")
    def fork_restore_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database timestamp from which it was restored.
        """
        return pulumi.get(self, "fork_restore_time")

    @fork_restore_time.setter
    def fork_restore_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fork_restore_time", value)

    @_builtins.property
    @pulumi.getter(name="forkSource")
    def fork_source(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the database that was forked from.

        * `updates` - (Optional) Configuration settings for automated patch update maintenance for the Managed Database.
        """
        return pulumi.get(self, "fork_source")

    @fork_source.setter
    def fork_source(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "fork_source", value)

    @_builtins.property
    @pulumi.getter
    def suspended(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this Managed Database should be suspended.
        """
        return pulumi.get(self, "suspended")

    @suspended.setter
    def suspended(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "suspended", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['DatabaseMysqlV2TimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['DatabaseMysqlV2TimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter
    def updates(self) -> Optional[pulumi.Input['DatabaseMysqlV2UpdatesArgs']]:
        """
        Configuration settings for automated patch update maintenance for the Managed Database.
        """
        return pulumi.get(self, "updates")

    @updates.setter
    def updates(self, value: Optional[pulumi.Input['DatabaseMysqlV2UpdatesArgs']]):
        pulumi.set(self, "updates", value)


@pulumi.input_type
class _DatabaseMysqlV2State:
    def __init__(__self__, *,
                 allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_size: Optional[pulumi.Input[_builtins.int]] = None,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_binlog_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_connect_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_default_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_mysql_group_concat_max_len: Optional[pulumi.Input[_builtins.float]] = None,
                 engine_config_mysql_information_schema_stats_expiry: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_change_buffer_max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_flush_neighbors: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_ft_min_token_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_ft_server_stopword_table: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_mysql_innodb_lock_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_log_buffer_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_online_alter_log_max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_read_io_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_rollback_on_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_config_mysql_innodb_thread_concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_write_io_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_interactive_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_internal_tmp_mem_storage_engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_mysql_max_allowed_packet: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_max_heap_table_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_net_buffer_length: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_net_read_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_net_write_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_sort_buffer_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_sql_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_mysql_sql_require_primary_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_config_mysql_tmp_table_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fork_restore_time: Optional[pulumi.Input[_builtins.str]] = None,
                 fork_source: Optional[pulumi.Input[_builtins.int]] = None,
                 host_primary: Optional[pulumi.Input[_builtins.str]] = None,
                 host_secondary: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 members: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 oldest_restore_time: Optional[pulumi.Input[_builtins.str]] = None,
                 pending_updates: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseMysqlV2PendingUpdateArgs']]]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 root_password: Optional[pulumi.Input[_builtins.str]] = None,
                 root_username: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_connection: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 suspended: Optional[pulumi.Input[_builtins.bool]] = None,
                 timeouts: Optional[pulumi.Input['DatabaseMysqlV2TimeoutsArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 updated: Optional[pulumi.Input[_builtins.str]] = None,
                 updates: Optional[pulumi.Input['DatabaseMysqlV2UpdatesArgs']] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DatabaseMysqlV2 resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allow_lists: A list of IP addresses that can access the Managed Database. Each item can be a single IP address or a range in CIDR format. Use `DatabaseAccessControls` to manage your allow list separately.
        :param pulumi.Input[_builtins.str] ca_cert: The base64-encoded SSL CA certificate for the Managed Database.
        :param pulumi.Input[_builtins.int] cluster_size: The number of Linode Instance nodes deployed to the Managed Database. (default `1`)
        :param pulumi.Input[_builtins.str] created: When this Managed Database was created.
        :param pulumi.Input[_builtins.bool] encrypted: Whether the Managed Databases is encrypted.
        :param pulumi.Input[_builtins.str] engine: The Managed Database engine. (e.g. `mysql`)
        :param pulumi.Input[_builtins.int] engine_config_binlog_retention_period: The minimum amount of time in seconds to keep binlog entries before deletion. This may be extended for services that require binlog entries for longer than the default, for example if using the MySQL Debezium Kafka connector.
        :param pulumi.Input[_builtins.int] engine_config_mysql_connect_timeout: The number of seconds that the mysqld server waits for a connect packet before responding with "Bad handshake".
        :param pulumi.Input[_builtins.str] engine_config_mysql_default_time_zone: Default server time zone as an offset from UTC (from -12:00 to +12:00), a time zone name, or `SYSTEM` to use the MySQL server default.
        :param pulumi.Input[_builtins.float] engine_config_mysql_group_concat_max_len: The maximum permitted result length in bytes for the `GROUP_CONCAT()` function.
        :param pulumi.Input[_builtins.int] engine_config_mysql_information_schema_stats_expiry: The time, in seconds, before cached statistics expire.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_change_buffer_max_size: Maximum size for the InnoDB change buffer, as a percentage of the total size of the buffer pool. Default is 25.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_flush_neighbors: Specifies whether flushing a page from the InnoDB buffer pool also flushes other dirty pages in the same extent (default is 1): 0 - dirty pages in the same extent are not flushed, 1 - flush contiguous dirty pages in the same extent, 2 - flush dirty pages in the same extent.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_ft_min_token_size: Minimum length of words that are stored in an InnoDB FULLTEXT index. Changing this parameter will lead to a restart of the MySQL service.
        :param pulumi.Input[_builtins.str] engine_config_mysql_innodb_ft_server_stopword_table: This option is used to specify your own InnoDB FULLTEXT index stopword list for all InnoDB tables. This field is nullable.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_lock_wait_timeout: The length of time in seconds an InnoDB transaction waits for a row lock before giving up. Default is 120.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_log_buffer_size: The size in bytes of the buffer that InnoDB uses to write to the log files on disk.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_online_alter_log_max_size: The upper limit in bytes on the size of the temporary log files used during online DDL operations for InnoDB tables.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_read_io_threads: The number of I/O threads for read operations in InnoDB. Default is 4. Changing this parameter will lead to a restart of the MySQL service.
        :param pulumi.Input[_builtins.bool] engine_config_mysql_innodb_rollback_on_timeout: When enabled, a transaction timeout causes InnoDB to abort and roll back the entire transaction. Changing this parameter will lead to a restart of the MySQL service.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_thread_concurrency: Defines the maximum number of threads permitted inside of InnoDB. Default is 0 (infinite concurrency - no limit).
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_write_io_threads: The number of I/O threads for write operations in InnoDB. Default is 4. Changing this parameter will lead to a restart of the MySQL service.
        :param pulumi.Input[_builtins.int] engine_config_mysql_interactive_timeout: The number of seconds the server waits for activity on an interactive connection before closing it.
        :param pulumi.Input[_builtins.str] engine_config_mysql_internal_tmp_mem_storage_engine: The storage engine for in-memory internal temporary tables.
        :param pulumi.Input[_builtins.int] engine_config_mysql_max_allowed_packet: Size of the largest message in bytes that can be received by the server. Default is 67108864 (64M).
        :param pulumi.Input[_builtins.int] engine_config_mysql_max_heap_table_size: Limits the size of internal in-memory tables. Also set tmp_table_size. Default is 16777216 (16M).
        :param pulumi.Input[_builtins.int] engine_config_mysql_net_buffer_length: Start sizes of connection buffer and result buffer. Default is 16384 (16K). Changing this parameter will lead to a restart of the MySQL service.
        :param pulumi.Input[_builtins.int] engine_config_mysql_net_read_timeout: The number of seconds to wait for more data from a connection before aborting the read.
        :param pulumi.Input[_builtins.int] engine_config_mysql_net_write_timeout: The number of seconds to wait for a block to be written to a connection before aborting the write.
        :param pulumi.Input[_builtins.int] engine_config_mysql_sort_buffer_size: Sort buffer size in bytes for ORDER BY optimization. Default is 262144 (256K).
        :param pulumi.Input[_builtins.str] engine_config_mysql_sql_mode: Global SQL mode. Set to empty to use MySQL server defaults. When creating a new service and not setting this field Aiven default SQL mode (strict, SQL standard compliant) will be assigned. (default `ANSI,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION,NO_ZERO_DATE,NO_ZERO_IN_DATE,STRICT_ALL_TABLES`)
        :param pulumi.Input[_builtins.bool] engine_config_mysql_sql_require_primary_key: Require primary key to be defined for new tables or old tables modified with ALTER TABLE and fail if missing. It is recommended to always have primary keys because various functionality may break if any large table is missing them. (default `true`)
        :param pulumi.Input[_builtins.int] engine_config_mysql_tmp_table_size: Limits the size of internal in-memory tables. Also set max_heap_table_size. Default is 16777216 (16M).
        :param pulumi.Input[_builtins.int] engine_config_mysql_wait_timeout: The number of seconds the server waits for activity on a noninteractive connection before closing it.
        :param pulumi.Input[_builtins.str] engine_id: The Managed Database engine in engine/version format. (e.g. `mysql`)
        :param pulumi.Input[_builtins.str] fork_restore_time: The database timestamp from which it was restored.
        :param pulumi.Input[_builtins.int] fork_source: The ID of the database that was forked from.
               
               * `updates` - (Optional) Configuration settings for automated patch update maintenance for the Managed Database.
        :param pulumi.Input[_builtins.str] host_primary: The primary host for the Managed Database.
        :param pulumi.Input[_builtins.str] host_secondary: The secondary/private host for the managed database.
        :param pulumi.Input[_builtins.str] label: A unique, user-defined string referring to the Managed Database.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] members: A mapping between IP addresses and strings designating them as primary or failover.
        :param pulumi.Input[_builtins.str] oldest_restore_time: The oldest time to which a database can be restored.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseMysqlV2PendingUpdateArgs']]] pending_updates: A set of pending updates.
        :param pulumi.Input[_builtins.str] platform: The back-end platform for relational databases used by the service.
        :param pulumi.Input[_builtins.int] port: The access port for this Managed Database.
        :param pulumi.Input[_builtins.str] region: The region to use for the Managed Database.
        :param pulumi.Input[_builtins.str] root_password: The randomly-generated root password for the Managed Database instance.
        :param pulumi.Input[_builtins.str] root_username: The root username for the Managed Database instance.
        :param pulumi.Input[_builtins.bool] ssl_connection: Whether to require SSL credentials to establish a connection to the Managed Database.
        :param pulumi.Input[_builtins.str] status: The operating status of the Managed Database.
        :param pulumi.Input[_builtins.bool] suspended: Whether this Managed Database should be suspended.
        :param pulumi.Input[_builtins.str] type: The Linode Instance type used for the nodes of the Managed Database.
               
               - - -
        :param pulumi.Input[_builtins.str] updated: When this Managed Database was last updated.
        :param pulumi.Input['DatabaseMysqlV2UpdatesArgs'] updates: Configuration settings for automated patch update maintenance for the Managed Database.
        :param pulumi.Input[_builtins.str] version: The Managed Database engine version. (e.g. `13.2`)
        """
        if allow_lists is not None:
            pulumi.set(__self__, "allow_lists", allow_lists)
        if ca_cert is not None:
            pulumi.set(__self__, "ca_cert", ca_cert)
        if cluster_size is not None:
            pulumi.set(__self__, "cluster_size", cluster_size)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_config_binlog_retention_period is not None:
            pulumi.set(__self__, "engine_config_binlog_retention_period", engine_config_binlog_retention_period)
        if engine_config_mysql_connect_timeout is not None:
            pulumi.set(__self__, "engine_config_mysql_connect_timeout", engine_config_mysql_connect_timeout)
        if engine_config_mysql_default_time_zone is not None:
            pulumi.set(__self__, "engine_config_mysql_default_time_zone", engine_config_mysql_default_time_zone)
        if engine_config_mysql_group_concat_max_len is not None:
            pulumi.set(__self__, "engine_config_mysql_group_concat_max_len", engine_config_mysql_group_concat_max_len)
        if engine_config_mysql_information_schema_stats_expiry is not None:
            pulumi.set(__self__, "engine_config_mysql_information_schema_stats_expiry", engine_config_mysql_information_schema_stats_expiry)
        if engine_config_mysql_innodb_change_buffer_max_size is not None:
            pulumi.set(__self__, "engine_config_mysql_innodb_change_buffer_max_size", engine_config_mysql_innodb_change_buffer_max_size)
        if engine_config_mysql_innodb_flush_neighbors is not None:
            pulumi.set(__self__, "engine_config_mysql_innodb_flush_neighbors", engine_config_mysql_innodb_flush_neighbors)
        if engine_config_mysql_innodb_ft_min_token_size is not None:
            pulumi.set(__self__, "engine_config_mysql_innodb_ft_min_token_size", engine_config_mysql_innodb_ft_min_token_size)
        if engine_config_mysql_innodb_ft_server_stopword_table is not None:
            pulumi.set(__self__, "engine_config_mysql_innodb_ft_server_stopword_table", engine_config_mysql_innodb_ft_server_stopword_table)
        if engine_config_mysql_innodb_lock_wait_timeout is not None:
            pulumi.set(__self__, "engine_config_mysql_innodb_lock_wait_timeout", engine_config_mysql_innodb_lock_wait_timeout)
        if engine_config_mysql_innodb_log_buffer_size is not None:
            pulumi.set(__self__, "engine_config_mysql_innodb_log_buffer_size", engine_config_mysql_innodb_log_buffer_size)
        if engine_config_mysql_innodb_online_alter_log_max_size is not None:
            pulumi.set(__self__, "engine_config_mysql_innodb_online_alter_log_max_size", engine_config_mysql_innodb_online_alter_log_max_size)
        if engine_config_mysql_innodb_read_io_threads is not None:
            pulumi.set(__self__, "engine_config_mysql_innodb_read_io_threads", engine_config_mysql_innodb_read_io_threads)
        if engine_config_mysql_innodb_rollback_on_timeout is not None:
            pulumi.set(__self__, "engine_config_mysql_innodb_rollback_on_timeout", engine_config_mysql_innodb_rollback_on_timeout)
        if engine_config_mysql_innodb_thread_concurrency is not None:
            pulumi.set(__self__, "engine_config_mysql_innodb_thread_concurrency", engine_config_mysql_innodb_thread_concurrency)
        if engine_config_mysql_innodb_write_io_threads is not None:
            pulumi.set(__self__, "engine_config_mysql_innodb_write_io_threads", engine_config_mysql_innodb_write_io_threads)
        if engine_config_mysql_interactive_timeout is not None:
            pulumi.set(__self__, "engine_config_mysql_interactive_timeout", engine_config_mysql_interactive_timeout)
        if engine_config_mysql_internal_tmp_mem_storage_engine is not None:
            pulumi.set(__self__, "engine_config_mysql_internal_tmp_mem_storage_engine", engine_config_mysql_internal_tmp_mem_storage_engine)
        if engine_config_mysql_max_allowed_packet is not None:
            pulumi.set(__self__, "engine_config_mysql_max_allowed_packet", engine_config_mysql_max_allowed_packet)
        if engine_config_mysql_max_heap_table_size is not None:
            pulumi.set(__self__, "engine_config_mysql_max_heap_table_size", engine_config_mysql_max_heap_table_size)
        if engine_config_mysql_net_buffer_length is not None:
            pulumi.set(__self__, "engine_config_mysql_net_buffer_length", engine_config_mysql_net_buffer_length)
        if engine_config_mysql_net_read_timeout is not None:
            pulumi.set(__self__, "engine_config_mysql_net_read_timeout", engine_config_mysql_net_read_timeout)
        if engine_config_mysql_net_write_timeout is not None:
            pulumi.set(__self__, "engine_config_mysql_net_write_timeout", engine_config_mysql_net_write_timeout)
        if engine_config_mysql_sort_buffer_size is not None:
            pulumi.set(__self__, "engine_config_mysql_sort_buffer_size", engine_config_mysql_sort_buffer_size)
        if engine_config_mysql_sql_mode is not None:
            pulumi.set(__self__, "engine_config_mysql_sql_mode", engine_config_mysql_sql_mode)
        if engine_config_mysql_sql_require_primary_key is not None:
            pulumi.set(__self__, "engine_config_mysql_sql_require_primary_key", engine_config_mysql_sql_require_primary_key)
        if engine_config_mysql_tmp_table_size is not None:
            pulumi.set(__self__, "engine_config_mysql_tmp_table_size", engine_config_mysql_tmp_table_size)
        if engine_config_mysql_wait_timeout is not None:
            pulumi.set(__self__, "engine_config_mysql_wait_timeout", engine_config_mysql_wait_timeout)
        if engine_id is not None:
            pulumi.set(__self__, "engine_id", engine_id)
        if fork_restore_time is not None:
            pulumi.set(__self__, "fork_restore_time", fork_restore_time)
        if fork_source is not None:
            pulumi.set(__self__, "fork_source", fork_source)
        if host_primary is not None:
            pulumi.set(__self__, "host_primary", host_primary)
        if host_secondary is not None:
            pulumi.set(__self__, "host_secondary", host_secondary)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if oldest_restore_time is not None:
            pulumi.set(__self__, "oldest_restore_time", oldest_restore_time)
        if pending_updates is not None:
            pulumi.set(__self__, "pending_updates", pending_updates)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if root_password is not None:
            pulumi.set(__self__, "root_password", root_password)
        if root_username is not None:
            pulumi.set(__self__, "root_username", root_username)
        if ssl_connection is not None:
            pulumi.set(__self__, "ssl_connection", ssl_connection)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if suspended is not None:
            pulumi.set(__self__, "suspended", suspended)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated is not None:
            pulumi.set(__self__, "updated", updated)
        if updates is not None:
            pulumi.set(__self__, "updates", updates)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="allowLists")
    def allow_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IP addresses that can access the Managed Database. Each item can be a single IP address or a range in CIDR format. Use `DatabaseAccessControls` to manage your allow list separately.
        """
        return pulumi.get(self, "allow_lists")

    @allow_lists.setter
    def allow_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allow_lists", value)

    @_builtins.property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64-encoded SSL CA certificate for the Managed Database.
        """
        return pulumi.get(self, "ca_cert")

    @ca_cert.setter
    def ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of Linode Instance nodes deployed to the Managed Database. (default `1`)
        """
        return pulumi.get(self, "cluster_size")

    @cluster_size.setter
    def cluster_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cluster_size", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When this Managed Database was created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the Managed Databases is encrypted.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encrypted", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Managed Database engine. (e.g. `mysql`)
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigBinlogRetentionPeriod")
    def engine_config_binlog_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum amount of time in seconds to keep binlog entries before deletion. This may be extended for services that require binlog entries for longer than the default, for example if using the MySQL Debezium Kafka connector.
        """
        return pulumi.get(self, "engine_config_binlog_retention_period")

    @engine_config_binlog_retention_period.setter
    def engine_config_binlog_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_binlog_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlConnectTimeout")
    def engine_config_mysql_connect_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds that the mysqld server waits for a connect packet before responding with "Bad handshake".
        """
        return pulumi.get(self, "engine_config_mysql_connect_timeout")

    @engine_config_mysql_connect_timeout.setter
    def engine_config_mysql_connect_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_connect_timeout", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlDefaultTimeZone")
    def engine_config_mysql_default_time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default server time zone as an offset from UTC (from -12:00 to +12:00), a time zone name, or `SYSTEM` to use the MySQL server default.
        """
        return pulumi.get(self, "engine_config_mysql_default_time_zone")

    @engine_config_mysql_default_time_zone.setter
    def engine_config_mysql_default_time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_config_mysql_default_time_zone", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlGroupConcatMaxLen")
    def engine_config_mysql_group_concat_max_len(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The maximum permitted result length in bytes for the `GROUP_CONCAT()` function.
        """
        return pulumi.get(self, "engine_config_mysql_group_concat_max_len")

    @engine_config_mysql_group_concat_max_len.setter
    def engine_config_mysql_group_concat_max_len(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "engine_config_mysql_group_concat_max_len", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInformationSchemaStatsExpiry")
    def engine_config_mysql_information_schema_stats_expiry(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time, in seconds, before cached statistics expire.
        """
        return pulumi.get(self, "engine_config_mysql_information_schema_stats_expiry")

    @engine_config_mysql_information_schema_stats_expiry.setter
    def engine_config_mysql_information_schema_stats_expiry(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_information_schema_stats_expiry", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbChangeBufferMaxSize")
    def engine_config_mysql_innodb_change_buffer_max_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum size for the InnoDB change buffer, as a percentage of the total size of the buffer pool. Default is 25.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_change_buffer_max_size")

    @engine_config_mysql_innodb_change_buffer_max_size.setter
    def engine_config_mysql_innodb_change_buffer_max_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_innodb_change_buffer_max_size", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbFlushNeighbors")
    def engine_config_mysql_innodb_flush_neighbors(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies whether flushing a page from the InnoDB buffer pool also flushes other dirty pages in the same extent (default is 1): 0 - dirty pages in the same extent are not flushed, 1 - flush contiguous dirty pages in the same extent, 2 - flush dirty pages in the same extent.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_flush_neighbors")

    @engine_config_mysql_innodb_flush_neighbors.setter
    def engine_config_mysql_innodb_flush_neighbors(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_innodb_flush_neighbors", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbFtMinTokenSize")
    def engine_config_mysql_innodb_ft_min_token_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum length of words that are stored in an InnoDB FULLTEXT index. Changing this parameter will lead to a restart of the MySQL service.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_ft_min_token_size")

    @engine_config_mysql_innodb_ft_min_token_size.setter
    def engine_config_mysql_innodb_ft_min_token_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_innodb_ft_min_token_size", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbFtServerStopwordTable")
    def engine_config_mysql_innodb_ft_server_stopword_table(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This option is used to specify your own InnoDB FULLTEXT index stopword list for all InnoDB tables. This field is nullable.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_ft_server_stopword_table")

    @engine_config_mysql_innodb_ft_server_stopword_table.setter
    def engine_config_mysql_innodb_ft_server_stopword_table(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_config_mysql_innodb_ft_server_stopword_table", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbLockWaitTimeout")
    def engine_config_mysql_innodb_lock_wait_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The length of time in seconds an InnoDB transaction waits for a row lock before giving up. Default is 120.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_lock_wait_timeout")

    @engine_config_mysql_innodb_lock_wait_timeout.setter
    def engine_config_mysql_innodb_lock_wait_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_innodb_lock_wait_timeout", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbLogBufferSize")
    def engine_config_mysql_innodb_log_buffer_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size in bytes of the buffer that InnoDB uses to write to the log files on disk.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_log_buffer_size")

    @engine_config_mysql_innodb_log_buffer_size.setter
    def engine_config_mysql_innodb_log_buffer_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_innodb_log_buffer_size", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbOnlineAlterLogMaxSize")
    def engine_config_mysql_innodb_online_alter_log_max_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The upper limit in bytes on the size of the temporary log files used during online DDL operations for InnoDB tables.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_online_alter_log_max_size")

    @engine_config_mysql_innodb_online_alter_log_max_size.setter
    def engine_config_mysql_innodb_online_alter_log_max_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_innodb_online_alter_log_max_size", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbReadIoThreads")
    def engine_config_mysql_innodb_read_io_threads(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of I/O threads for read operations in InnoDB. Default is 4. Changing this parameter will lead to a restart of the MySQL service.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_read_io_threads")

    @engine_config_mysql_innodb_read_io_threads.setter
    def engine_config_mysql_innodb_read_io_threads(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_innodb_read_io_threads", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbRollbackOnTimeout")
    def engine_config_mysql_innodb_rollback_on_timeout(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, a transaction timeout causes InnoDB to abort and roll back the entire transaction. Changing this parameter will lead to a restart of the MySQL service.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_rollback_on_timeout")

    @engine_config_mysql_innodb_rollback_on_timeout.setter
    def engine_config_mysql_innodb_rollback_on_timeout(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "engine_config_mysql_innodb_rollback_on_timeout", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbThreadConcurrency")
    def engine_config_mysql_innodb_thread_concurrency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Defines the maximum number of threads permitted inside of InnoDB. Default is 0 (infinite concurrency - no limit).
        """
        return pulumi.get(self, "engine_config_mysql_innodb_thread_concurrency")

    @engine_config_mysql_innodb_thread_concurrency.setter
    def engine_config_mysql_innodb_thread_concurrency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_innodb_thread_concurrency", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbWriteIoThreads")
    def engine_config_mysql_innodb_write_io_threads(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of I/O threads for write operations in InnoDB. Default is 4. Changing this parameter will lead to a restart of the MySQL service.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_write_io_threads")

    @engine_config_mysql_innodb_write_io_threads.setter
    def engine_config_mysql_innodb_write_io_threads(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_innodb_write_io_threads", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInteractiveTimeout")
    def engine_config_mysql_interactive_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds the server waits for activity on an interactive connection before closing it.
        """
        return pulumi.get(self, "engine_config_mysql_interactive_timeout")

    @engine_config_mysql_interactive_timeout.setter
    def engine_config_mysql_interactive_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_interactive_timeout", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInternalTmpMemStorageEngine")
    def engine_config_mysql_internal_tmp_mem_storage_engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage engine for in-memory internal temporary tables.
        """
        return pulumi.get(self, "engine_config_mysql_internal_tmp_mem_storage_engine")

    @engine_config_mysql_internal_tmp_mem_storage_engine.setter
    def engine_config_mysql_internal_tmp_mem_storage_engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_config_mysql_internal_tmp_mem_storage_engine", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlMaxAllowedPacket")
    def engine_config_mysql_max_allowed_packet(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Size of the largest message in bytes that can be received by the server. Default is 67108864 (64M).
        """
        return pulumi.get(self, "engine_config_mysql_max_allowed_packet")

    @engine_config_mysql_max_allowed_packet.setter
    def engine_config_mysql_max_allowed_packet(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_max_allowed_packet", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlMaxHeapTableSize")
    def engine_config_mysql_max_heap_table_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Limits the size of internal in-memory tables. Also set tmp_table_size. Default is 16777216 (16M).
        """
        return pulumi.get(self, "engine_config_mysql_max_heap_table_size")

    @engine_config_mysql_max_heap_table_size.setter
    def engine_config_mysql_max_heap_table_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_max_heap_table_size", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlNetBufferLength")
    def engine_config_mysql_net_buffer_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Start sizes of connection buffer and result buffer. Default is 16384 (16K). Changing this parameter will lead to a restart of the MySQL service.
        """
        return pulumi.get(self, "engine_config_mysql_net_buffer_length")

    @engine_config_mysql_net_buffer_length.setter
    def engine_config_mysql_net_buffer_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_net_buffer_length", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlNetReadTimeout")
    def engine_config_mysql_net_read_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds to wait for more data from a connection before aborting the read.
        """
        return pulumi.get(self, "engine_config_mysql_net_read_timeout")

    @engine_config_mysql_net_read_timeout.setter
    def engine_config_mysql_net_read_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_net_read_timeout", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlNetWriteTimeout")
    def engine_config_mysql_net_write_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds to wait for a block to be written to a connection before aborting the write.
        """
        return pulumi.get(self, "engine_config_mysql_net_write_timeout")

    @engine_config_mysql_net_write_timeout.setter
    def engine_config_mysql_net_write_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_net_write_timeout", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlSortBufferSize")
    def engine_config_mysql_sort_buffer_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sort buffer size in bytes for ORDER BY optimization. Default is 262144 (256K).
        """
        return pulumi.get(self, "engine_config_mysql_sort_buffer_size")

    @engine_config_mysql_sort_buffer_size.setter
    def engine_config_mysql_sort_buffer_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_sort_buffer_size", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlSqlMode")
    def engine_config_mysql_sql_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Global SQL mode. Set to empty to use MySQL server defaults. When creating a new service and not setting this field Aiven default SQL mode (strict, SQL standard compliant) will be assigned. (default `ANSI,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION,NO_ZERO_DATE,NO_ZERO_IN_DATE,STRICT_ALL_TABLES`)
        """
        return pulumi.get(self, "engine_config_mysql_sql_mode")

    @engine_config_mysql_sql_mode.setter
    def engine_config_mysql_sql_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_config_mysql_sql_mode", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlSqlRequirePrimaryKey")
    def engine_config_mysql_sql_require_primary_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Require primary key to be defined for new tables or old tables modified with ALTER TABLE and fail if missing. It is recommended to always have primary keys because various functionality may break if any large table is missing them. (default `true`)
        """
        return pulumi.get(self, "engine_config_mysql_sql_require_primary_key")

    @engine_config_mysql_sql_require_primary_key.setter
    def engine_config_mysql_sql_require_primary_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "engine_config_mysql_sql_require_primary_key", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlTmpTableSize")
    def engine_config_mysql_tmp_table_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Limits the size of internal in-memory tables. Also set max_heap_table_size. Default is 16777216 (16M).
        """
        return pulumi.get(self, "engine_config_mysql_tmp_table_size")

    @engine_config_mysql_tmp_table_size.setter
    def engine_config_mysql_tmp_table_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_tmp_table_size", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlWaitTimeout")
    def engine_config_mysql_wait_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds the server waits for activity on a noninteractive connection before closing it.
        """
        return pulumi.get(self, "engine_config_mysql_wait_timeout")

    @engine_config_mysql_wait_timeout.setter
    def engine_config_mysql_wait_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_mysql_wait_timeout", value)

    @_builtins.property
    @pulumi.getter(name="engineId")
    def engine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Managed Database engine in engine/version format. (e.g. `mysql`)
        """
        return pulumi.get(self, "engine_id")

    @engine_id.setter
    def engine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_id", value)

    @_builtins.property
    @pulumi.getter(name="forkRestoreTime")
    def fork_restore_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database timestamp from which it was restored.
        """
        return pulumi.get(self, "fork_restore_time")

    @fork_restore_time.setter
    def fork_restore_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fork_restore_time", value)

    @_builtins.property
    @pulumi.getter(name="forkSource")
    def fork_source(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the database that was forked from.

        * `updates` - (Optional) Configuration settings for automated patch update maintenance for the Managed Database.
        """
        return pulumi.get(self, "fork_source")

    @fork_source.setter
    def fork_source(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "fork_source", value)

    @_builtins.property
    @pulumi.getter(name="hostPrimary")
    def host_primary(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The primary host for the Managed Database.
        """
        return pulumi.get(self, "host_primary")

    @host_primary.setter
    def host_primary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_primary", value)

    @_builtins.property
    @pulumi.getter(name="hostSecondary")
    def host_secondary(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secondary/private host for the managed database.
        """
        return pulumi.get(self, "host_secondary")

    @host_secondary.setter
    def host_secondary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_secondary", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique, user-defined string referring to the Managed Database.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping between IP addresses and strings designating them as primary or failover.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "members", value)

    @_builtins.property
    @pulumi.getter(name="oldestRestoreTime")
    def oldest_restore_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The oldest time to which a database can be restored.
        """
        return pulumi.get(self, "oldest_restore_time")

    @oldest_restore_time.setter
    def oldest_restore_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oldest_restore_time", value)

    @_builtins.property
    @pulumi.getter(name="pendingUpdates")
    def pending_updates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseMysqlV2PendingUpdateArgs']]]]:
        """
        A set of pending updates.
        """
        return pulumi.get(self, "pending_updates")

    @pending_updates.setter
    def pending_updates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseMysqlV2PendingUpdateArgs']]]]):
        pulumi.set(self, "pending_updates", value)

    @_builtins.property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The back-end platform for relational databases used by the service.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The access port for this Managed Database.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the Managed Database.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The randomly-generated root password for the Managed Database instance.
        """
        return pulumi.get(self, "root_password")

    @root_password.setter
    def root_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "root_password", value)

    @_builtins.property
    @pulumi.getter(name="rootUsername")
    def root_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The root username for the Managed Database instance.
        """
        return pulumi.get(self, "root_username")

    @root_username.setter
    def root_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "root_username", value)

    @_builtins.property
    @pulumi.getter(name="sslConnection")
    def ssl_connection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to require SSL credentials to establish a connection to the Managed Database.
        """
        return pulumi.get(self, "ssl_connection")

    @ssl_connection.setter
    def ssl_connection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssl_connection", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operating status of the Managed Database.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def suspended(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this Managed Database should be suspended.
        """
        return pulumi.get(self, "suspended")

    @suspended.setter
    def suspended(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "suspended", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['DatabaseMysqlV2TimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['DatabaseMysqlV2TimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Linode Instance type used for the nodes of the Managed Database.

        - - -
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When this Managed Database was last updated.
        """
        return pulumi.get(self, "updated")

    @updated.setter
    def updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated", value)

    @_builtins.property
    @pulumi.getter
    def updates(self) -> Optional[pulumi.Input['DatabaseMysqlV2UpdatesArgs']]:
        """
        Configuration settings for automated patch update maintenance for the Managed Database.
        """
        return pulumi.get(self, "updates")

    @updates.setter
    def updates(self, value: Optional[pulumi.Input['DatabaseMysqlV2UpdatesArgs']]):
        pulumi.set(self, "updates", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Managed Database engine version. (e.g. `13.2`)
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("linode:index/databaseMysqlV2:DatabaseMysqlV2")
class DatabaseMysqlV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cluster_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_binlog_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_connect_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_default_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_mysql_group_concat_max_len: Optional[pulumi.Input[_builtins.float]] = None,
                 engine_config_mysql_information_schema_stats_expiry: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_change_buffer_max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_flush_neighbors: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_ft_min_token_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_ft_server_stopword_table: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_mysql_innodb_lock_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_log_buffer_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_online_alter_log_max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_read_io_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_rollback_on_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_config_mysql_innodb_thread_concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_write_io_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_interactive_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_internal_tmp_mem_storage_engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_mysql_max_allowed_packet: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_max_heap_table_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_net_buffer_length: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_net_read_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_net_write_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_sort_buffer_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_sql_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_mysql_sql_require_primary_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_config_mysql_tmp_table_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fork_restore_time: Optional[pulumi.Input[_builtins.str]] = None,
                 fork_source: Optional[pulumi.Input[_builtins.int]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 suspended: Optional[pulumi.Input[_builtins.bool]] = None,
                 timeouts: Optional[pulumi.Input[Union['DatabaseMysqlV2TimeoutsArgs', 'DatabaseMysqlV2TimeoutsArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 updates: Optional[pulumi.Input[Union['DatabaseMysqlV2UpdatesArgs', 'DatabaseMysqlV2UpdatesArgsDict']]] = None,
                 __props__=None):
        """
        Provides a Linode MySQL Database resource. This can be used to create, modify, and delete Linode MySQL Databases.
        For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/post-databases-mysql-instances).

        Please keep in mind that Managed Databases can take up to half an hour to provision.

        ## Example Usage

        Creating a simple MySQL database that does not allow connections:

        ```python
        import pulumi
        import pulumi_linode as linode

        foobar = linode.DatabaseMysqlV2("foobar",
            label="mydatabase",
            engine_id="mysql/8",
            region="us-mia",
            type="g6-nanode-1")
        ```

        Creating a simple MySQL database that allows connections from all IPv4 addresses:

        ```python
        import pulumi
        import pulumi_linode as linode

        foobar = linode.DatabaseMysqlV2("foobar",
            label="mydatabase",
            engine_id="mysql/8",
            region="us-mia",
            type="g6-nanode-1",
            allow_lists=["0.0.0.0/0"])
        ```

        Creating a complex MySQL database:

        ## Import

        Linode MySQL Databases can be imported using the `id`, e.g.

        ```sh
        $ pulumi import linode:index/databaseMysqlV2:DatabaseMysqlV2 foobar 1234567
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allow_lists: A list of IP addresses that can access the Managed Database. Each item can be a single IP address or a range in CIDR format. Use `DatabaseAccessControls` to manage your allow list separately.
        :param pulumi.Input[_builtins.int] cluster_size: The number of Linode Instance nodes deployed to the Managed Database. (default `1`)
        :param pulumi.Input[_builtins.int] engine_config_binlog_retention_period: The minimum amount of time in seconds to keep binlog entries before deletion. This may be extended for services that require binlog entries for longer than the default, for example if using the MySQL Debezium Kafka connector.
        :param pulumi.Input[_builtins.int] engine_config_mysql_connect_timeout: The number of seconds that the mysqld server waits for a connect packet before responding with "Bad handshake".
        :param pulumi.Input[_builtins.str] engine_config_mysql_default_time_zone: Default server time zone as an offset from UTC (from -12:00 to +12:00), a time zone name, or `SYSTEM` to use the MySQL server default.
        :param pulumi.Input[_builtins.float] engine_config_mysql_group_concat_max_len: The maximum permitted result length in bytes for the `GROUP_CONCAT()` function.
        :param pulumi.Input[_builtins.int] engine_config_mysql_information_schema_stats_expiry: The time, in seconds, before cached statistics expire.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_change_buffer_max_size: Maximum size for the InnoDB change buffer, as a percentage of the total size of the buffer pool. Default is 25.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_flush_neighbors: Specifies whether flushing a page from the InnoDB buffer pool also flushes other dirty pages in the same extent (default is 1): 0 - dirty pages in the same extent are not flushed, 1 - flush contiguous dirty pages in the same extent, 2 - flush dirty pages in the same extent.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_ft_min_token_size: Minimum length of words that are stored in an InnoDB FULLTEXT index. Changing this parameter will lead to a restart of the MySQL service.
        :param pulumi.Input[_builtins.str] engine_config_mysql_innodb_ft_server_stopword_table: This option is used to specify your own InnoDB FULLTEXT index stopword list for all InnoDB tables. This field is nullable.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_lock_wait_timeout: The length of time in seconds an InnoDB transaction waits for a row lock before giving up. Default is 120.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_log_buffer_size: The size in bytes of the buffer that InnoDB uses to write to the log files on disk.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_online_alter_log_max_size: The upper limit in bytes on the size of the temporary log files used during online DDL operations for InnoDB tables.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_read_io_threads: The number of I/O threads for read operations in InnoDB. Default is 4. Changing this parameter will lead to a restart of the MySQL service.
        :param pulumi.Input[_builtins.bool] engine_config_mysql_innodb_rollback_on_timeout: When enabled, a transaction timeout causes InnoDB to abort and roll back the entire transaction. Changing this parameter will lead to a restart of the MySQL service.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_thread_concurrency: Defines the maximum number of threads permitted inside of InnoDB. Default is 0 (infinite concurrency - no limit).
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_write_io_threads: The number of I/O threads for write operations in InnoDB. Default is 4. Changing this parameter will lead to a restart of the MySQL service.
        :param pulumi.Input[_builtins.int] engine_config_mysql_interactive_timeout: The number of seconds the server waits for activity on an interactive connection before closing it.
        :param pulumi.Input[_builtins.str] engine_config_mysql_internal_tmp_mem_storage_engine: The storage engine for in-memory internal temporary tables.
        :param pulumi.Input[_builtins.int] engine_config_mysql_max_allowed_packet: Size of the largest message in bytes that can be received by the server. Default is 67108864 (64M).
        :param pulumi.Input[_builtins.int] engine_config_mysql_max_heap_table_size: Limits the size of internal in-memory tables. Also set tmp_table_size. Default is 16777216 (16M).
        :param pulumi.Input[_builtins.int] engine_config_mysql_net_buffer_length: Start sizes of connection buffer and result buffer. Default is 16384 (16K). Changing this parameter will lead to a restart of the MySQL service.
        :param pulumi.Input[_builtins.int] engine_config_mysql_net_read_timeout: The number of seconds to wait for more data from a connection before aborting the read.
        :param pulumi.Input[_builtins.int] engine_config_mysql_net_write_timeout: The number of seconds to wait for a block to be written to a connection before aborting the write.
        :param pulumi.Input[_builtins.int] engine_config_mysql_sort_buffer_size: Sort buffer size in bytes for ORDER BY optimization. Default is 262144 (256K).
        :param pulumi.Input[_builtins.str] engine_config_mysql_sql_mode: Global SQL mode. Set to empty to use MySQL server defaults. When creating a new service and not setting this field Aiven default SQL mode (strict, SQL standard compliant) will be assigned. (default `ANSI,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION,NO_ZERO_DATE,NO_ZERO_IN_DATE,STRICT_ALL_TABLES`)
        :param pulumi.Input[_builtins.bool] engine_config_mysql_sql_require_primary_key: Require primary key to be defined for new tables or old tables modified with ALTER TABLE and fail if missing. It is recommended to always have primary keys because various functionality may break if any large table is missing them. (default `true`)
        :param pulumi.Input[_builtins.int] engine_config_mysql_tmp_table_size: Limits the size of internal in-memory tables. Also set max_heap_table_size. Default is 16777216 (16M).
        :param pulumi.Input[_builtins.int] engine_config_mysql_wait_timeout: The number of seconds the server waits for activity on a noninteractive connection before closing it.
        :param pulumi.Input[_builtins.str] engine_id: The Managed Database engine in engine/version format. (e.g. `mysql`)
        :param pulumi.Input[_builtins.str] fork_restore_time: The database timestamp from which it was restored.
        :param pulumi.Input[_builtins.int] fork_source: The ID of the database that was forked from.
               
               * `updates` - (Optional) Configuration settings for automated patch update maintenance for the Managed Database.
        :param pulumi.Input[_builtins.str] label: A unique, user-defined string referring to the Managed Database.
        :param pulumi.Input[_builtins.str] region: The region to use for the Managed Database.
        :param pulumi.Input[_builtins.bool] suspended: Whether this Managed Database should be suspended.
        :param pulumi.Input[_builtins.str] type: The Linode Instance type used for the nodes of the Managed Database.
               
               - - -
        :param pulumi.Input[Union['DatabaseMysqlV2UpdatesArgs', 'DatabaseMysqlV2UpdatesArgsDict']] updates: Configuration settings for automated patch update maintenance for the Managed Database.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseMysqlV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Linode MySQL Database resource. This can be used to create, modify, and delete Linode MySQL Databases.
        For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/post-databases-mysql-instances).

        Please keep in mind that Managed Databases can take up to half an hour to provision.

        ## Example Usage

        Creating a simple MySQL database that does not allow connections:

        ```python
        import pulumi
        import pulumi_linode as linode

        foobar = linode.DatabaseMysqlV2("foobar",
            label="mydatabase",
            engine_id="mysql/8",
            region="us-mia",
            type="g6-nanode-1")
        ```

        Creating a simple MySQL database that allows connections from all IPv4 addresses:

        ```python
        import pulumi
        import pulumi_linode as linode

        foobar = linode.DatabaseMysqlV2("foobar",
            label="mydatabase",
            engine_id="mysql/8",
            region="us-mia",
            type="g6-nanode-1",
            allow_lists=["0.0.0.0/0"])
        ```

        Creating a complex MySQL database:

        ## Import

        Linode MySQL Databases can be imported using the `id`, e.g.

        ```sh
        $ pulumi import linode:index/databaseMysqlV2:DatabaseMysqlV2 foobar 1234567
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseMysqlV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseMysqlV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cluster_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_binlog_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_connect_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_default_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_mysql_group_concat_max_len: Optional[pulumi.Input[_builtins.float]] = None,
                 engine_config_mysql_information_schema_stats_expiry: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_change_buffer_max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_flush_neighbors: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_ft_min_token_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_ft_server_stopword_table: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_mysql_innodb_lock_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_log_buffer_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_online_alter_log_max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_read_io_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_rollback_on_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_config_mysql_innodb_thread_concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_innodb_write_io_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_interactive_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_internal_tmp_mem_storage_engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_mysql_max_allowed_packet: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_max_heap_table_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_net_buffer_length: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_net_read_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_net_write_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_sort_buffer_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_sql_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_mysql_sql_require_primary_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_config_mysql_tmp_table_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_mysql_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fork_restore_time: Optional[pulumi.Input[_builtins.str]] = None,
                 fork_source: Optional[pulumi.Input[_builtins.int]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 suspended: Optional[pulumi.Input[_builtins.bool]] = None,
                 timeouts: Optional[pulumi.Input[Union['DatabaseMysqlV2TimeoutsArgs', 'DatabaseMysqlV2TimeoutsArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 updates: Optional[pulumi.Input[Union['DatabaseMysqlV2UpdatesArgs', 'DatabaseMysqlV2UpdatesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseMysqlV2Args.__new__(DatabaseMysqlV2Args)

            __props__.__dict__["allow_lists"] = allow_lists
            __props__.__dict__["cluster_size"] = cluster_size
            __props__.__dict__["engine_config_binlog_retention_period"] = engine_config_binlog_retention_period
            __props__.__dict__["engine_config_mysql_connect_timeout"] = engine_config_mysql_connect_timeout
            __props__.__dict__["engine_config_mysql_default_time_zone"] = engine_config_mysql_default_time_zone
            __props__.__dict__["engine_config_mysql_group_concat_max_len"] = engine_config_mysql_group_concat_max_len
            __props__.__dict__["engine_config_mysql_information_schema_stats_expiry"] = engine_config_mysql_information_schema_stats_expiry
            __props__.__dict__["engine_config_mysql_innodb_change_buffer_max_size"] = engine_config_mysql_innodb_change_buffer_max_size
            __props__.__dict__["engine_config_mysql_innodb_flush_neighbors"] = engine_config_mysql_innodb_flush_neighbors
            __props__.__dict__["engine_config_mysql_innodb_ft_min_token_size"] = engine_config_mysql_innodb_ft_min_token_size
            __props__.__dict__["engine_config_mysql_innodb_ft_server_stopword_table"] = engine_config_mysql_innodb_ft_server_stopword_table
            __props__.__dict__["engine_config_mysql_innodb_lock_wait_timeout"] = engine_config_mysql_innodb_lock_wait_timeout
            __props__.__dict__["engine_config_mysql_innodb_log_buffer_size"] = engine_config_mysql_innodb_log_buffer_size
            __props__.__dict__["engine_config_mysql_innodb_online_alter_log_max_size"] = engine_config_mysql_innodb_online_alter_log_max_size
            __props__.__dict__["engine_config_mysql_innodb_read_io_threads"] = engine_config_mysql_innodb_read_io_threads
            __props__.__dict__["engine_config_mysql_innodb_rollback_on_timeout"] = engine_config_mysql_innodb_rollback_on_timeout
            __props__.__dict__["engine_config_mysql_innodb_thread_concurrency"] = engine_config_mysql_innodb_thread_concurrency
            __props__.__dict__["engine_config_mysql_innodb_write_io_threads"] = engine_config_mysql_innodb_write_io_threads
            __props__.__dict__["engine_config_mysql_interactive_timeout"] = engine_config_mysql_interactive_timeout
            __props__.__dict__["engine_config_mysql_internal_tmp_mem_storage_engine"] = engine_config_mysql_internal_tmp_mem_storage_engine
            __props__.__dict__["engine_config_mysql_max_allowed_packet"] = engine_config_mysql_max_allowed_packet
            __props__.__dict__["engine_config_mysql_max_heap_table_size"] = engine_config_mysql_max_heap_table_size
            __props__.__dict__["engine_config_mysql_net_buffer_length"] = engine_config_mysql_net_buffer_length
            __props__.__dict__["engine_config_mysql_net_read_timeout"] = engine_config_mysql_net_read_timeout
            __props__.__dict__["engine_config_mysql_net_write_timeout"] = engine_config_mysql_net_write_timeout
            __props__.__dict__["engine_config_mysql_sort_buffer_size"] = engine_config_mysql_sort_buffer_size
            __props__.__dict__["engine_config_mysql_sql_mode"] = engine_config_mysql_sql_mode
            __props__.__dict__["engine_config_mysql_sql_require_primary_key"] = engine_config_mysql_sql_require_primary_key
            __props__.__dict__["engine_config_mysql_tmp_table_size"] = engine_config_mysql_tmp_table_size
            __props__.__dict__["engine_config_mysql_wait_timeout"] = engine_config_mysql_wait_timeout
            if engine_id is None and not opts.urn:
                raise TypeError("Missing required property 'engine_id'")
            __props__.__dict__["engine_id"] = engine_id
            __props__.__dict__["fork_restore_time"] = fork_restore_time
            __props__.__dict__["fork_source"] = fork_source
            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["suspended"] = suspended
            __props__.__dict__["timeouts"] = timeouts
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["updates"] = updates
            __props__.__dict__["ca_cert"] = None
            __props__.__dict__["created"] = None
            __props__.__dict__["encrypted"] = None
            __props__.__dict__["engine"] = None
            __props__.__dict__["host_primary"] = None
            __props__.__dict__["host_secondary"] = None
            __props__.__dict__["members"] = None
            __props__.__dict__["oldest_restore_time"] = None
            __props__.__dict__["pending_updates"] = None
            __props__.__dict__["platform"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["root_password"] = None
            __props__.__dict__["root_username"] = None
            __props__.__dict__["ssl_connection"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated"] = None
            __props__.__dict__["version"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["caCert", "rootPassword", "rootUsername"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DatabaseMysqlV2, __self__).__init__(
            'linode:index/databaseMysqlV2:DatabaseMysqlV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_size: Optional[pulumi.Input[_builtins.int]] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
            engine: Optional[pulumi.Input[_builtins.str]] = None,
            engine_config_binlog_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_mysql_connect_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_mysql_default_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
            engine_config_mysql_group_concat_max_len: Optional[pulumi.Input[_builtins.float]] = None,
            engine_config_mysql_information_schema_stats_expiry: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_mysql_innodb_change_buffer_max_size: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_mysql_innodb_flush_neighbors: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_mysql_innodb_ft_min_token_size: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_mysql_innodb_ft_server_stopword_table: Optional[pulumi.Input[_builtins.str]] = None,
            engine_config_mysql_innodb_lock_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_mysql_innodb_log_buffer_size: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_mysql_innodb_online_alter_log_max_size: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_mysql_innodb_read_io_threads: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_mysql_innodb_rollback_on_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
            engine_config_mysql_innodb_thread_concurrency: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_mysql_innodb_write_io_threads: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_mysql_interactive_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_mysql_internal_tmp_mem_storage_engine: Optional[pulumi.Input[_builtins.str]] = None,
            engine_config_mysql_max_allowed_packet: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_mysql_max_heap_table_size: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_mysql_net_buffer_length: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_mysql_net_read_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_mysql_net_write_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_mysql_sort_buffer_size: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_mysql_sql_mode: Optional[pulumi.Input[_builtins.str]] = None,
            engine_config_mysql_sql_require_primary_key: Optional[pulumi.Input[_builtins.bool]] = None,
            engine_config_mysql_tmp_table_size: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_mysql_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            engine_id: Optional[pulumi.Input[_builtins.str]] = None,
            fork_restore_time: Optional[pulumi.Input[_builtins.str]] = None,
            fork_source: Optional[pulumi.Input[_builtins.int]] = None,
            host_primary: Optional[pulumi.Input[_builtins.str]] = None,
            host_secondary: Optional[pulumi.Input[_builtins.str]] = None,
            label: Optional[pulumi.Input[_builtins.str]] = None,
            members: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            oldest_restore_time: Optional[pulumi.Input[_builtins.str]] = None,
            pending_updates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseMysqlV2PendingUpdateArgs', 'DatabaseMysqlV2PendingUpdateArgsDict']]]]] = None,
            platform: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            root_password: Optional[pulumi.Input[_builtins.str]] = None,
            root_username: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_connection: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            suspended: Optional[pulumi.Input[_builtins.bool]] = None,
            timeouts: Optional[pulumi.Input[Union['DatabaseMysqlV2TimeoutsArgs', 'DatabaseMysqlV2TimeoutsArgsDict']]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            updated: Optional[pulumi.Input[_builtins.str]] = None,
            updates: Optional[pulumi.Input[Union['DatabaseMysqlV2UpdatesArgs', 'DatabaseMysqlV2UpdatesArgsDict']]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'DatabaseMysqlV2':
        """
        Get an existing DatabaseMysqlV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allow_lists: A list of IP addresses that can access the Managed Database. Each item can be a single IP address or a range in CIDR format. Use `DatabaseAccessControls` to manage your allow list separately.
        :param pulumi.Input[_builtins.str] ca_cert: The base64-encoded SSL CA certificate for the Managed Database.
        :param pulumi.Input[_builtins.int] cluster_size: The number of Linode Instance nodes deployed to the Managed Database. (default `1`)
        :param pulumi.Input[_builtins.str] created: When this Managed Database was created.
        :param pulumi.Input[_builtins.bool] encrypted: Whether the Managed Databases is encrypted.
        :param pulumi.Input[_builtins.str] engine: The Managed Database engine. (e.g. `mysql`)
        :param pulumi.Input[_builtins.int] engine_config_binlog_retention_period: The minimum amount of time in seconds to keep binlog entries before deletion. This may be extended for services that require binlog entries for longer than the default, for example if using the MySQL Debezium Kafka connector.
        :param pulumi.Input[_builtins.int] engine_config_mysql_connect_timeout: The number of seconds that the mysqld server waits for a connect packet before responding with "Bad handshake".
        :param pulumi.Input[_builtins.str] engine_config_mysql_default_time_zone: Default server time zone as an offset from UTC (from -12:00 to +12:00), a time zone name, or `SYSTEM` to use the MySQL server default.
        :param pulumi.Input[_builtins.float] engine_config_mysql_group_concat_max_len: The maximum permitted result length in bytes for the `GROUP_CONCAT()` function.
        :param pulumi.Input[_builtins.int] engine_config_mysql_information_schema_stats_expiry: The time, in seconds, before cached statistics expire.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_change_buffer_max_size: Maximum size for the InnoDB change buffer, as a percentage of the total size of the buffer pool. Default is 25.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_flush_neighbors: Specifies whether flushing a page from the InnoDB buffer pool also flushes other dirty pages in the same extent (default is 1): 0 - dirty pages in the same extent are not flushed, 1 - flush contiguous dirty pages in the same extent, 2 - flush dirty pages in the same extent.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_ft_min_token_size: Minimum length of words that are stored in an InnoDB FULLTEXT index. Changing this parameter will lead to a restart of the MySQL service.
        :param pulumi.Input[_builtins.str] engine_config_mysql_innodb_ft_server_stopword_table: This option is used to specify your own InnoDB FULLTEXT index stopword list for all InnoDB tables. This field is nullable.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_lock_wait_timeout: The length of time in seconds an InnoDB transaction waits for a row lock before giving up. Default is 120.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_log_buffer_size: The size in bytes of the buffer that InnoDB uses to write to the log files on disk.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_online_alter_log_max_size: The upper limit in bytes on the size of the temporary log files used during online DDL operations for InnoDB tables.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_read_io_threads: The number of I/O threads for read operations in InnoDB. Default is 4. Changing this parameter will lead to a restart of the MySQL service.
        :param pulumi.Input[_builtins.bool] engine_config_mysql_innodb_rollback_on_timeout: When enabled, a transaction timeout causes InnoDB to abort and roll back the entire transaction. Changing this parameter will lead to a restart of the MySQL service.
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_thread_concurrency: Defines the maximum number of threads permitted inside of InnoDB. Default is 0 (infinite concurrency - no limit).
        :param pulumi.Input[_builtins.int] engine_config_mysql_innodb_write_io_threads: The number of I/O threads for write operations in InnoDB. Default is 4. Changing this parameter will lead to a restart of the MySQL service.
        :param pulumi.Input[_builtins.int] engine_config_mysql_interactive_timeout: The number of seconds the server waits for activity on an interactive connection before closing it.
        :param pulumi.Input[_builtins.str] engine_config_mysql_internal_tmp_mem_storage_engine: The storage engine for in-memory internal temporary tables.
        :param pulumi.Input[_builtins.int] engine_config_mysql_max_allowed_packet: Size of the largest message in bytes that can be received by the server. Default is 67108864 (64M).
        :param pulumi.Input[_builtins.int] engine_config_mysql_max_heap_table_size: Limits the size of internal in-memory tables. Also set tmp_table_size. Default is 16777216 (16M).
        :param pulumi.Input[_builtins.int] engine_config_mysql_net_buffer_length: Start sizes of connection buffer and result buffer. Default is 16384 (16K). Changing this parameter will lead to a restart of the MySQL service.
        :param pulumi.Input[_builtins.int] engine_config_mysql_net_read_timeout: The number of seconds to wait for more data from a connection before aborting the read.
        :param pulumi.Input[_builtins.int] engine_config_mysql_net_write_timeout: The number of seconds to wait for a block to be written to a connection before aborting the write.
        :param pulumi.Input[_builtins.int] engine_config_mysql_sort_buffer_size: Sort buffer size in bytes for ORDER BY optimization. Default is 262144 (256K).
        :param pulumi.Input[_builtins.str] engine_config_mysql_sql_mode: Global SQL mode. Set to empty to use MySQL server defaults. When creating a new service and not setting this field Aiven default SQL mode (strict, SQL standard compliant) will be assigned. (default `ANSI,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION,NO_ZERO_DATE,NO_ZERO_IN_DATE,STRICT_ALL_TABLES`)
        :param pulumi.Input[_builtins.bool] engine_config_mysql_sql_require_primary_key: Require primary key to be defined for new tables or old tables modified with ALTER TABLE and fail if missing. It is recommended to always have primary keys because various functionality may break if any large table is missing them. (default `true`)
        :param pulumi.Input[_builtins.int] engine_config_mysql_tmp_table_size: Limits the size of internal in-memory tables. Also set max_heap_table_size. Default is 16777216 (16M).
        :param pulumi.Input[_builtins.int] engine_config_mysql_wait_timeout: The number of seconds the server waits for activity on a noninteractive connection before closing it.
        :param pulumi.Input[_builtins.str] engine_id: The Managed Database engine in engine/version format. (e.g. `mysql`)
        :param pulumi.Input[_builtins.str] fork_restore_time: The database timestamp from which it was restored.
        :param pulumi.Input[_builtins.int] fork_source: The ID of the database that was forked from.
               
               * `updates` - (Optional) Configuration settings for automated patch update maintenance for the Managed Database.
        :param pulumi.Input[_builtins.str] host_primary: The primary host for the Managed Database.
        :param pulumi.Input[_builtins.str] host_secondary: The secondary/private host for the managed database.
        :param pulumi.Input[_builtins.str] label: A unique, user-defined string referring to the Managed Database.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] members: A mapping between IP addresses and strings designating them as primary or failover.
        :param pulumi.Input[_builtins.str] oldest_restore_time: The oldest time to which a database can be restored.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabaseMysqlV2PendingUpdateArgs', 'DatabaseMysqlV2PendingUpdateArgsDict']]]] pending_updates: A set of pending updates.
        :param pulumi.Input[_builtins.str] platform: The back-end platform for relational databases used by the service.
        :param pulumi.Input[_builtins.int] port: The access port for this Managed Database.
        :param pulumi.Input[_builtins.str] region: The region to use for the Managed Database.
        :param pulumi.Input[_builtins.str] root_password: The randomly-generated root password for the Managed Database instance.
        :param pulumi.Input[_builtins.str] root_username: The root username for the Managed Database instance.
        :param pulumi.Input[_builtins.bool] ssl_connection: Whether to require SSL credentials to establish a connection to the Managed Database.
        :param pulumi.Input[_builtins.str] status: The operating status of the Managed Database.
        :param pulumi.Input[_builtins.bool] suspended: Whether this Managed Database should be suspended.
        :param pulumi.Input[_builtins.str] type: The Linode Instance type used for the nodes of the Managed Database.
               
               - - -
        :param pulumi.Input[_builtins.str] updated: When this Managed Database was last updated.
        :param pulumi.Input[Union['DatabaseMysqlV2UpdatesArgs', 'DatabaseMysqlV2UpdatesArgsDict']] updates: Configuration settings for automated patch update maintenance for the Managed Database.
        :param pulumi.Input[_builtins.str] version: The Managed Database engine version. (e.g. `13.2`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseMysqlV2State.__new__(_DatabaseMysqlV2State)

        __props__.__dict__["allow_lists"] = allow_lists
        __props__.__dict__["ca_cert"] = ca_cert
        __props__.__dict__["cluster_size"] = cluster_size
        __props__.__dict__["created"] = created
        __props__.__dict__["encrypted"] = encrypted
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_config_binlog_retention_period"] = engine_config_binlog_retention_period
        __props__.__dict__["engine_config_mysql_connect_timeout"] = engine_config_mysql_connect_timeout
        __props__.__dict__["engine_config_mysql_default_time_zone"] = engine_config_mysql_default_time_zone
        __props__.__dict__["engine_config_mysql_group_concat_max_len"] = engine_config_mysql_group_concat_max_len
        __props__.__dict__["engine_config_mysql_information_schema_stats_expiry"] = engine_config_mysql_information_schema_stats_expiry
        __props__.__dict__["engine_config_mysql_innodb_change_buffer_max_size"] = engine_config_mysql_innodb_change_buffer_max_size
        __props__.__dict__["engine_config_mysql_innodb_flush_neighbors"] = engine_config_mysql_innodb_flush_neighbors
        __props__.__dict__["engine_config_mysql_innodb_ft_min_token_size"] = engine_config_mysql_innodb_ft_min_token_size
        __props__.__dict__["engine_config_mysql_innodb_ft_server_stopword_table"] = engine_config_mysql_innodb_ft_server_stopword_table
        __props__.__dict__["engine_config_mysql_innodb_lock_wait_timeout"] = engine_config_mysql_innodb_lock_wait_timeout
        __props__.__dict__["engine_config_mysql_innodb_log_buffer_size"] = engine_config_mysql_innodb_log_buffer_size
        __props__.__dict__["engine_config_mysql_innodb_online_alter_log_max_size"] = engine_config_mysql_innodb_online_alter_log_max_size
        __props__.__dict__["engine_config_mysql_innodb_read_io_threads"] = engine_config_mysql_innodb_read_io_threads
        __props__.__dict__["engine_config_mysql_innodb_rollback_on_timeout"] = engine_config_mysql_innodb_rollback_on_timeout
        __props__.__dict__["engine_config_mysql_innodb_thread_concurrency"] = engine_config_mysql_innodb_thread_concurrency
        __props__.__dict__["engine_config_mysql_innodb_write_io_threads"] = engine_config_mysql_innodb_write_io_threads
        __props__.__dict__["engine_config_mysql_interactive_timeout"] = engine_config_mysql_interactive_timeout
        __props__.__dict__["engine_config_mysql_internal_tmp_mem_storage_engine"] = engine_config_mysql_internal_tmp_mem_storage_engine
        __props__.__dict__["engine_config_mysql_max_allowed_packet"] = engine_config_mysql_max_allowed_packet
        __props__.__dict__["engine_config_mysql_max_heap_table_size"] = engine_config_mysql_max_heap_table_size
        __props__.__dict__["engine_config_mysql_net_buffer_length"] = engine_config_mysql_net_buffer_length
        __props__.__dict__["engine_config_mysql_net_read_timeout"] = engine_config_mysql_net_read_timeout
        __props__.__dict__["engine_config_mysql_net_write_timeout"] = engine_config_mysql_net_write_timeout
        __props__.__dict__["engine_config_mysql_sort_buffer_size"] = engine_config_mysql_sort_buffer_size
        __props__.__dict__["engine_config_mysql_sql_mode"] = engine_config_mysql_sql_mode
        __props__.__dict__["engine_config_mysql_sql_require_primary_key"] = engine_config_mysql_sql_require_primary_key
        __props__.__dict__["engine_config_mysql_tmp_table_size"] = engine_config_mysql_tmp_table_size
        __props__.__dict__["engine_config_mysql_wait_timeout"] = engine_config_mysql_wait_timeout
        __props__.__dict__["engine_id"] = engine_id
        __props__.__dict__["fork_restore_time"] = fork_restore_time
        __props__.__dict__["fork_source"] = fork_source
        __props__.__dict__["host_primary"] = host_primary
        __props__.__dict__["host_secondary"] = host_secondary
        __props__.__dict__["label"] = label
        __props__.__dict__["members"] = members
        __props__.__dict__["oldest_restore_time"] = oldest_restore_time
        __props__.__dict__["pending_updates"] = pending_updates
        __props__.__dict__["platform"] = platform
        __props__.__dict__["port"] = port
        __props__.__dict__["region"] = region
        __props__.__dict__["root_password"] = root_password
        __props__.__dict__["root_username"] = root_username
        __props__.__dict__["ssl_connection"] = ssl_connection
        __props__.__dict__["status"] = status
        __props__.__dict__["suspended"] = suspended
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["type"] = type
        __props__.__dict__["updated"] = updated
        __props__.__dict__["updates"] = updates
        __props__.__dict__["version"] = version
        return DatabaseMysqlV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowLists")
    def allow_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of IP addresses that can access the Managed Database. Each item can be a single IP address or a range in CIDR format. Use `DatabaseAccessControls` to manage your allow list separately.
        """
        return pulumi.get(self, "allow_lists")

    @_builtins.property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> pulumi.Output[_builtins.str]:
        """
        The base64-encoded SSL CA certificate for the Managed Database.
        """
        return pulumi.get(self, "ca_cert")

    @_builtins.property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> pulumi.Output[_builtins.int]:
        """
        The number of Linode Instance nodes deployed to the Managed Database. (default `1`)
        """
        return pulumi.get(self, "cluster_size")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        """
        When this Managed Database was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the Managed Databases is encrypted.
        """
        return pulumi.get(self, "encrypted")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> pulumi.Output[_builtins.str]:
        """
        The Managed Database engine. (e.g. `mysql`)
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineConfigBinlogRetentionPeriod")
    def engine_config_binlog_retention_period(self) -> pulumi.Output[_builtins.int]:
        """
        The minimum amount of time in seconds to keep binlog entries before deletion. This may be extended for services that require binlog entries for longer than the default, for example if using the MySQL Debezium Kafka connector.
        """
        return pulumi.get(self, "engine_config_binlog_retention_period")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlConnectTimeout")
    def engine_config_mysql_connect_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        The number of seconds that the mysqld server waits for a connect packet before responding with "Bad handshake".
        """
        return pulumi.get(self, "engine_config_mysql_connect_timeout")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlDefaultTimeZone")
    def engine_config_mysql_default_time_zone(self) -> pulumi.Output[_builtins.str]:
        """
        Default server time zone as an offset from UTC (from -12:00 to +12:00), a time zone name, or `SYSTEM` to use the MySQL server default.
        """
        return pulumi.get(self, "engine_config_mysql_default_time_zone")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlGroupConcatMaxLen")
    def engine_config_mysql_group_concat_max_len(self) -> pulumi.Output[_builtins.float]:
        """
        The maximum permitted result length in bytes for the `GROUP_CONCAT()` function.
        """
        return pulumi.get(self, "engine_config_mysql_group_concat_max_len")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInformationSchemaStatsExpiry")
    def engine_config_mysql_information_schema_stats_expiry(self) -> pulumi.Output[_builtins.int]:
        """
        The time, in seconds, before cached statistics expire.
        """
        return pulumi.get(self, "engine_config_mysql_information_schema_stats_expiry")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbChangeBufferMaxSize")
    def engine_config_mysql_innodb_change_buffer_max_size(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum size for the InnoDB change buffer, as a percentage of the total size of the buffer pool. Default is 25.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_change_buffer_max_size")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbFlushNeighbors")
    def engine_config_mysql_innodb_flush_neighbors(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies whether flushing a page from the InnoDB buffer pool also flushes other dirty pages in the same extent (default is 1): 0 - dirty pages in the same extent are not flushed, 1 - flush contiguous dirty pages in the same extent, 2 - flush dirty pages in the same extent.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_flush_neighbors")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbFtMinTokenSize")
    def engine_config_mysql_innodb_ft_min_token_size(self) -> pulumi.Output[_builtins.int]:
        """
        Minimum length of words that are stored in an InnoDB FULLTEXT index. Changing this parameter will lead to a restart of the MySQL service.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_ft_min_token_size")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbFtServerStopwordTable")
    def engine_config_mysql_innodb_ft_server_stopword_table(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        This option is used to specify your own InnoDB FULLTEXT index stopword list for all InnoDB tables. This field is nullable.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_ft_server_stopword_table")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbLockWaitTimeout")
    def engine_config_mysql_innodb_lock_wait_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        The length of time in seconds an InnoDB transaction waits for a row lock before giving up. Default is 120.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_lock_wait_timeout")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbLogBufferSize")
    def engine_config_mysql_innodb_log_buffer_size(self) -> pulumi.Output[_builtins.int]:
        """
        The size in bytes of the buffer that InnoDB uses to write to the log files on disk.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_log_buffer_size")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbOnlineAlterLogMaxSize")
    def engine_config_mysql_innodb_online_alter_log_max_size(self) -> pulumi.Output[_builtins.int]:
        """
        The upper limit in bytes on the size of the temporary log files used during online DDL operations for InnoDB tables.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_online_alter_log_max_size")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbReadIoThreads")
    def engine_config_mysql_innodb_read_io_threads(self) -> pulumi.Output[_builtins.int]:
        """
        The number of I/O threads for read operations in InnoDB. Default is 4. Changing this parameter will lead to a restart of the MySQL service.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_read_io_threads")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbRollbackOnTimeout")
    def engine_config_mysql_innodb_rollback_on_timeout(self) -> pulumi.Output[_builtins.bool]:
        """
        When enabled, a transaction timeout causes InnoDB to abort and roll back the entire transaction. Changing this parameter will lead to a restart of the MySQL service.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_rollback_on_timeout")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbThreadConcurrency")
    def engine_config_mysql_innodb_thread_concurrency(self) -> pulumi.Output[_builtins.int]:
        """
        Defines the maximum number of threads permitted inside of InnoDB. Default is 0 (infinite concurrency - no limit).
        """
        return pulumi.get(self, "engine_config_mysql_innodb_thread_concurrency")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbWriteIoThreads")
    def engine_config_mysql_innodb_write_io_threads(self) -> pulumi.Output[_builtins.int]:
        """
        The number of I/O threads for write operations in InnoDB. Default is 4. Changing this parameter will lead to a restart of the MySQL service.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_write_io_threads")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInteractiveTimeout")
    def engine_config_mysql_interactive_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        The number of seconds the server waits for activity on an interactive connection before closing it.
        """
        return pulumi.get(self, "engine_config_mysql_interactive_timeout")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInternalTmpMemStorageEngine")
    def engine_config_mysql_internal_tmp_mem_storage_engine(self) -> pulumi.Output[_builtins.str]:
        """
        The storage engine for in-memory internal temporary tables.
        """
        return pulumi.get(self, "engine_config_mysql_internal_tmp_mem_storage_engine")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlMaxAllowedPacket")
    def engine_config_mysql_max_allowed_packet(self) -> pulumi.Output[_builtins.int]:
        """
        Size of the largest message in bytes that can be received by the server. Default is 67108864 (64M).
        """
        return pulumi.get(self, "engine_config_mysql_max_allowed_packet")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlMaxHeapTableSize")
    def engine_config_mysql_max_heap_table_size(self) -> pulumi.Output[_builtins.int]:
        """
        Limits the size of internal in-memory tables. Also set tmp_table_size. Default is 16777216 (16M).
        """
        return pulumi.get(self, "engine_config_mysql_max_heap_table_size")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlNetBufferLength")
    def engine_config_mysql_net_buffer_length(self) -> pulumi.Output[_builtins.int]:
        """
        Start sizes of connection buffer and result buffer. Default is 16384 (16K). Changing this parameter will lead to a restart of the MySQL service.
        """
        return pulumi.get(self, "engine_config_mysql_net_buffer_length")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlNetReadTimeout")
    def engine_config_mysql_net_read_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        The number of seconds to wait for more data from a connection before aborting the read.
        """
        return pulumi.get(self, "engine_config_mysql_net_read_timeout")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlNetWriteTimeout")
    def engine_config_mysql_net_write_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        The number of seconds to wait for a block to be written to a connection before aborting the write.
        """
        return pulumi.get(self, "engine_config_mysql_net_write_timeout")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlSortBufferSize")
    def engine_config_mysql_sort_buffer_size(self) -> pulumi.Output[_builtins.int]:
        """
        Sort buffer size in bytes for ORDER BY optimization. Default is 262144 (256K).
        """
        return pulumi.get(self, "engine_config_mysql_sort_buffer_size")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlSqlMode")
    def engine_config_mysql_sql_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Global SQL mode. Set to empty to use MySQL server defaults. When creating a new service and not setting this field Aiven default SQL mode (strict, SQL standard compliant) will be assigned. (default `ANSI,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION,NO_ZERO_DATE,NO_ZERO_IN_DATE,STRICT_ALL_TABLES`)
        """
        return pulumi.get(self, "engine_config_mysql_sql_mode")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlSqlRequirePrimaryKey")
    def engine_config_mysql_sql_require_primary_key(self) -> pulumi.Output[_builtins.bool]:
        """
        Require primary key to be defined for new tables or old tables modified with ALTER TABLE and fail if missing. It is recommended to always have primary keys because various functionality may break if any large table is missing them. (default `true`)
        """
        return pulumi.get(self, "engine_config_mysql_sql_require_primary_key")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlTmpTableSize")
    def engine_config_mysql_tmp_table_size(self) -> pulumi.Output[_builtins.int]:
        """
        Limits the size of internal in-memory tables. Also set max_heap_table_size. Default is 16777216 (16M).
        """
        return pulumi.get(self, "engine_config_mysql_tmp_table_size")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlWaitTimeout")
    def engine_config_mysql_wait_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        The number of seconds the server waits for activity on a noninteractive connection before closing it.
        """
        return pulumi.get(self, "engine_config_mysql_wait_timeout")

    @_builtins.property
    @pulumi.getter(name="engineId")
    def engine_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Managed Database engine in engine/version format. (e.g. `mysql`)
        """
        return pulumi.get(self, "engine_id")

    @_builtins.property
    @pulumi.getter(name="forkRestoreTime")
    def fork_restore_time(self) -> pulumi.Output[_builtins.str]:
        """
        The database timestamp from which it was restored.
        """
        return pulumi.get(self, "fork_restore_time")

    @_builtins.property
    @pulumi.getter(name="forkSource")
    def fork_source(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The ID of the database that was forked from.

        * `updates` - (Optional) Configuration settings for automated patch update maintenance for the Managed Database.
        """
        return pulumi.get(self, "fork_source")

    @_builtins.property
    @pulumi.getter(name="hostPrimary")
    def host_primary(self) -> pulumi.Output[_builtins.str]:
        """
        The primary host for the Managed Database.
        """
        return pulumi.get(self, "host_primary")

    @_builtins.property
    @pulumi.getter(name="hostSecondary")
    def host_secondary(self) -> pulumi.Output[_builtins.str]:
        """
        The secondary/private host for the managed database.
        """
        return pulumi.get(self, "host_secondary")

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Output[_builtins.str]:
        """
        A unique, user-defined string referring to the Managed Database.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def members(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A mapping between IP addresses and strings designating them as primary or failover.
        """
        return pulumi.get(self, "members")

    @_builtins.property
    @pulumi.getter(name="oldestRestoreTime")
    def oldest_restore_time(self) -> pulumi.Output[_builtins.str]:
        """
        The oldest time to which a database can be restored.
        """
        return pulumi.get(self, "oldest_restore_time")

    @_builtins.property
    @pulumi.getter(name="pendingUpdates")
    def pending_updates(self) -> pulumi.Output[Sequence['outputs.DatabaseMysqlV2PendingUpdate']]:
        """
        A set of pending updates.
        """
        return pulumi.get(self, "pending_updates")

    @_builtins.property
    @pulumi.getter
    def platform(self) -> pulumi.Output[_builtins.str]:
        """
        The back-end platform for relational databases used by the service.
        """
        return pulumi.get(self, "platform")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.int]:
        """
        The access port for this Managed Database.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region to use for the Managed Database.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> pulumi.Output[_builtins.str]:
        """
        The randomly-generated root password for the Managed Database instance.
        """
        return pulumi.get(self, "root_password")

    @_builtins.property
    @pulumi.getter(name="rootUsername")
    def root_username(self) -> pulumi.Output[_builtins.str]:
        """
        The root username for the Managed Database instance.
        """
        return pulumi.get(self, "root_username")

    @_builtins.property
    @pulumi.getter(name="sslConnection")
    def ssl_connection(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to require SSL credentials to establish a connection to the Managed Database.
        """
        return pulumi.get(self, "ssl_connection")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The operating status of the Managed Database.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def suspended(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether this Managed Database should be suspended.
        """
        return pulumi.get(self, "suspended")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.DatabaseMysqlV2Timeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The Linode Instance type used for the nodes of the Managed Database.

        - - -
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def updated(self) -> pulumi.Output[_builtins.str]:
        """
        When this Managed Database was last updated.
        """
        return pulumi.get(self, "updated")

    @_builtins.property
    @pulumi.getter
    def updates(self) -> pulumi.Output['outputs.DatabaseMysqlV2Updates']:
        """
        Configuration settings for automated patch update maintenance for the Managed Database.
        """
        return pulumi.get(self, "updates")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The Managed Database engine version. (e.g. `13.2`)
        """
        return pulumi.get(self, "version")

