# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetImageResult',
    'AwaitableGetImageResult',
    'get_image',
    'get_image_output',
]

@pulumi.output_type
class GetImageResult:
    """
    A collection of values returned by getImage.
    """
    def __init__(__self__, capabilities=None, created=None, created_by=None, deprecated=None, description=None, expiry=None, id=None, is_public=None, label=None, replications=None, size=None, status=None, tags=None, total_size=None, type=None, vendor=None):
        if capabilities and not isinstance(capabilities, list):
            raise TypeError("Expected argument 'capabilities' to be a list")
        pulumi.set(__self__, "capabilities", capabilities)
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if deprecated and not isinstance(deprecated, bool):
            raise TypeError("Expected argument 'deprecated' to be a bool")
        pulumi.set(__self__, "deprecated", deprecated)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if expiry and not isinstance(expiry, str):
            raise TypeError("Expected argument 'expiry' to be a str")
        pulumi.set(__self__, "expiry", expiry)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_public and not isinstance(is_public, bool):
            raise TypeError("Expected argument 'is_public' to be a bool")
        pulumi.set(__self__, "is_public", is_public)
        if label and not isinstance(label, str):
            raise TypeError("Expected argument 'label' to be a str")
        pulumi.set(__self__, "label", label)
        if replications and not isinstance(replications, list):
            raise TypeError("Expected argument 'replications' to be a list")
        pulumi.set(__self__, "replications", replications)
        if size and not isinstance(size, int):
            raise TypeError("Expected argument 'size' to be a int")
        pulumi.set(__self__, "size", size)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if total_size and not isinstance(total_size, int):
            raise TypeError("Expected argument 'total_size' to be a int")
        pulumi.set(__self__, "total_size", total_size)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vendor and not isinstance(vendor, str):
            raise TypeError("Expected argument 'vendor' to be a str")
        pulumi.set(__self__, "vendor", vendor)

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "capabilities")

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.str:
        """
        When this Image was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        The name of the User who created this Image, or "linode" for official Images.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def deprecated(self) -> _builtins.bool:
        """
        Whether or not this Image is deprecated. Will only be true for deprecated public Images.
        """
        return pulumi.get(self, "deprecated")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A detailed description of this Image.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def expiry(self) -> _builtins.str:
        return pulumi.get(self, "expiry")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> _builtins.bool:
        """
        True if the Image is public.
        """
        return pulumi.get(self, "is_public")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        A short description of the Image.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def replications(self) -> Optional[Sequence['outputs.GetImageReplicationResult']]:
        """
        A list of image replication regions and corresponding status.
        """
        return pulumi.get(self, "replications")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        The minimum size this Image needs to deploy. Size is in MB. example: 2500
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of an image replica.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        A list of customized tags.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="totalSize")
    def total_size(self) -> _builtins.int:
        """
        The total size of the image in all available regions.
        """
        return pulumi.get(self, "total_size")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        How the Image was created. Manual Images can be created at any time. "Automatic" Images are created automatically from a deleted Linode. (`manual`, `automatic`)
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def vendor(self) -> _builtins.str:
        """
        The upstream distribution vendor. `None` for private Images.
        """
        return pulumi.get(self, "vendor")


class AwaitableGetImageResult(GetImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImageResult(
            capabilities=self.capabilities,
            created=self.created,
            created_by=self.created_by,
            deprecated=self.deprecated,
            description=self.description,
            expiry=self.expiry,
            id=self.id,
            is_public=self.is_public,
            label=self.label,
            replications=self.replications,
            size=self.size,
            status=self.status,
            tags=self.tags,
            total_size=self.total_size,
            type=self.type,
            vendor=self.vendor)


def get_image(id: Optional[_builtins.str] = None,
              replications: Optional[Sequence[Union['GetImageReplicationArgs', 'GetImageReplicationArgsDict']]] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImageResult:
    """
    Provides information about a Linode image
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-image).

    ## Example Usage

    The following example shows how one might use this data source to access information about a Linode image.

    ```python
    import pulumi
    import pulumi_linode as linode

    k8_master = linode.get_image(id="linode/debian12")
    ```


    :param _builtins.str id: The unique ID of this Image.  The ID of private images begin with `private/` followed by the numeric identifier of the private image, for example `private/12345`.
    :param Sequence[Union['GetImageReplicationArgs', 'GetImageReplicationArgsDict']] replications: A list of image replication regions and corresponding status.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['replications'] = replications
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getImage:getImage', __args__, opts=opts, typ=GetImageResult).value

    return AwaitableGetImageResult(
        capabilities=pulumi.get(__ret__, 'capabilities'),
        created=pulumi.get(__ret__, 'created'),
        created_by=pulumi.get(__ret__, 'created_by'),
        deprecated=pulumi.get(__ret__, 'deprecated'),
        description=pulumi.get(__ret__, 'description'),
        expiry=pulumi.get(__ret__, 'expiry'),
        id=pulumi.get(__ret__, 'id'),
        is_public=pulumi.get(__ret__, 'is_public'),
        label=pulumi.get(__ret__, 'label'),
        replications=pulumi.get(__ret__, 'replications'),
        size=pulumi.get(__ret__, 'size'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        total_size=pulumi.get(__ret__, 'total_size'),
        type=pulumi.get(__ret__, 'type'),
        vendor=pulumi.get(__ret__, 'vendor'))
def get_image_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                     replications: Optional[pulumi.Input[Optional[Sequence[Union['GetImageReplicationArgs', 'GetImageReplicationArgsDict']]]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetImageResult]:
    """
    Provides information about a Linode image
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-image).

    ## Example Usage

    The following example shows how one might use this data source to access information about a Linode image.

    ```python
    import pulumi
    import pulumi_linode as linode

    k8_master = linode.get_image(id="linode/debian12")
    ```


    :param _builtins.str id: The unique ID of this Image.  The ID of private images begin with `private/` followed by the numeric identifier of the private image, for example `private/12345`.
    :param Sequence[Union['GetImageReplicationArgs', 'GetImageReplicationArgsDict']] replications: A list of image replication regions and corresponding status.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['replications'] = replications
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getImage:getImage', __args__, opts=opts, typ=GetImageResult)
    return __ret__.apply(lambda __response__: GetImageResult(
        capabilities=pulumi.get(__response__, 'capabilities'),
        created=pulumi.get(__response__, 'created'),
        created_by=pulumi.get(__response__, 'created_by'),
        deprecated=pulumi.get(__response__, 'deprecated'),
        description=pulumi.get(__response__, 'description'),
        expiry=pulumi.get(__response__, 'expiry'),
        id=pulumi.get(__response__, 'id'),
        is_public=pulumi.get(__response__, 'is_public'),
        label=pulumi.get(__response__, 'label'),
        replications=pulumi.get(__response__, 'replications'),
        size=pulumi.get(__response__, 'size'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        total_size=pulumi.get(__response__, 'total_size'),
        type=pulumi.get(__response__, 'type'),
        vendor=pulumi.get(__response__, 'vendor')))
