# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetInstanceNetworkingResult',
    'AwaitableGetInstanceNetworkingResult',
    'get_instance_networking',
    'get_instance_networking_output',
]

@pulumi.output_type
class GetInstanceNetworkingResult:
    """
    A collection of values returned by getInstanceNetworking.
    """
    def __init__(__self__, id=None, ipv4s=None, ipv6s=None, linode_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipv4s and not isinstance(ipv4s, list):
            raise TypeError("Expected argument 'ipv4s' to be a list")
        pulumi.set(__self__, "ipv4s", ipv4s)
        if ipv6s and not isinstance(ipv6s, list):
            raise TypeError("Expected argument 'ipv6s' to be a list")
        pulumi.set(__self__, "ipv6s", ipv6s)
        if linode_id and not isinstance(linode_id, int):
            raise TypeError("Expected argument 'linode_id' to be a int")
        pulumi.set(__self__, "linode_id", linode_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ipv4s(self) -> Sequence['outputs.GetInstanceNetworkingIpv4Result']:
        return pulumi.get(self, "ipv4s")

    @_builtins.property
    @pulumi.getter
    def ipv6s(self) -> Sequence['outputs.GetInstanceNetworkingIpv6Result']:
        return pulumi.get(self, "ipv6s")

    @_builtins.property
    @pulumi.getter(name="linodeId")
    def linode_id(self) -> _builtins.int:
        """
        The ID of the Linode this address currently belongs to.
        """
        return pulumi.get(self, "linode_id")


class AwaitableGetInstanceNetworkingResult(GetInstanceNetworkingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceNetworkingResult(
            id=self.id,
            ipv4s=self.ipv4s,
            ipv6s=self.ipv6s,
            linode_id=self.linode_id)


def get_instance_networking(linode_id: Optional[_builtins.int] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceNetworkingResult:
    """
    Provides details about the networking configuration of an Instance.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-linode-config-interfaces).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_linode as linode

    example = linode.get_instance_networking(linode_id=123)
    ```


    :param _builtins.int linode_id: The Linode instance's ID.
    """
    __args__ = dict()
    __args__['linodeId'] = linode_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getInstanceNetworking:getInstanceNetworking', __args__, opts=opts, typ=GetInstanceNetworkingResult).value

    return AwaitableGetInstanceNetworkingResult(
        id=pulumi.get(__ret__, 'id'),
        ipv4s=pulumi.get(__ret__, 'ipv4s'),
        ipv6s=pulumi.get(__ret__, 'ipv6s'),
        linode_id=pulumi.get(__ret__, 'linode_id'))
def get_instance_networking_output(linode_id: Optional[pulumi.Input[_builtins.int]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstanceNetworkingResult]:
    """
    Provides details about the networking configuration of an Instance.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-linode-config-interfaces).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_linode as linode

    example = linode.get_instance_networking(linode_id=123)
    ```


    :param _builtins.int linode_id: The Linode instance's ID.
    """
    __args__ = dict()
    __args__['linodeId'] = linode_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getInstanceNetworking:getInstanceNetworking', __args__, opts=opts, typ=GetInstanceNetworkingResult)
    return __ret__.apply(lambda __response__: GetInstanceNetworkingResult(
        id=pulumi.get(__response__, 'id'),
        ipv4s=pulumi.get(__response__, 'ipv4s'),
        ipv6s=pulumi.get(__response__, 'ipv6s'),
        linode_id=pulumi.get(__response__, 'linode_id')))
