# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetNodebalancerConfigsResult',
    'AwaitableGetNodebalancerConfigsResult',
    'get_nodebalancer_configs',
    'get_nodebalancer_configs_output',
]

@pulumi.output_type
class GetNodebalancerConfigsResult:
    """
    A collection of values returned by getNodebalancerConfigs.
    """
    def __init__(__self__, filters=None, id=None, nodebalancer_configs=None, nodebalancer_id=None, order=None, order_by=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if nodebalancer_configs and not isinstance(nodebalancer_configs, list):
            raise TypeError("Expected argument 'nodebalancer_configs' to be a list")
        pulumi.set(__self__, "nodebalancer_configs", nodebalancer_configs)
        if nodebalancer_id and not isinstance(nodebalancer_id, int):
            raise TypeError("Expected argument 'nodebalancer_id' to be a int")
        pulumi.set(__self__, "nodebalancer_id", nodebalancer_id)
        if order and not isinstance(order, str):
            raise TypeError("Expected argument 'order' to be a str")
        pulumi.set(__self__, "order", order)
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        pulumi.set(__self__, "order_by", order_by)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetNodebalancerConfigsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The config's ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="nodebalancerConfigs")
    def nodebalancer_configs(self) -> Optional[Sequence['outputs.GetNodebalancerConfigsNodebalancerConfigResult']]:
        return pulumi.get(self, "nodebalancer_configs")

    @_builtins.property
    @pulumi.getter(name="nodebalancerId")
    def nodebalancer_id(self) -> _builtins.int:
        """
        The ID of the NodeBalancer that contains the config.
        """
        return pulumi.get(self, "nodebalancer_id")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "order_by")


class AwaitableGetNodebalancerConfigsResult(GetNodebalancerConfigsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNodebalancerConfigsResult(
            filters=self.filters,
            id=self.id,
            nodebalancer_configs=self.nodebalancer_configs,
            nodebalancer_id=self.nodebalancer_id,
            order=self.order,
            order_by=self.order_by)


def get_nodebalancer_configs(filters: Optional[Sequence[Union['GetNodebalancerConfigsFilterArgs', 'GetNodebalancerConfigsFilterArgsDict']]] = None,
                             nodebalancer_configs: Optional[Sequence[Union['GetNodebalancerConfigsNodebalancerConfigArgs', 'GetNodebalancerConfigsNodebalancerConfigArgsDict']]] = None,
                             nodebalancer_id: Optional[_builtins.int] = None,
                             order: Optional[_builtins.str] = None,
                             order_by: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNodebalancerConfigsResult:
    """
    Provides information about Linode NodeBalancer Configs that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-node-balancer-configs).

    ## Example Usage

    The following example shows how one might use this data source to access information about a list of NodeBalancer Configs.

    ```python
    import pulumi
    import pulumi_linode as linode

    filter_nb_configs = linode.get_nodebalancer_configs(nodebalancer_id=12345,
        filters=[{
            "name": "port",
            "values": ["80"],
        }])
    pulumi.export("nodebalancerConfigId", filter_nb_configs.nodebalancer_configs[0].id)
    ```

    ## Filterable Fields

    * `algorithm`

    * `check`

    * `nodebalancer_id`

    * `port`

    * `protocol`

    * `proxy_protocol`

    * `stickiness`

    * `check_path`

    * `check_body`

    * `check_passive`

    * `cipher_suite`

    * `ssl_commonname`


    :param _builtins.int nodebalancer_id: The ID of the NodeBalancer to access.
           
           * `filter` - (Optional) A set of filters used to select Linode NodeBalancers that meet certain requirements.
    :param _builtins.str order: The order in which results should be returned. (`asc`, `desc`; default `asc`)
    :param _builtins.str order_by: The attribute to order the results by. See the Filterable Fields section for a list of valid fields.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['nodebalancerConfigs'] = nodebalancer_configs
    __args__['nodebalancerId'] = nodebalancer_id
    __args__['order'] = order
    __args__['orderBy'] = order_by
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getNodebalancerConfigs:getNodebalancerConfigs', __args__, opts=opts, typ=GetNodebalancerConfigsResult).value

    return AwaitableGetNodebalancerConfigsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        nodebalancer_configs=pulumi.get(__ret__, 'nodebalancer_configs'),
        nodebalancer_id=pulumi.get(__ret__, 'nodebalancer_id'),
        order=pulumi.get(__ret__, 'order'),
        order_by=pulumi.get(__ret__, 'order_by'))
def get_nodebalancer_configs_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetNodebalancerConfigsFilterArgs', 'GetNodebalancerConfigsFilterArgsDict']]]]] = None,
                                    nodebalancer_configs: Optional[pulumi.Input[Optional[Sequence[Union['GetNodebalancerConfigsNodebalancerConfigArgs', 'GetNodebalancerConfigsNodebalancerConfigArgsDict']]]]] = None,
                                    nodebalancer_id: Optional[pulumi.Input[_builtins.int]] = None,
                                    order: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    order_by: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNodebalancerConfigsResult]:
    """
    Provides information about Linode NodeBalancer Configs that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-node-balancer-configs).

    ## Example Usage

    The following example shows how one might use this data source to access information about a list of NodeBalancer Configs.

    ```python
    import pulumi
    import pulumi_linode as linode

    filter_nb_configs = linode.get_nodebalancer_configs(nodebalancer_id=12345,
        filters=[{
            "name": "port",
            "values": ["80"],
        }])
    pulumi.export("nodebalancerConfigId", filter_nb_configs.nodebalancer_configs[0].id)
    ```

    ## Filterable Fields

    * `algorithm`

    * `check`

    * `nodebalancer_id`

    * `port`

    * `protocol`

    * `proxy_protocol`

    * `stickiness`

    * `check_path`

    * `check_body`

    * `check_passive`

    * `cipher_suite`

    * `ssl_commonname`


    :param _builtins.int nodebalancer_id: The ID of the NodeBalancer to access.
           
           * `filter` - (Optional) A set of filters used to select Linode NodeBalancers that meet certain requirements.
    :param _builtins.str order: The order in which results should be returned. (`asc`, `desc`; default `asc`)
    :param _builtins.str order_by: The attribute to order the results by. See the Filterable Fields section for a list of valid fields.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['nodebalancerConfigs'] = nodebalancer_configs
    __args__['nodebalancerId'] = nodebalancer_id
    __args__['order'] = order
    __args__['orderBy'] = order_by
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getNodebalancerConfigs:getNodebalancerConfigs', __args__, opts=opts, typ=GetNodebalancerConfigsResult)
    return __ret__.apply(lambda __response__: GetNodebalancerConfigsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        nodebalancer_configs=pulumi.get(__response__, 'nodebalancer_configs'),
        nodebalancer_id=pulumi.get(__response__, 'nodebalancer_id'),
        order=pulumi.get(__response__, 'order'),
        order_by=pulumi.get(__response__, 'order_by')))
