# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetObjectStorageQuotasResult',
    'AwaitableGetObjectStorageQuotasResult',
    'get_object_storage_quotas',
    'get_object_storage_quotas_output',
]

@pulumi.output_type
class GetObjectStorageQuotasResult:
    """
    A collection of values returned by getObjectStorageQuotas.
    """
    def __init__(__self__, filters=None, id=None, quotas=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if quotas and not isinstance(quotas, list):
            raise TypeError("Expected argument 'quotas' to be a list")
        pulumi.set(__self__, "quotas", quotas)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetObjectStorageQuotasFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def quotas(self) -> Optional[Sequence['outputs.GetObjectStorageQuotasQuotaResult']]:
        return pulumi.get(self, "quotas")


class AwaitableGetObjectStorageQuotasResult(GetObjectStorageQuotasResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetObjectStorageQuotasResult(
            filters=self.filters,
            id=self.id,
            quotas=self.quotas)


def get_object_storage_quotas(filters: Optional[Sequence[Union['GetObjectStorageQuotasFilterArgs', 'GetObjectStorageQuotasFilterArgsDict']]] = None,
                              quotas: Optional[Sequence[Union['GetObjectStorageQuotasQuotaArgs', 'GetObjectStorageQuotasQuotaArgsDict']]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetObjectStorageQuotasResult:
    """
    Provides details about a list of Object Storage quotas information on your account.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-object-storage-quotas).

    ## Example Usage

    The following example shows how one might use this data source to list and filter information about Object Storage quotas.

    ```python
    import pulumi
    import pulumi_linode as linode

    max_buckets_quotas = linode.get_object_storage_quotas(filters=[{
        "name": "endpoint_type",
        "values": ["E0"],
    }])
    ```

    ## Filterable Fields

    * `quota_id`

    * `quota_name`

    * `endpoint_type`

    * `s3_endpoint`

    * `description`

    * `quota_limit`

    * `resource_metric`
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['quotas'] = quotas
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getObjectStorageQuotas:getObjectStorageQuotas', __args__, opts=opts, typ=GetObjectStorageQuotasResult).value

    return AwaitableGetObjectStorageQuotasResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        quotas=pulumi.get(__ret__, 'quotas'))
def get_object_storage_quotas_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetObjectStorageQuotasFilterArgs', 'GetObjectStorageQuotasFilterArgsDict']]]]] = None,
                                     quotas: Optional[pulumi.Input[Optional[Sequence[Union['GetObjectStorageQuotasQuotaArgs', 'GetObjectStorageQuotasQuotaArgsDict']]]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetObjectStorageQuotasResult]:
    """
    Provides details about a list of Object Storage quotas information on your account.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-object-storage-quotas).

    ## Example Usage

    The following example shows how one might use this data source to list and filter information about Object Storage quotas.

    ```python
    import pulumi
    import pulumi_linode as linode

    max_buckets_quotas = linode.get_object_storage_quotas(filters=[{
        "name": "endpoint_type",
        "values": ["E0"],
    }])
    ```

    ## Filterable Fields

    * `quota_id`

    * `quota_name`

    * `endpoint_type`

    * `s3_endpoint`

    * `description`

    * `quota_limit`

    * `resource_metric`
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['quotas'] = quotas
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getObjectStorageQuotas:getObjectStorageQuotas', __args__, opts=opts, typ=GetObjectStorageQuotasResult)
    return __ret__.apply(lambda __response__: GetObjectStorageQuotasResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        quotas=pulumi.get(__response__, 'quotas')))
