# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRegionResult',
    'AwaitableGetRegionResult',
    'get_region',
    'get_region_output',
]

@pulumi.output_type
class GetRegionResult:
    """
    A collection of values returned by getRegion.
    """
    def __init__(__self__, capabilities=None, country=None, id=None, label=None, placement_group_limits=None, resolvers=None, site_type=None, status=None):
        if capabilities and not isinstance(capabilities, list):
            raise TypeError("Expected argument 'capabilities' to be a list")
        pulumi.set(__self__, "capabilities", capabilities)
        if country and not isinstance(country, str):
            raise TypeError("Expected argument 'country' to be a str")
        pulumi.set(__self__, "country", country)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if label and not isinstance(label, str):
            raise TypeError("Expected argument 'label' to be a str")
        pulumi.set(__self__, "label", label)
        if placement_group_limits and not isinstance(placement_group_limits, list):
            raise TypeError("Expected argument 'placement_group_limits' to be a list")
        pulumi.set(__self__, "placement_group_limits", placement_group_limits)
        if resolvers and not isinstance(resolvers, list):
            raise TypeError("Expected argument 'resolvers' to be a list")
        pulumi.set(__self__, "resolvers", resolvers)
        if site_type and not isinstance(site_type, str):
            raise TypeError("Expected argument 'site_type' to be a str")
        pulumi.set(__self__, "site_type", site_type)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> Sequence[_builtins.str]:
        """
        A list of capabilities of this region.
        """
        return pulumi.get(self, "capabilities")

    @_builtins.property
    @pulumi.getter
    def country(self) -> _builtins.str:
        """
        The country the region resides in.
        """
        return pulumi.get(self, "country")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Detailed location information for this Region, including city, state or region, and country.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="placementGroupLimits")
    def placement_group_limits(self) -> Sequence['outputs.GetRegionPlacementGroupLimitResult']:
        return pulumi.get(self, "placement_group_limits")

    @_builtins.property
    @pulumi.getter
    def resolvers(self) -> Optional[Sequence['outputs.GetRegionResolverResult']]:
        return pulumi.get(self, "resolvers")

    @_builtins.property
    @pulumi.getter(name="siteType")
    def site_type(self) -> _builtins.str:
        """
        The type of this region.
        """
        return pulumi.get(self, "site_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        This region’s current operational status (ok or outage).
        """
        return pulumi.get(self, "status")


class AwaitableGetRegionResult(GetRegionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegionResult(
            capabilities=self.capabilities,
            country=self.country,
            id=self.id,
            label=self.label,
            placement_group_limits=self.placement_group_limits,
            resolvers=self.resolvers,
            site_type=self.site_type,
            status=self.status)


def get_region(id: Optional[_builtins.str] = None,
               resolvers: Optional[Sequence[Union['GetRegionResolverArgs', 'GetRegionResolverArgsDict']]] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegionResult:
    """
    `get_region` provides details about a specific Linode region. See all regions [here](https://api.linode.com/v4/regions).
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-region).

    ## Example Usage

    The following example shows how the resource might be used to obtain additional information about a Linode region.

    ```python
    import pulumi
    import pulumi_linode as linode

    region = linode.get_region(id="us-east")
    ```


    :param _builtins.str id: The code name of the region to select.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['resolvers'] = resolvers
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getRegion:getRegion', __args__, opts=opts, typ=GetRegionResult).value

    return AwaitableGetRegionResult(
        capabilities=pulumi.get(__ret__, 'capabilities'),
        country=pulumi.get(__ret__, 'country'),
        id=pulumi.get(__ret__, 'id'),
        label=pulumi.get(__ret__, 'label'),
        placement_group_limits=pulumi.get(__ret__, 'placement_group_limits'),
        resolvers=pulumi.get(__ret__, 'resolvers'),
        site_type=pulumi.get(__ret__, 'site_type'),
        status=pulumi.get(__ret__, 'status'))
def get_region_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                      resolvers: Optional[pulumi.Input[Optional[Sequence[Union['GetRegionResolverArgs', 'GetRegionResolverArgsDict']]]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRegionResult]:
    """
    `get_region` provides details about a specific Linode region. See all regions [here](https://api.linode.com/v4/regions).
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-region).

    ## Example Usage

    The following example shows how the resource might be used to obtain additional information about a Linode region.

    ```python
    import pulumi
    import pulumi_linode as linode

    region = linode.get_region(id="us-east")
    ```


    :param _builtins.str id: The code name of the region to select.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['resolvers'] = resolvers
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getRegion:getRegion', __args__, opts=opts, typ=GetRegionResult)
    return __ret__.apply(lambda __response__: GetRegionResult(
        capabilities=pulumi.get(__response__, 'capabilities'),
        country=pulumi.get(__response__, 'country'),
        id=pulumi.get(__response__, 'id'),
        label=pulumi.get(__response__, 'label'),
        placement_group_limits=pulumi.get(__response__, 'placement_group_limits'),
        resolvers=pulumi.get(__response__, 'resolvers'),
        site_type=pulumi.get(__response__, 'site_type'),
        status=pulumi.get(__response__, 'status')))
