# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkingIpArgs', 'NetworkingIp']

@pulumi.input_type
class NetworkingIpArgs:
    def __init__(__self__, *,
                 linode_id: Optional[pulumi.Input[_builtins.int]] = None,
                 public: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkingIp resource.
        :param pulumi.Input[_builtins.int] linode_id: The ID of the Linode to which the IP address will be assigned. Updating this field on an ephemeral IP will trigger a recreation. Conflicts with `region`.
        :param pulumi.Input[_builtins.bool] public: Whether the IP address is public. Defaults to true.
        :param pulumi.Input[_builtins.str] region: The region for the reserved IPv4 address. Required when reserved is true and linode_id is not set.
        :param pulumi.Input[_builtins.bool] reserved: Whether the IPv4 address should be reserved.
        :param pulumi.Input[_builtins.str] type: The type of IP address. (ipv4, ipv6, etc.)
        """
        if linode_id is not None:
            pulumi.set(__self__, "linode_id", linode_id)
        if public is not None:
            pulumi.set(__self__, "public", public)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reserved is not None:
            pulumi.set(__self__, "reserved", reserved)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="linodeId")
    def linode_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the Linode to which the IP address will be assigned. Updating this field on an ephemeral IP will trigger a recreation. Conflicts with `region`.
        """
        return pulumi.get(self, "linode_id")

    @linode_id.setter
    def linode_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "linode_id", value)

    @_builtins.property
    @pulumi.getter
    def public(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the IP address is public. Defaults to true.
        """
        return pulumi.get(self, "public")

    @public.setter
    def public(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region for the reserved IPv4 address. Required when reserved is true and linode_id is not set.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def reserved(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the IPv4 address should be reserved.
        """
        return pulumi.get(self, "reserved")

    @reserved.setter
    def reserved(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reserved", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of IP address. (ipv4, ipv6, etc.)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _NetworkingIpState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 linode_id: Optional[pulumi.Input[_builtins.int]] = None,
                 prefix: Optional[pulumi.Input[_builtins.int]] = None,
                 public: Optional[pulumi.Input[_builtins.bool]] = None,
                 rdns: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved: Optional[pulumi.Input[_builtins.bool]] = None,
                 subnet_mask: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_nat11: Optional[pulumi.Input['NetworkingIpVpcNat11Args']] = None):
        """
        Input properties used for looking up and filtering NetworkingIp resources.
        :param pulumi.Input[_builtins.str] address: The IPv4 address that is configured as a 1:1 NAT for this VPC interface.
        :param pulumi.Input[_builtins.str] gateway: The default gateway for this address.
        :param pulumi.Input[_builtins.int] linode_id: The ID of the Linode to which the IP address will be assigned. Updating this field on an ephemeral IP will trigger a recreation. Conflicts with `region`.
        :param pulumi.Input[_builtins.int] prefix: The number of bits set in the subnet mask.
        :param pulumi.Input[_builtins.bool] public: Whether the IP address is public. Defaults to true.
        :param pulumi.Input[_builtins.str] rdns: The reverse DNS assigned to this address. For public IPv4 addresses, this will be set to a default value provided by Linode if not explicitly set.
        :param pulumi.Input[_builtins.str] region: The region for the reserved IPv4 address. Required when reserved is true and linode_id is not set.
        :param pulumi.Input[_builtins.bool] reserved: Whether the IPv4 address should be reserved.
        :param pulumi.Input[_builtins.str] subnet_mask: The mask that separates host bits from network bits for this address.
        :param pulumi.Input[_builtins.str] type: The type of IP address. (ipv4, ipv6, etc.)
        :param pulumi.Input['NetworkingIpVpcNat11Args'] vpc_nat11: Contains information about the NAT 1:1 mapping of a public IP address to a VPC subnet.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if linode_id is not None:
            pulumi.set(__self__, "linode_id", linode_id)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if public is not None:
            pulumi.set(__self__, "public", public)
        if rdns is not None:
            pulumi.set(__self__, "rdns", rdns)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reserved is not None:
            pulumi.set(__self__, "reserved", reserved)
        if subnet_mask is not None:
            pulumi.set(__self__, "subnet_mask", subnet_mask)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vpc_nat11 is not None:
            pulumi.set(__self__, "vpc_nat11", vpc_nat11)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 address that is configured as a 1:1 NAT for this VPC interface.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default gateway for this address.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway", value)

    @_builtins.property
    @pulumi.getter(name="linodeId")
    def linode_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the Linode to which the IP address will be assigned. Updating this field on an ephemeral IP will trigger a recreation. Conflicts with `region`.
        """
        return pulumi.get(self, "linode_id")

    @linode_id.setter
    def linode_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "linode_id", value)

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of bits set in the subnet mask.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "prefix", value)

    @_builtins.property
    @pulumi.getter
    def public(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the IP address is public. Defaults to true.
        """
        return pulumi.get(self, "public")

    @public.setter
    def public(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public", value)

    @_builtins.property
    @pulumi.getter
    def rdns(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reverse DNS assigned to this address. For public IPv4 addresses, this will be set to a default value provided by Linode if not explicitly set.
        """
        return pulumi.get(self, "rdns")

    @rdns.setter
    def rdns(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rdns", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region for the reserved IPv4 address. Required when reserved is true and linode_id is not set.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def reserved(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the IPv4 address should be reserved.
        """
        return pulumi.get(self, "reserved")

    @reserved.setter
    def reserved(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reserved", value)

    @_builtins.property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mask that separates host bits from network bits for this address.
        """
        return pulumi.get(self, "subnet_mask")

    @subnet_mask.setter
    def subnet_mask(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_mask", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of IP address. (ipv4, ipv6, etc.)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="vpcNat11")
    def vpc_nat11(self) -> Optional[pulumi.Input['NetworkingIpVpcNat11Args']]:
        """
        Contains information about the NAT 1:1 mapping of a public IP address to a VPC subnet.
        """
        return pulumi.get(self, "vpc_nat11")

    @vpc_nat11.setter
    def vpc_nat11(self, value: Optional[pulumi.Input['NetworkingIpVpcNat11Args']]):
        pulumi.set(self, "vpc_nat11", value)


@pulumi.type_token("linode:index/networkingIp:NetworkingIp")
class NetworkingIp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 linode_id: Optional[pulumi.Input[_builtins.int]] = None,
                 public: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages allocation of reserved IPv4 address in a region and optionally assigning the reserved address to a Linode instance.

        For more information, see the corresponding [API documentation](https://techdocs.akamai.com/linode-api/reference/post-allocate-ip).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_linode as linode

        test_ip = linode.NetworkingIp("test_ip",
            type="ipv4",
            linode_id=12345,
            public=True)
        ```

        ## Import

        IP addresses can be imported using the IP address ID, e.g.

        ```sh
        $ pulumi import linode:index/networkingIp:NetworkingIp example_ip 172.104.30.209
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] linode_id: The ID of the Linode to which the IP address will be assigned. Updating this field on an ephemeral IP will trigger a recreation. Conflicts with `region`.
        :param pulumi.Input[_builtins.bool] public: Whether the IP address is public. Defaults to true.
        :param pulumi.Input[_builtins.str] region: The region for the reserved IPv4 address. Required when reserved is true and linode_id is not set.
        :param pulumi.Input[_builtins.bool] reserved: Whether the IPv4 address should be reserved.
        :param pulumi.Input[_builtins.str] type: The type of IP address. (ipv4, ipv6, etc.)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[NetworkingIpArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages allocation of reserved IPv4 address in a region and optionally assigning the reserved address to a Linode instance.

        For more information, see the corresponding [API documentation](https://techdocs.akamai.com/linode-api/reference/post-allocate-ip).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_linode as linode

        test_ip = linode.NetworkingIp("test_ip",
            type="ipv4",
            linode_id=12345,
            public=True)
        ```

        ## Import

        IP addresses can be imported using the IP address ID, e.g.

        ```sh
        $ pulumi import linode:index/networkingIp:NetworkingIp example_ip 172.104.30.209
        ```

        :param str resource_name: The name of the resource.
        :param NetworkingIpArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkingIpArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 linode_id: Optional[pulumi.Input[_builtins.int]] = None,
                 public: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkingIpArgs.__new__(NetworkingIpArgs)

            __props__.__dict__["linode_id"] = linode_id
            __props__.__dict__["public"] = public
            __props__.__dict__["region"] = region
            __props__.__dict__["reserved"] = reserved
            __props__.__dict__["type"] = type
            __props__.__dict__["address"] = None
            __props__.__dict__["gateway"] = None
            __props__.__dict__["prefix"] = None
            __props__.__dict__["rdns"] = None
            __props__.__dict__["subnet_mask"] = None
            __props__.__dict__["vpc_nat11"] = None
        super(NetworkingIp, __self__).__init__(
            'linode:index/networkingIp:NetworkingIp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[_builtins.str]] = None,
            gateway: Optional[pulumi.Input[_builtins.str]] = None,
            linode_id: Optional[pulumi.Input[_builtins.int]] = None,
            prefix: Optional[pulumi.Input[_builtins.int]] = None,
            public: Optional[pulumi.Input[_builtins.bool]] = None,
            rdns: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            reserved: Optional[pulumi.Input[_builtins.bool]] = None,
            subnet_mask: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_nat11: Optional[pulumi.Input[Union['NetworkingIpVpcNat11Args', 'NetworkingIpVpcNat11ArgsDict']]] = None) -> 'NetworkingIp':
        """
        Get an existing NetworkingIp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: The IPv4 address that is configured as a 1:1 NAT for this VPC interface.
        :param pulumi.Input[_builtins.str] gateway: The default gateway for this address.
        :param pulumi.Input[_builtins.int] linode_id: The ID of the Linode to which the IP address will be assigned. Updating this field on an ephemeral IP will trigger a recreation. Conflicts with `region`.
        :param pulumi.Input[_builtins.int] prefix: The number of bits set in the subnet mask.
        :param pulumi.Input[_builtins.bool] public: Whether the IP address is public. Defaults to true.
        :param pulumi.Input[_builtins.str] rdns: The reverse DNS assigned to this address. For public IPv4 addresses, this will be set to a default value provided by Linode if not explicitly set.
        :param pulumi.Input[_builtins.str] region: The region for the reserved IPv4 address. Required when reserved is true and linode_id is not set.
        :param pulumi.Input[_builtins.bool] reserved: Whether the IPv4 address should be reserved.
        :param pulumi.Input[_builtins.str] subnet_mask: The mask that separates host bits from network bits for this address.
        :param pulumi.Input[_builtins.str] type: The type of IP address. (ipv4, ipv6, etc.)
        :param pulumi.Input[Union['NetworkingIpVpcNat11Args', 'NetworkingIpVpcNat11ArgsDict']] vpc_nat11: Contains information about the NAT 1:1 mapping of a public IP address to a VPC subnet.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkingIpState.__new__(_NetworkingIpState)

        __props__.__dict__["address"] = address
        __props__.__dict__["gateway"] = gateway
        __props__.__dict__["linode_id"] = linode_id
        __props__.__dict__["prefix"] = prefix
        __props__.__dict__["public"] = public
        __props__.__dict__["rdns"] = rdns
        __props__.__dict__["region"] = region
        __props__.__dict__["reserved"] = reserved
        __props__.__dict__["subnet_mask"] = subnet_mask
        __props__.__dict__["type"] = type
        __props__.__dict__["vpc_nat11"] = vpc_nat11
        return NetworkingIp(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Output[_builtins.str]:
        """
        The IPv4 address that is configured as a 1:1 NAT for this VPC interface.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> pulumi.Output[_builtins.str]:
        """
        The default gateway for this address.
        """
        return pulumi.get(self, "gateway")

    @_builtins.property
    @pulumi.getter(name="linodeId")
    def linode_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the Linode to which the IP address will be assigned. Updating this field on an ephemeral IP will trigger a recreation. Conflicts with `region`.
        """
        return pulumi.get(self, "linode_id")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> pulumi.Output[_builtins.int]:
        """
        The number of bits set in the subnet mask.
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter
    def public(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the IP address is public. Defaults to true.
        """
        return pulumi.get(self, "public")

    @_builtins.property
    @pulumi.getter
    def rdns(self) -> pulumi.Output[_builtins.str]:
        """
        The reverse DNS assigned to this address. For public IPv4 addresses, this will be set to a default value provided by Linode if not explicitly set.
        """
        return pulumi.get(self, "rdns")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region for the reserved IPv4 address. Required when reserved is true and linode_id is not set.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def reserved(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the IPv4 address should be reserved.
        """
        return pulumi.get(self, "reserved")

    @_builtins.property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> pulumi.Output[_builtins.str]:
        """
        The mask that separates host bits from network bits for this address.
        """
        return pulumi.get(self, "subnet_mask")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of IP address. (ipv4, ipv6, etc.)
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="vpcNat11")
    def vpc_nat11(self) -> pulumi.Output['outputs.NetworkingIpVpcNat11']:
        """
        Contains information about the NAT 1:1 mapping of a public IP address to a VPC subnet.
        """
        return pulumi.get(self, "vpc_nat11")

