# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NodeBalancerConfigArgs', 'NodeBalancerConfig']

@pulumi.input_type
class NodeBalancerConfigArgs:
    def __init__(__self__, *,
                 nodebalancer_id: pulumi.Input[_builtins.int],
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 check: Optional[pulumi.Input[_builtins.str]] = None,
                 check_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 check_body: Optional[pulumi.Input[_builtins.str]] = None,
                 check_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 check_passive: Optional[pulumi.Input[_builtins.bool]] = None,
                 check_path: Optional[pulumi.Input[_builtins.str]] = None,
                 check_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 cipher_suite: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_key: Optional[pulumi.Input[_builtins.str]] = None,
                 stickiness: Optional[pulumi.Input[_builtins.str]] = None,
                 udp_check_port: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a NodeBalancerConfig resource.
        :param pulumi.Input[_builtins.int] nodebalancer_id: The ID of the NodeBalancer to access.
               
               - - -
        :param pulumi.Input[_builtins.str] algorithm: What algorithm this NodeBalancer should use for routing traffic to backends. (`roundrobin`, `leastconn`, `source`)
        :param pulumi.Input[_builtins.str] check: The type of check to perform against backends to ensure they are serving requests. This is used to determine if backends are up or down. If none no check is performed. connection requires only a connection to the backend to succeed. http and http_body rely on the backend serving HTTP, and that the response returned matches what is expected. (`none`, `connection`, `http`, `http_body`)
        :param pulumi.Input[_builtins.int] check_attempts: How many times to attempt a check before considering a backend to be down. (1-30)
        :param pulumi.Input[_builtins.str] check_body: This value must be present in the response body of the check in order for it to pass. If this value is not present in the response body of a check request, the backend is considered to be down
        :param pulumi.Input[_builtins.int] check_interval: How often, in seconds, to check that backends are up and serving requests.
        :param pulumi.Input[_builtins.bool] check_passive: If true, any response from this backend with a 5xx status code will be enough for it to be considered unhealthy and taken out of rotation.
        :param pulumi.Input[_builtins.str] check_path: The URL path to check on each backend. If the backend does not respond to this request it is considered to be down.
        :param pulumi.Input[_builtins.int] check_timeout: How long, in seconds, to wait for a check attempt before considering it failed. (1-30)
        :param pulumi.Input[_builtins.str] cipher_suite: What ciphers to use for SSL connections served by this NodeBalancer. `legacy` is considered insecure and should only be used if necessary.
        :param pulumi.Input[_builtins.int] port: The TCP port this Config is for. These values must be unique across configs on a single NodeBalancer (you can't have two configs for port 80, for example). While some ports imply some protocols, no enforcement is done and you may configure your NodeBalancer however is useful to you. For example, while port 443 is generally used for HTTPS, you do not need SSL configured to have a NodeBalancer listening on port 443. (Defaults to 80)
        :param pulumi.Input[_builtins.str] protocol: The protocol this port is configured to serve. If this is set to https you must include an ssl_cert and an ssl_key. (`http`, `https`, `tcp`) (Defaults to `http`)
        :param pulumi.Input[_builtins.str] proxy_protocol: The version of ProxyProtocol to use for the underlying NodeBalancer. This requires protocol to be `tcp`. (`none`, `v1`, `v2`) (Defaults to `none`)
        :param pulumi.Input[_builtins.str] ssl_cert: The certificate this port is serving. This is not returned. If set, this field will come back as `<REDACTED>`. Please use the ssl_commonname and ssl_fingerprint to identify the certificate.
        :param pulumi.Input[_builtins.str] ssl_key: The private key corresponding to this port's certificate. This is not returned. If set, this field will come back as `<REDACTED>`. Please use the ssl_commonname and ssl_fingerprint to identify the certificate.
        :param pulumi.Input[_builtins.str] stickiness: Controls how session stickiness is handled on this port. (`none`, `table`, `http_cookie`)
        :param pulumi.Input[_builtins.int] udp_check_port: Specifies the port on the backend node used for active health checks, which may differ from the port serving traffic. Defaults to 80.
               
               * **NOTE: This argument may not be generally available.**
        """
        pulumi.set(__self__, "nodebalancer_id", nodebalancer_id)
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if check is not None:
            pulumi.set(__self__, "check", check)
        if check_attempts is not None:
            pulumi.set(__self__, "check_attempts", check_attempts)
        if check_body is not None:
            pulumi.set(__self__, "check_body", check_body)
        if check_interval is not None:
            pulumi.set(__self__, "check_interval", check_interval)
        if check_passive is not None:
            pulumi.set(__self__, "check_passive", check_passive)
        if check_path is not None:
            pulumi.set(__self__, "check_path", check_path)
        if check_timeout is not None:
            pulumi.set(__self__, "check_timeout", check_timeout)
        if cipher_suite is not None:
            pulumi.set(__self__, "cipher_suite", cipher_suite)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if proxy_protocol is not None:
            pulumi.set(__self__, "proxy_protocol", proxy_protocol)
        if ssl_cert is not None:
            pulumi.set(__self__, "ssl_cert", ssl_cert)
        if ssl_key is not None:
            pulumi.set(__self__, "ssl_key", ssl_key)
        if stickiness is not None:
            pulumi.set(__self__, "stickiness", stickiness)
        if udp_check_port is not None:
            pulumi.set(__self__, "udp_check_port", udp_check_port)

    @_builtins.property
    @pulumi.getter(name="nodebalancerId")
    def nodebalancer_id(self) -> pulumi.Input[_builtins.int]:
        """
        The ID of the NodeBalancer to access.

        - - -
        """
        return pulumi.get(self, "nodebalancer_id")

    @nodebalancer_id.setter
    def nodebalancer_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "nodebalancer_id", value)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        What algorithm this NodeBalancer should use for routing traffic to backends. (`roundrobin`, `leastconn`, `source`)
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter
    def check(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of check to perform against backends to ensure they are serving requests. This is used to determine if backends are up or down. If none no check is performed. connection requires only a connection to the backend to succeed. http and http_body rely on the backend serving HTTP, and that the response returned matches what is expected. (`none`, `connection`, `http`, `http_body`)
        """
        return pulumi.get(self, "check")

    @check.setter
    def check(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "check", value)

    @_builtins.property
    @pulumi.getter(name="checkAttempts")
    def check_attempts(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How many times to attempt a check before considering a backend to be down. (1-30)
        """
        return pulumi.get(self, "check_attempts")

    @check_attempts.setter
    def check_attempts(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "check_attempts", value)

    @_builtins.property
    @pulumi.getter(name="checkBody")
    def check_body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This value must be present in the response body of the check in order for it to pass. If this value is not present in the response body of a check request, the backend is considered to be down
        """
        return pulumi.get(self, "check_body")

    @check_body.setter
    def check_body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "check_body", value)

    @_builtins.property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How often, in seconds, to check that backends are up and serving requests.
        """
        return pulumi.get(self, "check_interval")

    @check_interval.setter
    def check_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "check_interval", value)

    @_builtins.property
    @pulumi.getter(name="checkPassive")
    def check_passive(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, any response from this backend with a 5xx status code will be enough for it to be considered unhealthy and taken out of rotation.
        """
        return pulumi.get(self, "check_passive")

    @check_passive.setter
    def check_passive(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "check_passive", value)

    @_builtins.property
    @pulumi.getter(name="checkPath")
    def check_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL path to check on each backend. If the backend does not respond to this request it is considered to be down.
        """
        return pulumi.get(self, "check_path")

    @check_path.setter
    def check_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "check_path", value)

    @_builtins.property
    @pulumi.getter(name="checkTimeout")
    def check_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How long, in seconds, to wait for a check attempt before considering it failed. (1-30)
        """
        return pulumi.get(self, "check_timeout")

    @check_timeout.setter
    def check_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "check_timeout", value)

    @_builtins.property
    @pulumi.getter(name="cipherSuite")
    def cipher_suite(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        What ciphers to use for SSL connections served by this NodeBalancer. `legacy` is considered insecure and should only be used if necessary.
        """
        return pulumi.get(self, "cipher_suite")

    @cipher_suite.setter
    def cipher_suite(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cipher_suite", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The TCP port this Config is for. These values must be unique across configs on a single NodeBalancer (you can't have two configs for port 80, for example). While some ports imply some protocols, no enforcement is done and you may configure your NodeBalancer however is useful to you. For example, while port 443 is generally used for HTTPS, you do not need SSL configured to have a NodeBalancer listening on port 443. (Defaults to 80)
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol this port is configured to serve. If this is set to https you must include an ssl_cert and an ssl_key. (`http`, `https`, `tcp`) (Defaults to `http`)
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of ProxyProtocol to use for the underlying NodeBalancer. This requires protocol to be `tcp`. (`none`, `v1`, `v2`) (Defaults to `none`)
        """
        return pulumi.get(self, "proxy_protocol")

    @proxy_protocol.setter
    def proxy_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_protocol", value)

    @_builtins.property
    @pulumi.getter(name="sslCert")
    def ssl_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate this port is serving. This is not returned. If set, this field will come back as `<REDACTED>`. Please use the ssl_commonname and ssl_fingerprint to identify the certificate.
        """
        return pulumi.get(self, "ssl_cert")

    @ssl_cert.setter
    def ssl_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_cert", value)

    @_builtins.property
    @pulumi.getter(name="sslKey")
    def ssl_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key corresponding to this port's certificate. This is not returned. If set, this field will come back as `<REDACTED>`. Please use the ssl_commonname and ssl_fingerprint to identify the certificate.
        """
        return pulumi.get(self, "ssl_key")

    @ssl_key.setter
    def ssl_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_key", value)

    @_builtins.property
    @pulumi.getter
    def stickiness(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls how session stickiness is handled on this port. (`none`, `table`, `http_cookie`)
        """
        return pulumi.get(self, "stickiness")

    @stickiness.setter
    def stickiness(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stickiness", value)

    @_builtins.property
    @pulumi.getter(name="udpCheckPort")
    def udp_check_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the port on the backend node used for active health checks, which may differ from the port serving traffic. Defaults to 80.

        * **NOTE: This argument may not be generally available.**
        """
        return pulumi.get(self, "udp_check_port")

    @udp_check_port.setter
    def udp_check_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "udp_check_port", value)


@pulumi.input_type
class _NodeBalancerConfigState:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 check: Optional[pulumi.Input[_builtins.str]] = None,
                 check_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 check_body: Optional[pulumi.Input[_builtins.str]] = None,
                 check_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 check_passive: Optional[pulumi.Input[_builtins.bool]] = None,
                 check_path: Optional[pulumi.Input[_builtins.str]] = None,
                 check_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 cipher_suite: Optional[pulumi.Input[_builtins.str]] = None,
                 node_statuses: Optional[pulumi.Input[Sequence[pulumi.Input['NodeBalancerConfigNodeStatusArgs']]]] = None,
                 nodebalancer_id: Optional[pulumi.Input[_builtins.int]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_commonname: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_key: Optional[pulumi.Input[_builtins.str]] = None,
                 stickiness: Optional[pulumi.Input[_builtins.str]] = None,
                 udp_check_port: Optional[pulumi.Input[_builtins.int]] = None,
                 udp_session_timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering NodeBalancerConfig resources.
        :param pulumi.Input[_builtins.str] algorithm: What algorithm this NodeBalancer should use for routing traffic to backends. (`roundrobin`, `leastconn`, `source`)
        :param pulumi.Input[_builtins.str] check: The type of check to perform against backends to ensure they are serving requests. This is used to determine if backends are up or down. If none no check is performed. connection requires only a connection to the backend to succeed. http and http_body rely on the backend serving HTTP, and that the response returned matches what is expected. (`none`, `connection`, `http`, `http_body`)
        :param pulumi.Input[_builtins.int] check_attempts: How many times to attempt a check before considering a backend to be down. (1-30)
        :param pulumi.Input[_builtins.str] check_body: This value must be present in the response body of the check in order for it to pass. If this value is not present in the response body of a check request, the backend is considered to be down
        :param pulumi.Input[_builtins.int] check_interval: How often, in seconds, to check that backends are up and serving requests.
        :param pulumi.Input[_builtins.bool] check_passive: If true, any response from this backend with a 5xx status code will be enough for it to be considered unhealthy and taken out of rotation.
        :param pulumi.Input[_builtins.str] check_path: The URL path to check on each backend. If the backend does not respond to this request it is considered to be down.
        :param pulumi.Input[_builtins.int] check_timeout: How long, in seconds, to wait for a check attempt before considering it failed. (1-30)
        :param pulumi.Input[_builtins.str] cipher_suite: What ciphers to use for SSL connections served by this NodeBalancer. `legacy` is considered insecure and should only be used if necessary.
        :param pulumi.Input[Sequence[pulumi.Input['NodeBalancerConfigNodeStatusArgs']]] node_statuses: A structure containing information about the health of the backends for this port. This information is updated periodically as checks are performed against backends.
        :param pulumi.Input[_builtins.int] nodebalancer_id: The ID of the NodeBalancer to access.
               
               - - -
        :param pulumi.Input[_builtins.int] port: The TCP port this Config is for. These values must be unique across configs on a single NodeBalancer (you can't have two configs for port 80, for example). While some ports imply some protocols, no enforcement is done and you may configure your NodeBalancer however is useful to you. For example, while port 443 is generally used for HTTPS, you do not need SSL configured to have a NodeBalancer listening on port 443. (Defaults to 80)
        :param pulumi.Input[_builtins.str] protocol: The protocol this port is configured to serve. If this is set to https you must include an ssl_cert and an ssl_key. (`http`, `https`, `tcp`) (Defaults to `http`)
        :param pulumi.Input[_builtins.str] proxy_protocol: The version of ProxyProtocol to use for the underlying NodeBalancer. This requires protocol to be `tcp`. (`none`, `v1`, `v2`) (Defaults to `none`)
        :param pulumi.Input[_builtins.str] ssl_cert: The certificate this port is serving. This is not returned. If set, this field will come back as `<REDACTED>`. Please use the ssl_commonname and ssl_fingerprint to identify the certificate.
        :param pulumi.Input[_builtins.str] ssl_commonname: The read-only common name automatically derived from the SSL certificate assigned to this NodeBalancerConfig. Please refer to this field to verify that the appropriate certificate is assigned to your NodeBalancerConfig.
        :param pulumi.Input[_builtins.str] ssl_fingerprint: The read-only fingerprint automatically derived from the SSL certificate assigned to this NodeBalancerConfig. Please refer to this field to verify that the appropriate certificate is assigned to your NodeBalancerConfig.
        :param pulumi.Input[_builtins.str] ssl_key: The private key corresponding to this port's certificate. This is not returned. If set, this field will come back as `<REDACTED>`. Please use the ssl_commonname and ssl_fingerprint to identify the certificate.
        :param pulumi.Input[_builtins.str] stickiness: Controls how session stickiness is handled on this port. (`none`, `table`, `http_cookie`)
        :param pulumi.Input[_builtins.int] udp_check_port: Specifies the port on the backend node used for active health checks, which may differ from the port serving traffic. Defaults to 80.
               
               * **NOTE: This argument may not be generally available.**
        :param pulumi.Input[_builtins.int] udp_session_timeout: The read-only idle time in seconds after which a session that hasn’t received packets is destroyed.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if check is not None:
            pulumi.set(__self__, "check", check)
        if check_attempts is not None:
            pulumi.set(__self__, "check_attempts", check_attempts)
        if check_body is not None:
            pulumi.set(__self__, "check_body", check_body)
        if check_interval is not None:
            pulumi.set(__self__, "check_interval", check_interval)
        if check_passive is not None:
            pulumi.set(__self__, "check_passive", check_passive)
        if check_path is not None:
            pulumi.set(__self__, "check_path", check_path)
        if check_timeout is not None:
            pulumi.set(__self__, "check_timeout", check_timeout)
        if cipher_suite is not None:
            pulumi.set(__self__, "cipher_suite", cipher_suite)
        if node_statuses is not None:
            pulumi.set(__self__, "node_statuses", node_statuses)
        if nodebalancer_id is not None:
            pulumi.set(__self__, "nodebalancer_id", nodebalancer_id)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if proxy_protocol is not None:
            pulumi.set(__self__, "proxy_protocol", proxy_protocol)
        if ssl_cert is not None:
            pulumi.set(__self__, "ssl_cert", ssl_cert)
        if ssl_commonname is not None:
            pulumi.set(__self__, "ssl_commonname", ssl_commonname)
        if ssl_fingerprint is not None:
            pulumi.set(__self__, "ssl_fingerprint", ssl_fingerprint)
        if ssl_key is not None:
            pulumi.set(__self__, "ssl_key", ssl_key)
        if stickiness is not None:
            pulumi.set(__self__, "stickiness", stickiness)
        if udp_check_port is not None:
            pulumi.set(__self__, "udp_check_port", udp_check_port)
        if udp_session_timeout is not None:
            pulumi.set(__self__, "udp_session_timeout", udp_session_timeout)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        What algorithm this NodeBalancer should use for routing traffic to backends. (`roundrobin`, `leastconn`, `source`)
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter
    def check(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of check to perform against backends to ensure they are serving requests. This is used to determine if backends are up or down. If none no check is performed. connection requires only a connection to the backend to succeed. http and http_body rely on the backend serving HTTP, and that the response returned matches what is expected. (`none`, `connection`, `http`, `http_body`)
        """
        return pulumi.get(self, "check")

    @check.setter
    def check(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "check", value)

    @_builtins.property
    @pulumi.getter(name="checkAttempts")
    def check_attempts(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How many times to attempt a check before considering a backend to be down. (1-30)
        """
        return pulumi.get(self, "check_attempts")

    @check_attempts.setter
    def check_attempts(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "check_attempts", value)

    @_builtins.property
    @pulumi.getter(name="checkBody")
    def check_body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This value must be present in the response body of the check in order for it to pass. If this value is not present in the response body of a check request, the backend is considered to be down
        """
        return pulumi.get(self, "check_body")

    @check_body.setter
    def check_body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "check_body", value)

    @_builtins.property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How often, in seconds, to check that backends are up and serving requests.
        """
        return pulumi.get(self, "check_interval")

    @check_interval.setter
    def check_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "check_interval", value)

    @_builtins.property
    @pulumi.getter(name="checkPassive")
    def check_passive(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, any response from this backend with a 5xx status code will be enough for it to be considered unhealthy and taken out of rotation.
        """
        return pulumi.get(self, "check_passive")

    @check_passive.setter
    def check_passive(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "check_passive", value)

    @_builtins.property
    @pulumi.getter(name="checkPath")
    def check_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL path to check on each backend. If the backend does not respond to this request it is considered to be down.
        """
        return pulumi.get(self, "check_path")

    @check_path.setter
    def check_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "check_path", value)

    @_builtins.property
    @pulumi.getter(name="checkTimeout")
    def check_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How long, in seconds, to wait for a check attempt before considering it failed. (1-30)
        """
        return pulumi.get(self, "check_timeout")

    @check_timeout.setter
    def check_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "check_timeout", value)

    @_builtins.property
    @pulumi.getter(name="cipherSuite")
    def cipher_suite(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        What ciphers to use for SSL connections served by this NodeBalancer. `legacy` is considered insecure and should only be used if necessary.
        """
        return pulumi.get(self, "cipher_suite")

    @cipher_suite.setter
    def cipher_suite(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cipher_suite", value)

    @_builtins.property
    @pulumi.getter(name="nodeStatuses")
    def node_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeBalancerConfigNodeStatusArgs']]]]:
        """
        A structure containing information about the health of the backends for this port. This information is updated periodically as checks are performed against backends.
        """
        return pulumi.get(self, "node_statuses")

    @node_statuses.setter
    def node_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeBalancerConfigNodeStatusArgs']]]]):
        pulumi.set(self, "node_statuses", value)

    @_builtins.property
    @pulumi.getter(name="nodebalancerId")
    def nodebalancer_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the NodeBalancer to access.

        - - -
        """
        return pulumi.get(self, "nodebalancer_id")

    @nodebalancer_id.setter
    def nodebalancer_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "nodebalancer_id", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The TCP port this Config is for. These values must be unique across configs on a single NodeBalancer (you can't have two configs for port 80, for example). While some ports imply some protocols, no enforcement is done and you may configure your NodeBalancer however is useful to you. For example, while port 443 is generally used for HTTPS, you do not need SSL configured to have a NodeBalancer listening on port 443. (Defaults to 80)
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol this port is configured to serve. If this is set to https you must include an ssl_cert and an ssl_key. (`http`, `https`, `tcp`) (Defaults to `http`)
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of ProxyProtocol to use for the underlying NodeBalancer. This requires protocol to be `tcp`. (`none`, `v1`, `v2`) (Defaults to `none`)
        """
        return pulumi.get(self, "proxy_protocol")

    @proxy_protocol.setter
    def proxy_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_protocol", value)

    @_builtins.property
    @pulumi.getter(name="sslCert")
    def ssl_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate this port is serving. This is not returned. If set, this field will come back as `<REDACTED>`. Please use the ssl_commonname and ssl_fingerprint to identify the certificate.
        """
        return pulumi.get(self, "ssl_cert")

    @ssl_cert.setter
    def ssl_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_cert", value)

    @_builtins.property
    @pulumi.getter(name="sslCommonname")
    def ssl_commonname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The read-only common name automatically derived from the SSL certificate assigned to this NodeBalancerConfig. Please refer to this field to verify that the appropriate certificate is assigned to your NodeBalancerConfig.
        """
        return pulumi.get(self, "ssl_commonname")

    @ssl_commonname.setter
    def ssl_commonname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_commonname", value)

    @_builtins.property
    @pulumi.getter(name="sslFingerprint")
    def ssl_fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The read-only fingerprint automatically derived from the SSL certificate assigned to this NodeBalancerConfig. Please refer to this field to verify that the appropriate certificate is assigned to your NodeBalancerConfig.
        """
        return pulumi.get(self, "ssl_fingerprint")

    @ssl_fingerprint.setter
    def ssl_fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_fingerprint", value)

    @_builtins.property
    @pulumi.getter(name="sslKey")
    def ssl_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key corresponding to this port's certificate. This is not returned. If set, this field will come back as `<REDACTED>`. Please use the ssl_commonname and ssl_fingerprint to identify the certificate.
        """
        return pulumi.get(self, "ssl_key")

    @ssl_key.setter
    def ssl_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_key", value)

    @_builtins.property
    @pulumi.getter
    def stickiness(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls how session stickiness is handled on this port. (`none`, `table`, `http_cookie`)
        """
        return pulumi.get(self, "stickiness")

    @stickiness.setter
    def stickiness(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stickiness", value)

    @_builtins.property
    @pulumi.getter(name="udpCheckPort")
    def udp_check_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the port on the backend node used for active health checks, which may differ from the port serving traffic. Defaults to 80.

        * **NOTE: This argument may not be generally available.**
        """
        return pulumi.get(self, "udp_check_port")

    @udp_check_port.setter
    def udp_check_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "udp_check_port", value)

    @_builtins.property
    @pulumi.getter(name="udpSessionTimeout")
    def udp_session_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The read-only idle time in seconds after which a session that hasn’t received packets is destroyed.
        """
        return pulumi.get(self, "udp_session_timeout")

    @udp_session_timeout.setter
    def udp_session_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "udp_session_timeout", value)


@pulumi.type_token("linode:index/nodeBalancerConfig:NodeBalancerConfig")
class NodeBalancerConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 check: Optional[pulumi.Input[_builtins.str]] = None,
                 check_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 check_body: Optional[pulumi.Input[_builtins.str]] = None,
                 check_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 check_passive: Optional[pulumi.Input[_builtins.bool]] = None,
                 check_path: Optional[pulumi.Input[_builtins.str]] = None,
                 check_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 cipher_suite: Optional[pulumi.Input[_builtins.str]] = None,
                 nodebalancer_id: Optional[pulumi.Input[_builtins.int]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_key: Optional[pulumi.Input[_builtins.str]] = None,
                 stickiness: Optional[pulumi.Input[_builtins.str]] = None,
                 udp_check_port: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Linode NodeBalancer Config resource.  This can be used to create, modify, and delete Linodes NodeBalancer Configs.
        For more information, see [Getting Started with NodeBalancers](https://www.linode.com/docs/platform/nodebalancer/getting-started-with-nodebalancers/) and the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/post-node-balancer-config).

        ## Example Usage

        The following example shows how one might use this resource to configure a NodeBalancer Config attached to a Linode instance.

        ```python
        import pulumi
        import pulumi_linode as linode

        foobar = linode.NodeBalancer("foobar",
            label="mynodebalancer",
            region="us-east",
            client_conn_throttle=20)
        foofig = linode.NodeBalancerConfig("foofig",
            nodebalancer_id=foobar.id,
            port=8088,
            protocol="http",
            check="http",
            check_path="/foo",
            check_attempts=3,
            check_timeout=30,
            udp_check_port=12345,
            stickiness="http_cookie",
            algorithm="source")
        ```

        ## Import

        NodeBalancer Configs can be imported using the NodeBalancer `nodebalancer_id` followed by the NodeBalancer Config `id` separated by a comma, e.g.

        ```sh
        $ pulumi import linode:index/nodeBalancerConfig:NodeBalancerConfig http-foobar 1234567,7654321
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] algorithm: What algorithm this NodeBalancer should use for routing traffic to backends. (`roundrobin`, `leastconn`, `source`)
        :param pulumi.Input[_builtins.str] check: The type of check to perform against backends to ensure they are serving requests. This is used to determine if backends are up or down. If none no check is performed. connection requires only a connection to the backend to succeed. http and http_body rely on the backend serving HTTP, and that the response returned matches what is expected. (`none`, `connection`, `http`, `http_body`)
        :param pulumi.Input[_builtins.int] check_attempts: How many times to attempt a check before considering a backend to be down. (1-30)
        :param pulumi.Input[_builtins.str] check_body: This value must be present in the response body of the check in order for it to pass. If this value is not present in the response body of a check request, the backend is considered to be down
        :param pulumi.Input[_builtins.int] check_interval: How often, in seconds, to check that backends are up and serving requests.
        :param pulumi.Input[_builtins.bool] check_passive: If true, any response from this backend with a 5xx status code will be enough for it to be considered unhealthy and taken out of rotation.
        :param pulumi.Input[_builtins.str] check_path: The URL path to check on each backend. If the backend does not respond to this request it is considered to be down.
        :param pulumi.Input[_builtins.int] check_timeout: How long, in seconds, to wait for a check attempt before considering it failed. (1-30)
        :param pulumi.Input[_builtins.str] cipher_suite: What ciphers to use for SSL connections served by this NodeBalancer. `legacy` is considered insecure and should only be used if necessary.
        :param pulumi.Input[_builtins.int] nodebalancer_id: The ID of the NodeBalancer to access.
               
               - - -
        :param pulumi.Input[_builtins.int] port: The TCP port this Config is for. These values must be unique across configs on a single NodeBalancer (you can't have two configs for port 80, for example). While some ports imply some protocols, no enforcement is done and you may configure your NodeBalancer however is useful to you. For example, while port 443 is generally used for HTTPS, you do not need SSL configured to have a NodeBalancer listening on port 443. (Defaults to 80)
        :param pulumi.Input[_builtins.str] protocol: The protocol this port is configured to serve. If this is set to https you must include an ssl_cert and an ssl_key. (`http`, `https`, `tcp`) (Defaults to `http`)
        :param pulumi.Input[_builtins.str] proxy_protocol: The version of ProxyProtocol to use for the underlying NodeBalancer. This requires protocol to be `tcp`. (`none`, `v1`, `v2`) (Defaults to `none`)
        :param pulumi.Input[_builtins.str] ssl_cert: The certificate this port is serving. This is not returned. If set, this field will come back as `<REDACTED>`. Please use the ssl_commonname and ssl_fingerprint to identify the certificate.
        :param pulumi.Input[_builtins.str] ssl_key: The private key corresponding to this port's certificate. This is not returned. If set, this field will come back as `<REDACTED>`. Please use the ssl_commonname and ssl_fingerprint to identify the certificate.
        :param pulumi.Input[_builtins.str] stickiness: Controls how session stickiness is handled on this port. (`none`, `table`, `http_cookie`)
        :param pulumi.Input[_builtins.int] udp_check_port: Specifies the port on the backend node used for active health checks, which may differ from the port serving traffic. Defaults to 80.
               
               * **NOTE: This argument may not be generally available.**
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NodeBalancerConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Linode NodeBalancer Config resource.  This can be used to create, modify, and delete Linodes NodeBalancer Configs.
        For more information, see [Getting Started with NodeBalancers](https://www.linode.com/docs/platform/nodebalancer/getting-started-with-nodebalancers/) and the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/post-node-balancer-config).

        ## Example Usage

        The following example shows how one might use this resource to configure a NodeBalancer Config attached to a Linode instance.

        ```python
        import pulumi
        import pulumi_linode as linode

        foobar = linode.NodeBalancer("foobar",
            label="mynodebalancer",
            region="us-east",
            client_conn_throttle=20)
        foofig = linode.NodeBalancerConfig("foofig",
            nodebalancer_id=foobar.id,
            port=8088,
            protocol="http",
            check="http",
            check_path="/foo",
            check_attempts=3,
            check_timeout=30,
            udp_check_port=12345,
            stickiness="http_cookie",
            algorithm="source")
        ```

        ## Import

        NodeBalancer Configs can be imported using the NodeBalancer `nodebalancer_id` followed by the NodeBalancer Config `id` separated by a comma, e.g.

        ```sh
        $ pulumi import linode:index/nodeBalancerConfig:NodeBalancerConfig http-foobar 1234567,7654321
        ```

        :param str resource_name: The name of the resource.
        :param NodeBalancerConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NodeBalancerConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 check: Optional[pulumi.Input[_builtins.str]] = None,
                 check_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 check_body: Optional[pulumi.Input[_builtins.str]] = None,
                 check_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 check_passive: Optional[pulumi.Input[_builtins.bool]] = None,
                 check_path: Optional[pulumi.Input[_builtins.str]] = None,
                 check_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 cipher_suite: Optional[pulumi.Input[_builtins.str]] = None,
                 nodebalancer_id: Optional[pulumi.Input[_builtins.int]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_key: Optional[pulumi.Input[_builtins.str]] = None,
                 stickiness: Optional[pulumi.Input[_builtins.str]] = None,
                 udp_check_port: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NodeBalancerConfigArgs.__new__(NodeBalancerConfigArgs)

            __props__.__dict__["algorithm"] = algorithm
            __props__.__dict__["check"] = check
            __props__.__dict__["check_attempts"] = check_attempts
            __props__.__dict__["check_body"] = check_body
            __props__.__dict__["check_interval"] = check_interval
            __props__.__dict__["check_passive"] = check_passive
            __props__.__dict__["check_path"] = check_path
            __props__.__dict__["check_timeout"] = check_timeout
            __props__.__dict__["cipher_suite"] = cipher_suite
            if nodebalancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'nodebalancer_id'")
            __props__.__dict__["nodebalancer_id"] = nodebalancer_id
            __props__.__dict__["port"] = port
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["proxy_protocol"] = proxy_protocol
            __props__.__dict__["ssl_cert"] = None if ssl_cert is None else pulumi.Output.secret(ssl_cert)
            __props__.__dict__["ssl_key"] = None if ssl_key is None else pulumi.Output.secret(ssl_key)
            __props__.__dict__["stickiness"] = stickiness
            __props__.__dict__["udp_check_port"] = udp_check_port
            __props__.__dict__["node_statuses"] = None
            __props__.__dict__["ssl_commonname"] = None
            __props__.__dict__["ssl_fingerprint"] = None
            __props__.__dict__["udp_session_timeout"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["sslCert", "sslKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(NodeBalancerConfig, __self__).__init__(
            'linode:index/nodeBalancerConfig:NodeBalancerConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            check: Optional[pulumi.Input[_builtins.str]] = None,
            check_attempts: Optional[pulumi.Input[_builtins.int]] = None,
            check_body: Optional[pulumi.Input[_builtins.str]] = None,
            check_interval: Optional[pulumi.Input[_builtins.int]] = None,
            check_passive: Optional[pulumi.Input[_builtins.bool]] = None,
            check_path: Optional[pulumi.Input[_builtins.str]] = None,
            check_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            cipher_suite: Optional[pulumi.Input[_builtins.str]] = None,
            node_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodeBalancerConfigNodeStatusArgs', 'NodeBalancerConfigNodeStatusArgsDict']]]]] = None,
            nodebalancer_id: Optional[pulumi.Input[_builtins.int]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            proxy_protocol: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_cert: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_commonname: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_key: Optional[pulumi.Input[_builtins.str]] = None,
            stickiness: Optional[pulumi.Input[_builtins.str]] = None,
            udp_check_port: Optional[pulumi.Input[_builtins.int]] = None,
            udp_session_timeout: Optional[pulumi.Input[_builtins.int]] = None) -> 'NodeBalancerConfig':
        """
        Get an existing NodeBalancerConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] algorithm: What algorithm this NodeBalancer should use for routing traffic to backends. (`roundrobin`, `leastconn`, `source`)
        :param pulumi.Input[_builtins.str] check: The type of check to perform against backends to ensure they are serving requests. This is used to determine if backends are up or down. If none no check is performed. connection requires only a connection to the backend to succeed. http and http_body rely on the backend serving HTTP, and that the response returned matches what is expected. (`none`, `connection`, `http`, `http_body`)
        :param pulumi.Input[_builtins.int] check_attempts: How many times to attempt a check before considering a backend to be down. (1-30)
        :param pulumi.Input[_builtins.str] check_body: This value must be present in the response body of the check in order for it to pass. If this value is not present in the response body of a check request, the backend is considered to be down
        :param pulumi.Input[_builtins.int] check_interval: How often, in seconds, to check that backends are up and serving requests.
        :param pulumi.Input[_builtins.bool] check_passive: If true, any response from this backend with a 5xx status code will be enough for it to be considered unhealthy and taken out of rotation.
        :param pulumi.Input[_builtins.str] check_path: The URL path to check on each backend. If the backend does not respond to this request it is considered to be down.
        :param pulumi.Input[_builtins.int] check_timeout: How long, in seconds, to wait for a check attempt before considering it failed. (1-30)
        :param pulumi.Input[_builtins.str] cipher_suite: What ciphers to use for SSL connections served by this NodeBalancer. `legacy` is considered insecure and should only be used if necessary.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodeBalancerConfigNodeStatusArgs', 'NodeBalancerConfigNodeStatusArgsDict']]]] node_statuses: A structure containing information about the health of the backends for this port. This information is updated periodically as checks are performed against backends.
        :param pulumi.Input[_builtins.int] nodebalancer_id: The ID of the NodeBalancer to access.
               
               - - -
        :param pulumi.Input[_builtins.int] port: The TCP port this Config is for. These values must be unique across configs on a single NodeBalancer (you can't have two configs for port 80, for example). While some ports imply some protocols, no enforcement is done and you may configure your NodeBalancer however is useful to you. For example, while port 443 is generally used for HTTPS, you do not need SSL configured to have a NodeBalancer listening on port 443. (Defaults to 80)
        :param pulumi.Input[_builtins.str] protocol: The protocol this port is configured to serve. If this is set to https you must include an ssl_cert and an ssl_key. (`http`, `https`, `tcp`) (Defaults to `http`)
        :param pulumi.Input[_builtins.str] proxy_protocol: The version of ProxyProtocol to use for the underlying NodeBalancer. This requires protocol to be `tcp`. (`none`, `v1`, `v2`) (Defaults to `none`)
        :param pulumi.Input[_builtins.str] ssl_cert: The certificate this port is serving. This is not returned. If set, this field will come back as `<REDACTED>`. Please use the ssl_commonname and ssl_fingerprint to identify the certificate.
        :param pulumi.Input[_builtins.str] ssl_commonname: The read-only common name automatically derived from the SSL certificate assigned to this NodeBalancerConfig. Please refer to this field to verify that the appropriate certificate is assigned to your NodeBalancerConfig.
        :param pulumi.Input[_builtins.str] ssl_fingerprint: The read-only fingerprint automatically derived from the SSL certificate assigned to this NodeBalancerConfig. Please refer to this field to verify that the appropriate certificate is assigned to your NodeBalancerConfig.
        :param pulumi.Input[_builtins.str] ssl_key: The private key corresponding to this port's certificate. This is not returned. If set, this field will come back as `<REDACTED>`. Please use the ssl_commonname and ssl_fingerprint to identify the certificate.
        :param pulumi.Input[_builtins.str] stickiness: Controls how session stickiness is handled on this port. (`none`, `table`, `http_cookie`)
        :param pulumi.Input[_builtins.int] udp_check_port: Specifies the port on the backend node used for active health checks, which may differ from the port serving traffic. Defaults to 80.
               
               * **NOTE: This argument may not be generally available.**
        :param pulumi.Input[_builtins.int] udp_session_timeout: The read-only idle time in seconds after which a session that hasn’t received packets is destroyed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NodeBalancerConfigState.__new__(_NodeBalancerConfigState)

        __props__.__dict__["algorithm"] = algorithm
        __props__.__dict__["check"] = check
        __props__.__dict__["check_attempts"] = check_attempts
        __props__.__dict__["check_body"] = check_body
        __props__.__dict__["check_interval"] = check_interval
        __props__.__dict__["check_passive"] = check_passive
        __props__.__dict__["check_path"] = check_path
        __props__.__dict__["check_timeout"] = check_timeout
        __props__.__dict__["cipher_suite"] = cipher_suite
        __props__.__dict__["node_statuses"] = node_statuses
        __props__.__dict__["nodebalancer_id"] = nodebalancer_id
        __props__.__dict__["port"] = port
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["proxy_protocol"] = proxy_protocol
        __props__.__dict__["ssl_cert"] = ssl_cert
        __props__.__dict__["ssl_commonname"] = ssl_commonname
        __props__.__dict__["ssl_fingerprint"] = ssl_fingerprint
        __props__.__dict__["ssl_key"] = ssl_key
        __props__.__dict__["stickiness"] = stickiness
        __props__.__dict__["udp_check_port"] = udp_check_port
        __props__.__dict__["udp_session_timeout"] = udp_session_timeout
        return NodeBalancerConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        What algorithm this NodeBalancer should use for routing traffic to backends. (`roundrobin`, `leastconn`, `source`)
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter
    def check(self) -> pulumi.Output[_builtins.str]:
        """
        The type of check to perform against backends to ensure they are serving requests. This is used to determine if backends are up or down. If none no check is performed. connection requires only a connection to the backend to succeed. http and http_body rely on the backend serving HTTP, and that the response returned matches what is expected. (`none`, `connection`, `http`, `http_body`)
        """
        return pulumi.get(self, "check")

    @_builtins.property
    @pulumi.getter(name="checkAttempts")
    def check_attempts(self) -> pulumi.Output[_builtins.int]:
        """
        How many times to attempt a check before considering a backend to be down. (1-30)
        """
        return pulumi.get(self, "check_attempts")

    @_builtins.property
    @pulumi.getter(name="checkBody")
    def check_body(self) -> pulumi.Output[_builtins.str]:
        """
        This value must be present in the response body of the check in order for it to pass. If this value is not present in the response body of a check request, the backend is considered to be down
        """
        return pulumi.get(self, "check_body")

    @_builtins.property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> pulumi.Output[_builtins.int]:
        """
        How often, in seconds, to check that backends are up and serving requests.
        """
        return pulumi.get(self, "check_interval")

    @_builtins.property
    @pulumi.getter(name="checkPassive")
    def check_passive(self) -> pulumi.Output[_builtins.bool]:
        """
        If true, any response from this backend with a 5xx status code will be enough for it to be considered unhealthy and taken out of rotation.
        """
        return pulumi.get(self, "check_passive")

    @_builtins.property
    @pulumi.getter(name="checkPath")
    def check_path(self) -> pulumi.Output[_builtins.str]:
        """
        The URL path to check on each backend. If the backend does not respond to this request it is considered to be down.
        """
        return pulumi.get(self, "check_path")

    @_builtins.property
    @pulumi.getter(name="checkTimeout")
    def check_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        How long, in seconds, to wait for a check attempt before considering it failed. (1-30)
        """
        return pulumi.get(self, "check_timeout")

    @_builtins.property
    @pulumi.getter(name="cipherSuite")
    def cipher_suite(self) -> pulumi.Output[_builtins.str]:
        """
        What ciphers to use for SSL connections served by this NodeBalancer. `legacy` is considered insecure and should only be used if necessary.
        """
        return pulumi.get(self, "cipher_suite")

    @_builtins.property
    @pulumi.getter(name="nodeStatuses")
    def node_statuses(self) -> pulumi.Output[Sequence['outputs.NodeBalancerConfigNodeStatus']]:
        """
        A structure containing information about the health of the backends for this port. This information is updated periodically as checks are performed against backends.
        """
        return pulumi.get(self, "node_statuses")

    @_builtins.property
    @pulumi.getter(name="nodebalancerId")
    def nodebalancer_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the NodeBalancer to access.

        - - -
        """
        return pulumi.get(self, "nodebalancer_id")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.int]:
        """
        The TCP port this Config is for. These values must be unique across configs on a single NodeBalancer (you can't have two configs for port 80, for example). While some ports imply some protocols, no enforcement is done and you may configure your NodeBalancer however is useful to you. For example, while port 443 is generally used for HTTPS, you do not need SSL configured to have a NodeBalancer listening on port 443. (Defaults to 80)
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        The protocol this port is configured to serve. If this is set to https you must include an ssl_cert and an ssl_key. (`http`, `https`, `tcp`) (Defaults to `http`)
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> pulumi.Output[_builtins.str]:
        """
        The version of ProxyProtocol to use for the underlying NodeBalancer. This requires protocol to be `tcp`. (`none`, `v1`, `v2`) (Defaults to `none`)
        """
        return pulumi.get(self, "proxy_protocol")

    @_builtins.property
    @pulumi.getter(name="sslCert")
    def ssl_cert(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The certificate this port is serving. This is not returned. If set, this field will come back as `<REDACTED>`. Please use the ssl_commonname and ssl_fingerprint to identify the certificate.
        """
        return pulumi.get(self, "ssl_cert")

    @_builtins.property
    @pulumi.getter(name="sslCommonname")
    def ssl_commonname(self) -> pulumi.Output[_builtins.str]:
        """
        The read-only common name automatically derived from the SSL certificate assigned to this NodeBalancerConfig. Please refer to this field to verify that the appropriate certificate is assigned to your NodeBalancerConfig.
        """
        return pulumi.get(self, "ssl_commonname")

    @_builtins.property
    @pulumi.getter(name="sslFingerprint")
    def ssl_fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        The read-only fingerprint automatically derived from the SSL certificate assigned to this NodeBalancerConfig. Please refer to this field to verify that the appropriate certificate is assigned to your NodeBalancerConfig.
        """
        return pulumi.get(self, "ssl_fingerprint")

    @_builtins.property
    @pulumi.getter(name="sslKey")
    def ssl_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The private key corresponding to this port's certificate. This is not returned. If set, this field will come back as `<REDACTED>`. Please use the ssl_commonname and ssl_fingerprint to identify the certificate.
        """
        return pulumi.get(self, "ssl_key")

    @_builtins.property
    @pulumi.getter
    def stickiness(self) -> pulumi.Output[_builtins.str]:
        """
        Controls how session stickiness is handled on this port. (`none`, `table`, `http_cookie`)
        """
        return pulumi.get(self, "stickiness")

    @_builtins.property
    @pulumi.getter(name="udpCheckPort")
    def udp_check_port(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the port on the backend node used for active health checks, which may differ from the port serving traffic. Defaults to 80.

        * **NOTE: This argument may not be generally available.**
        """
        return pulumi.get(self, "udp_check_port")

    @_builtins.property
    @pulumi.getter(name="udpSessionTimeout")
    def udp_session_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        The read-only idle time in seconds after which a session that hasn’t received packets is destroyed.
        """
        return pulumi.get(self, "udp_session_timeout")

