"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetDateRange = void 0;
class GetDateRange {
    constructor() {
        this.dateFormatString = (date) => {
            return (date.getFullYear()) + '-' + ('00' + (date.getMonth() + 1)).slice(-2) + '-' + ('00' + (date.getDate())).slice(-2);
        };
        const now = new Date(Date.now());
        if (now.getDate() === 1) {
            // Last month
            this.start = this.dateFormatString(new Date(now.getFullYear(), now.getMonth() - 1, 1));
            this.end = this.dateFormatString(new Date(now.getFullYear(), now.getMonth(), 0));
        }
        else {
            this.start = this.dateFormatString(new Date(now.getFullYear(), now.getMonth(), 1));
            this.end = this.dateFormatString(new Date(now.getFullYear(), now.getMonth(), now.getDate() - 1));
        }
    }
}
exports.GetDateRange = GetDateRange;
//# sourceMappingURL=data:application/json;base64,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