"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DailyCostUsageReporter = exports.CostGroupType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const crypto = require("crypto");
const cdk = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const scheduler = require("aws-cdk-lib/aws-scheduler");
const constructs_1 = require("constructs");
const cost_reporter_function_1 = require("./funcs/cost-reporter-function");
var CostGroupType;
(function (CostGroupType) {
    CostGroupType["ACCOUNTS"] = "Accounts";
    CostGroupType["SERVICES"] = "Services";
})(CostGroupType = exports.CostGroupType || (exports.CostGroupType = {}));
class DailyCostUsageReporter extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        // 👇Get current account & region
        const account = cdk.Stack.of(this).account;
        // const region = cdk.Stack.of(this).region;
        // 👇Create random key
        const randomNameKey = crypto.createHash('shake256', { outputLength: 4 })
            .update(`${cdk.Names.uniqueId(scope)}-${cdk.Names.uniqueId(this)}`)
            .digest('hex');
        // 👇Lambda Exec Role
        const lambdaExecutionRole = new iam.Role(this, 'LambdaExecutionRole', {
            roleName: `cost-report-lambda-exec-${randomNameKey}-role`,
            description: '',
            assumedBy: new iam.ServicePrincipal('lambda.amazonaws.com'),
            managedPolicies: [
                iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'),
            ],
            inlinePolicies: {
                ['get-cost-usage']: new iam.PolicyDocument({
                    statements: [
                        new iam.PolicyStatement({
                            effect: iam.Effect.ALLOW,
                            actions: [
                                'ce:GetCostAndUsage',
                            ],
                            resources: ['*'],
                        }),
                    ],
                }),
            },
        });
        // 👇Lambda Function
        const lambdaFunction = new cost_reporter_function_1.CostReporterFunction(this, 'CostReporterFunction', {
            functionName: `cost-report-${randomNameKey}-func`,
            description: 'A function to archive logs s3 bucket from CloudWatch Logs.',
            environment: {
                //BUCKET_NAME: logArchiveBucket.bucketName,
                SLACK_TOKEN: props.slackToken,
                SLACK_CHANNEL: props.slackChannel,
            },
            role: lambdaExecutionRole,
        });
        // 👇EventBridge Scheduler IAM Role
        const schedulerExecutionRole = new iam.Role(this, 'SchedulerExecutionRole', {
            roleName: `daily-cost-report-schedule-${randomNameKey}-exec-role`,
            assumedBy: new iam.ServicePrincipal('scheduler.amazonaws.com'),
            inlinePolicies: {
                ['lambda-invoke-policy']: new iam.PolicyDocument({
                    statements: [
                        new iam.PolicyStatement({
                            effect: iam.Effect.ALLOW,
                            actions: [
                                'lambda:InvokeFunction',
                            ],
                            resources: [
                                lambdaFunction.functionArn,
                                `${lambdaFunction.functionArn}:*`,
                            ],
                        }),
                    ],
                }),
            },
        });
        // 👇Schedule
        new scheduler.CfnSchedule(this, 'Schedule', {
            name: `daily-cost-report-${account}-schedule`,
            description: `aws account ${account} const reports.`,
            state: 'ENABLED',
            //groupName: scheduleGroup.name, // default
            flexibleTimeWindow: {
                mode: 'OFF',
            },
            scheduleExpressionTimezone: props.scheduleTimezone ?? 'UTC',
            scheduleExpression: 'cron(1 9 * * ? *)',
            target: {
                arn: lambdaFunction.functionArn,
                roleArn: schedulerExecutionRole.roleArn,
                input: JSON.stringify({ Type: props.costGroupType }),
                retryPolicy: {
                    maximumEventAgeInSeconds: 60,
                    maximumRetryAttempts: 0,
                },
            },
        });
    }
}
exports.DailyCostUsageReporter = DailyCostUsageReporter;
_a = JSII_RTTI_SYMBOL_1;
DailyCostUsageReporter[_a] = { fqn: "@gammarer/aws-daily-cost-usage-reporter.DailyCostUsageReporter", version: "0.9.1" };
//# sourceMappingURL=data:application/json;base64,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