# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LookupDefinitionArgs', 'LookupDefinition']

@pulumi.input_type
class LookupDefinitionArgs:
    def __init__(__self__, *,
                 filename: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 acl: Optional[pulumi.Input['LookupDefinitionAclArgs']] = None):
        """
        The set of arguments for constructing a LookupDefinition resource.
        :param pulumi.Input[builtins.str] filename: The filename for the lookup table, usually ending in `.csv`.
        :param pulumi.Input[builtins.str] name: A unique name for the lookup definition within the app context.
        :param pulumi.Input['LookupDefinitionAclArgs'] acl: Defines the access control list (ACL) for the lookup definition. See acl.md for more details.
        """
        pulumi.set(__self__, "filename", filename)
        pulumi.set(__self__, "name", name)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)

    @property
    @pulumi.getter
    def filename(self) -> pulumi.Input[builtins.str]:
        """
        The filename for the lookup table, usually ending in `.csv`.
        """
        return pulumi.get(self, "filename")

    @filename.setter
    def filename(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "filename", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        A unique name for the lookup definition within the app context.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input['LookupDefinitionAclArgs']]:
        """
        Defines the access control list (ACL) for the lookup definition. See acl.md for more details.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input['LookupDefinitionAclArgs']]):
        pulumi.set(self, "acl", value)


@pulumi.input_type
class _LookupDefinitionState:
    def __init__(__self__, *,
                 acl: Optional[pulumi.Input['LookupDefinitionAclArgs']] = None,
                 filename: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering LookupDefinition resources.
        :param pulumi.Input['LookupDefinitionAclArgs'] acl: Defines the access control list (ACL) for the lookup definition. See acl.md for more details.
        :param pulumi.Input[builtins.str] filename: The filename for the lookup table, usually ending in `.csv`.
        :param pulumi.Input[builtins.str] name: A unique name for the lookup definition within the app context.
        """
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if filename is not None:
            pulumi.set(__self__, "filename", filename)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input['LookupDefinitionAclArgs']]:
        """
        Defines the access control list (ACL) for the lookup definition. See acl.md for more details.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input['LookupDefinitionAclArgs']]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter
    def filename(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The filename for the lookup table, usually ending in `.csv`.
        """
        return pulumi.get(self, "filename")

    @filename.setter
    def filename(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filename", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique name for the lookup definition within the app context.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("splunk:index/lookupDefinition:LookupDefinition")
class LookupDefinition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[Union['LookupDefinitionAclArgs', 'LookupDefinitionAclArgsDict']]] = None,
                 filename: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## 

        # Resource: LookupDefinition

        Manage lookup definitions in Splunk. For more information on lookup definitions, refer to the official Splunk documentation: https://docs.splunk.com/Documentation/Splunk/latest/Knowledge/Aboutlookupsandfieldactions

        ## Example Usage

        ```python
        import pulumi
        import pulumi_splunk as splunk

        example = splunk.LookupDefinition("example",
            name="example_lookup_definition",
            filename="example_lookup_file.csv",
            acl={
                "owner": "admin",
                "app": "search",
                "sharing": "app",
                "reads": ["*"],
                "writes": ["admin"],
            })
        ```

        ## Validation Rules

        When `acl.sharing` is set to `user`, the `acl.read` and `acl.write` fields must not be explicitly set. Setting them will trigger a validation error.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LookupDefinitionAclArgs', 'LookupDefinitionAclArgsDict']] acl: Defines the access control list (ACL) for the lookup definition. See acl.md for more details.
        :param pulumi.Input[builtins.str] filename: The filename for the lookup table, usually ending in `.csv`.
        :param pulumi.Input[builtins.str] name: A unique name for the lookup definition within the app context.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LookupDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## 

        # Resource: LookupDefinition

        Manage lookup definitions in Splunk. For more information on lookup definitions, refer to the official Splunk documentation: https://docs.splunk.com/Documentation/Splunk/latest/Knowledge/Aboutlookupsandfieldactions

        ## Example Usage

        ```python
        import pulumi
        import pulumi_splunk as splunk

        example = splunk.LookupDefinition("example",
            name="example_lookup_definition",
            filename="example_lookup_file.csv",
            acl={
                "owner": "admin",
                "app": "search",
                "sharing": "app",
                "reads": ["*"],
                "writes": ["admin"],
            })
        ```

        ## Validation Rules

        When `acl.sharing` is set to `user`, the `acl.read` and `acl.write` fields must not be explicitly set. Setting them will trigger a validation error.

        :param str resource_name: The name of the resource.
        :param LookupDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LookupDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[Union['LookupDefinitionAclArgs', 'LookupDefinitionAclArgsDict']]] = None,
                 filename: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LookupDefinitionArgs.__new__(LookupDefinitionArgs)

            __props__.__dict__["acl"] = acl
            if filename is None and not opts.urn:
                raise TypeError("Missing required property 'filename'")
            __props__.__dict__["filename"] = filename
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
        super(LookupDefinition, __self__).__init__(
            'splunk:index/lookupDefinition:LookupDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[Union['LookupDefinitionAclArgs', 'LookupDefinitionAclArgsDict']]] = None,
            filename: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None) -> 'LookupDefinition':
        """
        Get an existing LookupDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LookupDefinitionAclArgs', 'LookupDefinitionAclArgsDict']] acl: Defines the access control list (ACL) for the lookup definition. See acl.md for more details.
        :param pulumi.Input[builtins.str] filename: The filename for the lookup table, usually ending in `.csv`.
        :param pulumi.Input[builtins.str] name: A unique name for the lookup definition within the app context.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LookupDefinitionState.__new__(_LookupDefinitionState)

        __props__.__dict__["acl"] = acl
        __props__.__dict__["filename"] = filename
        __props__.__dict__["name"] = name
        return LookupDefinition(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output['outputs.LookupDefinitionAcl']:
        """
        Defines the access control list (ACL) for the lookup definition. See acl.md for more details.
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter
    def filename(self) -> pulumi.Output[builtins.str]:
        """
        The filename for the lookup table, usually ending in `.csv`.
        """
        return pulumi.get(self, "filename")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A unique name for the lookup definition within the app context.
        """
        return pulumi.get(self, "name")

