import os
import subprocess

Dir = os.path.dirname(__file__)


def main() -> str:
    if subprocess.run(["cmake", "--version"]).returncode:
        raise RuntimeError("Could not find cmake")

    # get the compiler id and version
    if subprocess.run(
        ["cmake", "-S", Dir, "-B", os.path.join(Dir, "build")]
    ).returncode:
        raise RuntimeError(
            "Could not find a C++ 20 compiler. Do you have a C++ 20 compiler installed?"
        )

    # Get the compiler variables generated by the cmake file
    with open(os.path.join(Dir, "build", "compiler_id.txt")) as f:
        compiler_id_str = f.read().strip()
    with open(os.path.join(Dir, "build", "compiler_version.txt")) as f:
        compiler_version = f.read().strip()

    # convert the compiler id to an int so it can be used in a version number
    compiler_id_int = 0
    for b in compiler_id_str.encode("utf-8"):
        compiler_id_int <<= 8
        compiler_id_int += b

    # combine the compiler id and compiler version into a version number
    return f"==3.0.0.{compiler_id_int}.{compiler_version}"
