'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.load_ipython_extension = load_ipython_extension;
/**
 * This file contains the javascript that is run when the notebook is loaded.
 * It contains some requirejs configuration and the `load_ipython_extension` 
 * which is required for any notebook extension.
 */

/**
 * Configure requirejs.
 */
if (window.require) {
  window.require.config({
    map: {
      '*': {
        'jupyter_francy': 'nbextensions/jupyter_francy/index'
      }
    }
  });
}

/**
 * Export the required load_ipython_extention.
 */
function load_ipython_extension() {
  define(['base/js/namespace', 'nbextensions/jupyter_francy/index', 'nbextensions/jupyter_francy/francy'], function (Jupyter, Extension, FrancyBundle) {
    var notebook = Jupyter.notebook;

    Extension.init(Jupyter, FrancyBundle);
    Extension.register_renderer(notebook);
    Extension.render_cells(notebook);
  });
}