'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APPEND_ID = exports.CLASS_NAME = exports.MIME_TYPE = undefined;

var _d3Min = require('francy-js/lib/d3.min.js');

var d3 = _interopRequireWildcard(_d3Min);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

window.d3 = d3; // we need this to be present

var MIME_TYPE = exports.MIME_TYPE = 'application/vnd.francy+json';
var CLASS_NAME = exports.CLASS_NAME = 'jp-OutputWidget-Francy';
var APPEND_ID = exports.APPEND_ID = 'francy-drawing-div';

// this will execute always!
(function createHiddenDrawingDiv() {
  // Create a 'display: none;' div for drawings
  // well, better putting this as visibility hidden in order to get sizes as visibility prevent this
  // the workaround would be setTimeout(()=>{francy.render}, 10) :/
  var body = d3.select('body');
  if (!body.select('div#' + APPEND_ID).node()) {
    body.append('div').attr('id', APPEND_ID).attr('style', 'visibility: false;');
  }
})();