# hh-cli

[![PyPI version](https://img.shields.io/pypi/v/hhcli.svg)](https://pypi.org/project/hhcli/)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)
[![Follow on Telegram](https://img.shields.io/badge/Telegram-Join-blue?logo=telegram)](https://t.me/hhcli)

Неофициальный CLI-клиент для поиска работы и откликов на hh.ru.

`hh-cli` — это авторизованное приложение, позволяющее искать вакансии, просматривать их, отмечать понравившиеся и откликаться на них в интерфейсе терминала. У приложения есть [канал в Telegram](https://t.me/hhcli), где публикуются основные новости проекта.

> **Примечание:** hhcli — это авторизованное (легальное) приложение, одобренное hh.ru, однако, оно разрабатывается независимым разработчиком и не является официальным!

![gif-of-hhcli](img/review.gif "A short demo CLI TUI interface").

## Ключевые возможности

- Локальная база данных SQLite, хранящая профили, историю, кэш вакансий, справочники и т.д.
- Кроссплатформенный TUI-интерфейс (Linux, Windows).
- Профили для разных аккаунтов с поддержкой нескольких резюме внутри одного аккаунта.
- Два режима поиска: автоматический по рекомендациям hh.ru и ручной с настраиваемыми фильтрами.
- Отклик на несколько выбранных вакансий с отправкой сопроводительного письма.
- Хранение истории всех откликов и переписок с работодателями.
- Переписка с работодателями и форматирование текста сообщений прямо внутри приложения.
- Фильтры и отсев дубликатов вакансий (спама по городам). 
- Подсветка компаний, в которые ранее был отклик.
- Подсветка вакансий, на которые был отклик (по названию+компания или по id вакансии).
- Приложение чистит базу данных от устаревшего кэша вакансий (старше 5 дней) и логов (старше 20 дней).
- Выбор и возможность создания собственных тем оформления.

## Установка

### Linux

#### Ubuntu / Debian / Mint (apt)

```bash
sudo apt update && sudo apt install python3 python3-pip pipx git -y
pipx install hhcli
```

#### Arch / Manjaro (pacman)

```bash
sudo pacman -Syu python python-pip pipx git
pipx install hhcli
```

#### Fedora / RHEL / Rocky (dnf / yum)

```bash
sudo dnf install python3 python3-pip pipx git  # либо sudo yum install ...
pipx install hhcli
```

#### Другие дистрибутивы

- Установите Python ≥3.9 и `pipx` из стандартного репозитория.
- Выполните `pipx install hhcli`.
- Если `pipx` отсутствует, можно поставить локально: `pip install --user pipx && pipx ensurepath`.

### Windows

#### Установка Python и pipx

1. Скачайте Python 3.9+ с [python.org](https://www.python.org/downloads/windows/) и поставьте галочку “Add Python to PATH”.
2. Установите `pipx` (PowerShell или CMD, права администратора не нужны):

```powershell
python -m pip install --upgrade pip
python -m pip install pipx
python -m pipx ensurepath
```

#### Установка hhcli

Перезапустите PowerShell (или CMD) и выполните:

```powershell
pipx install hhcli
```

> После установки откройте новое окно PowerShell/Command Prompt, чтобы PATH подхватил `C:\Users\<имя>\.local\bin`. Если команда `hhcli` всё ещё не находится, убедитесь, что этот путь внесён в переменные среды (Параметры → Система → Дополнительные параметры → Переменные среды) и перезапустите терминал.

#### Обновление / удаление

- Обновить: `pipx install hhcli --force`
- Удалить: `pipx uninstall hhcli`

## Удаление

Используйте `pipx uninstall hhcli` (Windows и Linux) или, если ставили из исходников, удалите виртуальное окружение/пакет. Данные профиля лежат в:

- Linux: `~/.local/share/hhcli`
- Windows: `%LOCALAPPDATA%\hhcli`

## Первый запуск и настройка

#### 1. Авторизация

После установки запустите процесс аутентификации. Вам нужно будет придумать короткое имя для вашего профиля (go, python, pm, analyst и т.д).

```bash
hhcli --auth analyst
```
В системном браузере загрузится страница hh.ru для аутентификации на сайте. После успешного входа нужно запустить приложение.

#### 2. Запуск

Выполните команду:

```bash
hhcli
```

При первом запуске с несколькими резюме приложение предложит выбрать, какое из них использовать для поиска.

#### 3. Настройка

Вся настройка (ключевые слова для поиска, шаблон сопроводительного письма, внешний вид) производится внутри приложения. Нажмите клавишу `c` на любом из основных экранов, чтобы перейти в меню настроек.

## Использование

Основное взаимодействие с приложением происходит через TUI-интерфейс.

### Основные команды (CLI)

| Команда | Описание |
| :--- | :--- |
| `hhcli` | Запускает основной TUI-интерфейс. |
| `hhcli --auth <имя_профиля>` | Выполняет аутентификацию для нового профиля или обновляет токен авторизации для существующего. |
| `hhcli -v` / `hhcli --version` | Показывает текущую версию (из PyPI). |
| `hhcli -i` / `hhcli --info` | Выводит информацию о версии, пути к локальной базе и доступных профилях. |

### Горячие клавиши (внутри приложения)

| Клавиша | Действие |
| :--- | :--- |
| `Пробел` | Выбрать/снять выбор с текущей вакансии. |
| `A` | Откликнуться на все выбранные вакансии. |
| `H` | Открыть экран с историей откликов для текущего резюме. |
| `C` | Открыть экран настроек профиля. |
| `Q` / `Esc` | Вернуться на предыдущий экран или выйти из приложения. |
| `←` / `→` | Переключение между страницами в списке вакансий. |

## Темы оформления

У приложения есть своя дизайн-система для переключения тем оформления. Чтобы создать новую тему, скопируйте содержимое любого существующего файла `.tcss` из каталога `hhcli/ui/themes` в новый файл и настройте палитру. Новая тема будет доступна на экране настроек.

**Переменные стилей:** базовые токены отвечают за основные цвета темы (остальные значения собираются автоматически в `hhcli/ui/themes/design_system.tcss`):

- `background1` — основной фон приложения.
- `background2` — фон панелей, карточек, списков.
- `background3` — фон шапок, рамок и выделений.
- `foreground1` — вторичный текст (подписи, подсказки).
- `foreground2` — основной текст.
- `foreground3` — акцентный текст/заголовки.
- `primary` — главный акцент (кнопки, ссылки, выделения).
- `secondary` — дополнительный акцент и ховеры.
- `red`, `orange`, `yellow`, `green`, `blue`, `purple`, `magenta`, `cyan` — цвета статусов и вспомогательных подсветок.
- `scrim` — полупрозрачная подложка для модальных окон.

## TO DO

Дальнейшие планы:

- ~~Переработка первых двух экранов (были унаследованы от старой [bash-версии](https://github.com/fovendor/hhcli/tree/legacy))~~.
- ~~Интерактивное добавление профилей без ввода команды `hhcli --auth <profile>`~~.
- *Улучшение поддержки и тестирование на других ОС (macOS, ~~Windows~~)*.
- Расширение возможностей фильтрации и аналитики по истории откликов.
- Добавление экрана с дашбордом на основе истории откликов.
- ~~Добавление переписки с работодателями.~~
- Нотификация и уведомление о непрочитанных сообщениях работодателей.
- Добавление кастомизации сопроводительного письма для некоторых из выбранных вакансий.

## Предыстория

Изначально hhcli не планировался как большой и долго поддерживаемый проект. Но текущая ситуация на рынке труда: глупые алгоритмы отбора, фейковые вакансии, некомпетентные HR'ы и в целом низкая эффективность ручного поиска и откликов через сайт мотивируют меня развивать этот инструмент дальше.

Прежняя версия hhcli делегировала практически всю работу с API утилите [hh-applicant-tool](https://github.com/s3rgeym/hh-applicant-tool), отчасти поэтому была полностью переписана в текущее исполнение. Подробнее можно ознакомиться в ветке [legacy](https://github.com/fovendor/hhcli/tree/legacy). 

Legacy-версия перестала поддерживаться 26.10.2025, её дальнейшая работоспособность не гарантирована и полностью зависит от `hh-applicant-tool`.

## Лицензия

Проект распространяется под лицензией MIT. Смотрите файл `LICENSE` для подробностей.
