# Contributing to Sigma 🧙‍♂️

First off, thank you for considering contributing to Sigma! Your help is invaluable in keeping this project up-to-date and useful for the community.

The following guidelines will help you understand how to contribute effectively.

## 📝 Reporting False Positives Or Proposing New Detection Rule Ideas 🔎

If you find a false positive or would like to propose a new detection rule idea but do not have the time to create one, please create a new issue on the [GitHub repository](https://github.com/SigmaHQ/sigma/issues/new/choose) by selecting one of the available templates.

## 🛠️ Submitting Pull Requests (PRs)

1. Fork the [SigmaHQ repository](https://github.com/SigmaHQ/sigma) and clone your fork to your local machine.

2. Create a new branch for your changes:

```bash
git checkout -b your-feature-branch
```

3. Make your changes, and test them:

```bash
python tests/test_logsource.py
python tests/test_rules.py
```

4. Once the test is successful, commit the changes to your branch:

```bash
git add .
git commit -m "Your commit message"
```

5. Push your changes to your fork:

```bash
git push origin your-feature-branch
```

6. Create a new Pull Request (PR) against the upstream repository:

* Go to the [Sigma repository](https://github.com/SigmaHQ/sigma) on GitHub
* Click the "New Pull Request" button
* Choose your fork and your feature branch
* Add a clear and descriptive title and a detailed description of your changes
* Submit the Pull Request

## 📚 Adding or Updating Detection Rules

To update or contribute a new rule please make sure to follow the guidelines in the [SigmaHQ conventions documents](https://github.com/SigmaHQ/sigma-specification/blob/main/sigmahq). Consider installing the [VsCode Sigma Extension](https://marketplace.visualstudio.com/items?itemName=humpalum.sigma) for auto completion and quality of life features.

Thank you for contributing to Sigma! 🧙‍♂️
