# SNAKE Malware

## Summary

On may 9th 2023 CISA published a report detailing their investigations and analysis of the SNAKE malware that they attribute to the FSB. Here is a quick excerpt from the report.

> The Snake implant is considered the most sophisticated cyber espionage tool designed and used by Center 16 of Russia’s Federal Security Service (FSB) for long-term intelligence collection on sensitive targets. To conduct operations using this tool, the FSB created a covert peer-to-peer (P2P) network of numerous Snake-infected computers worldwide. Many systems in this P2P network serve as relay nodes which route disguised operational traffic to and from Snake implants on the FSB’s ultimate targets. Snake’s custom communications protocols employ encryption and fragmentation for confidentiality and are designed to hamper detection and collection efforts

You can find more information on the threat in the following articles:

- [Hunting Russian Intelligence “Snake” Malware](https://media.defense.gov/2023/May/09/2003218554/-1/-1/0/JOINT_CSA_HUNTING_RU_INTEL_SNAKE_MALWARE_20230509.PDF)

## Rules

- [SNAKE Malware Kernel Driver File Indicator](./file_event_win_malware_snake_encrypted_payload_ioc.yml)
- [SNAKE Malware Installer Name Indicators](./file_event_win_malware_snake_installers_ioc.yml)
- [SNAKE Malware WerFault Persistence File Creation](./file_event_win_malware_snake_werfault_creation.yml)
- [Potential SNAKE Malware Installation CLI Arguments Indicator](./proc_creation_win_malware_snake_installer_cli_args.yml)
- [Potential SNAKE Malware Installation Binary Indicator](./proc_creation_win_malware_snake_installer_exec.yml)
- [Potential SNAKE Malware Persistence Service Execution](./proc_creation_win_malware_snake_service_execution.yml)
- [SNAKE Malware Covert Store Registry Key](./registry_set_malware_snake_covert_store_key.yml)
- [Potential Encrypted Registry Blob Related To SNAKE Malware](./registry_set_malware_snake_encrypted_key.yml)
- [SNAKE Malware Service Persistence](./win_system_malware_snake_persistence_service.yml)
