# Kapeka backdoor

Kapeka has been used in assaults against people in Eastern Europe since at least the middle of 2022. Microsoft originally identified the [Kapeka backdoor](https://www.securityweek.com/kapeka-a-new-backdoor-in-sandworms-arsenal-of-aggression/). In a brief explanation released on February 14, 2024, Microsoft referred to this new backdoor as "KnuckleTouch" and linked it to a threat actor organization known as SeaShell Blizzard, which is also the name of the notorious Sandworm gang.

However, it is the security firm [WithSecure](https://labs.withsecure.com/publications/kapeka) that has conducted an in-depth analysis of Kapeka. WithSecure believes that KnuckleTouch is indeed the same as Kapeka. Their assessment suggests that Kapeka is a tool used by an APT (Advanced Persistent Threat) group. 

Despite limited public knowledge about Kapeka, WithSecure has identified its use in specific incidents, particularly in regions like Estonia and Ukraine. Kapeka’s stealth mechanisms allow it to maintain persistence and evade detection. If successfully delivered, it can serve as a powerful tool for long-term cyberespionage.

## Rules

- [Potential Kapeka Decrypted Backdoor Indicator](./file_event_win_malware_kapeka_backdoor_indicators.yml)
- [Kapeka Backdoor Loaded Via Rundll32.EXE](./image_load_malware_kapeka_backdoor_wll.yml)
- [Kapeka Backdoor Persistence Activity](./proc_creation_win_malware_kapeka_backdoor_persistence.yml)
- [Kapeka Backdoor Execution Via RunDLL32.EXE](./proc_creation_win_malware_kapeka_backdoor_rundll32_execution.yml)
- [Kapeka Backdoor Autorun Persistence](./registry_set_malware_kapeka_backdoor_autorun_persistence.yml)
- [Kapeka Backdoor Configuration Persistence](./registry_set_malware_kapeka_backdoor_configuration.yml)
- [Kapeka Backdoor Scheduled Task Creation](./win_security_malware_kapeka_backdoor_scheduled_task_creation.yml)
