#
# This file is part of Invenio.
# Copyright (C) 2016-2018 CERN.
#
# Invenio is free software; you can redistribute it and/or modify it
# under the terms of the MIT License; see LICENSE file for more details.

"""Create collections tables."""

import sqlalchemy as sa
from alembic import op
from sqlalchemy_utils import UUIDType

# revision identifiers, used by Alembic.
revision = "425b691f768b"
down_revision = "1748509182"
branch_labels = ()
depends_on = None


def upgrade():
    """Upgrade database."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "collections_collection_tree",
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("updated", sa.DateTime(), nullable=False),
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("community_id", UUIDType(), nullable=True),
        sa.Column("title", sa.String(length=255), nullable=False),
        sa.Column("order", sa.Integer(), nullable=True),
        sa.Column("slug", sa.String(length=255), nullable=False),
        sa.ForeignKeyConstraint(
            ["community_id"],
            ["communities_metadata.id"],
            name=op.f(
                "fk_collections_collection_tree_community_id_communities_metadata"
            ),
            ondelete="SET NULL",
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_collections_collection_tree")),
        sa.UniqueConstraint(
            "slug",
            "community_id",
            name="uq_collections_collection_tree_slug_community_id",
        ),
    )
    op.create_index(
        op.f("ix_collections_collection_tree_community_id"),
        "collections_collection_tree",
        ["community_id"],
        unique=False,
    )

    op.create_table(
        "collections_collection",
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("updated", sa.DateTime(), nullable=False),
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("slug", sa.String(length=255), nullable=False),
        sa.Column("path", sa.Text(), nullable=False),
        sa.Column("tree_id", sa.Integer(), nullable=False),
        sa.Column("title", sa.String(length=255), nullable=False),
        sa.Column("query", sa.Text(), nullable=False),
        sa.Column("order", sa.Integer(), nullable=True),
        sa.Column("depth", sa.Integer(), nullable=True),
        sa.Column("num_records", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["tree_id"],
            ["collections_collection_tree.id"],
            name=op.f("fk_collections_collection_tree_id_collections_collection_tree"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_collections_collection")),
        sa.UniqueConstraint(
            "slug", "tree_id", name="uq_collections_collection_slug_tree_id"
        ),
    )
    op.create_index(
        op.f("ix_collections_collection_path"),
        "collections_collection",
        ["path"],
        unique=False,
    )


def downgrade():
    """Downgrade database."""
    op.drop_index(
        op.f("ix_collections_collection_path"), table_name="collections_collection"
    )
    op.drop_table("collections_collection")
    op.drop_index(
        op.f("ix_collections_collection_tree_community_id"),
        table_name="collections_collection_tree",
    )
    op.drop_table("collections_collection_tree")
