//! python open mode strings
//!
//! NOTE:
//!
//! Everything in this module is a huge POS and I hate it.... most of it was
//! generated by me in ipython/vim/sed
//!
use pyo3::prelude::*;
use std::str::FromStr;

trait OpenOptionsLike {
    fn append(&self) -> bool;
    fn create(&self) -> bool;
    fn create_new(&self) -> bool;
    fn read(&self) -> bool;
    fn truncate(&self) -> bool;
    fn write(&self) -> bool;
}

#[derive(Debug, Clone, Copy)]
#[expect(clippy::struct_excessive_bools)]
pub(crate) struct PyOpenOptions {
    pub append: bool,
    pub create: bool,
    pub create_new: bool,
    pub read: bool,
    pub truncate: bool,
    pub write: bool,
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq)]
pub enum PyOpenMode {
    AppendBinary,
    AppendBinaryPlus,
    AppendText,
    AppendTextPlus,
    #[default]
    ReadBinary,
    ReadBinaryPlus,
    ReadText,
    ReadTextPlus,
    WriteBinary,
    WriteBinaryPlus,
    WriteText,
    WriteTextPlus,
    ExclusiveBinary,
    ExclusiveBinaryPlus,
    ExclusiveText,
    ExclusiveTextPlus,
}

impl PyOpenMode {
    pub fn is_binary(self) -> bool {
        matches!(
            self,
            Self::AppendBinary
                | Self::AppendBinaryPlus
                | Self::ReadBinary
                | Self::ReadBinaryPlus
                | Self::WriteBinary
                | Self::WriteBinaryPlus
                | Self::ExclusiveBinary
                | Self::ExclusiveBinaryPlus
        )
    }
}

impl OpenOptionsLike for PyOpenMode {
    fn append(&self) -> bool {
        matches!(
            self,
            Self::AppendBinary | Self::AppendBinaryPlus | Self::AppendText | Self::AppendTextPlus
        )
    }

    fn create(&self) -> bool {
        matches!(
            self,
            Self::AppendBinary
                | Self::AppendBinaryPlus
                | Self::AppendText
                | Self::AppendTextPlus
                | Self::WriteBinary
                | Self::WriteBinaryPlus
                | Self::WriteText
                | Self::WriteTextPlus
        )
    }

    fn create_new(&self) -> bool {
        matches!(
            self,
            Self::ExclusiveBinary
                | Self::ExclusiveBinaryPlus
                | Self::ExclusiveText
                | Self::ExclusiveTextPlus
        )
    }

    fn read(&self) -> bool {
        matches!(
            self,
            Self::AppendBinaryPlus
                | Self::AppendTextPlus
                | Self::ReadBinary
                | Self::ReadBinaryPlus
                | Self::ReadText
                | Self::ReadTextPlus
                | Self::WriteBinaryPlus
                | Self::WriteTextPlus
                | Self::ExclusiveBinaryPlus
                | Self::ExclusiveTextPlus
        )
    }

    fn truncate(&self) -> bool {
        matches!(
            self,
            Self::WriteBinary | Self::WriteBinaryPlus | Self::WriteText | Self::WriteTextPlus
        )
    }

    fn write(&self) -> bool {
        matches!(
            self,
            Self::AppendBinary
                | Self::AppendBinaryPlus
                | Self::AppendText
                | Self::AppendTextPlus
                | Self::ReadBinaryPlus
                | Self::ReadTextPlus
                | Self::WriteBinary
                | Self::WriteBinaryPlus
                | Self::WriteText
                | Self::WriteTextPlus
                | Self::ExclusiveBinary
                | Self::ExclusiveBinaryPlus
                | Self::ExclusiveText
                | Self::ExclusiveTextPlus
        )
    }
}

impl std::fmt::Display for PyOpenMode {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let s = match self {
            Self::AppendBinary => "ab",
            Self::AppendBinaryPlus => "ab+",
            Self::AppendText => "at",
            Self::AppendTextPlus => "at+",
            Self::ReadBinary => "rb",
            Self::ReadBinaryPlus => "rb+",
            Self::ReadText => "rt",
            Self::ReadTextPlus => "rt+",
            Self::WriteBinary => "wb",
            Self::WriteBinaryPlus => "wb+",
            Self::WriteText => "wt",
            Self::WriteTextPlus => "wt+",
            Self::ExclusiveBinary => "xb",
            Self::ExclusiveBinaryPlus => "xb+",
            Self::ExclusiveText => "xt",
            Self::ExclusiveTextPlus => "xt+",
        };
        write!(f, "{s}")
    }
}

const ERR_INVALID_PYTHON_OPEN_MODE: &str = "Invalid python open mode string; valid modes are: ab, ab+, at, at+, rb, rb+, rt, rt+, wb, wb+, wt, wt+, xb, xb+, xt, xt+";
impl FromStr for PyOpenMode {
    type Err = &'static str;

    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match canonical_open_mode(s) {
            Some("ab") => Ok(Self::AppendBinary),
            Some("ab+") => Ok(Self::AppendBinaryPlus),
            Some("at") => Ok(Self::AppendText),
            Some("at+") => Ok(Self::AppendTextPlus),
            Some("rb") => Ok(Self::ReadBinary),
            Some("rb+") => Ok(Self::ReadBinaryPlus),
            Some("rt") => Ok(Self::ReadText),
            Some("rt+") => Ok(Self::ReadTextPlus),
            Some("wb") => Ok(Self::WriteBinary),
            Some("wb+") => Ok(Self::WriteBinaryPlus),
            Some("wt") => Ok(Self::WriteText),
            Some("wt+") => Ok(Self::WriteTextPlus),
            Some("xb") => Ok(Self::ExclusiveBinary),
            Some("xb+") => Ok(Self::ExclusiveBinaryPlus),
            Some("xt") => Ok(Self::ExclusiveText),
            Some("xt+") => Ok(Self::ExclusiveTextPlus),
            _ => Err(ERR_INVALID_PYTHON_OPEN_MODE),
        }
    }
}

// #[rustfmt::skip]
// pub(crate) fn canonical_open_mode(s: &str) -> bool {
//     matches!(
//         s,
//         "ab" | "ab+" | "at" | "at+" |
//         "rb" | "rb+" | "rt" | "rt+" |
//         "wb" | "wb+" | "wt" | "wt+" |
//         "xb" | "xb+" | "xt" | "xt+"
//     )
// }

pub(super) fn canonical_open_mode(s: &str) -> Option<&'static str> {
    match s {
        "ab" | "ba" => Some("ab"),
        "+ab" | "+ba" | "a+b" | "ab+" | "b+a" | "ba+" => Some("ab+"),
        "+a" | "a" | "a+" | "at" | "ta" => Some("at"),
        "+at" | "+ta" | "a+t" | "at+" | "t+a" | "ta+" => Some("at+"),
        "br" | "rb" => Some("rb"),
        "+br" | "+rb" | "b+r" | "br+" | "r+b" | "rb+" => Some("rb+"),
        "r" | "rt" | "tr" => Some("rt"),
        "+r" | "+rt" | "+tr" | "r+" | "r+t" | "rt+" | "t+r" | "tr+" => Some("rt+"),
        "bw" | "wb" => Some("wb"),
        "+bw" | "+wb" | "b+w" | "bw+" | "w+b" | "wb+" => Some("wb+"),
        "+w" | "tw" | "w" | "w+" | "wt" => Some("wt"),
        "+tw" | "+wt" | "t+w" | "tw+" | "w+t" | "wt+" => Some("wt+"),
        "bx" | "xb" => Some("xb"),
        "+bx" | "+xb" | "b+x" | "bx+" | "x+b" | "xb+" => Some("xb+"),
        "tx" | "x" | "xt" => Some("xt"),
        "+tx" | "+x" | "+xt" | "t+x" | "tx+" | "x+" | "x+t" | "xt+" => Some("xt+"),
        _ => None,
    }
}

impl FromPyObject<'_> for PyOpenMode {
    fn extract_bound(ob: &Bound<'_, PyAny>) -> PyResult<Self> {
        let s: &str = ob.extract()?;
        Self::from_str(s).map_err(PyErr::new::<pyo3::exceptions::PyValueError, _>)
    }
}

impl From<PyOpenMode> for PyOpenOptions {
    fn from(mode: PyOpenMode) -> Self {
        Self {
            append: mode.append(),
            create: mode.create(),
            create_new: mode.create_new(),
            read: mode.read(),
            truncate: mode.truncate(),
            write: mode.write(),
        }
    }
}
//
impl PyOpenOptions {
    pub(crate) fn apply_to(self, open: &mut tokio::fs::OpenOptions) {
        open.read(self.read);
        open.write(self.write);
        open.append(self.append);
        open.create(self.create);
        open.truncate(self.truncate);
        open.create_new(self.create_new);
    }
}
