* Guide
    * [Overview](index.md)
    * [Quickstart](quickstart.md)
    * [Installation](install.md)
    * Common Use Cases
        * [Batch Inference](use-case/batch-inference.md)
    * Working with Modalities
        * [Modalities](modalities/index.md)
        * [Custom Modalities](modalities/custom.md)
        * [URLs and Files](modalities/urls.md)
        * [Text](modalities/text.md)
        * [Images](modalities/images.md)
        * [Videos](modalities/videos.md)
        * [JSON and Nested Data](modalities/json.md)
    * Running Custom Python Code
        * [Custom Code](custom-code/index.md)
        * [User-Defined Functions (UDFs)](custom-code/udfs.md)
        * [Working with GPUs](custom-code/gpu.md)
        * [External APIs](custom-code/apis.md)
    * Models and Providers
        * [Overview](models/index.md)
    * Data Connectors
        * [Connectors](connectors/index.md)
        * [Custom Connectors](connectors/custom.md)
        * [AWS Glue](connectors/glue.md)
        * [AWS S3 Tables](connectors/s3tables.md)
        * [Apache Hudi](connectors/hudi.md)
        * [Apache Iceberg](connectors/iceberg.md)
        * [Azure Blob Store](connectors/azure.md)
        * [Delta Lake](connectors/delta_lake.md)
        * [Hugging Face Datasets](connectors/huggingface.md)
        * [S3](connectors/aws.md)
        * [SQL Databases](connectors/sql.md)
        * [Turbopuffer](connectors/turbopuffer.md)
        * [Unity Catalog (Databricks)](connectors/unity_catalog.md)
    * [Scaling Out and Deployment](distributed.md)
    * Optimization and Debugging
        * [Optimization](optimization/index.md)
        * [Architecture](optimization/architecture.md)
        * [Managing Memory Usage](optimization/memory.md)
        * [Partitioning](optimization/partitioning.md)
        * [Observability](optimization/observability.md)
    * [Benchmarks](benchmarks/index.md)
    * [Community <sup>↗</sup>](http://www.daft.ai/slack)
    * [Contributing](contributing-to-daft.md)
    * [Roadmap](roadmap.md)
    * [Release Notes <sup>↗</sup>](https://github.com/Eventual-Inc/Daft/releases)
    * [Usage Telemetry](telemetry.md)
* Examples
    * [Examples](examples/index.md)
    * [Web Text Deduplication](examples/minhash-dedupe.md)
    * [Document Processing](examples/document-processing.md)
    * [Audio Transcription](examples/audio-transcription.md)
    * [Generate Text Embeddings for Turbopuffer](examples/text-embeddings.md)
    * [Running LLMs on the Red Pajamas Dataset](examples/llms-red-pajamas.md)
    * [Generate Images from Text with Stable Diffusion](examples/image-generation.md)
    * [Querying Image Data](examples/querying-images.md)
    * [MNIST Digit Classification](examples/mnist.md)
    * [Window Functions](examples/window-functions.md)
* Python API
    * [Python API](api/index.md)
    * [AI](api/ai.md)
    * [I/O](api/io.md)
    * [DataFrame](api/dataframe.md)
    * [Expressions](api/expressions.md)
    * [Functions](api/functions/)
    * [User-Defined Functions](api/udf.md)
    * [Data Types](api/datatypes.md)
    * [Window](api/window.md)
    * [Sessions](api/sessions.md)
    * [Catalogs & Tables](api/catalogs_tables.md)
    * [Schema](api/schema.md)
    * [Aggregations](api/aggregations.md)
    * [Series](api/series.md)
    * [Spark Connect](api/spark_connect.md)
    * [Configuration](api/config.md)
    * [Miscellaneous](api/misc.md)
* SQL Reference
    * [SQL Reference](sql/index.md)
    * Statements
        * [SELECT](sql/statements/select.md)
        * [SHOW](sql/statements/show.md)
        * [USE](sql/statements/use.md)
    * [Data Types](sql/datatypes.md)
    * [Window Functions](sql/window_functions.md)

<!--
TODO
        * [Custom Connectors](connectors/custom.md)
        * [CSV](connectors/csv.md)
        * [Google Cloud Storage (GCS)](connectors/gcs.md)
        * [HTTP](connectors/http.md)
        * [JSON](connectors/json.md)
        * [Lance](connectors/lance.md)
        * [Parquet](connectors/parquet.md)
        * [Turbopuffer](connectors/turbopuffer.md)
        * [WARC (Web ARChive)](connectors/warc.md)
-->
