#![allow(clippy::derive_partial_eq_without_eq)]
#![allow(clippy::too_long_first_doc_paragraph)]
#![allow(clippy::large_enum_variant)]

// This file is @generated by prost-build.
/// StorageLevel for persisting Datasets/Tables.
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct StorageLevel {
    /// (Required) Whether the cache should use disk or not.
    #[prost(bool, tag = "1")]
    pub use_disk: bool,
    /// (Required) Whether the cache should use memory or not.
    #[prost(bool, tag = "2")]
    pub use_memory: bool,
    /// (Required) Whether the cache should use off-heap or not.
    #[prost(bool, tag = "3")]
    pub use_off_heap: bool,
    /// (Required) Whether the cached data is deserialized or not.
    #[prost(bool, tag = "4")]
    pub deserialized: bool,
    /// (Required) The number of replicas.
    #[prost(int32, tag = "5")]
    pub replication: i32,
}
/// ResourceInformation to hold information about a type of Resource.
/// The corresponding class is 'org.apache.spark.resource.ResourceInformation'
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ResourceInformation {
    /// (Required) The name of the resource
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
    /// (Required) An array of strings describing the addresses of the resource.
    #[prost(string, repeated, tag = "2")]
    pub addresses: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// An executor resource request.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ExecutorResourceRequest {
    /// (Required) resource name.
    #[prost(string, tag = "1")]
    pub resource_name: ::prost::alloc::string::String,
    /// (Required) resource amount requesting.
    #[prost(int64, tag = "2")]
    pub amount: i64,
    /// Optional script used to discover the resources.
    #[prost(string, optional, tag = "3")]
    pub discovery_script: ::core::option::Option<::prost::alloc::string::String>,
    /// Optional vendor, required for some cluster managers.
    #[prost(string, optional, tag = "4")]
    pub vendor: ::core::option::Option<::prost::alloc::string::String>,
}
/// A task resource request.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TaskResourceRequest {
    /// (Required) resource name.
    #[prost(string, tag = "1")]
    pub resource_name: ::prost::alloc::string::String,
    /// (Required) resource amount requesting as a double to support fractional
    /// resource requests.
    #[prost(double, tag = "2")]
    pub amount: f64,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ResourceProfile {
    /// (Optional) Resource requests for executors. Mapped from the resource name
    /// (e.g., cores, memory, CPU) to its specific request.
    #[prost(map = "string, message", tag = "1")]
    pub executor_resources:
        ::std::collections::HashMap<::prost::alloc::string::String, ExecutorResourceRequest>,
    /// (Optional) Resource requests for tasks. Mapped from the resource name
    /// (e.g., cores, memory, CPU) to its specific request.
    #[prost(map = "string, message", tag = "2")]
    pub task_resources:
        ::std::collections::HashMap<::prost::alloc::string::String, TaskResourceRequest>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Origin {
    /// (Required) Indicate the origin type.
    #[prost(oneof = "origin::Function", tags = "1")]
    pub function: ::core::option::Option<origin::Function>,
}
/// Nested message and enum types in `Origin`.
pub mod origin {
    /// (Required) Indicate the origin type.
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Function {
        #[prost(message, tag = "1")]
        PythonOrigin(super::PythonOrigin),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PythonOrigin {
    /// (Required) Name of the origin, for example, the name of the function
    #[prost(string, tag = "1")]
    pub fragment: ::prost::alloc::string::String,
    /// (Required) Callsite to show to end users, for example, stacktrace.
    #[prost(string, tag = "2")]
    pub call_site: ::prost::alloc::string::String,
}
/// This message describes the logical \[[DataType]\] of something. It does not carry the value
/// itself but only describes it.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DataType {
    #[prost(
        oneof = "data_type::Kind",
        tags = "1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 25, 23, 24"
    )]
    pub kind: ::core::option::Option<data_type::Kind>,
}
/// Nested message and enum types in `DataType`.
pub mod data_type {
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Boolean {
        #[prost(uint32, tag = "1")]
        pub type_variation_reference: u32,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Byte {
        #[prost(uint32, tag = "1")]
        pub type_variation_reference: u32,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Short {
        #[prost(uint32, tag = "1")]
        pub type_variation_reference: u32,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Integer {
        #[prost(uint32, tag = "1")]
        pub type_variation_reference: u32,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Long {
        #[prost(uint32, tag = "1")]
        pub type_variation_reference: u32,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Float {
        #[prost(uint32, tag = "1")]
        pub type_variation_reference: u32,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Double {
        #[prost(uint32, tag = "1")]
        pub type_variation_reference: u32,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct String {
        #[prost(uint32, tag = "1")]
        pub type_variation_reference: u32,
        #[prost(string, tag = "2")]
        pub collation: ::prost::alloc::string::String,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Binary {
        #[prost(uint32, tag = "1")]
        pub type_variation_reference: u32,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Null {
        #[prost(uint32, tag = "1")]
        pub type_variation_reference: u32,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Timestamp {
        #[prost(uint32, tag = "1")]
        pub type_variation_reference: u32,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Date {
        #[prost(uint32, tag = "1")]
        pub type_variation_reference: u32,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct TimestampNtz {
        #[prost(uint32, tag = "1")]
        pub type_variation_reference: u32,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct CalendarInterval {
        #[prost(uint32, tag = "1")]
        pub type_variation_reference: u32,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct YearMonthInterval {
        #[prost(int32, optional, tag = "1")]
        pub start_field: ::core::option::Option<i32>,
        #[prost(int32, optional, tag = "2")]
        pub end_field: ::core::option::Option<i32>,
        #[prost(uint32, tag = "3")]
        pub type_variation_reference: u32,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct DayTimeInterval {
        #[prost(int32, optional, tag = "1")]
        pub start_field: ::core::option::Option<i32>,
        #[prost(int32, optional, tag = "2")]
        pub end_field: ::core::option::Option<i32>,
        #[prost(uint32, tag = "3")]
        pub type_variation_reference: u32,
    }
    /// Start compound types.
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Char {
        #[prost(int32, tag = "1")]
        pub length: i32,
        #[prost(uint32, tag = "2")]
        pub type_variation_reference: u32,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct VarChar {
        #[prost(int32, tag = "1")]
        pub length: i32,
        #[prost(uint32, tag = "2")]
        pub type_variation_reference: u32,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Decimal {
        #[prost(int32, optional, tag = "1")]
        pub scale: ::core::option::Option<i32>,
        #[prost(int32, optional, tag = "2")]
        pub precision: ::core::option::Option<i32>,
        #[prost(uint32, tag = "3")]
        pub type_variation_reference: u32,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct StructField {
        #[prost(string, tag = "1")]
        pub name: ::prost::alloc::string::String,
        #[prost(message, optional, tag = "2")]
        pub data_type: ::core::option::Option<super::DataType>,
        #[prost(bool, tag = "3")]
        pub nullable: bool,
        #[prost(string, optional, tag = "4")]
        pub metadata: ::core::option::Option<::prost::alloc::string::String>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Struct {
        #[prost(message, repeated, tag = "1")]
        pub fields: ::prost::alloc::vec::Vec<StructField>,
        #[prost(uint32, tag = "2")]
        pub type_variation_reference: u32,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Array {
        #[prost(message, optional, boxed, tag = "1")]
        pub element_type: ::core::option::Option<::prost::alloc::boxed::Box<super::DataType>>,
        #[prost(bool, tag = "2")]
        pub contains_null: bool,
        #[prost(uint32, tag = "3")]
        pub type_variation_reference: u32,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Map {
        #[prost(message, optional, boxed, tag = "1")]
        pub key_type: ::core::option::Option<::prost::alloc::boxed::Box<super::DataType>>,
        #[prost(message, optional, boxed, tag = "2")]
        pub value_type: ::core::option::Option<::prost::alloc::boxed::Box<super::DataType>>,
        #[prost(bool, tag = "3")]
        pub value_contains_null: bool,
        #[prost(uint32, tag = "4")]
        pub type_variation_reference: u32,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Variant {
        #[prost(uint32, tag = "1")]
        pub type_variation_reference: u32,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Udt {
        #[prost(string, tag = "1")]
        pub r#type: ::prost::alloc::string::String,
        #[prost(string, optional, tag = "2")]
        pub jvm_class: ::core::option::Option<::prost::alloc::string::String>,
        #[prost(string, optional, tag = "3")]
        pub python_class: ::core::option::Option<::prost::alloc::string::String>,
        #[prost(string, optional, tag = "4")]
        pub serialized_python_class: ::core::option::Option<::prost::alloc::string::String>,
        #[prost(message, optional, boxed, tag = "5")]
        pub sql_type: ::core::option::Option<::prost::alloc::boxed::Box<super::DataType>>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Unparsed {
        /// (Required) The unparsed data type string
        #[prost(string, tag = "1")]
        pub data_type_string: ::prost::alloc::string::String,
    }
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Kind {
        #[prost(message, tag = "1")]
        Null(Null),
        #[prost(message, tag = "2")]
        Binary(Binary),
        #[prost(message, tag = "3")]
        Boolean(Boolean),
        /// Numeric types
        #[prost(message, tag = "4")]
        Byte(Byte),
        #[prost(message, tag = "5")]
        Short(Short),
        #[prost(message, tag = "6")]
        Integer(Integer),
        #[prost(message, tag = "7")]
        Long(Long),
        #[prost(message, tag = "8")]
        Float(Float),
        #[prost(message, tag = "9")]
        Double(Double),
        #[prost(message, tag = "10")]
        Decimal(Decimal),
        /// String types
        #[prost(message, tag = "11")]
        String(String),
        #[prost(message, tag = "12")]
        Char(Char),
        #[prost(message, tag = "13")]
        VarChar(VarChar),
        /// Datatime types
        #[prost(message, tag = "14")]
        Date(Date),
        #[prost(message, tag = "15")]
        Timestamp(Timestamp),
        #[prost(message, tag = "16")]
        TimestampNtz(TimestampNtz),
        /// Interval types
        #[prost(message, tag = "17")]
        CalendarInterval(CalendarInterval),
        #[prost(message, tag = "18")]
        YearMonthInterval(YearMonthInterval),
        #[prost(message, tag = "19")]
        DayTimeInterval(DayTimeInterval),
        /// Complex types
        #[prost(message, tag = "20")]
        Array(::prost::alloc::boxed::Box<Array>),
        #[prost(message, tag = "21")]
        Struct(Struct),
        #[prost(message, tag = "22")]
        Map(::prost::alloc::boxed::Box<Map>),
        #[prost(message, tag = "25")]
        Variant(Variant),
        /// UserDefinedType
        #[prost(message, tag = "23")]
        Udt(::prost::alloc::boxed::Box<Udt>),
        /// UnparsedDataType
        #[prost(message, tag = "24")]
        Unparsed(Unparsed),
    }
}
/// Expression used to refer to fields, functions and similar. This can be used everywhere
/// expressions in SQL appear.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Expression {
    #[prost(message, optional, tag = "18")]
    pub common: ::core::option::Option<ExpressionCommon>,
    #[prost(
        oneof = "expression::ExprType",
        tags = "1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 999"
    )]
    pub expr_type: ::core::option::Option<expression::ExprType>,
}
/// Nested message and enum types in `Expression`.
pub mod expression {
    /// Expression for the OVER clause or WINDOW clause.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Window {
        /// (Required) The window function.
        #[prost(message, optional, boxed, tag = "1")]
        pub window_function: ::core::option::Option<::prost::alloc::boxed::Box<super::Expression>>,
        /// (Optional) The way that input rows are partitioned.
        #[prost(message, repeated, tag = "2")]
        pub partition_spec: ::prost::alloc::vec::Vec<super::Expression>,
        /// (Optional) Ordering of rows in a partition.
        #[prost(message, repeated, tag = "3")]
        pub order_spec: ::prost::alloc::vec::Vec<SortOrder>,
        /// (Optional) Window frame in a partition.
        ///
        /// If not set, it will be treated as 'UnspecifiedFrame'.
        #[prost(message, optional, boxed, tag = "4")]
        pub frame_spec: ::core::option::Option<::prost::alloc::boxed::Box<window::WindowFrame>>,
    }
    /// Nested message and enum types in `Window`.
    pub mod window {
        /// The window frame
        #[derive(Clone, PartialEq, ::prost::Message)]
        pub struct WindowFrame {
            /// (Required) The type of the frame.
            #[prost(enumeration = "window_frame::FrameType", tag = "1")]
            pub frame_type: i32,
            /// (Required) The lower bound of the frame.
            #[prost(message, optional, boxed, tag = "2")]
            pub lower:
                ::core::option::Option<::prost::alloc::boxed::Box<window_frame::FrameBoundary>>,
            /// (Required) The upper bound of the frame.
            #[prost(message, optional, boxed, tag = "3")]
            pub upper:
                ::core::option::Option<::prost::alloc::boxed::Box<window_frame::FrameBoundary>>,
        }
        /// Nested message and enum types in `WindowFrame`.
        pub mod window_frame {
            #[derive(Clone, PartialEq, ::prost::Message)]
            pub struct FrameBoundary {
                #[prost(oneof = "frame_boundary::Boundary", tags = "1, 2, 3")]
                pub boundary: ::core::option::Option<frame_boundary::Boundary>,
            }
            /// Nested message and enum types in `FrameBoundary`.
            pub mod frame_boundary {
                #[derive(Clone, PartialEq, ::prost::Oneof)]
                pub enum Boundary {
                    /// CURRENT ROW boundary
                    #[prost(bool, tag = "1")]
                    CurrentRow(bool),
                    /// UNBOUNDED boundary.
                    /// For lower bound, it will be converted to 'UnboundedPreceding'.
                    /// for upper bound, it will be converted to 'UnboundedFollowing'.
                    #[prost(bool, tag = "2")]
                    Unbounded(bool),
                    /// This is an expression for future proofing. We are expecting literals on the server side.
                    #[prost(message, tag = "3")]
                    Value(::prost::alloc::boxed::Box<super::super::super::super::Expression>),
                }
            }
            #[derive(
                Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration,
            )]
            #[repr(i32)]
            pub enum FrameType {
                Undefined = 0,
                /// RowFrame treats rows in a partition individually.
                Row = 1,
                /// RangeFrame treats rows in a partition as groups of peers.
                /// All rows having the same 'ORDER BY' ordering are considered as peers.
                Range = 2,
            }
            impl FrameType {
                /// String value of the enum field names used in the ProtoBuf definition.
                ///
                /// The values are not transformed in any way and thus are considered stable
                /// (if the ProtoBuf definition does not change) and safe for programmatic use.
                pub fn as_str_name(&self) -> &'static str {
                    match self {
                        Self::Undefined => "FRAME_TYPE_UNDEFINED",
                        Self::Row => "FRAME_TYPE_ROW",
                        Self::Range => "FRAME_TYPE_RANGE",
                    }
                }
                /// Creates an enum from field names used in the ProtoBuf definition.
                pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
                    match value {
                        "FRAME_TYPE_UNDEFINED" => Some(Self::Undefined),
                        "FRAME_TYPE_ROW" => Some(Self::Row),
                        "FRAME_TYPE_RANGE" => Some(Self::Range),
                        _ => None,
                    }
                }
            }
        }
    }
    /// SortOrder is used to specify the  data ordering, it is normally used in Sort and Window.
    /// It is an unevaluable expression and cannot be evaluated, so can not be used in Projection.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct SortOrder {
        /// (Required) The expression to be sorted.
        #[prost(message, optional, boxed, tag = "1")]
        pub child: ::core::option::Option<::prost::alloc::boxed::Box<super::Expression>>,
        /// (Required) The sort direction, should be ASCENDING or DESCENDING.
        #[prost(enumeration = "sort_order::SortDirection", tag = "2")]
        pub direction: i32,
        /// (Required) How to deal with NULLs, should be NULLS_FIRST or NULLS_LAST.
        #[prost(enumeration = "sort_order::NullOrdering", tag = "3")]
        pub null_ordering: i32,
    }
    /// Nested message and enum types in `SortOrder`.
    pub mod sort_order {
        #[derive(
            Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration,
        )]
        #[repr(i32)]
        pub enum SortDirection {
            Unspecified = 0,
            Ascending = 1,
            Descending = 2,
        }
        impl SortDirection {
            /// String value of the enum field names used in the ProtoBuf definition.
            ///
            /// The values are not transformed in any way and thus are considered stable
            /// (if the ProtoBuf definition does not change) and safe for programmatic use.
            pub fn as_str_name(&self) -> &'static str {
                match self {
                    Self::Unspecified => "SORT_DIRECTION_UNSPECIFIED",
                    Self::Ascending => "SORT_DIRECTION_ASCENDING",
                    Self::Descending => "SORT_DIRECTION_DESCENDING",
                }
            }
            /// Creates an enum from field names used in the ProtoBuf definition.
            pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
                match value {
                    "SORT_DIRECTION_UNSPECIFIED" => Some(Self::Unspecified),
                    "SORT_DIRECTION_ASCENDING" => Some(Self::Ascending),
                    "SORT_DIRECTION_DESCENDING" => Some(Self::Descending),
                    _ => None,
                }
            }
        }
        #[derive(
            Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration,
        )]
        #[repr(i32)]
        pub enum NullOrdering {
            SortNullsUnspecified = 0,
            SortNullsFirst = 1,
            SortNullsLast = 2,
        }
        impl NullOrdering {
            /// String value of the enum field names used in the ProtoBuf definition.
            ///
            /// The values are not transformed in any way and thus are considered stable
            /// (if the ProtoBuf definition does not change) and safe for programmatic use.
            pub fn as_str_name(&self) -> &'static str {
                match self {
                    Self::SortNullsUnspecified => "SORT_NULLS_UNSPECIFIED",
                    Self::SortNullsFirst => "SORT_NULLS_FIRST",
                    Self::SortNullsLast => "SORT_NULLS_LAST",
                }
            }
            /// Creates an enum from field names used in the ProtoBuf definition.
            pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
                match value {
                    "SORT_NULLS_UNSPECIFIED" => Some(Self::SortNullsUnspecified),
                    "SORT_NULLS_FIRST" => Some(Self::SortNullsFirst),
                    "SORT_NULLS_LAST" => Some(Self::SortNullsLast),
                    _ => None,
                }
            }
        }
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Cast {
        /// (Required) the expression to be casted.
        #[prost(message, optional, boxed, tag = "1")]
        pub expr: ::core::option::Option<::prost::alloc::boxed::Box<super::Expression>>,
        /// (Optional) The expression evaluation mode.
        #[prost(enumeration = "cast::EvalMode", tag = "4")]
        pub eval_mode: i32,
        /// (Required) the data type that the expr to be casted to.
        #[prost(oneof = "cast::CastToType", tags = "2, 3")]
        pub cast_to_type: ::core::option::Option<cast::CastToType>,
    }
    /// Nested message and enum types in `Cast`.
    pub mod cast {
        #[derive(
            Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration,
        )]
        #[repr(i32)]
        pub enum EvalMode {
            Unspecified = 0,
            Legacy = 1,
            Ansi = 2,
            Try = 3,
        }
        impl EvalMode {
            /// String value of the enum field names used in the ProtoBuf definition.
            ///
            /// The values are not transformed in any way and thus are considered stable
            /// (if the ProtoBuf definition does not change) and safe for programmatic use.
            pub fn as_str_name(&self) -> &'static str {
                match self {
                    Self::Unspecified => "EVAL_MODE_UNSPECIFIED",
                    Self::Legacy => "EVAL_MODE_LEGACY",
                    Self::Ansi => "EVAL_MODE_ANSI",
                    Self::Try => "EVAL_MODE_TRY",
                }
            }
            /// Creates an enum from field names used in the ProtoBuf definition.
            pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
                match value {
                    "EVAL_MODE_UNSPECIFIED" => Some(Self::Unspecified),
                    "EVAL_MODE_LEGACY" => Some(Self::Legacy),
                    "EVAL_MODE_ANSI" => Some(Self::Ansi),
                    "EVAL_MODE_TRY" => Some(Self::Try),
                    _ => None,
                }
            }
        }
        /// (Required) the data type that the expr to be casted to.
        #[derive(Clone, PartialEq, ::prost::Oneof)]
        pub enum CastToType {
            #[prost(message, tag = "2")]
            Type(super::super::DataType),
            /// If this is set, Server will use Catalyst parser to parse this string to DataType.
            #[prost(string, tag = "3")]
            TypeStr(::prost::alloc::string::String),
        }
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Literal {
        #[prost(
            oneof = "literal::LiteralType",
            tags = "1, 2, 3, 4, 5, 6, 7, 10, 11, 12, 13, 16, 17, 18, 19, 20, 21, 22, 23, 24"
        )]
        pub literal_type: ::core::option::Option<literal::LiteralType>,
    }
    /// Nested message and enum types in `Literal`.
    pub mod literal {
        #[derive(Clone, PartialEq, ::prost::Message)]
        pub struct Decimal {
            /// the string representation.
            #[prost(string, tag = "1")]
            pub value: ::prost::alloc::string::String,
            /// The maximum number of digits allowed in the value.
            /// the maximum precision is 38.
            #[prost(int32, optional, tag = "2")]
            pub precision: ::core::option::Option<i32>,
            /// declared scale of decimal literal
            #[prost(int32, optional, tag = "3")]
            pub scale: ::core::option::Option<i32>,
        }
        #[derive(Clone, Copy, PartialEq, ::prost::Message)]
        pub struct CalendarInterval {
            #[prost(int32, tag = "1")]
            pub months: i32,
            #[prost(int32, tag = "2")]
            pub days: i32,
            #[prost(int64, tag = "3")]
            pub microseconds: i64,
        }
        #[derive(Clone, PartialEq, ::prost::Message)]
        pub struct Array {
            #[prost(message, optional, tag = "1")]
            pub element_type: ::core::option::Option<super::super::DataType>,
            #[prost(message, repeated, tag = "2")]
            pub elements: ::prost::alloc::vec::Vec<super::Literal>,
        }
        #[derive(Clone, PartialEq, ::prost::Message)]
        pub struct Map {
            #[prost(message, optional, tag = "1")]
            pub key_type: ::core::option::Option<super::super::DataType>,
            #[prost(message, optional, tag = "2")]
            pub value_type: ::core::option::Option<super::super::DataType>,
            #[prost(message, repeated, tag = "3")]
            pub keys: ::prost::alloc::vec::Vec<super::Literal>,
            #[prost(message, repeated, tag = "4")]
            pub values: ::prost::alloc::vec::Vec<super::Literal>,
        }
        #[derive(Clone, PartialEq, ::prost::Message)]
        pub struct Struct {
            #[prost(message, optional, tag = "1")]
            pub struct_type: ::core::option::Option<super::super::DataType>,
            #[prost(message, repeated, tag = "2")]
            pub elements: ::prost::alloc::vec::Vec<super::Literal>,
        }
        #[derive(Clone, PartialEq, ::prost::Oneof)]
        pub enum LiteralType {
            #[prost(message, tag = "1")]
            Null(super::super::DataType),
            #[prost(bytes, tag = "2")]
            Binary(::prost::alloc::vec::Vec<u8>),
            #[prost(bool, tag = "3")]
            Boolean(bool),
            #[prost(int32, tag = "4")]
            Byte(i32),
            #[prost(int32, tag = "5")]
            Short(i32),
            #[prost(int32, tag = "6")]
            Integer(i32),
            #[prost(int64, tag = "7")]
            Long(i64),
            #[prost(float, tag = "10")]
            Float(f32),
            #[prost(double, tag = "11")]
            Double(f64),
            #[prost(message, tag = "12")]
            Decimal(Decimal),
            #[prost(string, tag = "13")]
            String(::prost::alloc::string::String),
            /// Date in units of days since the UNIX epoch.
            #[prost(int32, tag = "16")]
            Date(i32),
            /// Timestamp in units of microseconds since the UNIX epoch.
            #[prost(int64, tag = "17")]
            Timestamp(i64),
            /// Timestamp in units of microseconds since the UNIX epoch (without timezone information).
            #[prost(int64, tag = "18")]
            TimestampNtz(i64),
            #[prost(message, tag = "19")]
            CalendarInterval(CalendarInterval),
            #[prost(int32, tag = "20")]
            YearMonthInterval(i32),
            #[prost(int64, tag = "21")]
            DayTimeInterval(i64),
            #[prost(message, tag = "22")]
            Array(Array),
            #[prost(message, tag = "23")]
            Map(Map),
            #[prost(message, tag = "24")]
            Struct(Struct),
        }
    }
    /// An unresolved attribute that is not explicitly bound to a specific column, but the column
    /// is resolved during analysis by name.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct UnresolvedAttribute {
        /// (Required) An identifier that will be parsed by Catalyst parser. This should follow the
        /// Spark SQL identifier syntax.
        #[prost(string, tag = "1")]
        pub unparsed_identifier: ::prost::alloc::string::String,
        /// (Optional) The id of corresponding connect plan.
        #[prost(int64, optional, tag = "2")]
        pub plan_id: ::core::option::Option<i64>,
        /// (Optional) The requested column is a metadata column.
        #[prost(bool, optional, tag = "3")]
        pub is_metadata_column: ::core::option::Option<bool>,
    }
    /// An unresolved function is not explicitly bound to one explicit function, but the function
    /// is resolved during analysis following Sparks name resolution rules.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct UnresolvedFunction {
        /// (Required) name (or unparsed name for user defined function) for the unresolved function.
        #[prost(string, tag = "1")]
        pub function_name: ::prost::alloc::string::String,
        /// (Optional) Function arguments. Empty arguments are allowed.
        #[prost(message, repeated, tag = "2")]
        pub arguments: ::prost::alloc::vec::Vec<super::Expression>,
        /// (Required) Indicate if this function should be applied on distinct values.
        #[prost(bool, tag = "3")]
        pub is_distinct: bool,
        /// (Required) Indicate if this is a user defined function.
        ///
        /// When it is not a user defined function, Connect will use the function name directly.
        /// When it is a user defined function, Connect will parse the function name first.
        #[prost(bool, tag = "4")]
        pub is_user_defined_function: bool,
    }
    /// Expression as string.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ExpressionString {
        /// (Required) A SQL expression that will be parsed by Catalyst parser.
        #[prost(string, tag = "1")]
        pub expression: ::prost::alloc::string::String,
    }
    /// UnresolvedStar is used to expand all the fields of a relation or struct.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct UnresolvedStar {
        /// (Optional) The target of the expansion.
        ///
        /// If set, it should end with '.*' and will be parsed by 'parseAttributeName'
        /// in the server side.
        #[prost(string, optional, tag = "1")]
        pub unparsed_target: ::core::option::Option<::prost::alloc::string::String>,
        /// (Optional) The id of corresponding connect plan.
        #[prost(int64, optional, tag = "2")]
        pub plan_id: ::core::option::Option<i64>,
    }
    /// Represents all of the input attributes to a given relational operator, for example in
    /// "SELECT `(id)?+.+` FROM ...".
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct UnresolvedRegex {
        /// (Required) The column name used to extract column with regex.
        #[prost(string, tag = "1")]
        pub col_name: ::prost::alloc::string::String,
        /// (Optional) The id of corresponding connect plan.
        #[prost(int64, optional, tag = "2")]
        pub plan_id: ::core::option::Option<i64>,
    }
    /// Extracts a value or values from an Expression
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct UnresolvedExtractValue {
        /// (Required) The expression to extract value from, can be
        /// Map, Array, Struct or array of Structs.
        #[prost(message, optional, boxed, tag = "1")]
        pub child: ::core::option::Option<::prost::alloc::boxed::Box<super::Expression>>,
        /// (Required) The expression to describe the extraction, can be
        /// key of Map, index of Array, field name of Struct.
        #[prost(message, optional, boxed, tag = "2")]
        pub extraction: ::core::option::Option<::prost::alloc::boxed::Box<super::Expression>>,
    }
    /// Add, replace or drop a field of `StructType` expression by name.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct UpdateFields {
        /// (Required) The struct expression.
        #[prost(message, optional, boxed, tag = "1")]
        pub struct_expression:
            ::core::option::Option<::prost::alloc::boxed::Box<super::Expression>>,
        /// (Required) The field name.
        #[prost(string, tag = "2")]
        pub field_name: ::prost::alloc::string::String,
        /// (Optional) The expression to add or replace.
        ///
        /// When not set, it means this field will be dropped.
        #[prost(message, optional, boxed, tag = "3")]
        pub value_expression: ::core::option::Option<::prost::alloc::boxed::Box<super::Expression>>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Alias {
        /// (Required) The expression that alias will be added on.
        #[prost(message, optional, boxed, tag = "1")]
        pub expr: ::core::option::Option<::prost::alloc::boxed::Box<super::Expression>>,
        /// (Required) a list of name parts for the alias.
        ///
        /// Scalar columns only has one name that presents.
        #[prost(string, repeated, tag = "2")]
        pub name: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
        /// (Optional) Alias metadata expressed as a JSON map.
        #[prost(string, optional, tag = "3")]
        pub metadata: ::core::option::Option<::prost::alloc::string::String>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct LambdaFunction {
        /// (Required) The lambda function.
        ///
        /// The function body should use 'UnresolvedAttribute' as arguments, the sever side will
        /// replace 'UnresolvedAttribute' with 'UnresolvedNamedLambdaVariable'.
        #[prost(message, optional, boxed, tag = "1")]
        pub function: ::core::option::Option<::prost::alloc::boxed::Box<super::Expression>>,
        /// (Required) Function variables. Must contains 1 ~ 3 variables.
        #[prost(message, repeated, tag = "2")]
        pub arguments: ::prost::alloc::vec::Vec<UnresolvedNamedLambdaVariable>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct UnresolvedNamedLambdaVariable {
        /// (Required) a list of name parts for the variable. Must not be empty.
        #[prost(string, repeated, tag = "1")]
        pub name_parts: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    }
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum ExprType {
        #[prost(message, tag = "1")]
        Literal(Literal),
        #[prost(message, tag = "2")]
        UnresolvedAttribute(UnresolvedAttribute),
        #[prost(message, tag = "3")]
        UnresolvedFunction(UnresolvedFunction),
        #[prost(message, tag = "4")]
        ExpressionString(ExpressionString),
        #[prost(message, tag = "5")]
        UnresolvedStar(UnresolvedStar),
        #[prost(message, tag = "6")]
        Alias(::prost::alloc::boxed::Box<Alias>),
        #[prost(message, tag = "7")]
        Cast(::prost::alloc::boxed::Box<Cast>),
        #[prost(message, tag = "8")]
        UnresolvedRegex(UnresolvedRegex),
        #[prost(message, tag = "9")]
        SortOrder(::prost::alloc::boxed::Box<SortOrder>),
        #[prost(message, tag = "10")]
        LambdaFunction(::prost::alloc::boxed::Box<LambdaFunction>),
        #[prost(message, tag = "11")]
        Window(::prost::alloc::boxed::Box<Window>),
        #[prost(message, tag = "12")]
        UnresolvedExtractValue(::prost::alloc::boxed::Box<UnresolvedExtractValue>),
        #[prost(message, tag = "13")]
        UpdateFields(::prost::alloc::boxed::Box<UpdateFields>),
        #[prost(message, tag = "14")]
        UnresolvedNamedLambdaVariable(UnresolvedNamedLambdaVariable),
        #[prost(message, tag = "15")]
        CommonInlineUserDefinedFunction(super::CommonInlineUserDefinedFunction),
        #[prost(message, tag = "16")]
        CallFunction(super::CallFunction),
        #[prost(message, tag = "17")]
        NamedArgumentExpression(::prost::alloc::boxed::Box<super::NamedArgumentExpression>),
        #[prost(message, tag = "19")]
        MergeAction(::prost::alloc::boxed::Box<super::MergeAction>),
        #[prost(message, tag = "20")]
        TypedAggregateExpression(super::TypedAggregateExpression),
        /// This field is used to mark extensions to the protocol. When plugins generate arbitrary
        /// relations they can add them here. During the planning the correct resolution is done.
        #[prost(message, tag = "999")]
        Extension(::prost_types::Any),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ExpressionCommon {
    /// (Required) Keep the information of the origin for this expression such as stacktrace.
    #[prost(message, optional, tag = "1")]
    pub origin: ::core::option::Option<Origin>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CommonInlineUserDefinedFunction {
    /// (Required) Name of the user-defined function.
    #[prost(string, tag = "1")]
    pub function_name: ::prost::alloc::string::String,
    /// (Optional) Indicate if the user-defined function is deterministic.
    #[prost(bool, tag = "2")]
    pub deterministic: bool,
    /// (Optional) Function arguments. Empty arguments are allowed.
    #[prost(message, repeated, tag = "3")]
    pub arguments: ::prost::alloc::vec::Vec<Expression>,
    /// (Required) Indicate the function type of the user-defined function.
    #[prost(
        oneof = "common_inline_user_defined_function::Function",
        tags = "4, 5, 6"
    )]
    pub function: ::core::option::Option<common_inline_user_defined_function::Function>,
}
/// Nested message and enum types in `CommonInlineUserDefinedFunction`.
pub mod common_inline_user_defined_function {
    /// (Required) Indicate the function type of the user-defined function.
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Function {
        #[prost(message, tag = "4")]
        PythonUdf(super::PythonUdf),
        #[prost(message, tag = "5")]
        ScalarScalaUdf(super::ScalarScalaUdf),
        #[prost(message, tag = "6")]
        JavaUdf(super::JavaUdf),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PythonUdf {
    /// (Required) Output type of the Python UDF
    #[prost(message, optional, tag = "1")]
    pub output_type: ::core::option::Option<DataType>,
    /// (Required) EvalType of the Python UDF
    #[prost(int32, tag = "2")]
    pub eval_type: i32,
    /// (Required) The encoded commands of the Python UDF
    #[prost(bytes = "vec", tag = "3")]
    pub command: ::prost::alloc::vec::Vec<u8>,
    /// (Required) Python version being used in the client.
    #[prost(string, tag = "4")]
    pub python_ver: ::prost::alloc::string::String,
    /// (Optional) Additional includes for the Python UDF.
    #[prost(string, repeated, tag = "5")]
    pub additional_includes: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ScalarScalaUdf {
    /// (Required) Serialized JVM object containing UDF definition, input encoders and output encoder
    #[prost(bytes = "vec", tag = "1")]
    pub payload: ::prost::alloc::vec::Vec<u8>,
    /// (Optional) Input type(s) of the UDF
    #[prost(message, repeated, tag = "2")]
    pub input_types: ::prost::alloc::vec::Vec<DataType>,
    /// (Required) Output type of the UDF
    #[prost(message, optional, tag = "3")]
    pub output_type: ::core::option::Option<DataType>,
    /// (Required) True if the UDF can return null value
    #[prost(bool, tag = "4")]
    pub nullable: bool,
    /// (Required) Indicate if the UDF is an aggregate function
    #[prost(bool, tag = "5")]
    pub aggregate: bool,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct JavaUdf {
    /// (Required) Fully qualified name of Java class
    #[prost(string, tag = "1")]
    pub class_name: ::prost::alloc::string::String,
    /// (Optional) Output type of the Java UDF
    #[prost(message, optional, tag = "2")]
    pub output_type: ::core::option::Option<DataType>,
    /// (Required) Indicate if the Java user-defined function is an aggregate function
    #[prost(bool, tag = "3")]
    pub aggregate: bool,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TypedAggregateExpression {
    /// (Required) The aggregate function object packed into bytes.
    #[prost(message, optional, tag = "1")]
    pub scalar_scala_udf: ::core::option::Option<ScalarScalaUdf>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CallFunction {
    /// (Required) Unparsed name of the SQL function.
    #[prost(string, tag = "1")]
    pub function_name: ::prost::alloc::string::String,
    /// (Optional) Function arguments. Empty arguments are allowed.
    #[prost(message, repeated, tag = "2")]
    pub arguments: ::prost::alloc::vec::Vec<Expression>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct NamedArgumentExpression {
    /// (Required) The key of the named argument.
    #[prost(string, tag = "1")]
    pub key: ::prost::alloc::string::String,
    /// (Required) The value expression of the named argument.
    #[prost(message, optional, boxed, tag = "2")]
    pub value: ::core::option::Option<::prost::alloc::boxed::Box<Expression>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MergeAction {
    /// (Required) The action type of the merge action.
    #[prost(enumeration = "merge_action::ActionType", tag = "1")]
    pub action_type: i32,
    /// (Optional) The condition expression of the merge action.
    #[prost(message, optional, boxed, tag = "2")]
    pub condition: ::core::option::Option<::prost::alloc::boxed::Box<Expression>>,
    /// (Optional) The assignments of the merge action. Required for ActionTypes INSERT and UPDATE.
    #[prost(message, repeated, tag = "3")]
    pub assignments: ::prost::alloc::vec::Vec<merge_action::Assignment>,
}
/// Nested message and enum types in `MergeAction`.
pub mod merge_action {
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Assignment {
        /// (Required) The key of the assignment.
        #[prost(message, optional, tag = "1")]
        pub key: ::core::option::Option<super::Expression>,
        /// (Required) The value of the assignment.
        #[prost(message, optional, tag = "2")]
        pub value: ::core::option::Option<super::Expression>,
    }
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum ActionType {
        Invalid = 0,
        Delete = 1,
        Insert = 2,
        InsertStar = 3,
        Update = 4,
        UpdateStar = 5,
    }
    impl ActionType {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::Invalid => "ACTION_TYPE_INVALID",
                Self::Delete => "ACTION_TYPE_DELETE",
                Self::Insert => "ACTION_TYPE_INSERT",
                Self::InsertStar => "ACTION_TYPE_INSERT_STAR",
                Self::Update => "ACTION_TYPE_UPDATE",
                Self::UpdateStar => "ACTION_TYPE_UPDATE_STAR",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "ACTION_TYPE_INVALID" => Some(Self::Invalid),
                "ACTION_TYPE_DELETE" => Some(Self::Delete),
                "ACTION_TYPE_INSERT" => Some(Self::Insert),
                "ACTION_TYPE_INSERT_STAR" => Some(Self::InsertStar),
                "ACTION_TYPE_UPDATE" => Some(Self::Update),
                "ACTION_TYPE_UPDATE_STAR" => Some(Self::UpdateStar),
                _ => None,
            }
        }
    }
}
/// Catalog messages are marked as unstable.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Catalog {
    #[prost(
        oneof = "catalog::CatType",
        tags = "1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26"
    )]
    pub cat_type: ::core::option::Option<catalog::CatType>,
}
/// Nested message and enum types in `Catalog`.
pub mod catalog {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum CatType {
        #[prost(message, tag = "1")]
        CurrentDatabase(super::CurrentDatabase),
        #[prost(message, tag = "2")]
        SetCurrentDatabase(super::SetCurrentDatabase),
        #[prost(message, tag = "3")]
        ListDatabases(super::ListDatabases),
        #[prost(message, tag = "4")]
        ListTables(super::ListTables),
        #[prost(message, tag = "5")]
        ListFunctions(super::ListFunctions),
        #[prost(message, tag = "6")]
        ListColumns(super::ListColumns),
        #[prost(message, tag = "7")]
        GetDatabase(super::GetDatabase),
        #[prost(message, tag = "8")]
        GetTable(super::GetTable),
        #[prost(message, tag = "9")]
        GetFunction(super::GetFunction),
        #[prost(message, tag = "10")]
        DatabaseExists(super::DatabaseExists),
        #[prost(message, tag = "11")]
        TableExists(super::TableExists),
        #[prost(message, tag = "12")]
        FunctionExists(super::FunctionExists),
        #[prost(message, tag = "13")]
        CreateExternalTable(super::CreateExternalTable),
        #[prost(message, tag = "14")]
        CreateTable(super::CreateTable),
        #[prost(message, tag = "15")]
        DropTempView(super::DropTempView),
        #[prost(message, tag = "16")]
        DropGlobalTempView(super::DropGlobalTempView),
        #[prost(message, tag = "17")]
        RecoverPartitions(super::RecoverPartitions),
        #[prost(message, tag = "18")]
        IsCached(super::IsCached),
        #[prost(message, tag = "19")]
        CacheTable(super::CacheTable),
        #[prost(message, tag = "20")]
        UncacheTable(super::UncacheTable),
        #[prost(message, tag = "21")]
        ClearCache(super::ClearCache),
        #[prost(message, tag = "22")]
        RefreshTable(super::RefreshTable),
        #[prost(message, tag = "23")]
        RefreshByPath(super::RefreshByPath),
        #[prost(message, tag = "24")]
        CurrentCatalog(super::CurrentCatalog),
        #[prost(message, tag = "25")]
        SetCurrentCatalog(super::SetCurrentCatalog),
        #[prost(message, tag = "26")]
        ListCatalogs(super::ListCatalogs),
    }
}
/// See `spark.catalog.currentDatabase`
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct CurrentDatabase {}
/// See `spark.catalog.setCurrentDatabase`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SetCurrentDatabase {
    /// (Required)
    #[prost(string, tag = "1")]
    pub db_name: ::prost::alloc::string::String,
}
/// See `spark.catalog.listDatabases`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListDatabases {
    /// (Optional) The pattern that the database name needs to match
    #[prost(string, optional, tag = "1")]
    pub pattern: ::core::option::Option<::prost::alloc::string::String>,
}
/// See `spark.catalog.listTables`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListTables {
    /// (Optional)
    #[prost(string, optional, tag = "1")]
    pub db_name: ::core::option::Option<::prost::alloc::string::String>,
    /// (Optional) The pattern that the table name needs to match
    #[prost(string, optional, tag = "2")]
    pub pattern: ::core::option::Option<::prost::alloc::string::String>,
}
/// See `spark.catalog.listFunctions`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListFunctions {
    /// (Optional)
    #[prost(string, optional, tag = "1")]
    pub db_name: ::core::option::Option<::prost::alloc::string::String>,
    /// (Optional) The pattern that the function name needs to match
    #[prost(string, optional, tag = "2")]
    pub pattern: ::core::option::Option<::prost::alloc::string::String>,
}
/// See `spark.catalog.listColumns`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListColumns {
    /// (Required)
    #[prost(string, tag = "1")]
    pub table_name: ::prost::alloc::string::String,
    /// (Optional)
    #[prost(string, optional, tag = "2")]
    pub db_name: ::core::option::Option<::prost::alloc::string::String>,
}
/// See `spark.catalog.getDatabase`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetDatabase {
    /// (Required)
    #[prost(string, tag = "1")]
    pub db_name: ::prost::alloc::string::String,
}
/// See `spark.catalog.getTable`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetTable {
    /// (Required)
    #[prost(string, tag = "1")]
    pub table_name: ::prost::alloc::string::String,
    /// (Optional)
    #[prost(string, optional, tag = "2")]
    pub db_name: ::core::option::Option<::prost::alloc::string::String>,
}
/// See `spark.catalog.getFunction`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetFunction {
    /// (Required)
    #[prost(string, tag = "1")]
    pub function_name: ::prost::alloc::string::String,
    /// (Optional)
    #[prost(string, optional, tag = "2")]
    pub db_name: ::core::option::Option<::prost::alloc::string::String>,
}
/// See `spark.catalog.databaseExists`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DatabaseExists {
    /// (Required)
    #[prost(string, tag = "1")]
    pub db_name: ::prost::alloc::string::String,
}
/// See `spark.catalog.tableExists`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableExists {
    /// (Required)
    #[prost(string, tag = "1")]
    pub table_name: ::prost::alloc::string::String,
    /// (Optional)
    #[prost(string, optional, tag = "2")]
    pub db_name: ::core::option::Option<::prost::alloc::string::String>,
}
/// See `spark.catalog.functionExists`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FunctionExists {
    /// (Required)
    #[prost(string, tag = "1")]
    pub function_name: ::prost::alloc::string::String,
    /// (Optional)
    #[prost(string, optional, tag = "2")]
    pub db_name: ::core::option::Option<::prost::alloc::string::String>,
}
/// See `spark.catalog.createExternalTable`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CreateExternalTable {
    /// (Required)
    #[prost(string, tag = "1")]
    pub table_name: ::prost::alloc::string::String,
    /// (Optional)
    #[prost(string, optional, tag = "2")]
    pub path: ::core::option::Option<::prost::alloc::string::String>,
    /// (Optional)
    #[prost(string, optional, tag = "3")]
    pub source: ::core::option::Option<::prost::alloc::string::String>,
    /// (Optional)
    #[prost(message, optional, tag = "4")]
    pub schema: ::core::option::Option<DataType>,
    /// Options could be empty for valid data source format.
    /// The map key is case insensitive.
    #[prost(map = "string, string", tag = "5")]
    pub options:
        ::std::collections::HashMap<::prost::alloc::string::String, ::prost::alloc::string::String>,
}
/// See `spark.catalog.createTable`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CreateTable {
    /// (Required)
    #[prost(string, tag = "1")]
    pub table_name: ::prost::alloc::string::String,
    /// (Optional)
    #[prost(string, optional, tag = "2")]
    pub path: ::core::option::Option<::prost::alloc::string::String>,
    /// (Optional)
    #[prost(string, optional, tag = "3")]
    pub source: ::core::option::Option<::prost::alloc::string::String>,
    /// (Optional)
    #[prost(string, optional, tag = "4")]
    pub description: ::core::option::Option<::prost::alloc::string::String>,
    /// (Optional)
    #[prost(message, optional, tag = "5")]
    pub schema: ::core::option::Option<DataType>,
    /// Options could be empty for valid data source format.
    /// The map key is case insensitive.
    #[prost(map = "string, string", tag = "6")]
    pub options:
        ::std::collections::HashMap<::prost::alloc::string::String, ::prost::alloc::string::String>,
}
/// See `spark.catalog.dropTempView`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DropTempView {
    /// (Required)
    #[prost(string, tag = "1")]
    pub view_name: ::prost::alloc::string::String,
}
/// See `spark.catalog.dropGlobalTempView`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DropGlobalTempView {
    /// (Required)
    #[prost(string, tag = "1")]
    pub view_name: ::prost::alloc::string::String,
}
/// See `spark.catalog.recoverPartitions`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RecoverPartitions {
    /// (Required)
    #[prost(string, tag = "1")]
    pub table_name: ::prost::alloc::string::String,
}
/// See `spark.catalog.isCached`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct IsCached {
    /// (Required)
    #[prost(string, tag = "1")]
    pub table_name: ::prost::alloc::string::String,
}
/// See `spark.catalog.cacheTable`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CacheTable {
    /// (Required)
    #[prost(string, tag = "1")]
    pub table_name: ::prost::alloc::string::String,
    /// (Optional)
    #[prost(message, optional, tag = "2")]
    pub storage_level: ::core::option::Option<StorageLevel>,
}
/// See `spark.catalog.uncacheTable`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct UncacheTable {
    /// (Required)
    #[prost(string, tag = "1")]
    pub table_name: ::prost::alloc::string::String,
}
/// See `spark.catalog.clearCache`
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct ClearCache {}
/// See `spark.catalog.refreshTable`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RefreshTable {
    /// (Required)
    #[prost(string, tag = "1")]
    pub table_name: ::prost::alloc::string::String,
}
/// See `spark.catalog.refreshByPath`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RefreshByPath {
    /// (Required)
    #[prost(string, tag = "1")]
    pub path: ::prost::alloc::string::String,
}
/// See `spark.catalog.currentCatalog`
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct CurrentCatalog {}
/// See `spark.catalog.setCurrentCatalog`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SetCurrentCatalog {
    /// (Required)
    #[prost(string, tag = "1")]
    pub catalog_name: ::prost::alloc::string::String,
}
/// See `spark.catalog.listCatalogs`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListCatalogs {
    /// (Optional) The pattern that the catalog name needs to match
    #[prost(string, optional, tag = "1")]
    pub pattern: ::core::option::Option<::prost::alloc::string::String>,
}
/// The main \[[Relation]\] type. Fundamentally, a relation is a typed container
/// that has exactly one explicit relation type set.
///
/// When adding new relation types, they have to be registered here.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Relation {
    #[prost(message, optional, tag = "1")]
    pub common: ::core::option::Option<RelationCommon>,
    #[prost(
        oneof = "relation::RelType",
        tags = "2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 90, 91, 92, 100, 101, 102, 103, 104, 105, 106, 107, 200, 998, 999"
    )]
    pub rel_type: ::core::option::Option<relation::RelType>,
}
/// Nested message and enum types in `Relation`.
pub mod relation {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum RelType {
        #[prost(message, tag = "2")]
        Read(super::Read),
        #[prost(message, tag = "3")]
        Project(::prost::alloc::boxed::Box<super::Project>),
        #[prost(message, tag = "4")]
        Filter(::prost::alloc::boxed::Box<super::Filter>),
        #[prost(message, tag = "5")]
        Join(::prost::alloc::boxed::Box<super::Join>),
        #[prost(message, tag = "6")]
        SetOp(::prost::alloc::boxed::Box<super::SetOperation>),
        #[prost(message, tag = "7")]
        Sort(::prost::alloc::boxed::Box<super::Sort>),
        #[prost(message, tag = "8")]
        Limit(::prost::alloc::boxed::Box<super::Limit>),
        #[prost(message, tag = "9")]
        Aggregate(::prost::alloc::boxed::Box<super::Aggregate>),
        #[prost(message, tag = "10")]
        Sql(super::Sql),
        #[prost(message, tag = "11")]
        LocalRelation(super::LocalRelation),
        #[prost(message, tag = "12")]
        Sample(::prost::alloc::boxed::Box<super::Sample>),
        #[prost(message, tag = "13")]
        Offset(::prost::alloc::boxed::Box<super::Offset>),
        #[prost(message, tag = "14")]
        Deduplicate(::prost::alloc::boxed::Box<super::Deduplicate>),
        #[prost(message, tag = "15")]
        Range(super::Range),
        #[prost(message, tag = "16")]
        SubqueryAlias(::prost::alloc::boxed::Box<super::SubqueryAlias>),
        #[prost(message, tag = "17")]
        Repartition(::prost::alloc::boxed::Box<super::Repartition>),
        #[prost(message, tag = "18")]
        ToDf(::prost::alloc::boxed::Box<super::ToDf>),
        #[prost(message, tag = "19")]
        WithColumnsRenamed(::prost::alloc::boxed::Box<super::WithColumnsRenamed>),
        #[prost(message, tag = "20")]
        ShowString(::prost::alloc::boxed::Box<super::ShowString>),
        #[prost(message, tag = "21")]
        Drop(::prost::alloc::boxed::Box<super::Drop>),
        #[prost(message, tag = "22")]
        Tail(::prost::alloc::boxed::Box<super::Tail>),
        #[prost(message, tag = "23")]
        WithColumns(::prost::alloc::boxed::Box<super::WithColumns>),
        #[prost(message, tag = "24")]
        Hint(::prost::alloc::boxed::Box<super::Hint>),
        #[prost(message, tag = "25")]
        Unpivot(::prost::alloc::boxed::Box<super::Unpivot>),
        #[prost(message, tag = "26")]
        ToSchema(::prost::alloc::boxed::Box<super::ToSchema>),
        #[prost(message, tag = "27")]
        RepartitionByExpression(::prost::alloc::boxed::Box<super::RepartitionByExpression>),
        #[prost(message, tag = "28")]
        MapPartitions(::prost::alloc::boxed::Box<super::MapPartitions>),
        #[prost(message, tag = "29")]
        CollectMetrics(::prost::alloc::boxed::Box<super::CollectMetrics>),
        #[prost(message, tag = "30")]
        Parse(::prost::alloc::boxed::Box<super::Parse>),
        #[prost(message, tag = "31")]
        GroupMap(::prost::alloc::boxed::Box<super::GroupMap>),
        #[prost(message, tag = "32")]
        CoGroupMap(::prost::alloc::boxed::Box<super::CoGroupMap>),
        #[prost(message, tag = "33")]
        WithWatermark(::prost::alloc::boxed::Box<super::WithWatermark>),
        #[prost(message, tag = "34")]
        ApplyInPandasWithState(::prost::alloc::boxed::Box<super::ApplyInPandasWithState>),
        #[prost(message, tag = "35")]
        HtmlString(::prost::alloc::boxed::Box<super::HtmlString>),
        #[prost(message, tag = "36")]
        CachedLocalRelation(super::CachedLocalRelation),
        #[prost(message, tag = "37")]
        CachedRemoteRelation(super::CachedRemoteRelation),
        #[prost(message, tag = "38")]
        CommonInlineUserDefinedTableFunction(super::CommonInlineUserDefinedTableFunction),
        #[prost(message, tag = "39")]
        AsOfJoin(::prost::alloc::boxed::Box<super::AsOfJoin>),
        #[prost(message, tag = "40")]
        CommonInlineUserDefinedDataSource(super::CommonInlineUserDefinedDataSource),
        #[prost(message, tag = "41")]
        WithRelations(::prost::alloc::boxed::Box<super::WithRelations>),
        #[prost(message, tag = "42")]
        Transpose(::prost::alloc::boxed::Box<super::Transpose>),
        /// NA functions
        #[prost(message, tag = "90")]
        FillNa(::prost::alloc::boxed::Box<super::NaFill>),
        #[prost(message, tag = "91")]
        DropNa(::prost::alloc::boxed::Box<super::NaDrop>),
        #[prost(message, tag = "92")]
        Replace(::prost::alloc::boxed::Box<super::NaReplace>),
        /// stat functions
        #[prost(message, tag = "100")]
        Summary(::prost::alloc::boxed::Box<super::StatSummary>),
        #[prost(message, tag = "101")]
        Crosstab(::prost::alloc::boxed::Box<super::StatCrosstab>),
        #[prost(message, tag = "102")]
        Describe(::prost::alloc::boxed::Box<super::StatDescribe>),
        #[prost(message, tag = "103")]
        Cov(::prost::alloc::boxed::Box<super::StatCov>),
        #[prost(message, tag = "104")]
        Corr(::prost::alloc::boxed::Box<super::StatCorr>),
        #[prost(message, tag = "105")]
        ApproxQuantile(::prost::alloc::boxed::Box<super::StatApproxQuantile>),
        #[prost(message, tag = "106")]
        FreqItems(::prost::alloc::boxed::Box<super::StatFreqItems>),
        #[prost(message, tag = "107")]
        SampleBy(::prost::alloc::boxed::Box<super::StatSampleBy>),
        /// Catalog API (experimental / unstable)
        #[prost(message, tag = "200")]
        Catalog(super::Catalog),
        /// This field is used to mark extensions to the protocol. When plugins generate arbitrary
        /// relations they can add them here. During the planning the correct resolution is done.
        #[prost(message, tag = "998")]
        Extension(::prost_types::Any),
        #[prost(message, tag = "999")]
        Unknown(super::Unknown),
    }
}
/// Used for testing purposes only.
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Unknown {}
/// Common metadata of all relations.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RelationCommon {
    /// (Required) Shared relation metadata.
    #[deprecated]
    #[prost(string, tag = "1")]
    pub source_info: ::prost::alloc::string::String,
    /// (Optional) A per-client globally unique id for a given connect plan.
    #[prost(int64, optional, tag = "2")]
    pub plan_id: ::core::option::Option<i64>,
    /// (Optional) Keep the information of the origin for this expression such as stacktrace.
    #[prost(message, optional, tag = "3")]
    pub origin: ::core::option::Option<Origin>,
}
/// Relation that uses a SQL query to generate the output.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Sql {
    /// (Required) The SQL query.
    #[prost(string, tag = "1")]
    pub query: ::prost::alloc::string::String,
    /// (Optional) A map of parameter names to literal expressions.
    #[prost(map = "string, message", tag = "2")]
    pub args: ::std::collections::HashMap<::prost::alloc::string::String, expression::Literal>,
    /// (Optional) A sequence of literal expressions for positional parameters in the SQL query text.
    #[deprecated]
    #[prost(message, repeated, tag = "3")]
    pub pos_args: ::prost::alloc::vec::Vec<expression::Literal>,
    /// (Optional) A map of parameter names to expressions.
    /// It cannot coexist with `pos_arguments`.
    #[prost(map = "string, message", tag = "4")]
    pub named_arguments: ::std::collections::HashMap<::prost::alloc::string::String, Expression>,
    /// (Optional) A sequence of expressions for positional parameters in the SQL query text.
    /// It cannot coexist with `named_arguments`.
    #[prost(message, repeated, tag = "5")]
    pub pos_arguments: ::prost::alloc::vec::Vec<Expression>,
}
/// Relation of type \[[WithRelations]\].
///
/// This relation contains a root plan, and one or more references that are used by the root plan.
/// There are two ways of referencing a relation, by name (through a subquery alias), or by plan_id
/// (using RelationCommon.plan_id).
///
/// This relation can be used to implement CTEs, describe DAGs, or to reduce tree depth.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct WithRelations {
    /// (Required) Plan at the root of the query tree. This plan is expected to contain one or more
    /// references. Those references get expanded later on by the engine.
    #[prost(message, optional, boxed, tag = "1")]
    pub root: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) Plans referenced by the root plan. Relations in this list are also allowed to
    /// contain references to other relations in this list, as long they do not form cycles.
    #[prost(message, repeated, tag = "2")]
    pub references: ::prost::alloc::vec::Vec<Relation>,
}
/// Relation that reads from a file / table or other data source. Does not have additional
/// inputs.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Read {
    /// (Optional) Indicates if this is a streaming read.
    #[prost(bool, tag = "3")]
    pub is_streaming: bool,
    #[prost(oneof = "read::ReadType", tags = "1, 2")]
    pub read_type: ::core::option::Option<read::ReadType>,
}
/// Nested message and enum types in `Read`.
pub mod read {
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct NamedTable {
        /// (Required) Unparsed identifier for the table.
        #[prost(string, tag = "1")]
        pub unparsed_identifier: ::prost::alloc::string::String,
        /// Options for the named table. The map key is case insensitive.
        #[prost(map = "string, string", tag = "2")]
        pub options: ::std::collections::HashMap<
            ::prost::alloc::string::String,
            ::prost::alloc::string::String,
        >,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct DataSource {
        /// (Optional) Supported formats include: parquet, orc, text, json, parquet, csv, avro.
        ///
        /// If not set, the value from SQL conf 'spark.sql.sources.default' will be used.
        #[prost(string, optional, tag = "1")]
        pub format: ::core::option::Option<::prost::alloc::string::String>,
        /// (Optional) If not set, Spark will infer the schema.
        ///
        /// This schema string should be either DDL-formatted or JSON-formatted.
        #[prost(string, optional, tag = "2")]
        pub schema: ::core::option::Option<::prost::alloc::string::String>,
        /// Options for the data source. The context of this map varies based on the
        /// data source format. This options could be empty for valid data source format.
        /// The map key is case insensitive.
        #[prost(map = "string, string", tag = "3")]
        pub options: ::std::collections::HashMap<
            ::prost::alloc::string::String,
            ::prost::alloc::string::String,
        >,
        /// (Optional) A list of path for file-system backed data sources.
        #[prost(string, repeated, tag = "4")]
        pub paths: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
        /// (Optional) Condition in the where clause for each partition.
        ///
        /// This is only supported by the JDBC data source.
        #[prost(string, repeated, tag = "5")]
        pub predicates: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    }
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum ReadType {
        #[prost(message, tag = "1")]
        NamedTable(NamedTable),
        #[prost(message, tag = "2")]
        DataSource(DataSource),
    }
}
/// Projection of a bag of expressions for a given input relation.
///
/// The input relation must be specified.
/// The projected expression can be an arbitrary expression.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Project {
    /// (Optional) Input relation is optional for Project.
    ///
    /// For example, `SELECT ABS(-1)` is valid plan without an input plan.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) A Project requires at least one expression.
    #[prost(message, repeated, tag = "3")]
    pub expressions: ::prost::alloc::vec::Vec<Expression>,
}
/// Relation that applies a boolean expression `condition` on each row of `input` to produce
/// the output result.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Filter {
    /// (Required) Input relation for a Filter.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) A Filter must have a condition expression.
    #[prost(message, optional, tag = "2")]
    pub condition: ::core::option::Option<Expression>,
}
/// Relation of type \[[Join]\].
///
/// `left` and `right` must be present.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Join {
    /// (Required) Left input relation for a Join.
    #[prost(message, optional, boxed, tag = "1")]
    pub left: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) Right input relation for a Join.
    #[prost(message, optional, boxed, tag = "2")]
    pub right: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Optional) The join condition. Could be unset when `using_columns` is utilized.
    ///
    /// This field does not co-exist with using_columns.
    #[prost(message, optional, tag = "3")]
    pub join_condition: ::core::option::Option<Expression>,
    /// (Required) The join type.
    #[prost(enumeration = "join::JoinType", tag = "4")]
    pub join_type: i32,
    /// Optional. using_columns provides a list of columns that should present on both sides of
    /// the join inputs that this Join will join on. For example A JOIN B USING col_name is
    /// equivalent to A JOIN B on A.col_name = B.col_name.
    ///
    /// This field does not co-exist with join_condition.
    #[prost(string, repeated, tag = "5")]
    pub using_columns: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// (Optional) Only used by joinWith. Set the left and right join data types.
    #[prost(message, optional, tag = "6")]
    pub join_data_type: ::core::option::Option<join::JoinDataType>,
}
/// Nested message and enum types in `Join`.
pub mod join {
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct JoinDataType {
        /// If the left data type is a struct.
        #[prost(bool, tag = "1")]
        pub is_left_struct: bool,
        /// If the right data type is a struct.
        #[prost(bool, tag = "2")]
        pub is_right_struct: bool,
    }
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum JoinType {
        Unspecified = 0,
        Inner = 1,
        FullOuter = 2,
        LeftOuter = 3,
        RightOuter = 4,
        LeftAnti = 5,
        LeftSemi = 6,
        Cross = 7,
    }
    impl JoinType {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::Unspecified => "JOIN_TYPE_UNSPECIFIED",
                Self::Inner => "JOIN_TYPE_INNER",
                Self::FullOuter => "JOIN_TYPE_FULL_OUTER",
                Self::LeftOuter => "JOIN_TYPE_LEFT_OUTER",
                Self::RightOuter => "JOIN_TYPE_RIGHT_OUTER",
                Self::LeftAnti => "JOIN_TYPE_LEFT_ANTI",
                Self::LeftSemi => "JOIN_TYPE_LEFT_SEMI",
                Self::Cross => "JOIN_TYPE_CROSS",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "JOIN_TYPE_UNSPECIFIED" => Some(Self::Unspecified),
                "JOIN_TYPE_INNER" => Some(Self::Inner),
                "JOIN_TYPE_FULL_OUTER" => Some(Self::FullOuter),
                "JOIN_TYPE_LEFT_OUTER" => Some(Self::LeftOuter),
                "JOIN_TYPE_RIGHT_OUTER" => Some(Self::RightOuter),
                "JOIN_TYPE_LEFT_ANTI" => Some(Self::LeftAnti),
                "JOIN_TYPE_LEFT_SEMI" => Some(Self::LeftSemi),
                "JOIN_TYPE_CROSS" => Some(Self::Cross),
                _ => None,
            }
        }
    }
}
/// Relation of type \[[SetOperation]\]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SetOperation {
    /// (Required) Left input relation for a Set operation.
    #[prost(message, optional, boxed, tag = "1")]
    pub left_input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) Right input relation for a Set operation.
    #[prost(message, optional, boxed, tag = "2")]
    pub right_input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) The Set operation type.
    #[prost(enumeration = "set_operation::SetOpType", tag = "3")]
    pub set_op_type: i32,
    /// (Optional) If to remove duplicate rows.
    ///
    /// True to preserve all results.
    /// False to remove duplicate rows.
    #[prost(bool, optional, tag = "4")]
    pub is_all: ::core::option::Option<bool>,
    /// (Optional) If to perform the Set operation based on name resolution.
    ///
    /// Only UNION supports this option.
    #[prost(bool, optional, tag = "5")]
    pub by_name: ::core::option::Option<bool>,
    /// (Optional) If to perform the Set operation and allow missing columns.
    ///
    /// Only UNION supports this option.
    #[prost(bool, optional, tag = "6")]
    pub allow_missing_columns: ::core::option::Option<bool>,
}
/// Nested message and enum types in `SetOperation`.
pub mod set_operation {
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum SetOpType {
        Unspecified = 0,
        Intersect = 1,
        Union = 2,
        Except = 3,
    }
    impl SetOpType {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::Unspecified => "SET_OP_TYPE_UNSPECIFIED",
                Self::Intersect => "SET_OP_TYPE_INTERSECT",
                Self::Union => "SET_OP_TYPE_UNION",
                Self::Except => "SET_OP_TYPE_EXCEPT",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "SET_OP_TYPE_UNSPECIFIED" => Some(Self::Unspecified),
                "SET_OP_TYPE_INTERSECT" => Some(Self::Intersect),
                "SET_OP_TYPE_UNION" => Some(Self::Union),
                "SET_OP_TYPE_EXCEPT" => Some(Self::Except),
                _ => None,
            }
        }
    }
}
/// Relation of type \[[Limit]\] that is used to `limit` rows from the input relation.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Limit {
    /// (Required) Input relation for a Limit.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) the limit.
    #[prost(int32, tag = "2")]
    pub limit: i32,
}
/// Relation of type \[[Offset]\] that is used to read rows staring from the `offset` on
/// the input relation.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Offset {
    /// (Required) Input relation for an Offset.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) the limit.
    #[prost(int32, tag = "2")]
    pub offset: i32,
}
/// Relation of type \[[Tail]\] that is used to fetch `limit` rows from the last of the input relation.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Tail {
    /// (Required) Input relation for an Tail.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) the limit.
    #[prost(int32, tag = "2")]
    pub limit: i32,
}
/// Relation of type \[[Aggregate]\].
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Aggregate {
    /// (Required) Input relation for a RelationalGroupedDataset.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) How the RelationalGroupedDataset was built.
    #[prost(enumeration = "aggregate::GroupType", tag = "2")]
    pub group_type: i32,
    /// (Required) Expressions for grouping keys
    #[prost(message, repeated, tag = "3")]
    pub grouping_expressions: ::prost::alloc::vec::Vec<Expression>,
    /// (Required) List of values that will be translated to columns in the output DataFrame.
    #[prost(message, repeated, tag = "4")]
    pub aggregate_expressions: ::prost::alloc::vec::Vec<Expression>,
    /// (Optional) Pivots a column of the current `DataFrame` and performs the specified aggregation.
    #[prost(message, optional, tag = "5")]
    pub pivot: ::core::option::Option<aggregate::Pivot>,
    /// (Optional) List of values that will be translated to columns in the output DataFrame.
    #[prost(message, repeated, tag = "6")]
    pub grouping_sets: ::prost::alloc::vec::Vec<aggregate::GroupingSets>,
}
/// Nested message and enum types in `Aggregate`.
pub mod aggregate {
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Pivot {
        /// (Required) The column to pivot
        #[prost(message, optional, tag = "1")]
        pub col: ::core::option::Option<super::Expression>,
        /// (Optional) List of values that will be translated to columns in the output DataFrame.
        ///
        /// Note that if it is empty, the server side will immediately trigger a job to collect
        /// the distinct values of the column.
        #[prost(message, repeated, tag = "2")]
        pub values: ::prost::alloc::vec::Vec<super::expression::Literal>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct GroupingSets {
        /// (Required) Individual grouping set
        #[prost(message, repeated, tag = "1")]
        pub grouping_set: ::prost::alloc::vec::Vec<super::Expression>,
    }
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum GroupType {
        Unspecified = 0,
        Groupby = 1,
        Rollup = 2,
        Cube = 3,
        Pivot = 4,
        GroupingSets = 5,
    }
    impl GroupType {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::Unspecified => "GROUP_TYPE_UNSPECIFIED",
                Self::Groupby => "GROUP_TYPE_GROUPBY",
                Self::Rollup => "GROUP_TYPE_ROLLUP",
                Self::Cube => "GROUP_TYPE_CUBE",
                Self::Pivot => "GROUP_TYPE_PIVOT",
                Self::GroupingSets => "GROUP_TYPE_GROUPING_SETS",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "GROUP_TYPE_UNSPECIFIED" => Some(Self::Unspecified),
                "GROUP_TYPE_GROUPBY" => Some(Self::Groupby),
                "GROUP_TYPE_ROLLUP" => Some(Self::Rollup),
                "GROUP_TYPE_CUBE" => Some(Self::Cube),
                "GROUP_TYPE_PIVOT" => Some(Self::Pivot),
                "GROUP_TYPE_GROUPING_SETS" => Some(Self::GroupingSets),
                _ => None,
            }
        }
    }
}
/// Relation of type \[[Sort]\].
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Sort {
    /// (Required) Input relation for a Sort.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) The ordering expressions
    #[prost(message, repeated, tag = "2")]
    pub order: ::prost::alloc::vec::Vec<expression::SortOrder>,
    /// (Optional) if this is a global sort.
    #[prost(bool, optional, tag = "3")]
    pub is_global: ::core::option::Option<bool>,
}
/// Drop specified columns.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Drop {
    /// (Required) The input relation.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Optional) columns to drop.
    #[prost(message, repeated, tag = "2")]
    pub columns: ::prost::alloc::vec::Vec<Expression>,
    /// (Optional) names of columns to drop.
    #[prost(string, repeated, tag = "3")]
    pub column_names: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// Relation of type \[[Deduplicate]\] which have duplicate rows removed, could consider either only
/// the subset of columns or all the columns.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Deduplicate {
    /// (Required) Input relation for a Deduplicate.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Optional) Deduplicate based on a list of column names.
    ///
    /// This field does not co-use with `all_columns_as_keys`.
    #[prost(string, repeated, tag = "2")]
    pub column_names: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// (Optional) Deduplicate based on all the columns of the input relation.
    ///
    /// This field does not co-use with `column_names`.
    #[prost(bool, optional, tag = "3")]
    pub all_columns_as_keys: ::core::option::Option<bool>,
    /// (Optional) Deduplicate within the time range of watermark.
    #[prost(bool, optional, tag = "4")]
    pub within_watermark: ::core::option::Option<bool>,
}
/// A relation that does not need to be qualified by name.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LocalRelation {
    /// (Optional) Local collection data serialized into Arrow IPC streaming format which contains
    /// the schema of the data.
    #[prost(bytes = "vec", optional, tag = "1")]
    pub data: ::core::option::Option<::prost::alloc::vec::Vec<u8>>,
    /// (Optional) The schema of local data.
    /// It should be either a DDL-formatted type string or a JSON string.
    ///
    /// The server side will update the column names and data types according to this schema.
    /// If the 'data' is not provided, then this schema will be required.
    #[prost(string, optional, tag = "2")]
    pub schema: ::core::option::Option<::prost::alloc::string::String>,
}
/// A local relation that has been cached already.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CachedLocalRelation {
    /// (Required) A sha-256 hash of the serialized local relation in proto, see LocalRelation.
    #[prost(string, tag = "3")]
    pub hash: ::prost::alloc::string::String,
}
/// Represents a remote relation that has been cached on server.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CachedRemoteRelation {
    /// (Required) ID of the remote related (assigned by the service).
    #[prost(string, tag = "1")]
    pub relation_id: ::prost::alloc::string::String,
}
/// Relation of type \[[Sample]\] that samples a fraction of the dataset.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Sample {
    /// (Required) Input relation for a Sample.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) lower bound.
    #[prost(double, tag = "2")]
    pub lower_bound: f64,
    /// (Required) upper bound.
    #[prost(double, tag = "3")]
    pub upper_bound: f64,
    /// (Optional) Whether to sample with replacement.
    #[prost(bool, optional, tag = "4")]
    pub with_replacement: ::core::option::Option<bool>,
    /// (Required) The random seed.
    /// This field is required to avoid generating mutable dataframes (see SPARK-48184 for details),
    /// however, still keep it 'optional' here for backward compatibility.
    #[prost(int64, optional, tag = "5")]
    pub seed: ::core::option::Option<i64>,
    /// (Required) Explicitly sort the underlying plan to make the ordering deterministic or cache it.
    /// This flag is true when invoking `dataframe.randomSplit` to randomly splits DataFrame with the
    /// provided weights. Otherwise, it is false.
    #[prost(bool, tag = "6")]
    pub deterministic_order: bool,
}
/// Relation of type \[[Range]\] that generates a sequence of integers.
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Range {
    /// (Optional) Default value = 0
    #[prost(int64, optional, tag = "1")]
    pub start: ::core::option::Option<i64>,
    /// (Required)
    #[prost(int64, tag = "2")]
    pub end: i64,
    /// (Required)
    #[prost(int64, tag = "3")]
    pub step: i64,
    /// Optional. Default value is assigned by 1) SQL conf "spark.sql.leafNodeDefaultParallelism" if
    /// it is set, or 2) spark default parallelism.
    #[prost(int32, optional, tag = "4")]
    pub num_partitions: ::core::option::Option<i32>,
}
/// Relation alias.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SubqueryAlias {
    /// (Required) The input relation of SubqueryAlias.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) The alias.
    #[prost(string, tag = "2")]
    pub alias: ::prost::alloc::string::String,
    /// (Optional) Qualifier of the alias.
    #[prost(string, repeated, tag = "3")]
    pub qualifier: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// Relation repartition.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Repartition {
    /// (Required) The input relation of Repartition.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) Must be positive.
    #[prost(int32, tag = "2")]
    pub num_partitions: i32,
    /// (Optional) Default value is false.
    #[prost(bool, optional, tag = "3")]
    pub shuffle: ::core::option::Option<bool>,
}
/// Compose the string representing rows for output.
/// It will invoke 'Dataset.showString' to compute the results.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ShowString {
    /// (Required) The input relation.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) Number of rows to show.
    #[prost(int32, tag = "2")]
    pub num_rows: i32,
    /// (Required) If set to more than 0, truncates strings to
    /// `truncate` characters and all cells will be aligned right.
    #[prost(int32, tag = "3")]
    pub truncate: i32,
    /// (Required) If set to true, prints output rows vertically (one line per column value).
    #[prost(bool, tag = "4")]
    pub vertical: bool,
}
/// Compose the string representing rows for output.
/// It will invoke 'Dataset.htmlString' to compute the results.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HtmlString {
    /// (Required) The input relation.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) Number of rows to show.
    #[prost(int32, tag = "2")]
    pub num_rows: i32,
    /// (Required) If set to more than 0, truncates strings to
    /// `truncate` characters and all cells will be aligned right.
    #[prost(int32, tag = "3")]
    pub truncate: i32,
}
/// Computes specified statistics for numeric and string columns.
/// It will invoke 'Dataset.summary' (same as 'StatFunctions.summary')
/// to compute the results.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StatSummary {
    /// (Required) The input relation.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Optional) Statistics from to be computed.
    ///
    /// Available statistics are:
    ///   count
    ///   mean
    ///   stddev
    ///   min
    ///   max
    ///   arbitrary approximate percentiles specified as a percentage (e.g. 75%)
    ///   count_distinct
    ///   approx_count_distinct
    ///
    /// If no statistics are given, this function computes 'count', 'mean', 'stddev', 'min',
    /// 'approximate quartiles' (percentiles at 25%, 50%, and 75%), and 'max'.
    #[prost(string, repeated, tag = "2")]
    pub statistics: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// Computes basic statistics for numeric and string columns, including count, mean, stddev, min,
/// and max. If no columns are given, this function computes statistics for all numerical or
/// string columns.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StatDescribe {
    /// (Required) The input relation.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Optional) Columns to compute statistics on.
    #[prost(string, repeated, tag = "2")]
    pub cols: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// Computes a pair-wise frequency table of the given columns. Also known as a contingency table.
/// It will invoke 'Dataset.stat.crosstab' (same as 'StatFunctions.crossTabulate')
/// to compute the results.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StatCrosstab {
    /// (Required) The input relation.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) The name of the first column.
    ///
    /// Distinct items will make the first item of each row.
    #[prost(string, tag = "2")]
    pub col1: ::prost::alloc::string::String,
    /// (Required) The name of the second column.
    ///
    /// Distinct items will make the column names of the DataFrame.
    #[prost(string, tag = "3")]
    pub col2: ::prost::alloc::string::String,
}
/// Calculate the sample covariance of two numerical columns of a DataFrame.
/// It will invoke 'Dataset.stat.cov' (same as 'StatFunctions.calculateCov') to compute the results.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StatCov {
    /// (Required) The input relation.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) The name of the first column.
    #[prost(string, tag = "2")]
    pub col1: ::prost::alloc::string::String,
    /// (Required) The name of the second column.
    #[prost(string, tag = "3")]
    pub col2: ::prost::alloc::string::String,
}
/// Calculates the correlation of two columns of a DataFrame. Currently only supports the Pearson
/// Correlation Coefficient. It will invoke 'Dataset.stat.corr' (same as
/// 'StatFunctions.pearsonCorrelation') to compute the results.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StatCorr {
    /// (Required) The input relation.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) The name of the first column.
    #[prost(string, tag = "2")]
    pub col1: ::prost::alloc::string::String,
    /// (Required) The name of the second column.
    #[prost(string, tag = "3")]
    pub col2: ::prost::alloc::string::String,
    /// (Optional) Default value is 'pearson'.
    ///
    /// Currently only supports the Pearson Correlation Coefficient.
    #[prost(string, optional, tag = "4")]
    pub method: ::core::option::Option<::prost::alloc::string::String>,
}
/// Calculates the approximate quantiles of numerical columns of a DataFrame.
/// It will invoke 'Dataset.stat.approxQuantile' (same as 'StatFunctions.approxQuantile')
/// to compute the results.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StatApproxQuantile {
    /// (Required) The input relation.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) The names of the numerical columns.
    #[prost(string, repeated, tag = "2")]
    pub cols: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// (Required) A list of quantile probabilities.
    ///
    /// Each number must belong to \[0, 1\].
    /// For example 0 is the minimum, 0.5 is the median, 1 is the maximum.
    #[prost(double, repeated, tag = "3")]
    pub probabilities: ::prost::alloc::vec::Vec<f64>,
    /// (Required) The relative target precision to achieve (greater than or equal to 0).
    ///
    /// If set to zero, the exact quantiles are computed, which could be very expensive.
    /// Note that values greater than 1 are accepted but give the same result as 1.
    #[prost(double, tag = "4")]
    pub relative_error: f64,
}
/// Finding frequent items for columns, possibly with false positives.
/// It will invoke 'Dataset.stat.freqItems' (same as 'StatFunctions.freqItems')
/// to compute the results.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StatFreqItems {
    /// (Required) The input relation.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) The names of the columns to search frequent items in.
    #[prost(string, repeated, tag = "2")]
    pub cols: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// (Optional) The minimum frequency for an item to be considered `frequent`.
    /// Should be greater than 1e-4.
    #[prost(double, optional, tag = "3")]
    pub support: ::core::option::Option<f64>,
}
/// Returns a stratified sample without replacement based on the fraction
/// given on each stratum.
/// It will invoke 'Dataset.stat.freqItems' (same as 'StatFunctions.freqItems')
/// to compute the results.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StatSampleBy {
    /// (Required) The input relation.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) The column that defines strata.
    #[prost(message, optional, tag = "2")]
    pub col: ::core::option::Option<Expression>,
    /// (Required) Sampling fraction for each stratum.
    ///
    /// If a stratum is not specified, we treat its fraction as zero.
    #[prost(message, repeated, tag = "3")]
    pub fractions: ::prost::alloc::vec::Vec<stat_sample_by::Fraction>,
    /// (Required) The random seed.
    /// This field is required to avoid generating mutable dataframes (see SPARK-48184 for details),
    /// however, still keep it 'optional' here for backward compatibility.
    #[prost(int64, optional, tag = "5")]
    pub seed: ::core::option::Option<i64>,
}
/// Nested message and enum types in `StatSampleBy`.
pub mod stat_sample_by {
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Fraction {
        /// (Required) The stratum.
        #[prost(message, optional, tag = "1")]
        pub stratum: ::core::option::Option<super::expression::Literal>,
        /// (Required) The fraction value. Must be in \[0, 1\].
        #[prost(double, tag = "2")]
        pub fraction: f64,
    }
}
/// Replaces null values.
/// It will invoke 'Dataset.na.fill' (same as 'DataFrameNaFunctions.fill') to compute the results.
/// Following 3 parameter combinations are supported:
///   1, 'values' only contains 1 item, 'cols' is empty:
///     replaces null values in all type-compatible columns.
///   2, 'values' only contains 1 item, 'cols' is not empty:
///     replaces null values in specified columns.
///   3, 'values' contains more than 1 items, then 'cols' is required to have the same length:
///     replaces each specified column with corresponding value.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct NaFill {
    /// (Required) The input relation.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Optional) Optional list of column names to consider.
    #[prost(string, repeated, tag = "2")]
    pub cols: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// (Required) Values to replace null values with.
    ///
    /// Should contain at least 1 item.
    /// Only 4 data types are supported now: bool, long, double, string
    #[prost(message, repeated, tag = "3")]
    pub values: ::prost::alloc::vec::Vec<expression::Literal>,
}
/// Drop rows containing null values.
/// It will invoke 'Dataset.na.drop' (same as 'DataFrameNaFunctions.drop') to compute the results.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct NaDrop {
    /// (Required) The input relation.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Optional) Optional list of column names to consider.
    ///
    /// When it is empty, all the columns in the input relation will be considered.
    #[prost(string, repeated, tag = "2")]
    pub cols: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// (Optional) The minimum number of non-null and non-NaN values required to keep.
    ///
    /// When not set, it is equivalent to the number of considered columns, which means
    /// a row will be kept only if all columns are non-null.
    ///
    /// 'how' options ('all', 'any') can be easily converted to this field:
    ///    - 'all' -> set 'min_non_nulls' 1;
    ///    - 'any' -> keep 'min_non_nulls' unset;
    #[prost(int32, optional, tag = "3")]
    pub min_non_nulls: ::core::option::Option<i32>,
}
/// Replaces old values with the corresponding values.
/// It will invoke 'Dataset.na.replace' (same as 'DataFrameNaFunctions.replace')
/// to compute the results.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct NaReplace {
    /// (Required) The input relation.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Optional) List of column names to consider.
    ///
    /// When it is empty, all the type-compatible columns in the input relation will be considered.
    #[prost(string, repeated, tag = "2")]
    pub cols: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// (Optional) The value replacement mapping.
    #[prost(message, repeated, tag = "3")]
    pub replacements: ::prost::alloc::vec::Vec<na_replace::Replacement>,
}
/// Nested message and enum types in `NAReplace`.
pub mod na_replace {
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Replacement {
        /// (Required) The old value.
        ///
        /// Only 4 data types are supported now: null, bool, double, string.
        #[prost(message, optional, tag = "1")]
        pub old_value: ::core::option::Option<super::expression::Literal>,
        /// (Required) The new value.
        ///
        /// Should be of the same data type with the old value.
        #[prost(message, optional, tag = "2")]
        pub new_value: ::core::option::Option<super::expression::Literal>,
    }
}
/// Rename columns on the input relation by the same length of names.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ToDf {
    /// (Required) The input relation of RenameColumnsBySameLengthNames.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required)
    ///
    /// The number of columns of the input relation must be equal to the length
    /// of this field. If this is not true, an exception will be returned.
    #[prost(string, repeated, tag = "2")]
    pub column_names: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// Rename columns on the input relation by a map with name to name mapping.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct WithColumnsRenamed {
    /// (Required) The input relation.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Optional)
    ///
    /// Renaming column names of input relation from A to B where A is the map key
    /// and B is the map value. This is a no-op if schema doesn't contain any A. It
    /// does not require that all input relation column names to present as keys.
    /// duplicated B are not allowed.
    #[prost(map = "string, string", tag = "2")]
    pub rename_columns_map:
        ::std::collections::HashMap<::prost::alloc::string::String, ::prost::alloc::string::String>,
    #[prost(message, repeated, tag = "3")]
    pub renames: ::prost::alloc::vec::Vec<with_columns_renamed::Rename>,
}
/// Nested message and enum types in `WithColumnsRenamed`.
pub mod with_columns_renamed {
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Rename {
        /// (Required) The existing column name.
        #[prost(string, tag = "1")]
        pub col_name: ::prost::alloc::string::String,
        /// (Required) The new column name.
        #[prost(string, tag = "2")]
        pub new_col_name: ::prost::alloc::string::String,
    }
}
/// Adding columns or replacing the existing columns that have the same names.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct WithColumns {
    /// (Required) The input relation.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required)
    ///
    /// Given a column name, apply the corresponding expression on the column. If column
    /// name exists in the input relation, then replace the column. If the column name
    /// does not exist in the input relation, then adds it as a new column.
    ///
    /// Only one name part is expected from each Expression.Alias.
    ///
    /// An exception is thrown when duplicated names are present in the mapping.
    #[prost(message, repeated, tag = "2")]
    pub aliases: ::prost::alloc::vec::Vec<expression::Alias>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct WithWatermark {
    /// (Required) The input relation
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) Name of the column containing event time.
    #[prost(string, tag = "2")]
    pub event_time: ::prost::alloc::string::String,
    /// (Required)
    #[prost(string, tag = "3")]
    pub delay_threshold: ::prost::alloc::string::String,
}
/// Specify a hint over a relation. Hint should have a name and optional parameters.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Hint {
    /// (Required) The input relation.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) Hint name.
    ///
    /// Supported Join hints include BROADCAST, MERGE, SHUFFLE_HASH, SHUFFLE_REPLICATE_NL.
    ///
    /// Supported partitioning hints include COALESCE, REPARTITION, REPARTITION_BY_RANGE.
    #[prost(string, tag = "2")]
    pub name: ::prost::alloc::string::String,
    /// (Optional) Hint parameters.
    #[prost(message, repeated, tag = "3")]
    pub parameters: ::prost::alloc::vec::Vec<Expression>,
}
/// Unpivot a DataFrame from wide format to long format, optionally leaving identifier columns set.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Unpivot {
    /// (Required) The input relation.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) Id columns.
    #[prost(message, repeated, tag = "2")]
    pub ids: ::prost::alloc::vec::Vec<Expression>,
    /// (Optional) Value columns to unpivot.
    #[prost(message, optional, tag = "3")]
    pub values: ::core::option::Option<unpivot::Values>,
    /// (Required) Name of the variable column.
    #[prost(string, tag = "4")]
    pub variable_column_name: ::prost::alloc::string::String,
    /// (Required) Name of the value column.
    #[prost(string, tag = "5")]
    pub value_column_name: ::prost::alloc::string::String,
}
/// Nested message and enum types in `Unpivot`.
pub mod unpivot {
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Values {
        #[prost(message, repeated, tag = "1")]
        pub values: ::prost::alloc::vec::Vec<super::Expression>,
    }
}
/// Transpose a DataFrame, switching rows to columns.
/// Transforms the DataFrame such that the values in the specified index column
/// become the new columns of the DataFrame.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Transpose {
    /// (Required) The input relation.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Optional) A list of columns that will be treated as the indices.
    /// Only single column is supported now.
    #[prost(message, repeated, tag = "2")]
    pub index_columns: ::prost::alloc::vec::Vec<Expression>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ToSchema {
    /// (Required) The input relation.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) The user provided schema.
    ///
    /// The Sever side will update the dataframe with this schema.
    #[prost(message, optional, tag = "2")]
    pub schema: ::core::option::Option<DataType>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RepartitionByExpression {
    /// (Required) The input relation.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) The partitioning expressions.
    #[prost(message, repeated, tag = "2")]
    pub partition_exprs: ::prost::alloc::vec::Vec<Expression>,
    /// (Optional) number of partitions, must be positive.
    #[prost(int32, optional, tag = "3")]
    pub num_partitions: ::core::option::Option<i32>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MapPartitions {
    /// (Required) Input relation for a mapPartitions-equivalent API: mapInPandas, mapInArrow.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) Input user-defined function.
    #[prost(message, optional, tag = "2")]
    pub func: ::core::option::Option<CommonInlineUserDefinedFunction>,
    /// (Optional) Whether to use barrier mode execution or not.
    #[prost(bool, optional, tag = "3")]
    pub is_barrier: ::core::option::Option<bool>,
    /// (Optional) ResourceProfile id used for the stage level scheduling.
    #[prost(int32, optional, tag = "4")]
    pub profile_id: ::core::option::Option<i32>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GroupMap {
    /// (Required) Input relation for Group Map API: apply, applyInPandas.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) Expressions for grouping keys.
    #[prost(message, repeated, tag = "2")]
    pub grouping_expressions: ::prost::alloc::vec::Vec<Expression>,
    /// (Required) Input user-defined function.
    #[prost(message, optional, tag = "3")]
    pub func: ::core::option::Option<CommonInlineUserDefinedFunction>,
    /// (Optional) Expressions for sorting. Only used by Scala Sorted Group Map API.
    #[prost(message, repeated, tag = "4")]
    pub sorting_expressions: ::prost::alloc::vec::Vec<Expression>,
    /// Below fields are only used by (Flat)MapGroupsWithState
    /// (Optional) Input relation for initial State.
    #[prost(message, optional, boxed, tag = "5")]
    pub initial_input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Optional) Expressions for grouping keys of the initial state input relation.
    #[prost(message, repeated, tag = "6")]
    pub initial_grouping_expressions: ::prost::alloc::vec::Vec<Expression>,
    /// (Optional) True if MapGroupsWithState, false if FlatMapGroupsWithState.
    #[prost(bool, optional, tag = "7")]
    pub is_map_groups_with_state: ::core::option::Option<bool>,
    /// (Optional) The output mode of the function.
    #[prost(string, optional, tag = "8")]
    pub output_mode: ::core::option::Option<::prost::alloc::string::String>,
    /// (Optional) Timeout configuration for groups that do not receive data for a while.
    #[prost(string, optional, tag = "9")]
    pub timeout_conf: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CoGroupMap {
    /// (Required) One input relation for CoGroup Map API - applyInPandas.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// Expressions for grouping keys of the first input relation.
    #[prost(message, repeated, tag = "2")]
    pub input_grouping_expressions: ::prost::alloc::vec::Vec<Expression>,
    /// (Required) The other input relation.
    #[prost(message, optional, boxed, tag = "3")]
    pub other: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// Expressions for grouping keys of the other input relation.
    #[prost(message, repeated, tag = "4")]
    pub other_grouping_expressions: ::prost::alloc::vec::Vec<Expression>,
    /// (Required) Input user-defined function.
    #[prost(message, optional, tag = "5")]
    pub func: ::core::option::Option<CommonInlineUserDefinedFunction>,
    /// (Optional) Expressions for sorting. Only used by Scala Sorted CoGroup Map API.
    #[prost(message, repeated, tag = "6")]
    pub input_sorting_expressions: ::prost::alloc::vec::Vec<Expression>,
    /// (Optional) Expressions for sorting. Only used by Scala Sorted CoGroup Map API.
    #[prost(message, repeated, tag = "7")]
    pub other_sorting_expressions: ::prost::alloc::vec::Vec<Expression>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ApplyInPandasWithState {
    /// (Required) Input relation for applyInPandasWithState.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) Expressions for grouping keys.
    #[prost(message, repeated, tag = "2")]
    pub grouping_expressions: ::prost::alloc::vec::Vec<Expression>,
    /// (Required) Input user-defined function.
    #[prost(message, optional, tag = "3")]
    pub func: ::core::option::Option<CommonInlineUserDefinedFunction>,
    /// (Required) Schema for the output DataFrame.
    #[prost(string, tag = "4")]
    pub output_schema: ::prost::alloc::string::String,
    /// (Required) Schema for the state.
    #[prost(string, tag = "5")]
    pub state_schema: ::prost::alloc::string::String,
    /// (Required) The output mode of the function.
    #[prost(string, tag = "6")]
    pub output_mode: ::prost::alloc::string::String,
    /// (Required) Timeout configuration for groups that do not receive data for a while.
    #[prost(string, tag = "7")]
    pub timeout_conf: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CommonInlineUserDefinedTableFunction {
    /// (Required) Name of the user-defined table function.
    #[prost(string, tag = "1")]
    pub function_name: ::prost::alloc::string::String,
    /// (Optional) Whether the user-defined table function is deterministic.
    #[prost(bool, tag = "2")]
    pub deterministic: bool,
    /// (Optional) Function input arguments. Empty arguments are allowed.
    #[prost(message, repeated, tag = "3")]
    pub arguments: ::prost::alloc::vec::Vec<Expression>,
    /// (Required) Type of the user-defined table function.
    #[prost(
        oneof = "common_inline_user_defined_table_function::Function",
        tags = "4"
    )]
    pub function: ::core::option::Option<common_inline_user_defined_table_function::Function>,
}
/// Nested message and enum types in `CommonInlineUserDefinedTableFunction`.
pub mod common_inline_user_defined_table_function {
    /// (Required) Type of the user-defined table function.
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Function {
        #[prost(message, tag = "4")]
        PythonUdtf(super::PythonUdtf),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PythonUdtf {
    /// (Optional) Return type of the Python UDTF.
    #[prost(message, optional, tag = "1")]
    pub return_type: ::core::option::Option<DataType>,
    /// (Required) EvalType of the Python UDTF.
    #[prost(int32, tag = "2")]
    pub eval_type: i32,
    /// (Required) The encoded commands of the Python UDTF.
    #[prost(bytes = "vec", tag = "3")]
    pub command: ::prost::alloc::vec::Vec<u8>,
    /// (Required) Python version being used in the client.
    #[prost(string, tag = "4")]
    pub python_ver: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CommonInlineUserDefinedDataSource {
    /// (Required) Name of the data source.
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
    /// (Required) The data source type.
    #[prost(
        oneof = "common_inline_user_defined_data_source::DataSource",
        tags = "2"
    )]
    pub data_source: ::core::option::Option<common_inline_user_defined_data_source::DataSource>,
}
/// Nested message and enum types in `CommonInlineUserDefinedDataSource`.
pub mod common_inline_user_defined_data_source {
    /// (Required) The data source type.
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum DataSource {
        #[prost(message, tag = "2")]
        PythonDataSource(super::PythonDataSource),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PythonDataSource {
    /// (Required) The encoded commands of the Python data source.
    #[prost(bytes = "vec", tag = "1")]
    pub command: ::prost::alloc::vec::Vec<u8>,
    /// (Required) Python version being used in the client.
    #[prost(string, tag = "2")]
    pub python_ver: ::prost::alloc::string::String,
}
/// Collect arbitrary (named) metrics from a dataset.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CollectMetrics {
    /// (Required) The input relation.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) Name of the metrics.
    #[prost(string, tag = "2")]
    pub name: ::prost::alloc::string::String,
    /// (Required) The metric sequence.
    #[prost(message, repeated, tag = "3")]
    pub metrics: ::prost::alloc::vec::Vec<Expression>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Parse {
    /// (Required) Input relation to Parse. The input is expected to have single text column.
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) The expected format of the text.
    #[prost(enumeration = "parse::ParseFormat", tag = "2")]
    pub format: i32,
    /// (Optional) DataType representing the schema. If not set, Spark will infer the schema.
    #[prost(message, optional, tag = "3")]
    pub schema: ::core::option::Option<DataType>,
    /// Options for the csv/json parser. The map key is case insensitive.
    #[prost(map = "string, string", tag = "4")]
    pub options:
        ::std::collections::HashMap<::prost::alloc::string::String, ::prost::alloc::string::String>,
}
/// Nested message and enum types in `Parse`.
pub mod parse {
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum ParseFormat {
        Unspecified = 0,
        Csv = 1,
        Json = 2,
    }
    impl ParseFormat {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::Unspecified => "PARSE_FORMAT_UNSPECIFIED",
                Self::Csv => "PARSE_FORMAT_CSV",
                Self::Json => "PARSE_FORMAT_JSON",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "PARSE_FORMAT_UNSPECIFIED" => Some(Self::Unspecified),
                "PARSE_FORMAT_CSV" => Some(Self::Csv),
                "PARSE_FORMAT_JSON" => Some(Self::Json),
                _ => None,
            }
        }
    }
}
/// Relation of type \[[AsOfJoin]\].
///
/// `left` and `right` must be present.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AsOfJoin {
    /// (Required) Left input relation for a Join.
    #[prost(message, optional, boxed, tag = "1")]
    pub left: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) Right input relation for a Join.
    #[prost(message, optional, boxed, tag = "2")]
    pub right: ::core::option::Option<::prost::alloc::boxed::Box<Relation>>,
    /// (Required) Field to join on in left DataFrame
    #[prost(message, optional, tag = "3")]
    pub left_as_of: ::core::option::Option<Expression>,
    /// (Required) Field to join on in right DataFrame
    #[prost(message, optional, tag = "4")]
    pub right_as_of: ::core::option::Option<Expression>,
    /// (Optional) The join condition. Could be unset when `using_columns` is utilized.
    ///
    /// This field does not co-exist with using_columns.
    #[prost(message, optional, tag = "5")]
    pub join_expr: ::core::option::Option<Expression>,
    /// Optional. using_columns provides a list of columns that should present on both sides of
    /// the join inputs that this Join will join on. For example A JOIN B USING col_name is
    /// equivalent to A JOIN B on A.col_name = B.col_name.
    ///
    /// This field does not co-exist with join_condition.
    #[prost(string, repeated, tag = "6")]
    pub using_columns: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// (Required) The join type.
    #[prost(string, tag = "7")]
    pub join_type: ::prost::alloc::string::String,
    /// (Optional) The asof tolerance within this range.
    #[prost(message, optional, tag = "8")]
    pub tolerance: ::core::option::Option<Expression>,
    /// (Required) Whether allow matching with the same value or not.
    #[prost(bool, tag = "9")]
    pub allow_exact_matches: bool,
    /// (Required) Whether to search for prior, subsequent, or closest matches.
    #[prost(string, tag = "10")]
    pub direction: ::prost::alloc::string::String,
}
/// A \[[Command]\] is an operation that is executed by the server that does not directly consume or
/// produce a relational result.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Command {
    #[prost(
        oneof = "command::CommandType",
        tags = "1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 999"
    )]
    pub command_type: ::core::option::Option<command::CommandType>,
}
/// Nested message and enum types in `Command`.
pub mod command {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum CommandType {
        #[prost(message, tag = "1")]
        RegisterFunction(super::CommonInlineUserDefinedFunction),
        #[prost(message, tag = "2")]
        WriteOperation(super::WriteOperation),
        #[prost(message, tag = "3")]
        CreateDataframeView(super::CreateDataFrameViewCommand),
        #[prost(message, tag = "4")]
        WriteOperationV2(super::WriteOperationV2),
        #[prost(message, tag = "5")]
        SqlCommand(super::SqlCommand),
        #[prost(message, tag = "6")]
        WriteStreamOperationStart(super::WriteStreamOperationStart),
        #[prost(message, tag = "7")]
        StreamingQueryCommand(super::StreamingQueryCommand),
        #[prost(message, tag = "8")]
        GetResourcesCommand(super::GetResourcesCommand),
        #[prost(message, tag = "9")]
        StreamingQueryManagerCommand(super::StreamingQueryManagerCommand),
        #[prost(message, tag = "10")]
        RegisterTableFunction(super::CommonInlineUserDefinedTableFunction),
        #[prost(message, tag = "11")]
        StreamingQueryListenerBusCommand(super::StreamingQueryListenerBusCommand),
        #[prost(message, tag = "12")]
        RegisterDataSource(super::CommonInlineUserDefinedDataSource),
        #[prost(message, tag = "13")]
        CreateResourceProfileCommand(super::CreateResourceProfileCommand),
        #[prost(message, tag = "14")]
        CheckpointCommand(super::CheckpointCommand),
        #[prost(message, tag = "15")]
        RemoveCachedRemoteRelationCommand(super::RemoveCachedRemoteRelationCommand),
        #[prost(message, tag = "16")]
        MergeIntoTableCommand(super::MergeIntoTableCommand),
        /// This field is used to mark extensions to the protocol. When plugins generate arbitrary
        /// Commands they can add them here. During the planning the correct resolution is done.
        #[prost(message, tag = "999")]
        Extension(::prost_types::Any),
    }
}
/// A SQL Command is used to trigger the eager evaluation of SQL commands in Spark.
///
/// When the SQL provide as part of the message is a command it will be immediately evaluated
/// and the result will be collected and returned as part of a LocalRelation. If the result is
/// not a command, the operation will simply return a SQL Relation. This allows the client to be
/// almost oblivious to the server-side behavior.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SqlCommand {
    /// (Required) SQL Query.
    #[deprecated]
    #[prost(string, tag = "1")]
    pub sql: ::prost::alloc::string::String,
    /// (Optional) A map of parameter names to literal expressions.
    #[prost(map = "string, message", tag = "2")]
    pub args: ::std::collections::HashMap<::prost::alloc::string::String, expression::Literal>,
    /// (Optional) A sequence of literal expressions for positional parameters in the SQL query text.
    #[deprecated]
    #[prost(message, repeated, tag = "3")]
    pub pos_args: ::prost::alloc::vec::Vec<expression::Literal>,
    /// (Optional) A map of parameter names to expressions.
    /// It cannot coexist with `pos_arguments`.
    #[prost(map = "string, message", tag = "4")]
    pub named_arguments: ::std::collections::HashMap<::prost::alloc::string::String, Expression>,
    /// (Optional) A sequence of expressions for positional parameters in the SQL query text.
    /// It cannot coexist with `named_arguments`.
    #[deprecated]
    #[prost(message, repeated, tag = "5")]
    pub pos_arguments: ::prost::alloc::vec::Vec<Expression>,
    /// (Optional) The relation that this SQL command will be built on.
    #[prost(message, optional, tag = "6")]
    pub input: ::core::option::Option<Relation>,
}
/// A command that can create DataFrame global temp view or local temp view.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CreateDataFrameViewCommand {
    /// (Required) The relation that this view will be built on.
    #[prost(message, optional, tag = "1")]
    pub input: ::core::option::Option<Relation>,
    /// (Required) View name.
    #[prost(string, tag = "2")]
    pub name: ::prost::alloc::string::String,
    /// (Required) Whether this is global temp view or local temp view.
    #[prost(bool, tag = "3")]
    pub is_global: bool,
    /// (Required)
    ///
    /// If true, and if the view already exists, updates it; if false, and if the view
    /// already exists, throws exception.
    #[prost(bool, tag = "4")]
    pub replace: bool,
}
/// As writes are not directly handled during analysis and planning, they are modeled as commands.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct WriteOperation {
    /// (Required) The output of the `input` relation will be persisted according to the options.
    #[prost(message, optional, tag = "1")]
    pub input: ::core::option::Option<Relation>,
    /// (Optional) Format value according to the Spark documentation. Examples are: text, parquet, delta.
    #[prost(string, optional, tag = "2")]
    pub source: ::core::option::Option<::prost::alloc::string::String>,
    /// (Required) the save mode.
    #[prost(enumeration = "write_operation::SaveMode", tag = "5")]
    pub mode: i32,
    /// (Optional) List of columns to sort the output by.
    #[prost(string, repeated, tag = "6")]
    pub sort_column_names: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// (Optional) List of columns for partitioning.
    #[prost(string, repeated, tag = "7")]
    pub partitioning_columns: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// (Optional) Bucketing specification. Bucketing must set the number of buckets and the columns
    /// to bucket by.
    #[prost(message, optional, tag = "8")]
    pub bucket_by: ::core::option::Option<write_operation::BucketBy>,
    /// (Optional) A list of configuration options.
    #[prost(map = "string, string", tag = "9")]
    pub options:
        ::std::collections::HashMap<::prost::alloc::string::String, ::prost::alloc::string::String>,
    /// (Optional) Columns used for clustering the table.
    #[prost(string, repeated, tag = "10")]
    pub clustering_columns: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// (Optional)
    ///
    /// The destination of the write operation can be either a path or a table.
    /// If the destination is neither a path nor a table, such as jdbc and noop,
    /// the `save_type` should not be set.
    #[prost(oneof = "write_operation::SaveType", tags = "3, 4")]
    pub save_type: ::core::option::Option<write_operation::SaveType>,
}
/// Nested message and enum types in `WriteOperation`.
pub mod write_operation {
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct SaveTable {
        /// (Required) The table name.
        #[prost(string, tag = "1")]
        pub table_name: ::prost::alloc::string::String,
        /// (Required) The method to be called to write to the table.
        #[prost(enumeration = "save_table::TableSaveMethod", tag = "2")]
        pub save_method: i32,
    }
    /// Nested message and enum types in `SaveTable`.
    pub mod save_table {
        #[derive(
            Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration,
        )]
        #[repr(i32)]
        pub enum TableSaveMethod {
            Unspecified = 0,
            SaveAsTable = 1,
            InsertInto = 2,
        }
        impl TableSaveMethod {
            /// String value of the enum field names used in the ProtoBuf definition.
            ///
            /// The values are not transformed in any way and thus are considered stable
            /// (if the ProtoBuf definition does not change) and safe for programmatic use.
            pub fn as_str_name(&self) -> &'static str {
                match self {
                    Self::Unspecified => "TABLE_SAVE_METHOD_UNSPECIFIED",
                    Self::SaveAsTable => "TABLE_SAVE_METHOD_SAVE_AS_TABLE",
                    Self::InsertInto => "TABLE_SAVE_METHOD_INSERT_INTO",
                }
            }
            /// Creates an enum from field names used in the ProtoBuf definition.
            pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
                match value {
                    "TABLE_SAVE_METHOD_UNSPECIFIED" => Some(Self::Unspecified),
                    "TABLE_SAVE_METHOD_SAVE_AS_TABLE" => Some(Self::SaveAsTable),
                    "TABLE_SAVE_METHOD_INSERT_INTO" => Some(Self::InsertInto),
                    _ => None,
                }
            }
        }
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct BucketBy {
        #[prost(string, repeated, tag = "1")]
        pub bucket_column_names: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
        #[prost(int32, tag = "2")]
        pub num_buckets: i32,
    }
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum SaveMode {
        Unspecified = 0,
        Append = 1,
        Overwrite = 2,
        ErrorIfExists = 3,
        Ignore = 4,
    }
    impl SaveMode {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::Unspecified => "SAVE_MODE_UNSPECIFIED",
                Self::Append => "SAVE_MODE_APPEND",
                Self::Overwrite => "SAVE_MODE_OVERWRITE",
                Self::ErrorIfExists => "SAVE_MODE_ERROR_IF_EXISTS",
                Self::Ignore => "SAVE_MODE_IGNORE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "SAVE_MODE_UNSPECIFIED" => Some(Self::Unspecified),
                "SAVE_MODE_APPEND" => Some(Self::Append),
                "SAVE_MODE_OVERWRITE" => Some(Self::Overwrite),
                "SAVE_MODE_ERROR_IF_EXISTS" => Some(Self::ErrorIfExists),
                "SAVE_MODE_IGNORE" => Some(Self::Ignore),
                _ => None,
            }
        }
    }
    /// (Optional)
    ///
    /// The destination of the write operation can be either a path or a table.
    /// If the destination is neither a path nor a table, such as jdbc and noop,
    /// the `save_type` should not be set.
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum SaveType {
        #[prost(string, tag = "3")]
        Path(::prost::alloc::string::String),
        #[prost(message, tag = "4")]
        Table(SaveTable),
    }
}
/// As writes are not directly handled during analysis and planning, they are modeled as commands.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct WriteOperationV2 {
    /// (Required) The output of the `input` relation will be persisted according to the options.
    #[prost(message, optional, tag = "1")]
    pub input: ::core::option::Option<Relation>,
    /// (Required) The destination of the write operation must be either a path or a table.
    #[prost(string, tag = "2")]
    pub table_name: ::prost::alloc::string::String,
    /// (Optional) A provider for the underlying output data source. Spark's default catalog supports
    /// "parquet", "json", etc.
    #[prost(string, optional, tag = "3")]
    pub provider: ::core::option::Option<::prost::alloc::string::String>,
    /// (Optional) List of columns for partitioning for output table created by `create`,
    /// `createOrReplace`, or `replace`
    #[prost(message, repeated, tag = "4")]
    pub partitioning_columns: ::prost::alloc::vec::Vec<Expression>,
    /// (Optional) A list of configuration options.
    #[prost(map = "string, string", tag = "5")]
    pub options:
        ::std::collections::HashMap<::prost::alloc::string::String, ::prost::alloc::string::String>,
    /// (Optional) A list of table properties.
    #[prost(map = "string, string", tag = "6")]
    pub table_properties:
        ::std::collections::HashMap<::prost::alloc::string::String, ::prost::alloc::string::String>,
    /// (Required) Write mode.
    #[prost(enumeration = "write_operation_v2::Mode", tag = "7")]
    pub mode: i32,
    /// (Optional) A condition for overwrite saving mode
    #[prost(message, optional, tag = "8")]
    pub overwrite_condition: ::core::option::Option<Expression>,
    /// (Optional) Columns used for clustering the table.
    #[prost(string, repeated, tag = "9")]
    pub clustering_columns: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// Nested message and enum types in `WriteOperationV2`.
pub mod write_operation_v2 {
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Mode {
        Unspecified = 0,
        Create = 1,
        Overwrite = 2,
        OverwritePartitions = 3,
        Append = 4,
        Replace = 5,
        CreateOrReplace = 6,
    }
    impl Mode {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::Unspecified => "MODE_UNSPECIFIED",
                Self::Create => "MODE_CREATE",
                Self::Overwrite => "MODE_OVERWRITE",
                Self::OverwritePartitions => "MODE_OVERWRITE_PARTITIONS",
                Self::Append => "MODE_APPEND",
                Self::Replace => "MODE_REPLACE",
                Self::CreateOrReplace => "MODE_CREATE_OR_REPLACE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "MODE_UNSPECIFIED" => Some(Self::Unspecified),
                "MODE_CREATE" => Some(Self::Create),
                "MODE_OVERWRITE" => Some(Self::Overwrite),
                "MODE_OVERWRITE_PARTITIONS" => Some(Self::OverwritePartitions),
                "MODE_APPEND" => Some(Self::Append),
                "MODE_REPLACE" => Some(Self::Replace),
                "MODE_CREATE_OR_REPLACE" => Some(Self::CreateOrReplace),
                _ => None,
            }
        }
    }
}
/// Starts write stream operation as streaming query. Query ID and Run ID of the streaming
/// query are returned.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct WriteStreamOperationStart {
    /// (Required) The output of the `input` streaming relation will be written.
    #[prost(message, optional, tag = "1")]
    pub input: ::core::option::Option<Relation>,
    #[prost(string, tag = "2")]
    pub format: ::prost::alloc::string::String,
    #[prost(map = "string, string", tag = "3")]
    pub options:
        ::std::collections::HashMap<::prost::alloc::string::String, ::prost::alloc::string::String>,
    #[prost(string, repeated, tag = "4")]
    pub partitioning_column_names: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(string, tag = "9")]
    pub output_mode: ::prost::alloc::string::String,
    #[prost(string, tag = "10")]
    pub query_name: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "13")]
    pub foreach_writer: ::core::option::Option<StreamingForeachFunction>,
    #[prost(message, optional, tag = "14")]
    pub foreach_batch: ::core::option::Option<StreamingForeachFunction>,
    /// (Optional) Columns used for clustering the table.
    #[prost(string, repeated, tag = "15")]
    pub clustering_column_names: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(oneof = "write_stream_operation_start::Trigger", tags = "5, 6, 7, 8")]
    pub trigger: ::core::option::Option<write_stream_operation_start::Trigger>,
    /// The destination is optional. When set, it can be a path or a table name.
    #[prost(
        oneof = "write_stream_operation_start::SinkDestination",
        tags = "11, 12"
    )]
    pub sink_destination: ::core::option::Option<write_stream_operation_start::SinkDestination>,
}
/// Nested message and enum types in `WriteStreamOperationStart`.
pub mod write_stream_operation_start {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Trigger {
        #[prost(string, tag = "5")]
        ProcessingTimeInterval(::prost::alloc::string::String),
        #[prost(bool, tag = "6")]
        AvailableNow(bool),
        #[prost(bool, tag = "7")]
        Once(bool),
        #[prost(string, tag = "8")]
        ContinuousCheckpointInterval(::prost::alloc::string::String),
    }
    /// The destination is optional. When set, it can be a path or a table name.
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum SinkDestination {
        #[prost(string, tag = "11")]
        Path(::prost::alloc::string::String),
        #[prost(string, tag = "12")]
        TableName(::prost::alloc::string::String),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StreamingForeachFunction {
    #[prost(oneof = "streaming_foreach_function::Function", tags = "1, 2")]
    pub function: ::core::option::Option<streaming_foreach_function::Function>,
}
/// Nested message and enum types in `StreamingForeachFunction`.
pub mod streaming_foreach_function {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Function {
        #[prost(message, tag = "1")]
        PythonFunction(super::PythonUdf),
        #[prost(message, tag = "2")]
        ScalaFunction(super::ScalarScalaUdf),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct WriteStreamOperationStartResult {
    /// (Required) Query instance. See `StreamingQueryInstanceId`.
    #[prost(message, optional, tag = "1")]
    pub query_id: ::core::option::Option<StreamingQueryInstanceId>,
    /// An optional query name.
    #[prost(string, tag = "2")]
    pub name: ::prost::alloc::string::String,
    /// Optional query started event if there is any listener registered on the client side.
    #[prost(string, optional, tag = "3")]
    pub query_started_event_json: ::core::option::Option<::prost::alloc::string::String>,
}
/// A tuple that uniquely identifies an instance of streaming query run. It consists of `id` that
/// persists across the streaming runs and `run_id` that changes between each run of the
/// streaming query that resumes from the checkpoint.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StreamingQueryInstanceId {
    /// (Required) The unique id of this query that persists across restarts from checkpoint data.
    /// That is, this id is generated when a query is started for the first time, and
    /// will be the same every time it is restarted from checkpoint data.
    #[prost(string, tag = "1")]
    pub id: ::prost::alloc::string::String,
    /// (Required) The unique id of this run of the query. That is, every start/restart of a query
    /// will generate a unique run_id. Therefore, every time a query is restarted from
    /// checkpoint, it will have the same `id` but different `run_id`s.
    #[prost(string, tag = "2")]
    pub run_id: ::prost::alloc::string::String,
}
/// Commands for a streaming query.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StreamingQueryCommand {
    /// (Required) Query instance. See `StreamingQueryInstanceId`.
    #[prost(message, optional, tag = "1")]
    pub query_id: ::core::option::Option<StreamingQueryInstanceId>,
    /// See documentation for the corresponding API method in StreamingQuery.
    #[prost(
        oneof = "streaming_query_command::Command",
        tags = "2, 3, 4, 5, 6, 7, 8, 9"
    )]
    pub command: ::core::option::Option<streaming_query_command::Command>,
}
/// Nested message and enum types in `StreamingQueryCommand`.
pub mod streaming_query_command {
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct ExplainCommand {
        /// TODO: Consider reusing Explain from AnalyzePlanRequest message.
        ///        We can not do this right now since it base.proto imports this file.
        #[prost(bool, tag = "1")]
        pub extended: bool,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct AwaitTerminationCommand {
        #[prost(int64, optional, tag = "2")]
        pub timeout_ms: ::core::option::Option<i64>,
    }
    /// See documentation for the corresponding API method in StreamingQuery.
    #[derive(Clone, Copy, PartialEq, ::prost::Oneof)]
    pub enum Command {
        /// status() API.
        #[prost(bool, tag = "2")]
        Status(bool),
        /// lastProgress() API.
        #[prost(bool, tag = "3")]
        LastProgress(bool),
        /// recentProgress() API.
        #[prost(bool, tag = "4")]
        RecentProgress(bool),
        /// stop() API. Stops the query.
        #[prost(bool, tag = "5")]
        Stop(bool),
        /// processAllAvailable() API. Waits till all the available data is processed
        #[prost(bool, tag = "6")]
        ProcessAllAvailable(bool),
        /// explain() API. Returns logical and physical plans.
        #[prost(message, tag = "7")]
        Explain(ExplainCommand),
        /// exception() API. Returns the exception in the query if any.
        #[prost(bool, tag = "8")]
        Exception(bool),
        /// awaitTermination() API. Waits for the termination of the query.
        #[prost(message, tag = "9")]
        AwaitTermination(AwaitTerminationCommand),
    }
}
/// Response for commands on a streaming query.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StreamingQueryCommandResult {
    /// (Required) Query instance id. See `StreamingQueryInstanceId`.
    #[prost(message, optional, tag = "1")]
    pub query_id: ::core::option::Option<StreamingQueryInstanceId>,
    #[prost(
        oneof = "streaming_query_command_result::ResultType",
        tags = "2, 3, 4, 5, 6"
    )]
    pub result_type: ::core::option::Option<streaming_query_command_result::ResultType>,
}
/// Nested message and enum types in `StreamingQueryCommandResult`.
pub mod streaming_query_command_result {
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct StatusResult {
        /// See documentation for these Scala 'StreamingQueryStatus' struct
        #[prost(string, tag = "1")]
        pub status_message: ::prost::alloc::string::String,
        #[prost(bool, tag = "2")]
        pub is_data_available: bool,
        #[prost(bool, tag = "3")]
        pub is_trigger_active: bool,
        #[prost(bool, tag = "4")]
        pub is_active: bool,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct RecentProgressResult {
        /// Progress reports as an array of json strings.
        #[prost(string, repeated, tag = "5")]
        pub recent_progress_json: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ExplainResult {
        /// Logical and physical plans as string
        #[prost(string, tag = "1")]
        pub result: ::prost::alloc::string::String,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ExceptionResult {
        /// (Optional) Exception message as string, maps to the return value of original
        /// StreamingQueryException's toString method
        #[prost(string, optional, tag = "1")]
        pub exception_message: ::core::option::Option<::prost::alloc::string::String>,
        /// (Optional) Exception error class as string
        #[prost(string, optional, tag = "2")]
        pub error_class: ::core::option::Option<::prost::alloc::string::String>,
        /// (Optional) Exception stack trace as string
        #[prost(string, optional, tag = "3")]
        pub stack_trace: ::core::option::Option<::prost::alloc::string::String>,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct AwaitTerminationResult {
        #[prost(bool, tag = "1")]
        pub terminated: bool,
    }
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum ResultType {
        #[prost(message, tag = "2")]
        Status(StatusResult),
        #[prost(message, tag = "3")]
        RecentProgress(RecentProgressResult),
        #[prost(message, tag = "4")]
        Explain(ExplainResult),
        #[prost(message, tag = "5")]
        Exception(ExceptionResult),
        #[prost(message, tag = "6")]
        AwaitTermination(AwaitTerminationResult),
    }
}
/// Commands for the streaming query manager.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StreamingQueryManagerCommand {
    /// See documentation for the corresponding API method in StreamingQueryManager.
    #[prost(
        oneof = "streaming_query_manager_command::Command",
        tags = "1, 2, 3, 4, 5, 6, 7"
    )]
    pub command: ::core::option::Option<streaming_query_manager_command::Command>,
}
/// Nested message and enum types in `StreamingQueryManagerCommand`.
pub mod streaming_query_manager_command {
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct AwaitAnyTerminationCommand {
        /// (Optional) The waiting time in milliseconds to wait for any query to terminate.
        #[prost(int64, optional, tag = "1")]
        pub timeout_ms: ::core::option::Option<i64>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct StreamingQueryListenerCommand {
        #[prost(bytes = "vec", tag = "1")]
        pub listener_payload: ::prost::alloc::vec::Vec<u8>,
        #[prost(message, optional, tag = "2")]
        pub python_listener_payload: ::core::option::Option<super::PythonUdf>,
        #[prost(string, tag = "3")]
        pub id: ::prost::alloc::string::String,
    }
    /// See documentation for the corresponding API method in StreamingQueryManager.
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Command {
        /// active() API, returns a list of active queries.
        #[prost(bool, tag = "1")]
        Active(bool),
        /// get() API, returns the StreamingQuery identified by id.
        #[prost(string, tag = "2")]
        GetQuery(::prost::alloc::string::String),
        /// awaitAnyTermination() API, wait until any query terminates or timeout.
        #[prost(message, tag = "3")]
        AwaitAnyTermination(AwaitAnyTerminationCommand),
        /// resetTerminated() API.
        #[prost(bool, tag = "4")]
        ResetTerminated(bool),
        /// addListener API.
        #[prost(message, tag = "5")]
        AddListener(StreamingQueryListenerCommand),
        /// removeListener API.
        #[prost(message, tag = "6")]
        RemoveListener(StreamingQueryListenerCommand),
        /// listListeners() API, returns a list of streaming query listeners.
        #[prost(bool, tag = "7")]
        ListListeners(bool),
    }
}
/// Response for commands on the streaming query manager.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StreamingQueryManagerCommandResult {
    #[prost(
        oneof = "streaming_query_manager_command_result::ResultType",
        tags = "1, 2, 3, 4, 5, 6, 7"
    )]
    pub result_type: ::core::option::Option<streaming_query_manager_command_result::ResultType>,
}
/// Nested message and enum types in `StreamingQueryManagerCommandResult`.
pub mod streaming_query_manager_command_result {
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ActiveResult {
        #[prost(message, repeated, tag = "1")]
        pub active_queries: ::prost::alloc::vec::Vec<StreamingQueryInstance>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct StreamingQueryInstance {
        /// (Required) The id and runId of this query.
        #[prost(message, optional, tag = "1")]
        pub id: ::core::option::Option<super::StreamingQueryInstanceId>,
        /// (Optional) The name of this query.
        #[prost(string, optional, tag = "2")]
        pub name: ::core::option::Option<::prost::alloc::string::String>,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct AwaitAnyTerminationResult {
        #[prost(bool, tag = "1")]
        pub terminated: bool,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct StreamingQueryListenerInstance {
        #[prost(bytes = "vec", tag = "1")]
        pub listener_payload: ::prost::alloc::vec::Vec<u8>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ListStreamingQueryListenerResult {
        /// (Required) Reference IDs of listener instances.
        #[prost(string, repeated, tag = "1")]
        pub listener_ids: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    }
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum ResultType {
        #[prost(message, tag = "1")]
        Active(ActiveResult),
        #[prost(message, tag = "2")]
        Query(StreamingQueryInstance),
        #[prost(message, tag = "3")]
        AwaitAnyTermination(AwaitAnyTerminationResult),
        #[prost(bool, tag = "4")]
        ResetTerminated(bool),
        #[prost(bool, tag = "5")]
        AddListener(bool),
        #[prost(bool, tag = "6")]
        RemoveListener(bool),
        #[prost(message, tag = "7")]
        ListListeners(ListStreamingQueryListenerResult),
    }
}
/// The protocol for client-side StreamingQueryListener.
/// This command will only be set when either the first listener is added to the client, or the last
/// listener is removed from the client.
/// The add_listener_bus_listener command will only be set true in the first case.
/// The remove_listener_bus_listener command will only be set true in the second case.
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct StreamingQueryListenerBusCommand {
    #[prost(oneof = "streaming_query_listener_bus_command::Command", tags = "1, 2")]
    pub command: ::core::option::Option<streaming_query_listener_bus_command::Command>,
}
/// Nested message and enum types in `StreamingQueryListenerBusCommand`.
pub mod streaming_query_listener_bus_command {
    #[derive(Clone, Copy, PartialEq, ::prost::Oneof)]
    pub enum Command {
        #[prost(bool, tag = "1")]
        AddListenerBusListener(bool),
        #[prost(bool, tag = "2")]
        RemoveListenerBusListener(bool),
    }
}
/// The protocol for the returned events in the long-running response channel.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StreamingQueryListenerEvent {
    /// (Required) The json serialized event, all StreamingQueryListener events have a json method
    #[prost(string, tag = "1")]
    pub event_json: ::prost::alloc::string::String,
    /// (Required) Query event type used by client to decide how to deserialize the event_json
    #[prost(enumeration = "StreamingQueryEventType", tag = "2")]
    pub event_type: i32,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StreamingQueryListenerEventsResult {
    #[prost(message, repeated, tag = "1")]
    pub events: ::prost::alloc::vec::Vec<StreamingQueryListenerEvent>,
    #[prost(bool, optional, tag = "2")]
    pub listener_bus_listener_added: ::core::option::Option<bool>,
}
/// Command to get the output of 'SparkContext.resources'
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct GetResourcesCommand {}
/// Response for command 'GetResourcesCommand'.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetResourcesCommandResult {
    #[prost(map = "string, message", tag = "1")]
    pub resources: ::std::collections::HashMap<::prost::alloc::string::String, ResourceInformation>,
}
/// Command to create ResourceProfile
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CreateResourceProfileCommand {
    /// (Required) The ResourceProfile to be built on the server-side.
    #[prost(message, optional, tag = "1")]
    pub profile: ::core::option::Option<ResourceProfile>,
}
/// Response for command 'CreateResourceProfileCommand'.
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct CreateResourceProfileCommandResult {
    /// (Required) Server-side generated resource profile id.
    #[prost(int32, tag = "1")]
    pub profile_id: i32,
}
/// Command to remove `CashedRemoteRelation`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RemoveCachedRemoteRelationCommand {
    /// (Required) The remote to be related
    #[prost(message, optional, tag = "1")]
    pub relation: ::core::option::Option<CachedRemoteRelation>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CheckpointCommand {
    /// (Required) The logical plan to checkpoint.
    #[prost(message, optional, tag = "1")]
    pub relation: ::core::option::Option<Relation>,
    /// (Required) Locally checkpoint using a local temporary
    /// directory in Spark Connect server (Spark Driver)
    #[prost(bool, tag = "2")]
    pub local: bool,
    /// (Required) Whether to checkpoint this dataframe immediately.
    #[prost(bool, tag = "3")]
    pub eager: bool,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MergeIntoTableCommand {
    /// (Required) The name of the target table.
    #[prost(string, tag = "1")]
    pub target_table_name: ::prost::alloc::string::String,
    /// (Required) The relation of the source table.
    #[prost(message, optional, tag = "2")]
    pub source_table_plan: ::core::option::Option<Relation>,
    /// (Required) The condition to match the source and target.
    #[prost(message, optional, tag = "3")]
    pub merge_condition: ::core::option::Option<Expression>,
    /// (Optional) The actions to be taken when the condition is matched.
    #[prost(message, repeated, tag = "4")]
    pub match_actions: ::prost::alloc::vec::Vec<Expression>,
    /// (Optional) The actions to be taken when the condition is not matched.
    #[prost(message, repeated, tag = "5")]
    pub not_matched_actions: ::prost::alloc::vec::Vec<Expression>,
    /// (Optional) The actions to be taken when the condition is not matched by source.
    #[prost(message, repeated, tag = "6")]
    pub not_matched_by_source_actions: ::prost::alloc::vec::Vec<Expression>,
    /// (Required) Whether to enable schema evolution.
    #[prost(bool, tag = "7")]
    pub with_schema_evolution: bool,
}
/// The enum used for client side streaming query listener event
/// There is no QueryStartedEvent defined here,
/// it is added as a field in WriteStreamOperationStartResult
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum StreamingQueryEventType {
    QueryProgressUnspecified = 0,
    QueryProgressEvent = 1,
    QueryTerminatedEvent = 2,
    QueryIdleEvent = 3,
}
impl StreamingQueryEventType {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::QueryProgressUnspecified => "QUERY_PROGRESS_UNSPECIFIED",
            Self::QueryProgressEvent => "QUERY_PROGRESS_EVENT",
            Self::QueryTerminatedEvent => "QUERY_TERMINATED_EVENT",
            Self::QueryIdleEvent => "QUERY_IDLE_EVENT",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "QUERY_PROGRESS_UNSPECIFIED" => Some(Self::QueryProgressUnspecified),
            "QUERY_PROGRESS_EVENT" => Some(Self::QueryProgressEvent),
            "QUERY_TERMINATED_EVENT" => Some(Self::QueryTerminatedEvent),
            "QUERY_IDLE_EVENT" => Some(Self::QueryIdleEvent),
            _ => None,
        }
    }
}
/// A \[[Plan]\] is the structure that carries the runtime information for the execution from the
/// client to the server. A \[[Plan]\] can either be of the type \[[Relation]\] which is a reference
/// to the underlying logical plan or it can be of the \[[Command]\] type that is used to execute
/// commands on the server.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Plan {
    #[prost(oneof = "plan::OpType", tags = "1, 2")]
    pub op_type: ::core::option::Option<plan::OpType>,
}
/// Nested message and enum types in `Plan`.
pub mod plan {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum OpType {
        #[prost(message, tag = "1")]
        Root(super::Relation),
        #[prost(message, tag = "2")]
        Command(super::Command),
    }
}
/// User Context is used to refer to one particular user session that is executing
/// queries in the backend.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct UserContext {
    #[prost(string, tag = "1")]
    pub user_id: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub user_name: ::prost::alloc::string::String,
    /// To extend the existing user context message that is used to identify incoming requests,
    /// Spark Connect leverages the Any protobuf type that can be used to inject arbitrary other
    /// messages into this message. Extensions are stored as a `repeated` type to be able to
    /// handle multiple active extensions.
    #[prost(message, repeated, tag = "999")]
    pub extensions: ::prost::alloc::vec::Vec<::prost_types::Any>,
}
/// Request to perform plan analyze, optionally to explain the plan.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AnalyzePlanRequest {
    /// (Required)
    ///
    /// The session_id specifies a spark session for a user id (which is specified
    /// by user_context.user_id). The session_id is set by the client to be able to
    /// collate streaming responses from different queries within the dedicated session.
    /// The id should be an UUID string of the format `00112233-4455-6677-8899-aabbccddeeff`
    #[prost(string, tag = "1")]
    pub session_id: ::prost::alloc::string::String,
    /// (Optional)
    ///
    /// Server-side generated idempotency key from the previous responses (if any). Server
    /// can use this to validate that the server side session has not changed.
    #[prost(string, optional, tag = "17")]
    pub client_observed_server_side_session_id:
        ::core::option::Option<::prost::alloc::string::String>,
    /// (Required) User context
    #[prost(message, optional, tag = "2")]
    pub user_context: ::core::option::Option<UserContext>,
    /// Provides optional information about the client sending the request. This field
    /// can be used for language or version specific information and is only intended for
    /// logging purposes and will not be interpreted by the server.
    #[prost(string, optional, tag = "3")]
    pub client_type: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(
        oneof = "analyze_plan_request::Analyze",
        tags = "4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16"
    )]
    pub analyze: ::core::option::Option<analyze_plan_request::Analyze>,
}
/// Nested message and enum types in `AnalyzePlanRequest`.
pub mod analyze_plan_request {
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Schema {
        /// (Required) The logical plan to be analyzed.
        #[prost(message, optional, tag = "1")]
        pub plan: ::core::option::Option<super::Plan>,
    }
    /// Explains the input plan based on a configurable mode.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Explain {
        /// (Required) The logical plan to be analyzed.
        #[prost(message, optional, tag = "1")]
        pub plan: ::core::option::Option<super::Plan>,
        /// (Required) For analyzePlan rpc calls, configure the mode to explain plan in strings.
        #[prost(enumeration = "explain::ExplainMode", tag = "2")]
        pub explain_mode: i32,
    }
    /// Nested message and enum types in `Explain`.
    pub mod explain {
        /// Plan explanation mode.
        #[derive(
            Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration,
        )]
        #[repr(i32)]
        pub enum ExplainMode {
            Unspecified = 0,
            /// Generates only physical plan.
            Simple = 1,
            /// Generates parsed logical plan, analyzed logical plan, optimized logical plan and physical plan.
            /// Parsed Logical plan is a unresolved plan that extracted from the query. Analyzed logical plans
            /// transforms which translates unresolvedAttribute and unresolvedRelation into fully typed objects.
            /// The optimized logical plan transforms through a set of optimization rules, resulting in the
            /// physical plan.
            Extended = 2,
            /// Generates code for the statement, if any and a physical plan.
            Codegen = 3,
            /// If plan node statistics are available, generates a logical plan and also the statistics.
            Cost = 4,
            /// Generates a physical plan outline and also node details.
            Formatted = 5,
        }
        impl ExplainMode {
            /// String value of the enum field names used in the ProtoBuf definition.
            ///
            /// The values are not transformed in any way and thus are considered stable
            /// (if the ProtoBuf definition does not change) and safe for programmatic use.
            pub fn as_str_name(&self) -> &'static str {
                match self {
                    Self::Unspecified => "EXPLAIN_MODE_UNSPECIFIED",
                    Self::Simple => "EXPLAIN_MODE_SIMPLE",
                    Self::Extended => "EXPLAIN_MODE_EXTENDED",
                    Self::Codegen => "EXPLAIN_MODE_CODEGEN",
                    Self::Cost => "EXPLAIN_MODE_COST",
                    Self::Formatted => "EXPLAIN_MODE_FORMATTED",
                }
            }
            /// Creates an enum from field names used in the ProtoBuf definition.
            pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
                match value {
                    "EXPLAIN_MODE_UNSPECIFIED" => Some(Self::Unspecified),
                    "EXPLAIN_MODE_SIMPLE" => Some(Self::Simple),
                    "EXPLAIN_MODE_EXTENDED" => Some(Self::Extended),
                    "EXPLAIN_MODE_CODEGEN" => Some(Self::Codegen),
                    "EXPLAIN_MODE_COST" => Some(Self::Cost),
                    "EXPLAIN_MODE_FORMATTED" => Some(Self::Formatted),
                    _ => None,
                }
            }
        }
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct TreeString {
        /// (Required) The logical plan to be analyzed.
        #[prost(message, optional, tag = "1")]
        pub plan: ::core::option::Option<super::Plan>,
        /// (Optional) Max level of the schema.
        #[prost(int32, optional, tag = "2")]
        pub level: ::core::option::Option<i32>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct IsLocal {
        /// (Required) The logical plan to be analyzed.
        #[prost(message, optional, tag = "1")]
        pub plan: ::core::option::Option<super::Plan>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct IsStreaming {
        /// (Required) The logical plan to be analyzed.
        #[prost(message, optional, tag = "1")]
        pub plan: ::core::option::Option<super::Plan>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct InputFiles {
        /// (Required) The logical plan to be analyzed.
        #[prost(message, optional, tag = "1")]
        pub plan: ::core::option::Option<super::Plan>,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct SparkVersion {}
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct DdlParse {
        /// (Required) The DDL formatted string to be parsed.
        #[prost(string, tag = "1")]
        pub ddl_string: ::prost::alloc::string::String,
    }
    /// Returns `true` when the logical query plans  are equal and therefore return same results.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct SameSemantics {
        /// (Required) The plan to be compared.
        #[prost(message, optional, tag = "1")]
        pub target_plan: ::core::option::Option<super::Plan>,
        /// (Required) The other plan to be compared.
        #[prost(message, optional, tag = "2")]
        pub other_plan: ::core::option::Option<super::Plan>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct SemanticHash {
        /// (Required) The logical plan to get a hashCode.
        #[prost(message, optional, tag = "1")]
        pub plan: ::core::option::Option<super::Plan>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Persist {
        /// (Required) The logical plan to persist.
        #[prost(message, optional, tag = "1")]
        pub relation: ::core::option::Option<super::Relation>,
        /// (Optional) The storage level.
        #[prost(message, optional, tag = "2")]
        pub storage_level: ::core::option::Option<super::StorageLevel>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Unpersist {
        /// (Required) The logical plan to unpersist.
        #[prost(message, optional, tag = "1")]
        pub relation: ::core::option::Option<super::Relation>,
        /// (Optional) Whether to block until all blocks are deleted.
        #[prost(bool, optional, tag = "2")]
        pub blocking: ::core::option::Option<bool>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct GetStorageLevel {
        /// (Required) The logical plan to get the storage level.
        #[prost(message, optional, tag = "1")]
        pub relation: ::core::option::Option<super::Relation>,
    }
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Analyze {
        #[prost(message, tag = "4")]
        Schema(Schema),
        #[prost(message, tag = "5")]
        Explain(Explain),
        #[prost(message, tag = "6")]
        TreeString(TreeString),
        #[prost(message, tag = "7")]
        IsLocal(IsLocal),
        #[prost(message, tag = "8")]
        IsStreaming(IsStreaming),
        #[prost(message, tag = "9")]
        InputFiles(InputFiles),
        #[prost(message, tag = "10")]
        SparkVersion(SparkVersion),
        #[prost(message, tag = "11")]
        DdlParse(DdlParse),
        #[prost(message, tag = "12")]
        SameSemantics(SameSemantics),
        #[prost(message, tag = "13")]
        SemanticHash(SemanticHash),
        #[prost(message, tag = "14")]
        Persist(Persist),
        #[prost(message, tag = "15")]
        Unpersist(Unpersist),
        #[prost(message, tag = "16")]
        GetStorageLevel(GetStorageLevel),
    }
}
/// Response to performing analysis of the query. Contains relevant metadata to be able to
/// reason about the performance.
/// Next ID: 16
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AnalyzePlanResponse {
    #[prost(string, tag = "1")]
    pub session_id: ::prost::alloc::string::String,
    /// Server-side generated idempotency key that the client can use to assert that the server side
    /// session has not changed.
    #[prost(string, tag = "15")]
    pub server_side_session_id: ::prost::alloc::string::String,
    #[prost(
        oneof = "analyze_plan_response::Result",
        tags = "2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14"
    )]
    pub result: ::core::option::Option<analyze_plan_response::Result>,
}
/// Nested message and enum types in `AnalyzePlanResponse`.
pub mod analyze_plan_response {
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Schema {
        #[prost(message, optional, tag = "1")]
        pub schema: ::core::option::Option<super::DataType>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Explain {
        #[prost(string, tag = "1")]
        pub explain_string: ::prost::alloc::string::String,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct TreeString {
        #[prost(string, tag = "1")]
        pub tree_string: ::prost::alloc::string::String,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct IsLocal {
        #[prost(bool, tag = "1")]
        pub is_local: bool,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct IsStreaming {
        #[prost(bool, tag = "1")]
        pub is_streaming: bool,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct InputFiles {
        /// A best-effort snapshot of the files that compose this Dataset
        #[prost(string, repeated, tag = "1")]
        pub files: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct SparkVersion {
        #[prost(string, tag = "1")]
        pub version: ::prost::alloc::string::String,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct DdlParse {
        #[prost(message, optional, tag = "1")]
        pub parsed: ::core::option::Option<super::DataType>,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct SameSemantics {
        #[prost(bool, tag = "1")]
        pub result: bool,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct SemanticHash {
        #[prost(int32, tag = "1")]
        pub result: i32,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Persist {}
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Unpersist {}
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct GetStorageLevel {
        /// (Required) The StorageLevel as a result of get_storage_level request.
        #[prost(message, optional, tag = "1")]
        pub storage_level: ::core::option::Option<super::StorageLevel>,
    }
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Result {
        #[prost(message, tag = "2")]
        Schema(Schema),
        #[prost(message, tag = "3")]
        Explain(Explain),
        #[prost(message, tag = "4")]
        TreeString(TreeString),
        #[prost(message, tag = "5")]
        IsLocal(IsLocal),
        #[prost(message, tag = "6")]
        IsStreaming(IsStreaming),
        #[prost(message, tag = "7")]
        InputFiles(InputFiles),
        #[prost(message, tag = "8")]
        SparkVersion(SparkVersion),
        #[prost(message, tag = "9")]
        DdlParse(DdlParse),
        #[prost(message, tag = "10")]
        SameSemantics(SameSemantics),
        #[prost(message, tag = "11")]
        SemanticHash(SemanticHash),
        #[prost(message, tag = "12")]
        Persist(Persist),
        #[prost(message, tag = "13")]
        Unpersist(Unpersist),
        #[prost(message, tag = "14")]
        GetStorageLevel(GetStorageLevel),
    }
}
/// A request to be executed by the service.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ExecutePlanRequest {
    /// (Required)
    ///
    /// The session_id specifies a spark session for a user id (which is specified
    /// by user_context.user_id). The session_id is set by the client to be able to
    /// collate streaming responses from different queries within the dedicated session.
    /// The id should be an UUID string of the format `00112233-4455-6677-8899-aabbccddeeff`
    #[prost(string, tag = "1")]
    pub session_id: ::prost::alloc::string::String,
    /// (Optional)
    ///
    /// Server-side generated idempotency key from the previous responses (if any). Server
    /// can use this to validate that the server side session has not changed.
    #[prost(string, optional, tag = "8")]
    pub client_observed_server_side_session_id:
        ::core::option::Option<::prost::alloc::string::String>,
    /// (Required) User context
    ///
    /// user_context.user_id and session+id both identify a unique remote spark session on the
    /// server side.
    #[prost(message, optional, tag = "2")]
    pub user_context: ::core::option::Option<UserContext>,
    /// (Optional)
    /// Provide an id for this request. If not provided, it will be generated by the server.
    /// It is returned in every ExecutePlanResponse.operation_id of the ExecutePlan response stream.
    /// The id must be an UUID string of the format `00112233-4455-6677-8899-aabbccddeeff`
    #[prost(string, optional, tag = "6")]
    pub operation_id: ::core::option::Option<::prost::alloc::string::String>,
    /// (Required) The logical plan to be executed / analyzed.
    #[prost(message, optional, tag = "3")]
    pub plan: ::core::option::Option<Plan>,
    /// Provides optional information about the client sending the request. This field
    /// can be used for language or version specific information and is only intended for
    /// logging purposes and will not be interpreted by the server.
    #[prost(string, optional, tag = "4")]
    pub client_type: ::core::option::Option<::prost::alloc::string::String>,
    /// Repeated element for options that can be passed to the request. This element is currently
    /// unused but allows to pass in an extension value used for arbitrary options.
    #[prost(message, repeated, tag = "5")]
    pub request_options: ::prost::alloc::vec::Vec<execute_plan_request::RequestOption>,
    /// Tags to tag the given execution with.
    /// Tags cannot contain ',' character and cannot be empty strings.
    /// Used by Interrupt with interrupt.tag.
    #[prost(string, repeated, tag = "7")]
    pub tags: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// Nested message and enum types in `ExecutePlanRequest`.
pub mod execute_plan_request {
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct RequestOption {
        #[prost(oneof = "request_option::RequestOption", tags = "1, 999")]
        pub request_option: ::core::option::Option<request_option::RequestOption>,
    }
    /// Nested message and enum types in `RequestOption`.
    pub mod request_option {
        #[derive(Clone, PartialEq, ::prost::Oneof)]
        pub enum RequestOption {
            #[prost(message, tag = "1")]
            ReattachOptions(super::super::ReattachOptions),
            /// Extension type for request options
            #[prost(message, tag = "999")]
            Extension(::prost_types::Any),
        }
    }
}
/// The response of a query, can be one or more for each request. Responses belonging to the
/// same input query, carry the same `session_id`.
/// Next ID: 17
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ExecutePlanResponse {
    #[prost(string, tag = "1")]
    pub session_id: ::prost::alloc::string::String,
    /// Server-side generated idempotency key that the client can use to assert that the server side
    /// session has not changed.
    #[prost(string, tag = "15")]
    pub server_side_session_id: ::prost::alloc::string::String,
    /// Identifies the ExecutePlan execution.
    /// If set by the client in ExecutePlanRequest.operationId, that value is returned.
    /// Otherwise generated by the server.
    /// It is an UUID string of the format `00112233-4455-6677-8899-aabbccddeeff`
    #[prost(string, tag = "12")]
    pub operation_id: ::prost::alloc::string::String,
    /// Identified the response in the stream.
    /// The id is an UUID string of the format `00112233-4455-6677-8899-aabbccddeeff`
    #[prost(string, tag = "13")]
    pub response_id: ::prost::alloc::string::String,
    /// Metrics for the query execution. Typically, this field is only present in the last
    /// batch of results and then represent the overall state of the query execution.
    #[prost(message, optional, tag = "4")]
    pub metrics: ::core::option::Option<execute_plan_response::Metrics>,
    /// The metrics observed during the execution of the query plan.
    #[prost(message, repeated, tag = "6")]
    pub observed_metrics: ::prost::alloc::vec::Vec<execute_plan_response::ObservedMetrics>,
    /// (Optional) The Spark schema. This field is available when `collect` is called.
    #[prost(message, optional, tag = "7")]
    pub schema: ::core::option::Option<DataType>,
    /// Union type for the different response messages.
    #[prost(
        oneof = "execute_plan_response::ResponseType",
        tags = "2, 5, 8, 9, 10, 11, 16, 14, 17, 18, 19, 999"
    )]
    pub response_type: ::core::option::Option<execute_plan_response::ResponseType>,
}
/// Nested message and enum types in `ExecutePlanResponse`.
pub mod execute_plan_response {
    /// A SQL command returns an opaque Relation that can be directly used as input for the next
    /// call.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct SqlCommandResult {
        #[prost(message, optional, tag = "1")]
        pub relation: ::core::option::Option<super::Relation>,
    }
    /// Batch results of metrics.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ArrowBatch {
        /// Count rows in `data`. Must match the number of rows inside `data`.
        #[prost(int64, tag = "1")]
        pub row_count: i64,
        /// Serialized Arrow data.
        #[prost(bytes = "vec", tag = "2")]
        pub data: ::prost::alloc::vec::Vec<u8>,
        /// If set, row offset of the start of this ArrowBatch in execution results.
        #[prost(int64, optional, tag = "3")]
        pub start_offset: ::core::option::Option<i64>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Metrics {
        #[prost(message, repeated, tag = "1")]
        pub metrics: ::prost::alloc::vec::Vec<metrics::MetricObject>,
    }
    /// Nested message and enum types in `Metrics`.
    pub mod metrics {
        #[derive(Clone, PartialEq, ::prost::Message)]
        pub struct MetricObject {
            #[prost(string, tag = "1")]
            pub name: ::prost::alloc::string::String,
            #[prost(int64, tag = "2")]
            pub plan_id: i64,
            #[prost(int64, tag = "3")]
            pub parent: i64,
            #[prost(map = "string, message", tag = "4")]
            pub execution_metrics:
                ::std::collections::HashMap<::prost::alloc::string::String, MetricValue>,
        }
        #[derive(Clone, PartialEq, ::prost::Message)]
        pub struct MetricValue {
            #[prost(string, tag = "1")]
            pub name: ::prost::alloc::string::String,
            #[prost(int64, tag = "2")]
            pub value: i64,
            #[prost(string, tag = "3")]
            pub metric_type: ::prost::alloc::string::String,
        }
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ObservedMetrics {
        #[prost(string, tag = "1")]
        pub name: ::prost::alloc::string::String,
        #[prost(message, repeated, tag = "2")]
        pub values: ::prost::alloc::vec::Vec<super::expression::Literal>,
        #[prost(string, repeated, tag = "3")]
        pub keys: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
        #[prost(int64, tag = "4")]
        pub plan_id: i64,
    }
    /// If present, in a reattachable execution this means that after server sends onComplete,
    /// the execution is complete. If the server sends onComplete without sending a ResultComplete,
    /// it means that there is more, and the client should use ReattachExecute RPC to continue.
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct ResultComplete {}
    /// This message is used to communicate progress about the query progress during the execution.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ExecutionProgress {
        /// Captures the progress of each individual stage.
        #[prost(message, repeated, tag = "1")]
        pub stages: ::prost::alloc::vec::Vec<execution_progress::StageInfo>,
        /// Captures the currently in progress tasks.
        #[prost(int64, tag = "2")]
        pub num_inflight_tasks: i64,
    }
    /// Nested message and enum types in `ExecutionProgress`.
    pub mod execution_progress {
        #[derive(Clone, Copy, PartialEq, ::prost::Message)]
        pub struct StageInfo {
            #[prost(int64, tag = "1")]
            pub stage_id: i64,
            #[prost(int64, tag = "2")]
            pub num_tasks: i64,
            #[prost(int64, tag = "3")]
            pub num_completed_tasks: i64,
            #[prost(int64, tag = "4")]
            pub input_bytes_read: i64,
            #[prost(bool, tag = "5")]
            pub done: bool,
        }
    }
    /// Union type for the different response messages.
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum ResponseType {
        #[prost(message, tag = "2")]
        ArrowBatch(ArrowBatch),
        /// Special case for executing SQL commands.
        #[prost(message, tag = "5")]
        SqlCommandResult(SqlCommandResult),
        /// Response for a streaming query.
        #[prost(message, tag = "8")]
        WriteStreamOperationStartResult(super::WriteStreamOperationStartResult),
        /// Response for commands on a streaming query.
        #[prost(message, tag = "9")]
        StreamingQueryCommandResult(super::StreamingQueryCommandResult),
        /// Response for 'SparkContext.resources'.
        #[prost(message, tag = "10")]
        GetResourcesCommandResult(super::GetResourcesCommandResult),
        /// Response for commands on the streaming query manager.
        #[prost(message, tag = "11")]
        StreamingQueryManagerCommandResult(super::StreamingQueryManagerCommandResult),
        /// Response for commands on the client side streaming query listener.
        #[prost(message, tag = "16")]
        StreamingQueryListenerEventsResult(super::StreamingQueryListenerEventsResult),
        /// Response type informing if the stream is complete in reattachable execution.
        #[prost(message, tag = "14")]
        ResultComplete(ResultComplete),
        /// Response for command that creates ResourceProfile.
        #[prost(message, tag = "17")]
        CreateResourceProfileCommandResult(super::CreateResourceProfileCommandResult),
        /// (Optional) Intermediate query progress reports.
        #[prost(message, tag = "18")]
        ExecutionProgress(ExecutionProgress),
        /// Response for command that checkpoints a DataFrame.
        #[prost(message, tag = "19")]
        CheckpointCommandResult(super::CheckpointCommandResult),
        /// Support arbitrary result objects.
        #[prost(message, tag = "999")]
        Extension(::prost_types::Any),
    }
}
/// The key-value pair for the config request and response.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct KeyValue {
    /// (Required) The key.
    #[prost(string, tag = "1")]
    pub key: ::prost::alloc::string::String,
    /// (Optional) The value.
    #[prost(string, optional, tag = "2")]
    pub value: ::core::option::Option<::prost::alloc::string::String>,
}
/// Request to update or fetch the configurations.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ConfigRequest {
    /// (Required)
    ///
    /// The session_id specifies a spark session for a user id (which is specified
    /// by user_context.user_id). The session_id is set by the client to be able to
    /// collate streaming responses from different queries within the dedicated session.
    /// The id should be an UUID string of the format `00112233-4455-6677-8899-aabbccddeeff`
    #[prost(string, tag = "1")]
    pub session_id: ::prost::alloc::string::String,
    /// (Optional)
    ///
    /// Server-side generated idempotency key from the previous responses (if any). Server
    /// can use this to validate that the server side session has not changed.
    #[prost(string, optional, tag = "8")]
    pub client_observed_server_side_session_id:
        ::core::option::Option<::prost::alloc::string::String>,
    /// (Required) User context
    #[prost(message, optional, tag = "2")]
    pub user_context: ::core::option::Option<UserContext>,
    /// (Required) The operation for the config.
    #[prost(message, optional, tag = "3")]
    pub operation: ::core::option::Option<config_request::Operation>,
    /// Provides optional information about the client sending the request. This field
    /// can be used for language or version specific information and is only intended for
    /// logging purposes and will not be interpreted by the server.
    #[prost(string, optional, tag = "4")]
    pub client_type: ::core::option::Option<::prost::alloc::string::String>,
}
/// Nested message and enum types in `ConfigRequest`.
pub mod config_request {
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Operation {
        #[prost(oneof = "operation::OpType", tags = "1, 2, 3, 4, 5, 6, 7")]
        pub op_type: ::core::option::Option<operation::OpType>,
    }
    /// Nested message and enum types in `Operation`.
    pub mod operation {
        #[derive(Clone, PartialEq, ::prost::Oneof)]
        pub enum OpType {
            #[prost(message, tag = "1")]
            Set(super::Set),
            #[prost(message, tag = "2")]
            Get(super::Get),
            #[prost(message, tag = "3")]
            GetWithDefault(super::GetWithDefault),
            #[prost(message, tag = "4")]
            GetOption(super::GetOption),
            #[prost(message, tag = "5")]
            GetAll(super::GetAll),
            #[prost(message, tag = "6")]
            Unset(super::Unset),
            #[prost(message, tag = "7")]
            IsModifiable(super::IsModifiable),
        }
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Set {
        /// (Required) The config key-value pairs to set.
        #[prost(message, repeated, tag = "1")]
        pub pairs: ::prost::alloc::vec::Vec<super::KeyValue>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Get {
        /// (Required) The config keys to get.
        #[prost(string, repeated, tag = "1")]
        pub keys: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct GetWithDefault {
        /// (Required) The config key-value pairs to get. The value will be used as the default value.
        #[prost(message, repeated, tag = "1")]
        pub pairs: ::prost::alloc::vec::Vec<super::KeyValue>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct GetOption {
        /// (Required) The config keys to get optionally.
        #[prost(string, repeated, tag = "1")]
        pub keys: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct GetAll {
        /// (Optional) The prefix of the config key to get.
        #[prost(string, optional, tag = "1")]
        pub prefix: ::core::option::Option<::prost::alloc::string::String>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Unset {
        /// (Required) The config keys to unset.
        #[prost(string, repeated, tag = "1")]
        pub keys: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct IsModifiable {
        /// (Required) The config keys to check the config is modifiable.
        #[prost(string, repeated, tag = "1")]
        pub keys: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    }
}
/// Response to the config request.
/// Next ID: 5
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ConfigResponse {
    #[prost(string, tag = "1")]
    pub session_id: ::prost::alloc::string::String,
    /// Server-side generated idempotency key that the client can use to assert that the server side
    /// session has not changed.
    #[prost(string, tag = "4")]
    pub server_side_session_id: ::prost::alloc::string::String,
    /// (Optional) The result key-value pairs.
    ///
    /// Available when the operation is 'Get', 'GetWithDefault', 'GetOption', 'GetAll'.
    /// Also available for the operation 'IsModifiable' with boolean string "true" and "false".
    #[prost(message, repeated, tag = "2")]
    pub pairs: ::prost::alloc::vec::Vec<KeyValue>,
    /// (Optional)
    ///
    /// Warning messages for deprecated or unsupported configurations.
    #[prost(string, repeated, tag = "3")]
    pub warnings: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// Request to transfer client-local artifacts.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AddArtifactsRequest {
    /// (Required)
    ///
    /// The session_id specifies a spark session for a user id (which is specified
    /// by user_context.user_id). The session_id is set by the client to be able to
    /// collate streaming responses from different queries within the dedicated session.
    /// The id should be an UUID string of the format `00112233-4455-6677-8899-aabbccddeeff`
    #[prost(string, tag = "1")]
    pub session_id: ::prost::alloc::string::String,
    /// User context
    #[prost(message, optional, tag = "2")]
    pub user_context: ::core::option::Option<UserContext>,
    /// (Optional)
    ///
    /// Server-side generated idempotency key from the previous responses (if any). Server
    /// can use this to validate that the server side session has not changed.
    #[prost(string, optional, tag = "7")]
    pub client_observed_server_side_session_id:
        ::core::option::Option<::prost::alloc::string::String>,
    /// Provides optional information about the client sending the request. This field
    /// can be used for language or version specific information and is only intended for
    /// logging purposes and will not be interpreted by the server.
    #[prost(string, optional, tag = "6")]
    pub client_type: ::core::option::Option<::prost::alloc::string::String>,
    /// The payload is either a batch of artifacts or a partial chunk of a large artifact.
    #[prost(oneof = "add_artifacts_request::Payload", tags = "3, 4, 5")]
    pub payload: ::core::option::Option<add_artifacts_request::Payload>,
}
/// Nested message and enum types in `AddArtifactsRequest`.
pub mod add_artifacts_request {
    /// A chunk of an Artifact.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ArtifactChunk {
        /// Data chunk.
        #[prost(bytes = "vec", tag = "1")]
        pub data: ::prost::alloc::vec::Vec<u8>,
        /// CRC to allow server to verify integrity of the chunk.
        #[prost(int64, tag = "2")]
        pub crc: i64,
    }
    /// An artifact that is contained in a single `ArtifactChunk`.
    /// Generally, this message represents tiny artifacts such as REPL-generated class files.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct SingleChunkArtifact {
        /// The name of the artifact is expected in the form of a "Relative Path" that is made up of a
        /// sequence of directories and the final file element.
        /// Examples of "Relative Path"s: "jars/test.jar", "classes/xyz.class", "abc.xyz", "a/b/X.jar".
        /// The server is expected to maintain the hierarchy of files as defined by their name. (i.e
        /// The relative path of the file on the server's filesystem will be the same as the name of
        /// the provided artifact)
        #[prost(string, tag = "1")]
        pub name: ::prost::alloc::string::String,
        /// A single data chunk.
        #[prost(message, optional, tag = "2")]
        pub data: ::core::option::Option<ArtifactChunk>,
    }
    /// A number of `SingleChunkArtifact` batched into a single RPC.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Batch {
        #[prost(message, repeated, tag = "1")]
        pub artifacts: ::prost::alloc::vec::Vec<SingleChunkArtifact>,
    }
    /// Signals the beginning/start of a chunked artifact.
    /// A large artifact is transferred through a payload of `BeginChunkedArtifact` followed by a
    /// sequence of `ArtifactChunk`s.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct BeginChunkedArtifact {
        /// Name of the artifact undergoing chunking. Follows the same conventions as the `name` in
        /// the `Artifact` message.
        #[prost(string, tag = "1")]
        pub name: ::prost::alloc::string::String,
        /// Total size of the artifact in bytes.
        #[prost(int64, tag = "2")]
        pub total_bytes: i64,
        /// Number of chunks the artifact is split into.
        /// This includes the `initial_chunk`.
        #[prost(int64, tag = "3")]
        pub num_chunks: i64,
        /// The first/initial chunk.
        #[prost(message, optional, tag = "4")]
        pub initial_chunk: ::core::option::Option<ArtifactChunk>,
    }
    /// The payload is either a batch of artifacts or a partial chunk of a large artifact.
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Payload {
        #[prost(message, tag = "3")]
        Batch(Batch),
        /// The metadata and the initial chunk of a large artifact chunked into multiple requests.
        /// The server side is notified about the total size of the large artifact as well as the
        /// number of chunks to expect.
        #[prost(message, tag = "4")]
        BeginChunk(BeginChunkedArtifact),
        /// A chunk of an artifact excluding metadata. This can be any chunk of a large artifact
        /// excluding the first chunk (which is included in `BeginChunkedArtifact`).
        #[prost(message, tag = "5")]
        Chunk(ArtifactChunk),
    }
}
/// Response to adding an artifact. Contains relevant metadata to verify successful transfer of
/// artifact(s).
/// Next ID: 4
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AddArtifactsResponse {
    /// Session id in which the AddArtifact was running.
    #[prost(string, tag = "2")]
    pub session_id: ::prost::alloc::string::String,
    /// Server-side generated idempotency key that the client can use to assert that the server side
    /// session has not changed.
    #[prost(string, tag = "3")]
    pub server_side_session_id: ::prost::alloc::string::String,
    /// The list of artifact(s) seen by the server.
    #[prost(message, repeated, tag = "1")]
    pub artifacts: ::prost::alloc::vec::Vec<add_artifacts_response::ArtifactSummary>,
}
/// Nested message and enum types in `AddArtifactsResponse`.
pub mod add_artifacts_response {
    /// Metadata of an artifact.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ArtifactSummary {
        #[prost(string, tag = "1")]
        pub name: ::prost::alloc::string::String,
        /// Whether the CRC (Cyclic Redundancy Check) is successful on server verification.
        /// The server discards any artifact that fails the CRC.
        /// If false, the client may choose to resend the artifact specified by `name`.
        #[prost(bool, tag = "2")]
        pub is_crc_successful: bool,
    }
}
/// Request to get current statuses of artifacts at the server side.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ArtifactStatusesRequest {
    /// (Required)
    ///
    /// The session_id specifies a spark session for a user id (which is specified
    /// by user_context.user_id). The session_id is set by the client to be able to
    /// collate streaming responses from different queries within the dedicated session.
    /// The id should be an UUID string of the format `00112233-4455-6677-8899-aabbccddeeff`
    #[prost(string, tag = "1")]
    pub session_id: ::prost::alloc::string::String,
    /// (Optional)
    ///
    /// Server-side generated idempotency key from the previous responses (if any). Server
    /// can use this to validate that the server side session has not changed.
    #[prost(string, optional, tag = "5")]
    pub client_observed_server_side_session_id:
        ::core::option::Option<::prost::alloc::string::String>,
    /// User context
    #[prost(message, optional, tag = "2")]
    pub user_context: ::core::option::Option<UserContext>,
    /// Provides optional information about the client sending the request. This field
    /// can be used for language or version specific information and is only intended for
    /// logging purposes and will not be interpreted by the server.
    #[prost(string, optional, tag = "3")]
    pub client_type: ::core::option::Option<::prost::alloc::string::String>,
    /// The name of the artifact is expected in the form of a "Relative Path" that is made up of a
    /// sequence of directories and the final file element.
    /// Examples of "Relative Path"s: "jars/test.jar", "classes/xyz.class", "abc.xyz", "a/b/X.jar".
    /// The server is expected to maintain the hierarchy of files as defined by their name. (i.e
    /// The relative path of the file on the server's filesystem will be the same as the name of
    /// the provided artifact)
    #[prost(string, repeated, tag = "4")]
    pub names: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// Response to checking artifact statuses.
/// Next ID: 4
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ArtifactStatusesResponse {
    /// Session id in which the ArtifactStatus was running.
    #[prost(string, tag = "2")]
    pub session_id: ::prost::alloc::string::String,
    /// Server-side generated idempotency key that the client can use to assert that the server side
    /// session has not changed.
    #[prost(string, tag = "3")]
    pub server_side_session_id: ::prost::alloc::string::String,
    /// A map of artifact names to their statuses.
    #[prost(map = "string, message", tag = "1")]
    pub statuses: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        artifact_statuses_response::ArtifactStatus,
    >,
}
/// Nested message and enum types in `ArtifactStatusesResponse`.
pub mod artifact_statuses_response {
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct ArtifactStatus {
        /// Exists or not particular artifact at the server.
        #[prost(bool, tag = "1")]
        pub exists: bool,
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InterruptRequest {
    /// (Required)
    ///
    /// The session_id specifies a spark session for a user id (which is specified
    /// by user_context.user_id). The session_id is set by the client to be able to
    /// collate streaming responses from different queries within the dedicated session.
    /// The id should be an UUID string of the format `00112233-4455-6677-8899-aabbccddeeff`
    #[prost(string, tag = "1")]
    pub session_id: ::prost::alloc::string::String,
    /// (Optional)
    ///
    /// Server-side generated idempotency key from the previous responses (if any). Server
    /// can use this to validate that the server side session has not changed.
    #[prost(string, optional, tag = "7")]
    pub client_observed_server_side_session_id:
        ::core::option::Option<::prost::alloc::string::String>,
    /// (Required) User context
    #[prost(message, optional, tag = "2")]
    pub user_context: ::core::option::Option<UserContext>,
    /// Provides optional information about the client sending the request. This field
    /// can be used for language or version specific information and is only intended for
    /// logging purposes and will not be interpreted by the server.
    #[prost(string, optional, tag = "3")]
    pub client_type: ::core::option::Option<::prost::alloc::string::String>,
    /// (Required) The type of interrupt to execute.
    #[prost(enumeration = "interrupt_request::InterruptType", tag = "4")]
    pub interrupt_type: i32,
    #[prost(oneof = "interrupt_request::Interrupt", tags = "5, 6")]
    pub interrupt: ::core::option::Option<interrupt_request::Interrupt>,
}
/// Nested message and enum types in `InterruptRequest`.
pub mod interrupt_request {
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum InterruptType {
        Unspecified = 0,
        /// Interrupt all running executions within the session with the provided session_id.
        All = 1,
        /// Interrupt all running executions within the session with the provided operation_tag.
        Tag = 2,
        /// Interrupt the running execution within the session with the provided operation_id.
        OperationId = 3,
    }
    impl InterruptType {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::Unspecified => "INTERRUPT_TYPE_UNSPECIFIED",
                Self::All => "INTERRUPT_TYPE_ALL",
                Self::Tag => "INTERRUPT_TYPE_TAG",
                Self::OperationId => "INTERRUPT_TYPE_OPERATION_ID",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "INTERRUPT_TYPE_UNSPECIFIED" => Some(Self::Unspecified),
                "INTERRUPT_TYPE_ALL" => Some(Self::All),
                "INTERRUPT_TYPE_TAG" => Some(Self::Tag),
                "INTERRUPT_TYPE_OPERATION_ID" => Some(Self::OperationId),
                _ => None,
            }
        }
    }
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Interrupt {
        /// if interrupt_tag == INTERRUPT_TYPE_TAG, interrupt operation with this tag.
        #[prost(string, tag = "5")]
        OperationTag(::prost::alloc::string::String),
        /// if interrupt_tag == INTERRUPT_TYPE_OPERATION_ID, interrupt operation with this operation_id.
        #[prost(string, tag = "6")]
        OperationId(::prost::alloc::string::String),
    }
}
/// Next ID: 4
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InterruptResponse {
    /// Session id in which the interrupt was running.
    #[prost(string, tag = "1")]
    pub session_id: ::prost::alloc::string::String,
    /// Server-side generated idempotency key that the client can use to assert that the server side
    /// session has not changed.
    #[prost(string, tag = "3")]
    pub server_side_session_id: ::prost::alloc::string::String,
    /// Operation ids of the executions which were interrupted.
    #[prost(string, repeated, tag = "2")]
    pub interrupted_ids: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct ReattachOptions {
    /// If true, the request can be reattached to using ReattachExecute.
    /// ReattachExecute can be used either if the stream broke with a GRPC network error,
    /// or if the server closed the stream without sending a response with StreamStatus.complete=true.
    /// The server will keep a buffer of responses in case a response is lost, and
    /// ReattachExecute needs to back-track.
    ///
    /// If false, the execution response stream will will not be reattachable, and all responses are
    /// immediately released by the server after being sent.
    #[prost(bool, tag = "1")]
    pub reattachable: bool,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ReattachExecuteRequest {
    /// (Required)
    ///
    /// The session_id of the request to reattach to.
    /// This must be an id of existing session.
    #[prost(string, tag = "1")]
    pub session_id: ::prost::alloc::string::String,
    /// (Optional)
    ///
    /// Server-side generated idempotency key from the previous responses (if any). Server
    /// can use this to validate that the server side session has not changed.
    #[prost(string, optional, tag = "6")]
    pub client_observed_server_side_session_id:
        ::core::option::Option<::prost::alloc::string::String>,
    /// (Required) User context
    ///
    /// user_context.user_id and session+id both identify a unique remote spark session on the
    /// server side.
    #[prost(message, optional, tag = "2")]
    pub user_context: ::core::option::Option<UserContext>,
    /// (Required)
    /// Provide an id of the request to reattach to.
    /// This must be an id of existing operation.
    #[prost(string, tag = "3")]
    pub operation_id: ::prost::alloc::string::String,
    /// Provides optional information about the client sending the request. This field
    /// can be used for language or version specific information and is only intended for
    /// logging purposes and will not be interpreted by the server.
    #[prost(string, optional, tag = "4")]
    pub client_type: ::core::option::Option<::prost::alloc::string::String>,
    /// (Optional)
    /// Last already processed response id from the response stream.
    /// After reattach, server will resume the response stream after that response.
    /// If not specified, server will restart the stream from the start.
    ///
    /// Note: server controls the amount of responses that it buffers and it may drop responses,
    /// that are far behind the latest returned response, so this can't be used to arbitrarily
    /// scroll back the cursor. If the response is no longer available, this will result in an error.
    #[prost(string, optional, tag = "5")]
    pub last_response_id: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ReleaseExecuteRequest {
    /// (Required)
    ///
    /// The session_id of the request to reattach to.
    /// This must be an id of existing session.
    #[prost(string, tag = "1")]
    pub session_id: ::prost::alloc::string::String,
    /// (Optional)
    ///
    /// Server-side generated idempotency key from the previous responses (if any). Server
    /// can use this to validate that the server side session has not changed.
    #[prost(string, optional, tag = "7")]
    pub client_observed_server_side_session_id:
        ::core::option::Option<::prost::alloc::string::String>,
    /// (Required) User context
    ///
    /// user_context.user_id and session+id both identify a unique remote spark session on the
    /// server side.
    #[prost(message, optional, tag = "2")]
    pub user_context: ::core::option::Option<UserContext>,
    /// (Required)
    /// Provide an id of the request to reattach to.
    /// This must be an id of existing operation.
    #[prost(string, tag = "3")]
    pub operation_id: ::prost::alloc::string::String,
    /// Provides optional information about the client sending the request. This field
    /// can be used for language or version specific information and is only intended for
    /// logging purposes and will not be interpreted by the server.
    #[prost(string, optional, tag = "4")]
    pub client_type: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(oneof = "release_execute_request::Release", tags = "5, 6")]
    pub release: ::core::option::Option<release_execute_request::Release>,
}
/// Nested message and enum types in `ReleaseExecuteRequest`.
pub mod release_execute_request {
    /// Release and close operation completely.
    /// This will also interrupt the query if it is running execution, and wait for it to be torn down.
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct ReleaseAll {}
    /// Release all responses from the operation response stream up to and including
    /// the response with the given by response_id.
    /// While server determines by itself how much of a buffer of responses to keep, client providing
    /// explicit release calls will help reduce resource consumption.
    /// Noop if response_id not found in cached responses.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ReleaseUntil {
        #[prost(string, tag = "1")]
        pub response_id: ::prost::alloc::string::String,
    }
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Release {
        #[prost(message, tag = "5")]
        ReleaseAll(ReleaseAll),
        #[prost(message, tag = "6")]
        ReleaseUntil(ReleaseUntil),
    }
}
/// Next ID: 4
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ReleaseExecuteResponse {
    /// Session id in which the release was running.
    #[prost(string, tag = "1")]
    pub session_id: ::prost::alloc::string::String,
    /// Server-side generated idempotency key that the client can use to assert that the server side
    /// session has not changed.
    #[prost(string, tag = "3")]
    pub server_side_session_id: ::prost::alloc::string::String,
    /// Operation id of the operation on which the release executed.
    /// If the operation couldn't be found (because e.g. it was concurrently released), will be unset.
    /// Otherwise, it will be equal to the operation_id from request.
    #[prost(string, optional, tag = "2")]
    pub operation_id: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ReleaseSessionRequest {
    /// (Required)
    ///
    /// The session_id of the request to reattach to.
    /// This must be an id of existing session.
    #[prost(string, tag = "1")]
    pub session_id: ::prost::alloc::string::String,
    /// (Required) User context
    ///
    /// user_context.user_id and session+id both identify a unique remote spark session on the
    /// server side.
    #[prost(message, optional, tag = "2")]
    pub user_context: ::core::option::Option<UserContext>,
    /// Provides optional information about the client sending the request. This field
    /// can be used for language or version specific information and is only intended for
    /// logging purposes and will not be interpreted by the server.
    #[prost(string, optional, tag = "3")]
    pub client_type: ::core::option::Option<::prost::alloc::string::String>,
}
/// Next ID: 3
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ReleaseSessionResponse {
    /// Session id of the session on which the release executed.
    #[prost(string, tag = "1")]
    pub session_id: ::prost::alloc::string::String,
    /// Server-side generated idempotency key that the client can use to assert that the server side
    /// session has not changed.
    #[prost(string, tag = "2")]
    pub server_side_session_id: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FetchErrorDetailsRequest {
    /// (Required)
    /// The session_id specifies a Spark session for a user identified by user_context.user_id.
    /// The id should be a UUID string of the format `00112233-4455-6677-8899-aabbccddeeff`.
    #[prost(string, tag = "1")]
    pub session_id: ::prost::alloc::string::String,
    /// (Optional)
    ///
    /// Server-side generated idempotency key from the previous responses (if any). Server
    /// can use this to validate that the server side session has not changed.
    #[prost(string, optional, tag = "5")]
    pub client_observed_server_side_session_id:
        ::core::option::Option<::prost::alloc::string::String>,
    /// User context
    #[prost(message, optional, tag = "2")]
    pub user_context: ::core::option::Option<UserContext>,
    /// (Required)
    /// The id of the error.
    #[prost(string, tag = "3")]
    pub error_id: ::prost::alloc::string::String,
    /// Provides optional information about the client sending the request. This field
    /// can be used for language or version specific information and is only intended for
    /// logging purposes and will not be interpreted by the server.
    #[prost(string, optional, tag = "4")]
    pub client_type: ::core::option::Option<::prost::alloc::string::String>,
}
/// Next ID: 5
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FetchErrorDetailsResponse {
    /// Server-side generated idempotency key that the client can use to assert that the server side
    /// session has not changed.
    #[prost(string, tag = "3")]
    pub server_side_session_id: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub session_id: ::prost::alloc::string::String,
    /// The index of the root error in errors. The field will not be set if the error is not found.
    #[prost(int32, optional, tag = "1")]
    pub root_error_idx: ::core::option::Option<i32>,
    /// A list of errors.
    #[prost(message, repeated, tag = "2")]
    pub errors: ::prost::alloc::vec::Vec<fetch_error_details_response::Error>,
}
/// Nested message and enum types in `FetchErrorDetailsResponse`.
pub mod fetch_error_details_response {
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct StackTraceElement {
        /// The fully qualified name of the class containing the execution point.
        #[prost(string, tag = "1")]
        pub declaring_class: ::prost::alloc::string::String,
        /// The name of the method containing the execution point.
        #[prost(string, tag = "2")]
        pub method_name: ::prost::alloc::string::String,
        /// The name of the file containing the execution point.
        #[prost(string, optional, tag = "3")]
        pub file_name: ::core::option::Option<::prost::alloc::string::String>,
        /// The line number of the source line containing the execution point.
        #[prost(int32, tag = "4")]
        pub line_number: i32,
    }
    /// QueryContext defines the schema for the query context of a SparkThrowable.
    /// It helps users understand where the error occurs while executing queries.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct QueryContext {
        #[prost(enumeration = "query_context::ContextType", tag = "10")]
        pub context_type: i32,
        /// The object type of the query which throws the exception.
        /// If the exception is directly from the main query, it should be an empty string.
        /// Otherwise, it should be the exact object type in upper case. For example, a "VIEW".
        #[prost(string, tag = "1")]
        pub object_type: ::prost::alloc::string::String,
        /// The object name of the query which throws the exception.
        /// If the exception is directly from the main query, it should be an empty string.
        /// Otherwise, it should be the object name. For example, a view name "V1".
        #[prost(string, tag = "2")]
        pub object_name: ::prost::alloc::string::String,
        /// The starting index in the query text which throws the exception. The index starts from 0.
        #[prost(int32, tag = "3")]
        pub start_index: i32,
        /// The stopping index in the query which throws the exception. The index starts from 0.
        #[prost(int32, tag = "4")]
        pub stop_index: i32,
        /// The corresponding fragment of the query which throws the exception.
        #[prost(string, tag = "5")]
        pub fragment: ::prost::alloc::string::String,
        /// The user code (call site of the API) that caused throwing the exception.
        #[prost(string, tag = "6")]
        pub call_site: ::prost::alloc::string::String,
        /// Summary of the exception cause.
        #[prost(string, tag = "7")]
        pub summary: ::prost::alloc::string::String,
    }
    /// Nested message and enum types in `QueryContext`.
    pub mod query_context {
        /// The type of this query context.
        #[derive(
            Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration,
        )]
        #[repr(i32)]
        pub enum ContextType {
            Sql = 0,
            Dataframe = 1,
        }
        impl ContextType {
            /// String value of the enum field names used in the ProtoBuf definition.
            ///
            /// The values are not transformed in any way and thus are considered stable
            /// (if the ProtoBuf definition does not change) and safe for programmatic use.
            pub fn as_str_name(&self) -> &'static str {
                match self {
                    Self::Sql => "SQL",
                    Self::Dataframe => "DATAFRAME",
                }
            }
            /// Creates an enum from field names used in the ProtoBuf definition.
            pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
                match value {
                    "SQL" => Some(Self::Sql),
                    "DATAFRAME" => Some(Self::Dataframe),
                    _ => None,
                }
            }
        }
    }
    /// SparkThrowable defines the schema for SparkThrowable exceptions.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct SparkThrowable {
        /// Succinct, human-readable, unique, and consistent representation of the error category.
        #[prost(string, optional, tag = "1")]
        pub error_class: ::core::option::Option<::prost::alloc::string::String>,
        /// The message parameters for the error framework.
        #[prost(map = "string, string", tag = "2")]
        pub message_parameters: ::std::collections::HashMap<
            ::prost::alloc::string::String,
            ::prost::alloc::string::String,
        >,
        /// The query context of a SparkThrowable.
        #[prost(message, repeated, tag = "3")]
        pub query_contexts: ::prost::alloc::vec::Vec<QueryContext>,
        /// Portable error identifier across SQL engines
        /// If null, error class or SQLSTATE is not set.
        #[prost(string, optional, tag = "4")]
        pub sql_state: ::core::option::Option<::prost::alloc::string::String>,
    }
    /// Error defines the schema for the representing exception.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Error {
        /// The fully qualified names of the exception class and its parent classes.
        #[prost(string, repeated, tag = "1")]
        pub error_type_hierarchy: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
        /// The detailed message of the exception.
        #[prost(string, tag = "2")]
        pub message: ::prost::alloc::string::String,
        /// The stackTrace of the exception. It will be set
        /// if the SQLConf spark.sql.connect.serverStacktrace.enabled is true.
        #[prost(message, repeated, tag = "3")]
        pub stack_trace: ::prost::alloc::vec::Vec<StackTraceElement>,
        /// The index of the cause error in errors.
        #[prost(int32, optional, tag = "4")]
        pub cause_idx: ::core::option::Option<i32>,
        /// The structured data of a SparkThrowable exception.
        #[prost(message, optional, tag = "5")]
        pub spark_throwable: ::core::option::Option<SparkThrowable>,
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CheckpointCommandResult {
    /// (Required) The logical plan checkpointed.
    #[prost(message, optional, tag = "1")]
    pub relation: ::core::option::Option<CachedRemoteRelation>,
}
/// Generated client implementations.
pub mod spark_connect_service_client {
    #![allow(
        unused_variables,
        dead_code,
        missing_docs,
        clippy::wildcard_imports,
        clippy::let_unit_value
    )]
    use tonic::codegen::{http::Uri, *};
    /// Main interface for the SparkConnect service.
    #[derive(Debug, Clone)]
    pub struct SparkConnectServiceClient<T> {
        inner: tonic::client::Grpc<T>,
    }
    impl SparkConnectServiceClient<tonic::transport::Channel> {
        /// Attempt to create a new client by connecting to a given endpoint.
        pub async fn connect<D>(dst: D) -> Result<Self, tonic::transport::Error>
        where
            D: TryInto<tonic::transport::Endpoint>,
            D::Error: Into<StdError>,
        {
            let conn = tonic::transport::Endpoint::new(dst)?.connect().await?;
            Ok(Self::new(conn))
        }
    }
    impl<T> SparkConnectServiceClient<T>
    where
        T: tonic::client::GrpcService<tonic::body::BoxBody>,
        T::Error: Into<StdError>,
        T::ResponseBody: Body<Data = Bytes> + std::marker::Send + 'static,
        <T::ResponseBody as Body>::Error: Into<StdError> + std::marker::Send,
    {
        pub fn new(inner: T) -> Self {
            let inner = tonic::client::Grpc::new(inner);
            Self { inner }
        }
        pub fn with_origin(inner: T, origin: Uri) -> Self {
            let inner = tonic::client::Grpc::with_origin(inner, origin);
            Self { inner }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> SparkConnectServiceClient<InterceptedService<T, F>>
        where
            F: tonic::service::Interceptor,
            T::ResponseBody: Default,
            T: tonic::codegen::Service<
                    http::Request<tonic::body::BoxBody>,
                    Response = http::Response<
                        <T as tonic::client::GrpcService<tonic::body::BoxBody>>::ResponseBody,
                    >,
                >,
            <T as tonic::codegen::Service<http::Request<tonic::body::BoxBody>>>::Error:
                Into<StdError> + std::marker::Send + std::marker::Sync,
        {
            SparkConnectServiceClient::new(InterceptedService::new(inner, interceptor))
        }
        /// Compress requests with the given encoding.
        ///
        /// This requires the server to support it otherwise it might respond with an
        /// error.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.send_compressed(encoding);
            self
        }
        /// Enable decompressing responses.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.accept_compressed(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_decoding_message_size(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_encoding_message_size(limit);
            self
        }
        /// Executes a request that contains the query and returns a stream of [[Response]].
        ///
        /// It is guaranteed that there is at least one ARROW batch returned even if the result set is empty.
        pub async fn execute_plan(
            &mut self,
            request: impl tonic::IntoRequest<super::ExecutePlanRequest>,
        ) -> std::result::Result<
            tonic::Response<tonic::codec::Streaming<super::ExecutePlanResponse>>,
            tonic::Status,
        > {
            self.inner.ready().await.map_err(|e| {
                tonic::Status::unknown(format!("Service was not ready: {}", e.into()))
            })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/spark.connect.SparkConnectService/ExecutePlan",
            );
            let mut req = request.into_request();
            req.extensions_mut().insert(GrpcMethod::new(
                "spark.connect.SparkConnectService",
                "ExecutePlan",
            ));
            self.inner.server_streaming(req, path, codec).await
        }
        /// Analyzes a query and returns a [[AnalyzeResponse]] containing metadata about the query.
        pub async fn analyze_plan(
            &mut self,
            request: impl tonic::IntoRequest<super::AnalyzePlanRequest>,
        ) -> std::result::Result<tonic::Response<super::AnalyzePlanResponse>, tonic::Status>
        {
            self.inner.ready().await.map_err(|e| {
                tonic::Status::unknown(format!("Service was not ready: {}", e.into()))
            })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/spark.connect.SparkConnectService/AnalyzePlan",
            );
            let mut req = request.into_request();
            req.extensions_mut().insert(GrpcMethod::new(
                "spark.connect.SparkConnectService",
                "AnalyzePlan",
            ));
            self.inner.unary(req, path, codec).await
        }
        /// Update or fetch the configurations and returns a [[ConfigResponse]] containing the result.
        pub async fn config(
            &mut self,
            request: impl tonic::IntoRequest<super::ConfigRequest>,
        ) -> std::result::Result<tonic::Response<super::ConfigResponse>, tonic::Status> {
            self.inner.ready().await.map_err(|e| {
                tonic::Status::unknown(format!("Service was not ready: {}", e.into()))
            })?;
            let codec = tonic::codec::ProstCodec::default();
            let path =
                http::uri::PathAndQuery::from_static("/spark.connect.SparkConnectService/Config");
            let mut req = request.into_request();
            req.extensions_mut().insert(GrpcMethod::new(
                "spark.connect.SparkConnectService",
                "Config",
            ));
            self.inner.unary(req, path, codec).await
        }
        /// Add artifacts to the session and returns a [[AddArtifactsResponse]] containing metadata about
        /// the added artifacts.
        pub async fn add_artifacts(
            &mut self,
            request: impl tonic::IntoStreamingRequest<Message = super::AddArtifactsRequest>,
        ) -> std::result::Result<tonic::Response<super::AddArtifactsResponse>, tonic::Status>
        {
            self.inner.ready().await.map_err(|e| {
                tonic::Status::unknown(format!("Service was not ready: {}", e.into()))
            })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/spark.connect.SparkConnectService/AddArtifacts",
            );
            let mut req = request.into_streaming_request();
            req.extensions_mut().insert(GrpcMethod::new(
                "spark.connect.SparkConnectService",
                "AddArtifacts",
            ));
            self.inner.client_streaming(req, path, codec).await
        }
        /// Check statuses of artifacts in the session and returns them in a [[ArtifactStatusesResponse]]
        pub async fn artifact_status(
            &mut self,
            request: impl tonic::IntoRequest<super::ArtifactStatusesRequest>,
        ) -> std::result::Result<tonic::Response<super::ArtifactStatusesResponse>, tonic::Status>
        {
            self.inner.ready().await.map_err(|e| {
                tonic::Status::unknown(format!("Service was not ready: {}", e.into()))
            })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/spark.connect.SparkConnectService/ArtifactStatus",
            );
            let mut req = request.into_request();
            req.extensions_mut().insert(GrpcMethod::new(
                "spark.connect.SparkConnectService",
                "ArtifactStatus",
            ));
            self.inner.unary(req, path, codec).await
        }
        /// Interrupts running executions
        pub async fn interrupt(
            &mut self,
            request: impl tonic::IntoRequest<super::InterruptRequest>,
        ) -> std::result::Result<tonic::Response<super::InterruptResponse>, tonic::Status> {
            self.inner.ready().await.map_err(|e| {
                tonic::Status::unknown(format!("Service was not ready: {}", e.into()))
            })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/spark.connect.SparkConnectService/Interrupt",
            );
            let mut req = request.into_request();
            req.extensions_mut().insert(GrpcMethod::new(
                "spark.connect.SparkConnectService",
                "Interrupt",
            ));
            self.inner.unary(req, path, codec).await
        }
        /// Reattach to an existing reattachable execution.
        /// The ExecutePlan must have been started with ReattachOptions.reattachable=true.
        /// If the ExecutePlanResponse stream ends without a ResultComplete message, there is more to
        /// continue. If there is a ResultComplete, the client should use ReleaseExecute with
        pub async fn reattach_execute(
            &mut self,
            request: impl tonic::IntoRequest<super::ReattachExecuteRequest>,
        ) -> std::result::Result<
            tonic::Response<tonic::codec::Streaming<super::ExecutePlanResponse>>,
            tonic::Status,
        > {
            self.inner.ready().await.map_err(|e| {
                tonic::Status::unknown(format!("Service was not ready: {}", e.into()))
            })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/spark.connect.SparkConnectService/ReattachExecute",
            );
            let mut req = request.into_request();
            req.extensions_mut().insert(GrpcMethod::new(
                "spark.connect.SparkConnectService",
                "ReattachExecute",
            ));
            self.inner.server_streaming(req, path, codec).await
        }
        /// Release an reattachable execution, or parts thereof.
        /// The ExecutePlan must have been started with ReattachOptions.reattachable=true.
        /// Non reattachable executions are released automatically and immediately after the ExecutePlan
        /// RPC and ReleaseExecute may not be used.
        pub async fn release_execute(
            &mut self,
            request: impl tonic::IntoRequest<super::ReleaseExecuteRequest>,
        ) -> std::result::Result<tonic::Response<super::ReleaseExecuteResponse>, tonic::Status>
        {
            self.inner.ready().await.map_err(|e| {
                tonic::Status::unknown(format!("Service was not ready: {}", e.into()))
            })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/spark.connect.SparkConnectService/ReleaseExecute",
            );
            let mut req = request.into_request();
            req.extensions_mut().insert(GrpcMethod::new(
                "spark.connect.SparkConnectService",
                "ReleaseExecute",
            ));
            self.inner.unary(req, path, codec).await
        }
        /// Release a session.
        /// All the executions in the session will be released. Any further requests for the session with
        /// that session_id for the given user_id will fail. If the session didn't exist or was already
        /// released, this is a noop.
        pub async fn release_session(
            &mut self,
            request: impl tonic::IntoRequest<super::ReleaseSessionRequest>,
        ) -> std::result::Result<tonic::Response<super::ReleaseSessionResponse>, tonic::Status>
        {
            self.inner.ready().await.map_err(|e| {
                tonic::Status::unknown(format!("Service was not ready: {}", e.into()))
            })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/spark.connect.SparkConnectService/ReleaseSession",
            );
            let mut req = request.into_request();
            req.extensions_mut().insert(GrpcMethod::new(
                "spark.connect.SparkConnectService",
                "ReleaseSession",
            ));
            self.inner.unary(req, path, codec).await
        }
        /// FetchErrorDetails retrieves the matched exception with details based on a provided error id.
        pub async fn fetch_error_details(
            &mut self,
            request: impl tonic::IntoRequest<super::FetchErrorDetailsRequest>,
        ) -> std::result::Result<tonic::Response<super::FetchErrorDetailsResponse>, tonic::Status>
        {
            self.inner.ready().await.map_err(|e| {
                tonic::Status::unknown(format!("Service was not ready: {}", e.into()))
            })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/spark.connect.SparkConnectService/FetchErrorDetails",
            );
            let mut req = request.into_request();
            req.extensions_mut().insert(GrpcMethod::new(
                "spark.connect.SparkConnectService",
                "FetchErrorDetails",
            ));
            self.inner.unary(req, path, codec).await
        }
    }
}
/// Generated server implementations.
pub mod spark_connect_service_server {
    #![allow(
        unused_variables,
        dead_code,
        missing_docs,
        clippy::wildcard_imports,
        clippy::let_unit_value
    )]
    use tonic::codegen::*;
    /// Generated trait containing gRPC methods that should be implemented for use with SparkConnectServiceServer.
    #[async_trait]
    pub trait SparkConnectService: std::marker::Send + std::marker::Sync + 'static {
        /// Server streaming response type for the ExecutePlan method.
        type ExecutePlanStream: tonic::codegen::tokio_stream::Stream<
                Item = std::result::Result<super::ExecutePlanResponse, tonic::Status>,
            > + std::marker::Send
            + 'static;
        /// Executes a request that contains the query and returns a stream of [[Response]].
        ///
        /// It is guaranteed that there is at least one ARROW batch returned even if the result set is empty.
        async fn execute_plan(
            &self,
            request: tonic::Request<super::ExecutePlanRequest>,
        ) -> std::result::Result<tonic::Response<Self::ExecutePlanStream>, tonic::Status>;
        /// Analyzes a query and returns a [[AnalyzeResponse]] containing metadata about the query.
        async fn analyze_plan(
            &self,
            request: tonic::Request<super::AnalyzePlanRequest>,
        ) -> std::result::Result<tonic::Response<super::AnalyzePlanResponse>, tonic::Status>;
        /// Update or fetch the configurations and returns a [[ConfigResponse]] containing the result.
        async fn config(
            &self,
            request: tonic::Request<super::ConfigRequest>,
        ) -> std::result::Result<tonic::Response<super::ConfigResponse>, tonic::Status>;
        /// Add artifacts to the session and returns a [[AddArtifactsResponse]] containing metadata about
        /// the added artifacts.
        async fn add_artifacts(
            &self,
            request: tonic::Request<tonic::Streaming<super::AddArtifactsRequest>>,
        ) -> std::result::Result<tonic::Response<super::AddArtifactsResponse>, tonic::Status>;
        /// Check statuses of artifacts in the session and returns them in a [[ArtifactStatusesResponse]]
        async fn artifact_status(
            &self,
            request: tonic::Request<super::ArtifactStatusesRequest>,
        ) -> std::result::Result<tonic::Response<super::ArtifactStatusesResponse>, tonic::Status>;
        /// Interrupts running executions
        async fn interrupt(
            &self,
            request: tonic::Request<super::InterruptRequest>,
        ) -> std::result::Result<tonic::Response<super::InterruptResponse>, tonic::Status>;
        /// Server streaming response type for the ReattachExecute method.
        type ReattachExecuteStream: tonic::codegen::tokio_stream::Stream<
                Item = std::result::Result<super::ExecutePlanResponse, tonic::Status>,
            > + std::marker::Send
            + 'static;
        /// Reattach to an existing reattachable execution.
        /// The ExecutePlan must have been started with ReattachOptions.reattachable=true.
        /// If the ExecutePlanResponse stream ends without a ResultComplete message, there is more to
        /// continue. If there is a ResultComplete, the client should use ReleaseExecute with
        async fn reattach_execute(
            &self,
            request: tonic::Request<super::ReattachExecuteRequest>,
        ) -> std::result::Result<tonic::Response<Self::ReattachExecuteStream>, tonic::Status>;
        /// Release an reattachable execution, or parts thereof.
        /// The ExecutePlan must have been started with ReattachOptions.reattachable=true.
        /// Non reattachable executions are released automatically and immediately after the ExecutePlan
        /// RPC and ReleaseExecute may not be used.
        async fn release_execute(
            &self,
            request: tonic::Request<super::ReleaseExecuteRequest>,
        ) -> std::result::Result<tonic::Response<super::ReleaseExecuteResponse>, tonic::Status>;
        /// Release a session.
        /// All the executions in the session will be released. Any further requests for the session with
        /// that session_id for the given user_id will fail. If the session didn't exist or was already
        /// released, this is a noop.
        async fn release_session(
            &self,
            request: tonic::Request<super::ReleaseSessionRequest>,
        ) -> std::result::Result<tonic::Response<super::ReleaseSessionResponse>, tonic::Status>;
        /// FetchErrorDetails retrieves the matched exception with details based on a provided error id.
        async fn fetch_error_details(
            &self,
            request: tonic::Request<super::FetchErrorDetailsRequest>,
        ) -> std::result::Result<tonic::Response<super::FetchErrorDetailsResponse>, tonic::Status>;
    }
    /// Main interface for the SparkConnect service.
    #[derive(Debug)]
    pub struct SparkConnectServiceServer<T> {
        inner: Arc<T>,
        accept_compression_encodings: EnabledCompressionEncodings,
        send_compression_encodings: EnabledCompressionEncodings,
        max_decoding_message_size: Option<usize>,
        max_encoding_message_size: Option<usize>,
    }
    impl<T> SparkConnectServiceServer<T> {
        pub fn new(inner: T) -> Self {
            Self::from_arc(Arc::new(inner))
        }
        pub fn from_arc(inner: Arc<T>) -> Self {
            Self {
                inner,
                accept_compression_encodings: Default::default(),
                send_compression_encodings: Default::default(),
                max_decoding_message_size: None,
                max_encoding_message_size: None,
            }
        }
        pub fn with_interceptor<F>(inner: T, interceptor: F) -> InterceptedService<Self, F>
        where
            F: tonic::service::Interceptor,
        {
            InterceptedService::new(Self::new(inner), interceptor)
        }
        /// Enable decompressing requests with the given encoding.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.accept_compression_encodings.enable(encoding);
            self
        }
        /// Compress responses with the given encoding, if the client supports it.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.send_compression_encodings.enable(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.max_decoding_message_size = Some(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.max_encoding_message_size = Some(limit);
            self
        }
    }
    impl<T, B> tonic::codegen::Service<http::Request<B>> for SparkConnectServiceServer<T>
    where
        T: SparkConnectService,
        B: Body + std::marker::Send + 'static,
        B::Error: Into<StdError> + std::marker::Send + 'static,
    {
        type Response = http::Response<tonic::body::BoxBody>;
        type Error = std::convert::Infallible;
        type Future = BoxFuture<Self::Response, Self::Error>;
        fn poll_ready(
            &mut self,
            _cx: &mut Context<'_>,
        ) -> Poll<std::result::Result<(), Self::Error>> {
            Poll::Ready(Ok(()))
        }
        fn call(&mut self, req: http::Request<B>) -> Self::Future {
            match req.uri().path() {
                "/spark.connect.SparkConnectService/ExecutePlan" => {
                    #[allow(non_camel_case_types)]
                    struct ExecutePlanSvc<T: SparkConnectService>(pub Arc<T>);
                    impl<T: SparkConnectService>
                        tonic::server::ServerStreamingService<super::ExecutePlanRequest>
                        for ExecutePlanSvc<T>
                    {
                        type Response = super::ExecutePlanResponse;
                        type ResponseStream = T::ExecutePlanStream;
                        type Future =
                            BoxFuture<tonic::Response<Self::ResponseStream>, tonic::Status>;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::ExecutePlanRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as SparkConnectService>::execute_plan(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = ExecutePlanSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.server_streaming(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/spark.connect.SparkConnectService/AnalyzePlan" => {
                    #[allow(non_camel_case_types)]
                    struct AnalyzePlanSvc<T: SparkConnectService>(pub Arc<T>);
                    impl<T: SparkConnectService>
                        tonic::server::UnaryService<super::AnalyzePlanRequest>
                        for AnalyzePlanSvc<T>
                    {
                        type Response = super::AnalyzePlanResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::AnalyzePlanRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as SparkConnectService>::analyze_plan(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = AnalyzePlanSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/spark.connect.SparkConnectService/Config" => {
                    #[allow(non_camel_case_types)]
                    struct ConfigSvc<T: SparkConnectService>(pub Arc<T>);
                    impl<T: SparkConnectService> tonic::server::UnaryService<super::ConfigRequest> for ConfigSvc<T> {
                        type Response = super::ConfigResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::ConfigRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as SparkConnectService>::config(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = ConfigSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/spark.connect.SparkConnectService/AddArtifacts" => {
                    #[allow(non_camel_case_types)]
                    struct AddArtifactsSvc<T: SparkConnectService>(pub Arc<T>);
                    impl<T: SparkConnectService>
                        tonic::server::ClientStreamingService<super::AddArtifactsRequest>
                        for AddArtifactsSvc<T>
                    {
                        type Response = super::AddArtifactsResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(
                            &mut self,
                            request: tonic::Request<tonic::Streaming<super::AddArtifactsRequest>>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as SparkConnectService>::add_artifacts(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = AddArtifactsSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.client_streaming(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/spark.connect.SparkConnectService/ArtifactStatus" => {
                    #[allow(non_camel_case_types)]
                    struct ArtifactStatusSvc<T: SparkConnectService>(pub Arc<T>);
                    impl<T: SparkConnectService>
                        tonic::server::UnaryService<super::ArtifactStatusesRequest>
                        for ArtifactStatusSvc<T>
                    {
                        type Response = super::ArtifactStatusesResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::ArtifactStatusesRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as SparkConnectService>::artifact_status(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = ArtifactStatusSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/spark.connect.SparkConnectService/Interrupt" => {
                    #[allow(non_camel_case_types)]
                    struct InterruptSvc<T: SparkConnectService>(pub Arc<T>);
                    impl<T: SparkConnectService>
                        tonic::server::UnaryService<super::InterruptRequest> for InterruptSvc<T>
                    {
                        type Response = super::InterruptResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::InterruptRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as SparkConnectService>::interrupt(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = InterruptSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/spark.connect.SparkConnectService/ReattachExecute" => {
                    #[allow(non_camel_case_types)]
                    struct ReattachExecuteSvc<T: SparkConnectService>(pub Arc<T>);
                    impl<T: SparkConnectService>
                        tonic::server::ServerStreamingService<super::ReattachExecuteRequest>
                        for ReattachExecuteSvc<T>
                    {
                        type Response = super::ExecutePlanResponse;
                        type ResponseStream = T::ReattachExecuteStream;
                        type Future =
                            BoxFuture<tonic::Response<Self::ResponseStream>, tonic::Status>;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::ReattachExecuteRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as SparkConnectService>::reattach_execute(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = ReattachExecuteSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.server_streaming(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/spark.connect.SparkConnectService/ReleaseExecute" => {
                    #[allow(non_camel_case_types)]
                    struct ReleaseExecuteSvc<T: SparkConnectService>(pub Arc<T>);
                    impl<T: SparkConnectService>
                        tonic::server::UnaryService<super::ReleaseExecuteRequest>
                        for ReleaseExecuteSvc<T>
                    {
                        type Response = super::ReleaseExecuteResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::ReleaseExecuteRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as SparkConnectService>::release_execute(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = ReleaseExecuteSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/spark.connect.SparkConnectService/ReleaseSession" => {
                    #[allow(non_camel_case_types)]
                    struct ReleaseSessionSvc<T: SparkConnectService>(pub Arc<T>);
                    impl<T: SparkConnectService>
                        tonic::server::UnaryService<super::ReleaseSessionRequest>
                        for ReleaseSessionSvc<T>
                    {
                        type Response = super::ReleaseSessionResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::ReleaseSessionRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as SparkConnectService>::release_session(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = ReleaseSessionSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/spark.connect.SparkConnectService/FetchErrorDetails" => {
                    #[allow(non_camel_case_types)]
                    struct FetchErrorDetailsSvc<T: SparkConnectService>(pub Arc<T>);
                    impl<T: SparkConnectService>
                        tonic::server::UnaryService<super::FetchErrorDetailsRequest>
                        for FetchErrorDetailsSvc<T>
                    {
                        type Response = super::FetchErrorDetailsResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::FetchErrorDetailsRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as SparkConnectService>::fetch_error_details(&inner, request)
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = FetchErrorDetailsSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                _ => Box::pin(async move {
                    let mut response = http::Response::new(empty_body());
                    let headers = response.headers_mut();
                    headers.insert(
                        tonic::Status::GRPC_STATUS,
                        (tonic::Code::Unimplemented as i32).into(),
                    );
                    headers.insert(
                        http::header::CONTENT_TYPE,
                        tonic::metadata::GRPC_CONTENT_TYPE,
                    );
                    Ok(response)
                }),
            }
        }
    }
    impl<T> Clone for SparkConnectServiceServer<T> {
        fn clone(&self) -> Self {
            let inner = self.inner.clone();
            Self {
                inner,
                accept_compression_encodings: self.accept_compression_encodings,
                send_compression_encodings: self.send_compression_encodings,
                max_decoding_message_size: self.max_decoding_message_size,
                max_encoding_message_size: self.max_encoding_message_size,
            }
        }
    }
    /// Generated gRPC service name
    pub const SERVICE_NAME: &str = "spark.connect.SparkConnectService";
    impl<T> tonic::server::NamedService for SparkConnectServiceServer<T> {
        const NAME: &'static str = SERVICE_NAME;
    }
}
