"""This file was code generated by turms. If you want to change the contents of this file, you should make sure to add the MergeProcessor to your config will keep your changes when you re-run turms)."""

from rekuest_next.traits.ports import (
    ReturnWidgetInputTrait,
    DefinitionInputTrait,
    ValidatorInputTrait,
    WidgetInputTrait,
    PortTrait,
)
from typing_extensions import Literal
from typing import (
    Union,
    Iterable,
    Iterator,
    Any,
    Tuple,
    Annotated,
    Optional,
    AsyncIterator,
    List,
)
from rekuest_next.scalars import (
    ValidatorFunction,
    InstanceID,
    Identifier,
    Args,
    ActionHash,
    SearchQuery,
)
from pydantic import Field, BaseModel, ConfigDict
from rekuest_next.rath import RekuestNextRath
from rekuest_next.funcs import execute, aexecute, asubscribe, subscribe
from datetime import datetime
from rath.scalars import IDCoercible, ID
from enum import Enum
from rekuest_next.traits.action import Callable


class AssignWidgetKind(str, Enum):
    """The kind of assign widget."""

    SEARCH = "SEARCH"
    CHOICE = "CHOICE"
    SLIDER = "SLIDER"
    CUSTOM = "CUSTOM"
    STRING = "STRING"
    STATE_CHOICE = "STATE_CHOICE"


class PortKind(str, Enum):
    """The kind of port."""

    INT = "INT"
    STRING = "STRING"
    STRUCTURE = "STRUCTURE"
    LIST = "LIST"
    BOOL = "BOOL"
    DICT = "DICT"
    FLOAT = "FLOAT"
    DATE = "DATE"
    UNION = "UNION"
    ENUM = "ENUM"
    MODEL = "MODEL"
    MEMORY_STRUCTURE = "MEMORY_STRUCTURE"
    INTERFACE = "INTERFACE"


class EffectKind(str, Enum):
    """The kind of effect."""

    MESSAGE = "MESSAGE"
    HIDE = "HIDE"
    CUSTOM = "CUSTOM"


class ReturnWidgetKind(str, Enum):
    """The kind of return widget."""

    CHOICE = "CHOICE"
    CUSTOM = "CUSTOM"


class UIChildKind(str, Enum):
    """No documentation"""

    GRID = "GRID"
    SPLIT = "SPLIT"
    RESERVATION = "RESERVATION"
    STATE = "STATE"


class Ordering(str, Enum):
    """No documentation"""

    ASC = "ASC"
    ASC_NULLS_FIRST = "ASC_NULLS_FIRST"
    ASC_NULLS_LAST = "ASC_NULLS_LAST"
    DESC = "DESC"
    DESC_NULLS_FIRST = "DESC_NULLS_FIRST"
    DESC_NULLS_LAST = "DESC_NULLS_LAST"


class ActionKind(str, Enum):
    """The kind of action."""

    FUNCTION = "FUNCTION"
    GENERATOR = "GENERATOR"


class DemandKind(str, Enum):
    """No documentation"""

    ARGS = "ARGS"
    RETURNS = "RETURNS"


class AssignationEventKind(str, Enum):
    """The event kind of the assignationevent"""

    BOUND = "BOUND"
    QUEUED = "QUEUED"
    ASSIGN = "ASSIGN"
    PROGRESS = "PROGRESS"
    DELEGATE = "DELEGATE"
    DISCONNECTED = "DISCONNECTED"
    YIELD = "YIELD"
    DONE = "DONE"
    LOG = "LOG"
    CANCELING = "CANCELING"
    CANCELLED = "CANCELLED"
    INTERUPTING = "INTERUPTING"
    INTERUPTED = "INTERUPTED"
    ERROR = "ERROR"
    CRITICAL = "CRITICAL"


class LogLevel(str, Enum):
    """No documentation"""

    DEBUG = "DEBUG"
    INFO = "INFO"
    ERROR = "ERROR"
    WARN = "WARN"
    CRITICAL = "CRITICAL"


class HookKind(str, Enum):
    """No documentation"""

    CLEANUP = "CLEANUP"
    INIT = "INIT"


class StrFilterLookup(BaseModel):
    """No documentation"""

    exact: Optional[str] = None
    i_exact: Optional[str] = Field(alias="iExact", default=None)
    contains: Optional[str] = None
    i_contains: Optional[str] = Field(alias="iContains", default=None)
    in_list: Optional[Tuple[str, ...]] = Field(alias="inList", default=None)
    gt: Optional[str] = None
    gte: Optional[str] = None
    lt: Optional[str] = None
    lte: Optional[str] = None
    starts_with: Optional[str] = Field(alias="startsWith", default=None)
    i_starts_with: Optional[str] = Field(alias="iStartsWith", default=None)
    ends_with: Optional[str] = Field(alias="endsWith", default=None)
    i_ends_with: Optional[str] = Field(alias="iEndsWith", default=None)
    range: Optional[Tuple[str, ...]] = None
    is_null: Optional[bool] = Field(alias="isNull", default=None)
    regex: Optional[str] = None
    i_regex: Optional[str] = Field(alias="iRegex", default=None)
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class OffsetPaginationInput(BaseModel):
    """No documentation"""

    offset: int
    limit: Optional[int] = None
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class AgentFilter(BaseModel):
    """A way to filter agents"""

    scope: Optional["ScopeFilter"] = None
    client_id: Optional[str] = Field(alias="clientId", default=None)
    "Filter by client ID of the app the agent is registered to"
    instance_id: Optional[str] = Field(alias="instanceId", default=None)
    "Filter by instance ID of the agent"
    ids: Optional[Tuple[ID, ...]] = None
    "Filter by IDs of the agents"
    extensions: Optional[Tuple[str, ...]] = None
    "Filter by extensions of the agents"
    has_implementations: Optional[Tuple[str, ...]] = Field(
        alias="hasImplementations", default=None
    )
    "Filter by implementations of the agents"
    has_states: Optional[Tuple[str, ...]] = Field(alias="hasStates", default=None)
    "Filter by states of the agents"
    pinned: Optional[bool] = None
    "Filter by pinned agents"
    search: Optional[str] = None
    "Filter by name of the agents"
    distinct: Optional[bool] = None
    action_demands: Optional[Tuple["ActionDemandInput", ...]] = Field(
        alias="actionDemands", default=None
    )
    state_demands: Optional[Tuple["SchemaDemandInput", ...]] = Field(
        alias="stateDemands", default=None
    )
    and_: Optional["AgentFilter"] = Field(alias="AND", default=None)
    or_: Optional["AgentFilter"] = Field(alias="OR", default=None)
    not_: Optional["AgentFilter"] = Field(alias="NOT", default=None)
    distinct: Optional[bool] = Field(alias="DISTINCT", default=None)
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class ScopeFilter(BaseModel):
    """A way to filter by scope"""

    public: Optional[bool] = None
    org: Optional[bool] = None
    shared: Optional[bool] = None
    me: Optional[bool] = None
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class ActionDemandInput(BaseModel):
    """The input for creating a action demand."""

    key: str
    "The key of the action. This is used to identify the action in the system."
    hash: Optional[ActionHash] = None
    "The hash of the action. This is used to identify the action in the system."
    name: Optional[str] = None
    "The name of the action. This is used to identify the action in the system."
    description: Optional[str] = None
    "The description of the action. This can described the action and its purpose."
    arg_matches: Optional[Tuple["PortMatchInput", ...]] = Field(
        alias="argMatches", default=None
    )
    "The demands for the action args and returns. This is used to identify the demand in the system."
    return_matches: Optional[Tuple["PortMatchInput", ...]] = Field(
        alias="returnMatches", default=None
    )
    "The demands for the action args and returns. This is used to identify the demand in the system."
    protocols: Optional[Tuple[ID, ...]] = None
    "The protocols that the action has to implement. This is used to identify the demand in the system."
    force_arg_length: Optional[int] = Field(alias="forceArgLength", default=None)
    "Require that the action has a specific number of args. This is used to identify the demand in the system."
    force_return_length: Optional[int] = Field(alias="forceReturnLength", default=None)
    "Require that the action has a specific number of returns. This is used to identify the demand in the system."
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class PortMatchInput(BaseModel):
    """A dependency for a implementation. By defining dependencies, you can
    create a dependency graph for your implementations and actions"""

    at: Optional[int] = None
    key: Optional[str] = None
    kind: Optional[PortKind] = None
    identifier: Optional[str] = None
    nullable: Optional[bool] = None
    children: Optional[Tuple["PortMatchInput", ...]] = None
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class SchemaDemandInput(BaseModel):
    """The input for creating a action demand."""

    key: str
    "The key of the action. This is used to identify the action in the system."
    hash: Optional[ActionHash] = None
    "The hash of the state."
    matches: Optional[Tuple[PortMatchInput, ...]] = None
    "The demands for the action args and returns. This is used to identify the demand in the system."
    protocols: Optional[Tuple[ID, ...]] = None
    "The protocols that the action has to implement. This is used to identify the demand in the system."
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class ActionFilter(BaseModel):
    """No documentation"""

    search: Optional[str] = None
    name: Optional[StrFilterLookup] = None
    ids: Optional[Tuple[ID, ...]] = None
    demands: Optional[Tuple["PortDemandInput", ...]] = None
    protocols: Optional[Tuple[str, ...]] = None
    kind: Optional[ActionKind] = None
    in_collection: Optional[str] = Field(alias="inCollection", default=None)
    and_: Optional["ActionFilter"] = Field(alias="AND", default=None)
    or_: Optional["ActionFilter"] = Field(alias="OR", default=None)
    not_: Optional["ActionFilter"] = Field(alias="NOT", default=None)
    distinct: Optional[bool] = Field(alias="DISTINCT", default=None)
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class PortDemandInput(BaseModel):
    """The input for creating a port demand."""

    kind: DemandKind
    "The kind of the demand. You can ask for args or returns"
    matches: Optional[Tuple[PortMatchInput, ...]] = None
    "The matches of the demand. "
    force_length: Optional[int] = Field(alias="forceLength", default=None)
    "Require that the action has a specific number of ports. This is used to identify the demand in the system."
    force_non_nullable_length: Optional[int] = Field(
        alias="forceNonNullableLength", default=None
    )
    "Require that the action has a specific number of non-nullable ports. This is used to identify the demand in the system."
    force_structure_length: Optional[int] = Field(
        alias="forceStructureLength", default=None
    )
    "Require that the action has a specific number of structure ports. This is used to identify the demand in the system."
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class ActionOrder(BaseModel):
    """No documentation"""

    defined_at: Optional[Ordering] = Field(alias="definedAt", default=None)
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class ShortcutFilter(BaseModel):
    """No documentation"""

    search: Optional[str] = None
    ids: Optional[Tuple[ID, ...]] = None
    demands: Optional[Tuple[PortDemandInput, ...]] = None
    toolbox: Optional[ID] = None
    and_: Optional["ShortcutFilter"] = Field(alias="AND", default=None)
    or_: Optional["ShortcutFilter"] = Field(alias="OR", default=None)
    not_: Optional["ShortcutFilter"] = Field(alias="NOT", default=None)
    distinct: Optional[bool] = Field(alias="DISTINCT", default=None)
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class ShortcutOrder(BaseModel):
    """No documentation"""

    name: Optional[Ordering] = None
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class ToolboxFilter(BaseModel):
    """No documentation"""

    search: Optional[str] = None
    name: Optional[StrFilterLookup] = None
    ids: Optional[Tuple[ID, ...]] = None
    and_: Optional["ToolboxFilter"] = Field(alias="AND", default=None)
    or_: Optional["ToolboxFilter"] = Field(alias="OR", default=None)
    not_: Optional["ToolboxFilter"] = Field(alias="NOT", default=None)
    distinct: Optional[bool] = Field(alias="DISTINCT", default=None)
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class ToolboxOrder(BaseModel):
    """No documentation"""

    name: Optional[Ordering] = None
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class ActionDependencyInput(BaseModel):
    """A dependency for a implementation. By defining dependencies, you can
    create a dependency graph for your implementations and actions"""

    key: str
    hash: Optional[ActionHash] = None
    name: Optional[str] = None
    description: Optional[str] = None
    arg_matches: Optional[Tuple[PortMatchInput, ...]] = Field(
        alias="argMatches", default=None
    )
    return_matches: Optional[Tuple[PortMatchInput, ...]] = Field(
        alias="returnMatches", default=None
    )
    protocols: Optional[Tuple[ID, ...]] = None
    force_arg_length: Optional[int] = Field(alias="forceArgLength", default=None)
    force_return_length: Optional[int] = Field(alias="forceReturnLength", default=None)
    optional: bool
    allow_inactive: Optional[bool] = Field(alias="allowInactive", default=None)
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class CreateImplementationInput(BaseModel):
    """The input for creating a implementation."""

    implementation: "ImplementationInput"
    instance_id: InstanceID = Field(alias="instanceId")
    extension: str
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class ImplementationInput(BaseModel):
    """A implementation is a blueprint for a action. It is composed of a definition, a list of dependencies, and a list of params."""

    definition: "DefinitionInput"
    dependencies: Tuple[ActionDependencyInput, ...]
    interface: Optional[str] = None
    params: Optional[Any] = None
    dynamic: bool
    logo: Optional[str] = None
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class DefinitionInput(DefinitionInputTrait, BaseModel):
    """A definition

    Definitions are the building implementation for Actions and provide the
    information needed to create a action. They are primarly composed of a name,
    a description, and a list of ports.

    Definitions provide a protocol of input and output, and do not contain
    any information about the actual implementation of the action ( this is handled
    by a implementation that implements a action).




    """

    description: Optional[str] = None
    "The description of the definition. This is the text that is displayed in the UI"
    collections: Tuple[str, ...]
    "The collections of the definition. This is used to group definitions together in the UI"
    name: str
    "The name of the actions. This is used to uniquely identify the definition"
    stateful: bool
    "Whether the definition is stateful or not. If the definition is stateful, it can be used to create a stateful action. If the definition is not stateful, it cannot be used to create a stateful action"
    port_groups: Tuple["PortGroupInput", ...] = Field(alias="portGroups")
    "The port groups of the definition. This is used to group ports together in the UI"
    args: Tuple["PortInput", ...]
    "The args of the definition. This is the input ports of the definition"
    returns: Tuple["PortInput", ...]
    "The returns of the definition. This is the output ports of the definition"
    kind: ActionKind
    "The kind of the definition. This is the type of the definition. Can be either a function or a generator"
    is_test_for: Tuple[str, ...] = Field(alias="isTestFor")
    "The tests for the definition. This is used to group definitions together in the UI"
    interfaces: Tuple[str, ...]
    "The interfaces of the definition. This is used to group definitions together in the UI"
    is_dev: bool = Field(alias="isDev")
    "Whether the definition is a dev definition or not. If the definition is a dev definition, it can be used to create a dev action. If the definition is not a dev definition, it cannot be used to create a dev action"
    logo: Optional[str] = None
    "The logo of the definition. This is used to display the logo in the UI"
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class PortGroupInput(BaseModel):
    """A Port Group is a group of ports that are related to each other. It is used to group ports together in the UI and provide a better user experience."""

    key: str
    "The key of the port group. This is used to uniquely identify the port group"
    title: Optional[str] = None
    description: Optional[str] = None
    effects: Optional[Tuple["EffectInput", ...]] = None
    ports: Optional[Tuple[str, ...]] = None
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class EffectInput(BaseModel):
    """
                 An effect is a way to modify a port based on a condition. For example,
    you could have an effect that sets a port to null if another port is null.

    Or, you could have an effect that hides the port if another port meets a condition.
    E.g when the user selects a certain option in a dropdown, another port is hidden.


    """

    function: ValidatorFunction
    dependencies: Optional[Tuple[str, ...]] = None
    message: Optional[str] = None
    kind: EffectKind
    fade: Optional[bool] = None
    hook: Optional[str] = None
    ward: Optional[str] = None
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class PortInput(PortTrait, BaseModel):
    """Port

    A Port is a single input or output of a action. It is composed of a key and a kind
    which are used to uniquely identify the port.

    If the Port is a structure, we need to define a identifier and scope,
    Identifiers uniquely identify a specific type of model for the scopes (e.g
    all the ports that have the identifier "@mikro/image" are of the same type, and
    are hence compatible with each other). Scopes are used to define in which context
    the identifier is valid (e.g. a port with the identifier "@mikro/image" and the
    scope "local", can only be wired to other ports that have the same identifier and
    are running in the same app). Global ports are ports that have the scope "global",
    and can be wired to any other port that has the same identifier, as there exists a
    mechanism to resolve and retrieve the object for each app. Please check the rekuest
    documentation for more information on how this works.


    """

    validators: Optional[Tuple["ValidatorInput", ...]] = None
    key: str
    label: Optional[str] = None
    kind: PortKind
    description: Optional[str] = None
    identifier: Optional[str] = None
    nullable: bool
    effects: Optional[Tuple[EffectInput, ...]] = None
    default: Optional[Any] = None
    children: Optional[Tuple["PortInput", ...]] = None
    choices: Optional[Tuple["ChoiceInput", ...]] = None
    assign_widget: Optional["AssignWidgetInput"] = Field(
        alias="assignWidget", default=None
    )
    return_widget: Optional["ReturnWidgetInput"] = Field(
        alias="returnWidget", default=None
    )
    descriptors: Optional[Tuple["DescriptorInput", ...]] = None
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class ValidatorInput(ValidatorInputTrait, BaseModel):
    """
    A validating function for a port. Can specify a function that will run when validating values of the port.
    If outside dependencies are needed they need to be specified in the dependencies field. With the .. syntax
    when transversing the tree of ports.

    """

    function: ValidatorFunction
    dependencies: Optional[Tuple[str, ...]] = None
    label: Optional[str] = None
    error_message: Optional[str] = Field(alias="errorMessage", default=None)
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class ChoiceInput(BaseModel):
    """
    A choice is a value that can be selected in a dropdown.

    It is composed of a value, a label, and a description. The value is the
    value that is returned when the choice is selected. The label is the
    text that is displayed in the dropdown. The description is the text
    that is displayed when the user hovers over the choice.

    """

    value: Any
    label: str
    image: Optional[str] = None
    description: Optional[str] = None
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class AssignWidgetInput(WidgetInputTrait, BaseModel):
    """No documentation"""

    as_paragraph: Optional[bool] = Field(alias="asParagraph", default=None)
    "Whether to display the input as a paragraph or not. This is used for text inputs and dropdowns"
    kind: AssignWidgetKind
    query: Optional[SearchQuery] = None
    choices: Optional[Tuple[ChoiceInput, ...]] = None
    min: Optional[float] = None
    max: Optional[float] = None
    step: Optional[float] = None
    placeholder: Optional[str] = None
    hook: Optional[str] = None
    ward: Optional[str] = None
    fallback: Optional["AssignWidgetInput"] = None
    filters: Optional[Tuple[PortInput, ...]] = None
    dependencies: Optional[Tuple[str, ...]] = None
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class ReturnWidgetInput(ReturnWidgetInputTrait, BaseModel):
    """A Return Widget is a UI element that is used to display the value of a port.

    Return Widgets get displayed both if we show the return values of an assignment,
    but also when we inspect the given arguments of a previous run task. Their primary
    usecase is to adequately display the value of a port, in a user readable way.

    Return Widgets are often overwriten by the underlying UI framework (e.g. Orkestrator)
    to provide a better user experience. For example, a return widget that displays a
    date could be overwriten to display a calendar widget.

    Return Widgets provide more a way to customize this overwriten behavior.

    """

    kind: ReturnWidgetKind
    query: Optional[SearchQuery] = None
    choices: Optional[Tuple[ChoiceInput, ...]] = None
    min: Optional[int] = None
    max: Optional[int] = None
    step: Optional[int] = None
    placeholder: Optional[str] = None
    hook: Optional[str] = None
    ward: Optional[str] = None
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class DescriptorInput(BaseModel):
    """No documentation"""

    key: str
    value: Any
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class SetExtensionImplementationsInput(BaseModel):
    """The input for setting extension implementations."""

    implementations: Tuple[ImplementationInput, ...]
    "The implementations to set. This is used to identify the implementations in the system."
    instance_id: InstanceID = Field(alias="instanceId")
    extension: str
    run_cleanup: bool = Field(alias="runCleanup")
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class AssignInput(BaseModel):
    """The input for assigning args to a action."""

    instance_id: InstanceID = Field(alias="instanceId")
    action: Optional[ID] = None
    implementation: Optional[ID] = None
    agent: Optional[ID] = None
    action_hash: Optional[ActionHash] = Field(alias="actionHash", default=None)
    reservation: Optional[ID] = None
    interface: Optional[str] = None
    hooks: Optional[Tuple["HookInput", ...]] = None
    args: Args
    reference: Optional[str] = None
    parent: Optional[ID] = None
    cached: bool
    log: bool
    capture: bool
    ephemeral: bool
    dependencies: Optional[Args] = None
    is_hook: Optional[bool] = Field(alias="isHook", default=None)
    step: Optional[bool] = None
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class HookInput(BaseModel):
    """A hook is a function that is called when a action has reached a specific lifecycle point. Hooks are jsut actions that take an assignation as input and return a value."""

    kind: HookKind
    hash: ActionHash
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class CancelInput(BaseModel):
    """The input for canceling an assignation."""

    assignation: ID
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class CollectInput(BaseModel):
    """The input for collecting a shelved item in a drawer."""

    drawers: Tuple[ID, ...]
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class InterruptInput(BaseModel):
    """The input for interrupting an assignation."""

    assignation: ID
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class ReserveInput(BaseModel):
    """The input for reserving a action."""

    reference: Optional[str] = None
    instance_id: InstanceID = Field(alias="instanceId")
    action: Optional[ID] = None
    implementation: Optional[ID] = None
    title: Optional[str] = None
    hash: Optional[ActionHash] = None
    binds: Optional["BindsInput"] = None
    assignation_id: Optional[ID] = Field(alias="assignationId", default=None)
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class BindsInput(BaseModel):
    """No documentation"""

    implementations: Optional[Tuple[str, ...]] = None
    clients: Optional[Tuple[str, ...]] = None
    desired_instances: int = Field(alias="desiredInstances")
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class UnreserveInput(BaseModel):
    """No documentation"""

    reservation: ID
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class AgentInput(BaseModel):
    """No documentation"""

    instance_id: InstanceID = Field(alias="instanceId")
    "The instance ID of the agent. This is used to identify the agent in the system."
    name: Optional[str] = None
    "The name of the agent. This is used to identify the agent in the system."
    extensions: Optional[Tuple[str, ...]] = None
    "The extensions of the agent. This is used to identify the agent in the system."
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class CreateTestCaseInput(BaseModel):
    """No documentation"""

    action: ID
    tester: ID
    description: Optional[str] = None
    name: Optional[str] = None
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class CreateTestResultInput(BaseModel):
    """No documentation"""

    case: ID
    tester: ID
    implementation: ID
    passed: bool
    result: Optional[str] = None
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class ShelveInMemoryDrawerInput(BaseModel):
    """No documentation"""

    instance_id: InstanceID = Field(alias="instanceId")
    "The instance ID of the agent. This is used to identify the agent in the system."
    identifier: Identifier
    "The identifier of the drawer. This is used to identify the drawer in the system."
    resource_id: str = Field(alias="resourceId")
    "The resource ID of the drawer."
    label: Optional[str] = None
    "The label of the drawer. This is used to identify the drawer in the system."
    description: Optional[str] = None
    "The description of the drawer. This is used to identify the drawer in the system."
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class UnshelveMemoryDrawerInput(BaseModel):
    """No documentation"""

    instance_id: InstanceID = Field(alias="instanceId")
    "The instance ID of the agent. This is used to identify the agent in the system."
    id: str
    "The resource ID of the drawer."
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class CreateDashboardInput(BaseModel):
    """The input for creating a dashboard."""

    name: Optional[str] = None
    panels: Optional[Tuple[ID, ...]] = None
    tree: Optional["UITreeInput"] = None
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class UITreeInput(BaseModel):
    """No documentation"""

    child: "UIChildInput"
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class UIChildInput(BaseModel):
    """No documentation"""

    state: Optional[str] = None
    kind: UIChildKind
    hidden: Optional[bool] = None
    children: Optional[Tuple["UIChildInput", ...]] = None
    left: Optional["UIChildInput"] = None
    right: Optional["UIChildInput"] = None
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class CreateStateSchemaInput(BaseModel):
    """The input for creating a state schema."""

    state_schema: "StateSchemaInput" = Field(alias="stateSchema")
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class StateSchemaInput(BaseModel):
    """The input for creating a state schema."""

    ports: Tuple[PortInput, ...]
    name: str
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class SetStateInput(BaseModel):
    """The input for setting a state schema."""

    interface: str
    instance_id: InstanceID = Field(alias="instanceId")
    value: Args
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class UpdateStateInput(BaseModel):
    """The input for updating a state schema."""

    interface: str
    instance_id: InstanceID = Field(alias="instanceId")
    patches: Tuple[Args, ...]
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class CreateShortcutInput(BaseModel):
    """The input for creating a shortcut."""

    toolbox: Optional[ID] = None
    "The toolbox ID to create the shortcut in. If not provided, the shortcut will be created in the default toolbox."
    name: str
    description: Optional[str] = None
    action: ID
    implementation: Optional[ID] = None
    args: Args
    allow_quick: bool = Field(alias="allowQuick")
    use_returns: bool = Field(alias="useReturns")
    bind_number: Optional[int] = Field(alias="bindNumber", default=None)
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class SetAgentStatesInput(BaseModel):
    """The input for setting a state schema to an agent."""

    implementations: Tuple["StateImplementationInput", ...]
    instance_id: InstanceID = Field(alias="instanceId")
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class StateImplementationInput(BaseModel):
    """The input for initializing a state schema."""

    interface: str
    state_schema: StateSchemaInput = Field(alias="stateSchema")
    initial: Args
    model_config = ConfigDict(
        frozen=True, extra="forbid", populate_by_name=True, use_enum_values=True
    )


class PrimaryAction(Callable, BaseModel):
    """Represents an executable action in the system."""

    typename: Literal["Action"] = Field(
        alias="__typename", default="Action", exclude=True
    )
    name: str
    "Name of the action."
    id: ID
    "Unique ID of the action."
    hash: ActionHash
    "Unique hash identifying the action definition."
    description: Optional[str] = Field(default=None)
    "Optional description of the action."
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for PrimaryAction"""

        document = "fragment PrimaryAction on Action {\n  name\n  id\n  hash\n  description\n  __typename\n}"
        name = "PrimaryAction"
        type = "Action"


class AgentRegistryClient(BaseModel):
    """Represents a registered OAuth2 client."""

    typename: Literal["Client"] = Field(
        alias="__typename", default="Client", exclude=True
    )
    id: ID
    "Unique ID of the client."
    model_config = ConfigDict(frozen=True)


class AgentRegistryUser(BaseModel):
    """Represents an authenticated user."""

    typename: Literal["User"] = Field(alias="__typename", default="User", exclude=True)
    sub: ID
    "The subject identifier of the user."
    model_config = ConfigDict(frozen=True)


class AgentRegistry(BaseModel):
    """Links a user and a client for registry tracking."""

    typename: Literal["Registry"] = Field(
        alias="__typename", default="Registry", exclude=True
    )
    client: AgentRegistryClient
    "The associated client."
    user: AgentRegistryUser
    "The associated user."
    model_config = ConfigDict(frozen=True)


class AgentMemoryshelve(BaseModel):
    """A shelve for storing memory-based resources on an agent."""

    typename: Literal["MemoryShelve"] = Field(
        alias="__typename", default="MemoryShelve", exclude=True
    )
    id: ID
    "ID of the memory shelve."
    model_config = ConfigDict(frozen=True)


class Agent(BaseModel):
    """Represents a compute agent that can execute implementations."""

    typename: Literal["Agent"] = Field(
        alias="__typename", default="Agent", exclude=True
    )
    id: ID
    "Unique ID of the agent."
    registry: AgentRegistry
    "Registry entry this agent belongs to."
    memory_shelve: Optional[AgentMemoryshelve] = Field(
        default=None, alias="memoryShelve"
    )
    "Agent's associated memory shelve."
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for Agent"""

        document = "fragment Agent on Agent {\n  id\n  registry {\n    client {\n      id\n      __typename\n    }\n    user {\n      sub\n      __typename\n    }\n    __typename\n  }\n  memoryShelve {\n    id\n    __typename\n  }\n  __typename\n}"
        name = "Agent"
        type = "Agent"


class AssignationParent(BaseModel):
    """Tracks the assignment of an implementation to a specific task."""

    typename: Literal["Assignation"] = Field(
        alias="__typename", default="Assignation", exclude=True
    )
    id: ID
    "Unique ID of the assignation."
    model_config = ConfigDict(frozen=True)


class AssignationEvents(BaseModel):
    """An event that occurred during an assignation."""

    typename: Literal["AssignationEvent"] = Field(
        alias="__typename", default="AssignationEvent", exclude=True
    )
    id: ID
    "Unique ID of the event."
    returns: Optional[Any] = Field(default=None)
    "Optional return values."
    level: LogLevel
    "Default log level."
    model_config = ConfigDict(frozen=True)


class AssignationInstructs(BaseModel):
    """An instruct event for a specific assignation."""

    typename: Literal["AssignationInstruct"] = Field(
        alias="__typename", default="AssignationInstruct", exclude=True
    )
    id: ID
    "Unique ID of the instruct event."
    model_config = ConfigDict(frozen=True)


class Assignation(BaseModel):
    """Tracks the assignment of an implementation to a specific task."""

    typename: Literal["Assignation"] = Field(
        alias="__typename", default="Assignation", exclude=True
    )
    args: Any
    "Arguments used in the assignation."
    id: ID
    "Unique ID of the assignation."
    parent: Optional[AssignationParent] = Field(default=None)
    "Parent assignation that triggered this one."
    id: ID
    "Unique ID of the assignation."
    latest_event_kind: AssignationEventKind = Field(alias="latestEventKind")
    "Type of the latest event."
    events: Tuple[AssignationEvents, ...]
    "List of recent events for this assignation."
    instructs: Tuple[AssignationInstructs, ...]
    "List of recent instructions for this assignation."
    reference: Optional[str] = Field(default=None)
    "Optional external reference for tracking."
    updated_at: datetime = Field(alias="updatedAt")
    "Last update timestamp."
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for Assignation"""

        document = "fragment Assignation on Assignation {\n  args\n  id\n  parent {\n    id\n    __typename\n  }\n  id\n  latestEventKind\n  events {\n    id\n    returns\n    level\n    __typename\n  }\n  instructs {\n    id\n    __typename\n  }\n  reference\n  updatedAt\n  __typename\n}"
        name = "Assignation"
        type = "Assignation"


class AssignationEvent(BaseModel):
    """An event that occurred during an assignation."""

    typename: Literal["AssignationEvent"] = Field(
        alias="__typename", default="AssignationEvent", exclude=True
    )
    id: ID
    "Unique ID of the event."
    kind: AssignationEventKind
    "Kind of assignation event."
    returns: Optional[Any] = Field(default=None)
    "Optional return values."
    reference: str
    "Reference string for the event."
    message: Optional[str] = Field(default=None)
    "Optional message associated with the event."
    progress: Optional[int] = Field(default=None)
    "Progress percentage."
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for AssignationEvent"""

        document = "fragment AssignationEvent on AssignationEvent {\n  id\n  kind\n  returns\n  reference\n  message\n  progress\n  __typename\n}"
        name = "AssignationEvent"
        type = "AssignationEvent"


class DashboardUitreeChildChildren(BaseModel):
    """No documentation"""

    typename: Literal["UIGridItem"] = Field(
        alias="__typename", default="UIGridItem", exclude=True
    )
    x: int
    y: int
    w: int
    h: int
    model_config = ConfigDict(frozen=True)


class DashboardUitreeChildBase(BaseModel):
    """No documentation"""

    model_config = ConfigDict(frozen=True)


class DashboardUitreeChildBaseUIGrid(DashboardUitreeChildBase, BaseModel):
    """No documentation"""

    typename: Literal["UIGrid"] = Field(
        alias="__typename", default="UIGrid", exclude=True
    )
    row_height: int = Field(alias="rowHeight")
    children: Tuple[DashboardUitreeChildChildren, ...]


class DashboardUitreeChildBaseUISplit(DashboardUitreeChildBase, BaseModel):
    """No documentation"""

    typename: Literal["UISplit"] = Field(
        alias="__typename", default="UISplit", exclude=True
    )


class DashboardUitreeChildBaseUIState(DashboardUitreeChildBase, BaseModel):
    """No documentation"""

    typename: Literal["UIState"] = Field(
        alias="__typename", default="UIState", exclude=True
    )


class DashboardUitreeChildBaseCatchAll(DashboardUitreeChildBase, BaseModel):
    """Catch all class for DashboardUitreeChildBase"""

    typename: str = Field(alias="__typename", exclude=True)


class DashboardUitree(BaseModel):
    """No documentation"""

    typename: Literal["UITree"] = Field(
        alias="__typename", default="UITree", exclude=True
    )
    child: Union[
        Annotated[
            Union[
                DashboardUitreeChildBaseUIGrid,
                DashboardUitreeChildBaseUISplit,
                DashboardUitreeChildBaseUIState,
            ],
            Field(discriminator="typename"),
        ],
        DashboardUitreeChildBaseCatchAll,
    ]
    model_config = ConfigDict(frozen=True)


class Dashboard(BaseModel):
    """No documentation"""

    typename: Literal["Dashboard"] = Field(
        alias="__typename", default="Dashboard", exclude=True
    )
    id: ID
    name: Optional[str] = Field(default=None)
    ui_tree: Optional[DashboardUitree] = Field(default=None, alias="uiTree")
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for Dashboard"""

        document = "fragment Dashboard on Dashboard {\n  id\n  name\n  uiTree {\n    child {\n      ... on UIGrid {\n        rowHeight\n        children {\n          x\n          y\n          w\n          h\n        }\n      }\n      __typename\n    }\n    __typename\n  }\n  __typename\n}"
        name = "Dashboard"
        type = "Dashboard"


class ChildPortNestedChildren(PortTrait, BaseModel):
    """No documentation"""

    typename: Literal["Port"] = Field(alias="__typename", default="Port", exclude=True)
    key: str
    identifier: Optional[Identifier] = Field(default=None)
    nullable: bool
    kind: PortKind
    model_config = ConfigDict(frozen=True)


class ChildPortNestedChoices(BaseModel):
    """No documentation"""

    typename: Literal["Choice"] = Field(
        alias="__typename", default="Choice", exclude=True
    )
    value: str
    label: str
    description: Optional[str] = Field(default=None)
    model_config = ConfigDict(frozen=True)


class ChildPortNested(PortTrait, BaseModel):
    """No documentation"""

    typename: Literal["Port"] = Field(alias="__typename", default="Port", exclude=True)
    key: str
    kind: PortKind
    children: Optional[Tuple[ChildPortNestedChildren, ...]] = Field(default=None)
    choices: Optional[Tuple[ChildPortNestedChoices, ...]] = Field(default=None)
    identifier: Optional[Identifier] = Field(default=None)
    nullable: bool
    default: Optional[Any] = Field(default=None)
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for ChildPortNested"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}"
        name = "ChildPortNested"
        type = "Port"


class CustomEffect(BaseModel):
    """No documentation"""

    typename: Literal["CustomEffect"] = Field(
        alias="__typename", default="CustomEffect", exclude=True
    )
    kind: EffectKind
    hook: str
    ward: str
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for CustomEffect"""

        document = "fragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}"
        name = "CustomEffect"
        type = "CustomEffect"


class MessageEffect(BaseModel):
    """No documentation"""

    typename: Literal["MessageEffect"] = Field(
        alias="__typename", default="MessageEffect", exclude=True
    )
    kind: EffectKind
    message: str
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for MessageEffect"""

        document = "fragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}"
        name = "MessageEffect"
        type = "MessageEffect"


class StringAssignWidget(BaseModel):
    """No documentation"""

    typename: Literal["StringAssignWidget"] = Field(
        alias="__typename", default="StringAssignWidget", exclude=True
    )
    kind: AssignWidgetKind
    placeholder: str
    as_paragraph: bool = Field(alias="asParagraph")
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for StringAssignWidget"""

        document = "fragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}"
        name = "StringAssignWidget"
        type = "StringAssignWidget"


class SliderAssignWidget(BaseModel):
    """No documentation"""

    typename: Literal["SliderAssignWidget"] = Field(
        alias="__typename", default="SliderAssignWidget", exclude=True
    )
    kind: AssignWidgetKind
    min: Optional[float] = Field(default=None)
    max: Optional[float] = Field(default=None)
    step: Optional[float] = Field(default=None)
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for SliderAssignWidget"""

        document = "fragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}"
        name = "SliderAssignWidget"
        type = "SliderAssignWidget"


class SearchAssignWidget(BaseModel):
    """No documentation"""

    typename: Literal["SearchAssignWidget"] = Field(
        alias="__typename", default="SearchAssignWidget", exclude=True
    )
    kind: AssignWidgetKind
    query: str
    ward: str
    dependencies: Optional[Tuple[str, ...]] = Field(default=None)
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for SearchAssignWidget"""

        document = "fragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}"
        name = "SearchAssignWidget"
        type = "SearchAssignWidget"


class CustomAssignWidget(BaseModel):
    """No documentation"""

    typename: Literal["CustomAssignWidget"] = Field(
        alias="__typename", default="CustomAssignWidget", exclude=True
    )
    ward: str
    hook: str
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for CustomAssignWidget"""

        document = "fragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}"
        name = "CustomAssignWidget"
        type = "CustomAssignWidget"


class ChoiceAssignWidgetChoices(BaseModel):
    """No documentation"""

    typename: Literal["Choice"] = Field(
        alias="__typename", default="Choice", exclude=True
    )
    value: str
    label: str
    description: Optional[str] = Field(default=None)
    model_config = ConfigDict(frozen=True)


class ChoiceAssignWidget(BaseModel):
    """No documentation"""

    typename: Literal["ChoiceAssignWidget"] = Field(
        alias="__typename", default="ChoiceAssignWidget", exclude=True
    )
    kind: AssignWidgetKind
    choices: Optional[Tuple[ChoiceAssignWidgetChoices, ...]] = Field(default=None)
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for ChoiceAssignWidget"""

        document = "fragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}"
        name = "ChoiceAssignWidget"
        type = "ChoiceAssignWidget"


class CustomReturnWidget(BaseModel):
    """No documentation"""

    typename: Literal["CustomReturnWidget"] = Field(
        alias="__typename", default="CustomReturnWidget", exclude=True
    )
    kind: ReturnWidgetKind
    hook: str
    ward: str
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for CustomReturnWidget"""

        document = "fragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}"
        name = "CustomReturnWidget"
        type = "CustomReturnWidget"


class ChoiceReturnWidgetChoices(BaseModel):
    """No documentation"""

    typename: Literal["Choice"] = Field(
        alias="__typename", default="Choice", exclude=True
    )
    label: str
    value: str
    description: Optional[str] = Field(default=None)
    model_config = ConfigDict(frozen=True)


class ChoiceReturnWidget(BaseModel):
    """No documentation"""

    typename: Literal["ChoiceReturnWidget"] = Field(
        alias="__typename", default="ChoiceReturnWidget", exclude=True
    )
    choices: Optional[Tuple[ChoiceReturnWidgetChoices, ...]] = Field(default=None)
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for ChoiceReturnWidget"""

        document = "fragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}"
        name = "ChoiceReturnWidget"
        type = "ChoiceReturnWidget"


class TestCaseAction(Callable, BaseModel):
    """Represents an executable action in the system."""

    typename: Literal["Action"] = Field(
        alias="__typename", default="Action", exclude=True
    )
    id: ID
    "Unique ID of the action."
    model_config = ConfigDict(frozen=True)


class TestCase(BaseModel):
    """Defines a test case comparing expected behavior for actions."""

    typename: Literal["TestCase"] = Field(
        alias="__typename", default="TestCase", exclude=True
    )
    id: ID
    "Unique ID of the test case."
    action: TestCaseAction
    "Target action under test."
    is_benchmark: bool = Field(alias="isBenchmark")
    "If true, measures performance rather than correctness."
    description: str
    "Details of what this test case covers."
    name: str
    "Short name for the test case."
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for TestCase"""

        document = "fragment TestCase on TestCase {\n  id\n  action {\n    id\n    __typename\n  }\n  isBenchmark\n  description\n  name\n  __typename\n}"
        name = "TestCase"
        type = "TestCase"


class TestResultCase(BaseModel):
    """Defines a test case comparing expected behavior for actions."""

    typename: Literal["TestCase"] = Field(
        alias="__typename", default="TestCase", exclude=True
    )
    id: ID
    "Unique ID of the test case."
    model_config = ConfigDict(frozen=True)


class TestResult(BaseModel):
    """Result from executing a test case with specific implementations."""

    typename: Literal["TestResult"] = Field(
        alias="__typename", default="TestResult", exclude=True
    )
    id: ID
    "ID of the test result."
    case: TestResultCase
    "Associated test case."
    passed: bool
    "True if test passed."
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for TestResult"""

        document = "fragment TestResult on TestResult {\n  id\n  case {\n    id\n    __typename\n  }\n  passed\n  __typename\n}"
        name = "TestResult"
        type = "TestResult"


class Toolbox(BaseModel):
    """A collection of shortcuts grouped as a toolbox."""

    typename: Literal["Toolbox"] = Field(
        alias="__typename", default="Toolbox", exclude=True
    )
    id: ID
    "Toolbox ID."
    name: str
    "Name of the toolbox."
    description: str
    "Description of the toolbox."
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for Toolbox"""

        document = "fragment Toolbox on Toolbox {\n  id\n  name\n  description\n  __typename\n}"
        name = "Toolbox"
        type = "Toolbox"


class ListToolbox(BaseModel):
    """A collection of shortcuts grouped as a toolbox."""

    typename: Literal["Toolbox"] = Field(
        alias="__typename", default="Toolbox", exclude=True
    )
    id: ID
    "Toolbox ID."
    name: str
    "Name of the toolbox."
    description: str
    "Description of the toolbox."
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for ListToolbox"""

        document = "fragment ListToolbox on Toolbox {\n  id\n  name\n  description\n  __typename\n}"
        name = "ListToolbox"
        type = "Toolbox"


class AssignationChangeEvent(BaseModel):
    """No documentation"""

    typename: Literal["AssignationChangeEvent"] = Field(
        alias="__typename", default="AssignationChangeEvent", exclude=True
    )
    create: Optional[Assignation] = Field(default=None)
    event: Optional[AssignationEvent] = Field(default=None)
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for AssignationChangeEvent"""

        document = "fragment Assignation on Assignation {\n  args\n  id\n  parent {\n    id\n    __typename\n  }\n  id\n  latestEventKind\n  events {\n    id\n    returns\n    level\n    __typename\n  }\n  instructs {\n    id\n    __typename\n  }\n  reference\n  updatedAt\n  __typename\n}\n\nfragment AssignationEvent on AssignationEvent {\n  id\n  kind\n  returns\n  reference\n  message\n  progress\n  __typename\n}\n\nfragment AssignationChangeEvent on AssignationChangeEvent {\n  create {\n    ...Assignation\n    __typename\n  }\n  event {\n    ...AssignationEvent\n    __typename\n  }\n  __typename\n}"
        name = "AssignationChangeEvent"
        type = "AssignationChangeEvent"


class ChildPortChoices(BaseModel):
    """No documentation"""

    typename: Literal["Choice"] = Field(
        alias="__typename", default="Choice", exclude=True
    )
    value: str
    label: str
    description: Optional[str] = Field(default=None)
    model_config = ConfigDict(frozen=True)


class ChildPort(PortTrait, BaseModel):
    """No documentation"""

    typename: Literal["Port"] = Field(alias="__typename", default="Port", exclude=True)
    key: str
    kind: PortKind
    identifier: Optional[Identifier] = Field(default=None)
    children: Optional[Tuple[ChildPortNested, ...]] = Field(default=None)
    choices: Optional[Tuple[ChildPortChoices, ...]] = Field(default=None)
    nullable: bool
    default: Optional[Any] = Field(default=None)
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for ChildPort"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}"
        name = "ChildPort"
        type = "Port"


class PortEffectBase(BaseModel):
    """No documentation"""

    kind: EffectKind
    dependencies: Tuple[str, ...]
    function: ValidatorFunction


class PortEffectCatch(PortEffectBase):
    """Catch all class for PortEffectBase"""

    typename: str = Field(alias="__typename", exclude=True)
    "No documentation"
    kind: EffectKind
    dependencies: Tuple[str, ...]
    function: ValidatorFunction


class PortEffectCustomEffect(CustomEffect, PortEffectBase, BaseModel):
    """No documentation"""

    typename: Literal["CustomEffect"] = Field(
        alias="__typename", default="CustomEffect", exclude=True
    )


class PortEffectMessageEffect(MessageEffect, PortEffectBase, BaseModel):
    """No documentation"""

    typename: Literal["MessageEffect"] = Field(
        alias="__typename", default="MessageEffect", exclude=True
    )


class PortEffectHideEffect(PortEffectBase, BaseModel):
    """No documentation"""

    typename: Literal["HideEffect"] = Field(
        alias="__typename", default="HideEffect", exclude=True
    )


class PortAssignWidgetBase(BaseModel):
    """No documentation"""

    kind: AssignWidgetKind


class PortAssignWidgetCatch(PortAssignWidgetBase):
    """Catch all class for PortAssignWidgetBase"""

    typename: str = Field(alias="__typename", exclude=True)
    "No documentation"
    kind: AssignWidgetKind


class PortAssignWidgetSliderAssignWidget(
    SliderAssignWidget, PortAssignWidgetBase, BaseModel
):
    """No documentation"""

    typename: Literal["SliderAssignWidget"] = Field(
        alias="__typename", default="SliderAssignWidget", exclude=True
    )


class PortAssignWidgetChoiceAssignWidget(
    ChoiceAssignWidget, PortAssignWidgetBase, BaseModel
):
    """No documentation"""

    typename: Literal["ChoiceAssignWidget"] = Field(
        alias="__typename", default="ChoiceAssignWidget", exclude=True
    )


class PortAssignWidgetSearchAssignWidget(
    SearchAssignWidget, PortAssignWidgetBase, BaseModel
):
    """No documentation"""

    typename: Literal["SearchAssignWidget"] = Field(
        alias="__typename", default="SearchAssignWidget", exclude=True
    )


class PortAssignWidgetStateChoiceAssignWidget(PortAssignWidgetBase, BaseModel):
    """No documentation"""

    typename: Literal["StateChoiceAssignWidget"] = Field(
        alias="__typename", default="StateChoiceAssignWidget", exclude=True
    )


class PortAssignWidgetStringAssignWidget(
    StringAssignWidget, PortAssignWidgetBase, BaseModel
):
    """No documentation"""

    typename: Literal["StringAssignWidget"] = Field(
        alias="__typename", default="StringAssignWidget", exclude=True
    )


class PortAssignWidgetCustomAssignWidget(
    CustomAssignWidget, PortAssignWidgetBase, BaseModel
):
    """No documentation"""

    typename: Literal["CustomAssignWidget"] = Field(
        alias="__typename", default="CustomAssignWidget", exclude=True
    )


class ReturnWidgetBase(BaseModel):
    """No documentation"""

    kind: ReturnWidgetKind


class ReturnWidgetCatch(ReturnWidgetBase):
    """Catch all class for ReturnWidgetBase"""

    typename: str = Field(alias="__typename", exclude=True)
    "No documentation"
    kind: ReturnWidgetKind


class ReturnWidgetCustomReturnWidget(CustomReturnWidget, ReturnWidgetBase, BaseModel):
    """No documentation"""

    typename: Literal["CustomReturnWidget"] = Field(
        alias="__typename", default="CustomReturnWidget", exclude=True
    )


class ReturnWidgetChoiceReturnWidget(ChoiceReturnWidget, ReturnWidgetBase, BaseModel):
    """No documentation"""

    typename: Literal["ChoiceReturnWidget"] = Field(
        alias="__typename", default="ChoiceReturnWidget", exclude=True
    )


class PortAssignwidgetBase(BaseModel):
    """No documentation"""

    model_config = ConfigDict(frozen=True)


class PortAssignwidgetBaseSliderAssignWidget(
    PortAssignWidgetSliderAssignWidget, PortAssignwidgetBase, BaseModel
):
    """No documentation"""

    typename: Literal["SliderAssignWidget"] = Field(
        alias="__typename", default="SliderAssignWidget", exclude=True
    )


class PortAssignwidgetBaseChoiceAssignWidget(
    PortAssignWidgetChoiceAssignWidget, PortAssignwidgetBase, BaseModel
):
    """No documentation"""

    typename: Literal["ChoiceAssignWidget"] = Field(
        alias="__typename", default="ChoiceAssignWidget", exclude=True
    )


class PortAssignwidgetBaseSearchAssignWidget(
    PortAssignWidgetSearchAssignWidget, PortAssignwidgetBase, BaseModel
):
    """No documentation"""

    typename: Literal["SearchAssignWidget"] = Field(
        alias="__typename", default="SearchAssignWidget", exclude=True
    )


class PortAssignwidgetBaseStateChoiceAssignWidget(
    PortAssignWidgetStateChoiceAssignWidget, PortAssignwidgetBase, BaseModel
):
    """No documentation"""

    typename: Literal["StateChoiceAssignWidget"] = Field(
        alias="__typename", default="StateChoiceAssignWidget", exclude=True
    )


class PortAssignwidgetBaseStringAssignWidget(
    PortAssignWidgetStringAssignWidget, PortAssignwidgetBase, BaseModel
):
    """No documentation"""

    typename: Literal["StringAssignWidget"] = Field(
        alias="__typename", default="StringAssignWidget", exclude=True
    )


class PortAssignwidgetBaseCustomAssignWidget(
    PortAssignWidgetCustomAssignWidget, PortAssignwidgetBase, BaseModel
):
    """No documentation"""

    typename: Literal["CustomAssignWidget"] = Field(
        alias="__typename", default="CustomAssignWidget", exclude=True
    )


class PortAssignwidgetBaseCatchAll(PortAssignwidgetBase, BaseModel):
    """Catch all class for PortAssignwidgetBase"""

    typename: str = Field(alias="__typename", exclude=True)


class PortReturnwidgetBase(BaseModel):
    """No documentation"""

    model_config = ConfigDict(frozen=True)


class PortReturnwidgetBaseCustomReturnWidget(
    ReturnWidgetCustomReturnWidget, PortReturnwidgetBase, BaseModel
):
    """No documentation"""

    typename: Literal["CustomReturnWidget"] = Field(
        alias="__typename", default="CustomReturnWidget", exclude=True
    )


class PortReturnwidgetBaseChoiceReturnWidget(
    ReturnWidgetChoiceReturnWidget, PortReturnwidgetBase, BaseModel
):
    """No documentation"""

    typename: Literal["ChoiceReturnWidget"] = Field(
        alias="__typename", default="ChoiceReturnWidget", exclude=True
    )


class PortReturnwidgetBaseCatchAll(PortReturnwidgetBase, BaseModel):
    """Catch all class for PortReturnwidgetBase"""

    typename: str = Field(alias="__typename", exclude=True)


class PortChoices(BaseModel):
    """No documentation"""

    typename: Literal["Choice"] = Field(
        alias="__typename", default="Choice", exclude=True
    )
    value: str
    label: str
    description: Optional[str] = Field(default=None)
    model_config = ConfigDict(frozen=True)


class PortValidators(BaseModel):
    """No documentation"""

    typename: Literal["Validator"] = Field(
        alias="__typename", default="Validator", exclude=True
    )
    function: ValidatorFunction
    error_message: Optional[str] = Field(default=None, alias="errorMessage")
    dependencies: Optional[Tuple[str, ...]] = Field(default=None)
    label: Optional[str] = Field(default=None)
    model_config = ConfigDict(frozen=True)


class PortEffectsBase(BaseModel):
    """No documentation"""

    model_config = ConfigDict(frozen=True)


class PortEffectsBaseCustomEffect(PortEffectCustomEffect, PortEffectsBase, BaseModel):
    """No documentation"""

    typename: Literal["CustomEffect"] = Field(
        alias="__typename", default="CustomEffect", exclude=True
    )


class PortEffectsBaseMessageEffect(PortEffectMessageEffect, PortEffectsBase, BaseModel):
    """No documentation"""

    typename: Literal["MessageEffect"] = Field(
        alias="__typename", default="MessageEffect", exclude=True
    )


class PortEffectsBaseHideEffect(PortEffectHideEffect, PortEffectsBase, BaseModel):
    """No documentation"""

    typename: Literal["HideEffect"] = Field(
        alias="__typename", default="HideEffect", exclude=True
    )


class PortEffectsBaseCatchAll(PortEffectsBase, BaseModel):
    """Catch all class for PortEffectsBase"""

    typename: str = Field(alias="__typename", exclude=True)


class Port(PortTrait, BaseModel):
    """No documentation"""

    typename: Literal["Port"] = Field(alias="__typename", default="Port", exclude=True)
    key: str
    label: Optional[str] = Field(default=None)
    nullable: bool
    description: Optional[str] = Field(default=None)
    default: Optional[Any] = Field(default=None)
    kind: PortKind
    identifier: Optional[Identifier] = Field(default=None)
    children: Optional[Tuple[ChildPort, ...]] = Field(default=None)
    assign_widget: Optional[
        Union[
            Annotated[
                Union[
                    PortAssignwidgetBaseSliderAssignWidget,
                    PortAssignwidgetBaseChoiceAssignWidget,
                    PortAssignwidgetBaseSearchAssignWidget,
                    PortAssignwidgetBaseStateChoiceAssignWidget,
                    PortAssignwidgetBaseStringAssignWidget,
                    PortAssignwidgetBaseCustomAssignWidget,
                ],
                Field(discriminator="typename"),
            ],
            PortAssignwidgetBaseCatchAll,
        ]
    ] = Field(default=None, alias="assignWidget")
    return_widget: Optional[
        Union[
            Annotated[
                Union[
                    PortReturnwidgetBaseCustomReturnWidget,
                    PortReturnwidgetBaseChoiceReturnWidget,
                ],
                Field(discriminator="typename"),
            ],
            PortReturnwidgetBaseCatchAll,
        ]
    ] = Field(default=None, alias="returnWidget")
    choices: Optional[Tuple[PortChoices, ...]] = Field(default=None)
    validators: Optional[Tuple[PortValidators, ...]] = Field(default=None)
    effects: Optional[
        Tuple[
            Union[
                Annotated[
                    Union[
                        PortEffectsBaseCustomEffect,
                        PortEffectsBaseMessageEffect,
                        PortEffectsBaseHideEffect,
                    ],
                    Field(discriminator="typename"),
                ],
                PortEffectsBaseCatchAll,
            ],
            ...,
        ]
    ] = Field(default=None)
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for Port"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}"
        name = "Port"
        type = "Port"


class DefinitionCollections(BaseModel):
    """A grouping of actions."""

    typename: Literal["Collection"] = Field(
        alias="__typename", default="Collection", exclude=True
    )
    name: str
    "Name of the collection."
    model_config = ConfigDict(frozen=True)


class DefinitionIstestfor(Callable, BaseModel):
    """Represents an executable action in the system."""

    typename: Literal["Action"] = Field(
        alias="__typename", default="Action", exclude=True
    )
    id: ID
    "Unique ID of the action."
    model_config = ConfigDict(frozen=True)


class DefinitionPortgroups(BaseModel):
    """No documentation"""

    typename: Literal["PortGroup"] = Field(
        alias="__typename", default="PortGroup", exclude=True
    )
    key: str
    model_config = ConfigDict(frozen=True)


class Definition(Callable, BaseModel):
    """Represents an executable action in the system."""

    typename: Literal["Action"] = Field(
        alias="__typename", default="Action", exclude=True
    )
    args: Tuple[Port, ...]
    "Input arguments (ports) for the action."
    returns: Tuple[Port, ...]
    "Output values (ports) returned by the action."
    kind: ActionKind
    "The kind or category of the action."
    name: str
    "Name of the action."
    description: Optional[str] = Field(default=None)
    "Optional description of the action."
    interfaces: Tuple[str, ...]
    "Interfaces implemented by the action."
    collections: Tuple[DefinitionCollections, ...]
    "Collections to which this action belongs."
    is_dev: bool = Field(alias="isDev")
    "Marks whether the action is in development."
    is_test_for: Tuple[DefinitionIstestfor, ...] = Field(alias="isTestFor")
    "Actions for which this is a test."
    port_groups: Tuple[DefinitionPortgroups, ...] = Field(alias="portGroups")
    "Port groups used in the action for organizing ports."
    stateful: bool
    "Indicates whether the action maintains state."
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for Definition"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment Definition on Action {\n  args {\n    ...Port\n    __typename\n  }\n  returns {\n    ...Port\n    __typename\n  }\n  kind\n  name\n  description\n  interfaces\n  collections {\n    name\n    __typename\n  }\n  isDev\n  isTestFor {\n    id\n    __typename\n  }\n  portGroups {\n    key\n    __typename\n  }\n  stateful\n  __typename\n}"
        name = "Definition"
        type = "Action"


class ListAction(Callable, BaseModel):
    """Represents an executable action in the system."""

    typename: Literal["Action"] = Field(
        alias="__typename", default="Action", exclude=True
    )
    id: ID
    "Unique ID of the action."
    name: str
    "Name of the action."
    description: Optional[str] = Field(default=None)
    "Optional description of the action."
    args: Tuple[Port, ...]
    "Input arguments (ports) for the action."
    returns: Tuple[Port, ...]
    "Output values (ports) returned by the action."
    stateful: bool
    "Indicates whether the action maintains state."
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for ListAction"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment ListAction on Action {\n  id\n  name\n  description\n  args {\n    ...Port\n    __typename\n  }\n  returns {\n    ...Port\n    __typename\n  }\n  stateful\n  __typename\n}"
        name = "ListAction"
        type = "Action"


class ListShortcutAction(Callable, BaseModel):
    """Represents an executable action in the system."""

    typename: Literal["Action"] = Field(
        alias="__typename", default="Action", exclude=True
    )
    id: ID
    "Unique ID of the action."
    hash: ActionHash
    "Unique hash identifying the action definition."
    model_config = ConfigDict(frozen=True)


class ListShortcut(BaseModel):
    """Shortcut to an action with preset arguments."""

    typename: Literal["Shortcut"] = Field(
        alias="__typename", default="Shortcut", exclude=True
    )
    id: ID
    "Shortcut ID."
    name: str
    "Name of the shortcut."
    description: Optional[str] = Field(default=None)
    "Optional description."
    action: ListShortcutAction
    "The associated action."
    saved_args: Any = Field(alias="savedArgs")
    "Saved arguments for the shortcut."
    args: Tuple[Port, ...]
    "Input ports for the shortcut's action.dd"
    returns: Tuple[Port, ...]
    "Return ports from the shortcut's action."
    allow_quick: bool = Field(alias="allowQuick")
    "Allow quick execution without modification."
    use_returns: bool = Field(alias="useReturns")
    "If true, shortcut uses return values."
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for ListShortcut"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment ListShortcut on Shortcut {\n  id\n  name\n  description\n  action {\n    id\n    hash\n    __typename\n  }\n  savedArgs\n  args {\n    ...Port\n    __typename\n  }\n  returns {\n    ...Port\n    __typename\n  }\n  allowQuick\n  useReturns\n  __typename\n}"
        name = "ListShortcut"
        type = "Shortcut"


class StateSchema(BaseModel):
    """No documentation"""

    typename: Literal["StateSchema"] = Field(
        alias="__typename", default="StateSchema", exclude=True
    )
    id: ID
    name: str
    ports: Tuple[Port, ...]
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for StateSchema"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment StateSchema on StateSchema {\n  id\n  name\n  ports {\n    ...Port\n    __typename\n  }\n  __typename\n}"
        name = "StateSchema"
        type = "StateSchema"


class Action(Definition, Callable, BaseModel):
    """Represents an executable action in the system."""

    typename: Literal["Action"] = Field(
        alias="__typename", default="Action", exclude=True
    )
    hash: ActionHash
    "Unique hash identifying the action definition."
    id: ID
    "Unique ID of the action."
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for Action"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment Definition on Action {\n  args {\n    ...Port\n    __typename\n  }\n  returns {\n    ...Port\n    __typename\n  }\n  kind\n  name\n  description\n  interfaces\n  collections {\n    name\n    __typename\n  }\n  isDev\n  isTestFor {\n    id\n    __typename\n  }\n  portGroups {\n    key\n    __typename\n  }\n  stateful\n  __typename\n}\n\nfragment Action on Action {\n  hash\n  id\n  ...Definition\n  __typename\n}"
        name = "Action"
        type = "Action"


class StateAgent(BaseModel):
    """Represents a compute agent that can execute implementations."""

    typename: Literal["Agent"] = Field(
        alias="__typename", default="Agent", exclude=True
    )
    id: ID
    "Unique ID of the agent."
    model_config = ConfigDict(frozen=True)


class State(BaseModel):
    """No documentation"""

    typename: Literal["State"] = Field(
        alias="__typename", default="State", exclude=True
    )
    id: ID
    value: Args
    state_schema: StateSchema = Field(alias="stateSchema")
    "DEPRECATED Use schema instead: : None "
    agent: StateAgent
    interface: str
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for State"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment StateSchema on StateSchema {\n  id\n  name\n  ports {\n    ...Port\n    __typename\n  }\n  __typename\n}\n\nfragment State on State {\n  id\n  value\n  stateSchema {\n    ...StateSchema\n    __typename\n  }\n  agent {\n    id\n    __typename\n  }\n  interface\n  __typename\n}"
        name = "State"
        type = "State"


class ReservationWaiter(BaseModel):
    """Entity that waits for the completion of assignations."""

    typename: Literal["Waiter"] = Field(
        alias="__typename", default="Waiter", exclude=True
    )
    id: ID
    "Unique ID of the waiter."
    model_config = ConfigDict(frozen=True)


class Reservation(BaseModel):
    """Reservation for planned assignment of implementations."""

    typename: Literal["Reservation"] = Field(
        alias="__typename", default="Reservation", exclude=True
    )
    id: ID
    "ID of the reservation."
    action: Action
    "Action this reservation is for."
    waiter: ReservationWaiter
    "Waiter associated with the reservation."
    reference: str
    "Reference string for identification."
    updated_at: datetime = Field(alias="updatedAt")
    "Last update timestamp."
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for Reservation"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment Definition on Action {\n  args {\n    ...Port\n    __typename\n  }\n  returns {\n    ...Port\n    __typename\n  }\n  kind\n  name\n  description\n  interfaces\n  collections {\n    name\n    __typename\n  }\n  isDev\n  isTestFor {\n    id\n    __typename\n  }\n  portGroups {\n    key\n    __typename\n  }\n  stateful\n  __typename\n}\n\nfragment Action on Action {\n  hash\n  id\n  ...Definition\n  __typename\n}\n\nfragment Reservation on Reservation {\n  id\n  action {\n    ...Action\n    __typename\n  }\n  waiter {\n    id\n    __typename\n  }\n  reference\n  updatedAt\n  __typename\n}"
        name = "Reservation"
        type = "Reservation"


class Shortcut(BaseModel):
    """Shortcut to an action with preset arguments."""

    typename: Literal["Shortcut"] = Field(
        alias="__typename", default="Shortcut", exclude=True
    )
    id: ID
    "Shortcut ID."
    name: str
    "Name of the shortcut."
    description: Optional[str] = Field(default=None)
    "Optional description."
    action: Action
    "The associated action."
    saved_args: Any = Field(alias="savedArgs")
    "Saved arguments for the shortcut."
    args: Tuple[Port, ...]
    "Input ports for the shortcut's action.dd"
    returns: Tuple[Port, ...]
    "Return ports from the shortcut's action."
    use_returns: bool = Field(alias="useReturns")
    "If true, shortcut uses return values."
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for Shortcut"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment Definition on Action {\n  args {\n    ...Port\n    __typename\n  }\n  returns {\n    ...Port\n    __typename\n  }\n  kind\n  name\n  description\n  interfaces\n  collections {\n    name\n    __typename\n  }\n  isDev\n  isTestFor {\n    id\n    __typename\n  }\n  portGroups {\n    key\n    __typename\n  }\n  stateful\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Action on Action {\n  hash\n  id\n  ...Definition\n  __typename\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment Shortcut on Shortcut {\n  id\n  name\n  description\n  action {\n    ...Action\n    __typename\n  }\n  savedArgs\n  args {\n    ...Port\n    __typename\n  }\n  returns {\n    ...Port\n    __typename\n  }\n  useReturns\n  __typename\n}"
        name = "Shortcut"
        type = "Shortcut"


class ImplementationAgentRegistry(BaseModel):
    """Links a user and a client for registry tracking."""

    typename: Literal["Registry"] = Field(
        alias="__typename", default="Registry", exclude=True
    )
    id: ID
    "Unique identifier for the registry."
    model_config = ConfigDict(frozen=True)


class ImplementationAgent(BaseModel):
    """Represents a compute agent that can execute implementations."""

    typename: Literal["Agent"] = Field(
        alias="__typename", default="Agent", exclude=True
    )
    registry: ImplementationAgentRegistry
    "Registry entry this agent belongs to."
    model_config = ConfigDict(frozen=True)


class Implementation(BaseModel):
    """Represents a concrete implementation of an action."""

    typename: Literal["Implementation"] = Field(
        alias="__typename", default="Implementation", exclude=True
    )
    id: ID
    "Unique ID of the implementation."
    agent: ImplementationAgent
    "Agent running this implementation."
    action: Action
    "The action this implements."
    params: Any
    "Arbitrary parameters for the implementation."
    extension: str
    "Extension or module name."
    interface: str
    "Interface string representing the implementation entrypoint."
    model_config = ConfigDict(frozen=True)

    class Meta:
        """Meta class for Implementation"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment Definition on Action {\n  args {\n    ...Port\n    __typename\n  }\n  returns {\n    ...Port\n    __typename\n  }\n  kind\n  name\n  description\n  interfaces\n  collections {\n    name\n    __typename\n  }\n  isDev\n  isTestFor {\n    id\n    __typename\n  }\n  portGroups {\n    key\n    __typename\n  }\n  stateful\n  __typename\n}\n\nfragment Action on Action {\n  hash\n  id\n  ...Definition\n  __typename\n}\n\nfragment Implementation on Implementation {\n  id\n  agent {\n    registry {\n      id\n      __typename\n    }\n    __typename\n  }\n  action {\n    ...Action\n    __typename\n  }\n  params\n  extension\n  interface\n  __typename\n}"
        name = "Implementation"
        type = "Implementation"


class EnsureAgentMutation(BaseModel):
    """No documentation found for this operation."""

    ensure_agent: Agent = Field(alias="ensureAgent")
    "Ensure agent record exists or is up to date."

    class Arguments(BaseModel):
        """Arguments for EnsureAgent"""

        input: AgentInput
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for EnsureAgent"""

        document = "fragment Agent on Agent {\n  id\n  registry {\n    client {\n      id\n      __typename\n    }\n    user {\n      sub\n      __typename\n    }\n    __typename\n  }\n  memoryShelve {\n    id\n    __typename\n  }\n  __typename\n}\n\nmutation EnsureAgent($input: AgentInput!) {\n  ensureAgent(input: $input) {\n    ...Agent\n    __typename\n  }\n}"


class AssignMutation(BaseModel):
    """No documentation found for this operation."""

    assign: Assignation
    "Assign a task to an agent."

    class Arguments(BaseModel):
        """Arguments for assign"""

        input: AssignInput
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for assign"""

        document = "fragment Assignation on Assignation {\n  args\n  id\n  parent {\n    id\n    __typename\n  }\n  id\n  latestEventKind\n  events {\n    id\n    returns\n    level\n    __typename\n  }\n  instructs {\n    id\n    __typename\n  }\n  reference\n  updatedAt\n  __typename\n}\n\nmutation assign($input: AssignInput!) {\n  assign(input: $input) {\n    ...Assignation\n    __typename\n  }\n}"


class CancelMutation(BaseModel):
    """No documentation found for this operation."""

    cancel: Assignation
    "Cancel an active assignation."

    class Arguments(BaseModel):
        """Arguments for cancel"""

        input: CancelInput
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for cancel"""

        document = "fragment Assignation on Assignation {\n  args\n  id\n  parent {\n    id\n    __typename\n  }\n  id\n  latestEventKind\n  events {\n    id\n    returns\n    level\n    __typename\n  }\n  instructs {\n    id\n    __typename\n  }\n  reference\n  updatedAt\n  __typename\n}\n\nmutation cancel($input: CancelInput!) {\n  cancel(input: $input) {\n    ...Assignation\n    __typename\n  }\n}"


class InterruptMutation(BaseModel):
    """No documentation found for this operation."""

    interrupt: Assignation
    "Interrupt the execution of an assignation."

    class Arguments(BaseModel):
        """Arguments for interrupt"""

        input: InterruptInput
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for interrupt"""

        document = "fragment Assignation on Assignation {\n  args\n  id\n  parent {\n    id\n    __typename\n  }\n  id\n  latestEventKind\n  events {\n    id\n    returns\n    level\n    __typename\n  }\n  instructs {\n    id\n    __typename\n  }\n  reference\n  updatedAt\n  __typename\n}\n\nmutation interrupt($input: InterruptInput!) {\n  interrupt(input: $input) {\n    ...Assignation\n    __typename\n  }\n}"


class CollectMutation(BaseModel):
    """No documentation found for this operation."""

    collect: Tuple[str, ...]
    "Collect results from an assignation."

    class Arguments(BaseModel):
        """Arguments for collect"""

        input: CollectInput
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for collect"""

        document = (
            "mutation collect($input: CollectInput!) {\n  collect(input: $input)\n}"
        )


class CreateDashboardMutation(BaseModel):
    """No documentation found for this operation."""

    create_dashboard: Dashboard = Field(alias="createDashboard")
    "Create a dashboard layout."

    class Arguments(BaseModel):
        """Arguments for CreateDashboard"""

        input: CreateDashboardInput
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for CreateDashboard"""

        document = "fragment Dashboard on Dashboard {\n  id\n  name\n  uiTree {\n    child {\n      ... on UIGrid {\n        rowHeight\n        children {\n          x\n          y\n          w\n          h\n        }\n      }\n      __typename\n    }\n    __typename\n  }\n  __typename\n}\n\nmutation CreateDashboard($input: CreateDashboardInput!) {\n  createDashboard(input: $input) {\n    ...Dashboard\n    __typename\n  }\n}"


class ReserveMutation(BaseModel):
    """No documentation found for this operation."""

    reserve: Reservation
    "Reserve an implementation for future use."

    class Arguments(BaseModel):
        """Arguments for reserve"""

        input: ReserveInput
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for reserve"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment Definition on Action {\n  args {\n    ...Port\n    __typename\n  }\n  returns {\n    ...Port\n    __typename\n  }\n  kind\n  name\n  description\n  interfaces\n  collections {\n    name\n    __typename\n  }\n  isDev\n  isTestFor {\n    id\n    __typename\n  }\n  portGroups {\n    key\n    __typename\n  }\n  stateful\n  __typename\n}\n\nfragment Action on Action {\n  hash\n  id\n  ...Definition\n  __typename\n}\n\nfragment Reservation on Reservation {\n  id\n  action {\n    ...Action\n    __typename\n  }\n  waiter {\n    id\n    __typename\n  }\n  reference\n  updatedAt\n  __typename\n}\n\nmutation reserve($input: ReserveInput!) {\n  reserve(input: $input) {\n    ...Reservation\n    __typename\n  }\n}"


class UnreserveMutation(BaseModel):
    """No documentation found for this operation."""

    unreserve: str
    "Release a reserved implementation."

    class Arguments(BaseModel):
        """Arguments for unreserve"""

        input: UnreserveInput
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for unreserve"""

        document = "mutation unreserve($input: UnreserveInput!) {\n  unreserve(input: $input)\n}"


class ShelveMutationShelveinmemorydrawer(BaseModel):
    """No documentation"""

    typename: Literal["MemoryDrawer"] = Field(
        alias="__typename", default="MemoryDrawer", exclude=True
    )
    id: ID
    model_config = ConfigDict(frozen=True)


class ShelveMutation(BaseModel):
    """No documentation found for this operation."""

    shelve_in_memory_drawer: ShelveMutationShelveinmemorydrawer = Field(
        alias="shelveInMemoryDrawer"
    )
    "Shelve data into a memory drawer."

    class Arguments(BaseModel):
        """Arguments for shelve"""

        input: ShelveInMemoryDrawerInput
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for shelve"""

        document = "mutation shelve($input: ShelveInMemoryDrawerInput!) {\n  shelveInMemoryDrawer(input: $input) {\n    id\n    __typename\n  }\n}"


class UnshelveMutation(BaseModel):
    """No documentation found for this operation."""

    unshelve_memory_drawer: ID = Field(alias="unshelveMemoryDrawer")
    "Unshelve data from a memory drawer."

    class Arguments(BaseModel):
        """Arguments for unshelve"""

        input: UnshelveMemoryDrawerInput
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for unshelve"""

        document = "mutation unshelve($input: UnshelveMemoryDrawerInput!) {\n  unshelveMemoryDrawer(input: $input)\n}"


class CreateShortcutMutation(BaseModel):
    """No documentation found for this operation."""

    create_shortcut: Shortcut = Field(alias="createShortcut")
    "Create a shortcut to an action."

    class Arguments(BaseModel):
        """Arguments for CreateShortcut"""

        input: CreateShortcutInput
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for CreateShortcut"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment Definition on Action {\n  args {\n    ...Port\n    __typename\n  }\n  returns {\n    ...Port\n    __typename\n  }\n  kind\n  name\n  description\n  interfaces\n  collections {\n    name\n    __typename\n  }\n  isDev\n  isTestFor {\n    id\n    __typename\n  }\n  portGroups {\n    key\n    __typename\n  }\n  stateful\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Action on Action {\n  hash\n  id\n  ...Definition\n  __typename\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment Shortcut on Shortcut {\n  id\n  name\n  description\n  action {\n    ...Action\n    __typename\n  }\n  savedArgs\n  args {\n    ...Port\n    __typename\n  }\n  returns {\n    ...Port\n    __typename\n  }\n  useReturns\n  __typename\n}\n\nmutation CreateShortcut($input: CreateShortcutInput!) {\n  createShortcut(input: $input) {\n    ...Shortcut\n    __typename\n  }\n}"


class SetStateMutation(BaseModel):
    """No documentation found for this operation."""

    set_state: State = Field(alias="setState")
    "Set the value of a state object."

    class Arguments(BaseModel):
        """Arguments for SetState"""

        input: SetStateInput
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for SetState"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment StateSchema on StateSchema {\n  id\n  name\n  ports {\n    ...Port\n    __typename\n  }\n  __typename\n}\n\nfragment State on State {\n  id\n  value\n  stateSchema {\n    ...StateSchema\n    __typename\n  }\n  agent {\n    id\n    __typename\n  }\n  interface\n  __typename\n}\n\nmutation SetState($input: SetStateInput!) {\n  setState(input: $input) {\n    ...State\n    __typename\n  }\n}"


class UpdateStateMutation(BaseModel):
    """No documentation found for this operation."""

    update_state: State = Field(alias="updateState")
    "Update fields in a state object."

    class Arguments(BaseModel):
        """Arguments for UpdateState"""

        input: UpdateStateInput
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for UpdateState"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment StateSchema on StateSchema {\n  id\n  name\n  ports {\n    ...Port\n    __typename\n  }\n  __typename\n}\n\nfragment State on State {\n  id\n  value\n  stateSchema {\n    ...StateSchema\n    __typename\n  }\n  agent {\n    id\n    __typename\n  }\n  interface\n  __typename\n}\n\nmutation UpdateState($input: UpdateStateInput!) {\n  updateState(input: $input) {\n    ...State\n    __typename\n  }\n}"


class SetAgentStatesMutation(BaseModel):
    """No documentation found for this operation."""

    set_agent_states: Tuple[State, ...] = Field(alias="setAgentStates")
    "Set states for an agent."

    class Arguments(BaseModel):
        """Arguments for SetAgentStates"""

        input: SetAgentStatesInput
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for SetAgentStates"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment StateSchema on StateSchema {\n  id\n  name\n  ports {\n    ...Port\n    __typename\n  }\n  __typename\n}\n\nfragment State on State {\n  id\n  value\n  stateSchema {\n    ...StateSchema\n    __typename\n  }\n  agent {\n    id\n    __typename\n  }\n  interface\n  __typename\n}\n\nmutation SetAgentStates($input: SetAgentStatesInput!) {\n  setAgentStates(input: $input) {\n    ...State\n    __typename\n  }\n}"


class CreateStateSchemaMutation(BaseModel):
    """No documentation found for this operation."""

    create_state_schema: StateSchema = Field(alias="createStateSchema")
    "Define a new state schema."

    class Arguments(BaseModel):
        """Arguments for CreateStateSchema"""

        input: CreateStateSchemaInput
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for CreateStateSchema"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment StateSchema on StateSchema {\n  id\n  name\n  ports {\n    ...Port\n    __typename\n  }\n  __typename\n}\n\nmutation CreateStateSchema($input: CreateStateSchemaInput!) {\n  createStateSchema(input: $input) {\n    ...StateSchema\n    __typename\n  }\n}"


class CreateImplementationMutation(BaseModel):
    """No documentation found for this operation."""

    create_implementation: Implementation = Field(alias="createImplementation")
    "Create a new implementation entry."

    class Arguments(BaseModel):
        """Arguments for createImplementation"""

        input: CreateImplementationInput
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for createImplementation"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment Definition on Action {\n  args {\n    ...Port\n    __typename\n  }\n  returns {\n    ...Port\n    __typename\n  }\n  kind\n  name\n  description\n  interfaces\n  collections {\n    name\n    __typename\n  }\n  isDev\n  isTestFor {\n    id\n    __typename\n  }\n  portGroups {\n    key\n    __typename\n  }\n  stateful\n  __typename\n}\n\nfragment Action on Action {\n  hash\n  id\n  ...Definition\n  __typename\n}\n\nfragment Implementation on Implementation {\n  id\n  agent {\n    registry {\n      id\n      __typename\n    }\n    __typename\n  }\n  action {\n    ...Action\n    __typename\n  }\n  params\n  extension\n  interface\n  __typename\n}\n\nmutation createImplementation($input: CreateImplementationInput!) {\n  createImplementation(input: $input) {\n    ...Implementation\n    __typename\n  }\n}"


class SetExtensionImplementationsMutation(BaseModel):
    """No documentation found for this operation."""

    set_extension_implementations: Tuple[Implementation, ...] = Field(
        alias="setExtensionImplementations"
    )
    "Set implementations provided by an extension."

    class Arguments(BaseModel):
        """Arguments for SetExtensionImplementations"""

        input: SetExtensionImplementationsInput
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for SetExtensionImplementations"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment Definition on Action {\n  args {\n    ...Port\n    __typename\n  }\n  returns {\n    ...Port\n    __typename\n  }\n  kind\n  name\n  description\n  interfaces\n  collections {\n    name\n    __typename\n  }\n  isDev\n  isTestFor {\n    id\n    __typename\n  }\n  portGroups {\n    key\n    __typename\n  }\n  stateful\n  __typename\n}\n\nfragment Action on Action {\n  hash\n  id\n  ...Definition\n  __typename\n}\n\nfragment Implementation on Implementation {\n  id\n  agent {\n    registry {\n      id\n      __typename\n    }\n    __typename\n  }\n  action {\n    ...Action\n    __typename\n  }\n  params\n  extension\n  interface\n  __typename\n}\n\nmutation SetExtensionImplementations($input: SetExtensionImplementationsInput!) {\n  setExtensionImplementations(input: $input) {\n    ...Implementation\n    __typename\n  }\n}"


class Create_testcaseMutation(BaseModel):
    """No documentation found for this operation."""

    create_test_case: TestCase = Field(alias="createTestCase")
    "Create a new test case."

    class Arguments(BaseModel):
        """Arguments for create_testcase"""

        input: CreateTestCaseInput
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for create_testcase"""

        document = "fragment TestCase on TestCase {\n  id\n  action {\n    id\n    __typename\n  }\n  isBenchmark\n  description\n  name\n  __typename\n}\n\nmutation create_testcase($input: CreateTestCaseInput!) {\n  createTestCase(input: $input) {\n    ...TestCase\n    __typename\n  }\n}"


class Create_testresultMutation(BaseModel):
    """No documentation found for this operation."""

    create_test_result: TestResult = Field(alias="createTestResult")
    "Create a test result record."

    class Arguments(BaseModel):
        """Arguments for create_testresult"""

        input: CreateTestResultInput
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for create_testresult"""

        document = "fragment TestResult on TestResult {\n  id\n  case {\n    id\n    __typename\n  }\n  passed\n  __typename\n}\n\nmutation create_testresult($input: CreateTestResultInput!) {\n  createTestResult(input: $input) {\n    ...TestResult\n    __typename\n  }\n}"


class GetAgentQuery(BaseModel):
    """No documentation found for this operation."""

    agent: Agent
    "Retrieve an agent by ID."

    class Arguments(BaseModel):
        """Arguments for GetAgent"""

        id: ID
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for GetAgent"""

        document = "fragment Agent on Agent {\n  id\n  registry {\n    client {\n      id\n      __typename\n    }\n    user {\n      sub\n      __typename\n    }\n    __typename\n  }\n  memoryShelve {\n    id\n    __typename\n  }\n  __typename\n}\n\nquery GetAgent($id: ID!) {\n  agent(id: $id) {\n    ...Agent\n    __typename\n  }\n}"


class ListAgentsQuery(BaseModel):
    """No documentation found for this operation."""

    agents: Tuple[Agent, ...]
    "Retrieve all compute agents."

    class Arguments(BaseModel):
        """Arguments for ListAgents"""

        filters: Optional[AgentFilter] = Field(default=None)
        pagination: Optional[OffsetPaginationInput] = Field(default=None)
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for ListAgents"""

        document = "fragment Agent on Agent {\n  id\n  registry {\n    client {\n      id\n      __typename\n    }\n    user {\n      sub\n      __typename\n    }\n    __typename\n  }\n  memoryShelve {\n    id\n    __typename\n  }\n  __typename\n}\n\nquery ListAgents($filters: AgentFilter, $pagination: OffsetPaginationInput) {\n  agents(filters: $filters, pagination: $pagination) {\n    ...Agent\n    __typename\n  }\n}"


class RequestsQuery(BaseModel):
    """No documentation found for this operation."""

    assignations: Tuple[Assignation, ...]
    "Fetch assignations."

    class Arguments(BaseModel):
        """Arguments for requests"""

        instance_id: InstanceID
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for requests"""

        document = "fragment Assignation on Assignation {\n  args\n  id\n  parent {\n    id\n    __typename\n  }\n  id\n  latestEventKind\n  events {\n    id\n    returns\n    level\n    __typename\n  }\n  instructs {\n    id\n    __typename\n  }\n  reference\n  updatedAt\n  __typename\n}\n\nquery requests($instance_id: InstanceId!) {\n  assignations(instanceId: $instance_id) {\n    ...Assignation\n    __typename\n  }\n}"


class GetEventQuery(BaseModel):
    """No documentation found for this operation."""

    event: Tuple[AssignationEvent, ...]
    "Fetch a specific event."

    class Arguments(BaseModel):
        """Arguments for GetEvent"""

        id: Optional[ID] = Field(default=None)
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for GetEvent"""

        document = "fragment AssignationEvent on AssignationEvent {\n  id\n  kind\n  returns\n  reference\n  message\n  progress\n  __typename\n}\n\nquery GetEvent($id: ID) {\n  event(id: $id) {\n    ...AssignationEvent\n    __typename\n  }\n}"


class GetDashboardQuery(BaseModel):
    """No documentation found for this operation."""

    dashboard: Dashboard
    "Get dashboard by ID."

    class Arguments(BaseModel):
        """Arguments for GetDashboard"""

        id: ID
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for GetDashboard"""

        document = "fragment Dashboard on Dashboard {\n  id\n  name\n  uiTree {\n    child {\n      ... on UIGrid {\n        rowHeight\n        children {\n          x\n          y\n          w\n          h\n        }\n      }\n      __typename\n    }\n    __typename\n  }\n  __typename\n}\n\nquery GetDashboard($id: ID!) {\n  dashboard(id: $id) {\n    ...Dashboard\n    __typename\n  }\n}"


class GetMeActionsQueryActions(Callable, BaseModel):
    """Represents an executable action in the system."""

    typename: Literal["Action"] = Field(
        alias="__typename", default="Action", exclude=True
    )
    id: ID
    "Unique ID of the action."
    name: str
    "Name of the action."
    model_config = ConfigDict(frozen=True)


class GetMeActionsQuery(BaseModel):
    """No documentation found for this operation."""

    actions: Tuple[GetMeActionsQueryActions, ...]
    "List of all available actions."

    class Arguments(BaseModel):
        """Arguments for GetMeActions"""

        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for GetMeActions"""

        document = "query GetMeActions {\n  actions {\n    id\n    name\n    __typename\n  }\n}"


class FindQuery(BaseModel):
    """No documentation found for this operation."""

    action: Action
    "Fetch a specific action."

    class Arguments(BaseModel):
        """Arguments for find"""

        id: Optional[ID] = Field(default=None)
        implementation: Optional[ID] = Field(default=None)
        hash: Optional[ActionHash] = Field(default=None)
        matching: Optional[ActionDependencyInput] = Field(default=None)
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for find"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment Definition on Action {\n  args {\n    ...Port\n    __typename\n  }\n  returns {\n    ...Port\n    __typename\n  }\n  kind\n  name\n  description\n  interfaces\n  collections {\n    name\n    __typename\n  }\n  isDev\n  isTestFor {\n    id\n    __typename\n  }\n  portGroups {\n    key\n    __typename\n  }\n  stateful\n  __typename\n}\n\nfragment Action on Action {\n  hash\n  id\n  ...Definition\n  __typename\n}\n\nquery find($id: ID, $implementation: ID, $hash: ActionHash, $matching: ActionDependencyInput) {\n  action(\n    id: $id\n    implementation: $implementation\n    hash: $hash\n    matching: $matching\n  ) {\n    ...Action\n    __typename\n  }\n}"


class RetrieveallQuery(BaseModel):
    """No documentation found for this operation."""

    actions: Tuple[Action, ...]
    "List of all available actions."

    class Arguments(BaseModel):
        """Arguments for retrieveall"""

        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for retrieveall"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment Definition on Action {\n  args {\n    ...Port\n    __typename\n  }\n  returns {\n    ...Port\n    __typename\n  }\n  kind\n  name\n  description\n  interfaces\n  collections {\n    name\n    __typename\n  }\n  isDev\n  isTestFor {\n    id\n    __typename\n  }\n  portGroups {\n    key\n    __typename\n  }\n  stateful\n  __typename\n}\n\nfragment Action on Action {\n  hash\n  id\n  ...Definition\n  __typename\n}\n\nquery retrieveall {\n  actions {\n    ...Action\n    __typename\n  }\n}"


class SearchActionsQueryOptions(Callable, BaseModel):
    """Represents an executable action in the system."""

    typename: Literal["Action"] = Field(
        alias="__typename", default="Action", exclude=True
    )
    label: str
    "Name of the action."
    value: ID
    "Unique ID of the action."
    model_config = ConfigDict(frozen=True)


class SearchActionsQuery(BaseModel):
    """No documentation found for this operation."""

    options: Tuple[SearchActionsQueryOptions, ...]
    "List of all available actions."

    class Arguments(BaseModel):
        """Arguments for SearchActions"""

        search: Optional[str] = Field(default=None)
        values: Optional[List[ID]] = Field(default=None)
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for SearchActions"""

        document = "query SearchActions($search: String, $values: [ID!]) {\n  options: actions(\n    filters: {name: {iContains: $search}, ids: $values}\n    pagination: {limit: 10}\n  ) {\n    label: name\n    value: id\n    __typename\n  }\n}"


class ListActionsQuery(BaseModel):
    """No documentation found for this operation."""

    actions: Tuple[ListAction, ...]
    "List of all available actions."

    class Arguments(BaseModel):
        """Arguments for ListActions"""

        filters: Optional[ActionFilter] = Field(default=None)
        pagination: Optional[OffsetPaginationInput] = Field(default=None)
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for ListActions"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment ListAction on Action {\n  id\n  name\n  description\n  args {\n    ...Port\n    __typename\n  }\n  returns {\n    ...Port\n    __typename\n  }\n  stateful\n  __typename\n}\n\nquery ListActions($filters: ActionFilter, $pagination: OffsetPaginationInput) {\n  actions(filters: $filters, pagination: $pagination) {\n    ...ListAction\n    __typename\n  }\n}"


class PrimaryActionsQuery(BaseModel):
    """No documentation found for this operation."""

    actions: Tuple[PrimaryAction, ...]
    "List of all available actions."

    class Arguments(BaseModel):
        """Arguments for PrimaryActions"""

        pagination: Optional[OffsetPaginationInput] = Field(default=None)
        identifier: Optional[str] = Field(default=None)
        order: Optional[ActionOrder] = Field(default=None)
        search: Optional[str] = Field(default=None)
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for PrimaryActions"""

        document = "fragment PrimaryAction on Action {\n  name\n  id\n  hash\n  description\n  __typename\n}\n\nquery PrimaryActions($pagination: OffsetPaginationInput, $identifier: String, $order: ActionOrder, $search: String) {\n  actions(\n    order: $order\n    pagination: $pagination\n    filters: {demands: [{kind: ARGS, matches: [{at: 0, kind: STRUCTURE, identifier: $identifier}]}], search: $search}\n  ) {\n    ...PrimaryAction\n    __typename\n  }\n}"


class Get_reservationQuery(BaseModel):
    """No documentation found for this operation."""

    reservation: Reservation
    "Retrieve reservation by ID."

    class Arguments(BaseModel):
        """Arguments for get_reservation"""

        id: ID
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for get_reservation"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment Definition on Action {\n  args {\n    ...Port\n    __typename\n  }\n  returns {\n    ...Port\n    __typename\n  }\n  kind\n  name\n  description\n  interfaces\n  collections {\n    name\n    __typename\n  }\n  isDev\n  isTestFor {\n    id\n    __typename\n  }\n  portGroups {\n    key\n    __typename\n  }\n  stateful\n  __typename\n}\n\nfragment Action on Action {\n  hash\n  id\n  ...Definition\n  __typename\n}\n\nfragment Reservation on Reservation {\n  id\n  action {\n    ...Action\n    __typename\n  }\n  waiter {\n    id\n    __typename\n  }\n  reference\n  updatedAt\n  __typename\n}\n\nquery get_reservation($id: ID!) {\n  reservation(id: $id) {\n    ...Reservation\n    __typename\n  }\n}"


class ReservationsQuery(BaseModel):
    """No documentation found for this operation."""

    reservations: Tuple[Reservation, ...]
    "List of all reservations."

    class Arguments(BaseModel):
        """Arguments for reservations"""

        instance_id: InstanceID
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for reservations"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment Definition on Action {\n  args {\n    ...Port\n    __typename\n  }\n  returns {\n    ...Port\n    __typename\n  }\n  kind\n  name\n  description\n  interfaces\n  collections {\n    name\n    __typename\n  }\n  isDev\n  isTestFor {\n    id\n    __typename\n  }\n  portGroups {\n    key\n    __typename\n  }\n  stateful\n  __typename\n}\n\nfragment Action on Action {\n  hash\n  id\n  ...Definition\n  __typename\n}\n\nfragment Reservation on Reservation {\n  id\n  action {\n    ...Action\n    __typename\n  }\n  waiter {\n    id\n    __typename\n  }\n  reference\n  updatedAt\n  __typename\n}\n\nquery reservations($instance_id: InstanceId!) {\n  reservations(instanceId: $instance_id) {\n    ...Reservation\n    __typename\n  }\n}"


class ListShortcutsQuery(BaseModel):
    """No documentation found for this operation."""

    shortcuts: Tuple[ListShortcut, ...]
    "List of shortcuts."

    class Arguments(BaseModel):
        """Arguments for ListShortcuts"""

        pagination: Optional[OffsetPaginationInput] = Field(default=None)
        filters: Optional[ShortcutFilter] = Field(default=None)
        order: Optional[ShortcutOrder] = Field(default=None)
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for ListShortcuts"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment ListShortcut on Shortcut {\n  id\n  name\n  description\n  action {\n    id\n    hash\n    __typename\n  }\n  savedArgs\n  args {\n    ...Port\n    __typename\n  }\n  returns {\n    ...Port\n    __typename\n  }\n  allowQuick\n  useReturns\n  __typename\n}\n\nquery ListShortcuts($pagination: OffsetPaginationInput, $filters: ShortcutFilter, $order: ShortcutOrder) {\n  shortcuts(order: $order, pagination: $pagination, filters: $filters) {\n    ...ListShortcut\n    __typename\n  }\n}"


class GetShortcutQuery(BaseModel):
    """No documentation found for this operation."""

    shortcut: Shortcut
    "Retrieve shortcut by ID."

    class Arguments(BaseModel):
        """Arguments for GetShortcut"""

        id: ID
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for GetShortcut"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment Definition on Action {\n  args {\n    ...Port\n    __typename\n  }\n  returns {\n    ...Port\n    __typename\n  }\n  kind\n  name\n  description\n  interfaces\n  collections {\n    name\n    __typename\n  }\n  isDev\n  isTestFor {\n    id\n    __typename\n  }\n  portGroups {\n    key\n    __typename\n  }\n  stateful\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Action on Action {\n  hash\n  id\n  ...Definition\n  __typename\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment Shortcut on Shortcut {\n  id\n  name\n  description\n  action {\n    ...Action\n    __typename\n  }\n  savedArgs\n  args {\n    ...Port\n    __typename\n  }\n  returns {\n    ...Port\n    __typename\n  }\n  useReturns\n  __typename\n}\n\nquery GetShortcut($id: ID!) {\n  shortcut(id: $id) {\n    ...Shortcut\n    __typename\n  }\n}"


class Get_implementationQuery(BaseModel):
    """No documentation found for this operation."""

    implementation: Implementation
    "Get implementation by ID."

    class Arguments(BaseModel):
        """Arguments for get_implementation"""

        id: ID
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for get_implementation"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment Definition on Action {\n  args {\n    ...Port\n    __typename\n  }\n  returns {\n    ...Port\n    __typename\n  }\n  kind\n  name\n  description\n  interfaces\n  collections {\n    name\n    __typename\n  }\n  isDev\n  isTestFor {\n    id\n    __typename\n  }\n  portGroups {\n    key\n    __typename\n  }\n  stateful\n  __typename\n}\n\nfragment Action on Action {\n  hash\n  id\n  ...Definition\n  __typename\n}\n\nfragment Implementation on Implementation {\n  id\n  agent {\n    registry {\n      id\n      __typename\n    }\n    __typename\n  }\n  action {\n    ...Action\n    __typename\n  }\n  params\n  extension\n  interface\n  __typename\n}\n\nquery get_implementation($id: ID!) {\n  implementation(id: $id) {\n    ...Implementation\n    __typename\n  }\n}"


class Search_implementationsQueryOptions(BaseModel):
    """Represents a concrete implementation of an action."""

    typename: Literal["Implementation"] = Field(
        alias="__typename", default="Implementation", exclude=True
    )
    label: str
    "Constructed name for display, combining interface and agent name."
    value: ID
    "Unique ID of the implementation."
    model_config = ConfigDict(frozen=True)


class Search_implementationsQuery(BaseModel):
    """No documentation found for this operation."""

    options: Tuple[Search_implementationsQueryOptions, ...]
    "All registered implementations."

    class Arguments(BaseModel):
        """Arguments for search_implementations"""

        search: Optional[str] = Field(default=None)
        values: Optional[List[ID]] = Field(default=None)
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for search_implementations"""

        document = "query search_implementations($search: String, $values: [ID!]) {\n  options: implementations(\n    filters: {interface: {iContains: $search}, ids: $values}\n    pagination: {limit: 10}\n  ) {\n    label: name\n    value: id\n    __typename\n  }\n}"


class Implementations_forQuery(BaseModel):
    """No documentation found for this operation."""

    implementations: Tuple[Implementation, ...]
    "All registered implementations."

    class Arguments(BaseModel):
        """Arguments for implementations_for"""

        hash: ActionHash
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for implementations_for"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment Definition on Action {\n  args {\n    ...Port\n    __typename\n  }\n  returns {\n    ...Port\n    __typename\n  }\n  kind\n  name\n  description\n  interfaces\n  collections {\n    name\n    __typename\n  }\n  isDev\n  isTestFor {\n    id\n    __typename\n  }\n  portGroups {\n    key\n    __typename\n  }\n  stateful\n  __typename\n}\n\nfragment Action on Action {\n  hash\n  id\n  ...Definition\n  __typename\n}\n\nfragment Implementation on Implementation {\n  id\n  agent {\n    registry {\n      id\n      __typename\n    }\n    __typename\n  }\n  action {\n    ...Action\n    __typename\n  }\n  params\n  extension\n  interface\n  __typename\n}\n\nquery implementations_for($hash: ActionHash!) {\n  implementations(filters: {actionHash: $hash}) {\n    ...Implementation\n    __typename\n  }\n}"


class MyImplementationAtQuery(BaseModel):
    """No documentation found for this operation."""

    my_implementation_at: Implementation = Field(alias="myImplementationAt")
    "Find your implementation at a specific interface."

    class Arguments(BaseModel):
        """Arguments for MyImplementationAt"""

        instance_id: str = Field(alias="instanceId")
        interface: Optional[str] = Field(default=None)
        action_id: Optional[ID] = Field(alias="actionId", default=None)
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for MyImplementationAt"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment Definition on Action {\n  args {\n    ...Port\n    __typename\n  }\n  returns {\n    ...Port\n    __typename\n  }\n  kind\n  name\n  description\n  interfaces\n  collections {\n    name\n    __typename\n  }\n  isDev\n  isTestFor {\n    id\n    __typename\n  }\n  portGroups {\n    key\n    __typename\n  }\n  stateful\n  __typename\n}\n\nfragment Action on Action {\n  hash\n  id\n  ...Definition\n  __typename\n}\n\nfragment Implementation on Implementation {\n  id\n  agent {\n    registry {\n      id\n      __typename\n    }\n    __typename\n  }\n  action {\n    ...Action\n    __typename\n  }\n  params\n  extension\n  interface\n  __typename\n}\n\nquery MyImplementationAt($instanceId: String!, $interface: String, $actionId: ID) {\n  myImplementationAt(\n    instanceId: $instanceId\n    interface: $interface\n    actionId: $actionId\n  ) {\n    ...Implementation\n    __typename\n  }\n}"


class Get_testcaseQuery(BaseModel):
    """No documentation found for this operation."""

    test_case: TestCase = Field(alias="testCase")
    "Retrieve test case by ID."

    class Arguments(BaseModel):
        """Arguments for get_testcase"""

        id: ID
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for get_testcase"""

        document = "fragment TestCase on TestCase {\n  id\n  action {\n    id\n    __typename\n  }\n  isBenchmark\n  description\n  name\n  __typename\n}\n\nquery get_testcase($id: ID!) {\n  testCase(id: $id) {\n    ...TestCase\n    __typename\n  }\n}"


class Get_testresultQuery(BaseModel):
    """No documentation found for this operation."""

    test_result: TestResult = Field(alias="testResult")
    "Get test result by ID."

    class Arguments(BaseModel):
        """Arguments for get_testresult"""

        id: ID
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for get_testresult"""

        document = "fragment TestResult on TestResult {\n  id\n  case {\n    id\n    __typename\n  }\n  passed\n  __typename\n}\n\nquery get_testresult($id: ID!) {\n  testResult(id: $id) {\n    ...TestResult\n    __typename\n  }\n}"


class Search_testcasesQueryOptions(BaseModel):
    """Defines a test case comparing expected behavior for actions."""

    typename: Literal["TestCase"] = Field(
        alias="__typename", default="TestCase", exclude=True
    )
    label: str
    "Short name for the test case."
    value: ID
    "Unique ID of the test case."
    model_config = ConfigDict(frozen=True)


class Search_testcasesQuery(BaseModel):
    """No documentation found for this operation."""

    options: Tuple[Search_testcasesQueryOptions, ...]
    "All test cases."

    class Arguments(BaseModel):
        """Arguments for search_testcases"""

        search: Optional[str] = Field(default=None)
        values: Optional[List[ID]] = Field(default=None)
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for search_testcases"""

        document = "query search_testcases($search: String, $values: [ID!]) {\n  options: testCases(\n    filters: {name: {iContains: $search}, ids: $values}\n    pagination: {limit: 10}\n  ) {\n    label: name\n    value: id\n    __typename\n  }\n}"


class Search_testresultsQueryOptions(BaseModel):
    """Result from executing a test case with specific implementations."""

    typename: Literal["TestResult"] = Field(
        alias="__typename", default="TestResult", exclude=True
    )
    label: datetime
    "When the test was executed."
    value: ID
    "ID of the test result."
    model_config = ConfigDict(frozen=True)


class Search_testresultsQuery(BaseModel):
    """No documentation found for this operation."""

    options: Tuple[Search_testresultsQueryOptions, ...]
    "Test results associated with test cases."

    class Arguments(BaseModel):
        """Arguments for search_testresults"""

        search: Optional[str] = Field(default=None)
        values: Optional[List[ID]] = Field(default=None)
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for search_testresults"""

        document = "query search_testresults($search: String, $values: [ID!]) {\n  options: testResults(\n    filters: {name: {iContains: $search}, ids: $values}\n    pagination: {limit: 10}\n  ) {\n    label: createdAt\n    value: id\n    __typename\n  }\n}"


class ListToolboxesQuery(BaseModel):
    """No documentation found for this operation."""

    toolboxes: Tuple[ListToolbox, ...]
    "List of toolboxes containing shortcuts."

    class Arguments(BaseModel):
        """Arguments for ListToolboxes"""

        pagination: Optional[OffsetPaginationInput] = Field(default=None)
        filters: Optional[ToolboxFilter] = Field(default=None)
        order: Optional[ToolboxOrder] = Field(default=None)
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for ListToolboxes"""

        document = "fragment ListToolbox on Toolbox {\n  id\n  name\n  description\n  __typename\n}\n\nquery ListToolboxes($pagination: OffsetPaginationInput, $filters: ToolboxFilter, $order: ToolboxOrder) {\n  toolboxes(order: $order, pagination: $pagination, filters: $filters) {\n    ...ListToolbox\n    __typename\n  }\n}"


class GetToolboxQuery(BaseModel):
    """No documentation found for this operation."""

    toolbox: Toolbox
    "Get toolbox by ID."

    class Arguments(BaseModel):
        """Arguments for GetToolbox"""

        id: ID
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for GetToolbox"""

        document = "fragment Toolbox on Toolbox {\n  id\n  name\n  description\n  __typename\n}\n\nquery GetToolbox($id: ID!) {\n  toolbox(id: $id) {\n    ...Toolbox\n    __typename\n  }\n}"


class WatchAssignationsSubscription(BaseModel):
    """No documentation found for this operation."""

    assignations: AssignationChangeEvent
    "Subscribe to updates on assignations."

    class Arguments(BaseModel):
        """Arguments for WatchAssignations"""

        instance_id: InstanceID = Field(alias="instanceId")
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for WatchAssignations"""

        document = "fragment Assignation on Assignation {\n  args\n  id\n  parent {\n    id\n    __typename\n  }\n  id\n  latestEventKind\n  events {\n    id\n    returns\n    level\n    __typename\n  }\n  instructs {\n    id\n    __typename\n  }\n  reference\n  updatedAt\n  __typename\n}\n\nfragment AssignationEvent on AssignationEvent {\n  id\n  kind\n  returns\n  reference\n  message\n  progress\n  __typename\n}\n\nfragment AssignationChangeEvent on AssignationChangeEvent {\n  create {\n    ...Assignation\n    __typename\n  }\n  event {\n    ...AssignationEvent\n    __typename\n  }\n  __typename\n}\n\nsubscription WatchAssignations($instanceId: InstanceId!) {\n  assignations(instanceId: $instanceId) {\n    ...AssignationChangeEvent\n    __typename\n  }\n}"


class WatchReservationsSubscription(BaseModel):
    """No documentation found for this operation."""

    reservations: Reservation
    "Subscribe to updates on reservations."

    class Arguments(BaseModel):
        """Arguments for WatchReservations"""

        instance_id: InstanceID = Field(alias="instanceId")
        model_config = ConfigDict(populate_by_name=True)

    class Meta:
        """Meta class for WatchReservations"""

        document = "fragment ChildPortNested on Port {\n  key\n  kind\n  children {\n    key\n    identifier\n    nullable\n    kind\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  identifier\n  nullable\n  default\n  __typename\n}\n\nfragment ChoiceAssignWidget on ChoiceAssignWidget {\n  __typename\n  kind\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n}\n\nfragment ChoiceReturnWidget on ChoiceReturnWidget {\n  __typename\n  choices {\n    label\n    value\n    description\n    __typename\n  }\n}\n\nfragment CustomAssignWidget on CustomAssignWidget {\n  __typename\n  ward\n  hook\n}\n\nfragment CustomEffect on CustomEffect {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment CustomReturnWidget on CustomReturnWidget {\n  __typename\n  kind\n  hook\n  ward\n}\n\nfragment MessageEffect on MessageEffect {\n  __typename\n  kind\n  message\n}\n\nfragment SearchAssignWidget on SearchAssignWidget {\n  __typename\n  kind\n  query\n  ward\n  dependencies\n}\n\nfragment SliderAssignWidget on SliderAssignWidget {\n  __typename\n  kind\n  min\n  max\n  step\n}\n\nfragment StringAssignWidget on StringAssignWidget {\n  __typename\n  kind\n  placeholder\n  asParagraph\n}\n\nfragment ChildPort on Port {\n  key\n  kind\n  identifier\n  children {\n    ...ChildPortNested\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  nullable\n  default\n  __typename\n}\n\nfragment PortAssignWidget on AssignWidget {\n  __typename\n  kind\n  ...StringAssignWidget\n  ...SearchAssignWidget\n  ...SliderAssignWidget\n  ...ChoiceAssignWidget\n  ...CustomAssignWidget\n}\n\nfragment PortEffect on Effect {\n  __typename\n  kind\n  dependencies\n  function\n  ...CustomEffect\n  ...MessageEffect\n}\n\nfragment ReturnWidget on ReturnWidget {\n  __typename\n  kind\n  ...CustomReturnWidget\n  ...ChoiceReturnWidget\n}\n\nfragment Port on Port {\n  __typename\n  key\n  label\n  nullable\n  description\n  default\n  kind\n  identifier\n  children {\n    ...ChildPort\n    __typename\n  }\n  assignWidget {\n    ...PortAssignWidget\n    __typename\n  }\n  returnWidget {\n    ...ReturnWidget\n    __typename\n  }\n  choices {\n    value\n    label\n    description\n    __typename\n  }\n  validators {\n    function\n    errorMessage\n    dependencies\n    label\n    __typename\n  }\n  effects {\n    ...PortEffect\n    __typename\n  }\n}\n\nfragment Definition on Action {\n  args {\n    ...Port\n    __typename\n  }\n  returns {\n    ...Port\n    __typename\n  }\n  kind\n  name\n  description\n  interfaces\n  collections {\n    name\n    __typename\n  }\n  isDev\n  isTestFor {\n    id\n    __typename\n  }\n  portGroups {\n    key\n    __typename\n  }\n  stateful\n  __typename\n}\n\nfragment Action on Action {\n  hash\n  id\n  ...Definition\n  __typename\n}\n\nfragment Reservation on Reservation {\n  id\n  action {\n    ...Action\n    __typename\n  }\n  waiter {\n    id\n    __typename\n  }\n  reference\n  updatedAt\n  __typename\n}\n\nsubscription WatchReservations($instanceId: InstanceId!) {\n  reservations(instanceId: $instanceId) {\n    ...Reservation\n    __typename\n  }\n}"


async def aensure_agent(
    instance_id: InstanceID,
    name: Optional[str] = None,
    extensions: Optional[Iterable[str]] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Agent:
    """EnsureAgent

    Ensure agent record exists or is up to date.

    Args:
        instance_id: The instance ID of the agent. This is used to identify the agent in the system.
        name: The name of the agent. This is used to identify the agent in the system.
        extensions: The extensions of the agent. This is used to identify the agent in the system.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Agent
    """
    return (
        await aexecute(
            EnsureAgentMutation,
            {
                "input": {
                    "instanceId": instance_id,
                    "name": name,
                    "extensions": extensions,
                }
            },
            rath=rath,
        )
    ).ensure_agent


def ensure_agent(
    instance_id: InstanceID,
    name: Optional[str] = None,
    extensions: Optional[Iterable[str]] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Agent:
    """EnsureAgent

    Ensure agent record exists or is up to date.

    Args:
        instance_id: The instance ID of the agent. This is used to identify the agent in the system.
        name: The name of the agent. This is used to identify the agent in the system.
        extensions: The extensions of the agent. This is used to identify the agent in the system.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Agent
    """
    return execute(
        EnsureAgentMutation,
        {"input": {"instanceId": instance_id, "name": name, "extensions": extensions}},
        rath=rath,
    ).ensure_agent


async def aassign(
    instance_id: InstanceID,
    args: Args,
    cached: bool,
    log: bool,
    capture: bool,
    ephemeral: bool,
    action: Optional[IDCoercible] = None,
    implementation: Optional[IDCoercible] = None,
    agent: Optional[IDCoercible] = None,
    action_hash: Optional[ActionHash] = None,
    reservation: Optional[IDCoercible] = None,
    interface: Optional[str] = None,
    hooks: Optional[Iterable[HookInput]] = None,
    reference: Optional[str] = "6a818477-94ae-4f1d-8b04-41d4f9e015ea",
    parent: Optional[IDCoercible] = None,
    dependencies: Optional[Args] = None,
    is_hook: Optional[bool] = None,
    step: Optional[bool] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Assignation:
    """assign

    Assign a task to an agent.

    Args:
        instance_id: The `InstanceID` scalar type represents a unique instance identifier (required)
        action: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID.
        implementation: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID.
        agent: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID.
        action_hash: The `ArrayLike` scalar type represents a reference to a store previously created by the user n a datalayer
        reservation: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID.
        interface: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text.
        hooks: A hook is a function that is called when a action has reached a specific lifecycle point. Hooks are jsut actions that take an assignation as input and return a value. (required) (list)
        args: The `Args` scalar type represents a Dictionary of arguments (required)
        reference: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text.
        parent: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID.
        cached: The `Boolean` scalar type represents `true` or `false`. (required)
        log: The `Boolean` scalar type represents `true` or `false`. (required)
        capture: The `Boolean` scalar type represents `true` or `false`. (required)
        ephemeral: The `Boolean` scalar type represents `true` or `false`. (required)
        dependencies: The `Args` scalar type represents a Dictionary of arguments
        is_hook: The `Boolean` scalar type represents `true` or `false`.
        step: The `Boolean` scalar type represents `true` or `false`.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Assignation
    """
    return (
        await aexecute(
            AssignMutation,
            {
                "input": {
                    "instanceId": instance_id,
                    "action": action,
                    "implementation": implementation,
                    "agent": agent,
                    "actionHash": action_hash,
                    "reservation": reservation,
                    "interface": interface,
                    "hooks": hooks,
                    "args": args,
                    "reference": reference,
                    "parent": parent,
                    "cached": cached,
                    "log": log,
                    "capture": capture,
                    "ephemeral": ephemeral,
                    "dependencies": dependencies,
                    "isHook": is_hook,
                    "step": step,
                }
            },
            rath=rath,
        )
    ).assign


def assign(
    instance_id: InstanceID,
    args: Args,
    cached: bool,
    log: bool,
    capture: bool,
    ephemeral: bool,
    action: Optional[IDCoercible] = None,
    implementation: Optional[IDCoercible] = None,
    agent: Optional[IDCoercible] = None,
    action_hash: Optional[ActionHash] = None,
    reservation: Optional[IDCoercible] = None,
    interface: Optional[str] = None,
    hooks: Optional[Iterable[HookInput]] = None,
    reference: Optional[str] = "6a818477-94ae-4f1d-8b04-41d4f9e015ea",
    parent: Optional[IDCoercible] = None,
    dependencies: Optional[Args] = None,
    is_hook: Optional[bool] = None,
    step: Optional[bool] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Assignation:
    """assign

    Assign a task to an agent.

    Args:
        instance_id: The `InstanceID` scalar type represents a unique instance identifier (required)
        action: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID.
        implementation: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID.
        agent: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID.
        action_hash: The `ArrayLike` scalar type represents a reference to a store previously created by the user n a datalayer
        reservation: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID.
        interface: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text.
        hooks: A hook is a function that is called when a action has reached a specific lifecycle point. Hooks are jsut actions that take an assignation as input and return a value. (required) (list)
        args: The `Args` scalar type represents a Dictionary of arguments (required)
        reference: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text.
        parent: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID.
        cached: The `Boolean` scalar type represents `true` or `false`. (required)
        log: The `Boolean` scalar type represents `true` or `false`. (required)
        capture: The `Boolean` scalar type represents `true` or `false`. (required)
        ephemeral: The `Boolean` scalar type represents `true` or `false`. (required)
        dependencies: The `Args` scalar type represents a Dictionary of arguments
        is_hook: The `Boolean` scalar type represents `true` or `false`.
        step: The `Boolean` scalar type represents `true` or `false`.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Assignation
    """
    return execute(
        AssignMutation,
        {
            "input": {
                "instanceId": instance_id,
                "action": action,
                "implementation": implementation,
                "agent": agent,
                "actionHash": action_hash,
                "reservation": reservation,
                "interface": interface,
                "hooks": hooks,
                "args": args,
                "reference": reference,
                "parent": parent,
                "cached": cached,
                "log": log,
                "capture": capture,
                "ephemeral": ephemeral,
                "dependencies": dependencies,
                "isHook": is_hook,
                "step": step,
            }
        },
        rath=rath,
    ).assign


async def acancel(
    assignation: IDCoercible, rath: Optional[RekuestNextRath] = None
) -> Assignation:
    """cancel

    Cancel an active assignation.

    Args:
        assignation: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID. (required)
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Assignation
    """
    return (
        await aexecute(
            CancelMutation, {"input": {"assignation": assignation}}, rath=rath
        )
    ).cancel


def cancel(
    assignation: IDCoercible, rath: Optional[RekuestNextRath] = None
) -> Assignation:
    """cancel

    Cancel an active assignation.

    Args:
        assignation: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID. (required)
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Assignation
    """
    return execute(
        CancelMutation, {"input": {"assignation": assignation}}, rath=rath
    ).cancel


async def ainterrupt(
    assignation: IDCoercible, rath: Optional[RekuestNextRath] = None
) -> Assignation:
    """interrupt

    Interrupt the execution of an assignation.

    Args:
        assignation: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID. (required)
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Assignation
    """
    return (
        await aexecute(
            InterruptMutation, {"input": {"assignation": assignation}}, rath=rath
        )
    ).interrupt


def interrupt(
    assignation: IDCoercible, rath: Optional[RekuestNextRath] = None
) -> Assignation:
    """interrupt

    Interrupt the execution of an assignation.

    Args:
        assignation: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID. (required)
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Assignation
    """
    return execute(
        InterruptMutation, {"input": {"assignation": assignation}}, rath=rath
    ).interrupt


async def acollect(
    drawers: Iterable[IDCoercible], rath: Optional[RekuestNextRath] = None
) -> Tuple[str, ...]:
    """collect

    Collect results from an assignation.

    Args:
        drawers: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID. (required) (list) (required)
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[str]
    """
    return (
        await aexecute(CollectMutation, {"input": {"drawers": drawers}}, rath=rath)
    ).collect


def collect(
    drawers: Iterable[IDCoercible], rath: Optional[RekuestNextRath] = None
) -> Tuple[str, ...]:
    """collect

    Collect results from an assignation.

    Args:
        drawers: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID. (required) (list) (required)
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[str]
    """
    return execute(CollectMutation, {"input": {"drawers": drawers}}, rath=rath).collect


async def acreate_dashboard(
    name: Optional[str] = None,
    panels: Optional[Iterable[IDCoercible]] = None,
    tree: Optional[UITreeInput] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Dashboard:
    """CreateDashboard

    Create a dashboard layout.

    Args:
        name: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text.
        panels: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID. (required) (list)
        tree:
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Dashboard
    """
    return (
        await aexecute(
            CreateDashboardMutation,
            {"input": {"name": name, "panels": panels, "tree": tree}},
            rath=rath,
        )
    ).create_dashboard


def create_dashboard(
    name: Optional[str] = None,
    panels: Optional[Iterable[IDCoercible]] = None,
    tree: Optional[UITreeInput] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Dashboard:
    """CreateDashboard

    Create a dashboard layout.

    Args:
        name: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text.
        panels: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID. (required) (list)
        tree:
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Dashboard
    """
    return execute(
        CreateDashboardMutation,
        {"input": {"name": name, "panels": panels, "tree": tree}},
        rath=rath,
    ).create_dashboard


async def areserve(
    instance_id: InstanceID,
    reference: Optional[str] = "cc3855ac-62bd-4ce7-a784-9ad5ac5ff179",
    action: Optional[IDCoercible] = None,
    implementation: Optional[IDCoercible] = None,
    title: Optional[str] = None,
    hash: Optional[ActionHash] = None,
    binds: Optional[BindsInput] = None,
    assignation_id: Optional[IDCoercible] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Reservation:
    """reserve

    Reserve an implementation for future use.

    Args:
        reference: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text.
        instance_id: The `InstanceID` scalar type represents a unique instance identifier (required)
        action: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID.
        implementation: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID.
        title: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text.
        hash: The `ArrayLike` scalar type represents a reference to a store previously created by the user n a datalayer
        binds:
        assignation_id: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Reservation
    """
    return (
        await aexecute(
            ReserveMutation,
            {
                "input": {
                    "reference": reference,
                    "instanceId": instance_id,
                    "action": action,
                    "implementation": implementation,
                    "title": title,
                    "hash": hash,
                    "binds": binds,
                    "assignationId": assignation_id,
                }
            },
            rath=rath,
        )
    ).reserve


def reserve(
    instance_id: InstanceID,
    reference: Optional[str] = "cc3855ac-62bd-4ce7-a784-9ad5ac5ff179",
    action: Optional[IDCoercible] = None,
    implementation: Optional[IDCoercible] = None,
    title: Optional[str] = None,
    hash: Optional[ActionHash] = None,
    binds: Optional[BindsInput] = None,
    assignation_id: Optional[IDCoercible] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Reservation:
    """reserve

    Reserve an implementation for future use.

    Args:
        reference: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text.
        instance_id: The `InstanceID` scalar type represents a unique instance identifier (required)
        action: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID.
        implementation: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID.
        title: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text.
        hash: The `ArrayLike` scalar type represents a reference to a store previously created by the user n a datalayer
        binds:
        assignation_id: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Reservation
    """
    return execute(
        ReserveMutation,
        {
            "input": {
                "reference": reference,
                "instanceId": instance_id,
                "action": action,
                "implementation": implementation,
                "title": title,
                "hash": hash,
                "binds": binds,
                "assignationId": assignation_id,
            }
        },
        rath=rath,
    ).reserve


async def aunreserve(
    reservation: IDCoercible, rath: Optional[RekuestNextRath] = None
) -> str:
    """unreserve

    Release a reserved implementation.

    Args:
        reservation: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID. (required)
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        str
    """
    return (
        await aexecute(
            UnreserveMutation, {"input": {"reservation": reservation}}, rath=rath
        )
    ).unreserve


def unreserve(reservation: IDCoercible, rath: Optional[RekuestNextRath] = None) -> str:
    """unreserve

    Release a reserved implementation.

    Args:
        reservation: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID. (required)
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        str
    """
    return execute(
        UnreserveMutation, {"input": {"reservation": reservation}}, rath=rath
    ).unreserve


async def ashelve(
    instance_id: InstanceID,
    identifier: Identifier,
    resource_id: str,
    label: Optional[str] = None,
    description: Optional[str] = None,
    rath: Optional[RekuestNextRath] = None,
) -> ShelveMutationShelveinmemorydrawer:
    """shelve

    Shelve data into a memory drawer.

    Args:
        instance_id: The instance ID of the agent. This is used to identify the agent in the system.
        identifier: The identifier of the drawer. This is used to identify the drawer in the system.
        resource_id: The resource ID of the drawer.
        label: The label of the drawer. This is used to identify the drawer in the system.
        description: The description of the drawer. This is used to identify the drawer in the system.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        ShelveMutationShelveinmemorydrawer
    """
    return (
        await aexecute(
            ShelveMutation,
            {
                "input": {
                    "instanceId": instance_id,
                    "identifier": identifier,
                    "resourceId": resource_id,
                    "label": label,
                    "description": description,
                }
            },
            rath=rath,
        )
    ).shelve_in_memory_drawer


def shelve(
    instance_id: InstanceID,
    identifier: Identifier,
    resource_id: str,
    label: Optional[str] = None,
    description: Optional[str] = None,
    rath: Optional[RekuestNextRath] = None,
) -> ShelveMutationShelveinmemorydrawer:
    """shelve

    Shelve data into a memory drawer.

    Args:
        instance_id: The instance ID of the agent. This is used to identify the agent in the system.
        identifier: The identifier of the drawer. This is used to identify the drawer in the system.
        resource_id: The resource ID of the drawer.
        label: The label of the drawer. This is used to identify the drawer in the system.
        description: The description of the drawer. This is used to identify the drawer in the system.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        ShelveMutationShelveinmemorydrawer
    """
    return execute(
        ShelveMutation,
        {
            "input": {
                "instanceId": instance_id,
                "identifier": identifier,
                "resourceId": resource_id,
                "label": label,
                "description": description,
            }
        },
        rath=rath,
    ).shelve_in_memory_drawer


async def aunshelve(
    instance_id: InstanceID, id: str, rath: Optional[RekuestNextRath] = None
) -> ID:
    """unshelve

    Unshelve data from a memory drawer.

    Args:
        instance_id: The instance ID of the agent. This is used to identify the agent in the system.
        id: The resource ID of the drawer.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        ID
    """
    return (
        await aexecute(
            UnshelveMutation,
            {"input": {"instanceId": instance_id, "id": id}},
            rath=rath,
        )
    ).unshelve_memory_drawer


def unshelve(
    instance_id: InstanceID, id: str, rath: Optional[RekuestNextRath] = None
) -> ID:
    """unshelve

    Unshelve data from a memory drawer.

    Args:
        instance_id: The instance ID of the agent. This is used to identify the agent in the system.
        id: The resource ID of the drawer.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        ID
    """
    return execute(
        UnshelveMutation, {"input": {"instanceId": instance_id, "id": id}}, rath=rath
    ).unshelve_memory_drawer


async def acreate_shortcut(
    name: str,
    action: IDCoercible,
    args: Args,
    allow_quick: bool,
    use_returns: bool,
    toolbox: Optional[IDCoercible] = None,
    description: Optional[str] = None,
    implementation: Optional[IDCoercible] = None,
    bind_number: Optional[int] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Shortcut:
    """CreateShortcut

    Create a shortcut to an action.

    Args:
        toolbox: The toolbox ID to create the shortcut in. If not provided, the shortcut will be created in the default toolbox.
        name: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text. (required)
        description: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text.
        action: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID. (required)
        implementation: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID.
        args: The `Args` scalar type represents a Dictionary of arguments (required)
        allow_quick: The `Boolean` scalar type represents `true` or `false`. (required)
        use_returns: The `Boolean` scalar type represents `true` or `false`. (required)
        bind_number: The `Int` scalar type represents non-fractional signed whole numeric values. Int can represent values between -(2^31) and 2^31 - 1.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Shortcut
    """
    return (
        await aexecute(
            CreateShortcutMutation,
            {
                "input": {
                    "toolbox": toolbox,
                    "name": name,
                    "description": description,
                    "action": action,
                    "implementation": implementation,
                    "args": args,
                    "allowQuick": allow_quick,
                    "useReturns": use_returns,
                    "bindNumber": bind_number,
                }
            },
            rath=rath,
        )
    ).create_shortcut


def create_shortcut(
    name: str,
    action: IDCoercible,
    args: Args,
    allow_quick: bool,
    use_returns: bool,
    toolbox: Optional[IDCoercible] = None,
    description: Optional[str] = None,
    implementation: Optional[IDCoercible] = None,
    bind_number: Optional[int] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Shortcut:
    """CreateShortcut

    Create a shortcut to an action.

    Args:
        toolbox: The toolbox ID to create the shortcut in. If not provided, the shortcut will be created in the default toolbox.
        name: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text. (required)
        description: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text.
        action: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID. (required)
        implementation: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID.
        args: The `Args` scalar type represents a Dictionary of arguments (required)
        allow_quick: The `Boolean` scalar type represents `true` or `false`. (required)
        use_returns: The `Boolean` scalar type represents `true` or `false`. (required)
        bind_number: The `Int` scalar type represents non-fractional signed whole numeric values. Int can represent values between -(2^31) and 2^31 - 1.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Shortcut
    """
    return execute(
        CreateShortcutMutation,
        {
            "input": {
                "toolbox": toolbox,
                "name": name,
                "description": description,
                "action": action,
                "implementation": implementation,
                "args": args,
                "allowQuick": allow_quick,
                "useReturns": use_returns,
                "bindNumber": bind_number,
            }
        },
        rath=rath,
    ).create_shortcut


async def aset_state(
    interface: str,
    instance_id: InstanceID,
    value: Args,
    rath: Optional[RekuestNextRath] = None,
) -> State:
    """SetState

    Set the value of a state object.

    Args:
        interface: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text. (required)
        instance_id: The `InstanceID` scalar type represents a unique instance identifier (required)
        value: The `Args` scalar type represents a Dictionary of arguments (required)
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        State
    """
    return (
        await aexecute(
            SetStateMutation,
            {
                "input": {
                    "interface": interface,
                    "instanceId": instance_id,
                    "value": value,
                }
            },
            rath=rath,
        )
    ).set_state


def set_state(
    interface: str,
    instance_id: InstanceID,
    value: Args,
    rath: Optional[RekuestNextRath] = None,
) -> State:
    """SetState

    Set the value of a state object.

    Args:
        interface: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text. (required)
        instance_id: The `InstanceID` scalar type represents a unique instance identifier (required)
        value: The `Args` scalar type represents a Dictionary of arguments (required)
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        State
    """
    return execute(
        SetStateMutation,
        {"input": {"interface": interface, "instanceId": instance_id, "value": value}},
        rath=rath,
    ).set_state


async def aupdate_state(
    interface: str,
    instance_id: InstanceID,
    patches: Iterable[Args],
    rath: Optional[RekuestNextRath] = None,
) -> State:
    """UpdateState

    Update fields in a state object.

    Args:
        interface: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text. (required)
        instance_id: The `InstanceID` scalar type represents a unique instance identifier (required)
        patches: The `Args` scalar type represents a Dictionary of arguments (required) (list) (required)
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        State
    """
    return (
        await aexecute(
            UpdateStateMutation,
            {
                "input": {
                    "interface": interface,
                    "instanceId": instance_id,
                    "patches": patches,
                }
            },
            rath=rath,
        )
    ).update_state


def update_state(
    interface: str,
    instance_id: InstanceID,
    patches: Iterable[Args],
    rath: Optional[RekuestNextRath] = None,
) -> State:
    """UpdateState

    Update fields in a state object.

    Args:
        interface: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text. (required)
        instance_id: The `InstanceID` scalar type represents a unique instance identifier (required)
        patches: The `Args` scalar type represents a Dictionary of arguments (required) (list) (required)
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        State
    """
    return execute(
        UpdateStateMutation,
        {
            "input": {
                "interface": interface,
                "instanceId": instance_id,
                "patches": patches,
            }
        },
        rath=rath,
    ).update_state


async def aset_agent_states(
    implementations: Iterable[StateImplementationInput],
    instance_id: InstanceID,
    rath: Optional[RekuestNextRath] = None,
) -> Tuple[State, ...]:
    """SetAgentStates

    Set states for an agent.

    Args:
        implementations: The input for initializing a state schema. (required) (list) (required)
        instance_id: The `InstanceID` scalar type represents a unique instance identifier (required)
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[State]
    """
    return (
        await aexecute(
            SetAgentStatesMutation,
            {"input": {"implementations": implementations, "instanceId": instance_id}},
            rath=rath,
        )
    ).set_agent_states


def set_agent_states(
    implementations: Iterable[StateImplementationInput],
    instance_id: InstanceID,
    rath: Optional[RekuestNextRath] = None,
) -> Tuple[State, ...]:
    """SetAgentStates

    Set states for an agent.

    Args:
        implementations: The input for initializing a state schema. (required) (list) (required)
        instance_id: The `InstanceID` scalar type represents a unique instance identifier (required)
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[State]
    """
    return execute(
        SetAgentStatesMutation,
        {"input": {"implementations": implementations, "instanceId": instance_id}},
        rath=rath,
    ).set_agent_states


async def acreate_state_schema(
    state_schema: StateSchemaInput, rath: Optional[RekuestNextRath] = None
) -> StateSchema:
    """CreateStateSchema

    Define a new state schema.

    Args:
        state_schema: The input for creating a state schema. (required)
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        StateSchema
    """
    return (
        await aexecute(
            CreateStateSchemaMutation,
            {"input": {"stateSchema": state_schema}},
            rath=rath,
        )
    ).create_state_schema


def create_state_schema(
    state_schema: StateSchemaInput, rath: Optional[RekuestNextRath] = None
) -> StateSchema:
    """CreateStateSchema

    Define a new state schema.

    Args:
        state_schema: The input for creating a state schema. (required)
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        StateSchema
    """
    return execute(
        CreateStateSchemaMutation, {"input": {"stateSchema": state_schema}}, rath=rath
    ).create_state_schema


async def acreate_implementation(
    implementation: ImplementationInput,
    instance_id: InstanceID,
    extension: str,
    rath: Optional[RekuestNextRath] = None,
) -> Implementation:
    """createImplementation

    Create a new implementation entry.

    Args:
        implementation: A implementation is a blueprint for a action. It is composed of a definition, a list of dependencies, and a list of params. (required)
        instance_id: The `InstanceID` scalar type represents a unique instance identifier (required)
        extension: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text. (required)
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Implementation
    """
    return (
        await aexecute(
            CreateImplementationMutation,
            {
                "input": {
                    "implementation": implementation,
                    "instanceId": instance_id,
                    "extension": extension,
                }
            },
            rath=rath,
        )
    ).create_implementation


def create_implementation(
    implementation: ImplementationInput,
    instance_id: InstanceID,
    extension: str,
    rath: Optional[RekuestNextRath] = None,
) -> Implementation:
    """createImplementation

    Create a new implementation entry.

    Args:
        implementation: A implementation is a blueprint for a action. It is composed of a definition, a list of dependencies, and a list of params. (required)
        instance_id: The `InstanceID` scalar type represents a unique instance identifier (required)
        extension: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text. (required)
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Implementation
    """
    return execute(
        CreateImplementationMutation,
        {
            "input": {
                "implementation": implementation,
                "instanceId": instance_id,
                "extension": extension,
            }
        },
        rath=rath,
    ).create_implementation


async def aset_extension_implementations(
    implementations: Iterable[ImplementationInput],
    instance_id: InstanceID,
    extension: str,
    run_cleanup: bool,
    rath: Optional[RekuestNextRath] = None,
) -> Tuple[Implementation, ...]:
    """SetExtensionImplementations

    Set implementations provided by an extension.

    Args:
        implementations: The implementations to set. This is used to identify the implementations in the system.
        instance_id: The `InstanceID` scalar type represents a unique instance identifier (required)
        extension: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text. (required)
        run_cleanup: The `Boolean` scalar type represents `true` or `false`. (required)
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[Implementation]
    """
    return (
        await aexecute(
            SetExtensionImplementationsMutation,
            {
                "input": {
                    "implementations": implementations,
                    "instanceId": instance_id,
                    "extension": extension,
                    "runCleanup": run_cleanup,
                }
            },
            rath=rath,
        )
    ).set_extension_implementations


def set_extension_implementations(
    implementations: Iterable[ImplementationInput],
    instance_id: InstanceID,
    extension: str,
    run_cleanup: bool,
    rath: Optional[RekuestNextRath] = None,
) -> Tuple[Implementation, ...]:
    """SetExtensionImplementations

    Set implementations provided by an extension.

    Args:
        implementations: The implementations to set. This is used to identify the implementations in the system.
        instance_id: The `InstanceID` scalar type represents a unique instance identifier (required)
        extension: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text. (required)
        run_cleanup: The `Boolean` scalar type represents `true` or `false`. (required)
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[Implementation]
    """
    return execute(
        SetExtensionImplementationsMutation,
        {
            "input": {
                "implementations": implementations,
                "instanceId": instance_id,
                "extension": extension,
                "runCleanup": run_cleanup,
            }
        },
        rath=rath,
    ).set_extension_implementations


async def acreate_testcase(
    action: IDCoercible,
    tester: IDCoercible,
    description: Optional[str] = None,
    name: Optional[str] = None,
    rath: Optional[RekuestNextRath] = None,
) -> TestCase:
    """create_testcase

    Create a new test case.

    Args:
        action: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID. (required)
        tester: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID. (required)
        description: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text.
        name: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        TestCase
    """
    return (
        await aexecute(
            Create_testcaseMutation,
            {
                "input": {
                    "action": action,
                    "tester": tester,
                    "description": description,
                    "name": name,
                }
            },
            rath=rath,
        )
    ).create_test_case


def create_testcase(
    action: IDCoercible,
    tester: IDCoercible,
    description: Optional[str] = None,
    name: Optional[str] = None,
    rath: Optional[RekuestNextRath] = None,
) -> TestCase:
    """create_testcase

    Create a new test case.

    Args:
        action: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID. (required)
        tester: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID. (required)
        description: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text.
        name: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        TestCase
    """
    return execute(
        Create_testcaseMutation,
        {
            "input": {
                "action": action,
                "tester": tester,
                "description": description,
                "name": name,
            }
        },
        rath=rath,
    ).create_test_case


async def acreate_testresult(
    case: IDCoercible,
    tester: IDCoercible,
    implementation: IDCoercible,
    passed: bool,
    result: Optional[str] = None,
    rath: Optional[RekuestNextRath] = None,
) -> TestResult:
    """create_testresult

    Create a test result record.

    Args:
        case: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID. (required)
        tester: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID. (required)
        implementation: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID. (required)
        passed: The `Boolean` scalar type represents `true` or `false`. (required)
        result: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        TestResult
    """
    return (
        await aexecute(
            Create_testresultMutation,
            {
                "input": {
                    "case": case,
                    "tester": tester,
                    "implementation": implementation,
                    "passed": passed,
                    "result": result,
                }
            },
            rath=rath,
        )
    ).create_test_result


def create_testresult(
    case: IDCoercible,
    tester: IDCoercible,
    implementation: IDCoercible,
    passed: bool,
    result: Optional[str] = None,
    rath: Optional[RekuestNextRath] = None,
) -> TestResult:
    """create_testresult

    Create a test result record.

    Args:
        case: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID. (required)
        tester: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID. (required)
        implementation: The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID. (required)
        passed: The `Boolean` scalar type represents `true` or `false`. (required)
        result: The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        TestResult
    """
    return execute(
        Create_testresultMutation,
        {
            "input": {
                "case": case,
                "tester": tester,
                "implementation": implementation,
                "passed": passed,
                "result": result,
            }
        },
        rath=rath,
    ).create_test_result


async def aget_agent(id: ID, rath: Optional[RekuestNextRath] = None) -> Agent:
    """GetAgent

    Retrieve an agent by ID.

    Args:
        id (ID): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Agent
    """
    return (await aexecute(GetAgentQuery, {"id": id}, rath=rath)).agent


def get_agent(id: ID, rath: Optional[RekuestNextRath] = None) -> Agent:
    """GetAgent

    Retrieve an agent by ID.

    Args:
        id (ID): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Agent
    """
    return execute(GetAgentQuery, {"id": id}, rath=rath).agent


async def alist_agents(
    filters: Optional[AgentFilter] = None,
    pagination: Optional[OffsetPaginationInput] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Tuple[Agent, ...]:
    """ListAgents

    Retrieve all compute agents.

    Args:
        filters (Optional[AgentFilter], optional): No description.
        pagination (Optional[OffsetPaginationInput], optional): No description.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[Agent]
    """
    return (
        await aexecute(
            ListAgentsQuery, {"filters": filters, "pagination": pagination}, rath=rath
        )
    ).agents


def list_agents(
    filters: Optional[AgentFilter] = None,
    pagination: Optional[OffsetPaginationInput] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Tuple[Agent, ...]:
    """ListAgents

    Retrieve all compute agents.

    Args:
        filters (Optional[AgentFilter], optional): No description.
        pagination (Optional[OffsetPaginationInput], optional): No description.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[Agent]
    """
    return execute(
        ListAgentsQuery, {"filters": filters, "pagination": pagination}, rath=rath
    ).agents


async def arequests(
    instance_id: InstanceID, rath: Optional[RekuestNextRath] = None
) -> Tuple[Assignation, ...]:
    """requests

    Fetch assignations.

    Args:
        instance_id (InstanceID): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[Assignation]
    """
    return (
        await aexecute(RequestsQuery, {"instance_id": instance_id}, rath=rath)
    ).assignations


def requests(
    instance_id: InstanceID, rath: Optional[RekuestNextRath] = None
) -> Tuple[Assignation, ...]:
    """requests

    Fetch assignations.

    Args:
        instance_id (InstanceID): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[Assignation]
    """
    return execute(RequestsQuery, {"instance_id": instance_id}, rath=rath).assignations


async def aget_event(
    id: Optional[ID] = None, rath: Optional[RekuestNextRath] = None
) -> Tuple[AssignationEvent, ...]:
    """GetEvent

    Fetch a specific event.

    Args:
        id (Optional[ID], optional): No description.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[AssignationEvent]
    """
    return (await aexecute(GetEventQuery, {"id": id}, rath=rath)).event


def get_event(
    id: Optional[ID] = None, rath: Optional[RekuestNextRath] = None
) -> Tuple[AssignationEvent, ...]:
    """GetEvent

    Fetch a specific event.

    Args:
        id (Optional[ID], optional): No description.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[AssignationEvent]
    """
    return execute(GetEventQuery, {"id": id}, rath=rath).event


async def aget_dashboard(id: ID, rath: Optional[RekuestNextRath] = None) -> Dashboard:
    """GetDashboard

    Get dashboard by ID.

    Args:
        id (ID): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Dashboard
    """
    return (await aexecute(GetDashboardQuery, {"id": id}, rath=rath)).dashboard


def get_dashboard(id: ID, rath: Optional[RekuestNextRath] = None) -> Dashboard:
    """GetDashboard

    Get dashboard by ID.

    Args:
        id (ID): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Dashboard
    """
    return execute(GetDashboardQuery, {"id": id}, rath=rath).dashboard


async def aget_me_actions(
    rath: Optional[RekuestNextRath] = None,
) -> Tuple[GetMeActionsQueryActions, ...]:
    """GetMeActions

    List of all available actions.

    Args:
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[GetMeActionsQueryActions]
    """
    return (await aexecute(GetMeActionsQuery, {}, rath=rath)).actions


def get_me_actions(
    rath: Optional[RekuestNextRath] = None,
) -> Tuple[GetMeActionsQueryActions, ...]:
    """GetMeActions

    List of all available actions.

    Args:
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[GetMeActionsQueryActions]
    """
    return execute(GetMeActionsQuery, {}, rath=rath).actions


async def afind(
    id: Optional[ID] = None,
    implementation: Optional[ID] = None,
    hash: Optional[ActionHash] = None,
    matching: Optional[ActionDependencyInput] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Action:
    """find

    Fetch a specific action.

    Args:
        id (Optional[ID], optional): No description.
        implementation (Optional[ID], optional): No description.
        hash (Optional[ActionHash], optional): No description.
        matching (Optional[ActionDependencyInput], optional): No description.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Action
    """
    return (
        await aexecute(
            FindQuery,
            {
                "id": id,
                "implementation": implementation,
                "hash": hash,
                "matching": matching,
            },
            rath=rath,
        )
    ).action


def find(
    id: Optional[ID] = None,
    implementation: Optional[ID] = None,
    hash: Optional[ActionHash] = None,
    matching: Optional[ActionDependencyInput] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Action:
    """find

    Fetch a specific action.

    Args:
        id (Optional[ID], optional): No description.
        implementation (Optional[ID], optional): No description.
        hash (Optional[ActionHash], optional): No description.
        matching (Optional[ActionDependencyInput], optional): No description.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Action
    """
    return execute(
        FindQuery,
        {
            "id": id,
            "implementation": implementation,
            "hash": hash,
            "matching": matching,
        },
        rath=rath,
    ).action


async def aretrieveall(rath: Optional[RekuestNextRath] = None) -> Tuple[Action, ...]:
    """retrieveall

    List of all available actions.

    Args:
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[Action]
    """
    return (await aexecute(RetrieveallQuery, {}, rath=rath)).actions


def retrieveall(rath: Optional[RekuestNextRath] = None) -> Tuple[Action, ...]:
    """retrieveall

    List of all available actions.

    Args:
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[Action]
    """
    return execute(RetrieveallQuery, {}, rath=rath).actions


async def asearch_actions(
    search: Optional[str] = None,
    values: Optional[List[ID]] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Tuple[SearchActionsQueryOptions, ...]:
    """SearchActions

    List of all available actions.

    Args:
        search (Optional[str], optional): No description.
        values (Optional[List[ID]], optional): No description.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[SearchActionsQueryActions]
    """
    return (
        await aexecute(
            SearchActionsQuery, {"search": search, "values": values}, rath=rath
        )
    ).options


def search_actions(
    search: Optional[str] = None,
    values: Optional[List[ID]] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Tuple[SearchActionsQueryOptions, ...]:
    """SearchActions

    List of all available actions.

    Args:
        search (Optional[str], optional): No description.
        values (Optional[List[ID]], optional): No description.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[SearchActionsQueryActions]
    """
    return execute(
        SearchActionsQuery, {"search": search, "values": values}, rath=rath
    ).options


async def alist_actions(
    filters: Optional[ActionFilter] = None,
    pagination: Optional[OffsetPaginationInput] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Tuple[ListAction, ...]:
    """ListActions

    List of all available actions.

    Args:
        filters (Optional[ActionFilter], optional): No description.
        pagination (Optional[OffsetPaginationInput], optional): No description.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[ListAction]
    """
    return (
        await aexecute(
            ListActionsQuery, {"filters": filters, "pagination": pagination}, rath=rath
        )
    ).actions


def list_actions(
    filters: Optional[ActionFilter] = None,
    pagination: Optional[OffsetPaginationInput] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Tuple[ListAction, ...]:
    """ListActions

    List of all available actions.

    Args:
        filters (Optional[ActionFilter], optional): No description.
        pagination (Optional[OffsetPaginationInput], optional): No description.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[ListAction]
    """
    return execute(
        ListActionsQuery, {"filters": filters, "pagination": pagination}, rath=rath
    ).actions


async def aprimary_actions(
    pagination: Optional[OffsetPaginationInput] = None,
    identifier: Optional[str] = None,
    order: Optional[ActionOrder] = None,
    search: Optional[str] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Tuple[PrimaryAction, ...]:
    """PrimaryActions

    List of all available actions.

    Args:
        pagination (Optional[OffsetPaginationInput], optional): No description.
        identifier (Optional[str], optional): No description.
        order (Optional[ActionOrder], optional): No description.
        search (Optional[str], optional): No description.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[PrimaryAction]
    """
    return (
        await aexecute(
            PrimaryActionsQuery,
            {
                "pagination": pagination,
                "identifier": identifier,
                "order": order,
                "search": search,
            },
            rath=rath,
        )
    ).actions


def primary_actions(
    pagination: Optional[OffsetPaginationInput] = None,
    identifier: Optional[str] = None,
    order: Optional[ActionOrder] = None,
    search: Optional[str] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Tuple[PrimaryAction, ...]:
    """PrimaryActions

    List of all available actions.

    Args:
        pagination (Optional[OffsetPaginationInput], optional): No description.
        identifier (Optional[str], optional): No description.
        order (Optional[ActionOrder], optional): No description.
        search (Optional[str], optional): No description.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[PrimaryAction]
    """
    return execute(
        PrimaryActionsQuery,
        {
            "pagination": pagination,
            "identifier": identifier,
            "order": order,
            "search": search,
        },
        rath=rath,
    ).actions


async def aget_reservation(
    id: ID, rath: Optional[RekuestNextRath] = None
) -> Reservation:
    """get_reservation

    Retrieve reservation by ID.

    Args:
        id (ID): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Reservation
    """
    return (await aexecute(Get_reservationQuery, {"id": id}, rath=rath)).reservation


def get_reservation(id: ID, rath: Optional[RekuestNextRath] = None) -> Reservation:
    """get_reservation

    Retrieve reservation by ID.

    Args:
        id (ID): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Reservation
    """
    return execute(Get_reservationQuery, {"id": id}, rath=rath).reservation


async def areservations(
    instance_id: InstanceID, rath: Optional[RekuestNextRath] = None
) -> Tuple[Reservation, ...]:
    """reservations

    List of all reservations.

    Args:
        instance_id (InstanceID): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[Reservation]
    """
    return (
        await aexecute(ReservationsQuery, {"instance_id": instance_id}, rath=rath)
    ).reservations


def reservations(
    instance_id: InstanceID, rath: Optional[RekuestNextRath] = None
) -> Tuple[Reservation, ...]:
    """reservations

    List of all reservations.

    Args:
        instance_id (InstanceID): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[Reservation]
    """
    return execute(
        ReservationsQuery, {"instance_id": instance_id}, rath=rath
    ).reservations


async def alist_shortcuts(
    pagination: Optional[OffsetPaginationInput] = None,
    filters: Optional[ShortcutFilter] = None,
    order: Optional[ShortcutOrder] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Tuple[ListShortcut, ...]:
    """ListShortcuts

    List of shortcuts.

    Args:
        pagination (Optional[OffsetPaginationInput], optional): No description.
        filters (Optional[ShortcutFilter], optional): No description.
        order (Optional[ShortcutOrder], optional): No description.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[ListShortcut]
    """
    return (
        await aexecute(
            ListShortcutsQuery,
            {"pagination": pagination, "filters": filters, "order": order},
            rath=rath,
        )
    ).shortcuts


def list_shortcuts(
    pagination: Optional[OffsetPaginationInput] = None,
    filters: Optional[ShortcutFilter] = None,
    order: Optional[ShortcutOrder] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Tuple[ListShortcut, ...]:
    """ListShortcuts

    List of shortcuts.

    Args:
        pagination (Optional[OffsetPaginationInput], optional): No description.
        filters (Optional[ShortcutFilter], optional): No description.
        order (Optional[ShortcutOrder], optional): No description.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[ListShortcut]
    """
    return execute(
        ListShortcutsQuery,
        {"pagination": pagination, "filters": filters, "order": order},
        rath=rath,
    ).shortcuts


async def aget_shortcut(id: ID, rath: Optional[RekuestNextRath] = None) -> Shortcut:
    """GetShortcut

    Retrieve shortcut by ID.

    Args:
        id (ID): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Shortcut
    """
    return (await aexecute(GetShortcutQuery, {"id": id}, rath=rath)).shortcut


def get_shortcut(id: ID, rath: Optional[RekuestNextRath] = None) -> Shortcut:
    """GetShortcut

    Retrieve shortcut by ID.

    Args:
        id (ID): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Shortcut
    """
    return execute(GetShortcutQuery, {"id": id}, rath=rath).shortcut


async def aget_implementation(
    id: ID, rath: Optional[RekuestNextRath] = None
) -> Implementation:
    """get_implementation

    Get implementation by ID.

    Args:
        id (ID): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Implementation
    """
    return (
        await aexecute(Get_implementationQuery, {"id": id}, rath=rath)
    ).implementation


def get_implementation(
    id: ID, rath: Optional[RekuestNextRath] = None
) -> Implementation:
    """get_implementation

    Get implementation by ID.

    Args:
        id (ID): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Implementation
    """
    return execute(Get_implementationQuery, {"id": id}, rath=rath).implementation


async def asearch_implementations(
    search: Optional[str] = None,
    values: Optional[List[ID]] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Tuple[Search_implementationsQueryOptions, ...]:
    """search_implementations

    All registered implementations.

    Args:
        search (Optional[str], optional): No description.
        values (Optional[List[ID]], optional): No description.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[Search_implementationsQueryImplementations]
    """
    return (
        await aexecute(
            Search_implementationsQuery, {"search": search, "values": values}, rath=rath
        )
    ).options


def search_implementations(
    search: Optional[str] = None,
    values: Optional[List[ID]] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Tuple[Search_implementationsQueryOptions, ...]:
    """search_implementations

    All registered implementations.

    Args:
        search (Optional[str], optional): No description.
        values (Optional[List[ID]], optional): No description.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[Search_implementationsQueryImplementations]
    """
    return execute(
        Search_implementationsQuery, {"search": search, "values": values}, rath=rath
    ).options


async def aimplementations_for(
    hash: ActionHash, rath: Optional[RekuestNextRath] = None
) -> Tuple[Implementation, ...]:
    """implementations_for

    All registered implementations.

    Args:
        hash (ActionHash): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[Implementation]
    """
    return (
        await aexecute(Implementations_forQuery, {"hash": hash}, rath=rath)
    ).implementations


def implementations_for(
    hash: ActionHash, rath: Optional[RekuestNextRath] = None
) -> Tuple[Implementation, ...]:
    """implementations_for

    All registered implementations.

    Args:
        hash (ActionHash): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[Implementation]
    """
    return execute(Implementations_forQuery, {"hash": hash}, rath=rath).implementations


async def amy_implementation_at(
    instance_id: str,
    interface: Optional[str] = None,
    action_id: Optional[ID] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Implementation:
    """MyImplementationAt

    Find your implementation at a specific interface.

    Args:
        instance_id (str): No description
        interface (Optional[str], optional): No description.
        action_id (Optional[ID], optional): No description.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Implementation
    """
    return (
        await aexecute(
            MyImplementationAtQuery,
            {"instanceId": instance_id, "interface": interface, "actionId": action_id},
            rath=rath,
        )
    ).my_implementation_at


def my_implementation_at(
    instance_id: str,
    interface: Optional[str] = None,
    action_id: Optional[ID] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Implementation:
    """MyImplementationAt

    Find your implementation at a specific interface.

    Args:
        instance_id (str): No description
        interface (Optional[str], optional): No description.
        action_id (Optional[ID], optional): No description.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Implementation
    """
    return execute(
        MyImplementationAtQuery,
        {"instanceId": instance_id, "interface": interface, "actionId": action_id},
        rath=rath,
    ).my_implementation_at


async def aget_testcase(id: ID, rath: Optional[RekuestNextRath] = None) -> TestCase:
    """get_testcase

    Retrieve test case by ID.

    Args:
        id (ID): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        TestCase
    """
    return (await aexecute(Get_testcaseQuery, {"id": id}, rath=rath)).test_case


def get_testcase(id: ID, rath: Optional[RekuestNextRath] = None) -> TestCase:
    """get_testcase

    Retrieve test case by ID.

    Args:
        id (ID): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        TestCase
    """
    return execute(Get_testcaseQuery, {"id": id}, rath=rath).test_case


async def aget_testresult(id: ID, rath: Optional[RekuestNextRath] = None) -> TestResult:
    """get_testresult

    Get test result by ID.

    Args:
        id (ID): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        TestResult
    """
    return (await aexecute(Get_testresultQuery, {"id": id}, rath=rath)).test_result


def get_testresult(id: ID, rath: Optional[RekuestNextRath] = None) -> TestResult:
    """get_testresult

    Get test result by ID.

    Args:
        id (ID): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        TestResult
    """
    return execute(Get_testresultQuery, {"id": id}, rath=rath).test_result


async def asearch_testcases(
    search: Optional[str] = None,
    values: Optional[List[ID]] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Tuple[Search_testcasesQueryOptions, ...]:
    """search_testcases

    All test cases.

    Args:
        search (Optional[str], optional): No description.
        values (Optional[List[ID]], optional): No description.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[Search_testcasesQueryTestcases]
    """
    return (
        await aexecute(
            Search_testcasesQuery, {"search": search, "values": values}, rath=rath
        )
    ).options


def search_testcases(
    search: Optional[str] = None,
    values: Optional[List[ID]] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Tuple[Search_testcasesQueryOptions, ...]:
    """search_testcases

    All test cases.

    Args:
        search (Optional[str], optional): No description.
        values (Optional[List[ID]], optional): No description.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[Search_testcasesQueryTestcases]
    """
    return execute(
        Search_testcasesQuery, {"search": search, "values": values}, rath=rath
    ).options


async def asearch_testresults(
    search: Optional[str] = None,
    values: Optional[List[ID]] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Tuple[Search_testresultsQueryOptions, ...]:
    """search_testresults

    Test results associated with test cases.

    Args:
        search (Optional[str], optional): No description.
        values (Optional[List[ID]], optional): No description.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[Search_testresultsQueryTestresults]
    """
    return (
        await aexecute(
            Search_testresultsQuery, {"search": search, "values": values}, rath=rath
        )
    ).options


def search_testresults(
    search: Optional[str] = None,
    values: Optional[List[ID]] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Tuple[Search_testresultsQueryOptions, ...]:
    """search_testresults

    Test results associated with test cases.

    Args:
        search (Optional[str], optional): No description.
        values (Optional[List[ID]], optional): No description.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[Search_testresultsQueryTestresults]
    """
    return execute(
        Search_testresultsQuery, {"search": search, "values": values}, rath=rath
    ).options


async def alist_toolboxes(
    pagination: Optional[OffsetPaginationInput] = None,
    filters: Optional[ToolboxFilter] = None,
    order: Optional[ToolboxOrder] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Tuple[ListToolbox, ...]:
    """ListToolboxes

    List of toolboxes containing shortcuts.

    Args:
        pagination (Optional[OffsetPaginationInput], optional): No description.
        filters (Optional[ToolboxFilter], optional): No description.
        order (Optional[ToolboxOrder], optional): No description.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[ListToolbox]
    """
    return (
        await aexecute(
            ListToolboxesQuery,
            {"pagination": pagination, "filters": filters, "order": order},
            rath=rath,
        )
    ).toolboxes


def list_toolboxes(
    pagination: Optional[OffsetPaginationInput] = None,
    filters: Optional[ToolboxFilter] = None,
    order: Optional[ToolboxOrder] = None,
    rath: Optional[RekuestNextRath] = None,
) -> Tuple[ListToolbox, ...]:
    """ListToolboxes

    List of toolboxes containing shortcuts.

    Args:
        pagination (Optional[OffsetPaginationInput], optional): No description.
        filters (Optional[ToolboxFilter], optional): No description.
        order (Optional[ToolboxOrder], optional): No description.
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        List[ListToolbox]
    """
    return execute(
        ListToolboxesQuery,
        {"pagination": pagination, "filters": filters, "order": order},
        rath=rath,
    ).toolboxes


async def aget_toolbox(id: ID, rath: Optional[RekuestNextRath] = None) -> Toolbox:
    """GetToolbox

    Get toolbox by ID.

    Args:
        id (ID): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Toolbox
    """
    return (await aexecute(GetToolboxQuery, {"id": id}, rath=rath)).toolbox


def get_toolbox(id: ID, rath: Optional[RekuestNextRath] = None) -> Toolbox:
    """GetToolbox

    Get toolbox by ID.

    Args:
        id (ID): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Toolbox
    """
    return execute(GetToolboxQuery, {"id": id}, rath=rath).toolbox


async def awatch_assignations(
    instance_id: InstanceID, rath: Optional[RekuestNextRath] = None
) -> AsyncIterator[AssignationChangeEvent]:
    """WatchAssignations

    Subscribe to updates on assignations.

    Args:
        instance_id (InstanceID): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        AssignationChangeEvent
    """
    async for event in asubscribe(
        WatchAssignationsSubscription, {"instanceId": instance_id}, rath=rath
    ):
        yield event.assignations


def watch_assignations(
    instance_id: InstanceID, rath: Optional[RekuestNextRath] = None
) -> Iterator[AssignationChangeEvent]:
    """WatchAssignations

    Subscribe to updates on assignations.

    Args:
        instance_id (InstanceID): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        AssignationChangeEvent
    """
    for event in subscribe(
        WatchAssignationsSubscription, {"instanceId": instance_id}, rath=rath
    ):
        yield event.assignations


async def awatch_reservations(
    instance_id: InstanceID, rath: Optional[RekuestNextRath] = None
) -> AsyncIterator[Reservation]:
    """WatchReservations

    Subscribe to updates on reservations.

    Args:
        instance_id (InstanceID): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Reservation
    """
    async for event in asubscribe(
        WatchReservationsSubscription, {"instanceId": instance_id}, rath=rath
    ):
        yield event.reservations


def watch_reservations(
    instance_id: InstanceID, rath: Optional[RekuestNextRath] = None
) -> Iterator[Reservation]:
    """WatchReservations

    Subscribe to updates on reservations.

    Args:
        instance_id (InstanceID): No description
        rath (rekuest_next.rath.RekuestNextRath, optional): The arkitekt rath client

    Returns:
        Reservation
    """
    for event in subscribe(
        WatchReservationsSubscription, {"instanceId": instance_id}, rath=rath
    ):
        yield event.reservations


ActionDemandInput.model_rebuild()
ActionFilter.model_rebuild()
AgentFilter.model_rebuild()
AssignInput.model_rebuild()
AssignWidgetInput.model_rebuild()
CreateDashboardInput.model_rebuild()
CreateImplementationInput.model_rebuild()
CreateStateSchemaInput.model_rebuild()
DefinitionInput.model_rebuild()
ImplementationInput.model_rebuild()
PortGroupInput.model_rebuild()
PortInput.model_rebuild()
PortMatchInput.model_rebuild()
ReserveInput.model_rebuild()
SetAgentStatesInput.model_rebuild()
ShortcutFilter.model_rebuild()
ToolboxFilter.model_rebuild()
UIChildInput.model_rebuild()
UITreeInput.model_rebuild()
