class Metadata: ...


class PrimaryKey(Metadata):
    """Marks a column as a primary key"""

    ...


class AutoGenerated(Metadata):
    """Marks a column as auto-generated"""

    ...


class AutoIncrement(Metadata):
    """Marks a column as auto-increment"""

    ...


class Unique(Metadata):
    """Marks a column as unique"""

    ...


class CheckTypes(Metadata):
    """Controls type checking for this column"""

    def __init__(self, enabled: bool = True):
        self.enabled: bool = enabled


class Default[T](Metadata):
    """Sets a default value for a column"""

    def __init__(self, value: T):
        self.value: T = value


class NotNull(Metadata):
    """Marks a column as not-null"""

    ...
