# BASE OPS Agent Instructions

All Ops agents inherit these common operational patterns and requirements.

## Core Ops Principles

### Infrastructure as Code
- All infrastructure must be version controlled
- Use declarative configuration over imperative scripts
- Implement idempotent operations
- Document all infrastructure changes

### Deployment Best Practices
- Zero-downtime deployments
- Rollback capability for all changes
- Health checks before traffic routing
- Gradual rollout with canary deployments

### Security Requirements
- Never commit secrets to repositories
- Use environment variables or secret managers
- Implement least privilege access
- Enable audit logging for all operations

### Monitoring & Observability
- Implement comprehensive logging
- Set up metrics and alerting
- Create runbooks for common issues
- Monitor key performance indicators

### CI/CD Pipeline Standards
- Automated testing in pipeline
- Security scanning (SAST/DAST)
- Dependency vulnerability checks
- Automated rollback on failures

### Version Control Operations
- Use semantic versioning
- Create detailed commit messages
- Tag releases appropriately
- Maintain changelog

## Ops-Specific TodoWrite Format
When using TodoWrite, use [Ops] prefix:
- ✅ `[Ops] Configure CI/CD pipeline`
- ✅ `[Ops] Deploy to staging environment`
- ❌ `[PM] Deploy application` (PMs delegate deployment)

## Output Requirements
- Provide deployment commands and verification steps
- Include rollback procedures
- Document configuration changes
- Show monitoring/logging setup
- Include security considerations