"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ADOT_LAMBDA_LAYER_ARNS = exports.PARAMS_AND_SECRETS_LAMBDA_LAYER_ARNS = exports.FIREHOSE_CIDR_BLOCKS = exports.CLOUDWATCH_LAMBDA_INSIGHTS_ARNS = exports.APPCONFIG_LAMBDA_LAYER_ARNS = exports.APPMESH_ECR_ACCOUNTS = exports.DLC_REPOSITORY_ACCOUNTS = exports.ELBV2_ACCOUNTS = exports.PARTITION_MAP = exports.EBS_ENV_ENDPOINT_HOSTED_ZONE_IDS = exports.ROUTE_53_BUCKET_WEBSITE_ZONE_IDS = exports.AWS_CDK_METADATA = void 0;
/* eslint-disable @aws-cdk/no-literal-partition */
exports.AWS_CDK_METADATA = new Set([
    'af-south-1',
    'ap-east-1',
    'ap-northeast-1',
    'ap-northeast-2',
    // 'ap-northeast-3',
    'ap-south-1',
    // 'ap-south-2',
    'ap-southeast-1',
    'ap-southeast-2',
    // 'ap-southeast-3',
    // 'ap-southeast-4',
    'ca-central-1',
    'cn-north-1',
    'cn-northwest-1',
    'eu-central-1',
    // 'eu-central-2',
    'eu-north-1',
    'eu-south-1',
    // 'eu-south-2',
    'eu-west-1',
    'eu-west-2',
    'eu-west-3',
    // 'il-central-1',
    // 'me-central-1',
    'me-south-1',
    'sa-east-1',
    'us-east-1',
    'us-east-2',
    // 'us-gov-east-1',
    // 'us-gov-west-1',
    // 'us-iso-east-1',
    // 'us-isob-east-1',
    'us-west-1',
    'us-west-2',
]);
/**
 * The hosted zone Id if using an alias record in Route53.
 *
 * @see https://docs.aws.amazon.com/general/latest/gr/s3.html#s3_region
 */
exports.ROUTE_53_BUCKET_WEBSITE_ZONE_IDS = {
    'af-south-1': 'Z11KHD8FBVPUYU',
    'ap-east-1': 'ZNB98KWMFR0R6',
    'ap-northeast-1': 'Z2M4EHUR26P7ZW',
    'ap-northeast-2': 'Z3W03O7B5YMIYP',
    'ap-northeast-3': 'Z2YQB5RD63NC85',
    'ap-south-1': 'Z11RGJOFQNVJUP',
    'ap-south-2': 'Z02976202B4EZMXIPMXF7',
    'ap-southeast-1': 'Z3O0J2DXBE1FTB',
    'ap-southeast-2': 'Z1WCIGYICN2BYD',
    'ap-southeast-3': 'Z01846753K324LI26A3VV',
    'ap-southeast-4': 'Z0312387243XT5FE14WFO',
    'ca-central-1': 'Z1QDHH18159H29',
    'cn-north-1': 'Z5CN8UMXT92WN',
    'cn-northwest-1': 'Z282HJ1KT0DH03',
    'eu-central-1': 'Z21DNDUVLTQW6Q',
    'eu-central-2': 'Z030506016YDQGETNASS',
    'eu-north-1': 'Z3BAZG2TWCNX0D',
    'eu-south-1': 'Z3IXVV8C73GIO3',
    'eu-south-2': 'Z0081959F7139GRJC19J',
    'eu-west-1': 'Z1BKCTXD74EZPE',
    'eu-west-2': 'Z3GKZC51ZF0DB4',
    'eu-west-3': 'Z3R1K369G5AVDG',
    'il-central-1': 'Z09640613K4A3MN55U7GU',
    'me-central-1': 'Z06143092I8HRXZRUZROF',
    'me-south-1': 'Z1MPMWCPA7YB62',
    'sa-east-1': 'Z7KQH4QJS55SO',
    'us-east-1': 'Z3AQBSTGFYJSTF',
    'us-east-2': 'Z2O1EMRO9K5GLX',
    'us-gov-east-1': 'Z2NIFVYYW2VKV1',
    'us-gov-west-1': 'Z31GFT0UA1I2HV',
    'us-west-1': 'Z2F56UZL2M1ACD',
    'us-west-2': 'Z3BJ6K6RIION7M',
};
/**
 * The hosted zone Id of the Elastic Beanstalk environment.
 *
 * @see https://docs.aws.amazon.com/general/latest/gr/elasticbeanstalk.html
 */
exports.EBS_ENV_ENDPOINT_HOSTED_ZONE_IDS = {
    'af-south-1': 'Z1EI3BVKMKK4AM',
    'ap-east-1': 'ZPWYUBWRU171A',
    'ap-northeast-1': 'Z1R25G3KIG2GBW',
    'ap-northeast-2': 'Z3JE5OI70TWKCP',
    'ap-northeast-3': 'ZNE5GEY1TIAGY',
    'ap-south-1': 'Z18NTBI3Y7N9TZ',
    'ap-southeast-1': 'Z16FZ9L249IFLT',
    'ap-southeast-2': 'Z2PCDNR3VC2G1N',
    'ap-southeast-3': 'Z05913172VM7EAZB40TA8',
    'ca-central-1': 'ZJFCZL7SSZB5I',
    'eu-central-1': 'Z1FRNW7UH4DEZJ',
    'eu-north-1': 'Z23GO28BZ5AETM',
    'eu-south-1': 'Z10VDYYOA2JFKM',
    'eu-west-1': 'Z2NYPWQ7DFZAZH',
    'eu-west-2': 'Z1GKAAAUGATPF1',
    'eu-west-3': 'Z5WN6GAYWG5OB',
    'il-central-1': 'Z02941091PERNCB1MI5H7',
    'me-south-1': 'Z2BBTEKR2I36N2',
    'sa-east-1': 'Z10X7K2B4QSOFV',
    'us-east-1': 'Z117KPS5GTRQ2G',
    'us-east-2': 'Z14LCN19Q5QHIC',
    'us-gov-east-1': 'Z35TSARG0EJ4VU',
    'us-gov-west-1': 'Z4KAURWC4UUUG',
    'us-west-1': 'Z1LQECGX5PH1X',
    'us-west-2': 'Z38NKT9BP95V3O',
};
var Partition;
(function (Partition) {
    Partition["Default"] = "aws";
    Partition["Cn"] = "aws-cn";
    Partition["UsGov"] = "aws-us-gov";
    Partition["UsIso"] = "aws-iso";
    Partition["UsIsoB"] = "aws-iso-b";
})(Partition || (Partition = {}));
exports.PARTITION_MAP = {
    'default': { partition: Partition.Default, domainSuffix: 'amazonaws.com' },
    'cn-': { partition: Partition.Cn, domainSuffix: 'amazonaws.com.cn' },
    'us-gov-': { partition: Partition.UsGov, domainSuffix: 'amazonaws.com' },
    'us-iso-': { partition: Partition.UsIso, domainSuffix: 'c2s.ic.gov' },
    'us-isob-': { partition: Partition.UsIsoB, domainSuffix: 'sc2s.sgov.gov' },
};
// https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-access-logs.html#access-logging-bucket-permissions
// https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-access-logs.html#attach-bucket-policy
// Any not listed regions use the service principal "logdelivery.elasticloadbalancing.amazonaws.com"
exports.ELBV2_ACCOUNTS = {
    'af-south-1': '098369216593',
    'ap-east-1': '754344448648',
    'ap-northeast-1': '582318560864',
    'ap-northeast-2': '600734575887',
    'ap-northeast-3': '383597477331',
    'ap-south-1': '718504428378',
    'ap-southeast-1': '114774131450',
    'ap-southeast-2': '783225319266',
    'ap-southeast-3': '589379963580',
    'ca-central-1': '985666609251',
    'cn-north-1': '638102146993',
    'cn-northwest-1': '037604701340',
    'eu-central-1': '054676820928',
    'eu-north-1': '897822967062',
    'eu-south-1': '635631232127',
    'eu-west-1': '156460612806',
    'eu-west-2': '652711504416',
    'eu-west-3': '009996457667',
    'me-south-1': '076674570225',
    'sa-east-1': '507241528517',
    'us-east-1': '127311923021',
    'us-east-2': '033677994240',
    'us-gov-east-1': '190560391635',
    'us-gov-west-1': '048591011584',
    'us-iso-east-1': '770363063475',
    'us-isob-east-1': '740734521339',
    'us-iso-west-1': '121062877647',
    'us-west-1': '027434742980',
    'us-west-2': '797873946194',
};
// https://aws.amazon.com/releasenotes/available-deep-learning-containers-images
exports.DLC_REPOSITORY_ACCOUNTS = {
    'ap-east-1': '871362719292',
    'ap-northeast-1': '763104351884',
    'ap-northeast-2': '763104351884',
    'ap-south-1': '763104351884',
    'ap-southeast-1': '763104351884',
    'ap-southeast-2': '763104351884',
    'ca-central-1': '763104351884',
    'cn-north-1': '727897471807',
    'cn-northwest-1': '727897471807',
    'eu-central-1': '763104351884',
    'eu-north-1': '763104351884',
    'eu-west-1': '763104351884',
    'eu-west-2': '763104351884',
    'eu-west-3': '763104351884',
    'me-south-1': '217643126080',
    'sa-east-1': '763104351884',
    'us-east-1': '763104351884',
    'us-east-2': '763104351884',
    'us-west-1': '763104351884',
    'us-west-2': '763104351884',
};
// https://docs.aws.amazon.com/app-mesh/latest/userguide/envoy.html
// https://docs.amazonaws.cn/app-mesh/latest/userguide/envoy.html
exports.APPMESH_ECR_ACCOUNTS = {
    'af-south-1': '924023996002',
    'ap-east-1': '856666278305',
    'ap-northeast-1': '840364872350',
    'ap-northeast-2': '840364872350',
    'ap-northeast-3': '840364872350',
    'ap-south-1': '840364872350',
    'ap-southeast-1': '840364872350',
    'ap-southeast-2': '840364872350',
    'ap-southeast-3': '909464085924',
    'ca-central-1': '840364872350',
    'cn-north-1': '919366029133',
    'cn-northwest-1': '919830735681',
    'eu-central-1': '840364872350',
    'eu-north-1': '840364872350',
    'eu-south-1': '422531588944',
    'eu-west-1': '840364872350',
    'eu-west-2': '840364872350',
    'eu-west-3': '840364872350',
    'me-south-1': '772975370895',
    'sa-east-1': '840364872350',
    'us-east-1': '840364872350',
    'us-east-2': '840364872350',
    'us-west-1': '840364872350',
    'us-west-2': '840364872350',
};
// https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-integration-lambda-extensions-versions.html
exports.APPCONFIG_LAMBDA_LAYER_ARNS = {
    '2.0.181': {
        arm64: {
            'af-south-1': 'arn:aws:lambda:af-south-1:574348263942:layer:AWS-AppConfig-Extension-Arm64:1',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:630222743974:layer:AWS-AppConfig-Extension-Arm64:1',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:980059726660:layer:AWS-AppConfig-Extension-Arm64:37',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:826293736237:layer:AWS-AppConfig-Extension-Arm64:1',
            'ap-northeast-3': 'arn:aws:lambda:ap-northeast-3:706869817123:layer:AWS-AppConfig-Extension-Arm64:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:554480029851:layer:AWS-AppConfig-Extension-Arm64:36',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:421114256042:layer:AWS-AppConfig-Extension-Arm64:43',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:080788657173:layer:AWS-AppConfig-Extension-Arm64:36',
            'ap-southeast-3': 'arn:aws:lambda:ap-southeast-3:418787028745:layer:AWS-AppConfig-Extension-Arm64:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:039592058896:layer:AWS-AppConfig-Extension-Arm64:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:066940009817:layer:AWS-AppConfig-Extension-Arm64:36',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:646970417810:layer:AWS-AppConfig-Extension-Arm64:1',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:203683718741:layer:AWS-AppConfig-Extension-Arm64:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:434848589818:layer:AWS-AppConfig-Extension-Arm64:48',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:282860088358:layer:AWS-AppConfig-Extension-Arm64:33',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:493207061005:layer:AWS-AppConfig-Extension-Arm64:1',
            'me-south-1': 'arn:aws:lambda:me-south-1:559955524753:layer:AWS-AppConfig-Extension-Arm64:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:000010852771:layer:AWS-AppConfig-Extension-Arm64:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:027255383542:layer:AWS-AppConfig-Extension-Arm64:46',
            'us-east-2': 'arn:aws:lambda:us-east-2:728743619870:layer:AWS-AppConfig-Extension-Arm64:33',
            'us-west-1': 'arn:aws:lambda:us-west-1:958113053741:layer:AWS-AppConfig-Extension-Arm64:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:359756378197:layer:AWS-AppConfig-Extension-Arm64:48',
        },
        x86_64: {
            'af-south-1': 'arn:aws:lambda:af-south-1:574348263942:layer:AWS-AppConfig-Extension:73',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:630222743974:layer:AWS-AppConfig-Extension:73',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:980059726660:layer:AWS-AppConfig-Extension:84',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:826293736237:layer:AWS-AppConfig-Extension:93',
            'ap-northeast-3': 'arn:aws:lambda:ap-northeast-3:706869817123:layer:AWS-AppConfig-Extension:86',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:554480029851:layer:AWS-AppConfig-Extension:94',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:489524808438:layer:AWS-AppConfig-Extension:32',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:421114256042:layer:AWS-AppConfig-Extension:91',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:080788657173:layer:AWS-AppConfig-Extension:93',
            'ap-southeast-3': 'arn:aws:lambda:ap-southeast-3:418787028745:layer:AWS-AppConfig-Extension:64',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:039592058896:layer:AWS-AppConfig-Extension:81',
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:615057806174:layer:AWS-AppConfig-Extension:68',
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:615084187847:layer:AWS-AppConfig-Extension:68',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:066940009817:layer:AWS-AppConfig-Extension:93',
            'eu-central-2': 'arn:aws:lambda:eu-central-2:758369105281:layer:AWS-AppConfig-Extension:32',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:646970417810:layer:AWS-AppConfig-Extension:142',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:203683718741:layer:AWS-AppConfig-Extension:73',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:586093569114:layer:AWS-AppConfig-Extension:29',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:434848589818:layer:AWS-AppConfig-Extension:110',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:282860088358:layer:AWS-AppConfig-Extension:81',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:493207061005:layer:AWS-AppConfig-Extension:82',
            'me-central-1': 'arn:aws:lambda:me-central-1:662846165436:layer:AWS-AppConfig-Extension:34',
            'me-south-1': 'arn:aws:lambda:me-south-1:559955524753:layer:AWS-AppConfig-Extension:73',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:000010852771:layer:AWS-AppConfig-Extension:113',
            'us-east-1': 'arn:aws:lambda:us-east-1:027255383542:layer:AWS-AppConfig-Extension:113',
            'us-east-2': 'arn:aws:lambda:us-east-2:728743619870:layer:AWS-AppConfig-Extension:81',
            'us-gov-east-1': 'arn:aws-us-gov:lambda:us-gov-east-1:946561847325:layer:AWS-AppConfig-Extension:46',
            'us-gov-west-1': 'arn:aws-us-gov:lambda:us-gov-west-1:946746059096:layer:AWS-AppConfig-Extension:46',
            'us-west-1': 'arn:aws:lambda:us-west-1:958113053741:layer:AWS-AppConfig-Extension:124',
            'us-west-2': 'arn:aws:lambda:us-west-2:359756378197:layer:AWS-AppConfig-Extension:146',
        },
    },
    '2.0.165': {
        arm64: {
            'us-east-1': 'arn:aws:lambda:us-east-1:027255383542:layer:AWS-AppConfig-Extension-Arm64:43',
            'us-east-2': 'arn:aws:lambda:us-east-2:728743619870:layer:AWS-AppConfig-Extension-Arm64:31',
            'us-west-2': 'arn:aws:lambda:us-west-2:359756378197:layer:AWS-AppConfig-Extension-Arm64:45',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:066940009817:layer:AWS-AppConfig-Extension-Arm64:34',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:434848589818:layer:AWS-AppConfig-Extension-Arm64:46',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:282860088358:layer:AWS-AppConfig-Extension-Arm64:31',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:980059726660:layer:AWS-AppConfig-Extension-Arm64:35',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:421114256042:layer:AWS-AppConfig-Extension-Arm64:41',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:080788657173:layer:AWS-AppConfig-Extension-Arm64:34',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:554480029851:layer:AWS-AppConfig-Extension-Arm64:34',
        },
        x86_64: {
            'us-east-1': 'arn:aws:lambda:us-east-1:027255383542:layer:AWS-AppConfig-Extension:110',
            'us-east-2': 'arn:aws:lambda:us-east-2:728743619870:layer:AWS-AppConfig-Extension:79',
            'us-west-1': 'arn:aws:lambda:us-west-1:958113053741:layer:AWS-AppConfig-Extension:121',
            'us-west-2': 'arn:aws:lambda:us-west-2:359756378197:layer:AWS-AppConfig-Extension:143',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:039592058896:layer:AWS-AppConfig-Extension:79',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:066940009817:layer:AWS-AppConfig-Extension:91',
            'eu-central-2': 'arn:aws:lambda:eu-central-2:758369105281:layer:AWS-AppConfig-Extension:29',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:434848589818:layer:AWS-AppConfig-Extension:108',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:282860088358:layer:AWS-AppConfig-Extension:79',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:493207061005:layer:AWS-AppConfig-Extension:80',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:646970417810:layer:AWS-AppConfig-Extension:139',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:203683718741:layer:AWS-AppConfig-Extension:71',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:586093569114:layer:AWS-AppConfig-Extension:26',
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:615057806174:layer:AWS-AppConfig-Extension:66',
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:615084187847:layer:AWS-AppConfig-Extension:66',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:630222743974:layer:AWS-AppConfig-Extension:71',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:980059726660:layer:AWS-AppConfig-Extension:82',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:826293736237:layer:AWS-AppConfig-Extension:91',
            'ap-northeast-3': 'arn:aws:lambda:ap-northeast-3:706869817123:layer:AWS-AppConfig-Extension:84',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:421114256042:layer:AWS-AppConfig-Extension:89',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:080788657173:layer:AWS-AppConfig-Extension:91',
            'ap-southeast-3': 'arn:aws:lambda:ap-southeast-3:418787028745:layer:AWS-AppConfig-Extension:60',
            'ap-southeast-4': 'arn:aws:lambda:ap-southeast-4:307021474294:layer:AWS-AppConfig-Extension:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:554480029851:layer:AWS-AppConfig-Extension:92',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:489524808438:layer:AWS-AppConfig-Extension:29',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:000010852771:layer:AWS-AppConfig-Extension:110',
            'af-south-1': 'arn:aws:lambda:af-south-1:574348263942:layer:AWS-AppConfig-Extension:71',
            'me-central-1': 'arn:aws:lambda:me-central-1:662846165436:layer:AWS-AppConfig-Extension:31',
            'me-south-1': 'arn:aws:lambda:me-south-1:559955524753:layer:AWS-AppConfig-Extension:71',
            'us-gov-east-1': 'arn:aws-us-gov:lambda:us-gov-east-1:946561847325:layer:AWS-AppConfig-Extension:44',
            'us-gov-west-1': 'arn:aws-us-gov:lambda:us-gov-west-1:946746059096:layer:AWS-AppConfig-Extension:44',
        },
    },
    '2.0.122': {
        arm64: {
            'us-east-1': 'arn:aws:lambda:us-east-1:027255383542:layer:AWS-AppConfig-Extension-Arm64:15',
            'us-east-2': 'arn:aws:lambda:us-east-2:728743619870:layer:AWS-AppConfig-Extension-Arm64:11',
            'us-west-2': 'arn:aws:lambda:us-west-2:359756378197:layer:AWS-AppConfig-Extension-Arm64:16',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:066940009817:layer:AWS-AppConfig-Extension-Arm64:13',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:434848589818:layer:AWS-AppConfig-Extension-Arm64:20',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:282860088358:layer:AWS-AppConfig-Extension-Arm64:11',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:980059726660:layer:AWS-AppConfig-Extension-Arm64:15',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:421114256042:layer:AWS-AppConfig-Extension-Arm64:16',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:080788657173:layer:AWS-AppConfig-Extension-Arm64:13',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:554480029851:layer:AWS-AppConfig-Extension-Arm64:13',
        },
        x86_64: {
            'us-east-1': 'arn:aws:lambda:us-east-1:027255383542:layer:AWS-AppConfig-Extension:82',
            'us-east-2': 'arn:aws:lambda:us-east-2:728743619870:layer:AWS-AppConfig-Extension:59',
            'us-west-1': 'arn:aws:lambda:us-west-1:958113053741:layer:AWS-AppConfig-Extension:93',
            'us-west-2': 'arn:aws:lambda:us-west-2:359756378197:layer:AWS-AppConfig-Extension:114',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:039592058896:layer:AWS-AppConfig-Extension:59',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:066940009817:layer:AWS-AppConfig-Extension:70',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:434848589818:layer:AWS-AppConfig-Extension:82',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:282860088358:layer:AWS-AppConfig-Extension:59',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:493207061005:layer:AWS-AppConfig-Extension:60',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:646970417810:layer:AWS-AppConfig-Extension:111',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:203683718741:layer:AWS-AppConfig-Extension:54',
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:615057806174:layer:AWS-AppConfig-Extension:52',
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:615084187847:layer:AWS-AppConfig-Extension:52',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:630222743974:layer:AWS-AppConfig-Extension:54',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:980059726660:layer:AWS-AppConfig-Extension:62',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:826293736237:layer:AWS-AppConfig-Extension:70',
            'ap-northeast-3': 'arn:aws:lambda:ap-northeast-3:706869817123:layer:AWS-AppConfig-Extension:59',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:421114256042:layer:AWS-AppConfig-Extension:64',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:080788657173:layer:AWS-AppConfig-Extension:70',
            'ap-southeast-3': 'arn:aws:lambda:ap-southeast-3:418787028745:layer:AWS-AppConfig-Extension:37',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:554480029851:layer:AWS-AppConfig-Extension:71',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:000010852771:layer:AWS-AppConfig-Extension:82',
            'af-south-1': 'arn:aws:lambda:af-south-1:574348263942:layer:AWS-AppConfig-Extension:54',
            'me-south-1': 'arn:aws:lambda:me-south-1:559955524753:layer:AWS-AppConfig-Extension:54',
            'us-gov-east-1': 'arn:aws-us-gov:lambda:us-gov-east-1:946561847325:layer:AWS-AppConfig-Extension:29',
            'us-gov-west-1': 'arn:aws-us-gov:lambda:us-gov-west-1:946746059096:layer:AWS-AppConfig-Extension:29',
        },
    },
    '2.0.58': {
        arm64: {
            'us-east-1': 'arn:aws:lambda:us-east-1:027255383542:layer:AWS-AppConfig-Extension-Arm64:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:728743619870:layer:AWS-AppConfig-Extension-Arm64:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:359756378197:layer:AWS-AppConfig-Extension-Arm64:3',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:066940009817:layer:AWS-AppConfig-Extension-Arm64:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:434848589818:layer:AWS-AppConfig-Extension-Arm64:7',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:282860088358:layer:AWS-AppConfig-Extension-Arm64:2',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:980059726660:layer:AWS-AppConfig-Extension-Arm64:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:421114256042:layer:AWS-AppConfig-Extension-Arm64:3',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:080788657173:layer:AWS-AppConfig-Extension-Arm64:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:554480029851:layer:AWS-AppConfig-Extension-Arm64:2',
        },
        x86_64: {
            'us-east-1': 'arn:aws:lambda:us-east-1:027255383542:layer:AWS-AppConfig-Extension:69',
            'us-east-2': 'arn:aws:lambda:us-east-2:728743619870:layer:AWS-AppConfig-Extension:50',
            'us-west-1': 'arn:aws:lambda:us-west-1:958113053741:layer:AWS-AppConfig-Extension:78',
            'us-west-2': 'arn:aws:lambda:us-west-2:359756378197:layer:AWS-AppConfig-Extension:101',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:039592058896:layer:AWS-AppConfig-Extension:50',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:066940009817:layer:AWS-AppConfig-Extension:59',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:434848589818:layer:AWS-AppConfig-Extension:69',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:282860088358:layer:AWS-AppConfig-Extension:50',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:493207061005:layer:AWS-AppConfig-Extension:51',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:646970417810:layer:AWS-AppConfig-Extension:98',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:203683718741:layer:AWS-AppConfig-Extension:47',
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:615057806174:layer:AWS-AppConfig-Extension:46',
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:615084187847:layer:AWS-AppConfig-Extension:46',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:630222743974:layer:AWS-AppConfig-Extension:47',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:980059726660:layer:AWS-AppConfig-Extension:49',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:826293736237:layer:AWS-AppConfig-Extension:59',
            'ap-northeast-3': 'arn:aws:lambda:ap-northeast-3:706869817123:layer:AWS-AppConfig-Extension:46',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:421114256042:layer:AWS-AppConfig-Extension:51',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:080788657173:layer:AWS-AppConfig-Extension:59',
            'ap-southeast-3': 'arn:aws:lambda:ap-southeast-3:418787028745:layer:AWS-AppConfig-Extension:24',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:554480029851:layer:AWS-AppConfig-Extension:60',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:000010852771:layer:AWS-AppConfig-Extension:69',
            'af-south-1': 'arn:aws:lambda:af-south-1:574348263942:layer:AWS-AppConfig-Extension:47',
            'me-south-1': 'arn:aws:lambda:me-south-1:559955524753:layer:AWS-AppConfig-Extension:47',
            'us-gov-east-1': 'arn:aws-us-gov:lambda:us-gov-east-1:946561847325:layer:AWS-AppConfig-Extension:23',
            'us-gov-west-1': 'arn:aws-us-gov:lambda:us-gov-west-1:946746059096:layer:AWS-AppConfig-Extension:23',
        },
    },
    '2.0.45': {
        arm64: {
            'us-east-1': 'arn:aws:lambda:us-east-1:027255383542:layer:AWS-AppConfig-Extension-Arm64:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:728743619870:layer:AWS-AppConfig-Extension-Arm64:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:359756378197:layer:AWS-AppConfig-Extension-Arm64:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:066940009817:layer:AWS-AppConfig-Extension-Arm64:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:434848589818:layer:AWS-AppConfig-Extension-Arm64:6',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:282860088358:layer:AWS-AppConfig-Extension-Arm64:1',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:980059726660:layer:AWS-AppConfig-Extension-Arm64:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:421114256042:layer:AWS-AppConfig-Extension-Arm64:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:080788657173:layer:AWS-AppConfig-Extension-Arm64:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:554480029851:layer:AWS-AppConfig-Extension-Arm64:1',
        },
        x86_64: {
            'us-east-1': 'arn:aws:lambda:us-east-1:027255383542:layer:AWS-AppConfig-Extension:68',
            'us-east-2': 'arn:aws:lambda:us-east-2:728743619870:layer:AWS-AppConfig-Extension:49',
            'us-west-1': 'arn:aws:lambda:us-west-1:958113053741:layer:AWS-AppConfig-Extension:77',
            'us-west-2': 'arn:aws:lambda:us-west-2:359756378197:layer:AWS-AppConfig-Extension:100',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:039592058896:layer:AWS-AppConfig-Extension:49',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:066940009817:layer:AWS-AppConfig-Extension:58',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:434848589818:layer:AWS-AppConfig-Extension:68',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:282860088358:layer:AWS-AppConfig-Extension:49',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:493207061005:layer:AWS-AppConfig-Extension:50',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:646970417810:layer:AWS-AppConfig-Extension:97',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:203683718741:layer:AWS-AppConfig-Extension:46',
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:615057806174:layer:AWS-AppConfig-Extension:45',
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:615084187847:layer:AWS-AppConfig-Extension:45',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:630222743974:layer:AWS-AppConfig-Extension:46',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:980059726660:layer:AWS-AppConfig-Extension:48',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:826293736237:layer:AWS-AppConfig-Extension:58',
            'ap-northeast-3': 'arn:aws:lambda:ap-northeast-3:706869817123:layer:AWS-AppConfig-Extension:45',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:421114256042:layer:AWS-AppConfig-Extension:50',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:080788657173:layer:AWS-AppConfig-Extension:58',
            'ap-southeast-3': 'arn:aws:lambda:ap-southeast-3:418787028745:layer:AWS-AppConfig-Extension:23',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:554480029851:layer:AWS-AppConfig-Extension:59',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:000010852771:layer:AWS-AppConfig-Extension:68',
            'af-south-1': 'arn:aws:lambda:af-south-1:574348263942:layer:AWS-AppConfig-Extension:46',
            'me-south-1': 'arn:aws:lambda:me-south-1:559955524753:layer:AWS-AppConfig-Extension:46',
            'us-gov-east-1': 'arn:aws-us-gov:lambda:us-gov-east-1:946561847325:layer:AWS-AppConfig-Extension:22',
            'us-gov-west-1': 'arn:aws-us-gov:lambda:us-gov-west-1:946746059096:layer:AWS-AppConfig-Extension:22',
        },
    },
    '2.0.30': {
        x86_64: {
            'us-east-1': 'arn:aws:lambda:us-east-1:027255383542:layer:AWS-AppConfig-Extension:61',
            'us-east-2': 'arn:aws:lambda:us-east-2:728743619870:layer:AWS-AppConfig-Extension:47',
            'us-west-1': 'arn:aws:lambda:us-west-1:958113053741:layer:AWS-AppConfig-Extension:61',
            'us-west-2': 'arn:aws:lambda:us-west-2:359756378197:layer:AWS-AppConfig-Extension:89',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:039592058896:layer:AWS-AppConfig-Extension:47',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:066940009817:layer:AWS-AppConfig-Extension:54',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:434848589818:layer:AWS-AppConfig-Extension:59',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:282860088358:layer:AWS-AppConfig-Extension:47',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:493207061005:layer:AWS-AppConfig-Extension:48',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:646970417810:layer:AWS-AppConfig-Extension:86',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:203683718741:layer:AWS-AppConfig-Extension:44',
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:615057806174:layer:AWS-AppConfig-Extension:43',
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:615084187847:layer:AWS-AppConfig-Extension:43',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:630222743974:layer:AWS-AppConfig-Extension:44',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:980059726660:layer:AWS-AppConfig-Extension:45',
            'ap-northeast-3': 'arn:aws:lambda:ap-northeast-3:706869817123:layer:AWS-AppConfig-Extension:42',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:826293736237:layer:AWS-AppConfig-Extension:54',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:421114256042:layer:AWS-AppConfig-Extension:45',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:080788657173:layer:AWS-AppConfig-Extension:54',
            'ap-southeast-3': 'arn:aws:lambda:ap-southeast-3:418787028745:layer:AWS-AppConfig-Extension:13',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:554480029851:layer:AWS-AppConfig-Extension:55',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:000010852771:layer:AWS-AppConfig-Extension:61',
            'af-south-1': 'arn:aws:lambda:af-south-1:574348263942:layer:AWS-AppConfig-Extension:44',
            'me-south-1': 'arn:aws:lambda:me-south-1:559955524753:layer:AWS-AppConfig-Extension:44',
            'us-gov-east-1': 'arn:aws-us-gov:lambda:us-gov-east-1:946561847325:layer:AWS-AppConfig-Extension:20',
            'us-gov-west-1': 'arn:aws-us-gov:lambda:us-gov-west-1:946746059096:layer:AWS-AppConfig-Extension:20',
        },
    },
};
// https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Lambda-Insights-extension-versions.html
exports.CLOUDWATCH_LAMBDA_INSIGHTS_ARNS = {
    '1.0.229.0': {
        arm64: {
            'af-south-1': 'arn:aws:lambda:af-south-1:012438385374:layer:LambdaInsightsExtension-Arm64:2',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:519774774795:layer:LambdaInsightsExtension-Arm64:2',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension-Arm64:11',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension-Arm64:4',
            'ap-northeast-3': 'arn:aws:lambda:ap-northeast-3:194566237122:layer:LambdaInsightsExtension-Arm64:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension-Arm64:7',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension-Arm64:5',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension-Arm64:5',
            'ap-southeast-3': 'arn:aws:lambda:ap-southeast-3:439286490199:layer:LambdaInsightsExtension-Arm64:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension-Arm64:3',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension-Arm64:5',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension-Arm64:3',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:339249233099:layer:LambdaInsightsExtension-Arm64:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension-Arm64:5',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension-Arm64:5',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension-Arm64:3',
            'me-south-1': 'arn:aws:lambda:me-south-1:285320876703:layer:LambdaInsightsExtension-Arm64:2',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension-Arm64:3',
            'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension-Arm64:5',
            'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension-Arm64:7',
            'us-west-1': 'arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension-Arm64:3',
            'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension-Arm64:5',
        },
        x86_64: {
            'af-south-1': 'arn:aws:lambda:af-south-1:012438385374:layer:LambdaInsightsExtension:28',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:519774774795:layer:LambdaInsightsExtension:28',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:60',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:37',
            'ap-northeast-3': 'arn:aws:lambda:ap-northeast-3:194566237122:layer:LambdaInsightsExtension:19',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:36',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:891564319516:layer:LambdaInsightsExtension:10',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:38',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:38',
            'ap-southeast-3': 'arn:aws:lambda:ap-southeast-3:439286490199:layer:LambdaInsightsExtension:14',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:37',
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:488211338238:layer:LambdaInsightsExtension:29',
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:488211338238:layer:LambdaInsightsExtension:29',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:38',
            'eu-central-2': 'arn:aws:lambda:eu-central-2:033019950311:layer:LambdaInsightsExtension:11',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:35',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:339249233099:layer:LambdaInsightsExtension:28',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:352183217350:layer:LambdaInsightsExtension:12',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:38',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:38',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:37',
            'me-central-1': 'arn:aws:lambda:me-central-1:732604637566:layer:LambdaInsightsExtension:11',
            'me-south-1': 'arn:aws:lambda:me-south-1:285320876703:layer:LambdaInsightsExtension:28',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:37',
            'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:38',
            'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:38',
            'us-west-1': 'arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:38',
            'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:38',
        },
    },
    '1.0.178.0': {
        x86_64: {
            'af-south-1': 'arn:aws:lambda:af-south-1:012438385374:layer:LambdaInsightsExtension:25',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:519774774795:layer:LambdaInsightsExtension:25',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:50',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:32',
            'ap-northeast-3': 'arn:aws:lambda:ap-northeast-3:194566237122:layer:LambdaInsightsExtension:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:31',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:891564319516:layer:LambdaInsightsExtension:8',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:33',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:33',
            'ap-southeast-3': 'arn:aws:lambda:ap-southeast-3:439286490199:layer:LambdaInsightsExtension:11',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:32',
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:488211338238:layer:LambdaInsightsExtension:26',
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:488211338238:layer:LambdaInsightsExtension:26',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:35',
            'eu-central-2': 'arn:aws:lambda:eu-central-2:033019950311:layer:LambdaInsightsExtension:7',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:30',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:339249233099:layer:LambdaInsightsExtension:25',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:352183217350:layer:LambdaInsightsExtension:10',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:33',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:33',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:32',
            'me-central-1': 'arn:aws:lambda:me-central-1:732604637566:layer:LambdaInsightsExtension:9',
            'me-south-1': 'arn:aws:lambda:me-south-1:285320876703:layer:LambdaInsightsExtension:25',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:32',
            'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:35',
            'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:33',
            'us-west-1': 'arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:33',
            'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:33',
        },
    },
    '1.0.143.0': {
        x86_64: {
            'af-south-1': 'arn:aws:lambda:af-south-1:012438385374:layer:LambdaInsightsExtension:13',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:519774774795:layer:LambdaInsightsExtension:13',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:32',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:20',
            'ap-northeast-3': 'arn:aws:lambda:ap-northeast-3:194566237122:layer:LambdaInsightsExtension:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:21',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:21',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:21',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:20',
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:488211338238:layer:LambdaInsightsExtension:14',
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:488211338238:layer:LambdaInsightsExtension:14',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:21',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:20',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:339249233099:layer:LambdaInsightsExtension:13',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:21',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:21',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:20',
            'me-south-1': 'arn:aws:lambda:me-south-1:285320876703:layer:LambdaInsightsExtension:13',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:20',
            'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:21',
            'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:21',
            'us-west-1': 'arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:20',
            'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:21',
        },
    },
    '1.0.135.0': {
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension-Arm64:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension-Arm64:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension-Arm64:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension-Arm64:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension-Arm64:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension-Arm64:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension-Arm64:2',
            'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension-Arm64:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension-Arm64:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension-Arm64:2',
        },
        x86_64: {
            'af-south-1': 'arn:aws:lambda:af-south-1:012438385374:layer:LambdaInsightsExtension:11',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:519774774795:layer:LambdaInsightsExtension:11',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:25',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:18',
            'ap-northeast-3': 'arn:aws:lambda:ap-northeast-3:194566237122:layer:LambdaInsightsExtension:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:18',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:18',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:18',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:18',
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:488211338238:layer:LambdaInsightsExtension:11',
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:488211338238:layer:LambdaInsightsExtension:11',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:18',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:18',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:339249233099:layer:LambdaInsightsExtension:11',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:18',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:18',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:18',
            'me-south-1': 'arn:aws:lambda:me-south-1:285320876703:layer:LambdaInsightsExtension:11',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:18',
            'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:18',
            'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:18',
            'us-west-1': 'arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:18',
            'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:18',
        },
    },
    '1.0.119.0': {
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension-Arm64:1',
        },
        x86_64: {
            'af-south-1': 'arn:aws:lambda:af-south-1:012438385374:layer:LambdaInsightsExtension:9',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:519774774795:layer:LambdaInsightsExtension:9',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:23',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:16',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:16',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:16',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:16',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:16',
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:488211338238:layer:LambdaInsightsExtension:9',
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:488211338238:layer:LambdaInsightsExtension:9',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:16',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:16',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:339249233099:layer:LambdaInsightsExtension:9',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:16',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:16',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:16',
            'me-south-1': 'arn:aws:lambda:me-south-1:285320876703:layer:LambdaInsightsExtension:9',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:16',
            'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:16',
            'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:16',
            'us-west-1': 'arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:16',
            'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:16',
        },
    },
    '1.0.98.0': {
        x86_64: {
            'af-south-1': 'arn:aws:lambda:af-south-1:012438385374:layer:LambdaInsightsExtension:8',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:519774774795:layer:LambdaInsightsExtension:8',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:14',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:14',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:14',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:14',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:14',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:14',
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:488211338238:layer:LambdaInsightsExtension:8',
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:488211338238:layer:LambdaInsightsExtension:8',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:14',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:14',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:339249233099:layer:LambdaInsightsExtension:8',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:14',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:14',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:14',
            'me-south-1': 'arn:aws:lambda:me-south-1:285320876703:layer:LambdaInsightsExtension:8',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:14',
            'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:14',
            'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:14',
            'us-west-1': 'arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:14',
            'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:14',
        },
    },
    '1.0.89.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:12',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:12',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:12',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:12',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:12',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:12',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:12',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:12',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:12',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:12',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:12',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:12',
            'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:12',
            'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:12',
            'us-west-1': 'arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:12',
            'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:12',
        },
    },
    '1.0.86.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:11',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:11',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:11',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:11',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:11',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:11',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:11',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:11',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:11',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:11',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:11',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:11',
            'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:11',
            'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:11',
            'us-west-1': 'arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:11',
            'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:11',
        },
    },
    '1.0.54.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:2',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:2',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:2',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:2',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:2',
            'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:2',
            'us-west-1': 'arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:2',
        },
    },
};
// https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-rs-vpc
exports.FIREHOSE_CIDR_BLOCKS = {
    'af-south-1': '13.244.121.224',
    'ap-east-1': '18.162.221.32',
    'ap-northeast-1': '13.113.196.224',
    'ap-northeast-2': '13.209.1.64',
    'ap-northeast-3': '13.208.177.192',
    'ap-south-1': '13.232.67.32',
    'ap-southeast-1': '13.228.64.192',
    'ap-southeast-2': '13.210.67.224',
    'ap-southeast-3': '108.136.221.64',
    'ap-southeast-4': '16.50.161.128',
    'ca-central-1': '35.183.92.128',
    'cn-north-1': '52.81.151.32',
    'cn-northwest-1': '161.189.23.64',
    'eu-central-1': '35.158.127.160',
    'eu-north-1': '13.53.63.224',
    'eu-south-1': '15.161.135.128',
    'eu-west-1': '52.19.239.192',
    'eu-west-2': '18.130.1.96',
    'eu-west-3': '35.180.1.96',
    'il-central-1': '51.16.102.0',
    'me-central-1': '3.28.159.32',
    'me-south-1': '15.185.91.0',
    'sa-east-1': '18.228.1.128',
    'us-east-1': '52.70.63.192',
    'us-east-2': '13.58.135.96',
    'us-gov-east-1': '18.253.138.96',
    'us-gov-west-1': '52.61.204.160',
    'us-west-1': '13.57.135.192',
    'us-west-2': '52.89.255.224',
};
// https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieving-secrets_lambda.html#retrieving-secrets_lambda_ARNs
exports.PARAMS_AND_SECRETS_LAMBDA_LAYER_ARNS = {
    '1.0.103': {
        x86_64: {
            'af-south-1': 'arn:aws:lambda:af-south-1:317013901791:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:768336418462:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:133490724326:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:738900069198:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'ap-northeast-3': 'arn:aws:lambda:ap-northeast-3:576959938190:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:176022468876:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:070087711984:layer:AWS-Parameters-and-Secrets-Lambda-Extension:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:044395824272:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:665172237481:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'ap-southeast-3': 'arn:aws:lambda:ap-southeast-3:490737872127:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:200266452380:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:287114880934:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:287310001119:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:187925254637:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'eu-central-2': 'arn:aws:lambda:eu-central-2:772501565639:layer:AWS-Parameters-and-Secrets-Lambda-Extension:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:427196147048:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:325218067255:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:524103009944:layer:AWS-Parameters-and-Secrets-Lambda-Extension:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:015030872274:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:133256977650:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:780235371811:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'me-central-1': 'arn:aws:lambda:me-central-1:858974508948:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'me-south-1': 'arn:aws:lambda:me-south-1:832021897121:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:933737806257:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'us-east-1': 'arn:aws:lambda:us-east-1:177933569100:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'us-east-2': 'arn:aws:lambda:us-east-2:590474943231:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'us-gov-east-1': 'arn:aws-us-gov:lambda:us-gov-east-1:129776340158:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'us-gov-west-1': 'arn:aws-us-gov:lambda:us-gov-west-1:127562683043:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'us-west-1': 'arn:aws:lambda:us-west-1:997803712105:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
            'us-west-2': 'arn:aws:lambda:us-west-2:345057560386:layer:AWS-Parameters-and-Secrets-Lambda-Extension:4',
        },
        arm64: {
            'af-south-1': 'arn:aws:lambda:af-south-1:317013901791:layer:AWS-Parameters-and-Secrets-Lambda-Extension-Arm64:1',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:768336418462:layer:AWS-Parameters-and-Secrets-Lambda-Extension-Arm64:1',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:133490724326:layer:AWS-Parameters-and-Secrets-Lambda-Extension-Arm64:4',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:738900069198:layer:AWS-Parameters-and-Secrets-Lambda-Extension-Arm64:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:176022468876:layer:AWS-Parameters-and-Secrets-Lambda-Extension-Arm64:4',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:044395824272:layer:AWS-Parameters-and-Secrets-Lambda-Extension-Arm64:4',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:665172237481:layer:AWS-Parameters-and-Secrets-Lambda-Extension-Arm64:4',
            'ap-southeast-3': 'arn:aws:lambda:ap-southeast-3:490737872127:layer:AWS-Parameters-and-Secrets-Lambda-Extension-Arm64:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:200266452380:layer:AWS-Parameters-and-Secrets-Lambda-Extension-Arm64:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:187925254637:layer:AWS-Parameters-and-Secrets-Lambda-Extension-Arm64:4',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:427196147048:layer:AWS-Parameters-and-Secrets-Lambda-Extension-Arm64:1',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:325218067255:layer:AWS-Parameters-and-Secrets-Lambda-Extension-Arm64:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:015030872274:layer:AWS-Parameters-and-Secrets-Lambda-Extension-Arm64:4',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:133256977650:layer:AWS-Parameters-and-Secrets-Lambda-Extension-Arm64:4',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:780235371811:layer:AWS-Parameters-and-Secrets-Lambda-Extension-Arm64:1',
            'me-south-1': 'arn:aws:lambda:me-south-1:832021897121:layer:AWS-Parameters-and-Secrets-Lambda-Extension-Arm64:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:933737806257:layer:AWS-Parameters-and-Secrets-Lambda-Extension-Arm64:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:177933569100:layer:AWS-Parameters-and-Secrets-Lambda-Extension-Arm64:4',
            'us-east-2': 'arn:aws:lambda:us-east-2:590474943231:layer:AWS-Parameters-and-Secrets-Lambda-Extension-Arm64:4',
            'us-west-1': 'arn:aws:lambda:us-west-1:997803712105:layer:AWS-Parameters-and-Secrets-Lambda-Extension-Arm64:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:345057560386:layer:AWS-Parameters-and-Secrets-Lambda-Extension-Arm64:4',
        },
    },
};
const ADOT_LAMBDA_LAYER_JAVA_SDK_ARNS = {
    '1.28.1': {
        x86_64: {
            'af-south-1': 'arn:aws:lambda:af-south-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            // 'ap-northeast-3': 'arn:aws:lambda:ap-northeast-3:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            // 'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            // 'ap-southeast-3': 'arn:aws:lambda:ap-southeast-3:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            // 'ap-southeast-4': 'arn:aws:lambda:ap-southeast-4:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            // 'eu-central-2': 'arn:aws:lambda:eu-central-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            // 'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            // 'il-central-1': 'arn:aws:lambda:il-central-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            // 'me-central-1': 'arn:aws:lambda:me-central-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            'me-south-1': 'arn:aws:lambda:me-south-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-1:1',
        },
        arm64: {
            'af-south-1': 'arn:aws:lambda:af-south-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            // 'ap-northeast-3': 'arn:aws:lambda:ap-northeast-3:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            // 'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            // 'ap-southeast-3': 'arn:aws:lambda:ap-southeast-3:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            // 'ap-southeast-4': 'arn:aws:lambda:ap-southeast-4:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            // 'eu-central-2': 'arn:aws:lambda:eu-central-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            // 'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            // 'il-central-1': 'arn:aws:lambda:il-central-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            // 'me-central-1': 'arn:aws:lambda:me-central-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            'me-south-1': 'arn:aws:lambda:me-south-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-1:1',
        },
    },
    '1.28.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-0:1',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-0:1',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-28-0:1',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-0:1',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-0:1',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-28-0:1',
        },
    },
    '1.26.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-26-0:2',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-26-0:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-26-0:2',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-26-0:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-26-0:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-26-0:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-26-0:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-26-0:2',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-26-0:2',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-26-0:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-26-0:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-26-0:2',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-26-0:2',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-26-0:2',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-26-0:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-26-0:2',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-26-0:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-26-0:2',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-26-0:2',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-26-0:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-26-0:2',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-26-0:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-26-0:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-26-0:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-26-0:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-26-0:2',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-26-0:2',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-26-0:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-26-0:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-26-0:2',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-26-0:2',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-26-0:2',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-26-0:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-26-0:2',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-26-0:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-26-0:2',
        },
    },
    '1.24.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-24-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-24-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-24-0:1',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-24-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-24-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-24-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-24-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-24-0:1',
            'eu-central-2': 'arn:aws:lambda:eu-central-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-24-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-24-0:1',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-24-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-24-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-24-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-24-0:1',
            'me-central-1': 'arn:aws:lambda:me-central-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-24-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-24-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-24-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-24-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-24-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-24-0:1',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-24-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-24-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-24-0:1',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-24-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-24-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-24-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-24-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-24-0:1',
            'eu-central-2': 'arn:aws:lambda:eu-central-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-24-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-24-0:1',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-24-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-24-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-24-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-24-0:1',
            'me-central-1': 'arn:aws:lambda:me-central-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-24-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-24-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-24-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-24-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-24-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-24-0:1',
        },
    },
    '1.23.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-23-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-23-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-23-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-23-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-23-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-23-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-23-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-23-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-23-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-23-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-23-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-23-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-23-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-23-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-23-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-23-0:1',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-23-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-23-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-23-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-23-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-23-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-23-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-23-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-23-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-23-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-23-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-23-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-23-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-23-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-23-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-23-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-23-0:1',
        },
    },
    '1.21.1': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-1:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-1:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-1:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-1:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-1:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-1:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-1:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-1:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-1:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-1:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-1:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-1:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-1:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-1:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-1:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-1:1',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-1:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-1:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-1:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-1:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-1:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-1:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-1:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-1:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-1:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-1:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-1:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-1:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-1:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-1:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-1:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-1:1',
        },
    },
    '1.21.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-21-0:1',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-21-0:1',
        },
    },
    '1.19.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-19-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-19-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-19-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-19-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-19-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-19-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-19-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-19-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-19-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-19-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-19-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-19-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-19-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-19-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-19-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-wrapper-amd64-ver-1-19-0:1',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-19-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-19-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-19-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-19-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-19-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-19-0:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-19-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-19-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-19-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-19-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-19-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-19-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-19-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-19-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-19-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-wrapper-arm64-ver-1-19-0:1',
        },
    },
};
const ADOT_LAMBDA_LAYER_JAVA_AUTO_INSTRUMENTATION_ARNS = {
    '1.28.1': {
        x86_64: {
            'af-south-1': 'arn:aws:lambda:af-south-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            // 'ap-northeast-3': 'arn:aws:lambda:ap-northeast-3:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            // 'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            // 'ap-southeast-3': 'arn:aws:lambda:ap-southeast-3:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            // 'ap-southeast-4': 'arn:aws:lambda:ap-southeast-4:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            // 'eu-central-2': 'arn:aws:lambda:eu-central-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            // 'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            // 'il-central-1': 'arn:aws:lambda:il-central-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            // 'me-central-1': 'arn:aws:lambda:me-central-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            'me-south-1': 'arn:aws:lambda:me-south-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-1:1',
        },
        arm64: {
            'af-south-1': 'arn:aws:lambda:af-south-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            // 'ap-northeast-3': 'arn:aws:lambda:ap-northeast-3:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            // 'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            // 'ap-southeast-3': 'arn:aws:lambda:ap-southeast-3:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            // 'ap-southeast-4': 'arn:aws:lambda:ap-southeast-4:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            // 'eu-central-2': 'arn:aws:lambda:eu-central-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            // 'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            // 'il-central-1': 'arn:aws:lambda:il-central-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            // 'me-central-1': 'arn:aws:lambda:me-central-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            'me-south-1': 'arn:aws:lambda:me-south-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-1:1',
        },
    },
    '1.28.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-0:1',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-0:1',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-28-0:1',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-0:1',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-0:1',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-28-0:1',
        },
    },
    '1.26.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-26-0:2',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-26-0:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-26-0:2',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-26-0:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-26-0:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-26-0:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-26-0:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-26-0:2',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-26-0:2',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-26-0:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-26-0:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-26-0:2',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-agent-amd64-ver-1-26-0:2',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-26-0:2',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-26-0:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-26-0:2',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-26-0:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-26-0:2',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-26-0:2',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-26-0:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-26-0:2',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-26-0:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-26-0:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-26-0:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-26-0:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-26-0:2',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-26-0:2',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-26-0:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-26-0:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-26-0:2',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-agent-arm64-ver-1-26-0:2',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-26-0:2',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-26-0:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-26-0:2',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-26-0:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-26-0:2',
        },
    },
    '1.24.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-24-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-24-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-24-0:1',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-24-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-24-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-24-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-24-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-24-0:1',
            'eu-central-2': 'arn:aws:lambda:eu-central-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-24-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-24-0:1',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-24-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-24-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-24-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-agent-amd64-ver-1-24-0:1',
            'me-central-1': 'arn:aws:lambda:me-central-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-24-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-24-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-24-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-24-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-24-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-24-0:1',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-24-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-24-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-24-0:1',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-24-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-24-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-24-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-24-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-24-0:1',
            'eu-central-2': 'arn:aws:lambda:eu-central-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-24-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-24-0:1',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-24-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-24-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-24-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-agent-arm64-ver-1-24-0:1',
            'me-central-1': 'arn:aws:lambda:me-central-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-24-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-24-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-24-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-24-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-24-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-24-0:1',
        },
    },
    '1.23.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-23-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-23-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-23-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-23-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-23-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-23-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-23-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-23-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-23-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-23-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-agent-amd64-ver-1-23-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-23-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-23-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-23-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-23-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-23-0:1',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-23-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-23-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-23-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-23-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-23-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-23-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-23-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-23-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-23-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-23-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-agent-arm64-ver-1-23-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-23-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-23-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-23-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-23-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-23-0:1',
        },
    },
    '1.21.1': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-1:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-1:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-1:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-1:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-1:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-1:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-1:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-1:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-1:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-1:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-1:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-1:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-1:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-1:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-1:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-1:1',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-1:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-1:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-1:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-1:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-1:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-1:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-1:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-1:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-1:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-1:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-1:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-1:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-1:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-1:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-1:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-1:1',
        },
    },
    '1.21.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-21-0:1',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-21-0:1',
        },
    },
    '1.19.2': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-19-2:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-19-2:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-19-2:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-19-2:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-19-2:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-19-2:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-19-2:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-19-2:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-19-2:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-19-2:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-agent-amd64-ver-1-19-2:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-19-2:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-19-2:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-19-2:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-agent-amd64-ver-1-19-2:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-agent-amd64-ver-1-19-2:1',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-19-2:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-19-2:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-19-2:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-19-2:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-19-2:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-19-2:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-19-2:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-19-2:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-19-2:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-19-2:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-java-agent-arm64-ver-1-19-2:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-19-2:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-19-2:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-19-2:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-java-agent-arm64-ver-1-19-2:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-java-agent-arm64-ver-1-19-2:1',
        },
    },
};
const ADOT_LAMBDA_LAYER_JAVASCRIPT_SDK_ARNS = {
    '1.15.0-1': {
        x86_64: {
            'af-south-1': 'arn:aws:lambda:af-south-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            // 'ap-northeast-3': 'arn:aws:lambda:ap-northeast-3:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            // 'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            // 'ap-southeast-3': 'arn:aws:lambda:ap-southeast-3:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            // 'ap-southeast-4': 'arn:aws:lambda:ap-southeast-4:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            // 'eu-central-2': 'arn:aws:lambda:eu-central-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            // 'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            // 'il-central-1': 'arn:aws:lambda:il-central-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            // 'me-central-1': 'arn:aws:lambda:me-central-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            'me-south-1': 'arn:aws:lambda:me-south-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:2',
        },
        arm64: {
            'af-south-1': 'arn:aws:lambda:af-south-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            // 'ap-northeast-3': 'arn:aws:lambda:ap-northeast-3:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            // 'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            // 'ap-southeast-3': 'arn:aws:lambda:ap-southeast-3:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            // 'ap-southeast-4': 'arn:aws:lambda:ap-southeast-4:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            // 'eu-central-2': 'arn:aws:lambda:eu-central-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            // 'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            // 'il-central-1': 'arn:aws:lambda:il-central-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            // 'me-central-1': 'arn:aws:lambda:me-central-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            'me-south-1': 'arn:aws:lambda:me-south-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:2',
        },
    },
    '1.15.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:1',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:1',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-15-0:1',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:1',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:1',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-15-0:1',
        },
    },
    '1.13.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-13-0:2',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-13-0:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-13-0:2',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-13-0:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-13-0:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-13-0:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-13-0:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-13-0:2',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-13-0:2',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-13-0:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-13-0:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-13-0:2',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-nodejs-amd64-ver-1-13-0:2',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-13-0:2',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-13-0:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-13-0:2',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-13-0:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-13-0:2',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-13-0:2',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-13-0:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-13-0:2',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-13-0:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-13-0:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-13-0:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-13-0:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-13-0:2',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-13-0:2',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-13-0:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-13-0:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-13-0:2',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-nodejs-arm64-ver-1-13-0:2',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-13-0:2',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-13-0:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-13-0:2',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-13-0:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-13-0:2',
        },
    },
    '1.12.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-12-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-12-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-12-0:1',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-12-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-12-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-12-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-12-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-12-0:1',
            'eu-central-2': 'arn:aws:lambda:eu-central-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-12-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-12-0:1',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-12-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-12-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-12-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-nodejs-amd64-ver-1-12-0:1',
            'me-central-1': 'arn:aws:lambda:me-central-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-12-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-12-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-12-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-12-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-12-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-12-0:1',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-12-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-12-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-12-0:1',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-12-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-12-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-12-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-12-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-12-0:1',
            'eu-central-2': 'arn:aws:lambda:eu-central-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-12-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-12-0:1',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-12-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-12-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-12-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-nodejs-arm64-ver-1-12-0:1',
            'me-central-1': 'arn:aws:lambda:me-central-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-12-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-12-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-12-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-12-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-12-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-12-0:1',
        },
    },
    '1.9.1': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-9-1:2',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-9-1:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-9-1:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-9-1:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-9-1:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-9-1:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-9-1:2',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-9-1:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-9-1:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-9-1:2',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-nodejs-amd64-ver-1-9-1:2',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-9-1:2',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-9-1:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-9-1:2',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-9-1:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-9-1:2',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-9-1:2',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-9-1:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-9-1:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-9-1:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-9-1:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-9-1:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-9-1:2',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-9-1:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-9-1:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-9-1:2',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-nodejs-arm64-ver-1-9-1:2',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-9-1:2',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-9-1:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-9-1:2',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-9-1:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-9-1:2',
        },
    },
    '1.8.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-8-0:2',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-8-0:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-8-0:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-8-0:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-8-0:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-8-0:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-8-0:2',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-8-0:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-8-0:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-8-0:2',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-nodejs-amd64-ver-1-8-0:2',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-8-0:2',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-8-0:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-8-0:2',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-8-0:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-8-0:2',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-8-0:2',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-8-0:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-8-0:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-8-0:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-8-0:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-8-0:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-8-0:2',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-8-0:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-8-0:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-8-0:2',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-nodejs-arm64-ver-1-8-0:2',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-8-0:2',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-8-0:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-8-0:2',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-8-0:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-8-0:2',
        },
    },
    '1.7.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-7-0:2',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-7-0:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-7-0:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-7-0:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-7-0:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-7-0:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-7-0:2',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-7-0:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-7-0:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-7-0:2',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-nodejs-amd64-ver-1-7-0:2',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-7-0:2',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-7-0:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-7-0:2',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-nodejs-amd64-ver-1-7-0:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-nodejs-amd64-ver-1-7-0:2',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-7-0:2',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-7-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-7-0:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-7-0:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-7-0:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-7-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-7-0:2',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-7-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-7-0:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-7-0:2',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-nodejs-arm64-ver-1-7-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-7-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-7-0:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-7-0:2',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-nodejs-arm64-ver-1-7-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-nodejs-arm64-ver-1-7-0:2',
        },
    },
};
const ADOT_LAMBDA_LAYER_PYTHON_SDK_ARNS = {
    '1.19.0-1': {
        x86_64: {
            'af-south-1': 'arn:aws:lambda:af-south-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            // 'ap-northeast-3': 'arn:aws:lambda:ap-northeast-3:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            // 'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            // 'ap-southeast-3': 'arn:aws:lambda:ap-southeast-3:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            // 'ap-southeast-4': 'arn:aws:lambda:ap-southeast-4:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            // 'eu-central-2': 'arn:aws:lambda:eu-central-2:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            // 'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            // 'il-central-1': 'arn:aws:lambda:il-central-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            // 'me-central-1': 'arn:aws:lambda:me-central-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            'me-south-1': 'arn:aws:lambda:me-south-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:2',
        },
        arm64: {
            'af-south-1': 'arn:aws:lambda:af-south-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            // 'ap-northeast-3': 'arn:aws:lambda:ap-northeast-3:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            // 'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            // 'ap-southeast-3': 'arn:aws:lambda:ap-southeast-3:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            // 'ap-southeast-4': 'arn:aws:lambda:ap-southeast-4:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            // 'eu-central-2': 'arn:aws:lambda:eu-central-2:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            // 'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            // 'il-central-1': 'arn:aws:lambda:il-central-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            // 'me-central-1': 'arn:aws:lambda:me-central-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            'me-south-1': 'arn:aws:lambda:me-south-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:2',
        },
    },
    '1.19.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:1',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:1',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-python-amd64-ver-1-19-0:1',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:1',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:1',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-python-arm64-ver-1-19-0:1',
        },
    },
    '1.18.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-python-amd64-ver-1-18-0:2',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-python-amd64-ver-1-18-0:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-python-amd64-ver-1-18-0:2',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-python-amd64-ver-1-18-0:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-python-amd64-ver-1-18-0:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-python-amd64-ver-1-18-0:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-python-amd64-ver-1-18-0:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-python-amd64-ver-1-18-0:2',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-python-amd64-ver-1-18-0:2',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-python-amd64-ver-1-18-0:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-python-amd64-ver-1-18-0:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-python-amd64-ver-1-18-0:2',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-python-amd64-ver-1-18-0:2',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-python-amd64-ver-1-18-0:2',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-python-amd64-ver-1-18-0:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-python-amd64-ver-1-18-0:2',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-python-amd64-ver-1-18-0:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-python-amd64-ver-1-18-0:2',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-python-arm64-ver-1-18-0:2',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-python-arm64-ver-1-18-0:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-python-arm64-ver-1-18-0:2',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-python-arm64-ver-1-18-0:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-python-arm64-ver-1-18-0:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-python-arm64-ver-1-18-0:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-python-arm64-ver-1-18-0:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-python-arm64-ver-1-18-0:2',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-python-arm64-ver-1-18-0:2',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-python-arm64-ver-1-18-0:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-python-arm64-ver-1-18-0:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-python-arm64-ver-1-18-0:2',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-python-arm64-ver-1-18-0:2',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-python-arm64-ver-1-18-0:2',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-python-arm64-ver-1-18-0:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-python-arm64-ver-1-18-0:2',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-python-arm64-ver-1-18-0:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-python-arm64-ver-1-18-0:2',
        },
    },
    '1.17.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-python-amd64-ver-1-17-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-python-amd64-ver-1-17-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-python-amd64-ver-1-17-0:1',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-python-amd64-ver-1-17-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-python-amd64-ver-1-17-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-python-amd64-ver-1-17-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-python-amd64-ver-1-17-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-python-amd64-ver-1-17-0:1',
            'eu-central-2': 'arn:aws:lambda:eu-central-2:901920570463:layer:aws-otel-python-amd64-ver-1-17-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-python-amd64-ver-1-17-0:1',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-python-amd64-ver-1-17-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-python-amd64-ver-1-17-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-python-amd64-ver-1-17-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-python-amd64-ver-1-17-0:1',
            'me-central-1': 'arn:aws:lambda:me-central-1:901920570463:layer:aws-otel-python-amd64-ver-1-17-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-python-amd64-ver-1-17-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-python-amd64-ver-1-17-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-python-amd64-ver-1-17-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-python-amd64-ver-1-17-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-python-amd64-ver-1-17-0:1',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-python-arm64-ver-1-17-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-python-arm64-ver-1-17-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-python-arm64-ver-1-17-0:1',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-python-arm64-ver-1-17-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-python-arm64-ver-1-17-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-python-arm64-ver-1-17-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-python-arm64-ver-1-17-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-python-arm64-ver-1-17-0:1',
            'eu-central-2': 'arn:aws:lambda:eu-central-2:901920570463:layer:aws-otel-python-arm64-ver-1-17-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-python-arm64-ver-1-17-0:1',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-python-arm64-ver-1-17-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-python-arm64-ver-1-17-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-python-arm64-ver-1-17-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-python-arm64-ver-1-17-0:1',
            'me-central-1': 'arn:aws:lambda:me-central-1:901920570463:layer:aws-otel-python-arm64-ver-1-17-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-python-arm64-ver-1-17-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-python-arm64-ver-1-17-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-python-arm64-ver-1-17-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-python-arm64-ver-1-17-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-python-arm64-ver-1-17-0:1',
        },
    },
    '1.16.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-python-amd64-ver-1-16-0:2',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-python-amd64-ver-1-16-0:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-python-amd64-ver-1-16-0:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-python-amd64-ver-1-16-0:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-python-amd64-ver-1-16-0:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-python-amd64-ver-1-16-0:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-python-amd64-ver-1-16-0:2',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-python-amd64-ver-1-16-0:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-python-amd64-ver-1-16-0:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-python-amd64-ver-1-16-0:2',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-python-amd64-ver-1-16-0:2',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-python-amd64-ver-1-16-0:2',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-python-amd64-ver-1-16-0:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-python-amd64-ver-1-16-0:2',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-python-amd64-ver-1-16-0:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-python-amd64-ver-1-16-0:2',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-python-arm64-ver-1-16-0:2',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-python-arm64-ver-1-16-0:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-python-arm64-ver-1-16-0:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-python-arm64-ver-1-16-0:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-python-arm64-ver-1-16-0:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-python-arm64-ver-1-16-0:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-python-arm64-ver-1-16-0:2',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-python-arm64-ver-1-16-0:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-python-arm64-ver-1-16-0:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-python-arm64-ver-1-16-0:2',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-python-arm64-ver-1-16-0:2',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-python-arm64-ver-1-16-0:2',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-python-arm64-ver-1-16-0:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-python-arm64-ver-1-16-0:2',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-python-arm64-ver-1-16-0:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-python-arm64-ver-1-16-0:2',
        },
    },
    '1.15.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-python-amd64-ver-1-15-0:2',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-python-amd64-ver-1-15-0:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-python-amd64-ver-1-15-0:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-python-amd64-ver-1-15-0:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-python-amd64-ver-1-15-0:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-python-amd64-ver-1-15-0:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-python-amd64-ver-1-15-0:2',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-python-amd64-ver-1-15-0:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-python-amd64-ver-1-15-0:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-python-amd64-ver-1-15-0:2',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-python-amd64-ver-1-15-0:2',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-python-amd64-ver-1-15-0:2',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-python-amd64-ver-1-15-0:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-python-amd64-ver-1-15-0:2',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-python-amd64-ver-1-15-0:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-python-amd64-ver-1-15-0:2',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-python-arm64-ver-1-15-0:2',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-python-arm64-ver-1-15-0:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-python-arm64-ver-1-15-0:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-python-arm64-ver-1-15-0:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-python-arm64-ver-1-15-0:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-python-arm64-ver-1-15-0:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-python-arm64-ver-1-15-0:2',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-python-arm64-ver-1-15-0:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-python-arm64-ver-1-15-0:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-python-arm64-ver-1-15-0:2',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-python-arm64-ver-1-15-0:2',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-python-arm64-ver-1-15-0:2',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-python-arm64-ver-1-15-0:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-python-arm64-ver-1-15-0:2',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-python-arm64-ver-1-15-0:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-python-arm64-ver-1-15-0:2',
        },
    },
    '1.13.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-python-amd64-ver-1-13-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-python-amd64-ver-1-13-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-python-amd64-ver-1-13-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-python-amd64-ver-1-13-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-python-amd64-ver-1-13-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-python-amd64-ver-1-13-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-python-amd64-ver-1-13-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-python-amd64-ver-1-13-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-python-amd64-ver-1-13-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-python-amd64-ver-1-13-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-python-amd64-ver-1-13-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-python-amd64-ver-1-13-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-python-amd64-ver-1-13-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-python-amd64-ver-1-13-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-python-amd64-ver-1-13-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-python-amd64-ver-1-13-0:1',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-python-arm64-ver-1-13-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-python-arm64-ver-1-13-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-python-arm64-ver-1-13-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-python-arm64-ver-1-13-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-python-arm64-ver-1-13-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-python-arm64-ver-1-13-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-python-arm64-ver-1-13-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-python-arm64-ver-1-13-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-python-arm64-ver-1-13-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-python-arm64-ver-1-13-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-python-arm64-ver-1-13-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-python-arm64-ver-1-13-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-python-arm64-ver-1-13-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-python-arm64-ver-1-13-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-python-arm64-ver-1-13-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-python-arm64-ver-1-13-0:1',
        },
    },
};
const ADOT_LAMBDA_LAYER_GENERIC_ARNS = {
    '0.82.0': {
        x86_64: {
            'af-south-1': 'arn:aws:lambda:af-south-1:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            // 'ap-northeast-3': 'arn:aws:lambda:ap-northeast-3:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            // 'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            // 'ap-southeast-3': 'arn:aws:lambda:ap-southeast-3:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            // 'ap-southeast-4': 'arn:aws:lambda:ap-southeast-4:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            // 'eu-central-2': 'arn:aws:lambda:eu-central-2:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            // 'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            // 'il-central-1': 'arn:aws:lambda:il-central-1:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            // 'me-central-1': 'arn:aws:lambda:me-central-1:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            'me-south-1': 'arn:aws:lambda:me-south-1:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-collector-amd64-ver-0-82-0:1',
        },
        arm64: {
            'af-south-1': 'arn:aws:lambda:af-south-1:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            // 'ap-northeast-3': 'arn:aws:lambda:ap-northeast-3:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            // 'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            // 'ap-southeast-3': 'arn:aws:lambda:ap-southeast-3:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            // 'ap-southeast-4': 'arn:aws:lambda:ap-southeast-4:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            // 'eu-central-2': 'arn:aws:lambda:eu-central-2:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            // 'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            // 'il-central-1': 'arn:aws:lambda:il-central-1:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            // 'me-central-1': 'arn:aws:lambda:me-central-1:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            'me-south-1': 'arn:aws:lambda:me-south-1:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-collector-arm64-ver-0-82-0:1',
        },
    },
    '0.80.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-collector-amd64-ver-0-80-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-collector-amd64-ver-0-80-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-collector-amd64-ver-0-80-0:1',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-collector-amd64-ver-0-80-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-collector-amd64-ver-0-80-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-collector-amd64-ver-0-80-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-collector-amd64-ver-0-80-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-collector-amd64-ver-0-80-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-collector-amd64-ver-0-80-0:1',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-collector-amd64-ver-0-80-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-collector-amd64-ver-0-80-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-collector-amd64-ver-0-80-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-collector-amd64-ver-0-80-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-collector-amd64-ver-0-80-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-collector-amd64-ver-0-80-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-collector-amd64-ver-0-80-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-collector-amd64-ver-0-80-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-collector-amd64-ver-0-80-0:1',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-collector-arm64-ver-0-80-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-collector-arm64-ver-0-80-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-collector-arm64-ver-0-80-0:1',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-collector-arm64-ver-0-80-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-collector-arm64-ver-0-80-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-collector-arm64-ver-0-80-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-collector-arm64-ver-0-80-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-collector-arm64-ver-0-80-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-collector-arm64-ver-0-80-0:1',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-collector-arm64-ver-0-80-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-collector-arm64-ver-0-80-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-collector-arm64-ver-0-80-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-collector-arm64-ver-0-80-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-collector-arm64-ver-0-80-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-collector-arm64-ver-0-80-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-collector-arm64-ver-0-80-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-collector-arm64-ver-0-80-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-collector-arm64-ver-0-80-0:1',
        },
    },
    '0.78.2': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-collector-amd64-ver-0-78-2:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-collector-amd64-ver-0-78-2:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-collector-amd64-ver-0-78-2:1',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-collector-amd64-ver-0-78-2:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-collector-amd64-ver-0-78-2:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-collector-amd64-ver-0-78-2:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-collector-amd64-ver-0-78-2:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-collector-amd64-ver-0-78-2:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-collector-amd64-ver-0-78-2:1',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-collector-amd64-ver-0-78-2:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-collector-amd64-ver-0-78-2:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-collector-amd64-ver-0-78-2:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-collector-amd64-ver-0-78-2:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-collector-amd64-ver-0-78-2:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-collector-amd64-ver-0-78-2:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-collector-amd64-ver-0-78-2:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-collector-amd64-ver-0-78-2:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-collector-amd64-ver-0-78-2:1',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-collector-arm64-ver-0-78-2:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-collector-arm64-ver-0-78-2:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-collector-arm64-ver-0-78-2:1',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-collector-arm64-ver-0-78-2:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-collector-arm64-ver-0-78-2:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-collector-arm64-ver-0-78-2:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-collector-arm64-ver-0-78-2:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-collector-arm64-ver-0-78-2:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-collector-arm64-ver-0-78-2:1',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-collector-arm64-ver-0-78-2:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-collector-arm64-ver-0-78-2:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-collector-arm64-ver-0-78-2:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-collector-arm64-ver-0-78-2:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-collector-arm64-ver-0-78-2:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-collector-arm64-ver-0-78-2:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-collector-arm64-ver-0-78-2:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-collector-arm64-ver-0-78-2:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-collector-arm64-ver-0-78-2:1',
        },
    },
    '0.74.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-collector-amd64-ver-0-74-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-collector-amd64-ver-0-74-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-collector-amd64-ver-0-74-0:1',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-collector-amd64-ver-0-74-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-collector-amd64-ver-0-74-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-collector-amd64-ver-0-74-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-collector-amd64-ver-0-74-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-collector-amd64-ver-0-74-0:1',
            'eu-central-2': 'arn:aws:lambda:eu-central-2:901920570463:layer:aws-otel-collector-amd64-ver-0-74-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-collector-amd64-ver-0-74-0:1',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-collector-amd64-ver-0-74-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-collector-amd64-ver-0-74-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-collector-amd64-ver-0-74-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-collector-amd64-ver-0-74-0:1',
            'me-central-1': 'arn:aws:lambda:me-central-1:901920570463:layer:aws-otel-collector-amd64-ver-0-74-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-collector-amd64-ver-0-74-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-collector-amd64-ver-0-74-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-collector-amd64-ver-0-74-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-collector-amd64-ver-0-74-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-collector-amd64-ver-0-74-0:1',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-collector-arm64-ver-0-74-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-collector-arm64-ver-0-74-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-collector-arm64-ver-0-74-0:1',
            'ap-south-2': 'arn:aws:lambda:ap-south-2:901920570463:layer:aws-otel-collector-arm64-ver-0-74-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-collector-arm64-ver-0-74-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-collector-arm64-ver-0-74-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-collector-arm64-ver-0-74-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-collector-arm64-ver-0-74-0:1',
            'eu-central-2': 'arn:aws:lambda:eu-central-2:901920570463:layer:aws-otel-collector-arm64-ver-0-74-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-collector-arm64-ver-0-74-0:1',
            'eu-south-2': 'arn:aws:lambda:eu-south-2:901920570463:layer:aws-otel-collector-arm64-ver-0-74-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-collector-arm64-ver-0-74-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-collector-arm64-ver-0-74-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-collector-arm64-ver-0-74-0:1',
            'me-central-1': 'arn:aws:lambda:me-central-1:901920570463:layer:aws-otel-collector-arm64-ver-0-74-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-collector-arm64-ver-0-74-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-collector-arm64-ver-0-74-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-collector-arm64-ver-0-74-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-collector-arm64-ver-0-74-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-collector-arm64-ver-0-74-0:1',
        },
    },
    '0.72.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-collector-amd64-ver-0-72-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-collector-amd64-ver-0-72-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-collector-amd64-ver-0-72-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-collector-amd64-ver-0-72-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-collector-amd64-ver-0-72-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-collector-amd64-ver-0-72-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-collector-amd64-ver-0-72-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-collector-amd64-ver-0-72-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-collector-amd64-ver-0-72-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-collector-amd64-ver-0-72-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-collector-amd64-ver-0-72-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-collector-amd64-ver-0-72-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-collector-amd64-ver-0-72-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-collector-amd64-ver-0-72-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-collector-amd64-ver-0-72-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-collector-amd64-ver-0-72-0:1',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-collector-arm64-ver-0-72-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-collector-arm64-ver-0-72-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-collector-arm64-ver-0-72-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-collector-arm64-ver-0-72-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-collector-arm64-ver-0-72-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-collector-arm64-ver-0-72-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-collector-arm64-ver-0-72-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-collector-arm64-ver-0-72-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-collector-arm64-ver-0-72-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-collector-arm64-ver-0-72-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-collector-arm64-ver-0-72-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-collector-arm64-ver-0-72-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-collector-arm64-ver-0-72-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-collector-arm64-ver-0-72-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-collector-arm64-ver-0-72-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-collector-arm64-ver-0-72-0:1',
        },
    },
    '0.70.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-collector-amd64-ver-0-70-0:4',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-collector-amd64-ver-0-70-0:4',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-collector-amd64-ver-0-70-0:4',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-collector-amd64-ver-0-70-0:4',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-collector-amd64-ver-0-70-0:4',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-collector-amd64-ver-0-70-0:4',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-collector-amd64-ver-0-70-0:4',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-collector-amd64-ver-0-70-0:4',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-collector-amd64-ver-0-70-0:4',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-collector-amd64-ver-0-70-0:4',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-collector-amd64-ver-0-70-0:4',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-collector-amd64-ver-0-70-0:4',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-collector-amd64-ver-0-70-0:4',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-collector-amd64-ver-0-70-0:4',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-collector-amd64-ver-0-70-0:4',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-collector-amd64-ver-0-70-0:4',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-collector-arm64-ver-0-70-0:4',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-collector-arm64-ver-0-70-0:4',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-collector-arm64-ver-0-70-0:4',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-collector-arm64-ver-0-70-0:4',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-collector-arm64-ver-0-70-0:4',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-collector-arm64-ver-0-70-0:4',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-collector-arm64-ver-0-70-0:4',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-collector-arm64-ver-0-70-0:4',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-collector-arm64-ver-0-70-0:4',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-collector-arm64-ver-0-70-0:4',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-collector-arm64-ver-0-70-0:4',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-collector-arm64-ver-0-70-0:4',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-collector-arm64-ver-0-70-0:4',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-collector-arm64-ver-0-70-0:4',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-collector-arm64-ver-0-70-0:4',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-collector-arm64-ver-0-70-0:4',
        },
    },
    '0.68.0': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-collector-amd64-ver-0-68-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-collector-amd64-ver-0-68-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-collector-amd64-ver-0-68-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-collector-amd64-ver-0-68-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-collector-amd64-ver-0-68-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-collector-amd64-ver-0-68-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-collector-amd64-ver-0-68-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-collector-amd64-ver-0-68-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-collector-amd64-ver-0-68-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-collector-amd64-ver-0-68-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-collector-amd64-ver-0-68-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-collector-amd64-ver-0-68-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-collector-amd64-ver-0-68-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-collector-amd64-ver-0-68-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-collector-amd64-ver-0-68-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-collector-amd64-ver-0-68-0:1',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-collector-arm64-ver-0-68-0:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-collector-arm64-ver-0-68-0:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-collector-arm64-ver-0-68-0:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-collector-arm64-ver-0-68-0:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-collector-arm64-ver-0-68-0:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-collector-arm64-ver-0-68-0:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-collector-arm64-ver-0-68-0:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-collector-arm64-ver-0-68-0:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-collector-arm64-ver-0-68-0:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-collector-arm64-ver-0-68-0:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-collector-arm64-ver-0-68-0:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-collector-arm64-ver-0-68-0:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-collector-arm64-ver-0-68-0:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-collector-arm64-ver-0-68-0:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-collector-arm64-ver-0-68-0:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-collector-arm64-ver-0-68-0:1',
        },
    },
    '0.62.1': {
        x86_64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-collector-amd64-ver-0-62-1:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-collector-amd64-ver-0-62-1:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-collector-amd64-ver-0-62-1:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-collector-amd64-ver-0-62-1:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-collector-amd64-ver-0-62-1:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-collector-amd64-ver-0-62-1:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-collector-amd64-ver-0-62-1:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-collector-amd64-ver-0-62-1:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-collector-amd64-ver-0-62-1:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-collector-amd64-ver-0-62-1:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-collector-amd64-ver-0-62-1:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-collector-amd64-ver-0-62-1:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-collector-amd64-ver-0-62-1:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-collector-amd64-ver-0-62-1:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-collector-amd64-ver-0-62-1:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-collector-amd64-ver-0-62-1:1',
        },
        arm64: {
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:901920570463:layer:aws-otel-collector-arm64-ver-0-62-1:1',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:901920570463:layer:aws-otel-collector-arm64-ver-0-62-1:1',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:901920570463:layer:aws-otel-collector-arm64-ver-0-62-1:1',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:901920570463:layer:aws-otel-collector-arm64-ver-0-62-1:1',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:901920570463:layer:aws-otel-collector-arm64-ver-0-62-1:1',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:901920570463:layer:aws-otel-collector-arm64-ver-0-62-1:1',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:901920570463:layer:aws-otel-collector-arm64-ver-0-62-1:1',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:901920570463:layer:aws-otel-collector-arm64-ver-0-62-1:1',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:901920570463:layer:aws-otel-collector-arm64-ver-0-62-1:1',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:901920570463:layer:aws-otel-collector-arm64-ver-0-62-1:1',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:901920570463:layer:aws-otel-collector-arm64-ver-0-62-1:1',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:901920570463:layer:aws-otel-collector-arm64-ver-0-62-1:1',
            'us-east-1': 'arn:aws:lambda:us-east-1:901920570463:layer:aws-otel-collector-arm64-ver-0-62-1:1',
            'us-east-2': 'arn:aws:lambda:us-east-2:901920570463:layer:aws-otel-collector-arm64-ver-0-62-1:1',
            'us-west-1': 'arn:aws:lambda:us-west-1:901920570463:layer:aws-otel-collector-arm64-ver-0-62-1:1',
            'us-west-2': 'arn:aws:lambda:us-west-2:901920570463:layer:aws-otel-collector-arm64-ver-0-62-1:1',
        },
    },
};
exports.ADOT_LAMBDA_LAYER_ARNS = {
    JAVA_SDK: ADOT_LAMBDA_LAYER_JAVA_SDK_ARNS,
    JAVA_AUTO_INSTRUMENTATION: ADOT_LAMBDA_LAYER_JAVA_AUTO_INSTRUMENTATION_ARNS,
    JAVASCRIPT_SDK: ADOT_LAMBDA_LAYER_JAVASCRIPT_SDK_ARNS,
    PYTHON_SDK: ADOT_LAMBDA_LAYER_PYTHON_SDK_ARNS,
    GENERIC: ADOT_LAMBDA_LAYER_GENERIC_ARNS,
};
//# sourceMappingURL=data:application/json;base64,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