"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Default = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Provides default values for certain regional information points.
 */
class Default {
    /**
     * Computes a "standard" AWS Service principal for a given service, region and suffix. This is useful for example when
     * you need to compute a service principal name, but you do not have a synthesize-time region literal available (so
     * all you have is `{ "Ref": "AWS::Region" }`). This way you get the same defaulting behavior that is normally used
     * for built-in data.
     *
     * @param serviceFqn the name of the service (s3, s3.amazonaws.com, ...)
     * @param region    the region in which the service principal is needed.
     * @param urlSuffix deprecated and ignored.
     */
    static servicePrincipal(serviceFqn, region, urlSuffix) {
        // NOTE: this whole method is deprecated, and should not be used or updated anymore. The global service
        // principal is always correct, when referenced from within a region.
        // (As a note, regional principals (`<SERVICE>.<REGION>.amazonaws.com`) are required in
        // case of a cross-region reference to an opt-in region, but that's the only case, and that is not
        // controlled here).
        //
        // (It cannot be actually @deprecated since many of our tests use it :D)
        const serviceName = extractSimpleName(serviceFqn);
        if (!serviceName) {
            // Return "service" if it does not look like any of the following:
            // - s3
            // - s3.amazonaws.com
            // - s3.amazonaws.com.cn
            // - s3.c2s.ic.gov
            // - s3.sc2s.sgov.gov
            return serviceFqn;
        }
        function determineConfiguration(service) {
            function universal(s) { return `${s}.amazonaws.com`; }
            function partitional(s, _, u) { return `${s}.${u}`; }
            function regional(s, r) { return `${s}.${r}.amazonaws.com`; }
            function regionalPartitional(s, r, u) { return `${s}.${r}.${u}`; }
            // Exceptions for Service Principals in us-iso-*
            const US_ISO_EXCEPTIONS = new Set([
                'cloudhsm',
                'config',
                'states',
                'workspaces',
            ]);
            // Account for idiosyncratic Service Principals in `us-iso-*` regions
            if (region.startsWith('us-iso-') && US_ISO_EXCEPTIONS.has(service)) {
                switch (service) {
                    // Services with universal principal
                    case ('states'):
                        return universal;
                    // Services with a partitional principal
                    default:
                        return partitional;
                }
            }
            // Exceptions for Service Principals in us-isob-*
            const US_ISOB_EXCEPTIONS = new Set([
                'dms',
                'states',
            ]);
            // Account for idiosyncratic Service Principals in `us-isob-*` regions
            if (region.startsWith('us-isob-') && US_ISOB_EXCEPTIONS.has(service)) {
                switch (service) {
                    // Services with universal principal
                    case ('states'):
                        return universal;
                    // Services with a partitional principal
                    default:
                        return partitional;
                }
            }
            switch (service) {
                // CodeDeploy is regional+partitional in CN, only regional everywhere else
                case 'codedeploy':
                    return region.startsWith('cn-')
                        ? regionalPartitional
                        // ...except in the isolated regions, where it's universal
                        : (region.startsWith('us-iso') ? universal : regional);
                // Services with a regional AND partitional principal
                case 'logs':
                    return regionalPartitional;
                // Services with a regional principal
                case 'states':
                    return regional;
                case 'elasticmapreduce':
                    return region.startsWith('cn-')
                        ? partitional
                        : universal;
                // Services with a universal principal across all regions/partitions (the default case)
                default:
                    return universal;
            }
        }
        ;
        const configuration = determineConfiguration(serviceName);
        return configuration(serviceName, region, urlSuffix);
    }
    constructor() { }
}
exports.Default = Default;
_a = JSII_RTTI_SYMBOL_1;
Default[_a] = { fqn: "@aws-cdk/region-info.Default", version: "2.97.0" };
/**
 * The default value for a VPC Endpoint Service name prefix, useful if you do
 * not have a synthesize-time region literal available (all you have is
 * `{ "Ref": "AWS::Region" }`)
 */
Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX = 'com.amazonaws.vpce';
function extractSimpleName(serviceFqn) {
    const matches = serviceFqn.match(/^([^.]+)(?:(?:\.amazonaws\.com(?:\.cn)?)|(?:\.c2s\.ic\.gov)|(?:\.sc2s\.sgov\.gov))?$/);
    return matches ? matches[1] : undefined;
}
//# sourceMappingURL=data:application/json;base64,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