import * as ec2 from '@aws-cdk/aws-ec2';
import * as iam from '@aws-cdk/aws-iam';
import * as cdk from '@aws-cdk/core';
import { ManagedInstanceRole } from '@renovosolutions/cdk-library-managed-instance-role';
export interface InstanceServiceProps {
    /**
     * The name of the service this instance service will host
     */
    readonly name: string;
    /**
     * The VPC to launch this service in
     */
    readonly vpc: ec2.Vpc;
    /**
     * The subnet type to launch this service in
     *
     *
     * @default ec2.SubnetType.PRIVATE
     */
    readonly subnetType?: ec2.SubnetType;
    /**
     * The Amazon Machine Image (AMI) to launch the target instance with
     */
    readonly ami: ec2.IMachineImage;
    /**
     * Whether or not to enable logging to Cloudwatch Logs
     *
     *
     * @default true
     */
    readonly enableCloudwatchLogs?: boolean;
    /**
     * Allow all outbound traffic for the instances security group
     *
     *
     * @default true
     */
    readonly allowAllOutbound?: boolean;
    /**
     * Whether to disable inline ingress and egress rule optimization for the instances security group.
     *
     * If this is set to true, ingress and egress rules will not be declared under the SecurityGroup in cloudformation, but will be separate elements.
     *
     * Inlining rules is an optimization for producing smaller stack templates.
     * Sometimes this is not desirable, for example when security group access is managed via tags.
     *
     * The default value can be overriden globally by setting the context variable '@aws-cdk/aws-ec2.securityGroupDisableInlineRules'.
     *
     *
     * @default false
     */
    readonly disableInlineRules?: boolean;
    /**
     * Whether or not to prevent security group from containing rules that allow access to remote management ports:
     * SSH, RDP, WinRM, WinRM over HTTPs
     *
     * If these ports are opened when this is enabled an error will be added to CDK metadata and deployment and synth will fail.
     *
     *
     * @default true
     */
    readonly enableNoRemoteManagementPortsAspect?: boolean;
    /**
     * Whether or not to prevent security group from containing rules that allow access to relational DB ports:
     * MySQL, PostgreSQL, MariaDB, Oracle, SQL Server
     *
     * If these ports are opened when this is enabled an error will be added to CDK metadata and deployment and synth will fail.
     *
     *
     * @default true
     */
    readonly enableNoDBPortsAspect?: boolean;
    /**
     * Whether or not to prevent security group from containing rules that allow access from the public internet:
     * Any rule with a source from 0.0.0.0/0 or ::/0
     *
     * If these sources are used when this is enabled and error will be added to CDK metadata and deployment and synth will fail.
     */
    readonly enabledNoPublicIngressAspect?: boolean;
}
export interface ManagedLoggingPolicyProps {
    /**
     * The OS of the instance this policy is for.
     */
    readonly os: string;
}
export interface AmiLookup {
    /**
     * The name string to use for AMI lookup
     */
    readonly name: string;
    /**
     * The owners to use for AMI lookup
     */
    readonly owners?: string[];
    /**
     * Is this AMI expected to be windows?
     */
    readonly windows?: boolean;
}
export declare function ec2ImageToOsString(stack: cdk.Construct, image: ec2.IMachineImage): string;
export declare class ManagedLoggingPolicy extends cdk.Construct {
    readonly policy: iam.ManagedPolicy;
    constructor(scope: cdk.Construct, id: string, props: ManagedLoggingPolicyProps);
}
export declare class InstanceService extends cdk.Construct {
    readonly instanceProfile: ManagedInstanceRole;
    readonly securityGroup: ec2.SecurityGroup;
    constructor(scope: cdk.Construct, id: string, props: InstanceServiceProps);
}
