"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceService = exports.ManagedLoggingPolicy = exports.ec2ImageToOsString = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const cdk_aspects_library_security_group_1 = require("@renovosolutions/cdk-aspects-library-security-group");
const cdk_library_managed_instance_role_1 = require("@renovosolutions/cdk-library-managed-instance-role");
function ec2ImageToOsString(stack, image) {
    return ec2.OperatingSystemType[image.getImage(stack).osType].toLowerCase();
}
exports.ec2ImageToOsString = ec2ImageToOsString;
class ManagedLoggingPolicy extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (!(props.os.toLowerCase() == 'windows') && !(props.os.toLowerCase() == 'linux')) {
            throw new Error(`The os property for ManagedLoggingPolicy must be windows or linux and you gave: ${props.os.toLowerCase()}`);
        }
        let logResources = [];
        const logGroups = [
            `/${props.os}/logs`,
            `/${props.os}/logs/*`,
        ];
        logGroups.forEach((g) => {
            logResources.push(`arn:aws:logs:${cdk.Stack.of(this).region}:${cdk.Stack.of(this).account}:log-group:${g}`);
        });
        this.policy = new iam.ManagedPolicy(this, 'loggingPolicy', {
            description: 'Allow instance to log system logs to Cloudwatch',
            statements: [
                new iam.PolicyStatement({
                    effect: iam.Effect.ALLOW,
                    actions: [
                        'logs:PutLogEvents',
                        'logs:CreateLogGroup',
                        'logs:CreateLogStream',
                    ],
                    resources: logResources,
                }),
            ],
        });
    }
}
exports.ManagedLoggingPolicy = ManagedLoggingPolicy;
_a = JSII_RTTI_SYMBOL_1;
ManagedLoggingPolicy[_a] = { fqn: "@renovosolutions/cdk-library-renovo-instance-service.ManagedLoggingPolicy", version: "1.0.325" };
class InstanceService extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        let enableNoRemoteManagementPortsAspect = props.enableNoRemoteManagementPortsAspect ?? true;
        let enableNoDBPortsAspect = props.enableNoDBPortsAspect ?? true;
        let enabledNoPublicIngressAspect = props.enabledNoPublicIngressAspect ?? true;
        if (enableNoRemoteManagementPortsAspect)
            cdk.Aspects.of(this).add(new cdk_aspects_library_security_group_1.NoIngressCommonManagementPortsAspect());
        if (enableNoDBPortsAspect)
            cdk.Aspects.of(this).add(new cdk_aspects_library_security_group_1.NoIngressCommonRelationalDBPortsAspect());
        if (enabledNoPublicIngressAspect)
            cdk.Aspects.of(this).add(new cdk_aspects_library_security_group_1.NoPublicIngressAspect());
        let managedPolicies = [];
        // Logging configuration
        let enableCloudwatchLogs = (props.enableCloudwatchLogs === undefined) ? true : props.enableCloudwatchLogs;
        if (enableCloudwatchLogs) {
            managedPolicies.push(new ManagedLoggingPolicy(this, 'loggingPolicy', {
                os: ec2ImageToOsString(this, props.ami),
            }).policy);
        }
        this.instanceProfile = new cdk_library_managed_instance_role_1.ManagedInstanceRole(this, 'instanceRole', {
            domainJoinEnabled: false,
            ssmManagementEnabled: true,
            managedPolicies,
        });
        let allowAllOutbound = (props.allowAllOutbound === undefined) ? true : props.allowAllOutbound;
        let disableInlineRules = (props.disableInlineRules === undefined) ? false : props.disableInlineRules;
        this.securityGroup = new ec2.SecurityGroup(this, 'securityGroup', {
            allowAllOutbound: allowAllOutbound,
            vpc: props.vpc,
            description: `The security group applied to the instance service for ${props.name}`,
            disableInlineRules: disableInlineRules,
        });
    }
}
exports.InstanceService = InstanceService;
_b = JSII_RTTI_SYMBOL_1;
InstanceService[_b] = { fqn: "@renovosolutions/cdk-library-renovo-instance-service.InstanceService", version: "1.0.325" };
//# sourceMappingURL=data:application/json;base64,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