# LNbits Funding Sources Comparison Table

LNbits can use a number of different Lightning Network funding source.

There may be trade-offs between the funding sources used, for example funding LNbits using Strike requires the user to KYC themselves and has some
privacy compromises versus running your own LND node. However the technical barrier to entry of using Strike is lower than using LND.

The table below offers a comparison of the different Lightning Network funding sources that can be used with LNbits.

## LNbits Lightning Network Funding Sources Comparison Table

| **Funding Source**         | **Custodial Type** | **KYC Required**    | **Technical Knowledge Needed** | **Node Hosting Required** | **Privacy Level** | **Liquidity Management** | **Ease of Setup** | **Maintenance Effort** | **Cost Implications**                        | **Scalability** | **Notes**                                                        |
| -------------------------- | ------------------ | ------------------- | ------------------------------ | ------------------------- | ----------------- | ------------------------ | ----------------- | ---------------------- | -------------------------------------------- | --------------- | ---------------------------------------------------------------- |
| LND (gRPC)                 | Self-custodial     | ❌                  | Higher                         | ✅                        | High              | Manual                   | Moderate          | High                   | Infrastructure cost and channel opening fees | High            | gRPC interface for LND; suitable for advanced integrations.      |
| CoreLightning (CLN)        | Self-custodial     | ❌                  | Higher                         | ✅                        | High              | Manual                   | Moderate          | High                   | Infrastructure cost and channel opening fees | High            | Requires setting up and managing your own CLN node.              |
| Phoenixd                   | Self-custodial     | ❌                  | Medium                         | ❌                        | Medium            | Automatic                | Moderate          | Low                    | Minimal fees                                 | Medium          | Mobile wallet backend; suitable for mobile integrations.         |
| Nostr Wallet Connect (NWC) | Custodial          | Depends on provider | Low                            | ❌                        | Variable          | Provider-managed         | Easy              | Low                    | May incur fees                               | Medium          | Connects via Nostr protocol; depends on provider's policies.     |
| Boltz                      | Self-custodial     | ❌                  | Medium                         | ❌                        | Medium            | Provider-managed         | Moderate          | Moderate               | Minimal fees                                 | Medium          | Uses submarine swaps; connects to Boltz client.                  |
| LND (REST)                 | Self-custodial     | ❌                  | Higher                         | ✅                        | High              | Manual                   | Moderate          | High                   | Infrastructure cost and channel opening fees | High            | REST interface for LND; suitable for web integrations.           |
| CoreLightning REST         | Self-custodial     | ❌                  | Higher                         | ✅                        | High              | Manual                   | Moderate          | High                   | Infrastructure cost and channel opening fees | High            | REST interface for CLN; suitable for web integrations.           |
| LNbits (another instance)  | Custodial          | Depends on host     | Low                            | ❌                        | Variable          | Provider-managed         | Easy              | Low                    | May incur hosting fees                       | Medium          | Connects to another LNbits instance; depends on host's policies. |
| Alby                       | Custodial          | ✅                  | Low                            | ❌                        | Low               | Provider-managed         | Easy              | Low                    | Transaction fees apply                       | Medium          | Browser extension wallet; suitable for web users.                |
| Breez SDK                  | Self-custodial     | ❌                  | Medium                         | ❌                        | High              | Automatic                | Moderate          | Low                    | Minimal fees                                 | Medium          | SDK for integrating Breez wallet functionalities.                |
| OpenNode                   | Custodial          | ✅                  | Low                            | ❌                        | Low               | Provider-managed         | Easy              | Low                    | Transaction fees apply                       | Medium          | Third-party service; suitable for merchants.                     |
| Blink                      | Custodial          | ✅                  | Low                            | ❌                        | Low               | Provider-managed         | Easy              | Low                    | Transaction fees apply                       | Medium          | Third-party service; focuses on mobile integrations.             |
| ZBD                        | Custodial          | ✅                  | Low                            | ❌                        | Low               | Provider-managed         | Easy              | Low                    | Transaction fees apply                       | Medium          | Gaming-focused payment platform.                                 |
| Spark (CLN)                | Self-custodial     | ❌                  | Higher                         | ✅                        | High              | Manual                   | Moderate          | High                   | Infrastructure cost and channel opening fees | High            | Web interface for CLN; requires Spark server setup.              |
| Cliche Wallet              | Self-custodial     | ❌                  | Medium                         | ❌                        | Medium            | Manual                   | Moderate          | Moderate               | Minimal fees                                 | Medium          | Lightweight wallet; suitable for embedded systems.               |
| Strike                     | Custodial          | ✅                  | Low                            | ❌                        | Low               | Provider-managed         | Easy              | Low                    | Transaction fees apply                       | Medium          | Third-party service; suitable for quick setups.                  |
| LNPay                      | Custodial          | ✅                  | Low                            | ❌                        | Low               | Provider-managed         | Easy              | Low                    | Transaction fees apply                       | Medium          | Third-party service; suitable for quick setups.                  |
