

[![Serial](https://img.shields.io/badge/-ssh,serial,tty-grey?logo=gnometerminal&logoColor=white)](https://ceccopierangiolieugenio.github.io/pyTermTk-Docs/info/features/crosscompatible.html)
[![Linux](https://img.shields.io/badge/-Linux-grey?logo=linux&logoColor=white)](https://ceccopierangiolieugenio.github.io/pyTermTk-Docs/info/features/crosscompatible.html)
[![Windows](https://img.shields.io/badge/-Windows-grey?logo=pcgamingwiki&logoColor=white)](https://ceccopierangiolieugenio.github.io/pyTermTk-Docs/info/features/crosscompatible.html)
[![OSX](https://img.shields.io/badge/-OSX-grey?logo=apple&logoColor=white)](https://ceccopierangiolieugenio.github.io/pyTermTk-Docs/info/features/crosscompatible.html)
[![HTML5](https://img.shields.io/badge/-HTML5-grey?logo=html5)](https://ceccopierangiolieugenio.github.io/pyTermTk-Docs/info/features/crosscompatible.html)

[![Python](https://img.shields.io/badge/Python-v3.9%5E-green?logo=python)](https://devguide.python.org/versions/)
[![Test Status](https://img.shields.io/github/actions/workflow/status/ceccopierangiolieugenio/pyTermTk/testing.yml?branch=main&label=tests)](https://github.com/ceccopierangiolieugenio/pyTermTk/actions?query=workflow%3Atesting)
[![pyTermTk_version](https://img.shields.io/github/v/tag/ceccopierangiolieugenio/pyTermTk?label=version)](https://github.com/ceccopierangiolieugenio/pyTermTk/releases)
[![pypi_version](https://img.shields.io/pypi/v/pyTermTk?label=pypi)](https://pypi.org/project/pyTermTk)
[![Usage](https://img.shields.io/badge/Usage-Terminal%20User%20Interface-yellow)](https://ceccopierangiolieugenio.github.io/pyTermTk-Docs/)

![hero](https://ceccopierangiolieugenio.github.io/binaryRepo/pyTermTk/images/pyTermTk.HERO.1000.png)

[![pypi_version](https://img.shields.io/badge/Twitter-pyTermTk-blue?logo=x&logoColor=blue)](https://twitter.com/hashtag/pyTermTk?src=hashtag_click&f=live)
[![Static Badge](https://img.shields.io/badge/BlyeSky-pyTermTk-blue?logo=bluesky&logoColor=blue)](https://bsky.app/profile/piercecco.bsky.social)
[![Static Badge](https://img.shields.io/badge/Discord-pyTermTk-8A2BE2?logo=discord&logoColor=blue)](https://discord.gg/7E5DZdbw)


## [pyTermTk](https://github.com/ceccopierangiolieugenio/pyTermTk)

(**py**thon **Term**inal **T**ool**k**it) is a Text-based user interface library ([TUI](https://en.wikipedia.org/wiki/Text-based_user_interface))
Evolved from the discontinued project [pyCuT](https://github.com/ceccopierangiolieugenio/pyCuT)
and inspired by a mix of [Qt5](https://www.riverbankcomputing.com/static/Docs/PyQt5/),[GTK](https://pygobject.readthedocs.io/en/latest/), and [tkinter](https://docs.python.org/3/library/tkinter.html) api definition with a touch of personal interpretation

https://github.com/user-attachments/assets/888e745a-ea00-4d03-b6ec-273319d54ea7

## [Features](https://ceccopierangiolieugenio.github.io/pyTermTk-Docs/info/features/index.html)
- [Self Contained](https://ceccopierangiolieugenio.github.io/pyTermTk-Docs/info/installing.html#copy-termtk-folder) (no external lib required), Python 3.9 or above required.
- [Cross compatible](https://ceccopierangiolieugenio.github.io/pyTermTk-Docs/info/features/crosscompatible.html): [Linux](https://en.wikipedia.org/wiki/Linux)🐧, [MacOS](https://en.wikipedia.org/wiki/MacOS)🍎, [MS Windows](https://en.wikipedia.org/wiki/Microsoft_Windows)🪟, [HTML5](https://en.wikipedia.org/wiki/HTML5)🌍([Try](https://ceccopierangiolieugenio.github.io/pyTermTk-Docs/sandbox/sandbox.html))
- [Basic widgets](https://ceccopierangiolieugenio.github.io/pyTermTk-Docs/info/features/widgets.html#base-widgets) for [TUI](https://en.wikipedia.org/wiki/Text-based_user_interface) development (Button, Label, checkbox, ...)
- [Specialized widgets](https://ceccopierangiolieugenio.github.io/pyTermTk-Docs/info/features/widgets.html#specialised-widgets) to improve the usability (Windows, Frames, Tables, ...)
- QT Like Layout system to help arrange the widgets in the terminal
- True color support
- Ful/Half/Zero sized Unicode characters 😎
- I am pretty sure there is [something else...](https://ceccopierangiolieugenio.github.io/pyTermTk-Docs/info/features/index.html)

---

## Try the [Sandbox](https://ceccopierangiolieugenio.github.io/pyTermTk-Docs/sandbox/sandbox.html) straight from your browser

[![SandBox](https://user-images.githubusercontent.com/8876552/206438915-fdc868b1-32e0-46e8-9e2c-e29f4a7a0e75.png)](https://ceccopierangiolieugenio.github.io/pyTermTk-Docs/sandbox/sandbox.html)

Powered by [Pyodide](https://pyodide.org/) and [xterm.js](https://xtermjs.org/) and [CodeMirror5](https://codemirror.net/5/) and [w2ui](https://w2ui.com/)

---

## [the Tutorials](https://github.com/ceccopierangiolieugenio/pyTermTk/tree/main/tutorial) and [the Examples](https://github.com/ceccopierangiolieugenio/pyTermTk/tree/main/tutorial/000-examples.rst)
Be inspired by [the Tutorials](https://github.com/ceccopierangiolieugenio/pyTermTk/tree/main/tutorial) and [the Examples](https://github.com/ceccopierangiolieugenio/pyTermTk/tree/main/tutorial/000-examples.rst)

## [Api Definitions](https://ceccopierangiolieugenio.github.io/pyTermTk-Docs/index.html#api-reference)
Don't get bored by the [Api Definitions](https://ceccopierangiolieugenio.github.io/pyTermTk-Docs/index.html#api-reference)

## [ttkode](https://github.com/ceccopierangiolieugenio/pyTermTk/tree/main/apps/ttkode)
Burn your fingers with the Terminal Studio Kode

## [ttkDesigner](https://github.com/ceccopierangiolieugenio/pyTermTk/tree/main/apps/ttkDesigner)
Smell deliciousness with the official [pyTermTk](https://github.com/ceccopierangiolieugenio/pyTermTk) tool for designing and building Text-based user interfaces ([TUI](https://en.wikipedia.org/wiki/Text-based_user_interface)s)

## [theDumbPaintTool](https://github.com/ceccopierangiolieugenio/pyTermTk/tree/main/apps/dumbPaintTool)
Unravel your inner artist with [The Terminal ASCII Photoshop](https://ceccopierangiolieugenio.itch.io/dumb-paint-tool)

---

## [Install/Upgrade](https://ceccopierangiolieugenio.github.io/pyTermTk-Docs/info/installing.html)
[pyTermTk](https://github.com/ceccopierangiolieugenio/pyTermTk) is available on [PyPI](https://pypi.org/project/pyTermTk/)
```bash
pip3 install --upgrade pyTermTk
```

## Quick Test/Try - no install required

#### Clone
```bash
git clone https://github.com/ceccopierangiolieugenio/pyTermTk.git
cd pyTermTk
```

#### Demos
```bash
# Press CTRL-C to exit (CTRL-Break on Windows)

# Showcase Demo
python3 demo/demo.py -f -t

# run the ttkDesigner
run.ttkDesigner.sh

# run The Dumb Paint Tool
# it require pillow
#   pip install pillow
run.dumbPaintTool.sh

# Text edit with "Pygments" highlight integrated
# it require pygments
#   pip install pygments
python3 tests/test.ui.018.TextEdit.Pygments.py README.md
```

---

## Projects using [pyTermTk](https://github.com/ceccopierangiolieugenio/pyTermTk)
- [ttkDesigner](https://github.com/ceccopierangiolieugenio/pyTermTk/tree/main/apps/ttkDesigner) - the official [pyTermTk](https://github.com/ceccopierangiolieugenio/pyTermTk) tool for designing and building Text-based user interfaces ([TUI](https://en.wikipedia.org/wiki/Text-based_user_interface)s)
- [the DumbPaintTool](https://ceccopierangiolieugenio.itch.io/dumb-paint-tool) - The Terminal ASCII Photoshop
- [tlogg](https://github.com/ceccopierangiolieugenio/tlogg) - A fast, advanced log explorer.
- [ttkode](https://github.com/ceccopierangiolieugenio/ttkode) - TerminalToolKit (Studio) Code (editor)
- [pytest-fold](https://github.com/jeffwright13/pytest-fold) - A Pytest plugin to make console output more manageable when there are multiple failed tests
- [pytest-tui](https://github.com/jeffwright13/pytest-tui) - A Text User Interface (TUI) for Pytest, automatically launched after your test run is finished
- [breakoutRL](https://ceccopierangiolieugenio.itch.io/breakoutrl) - Breakout the Roguelike
- [7drl-2024](https://ceccopierangiolieugenio.itch.io/a-snake-on-a-plane) - A Snake🐍 on a Plane✈️ - The Roguelike

## Related Projects
- Honourable mention
  - [bpytop](https://github.com/aristocratos/bpytop) - Linux/OSX/FreeBSD resource monitor <br>
    This was the base inspiration for my core library

- Python
  - [urwid](https://github.com/urwid/urwid) - Console user interface library for Python
  - [pyTermGUI](https://github.com/bczsalba/pytermgui) - A simple yet powerful TUI framework for your Python (3.7+) applications
  - [Textual](https://github.com/Textualize/textual) - TUI (Text User Interface) framework for Python inspired by modern web development
  - [Rich](https://github.com/Textualize/rich) - Python library for rich text and beautiful formatting in the terminal
  - [PyCuT](https://github.com/ceccopierangiolieugenio/pyCuT) - terminal graphic library loosely based on QT api (my previous failed attempt)
  - [pyTooling.TerminalUI](https://github.com/pyTooling/pyTooling.TerminalUI) - A set of helpers to implement a text user interface (TUI) in a terminal.

- Non Python
  - [Turbo Vision](http://tvision.sourceforge.net)
  - [ncurses](https://en.wikipedia.org/wiki/Ncurses)
  - [tui.el](https://github.com/ebpa/tui.el) - An experimental text-based UI framework for Emacs modeled after React
