from typing import Protocol, Any, List, Tuple, Optional


class EspressoInputAdapter(Protocol):
    async def poll(self) -> Any: ...

    async def poll_all(self) -> List[Any]: ...

    async def poll_batch(self, batch_size: int) -> Tuple[List[Any], Optional[str]]: ...

    async def has_data(self) -> bool: ...

    async def ack(self, item: Any) -> None: ...

    async def nack(self, item: Any) -> None: ...

    def append_item(self, item: Any) -> None: ...

    def append_items(self, items: List[Any]) -> None: ...
