# generated by datamodel-codegen:
#   filename:  sae_eval.yaml

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Field


class NPSaeEval(BaseModel):
    id: str = Field(..., description='ID of the SAE Eval')
    typeName: str = Field(..., description='SAE Eval Type - should equal the "name" property of NPSaeEvalType')
    modelId: str = Field(..., description='The model ID of the SAE being evaluated')
    sourceId: str = Field(..., description='The source ID of the SAE being evaluated')
    output: str = Field(
        ...,
        description='The output data, matching the outputSchema of the NPSaeEvalType, with the exception of eval_result_details, which will go under detailedMetrics',
    )
    detailedMetrics: Optional[str] = Field(
        None,
        description='The eval_result_details of the output data. Kept in a separate field/column due to large size.',
    )


class NPSaeEvalType(BaseModel):
    name: str = Field(..., description='ID of the Eval Type')
    displayName: str = Field(..., description='A UI-friendly display name of the eval type')
    description: str = Field(..., description='A brief description of the eval')
    outputSchema: str = Field(
        ...,
        description='JSON output schema used to parse the eval output results. From the SAEBench repo - for example https://github.com/adamkarvonen/SAEBench/blob/main/sae_bench/evals/autointerp/eval_output_schema_autointerp.json',
    )
    url: Optional[str] = Field(None, description='URL to the eval')
    evals: Optional[List[NPSaeEval]] = Field(None, description='The actual eval results of this type')


class NPSaeEvalListRequest(BaseModel):
    pass


class NPSaeEvalListResponse(BaseModel):
    evalTypes: Optional[List[NPSaeEvalType]] = Field(None, description='List of SAE eval types and their results')
