# P4 Code Review Rules - Code Style (Low)

**Priority Level:** P4 (Low)
**Focus:** Code style and formatting

## 1. Formatting Standards

- Code is formatted with Ruff (`ruff format .`)
- All linting issues resolved (`ruff check --fix .`)
- Consistent indentation and spacing
- Proper line length (120 characters max)
- Import organization follows standards

## 2. Code Style

- Follows PEP 8 guidelines
- Consistent naming conventions (snake_case)
- Type hints where appropriate
- Google-style docstring format
- Clear and concise comments

## 3. Git Best Practices

- Meaningful commit messages
- Logical commit organization
- No unnecessary files in commits
- Proper branch naming conventions

## Review Guidelines

**Formatting Checklist:**
- [ ] Code formatted with Ruff
- [ ] No linting issues
- [ ] Consistent indentation
- [ ] Line length under 120 chars
- [ ] Imports organized properly

**Code Style Checklist:**
- [ ] Follows PEP 8
- [ ] Consistent naming (snake_case)
- [ ] Type hints present
- [ ] Google-style docstrings
- [ ] Clear comments

**Git Checklist:**
- [ ] Meaningful commit messages
- [ ] Logical commit structure
- [ ] No unnecessary files
- [ ] Proper branch naming