# Jovian: The platform for all your Data Science projects

![](/docs/jvn_full_logo.png)

jovian is an open-source Python package integrated with [Jovian](https://jovian.ml/?utm_source=github) to provide the tools necessary for Data Scientists and ML/DL Engineers to **Track**, **Collaborate** and **Automate** projects where even Students and Enthusiasts can leverage the same and also use [Jovian](https://jovian.ml/?utm_source=github) **Share** and **Showcase** their projects.

- [Upload and share Jupyter Notebooks](https://jovian-py.readthedocs.io/en/latest/user-guide/02-upload.html)
- [Reproduce Notebooks from Jovian](https://jovian-py.readthedocs.io/en/latest/user-guide/03-reproduce.html)
- [Notebooks as version, view Diffs between versions](https://jovian-py.readthedocs.io/en/latest/user-guide/04-version.html)
- [Attaching utility files and model outputs with the Notebook](https://jovian-py.readthedocs.io/en/latest/user-guide/05-attach.html)
- [Tracking Datasets, Hyperparameters and Metrics](https://jovian-py.readthedocs.io/en/latest/user-guide/06-track.html)
- [Comparing and Analyzing all the experiments](https://jovian-py.readthedocs.io/en/latest/user-guide/07-compare.html)
- [Collaborate with teammates/colleagues](https://jovian-py.readthedocs.io/en/latest/user-guide/08-collaborate.html)
- [Stay connected with your model training, live updates with Slack Notifications](https://jovian-py.readthedocs.io/en/latest/jvn/notif.html)

[![Documentation Status](https://readthedocs.org/projects/jovian-py/badge/?version=latest)](https://jovian-py.readthedocs.io/en/latest/?badge=latest)

## Installation

```
pip install jovian --upgrade
```

> **Caution**:
>
> If you get a `Permission denied` error, try installing with sudo permission (on Linux/Mac).
>
> ```
> sudo pip install jovian --upgrade
> ```
>
> Another alternative is to try installing with the `--user` flag, but you’ll need to ensure that the target directory is added to your system `PATH`.
>
> ```
> pip install jovian --upgrade --user
> ```

Visit [Docs](https://jovian-py.readthedocs.io) for more.

## Contribution Guidelines

If you want to contribute to **jovian**(Python package), review the [**Contribution Page**](https://github.com/JovianML/jovian-py/blob/master/CONTRIBUTING.md).

<table>
    <tr>
        <th> </th>
        <th>jovian(Python Package)</th>
        <th>Jovian(Webapp)</th>
    </tr>
    <tr>
        <td>Issues or Feature Request</td>
        <td align="center"> <a href="https://github.com/JovianML/jovian-py/issues">Forum</a> </td>
        <td align="center"> <a href="https://github.com/JovianML/jovian-support/issues">Forum</a> </td>
    </tr>
    <tr>
        <td>Repository and Website</td>
        <td align="center"> <a href="https://github.com/JovianML">Repo</a> </td>
        <td align="center"> <a href="https://jovian.ml/?utm_source=github">Website</a> </td>
    </tr>
    <tr>
        <td>Slack Discussions</td>
        <td align="center" colspan=2> <a href="https://bit.ly/jovian-users">Slack Invite</a> </td>
    </tr>
</table>

## Contact

Mail : hello@jovian.ml
<br>
Twitter : [@JovianML](https://twitter.com/JovianML)
<br>
Slack : [Slack Invite](https://bit.ly/jovian-users)
